//******************************************************************************
/**
 *
 * @file	fieldobj_draw.c
 * @brief	tB[hOBJ `n
 * @author	kagaya
 * @data	05.07.25
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "fieldobj.h"
#include "field_effect.h"

//==============================================================================
//	define
//==============================================================================

//==============================================================================
//	vg^Cv
//==============================================================================

//==============================================================================
//	tB[hOBJ `揈
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hOBJ`
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_Draw( FIELD_OBJ_PTR fldobj )
{
	CONST_FIELD_OBJ_SYS_PTR fos;
	
	fos = FieldOBJ_FieldOBJSysGet( fldobj );
	
	if( FieldOBJSys_DrawInitCompCheck(fos) == FALSE ){
		return;
	}
	
	if( FieldOBJSys_StatusBit_Check(fos,FLDOBJSYS_STA_BIT_DRAW_PROC_STOP) ){
		return;
	}
	
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_DRAW_PROC_INIT_COMP) ){
		FieldOBJ_DrawProcCall( fldobj );
	}
}

//==============================================================================
//	p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hOBJ `|[Y`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=`|[Y
 */
//--------------------------------------------------------------
int FieldOBJ_DrawPauseCheck( CONST_FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_MovePauseCheck(fldobj) == TRUE ){
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_ACMD) == FALSE ){
			return( TRUE );
		}
	}
	
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_PAUSE_ANM) ){
		return( TRUE );
	}
	
	return( FALSE );
}

//==============================================================================
//	`斳
//==============================================================================
//--------------------------------------------------------------
/**
 * `斳@
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawNon_Init( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_StatusBitSet_Vanish( fldobj, TRUE );
	FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_SHADOW_VANISH );
}

//--------------------------------------------------------------
/**
 * `斳@`
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawNon_Draw( FIELD_OBJ_PTR fldobj )
{
}

//--------------------------------------------------------------
/**
 * `斳@폜
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawNon_Delete( FIELD_OBJ_PTR fldobj )
{
}

//--------------------------------------------------------------
/**
 * `斳@ޔ
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	int			TRUE=
 */
//--------------------------------------------------------------
void FieldOBJ_DrawNon_Push( FIELD_OBJ_PTR fldobj )
{
}

//--------------------------------------------------------------
/**
 * `斳@A
 * ޔɍĕ`B
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	int			TRUE=
 */
//--------------------------------------------------------------
void FieldOBJ_DrawNon_Pop( FIELD_OBJ_PTR fldobj )
{
}

