//******************************************************************************
/**
 *
 * @file	fieldobj_draw_0.c
 * @brief	tB[hOBJ {`n0
 * @author	kagaya
 * @data	05.07.25
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "fieldobj.h"

#include "field_effect.h"

//==============================================================================
//	define
//==============================================================================

//==============================================================================
//	typedef
//==============================================================================
//--------------------------------------------------------------
///	BLACT00_WORK\
//--------------------------------------------------------------
typedef struct
{
	s16 old_dir;
	s16 frame;
	int old_state;
	BLACT_WORK_PTR act;
	FIELD_OBJ_BLACTANM_PUSH act_push;
}BLACT00_WORK;

#define BLACT00_WORK_SIZE (sizeof(BLACT00_WORK))

//--------------------------------------------------------------
///	MODEL00_WORK\
//--------------------------------------------------------------
typedef struct
{
	EOA_PTR eoa;
}MODEL00_WORK;

#define MODEL00_WORK_SIZE (sizeof(MODEL00_WORK))

//==============================================================================
//	vg^Cv
//==============================================================================
void FieldOBJ_DrawBlAct00_Init( FIELD_OBJ_PTR fldobj );
void FieldOBJ_DrawBlAct00_Delete( FIELD_OBJ_PTR fldobj );
void FieldOBJ_DrawBlAct00_Push( FIELD_OBJ_PTR fldobj );
void FieldOBJ_DrawBlAct00_Pop( FIELD_OBJ_PTR fldobj );

void FieldOBJ_DrawBlAct00_Draw( FIELD_OBJ_PTR fldobj );
void FieldOBJ_DrawBlAct00AnmNon_Draw( FIELD_OBJ_PTR fldobj );

static void DrawBlAct00Draw_STA_STOP(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir );
static void DrawBlAct00Draw_STA_WALK_32F_16F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir );
static void DrawBlAct00Draw_STA_WALK_8F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir );
static void DrawBlAct00Draw_STA_WALK_4F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir );
static void DrawBlAct00Draw_STA_WALK_2F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir );
static void DrawBlAct00Draw_STA_WALK_6F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir );
static void DrawBlAct00Draw_STA_WALK_3F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir );

void (* const DATA_DrawBlAct00_DrawTbl[])(
		FIELD_OBJ_PTR, BLACT_WORK_PTR, BLACT00_WORK *, int );

static void DrawBlActHeroDraw_STA_DASH_4F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir );

void (* const DATA_DrawBlActHero_DrawTbl[])(
		FIELD_OBJ_PTR, BLACT_WORK_PTR, BLACT00_WORK *, int );

static void DrawBlActHeroDraw_STA_TAKE_OFF_16F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir );
static void DrawBlActHeroDraw_STA_TAKE_OFF_8F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir );

void (* const DATA_DrawBlActHeroCycle_DrawTbl[])(
		FIELD_OBJ_PTR, BLACT_WORK_PTR, BLACT00_WORK *, int );

void FieldOBJ_DrawModel00_Init( FIELD_OBJ_PTR fldobj );
void FieldOBJ_DrawModel00_Draw( FIELD_OBJ_PTR fldobj );
void FieldOBJ_DrawModel00_Delete( FIELD_OBJ_PTR fldobj );
void FieldOBJ_DrawModel00_Push( FIELD_OBJ_PTR fldobj );
void FieldOBJ_DrawModel00_Pop( FIELD_OBJ_PTR fldobj );

static void FldOBJ_BlActAnmFrameStopSet( BLACT_WORK_PTR act );

//==============================================================================
//	BlAct00
//==============================================================================
//--------------------------------------------------------------
/**
 * r{[hAN^[|C^擾
 * @param
 * @retval
 */
//--------------------------------------------------------------
BLACT_WORK_PTR FieldOBJ_DrawBlAct00_BlActPtrGet( FIELD_OBJ_PTR fldobj )
{
	BLACT00_WORK *work;
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	return( work->act );
}

//--------------------------------------------------------------
/**
 * BlAct00 B
 * `ׂ̈̏sB
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawBlAct00_Init( FIELD_OBJ_PTR fldobj )
{
	BLACT00_WORK *work;
	
	work = FieldOBJ_DrawProcWorkInit( fldobj, BLACT00_WORK_SIZE );
	work->old_dir = DIR_NOT;
	FieldOBJ_BlActAddRegularGuest( fldobj, &work->act );
}

//--------------------------------------------------------------
/**
 * BlAct00 폜֐B
 * `Ŏgpm폜
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawBlAct00_Delete( FIELD_OBJ_PTR fldobj )
{
	BLACT00_WORK *work;
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	
	if( work->act != NULL ){
		FieldOBJ_BlActDelete( fldobj, work->act );
		work->act = NULL;
	}
}

//--------------------------------------------------------------
/**
 * BlAct00 ޔB
 * `ɕKvȏޔA`Ŏgpm폜
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	int			TRUE=
 */
//--------------------------------------------------------------
void FieldOBJ_DrawBlAct00_Push( FIELD_OBJ_PTR fldobj )
{
	BLACT00_WORK *work;
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	
	if( work->act != NULL ){
		FieldOBJ_BlActAnmPush( work->act, &work->act_push );
		FieldOBJ_BlActDelete( fldobj, work->act );
		work->act = NULL;
		
		FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_DRAW_PUSH );
	}
}

//--------------------------------------------------------------
/**
 * BlAct00 A
 * ޔɍĕ`B
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	int			TRUE=
 */
//--------------------------------------------------------------
void FieldOBJ_DrawBlAct00_Pop( FIELD_OBJ_PTR fldobj )
{
	int ret;
	BLACT00_WORK *work;
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	
	if( FieldOBJ_BlActAddPracFlagCheck(fldobj) == TRUE ){
		return;
	}
	
	if( work->act == NULL ){
		FieldOBJ_BlActAddRegularGuest( fldobj, &work->act );
	}
	
	if( work->act != NULL ){
		FieldOBJ_BlActAnmPop( work->act, &work->act_push );
		FieldOBJ_BlActPosSet( fldobj, work->act );
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_DRAW_PUSH );
	}
}

//==============================================================================
//	BlAct00	`
//==============================================================================
//--------------------------------------------------------------
/**
 * BlAct00 `B
 * tB[hOBJ`ɕKvȏ擾A`悷B
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawBlAct00_Draw( FIELD_OBJ_PTR fldobj )
{
	int dir,state;
	BLACT00_WORK *work = FieldOBJ_DrawProcWorkGet( fldobj );
	BLACT_WORK_PTR act = work->act;
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	
	if( FieldOBJ_BlActAddPracFlagCheck(fldobj) == TRUE ){		//ǉ
		return;
	}
	
	if( act == NULL ){
		return;
	}
	
	dir = FieldOBJ_DirDispGet( fldobj );
	state = FieldOBJ_DrawStatusGet( fldobj );
	
	GF_ASSERT( state < DRAW_STA_MAX && "FieldOBJ_DrawBlAct00_Draw()`Xe[^Xُ" );
	DATA_DrawBlAct00_DrawTbl[state]( fldobj, act, work, dir );
	
	work->old_dir = dir;
	FieldOBJ_BlActPosSet( fldobj, act );
	
	{
		int vanish = TRUE;
	
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_VANISH) == TRUE ){
			vanish = FALSE;
		}
	
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_HEIGHT_GET_NOT) == TRUE ){
			if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_HEIGHT_VANISH_OFF) == FALSE){
				vanish = FALSE;
			}
		}
		
		BLACT_ObjDrawFlagSet( act, vanish );
	}
	
	work->old_state = FieldOBJ_DrawStatusGet( fldobj );
}

//--------------------------------------------------------------
/**
 * BlAct00 `BAjȂ
 * tB[hOBJ`ɕKvȏ擾A`悷B
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawBlAct00AnmNon_Draw( FIELD_OBJ_PTR fldobj )
{
	int dir,no;
	BLACT00_WORK *work;
	BLACT_WORK_PTR act;
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	
	if( FieldOBJ_BlActAddPracFlagCheck(fldobj) == TRUE ){
		return;													//ǉ
	}
	
	act = work->act;
	
	if( act == NULL ){
		return;
	}
	
	FieldOBJ_BlActPosSet( fldobj, act );
	
	{
		int vanish;
		
		vanish = TRUE;
	
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_VANISH) == TRUE ){
			vanish = FALSE;
		}
	
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,
					FLDOBJ_STA_BIT_HEIGHT_GET_NOT) == TRUE ){
			if( FieldOBJ_StatusBit_CheckEasy(fldobj,
						FLDOBJ_STA_BIT_HEIGHT_VANISH_OFF) == FALSE ){
				vanish = FALSE;
			}
		}
	
		BLACT_ObjDrawFlagSet( act, vanish );
	}
}

//--------------------------------------------------------------
/**
 * BlAct00 DRAW_STA_STOP
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	act		BLACT_WORK_PTR
 * @param	dir		\DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
static void DrawBlAct00Draw_STA_STOP(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir )
{
	if( dir != work->old_dir ){
		int no = FieldOBJ_BlActAnmOffsNo_DirWalkGet( dir );
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameSetOffs( act, 0 );
	}else{
		FldOBJ_BlActAnmFrameStopSet( act );
	}
}

//--------------------------------------------------------------
/**
 * BlAct00 DRAW_STA_WALK_32F 16F
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	act		BLACT_WORK_PTR
 * @param	work	BLACT00_WORK *
 * @param	dir		\DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
static void DrawBlAct00Draw_STA_WALK_32F_16F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir )
{
	int no = FieldOBJ_BlActAnmOffsNo_DirWalkGet( dir );
	
	if( no != BLACT_AnmOffsGet(act) ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameChg( act, 0 );	//ʔf
	}
	
	if( dir != work->old_dir ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameSetOffs( act, 0 );
	}
		
	if( FieldOBJ_DrawPauseCheck(fldobj) == FALSE ){
		BLACT_AnmFrameChg( act, BLACTANM_FRAME_05 );
	}
}

//--------------------------------------------------------------
/**
 * BlAct00 DRAW_STA_WALK_8F
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	act		BLACT_WORK_PTR
 * @param	work	BLACT00_WORK *
 * @param	dir		\DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
static void DrawBlAct00Draw_STA_WALK_8F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir )
{
	int no = FieldOBJ_BlActAnmOffsNo_DirWalkGet( dir );
	
	if( no != BLACT_AnmOffsGet(act) ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameChg( act, 0 );	//ʔf
	}
	
	if( dir != work->old_dir ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameSetOffs( act, 0 );
	}
	
	if( FieldOBJ_DrawPauseCheck(fldobj) == FALSE ){
		BLACT_AnmFrameChg( act, BLACTANM_FRAME_1 );
	}
}

//--------------------------------------------------------------
/**
 * BlAct00 DRAW_STA_WALK_4F
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	act		BLACT_WORK_PTR
 * @param	work	BLACT00_WORK *
 * @param	dir		\DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
static void DrawBlAct00Draw_STA_WALK_4F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir )
{
	int no = FieldOBJ_BlActAnmOffsNo_DirWalkGet( dir );
	
	if( no != BLACT_AnmOffsGet(act) ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameChg( act, 0 );	//ʔf
	}
	
	if( dir != work->old_dir ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameSetOffs( act, 0 );
	}
		
	if( FieldOBJ_DrawPauseCheck(fldobj) == FALSE ){
		BLACT_AnmFrameChg( act, BLACTANM_FRAME_2 );
	}
}

//--------------------------------------------------------------
/**
 * BlAct00 DRAW_STA_WALK_2F
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	act		BLACT_WORK_PTR
 * @param	work	BLACT00_WORK *
 * @param	dir		\DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
static void DrawBlAct00Draw_STA_WALK_2F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir )
{
	int no = FieldOBJ_BlActAnmOffsNo_DirWalkGet( dir );
	
	if( no != BLACT_AnmOffsGet(act) ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameChg( act, 0 );	//ʔf
	}
	
	if( dir != work->old_dir ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameSetOffs( act, 0 );
	}
		
	if( FieldOBJ_DrawPauseCheck(fldobj) == FALSE ){
		BLACT_AnmFrameChg( act, BLACTANM_FRAME_4 );
	}
}

//--------------------------------------------------------------
/**
 * BlAct00 DRAW_STA_WALK_6F
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	act		BLACT_WORK_PTR
 * @param	work	BLACT00_WORK *
 * @param	dir		\DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
static void DrawBlAct00Draw_STA_WALK_6F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir )
{
	int no = FieldOBJ_BlActAnmOffsNo_DirWalkGet( dir );
	
	if( no != BLACT_AnmOffsGet(act) ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameChg( act, 0 );	//ʔf
	}
	
	if( dir != work->old_dir ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameSetOffs( act, 0 );
		work->frame = 0;
	}
		
	if(	work->old_state != DRAW_STA_WALK_6F ){
		work->frame = 0;
	}
		
	if( FieldOBJ_DrawPauseCheck(fldobj) == FALSE ){
		fx32 tbl[] = {
			BLACTANM_FRAME_1,
			BLACTANM_FRAME_1,
			BLACTANM_FRAME_2,
			BLACTANM_FRAME_1,
			BLACTANM_FRAME_1,
			BLACTANM_FRAME_2, 0 };
				
		BLACT_AnmFrameChg( act, tbl[work->frame] );
		work->frame++;
			
		if( tbl[work->frame] == 0 ){
			work->frame = 0;
		}
	}
}

//--------------------------------------------------------------
/**
 * BlAct00 DRAW_STA_WALK_3F
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	act		BLACT_WORK_PTR
 * @param	work	BLACT00_WORK *
 * @param	dir		\DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
static void DrawBlAct00Draw_STA_WALK_3F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir )
{
	int no = FieldOBJ_BlActAnmOffsNo_DirWalkGet( dir );
	
	if( no != BLACT_AnmOffsGet(act) ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameChg( act, 0 );	//ʔf
	}
	
	if( dir != work->old_dir ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameSetOffs( act, 0 );
		work->frame = 0;
	}
		
	if(	work->old_state != DRAW_STA_WALK_3F ){
		work->frame = 0;
	}
		
	if( FieldOBJ_DrawPauseCheck(fldobj) == FALSE ){
		fx32 tbl[] = {
			BLACTANM_FRAME_3,
			BLACTANM_FRAME_2,
			BLACTANM_FRAME_3, 0 };
			
		BLACT_AnmFrameChg( act, tbl[work->frame] );
		work->frame++;
			
		if( tbl[work->frame] == 0 ){
			work->frame = 0;
		}
	}
}

//--------------------------------------------------------------
///	BlAct00 `e[u
//--------------------------------------------------------------
static void (* const DATA_DrawBlAct00_DrawTbl[])(
		FIELD_OBJ_PTR, BLACT_WORK_PTR, BLACT00_WORK *, int ) =
{
	DrawBlAct00Draw_STA_STOP,
	DrawBlAct00Draw_STA_WALK_32F_16F,
	DrawBlAct00Draw_STA_WALK_32F_16F,
	DrawBlAct00Draw_STA_WALK_8F,
	DrawBlAct00Draw_STA_WALK_4F,
	DrawBlAct00Draw_STA_WALK_2F,
	DrawBlAct00Draw_STA_WALK_6F,
	DrawBlAct00Draw_STA_WALK_3F,
};

//==============================================================================
//	BlActBird
//==============================================================================
//--------------------------------------------------------------
/**
 * BlActBird `B
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawBlActBird_Draw( FIELD_OBJ_PTR fldobj )
{
	int dir,state;
	BLACT00_WORK *work = FieldOBJ_DrawProcWorkGet( fldobj );
	BLACT_WORK_PTR act = work->act;
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	
	if( FieldOBJ_BlActAddPracFlagCheck(fldobj) == TRUE ){		//ǉ
		return;
	}
	
	if( act == NULL ){
		return;
	}
	
	dir = FieldOBJ_DirDispGet( fldobj );
	state = FieldOBJ_DrawStatusGet( fldobj );
	
	switch( state ){
	case DRAW_STA_STOP:
		{
			int no;
			
			if( dir == DIR_UP || dir == DIR_DOWN ){
				no = 0;
			}else{
				no = 1;
			}
			
			BLACT_AnmOffsChg( act, no );
			BLACT_AnmFrameSetOffs( act, 0 );
			BLACT_AnmFrameChg( act, 0 );
		}
		break;
	default:
		{
			int no;
			fx32 frame = 0;
			
			if( dir == DIR_UP || dir == DIR_DOWN ){
				no = 0;
			}else{
				no = 1;
			}
			
			if( BLACT_AnmOffsGet(act) != no ){
				BLACT_AnmOffsChg( act, no );
				BLACT_AnmFrameSetOffs( act, 0 );
			}
			
			BLACT_AnmFrameChg( act, BLACTANM_FRAME_1 );
		}
		
		break;
	}
	
	work->old_dir = dir;
	FieldOBJ_BlActPosSet( fldobj, act );
	
	{
		int vanish = TRUE;
	
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_VANISH) == TRUE ){
			vanish = FALSE;
		}
	
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_HEIGHT_GET_NOT) == TRUE ){
			if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_HEIGHT_VANISH_OFF) == FALSE){
				vanish = FALSE;
			}
		}
		
		BLACT_ObjDrawFlagSet( act, vanish );
	}
	
	work->old_state = FieldOBJ_DrawStatusGet( fldobj );
}

//==============================================================================
//	BlActHero
//==============================================================================
//--------------------------------------------------------------
/**
 * BlActHero B
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawBlActHero_Init( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_DrawBlAct00_Init( fldobj );
}

//--------------------------------------------------------------
/**
 * BlActHero 폜֐B
 * `Ŏgpm폜
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawBlActHero_Delete( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_DrawBlAct00_Delete( fldobj );
}

//--------------------------------------------------------------
/**
 * BlActHero ޔB
 * `ɕKvȏޔA`Ŏgpm폜
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	int			TRUE=
 */
//--------------------------------------------------------------
void FieldOBJ_DrawBlActHero_Push( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_DrawBlAct00_Push( fldobj );
}

//--------------------------------------------------------------
/**
 * BlActHero A
 * ޔɍĕ`B
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	int			TRUE=
 */
//--------------------------------------------------------------
void FieldOBJ_DrawBlActHero_Pop( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_DrawBlAct00_Pop( fldobj );
}

//==============================================================================
//	BlActHero `
//==============================================================================
//--------------------------------------------------------------
/**
 * BlActHero `B
 * tB[hOBJ`ɕKvȏ擾A`悷B
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawBlActHero_Draw( FIELD_OBJ_PTR fldobj )
{
	int dir,state;
	BLACT00_WORK *work = FieldOBJ_DrawProcWorkGet( fldobj );
	BLACT_WORK_PTR act = work->act;
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	
	if( FieldOBJ_BlActAddPracFlagCheck(fldobj) == TRUE ){		//ǉ
		return;
	}
	
	if( act == NULL ){
		return;
	}
	
	dir = FieldOBJ_DirDispGet( fldobj );
	state = FieldOBJ_DrawStatusGet( fldobj );
	
	GF_ASSERT( state < DRAW_STA_MAX_HERO && "FieldOBJ_DrawBlActHero_Draw()`Xe[^Xُ" );
	DATA_DrawBlActHero_DrawTbl[state]( fldobj, act, work, dir );
	
	work->old_dir = dir;
	FieldOBJ_BlActPosSet( fldobj, act );
	
	{
		int vanish = TRUE;
	
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_VANISH) == TRUE ){
			vanish = FALSE;
		}
	
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_HEIGHT_GET_NOT) == TRUE ){
			if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_HEIGHT_VANISH_OFF) == FALSE){
				vanish = FALSE;
			}
		}
		
		BLACT_ObjDrawFlagSet( act, vanish );
	}
	
	work->old_state = FieldOBJ_DrawStatusGet( fldobj );
}

//--------------------------------------------------------------
/**
 * BlActHero DRAW_STA_STOP
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	act		BLACT_WORK_PTR
 * @param	dir		\DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
static void DrawBlActHeroDraw_STA_STOP(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir )
{
	int no = FieldOBJ_BlActAnmOffsNo_DirWalkGet( dir );
	
	if( work->old_state == DRAW_STA_DASH_4F ){
		BLACT_AnmOffsChg( act, no );
		FldOBJ_BlActAnmFrameStopSet( act );
	}else if( dir != work->old_dir ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameSetOffs( act, 0 );
		BLACT_AnmFrameChg( act, 0 );	//ʔf
	}else{
		FldOBJ_BlActAnmFrameStopSet( act );
	}
}

//--------------------------------------------------------------
/**
 * BlActHero DRAW_STA_DASH_4F
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	act		BLACT_WORK_PTR
 * @param	work	BLACT00_WORK *
 * @param	dir		\DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
static void DrawBlActHeroDraw_STA_DASH_4F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir )
{
	int no;
	
	if( dir != work->old_dir ){
		no = FieldOBJ_BlActAnmOffsNo_DirDashGet( dir );
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameSetOffs( act, 0 );
	}else if( work->old_state != DRAW_STA_DASH_4F ){
		no = FieldOBJ_BlActAnmOffsNo_DirDashGet( dir );
		BLACT_AnmOffsChg( act, no );
	}
		
	if( FieldOBJ_DrawPauseCheck(fldobj) == FALSE ){
		BLACT_AnmFrameChg( act, BLACTANM_FRAME_2 );
	}
}

//--------------------------------------------------------------
///	BlActHero `e[u
//--------------------------------------------------------------
static void (* const DATA_DrawBlActHero_DrawTbl[])(
		FIELD_OBJ_PTR, BLACT_WORK_PTR, BLACT00_WORK *, int ) =
{
	DrawBlActHeroDraw_STA_STOP,
	DrawBlAct00Draw_STA_WALK_32F_16F,
	DrawBlAct00Draw_STA_WALK_32F_16F,
	DrawBlAct00Draw_STA_WALK_8F,
	DrawBlAct00Draw_STA_WALK_4F,
	DrawBlAct00Draw_STA_WALK_2F,
	DrawBlAct00Draw_STA_WALK_6F,
	DrawBlAct00Draw_STA_WALK_3F,
	DrawBlActHeroDraw_STA_DASH_4F,
};

//==============================================================================
//	BlActHeroCycle
//==============================================================================
//--------------------------------------------------------------
/**
 * BlActHeroCycle `B
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawBlActHeroCycle_Draw( FIELD_OBJ_PTR fldobj )
{
	int dir,state;
	BLACT00_WORK *work = FieldOBJ_DrawProcWorkGet( fldobj );
	BLACT_WORK_PTR act = work->act;
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	
	if( FieldOBJ_BlActAddPracFlagCheck(fldobj) == TRUE ){		//ǉ
		return;
	}
	
	if( act == NULL ){
		return;
	}
	
	dir = FieldOBJ_DirDispGet( fldobj );
	state = FieldOBJ_DrawStatusGet( fldobj );
	
	GF_ASSERT( state < DRAW_STA_MAX_CYCLEHERO &&
			"FieldOBJ_DrawBlActHero_Draw()`Xe[^Xُ" );
	DATA_DrawBlActHeroCycle_DrawTbl[state]( fldobj, act, work, dir );
	
	work->old_dir = dir;
	FieldOBJ_BlActPosSet( fldobj, act );
	
	{
		int vanish = TRUE;
	
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_VANISH) == TRUE ){
			vanish = FALSE;
		}
	
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_HEIGHT_GET_NOT) == TRUE ){
			if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_HEIGHT_VANISH_OFF) == FALSE){
				vanish = FALSE;
			}
		}
		
		BLACT_ObjDrawFlagSet( act, vanish );
	}
	
	work->old_state = FieldOBJ_DrawStatusGet( fldobj );
}

//--------------------------------------------------------------
/**
 * BlActHero DRAW_STA_TAKE_OFF_4F
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	act		BLACT_WORK_PTR
 * @param	work	BLACT00_WORK *
 * @param	dir		\DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
static void DrawBlActHeroDraw_STA_TAKE_OFF_16F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir )
{
	int no;
	
	no = FieldOBJ_BlActAnmOffsNo_DirTakeOFFGet( dir );
	
	if( dir != work->old_dir ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameSetOffs( act, 0 );
	}else if( work->old_state != DRAW_STA_TAKE_OFF_16F ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameSetOffs( act, 0 );
	}else if( BLACT_AnmOffsGet(act) != no ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameSetOffs( act, 0 );
	}
		
	if( FieldOBJ_DrawPauseCheck(fldobj) == FALSE ){
		BLACT_AnmFrameChg( act, BLACTANM_FRAME_05 );
	}
}

//--------------------------------------------------------------
/**
 * BlActHero DRAW_STA_TAKE_OFF_8F
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	act		BLACT_WORK_PTR
 * @param	work	BLACT00_WORK *
 * @param	dir		\DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
static void DrawBlActHeroDraw_STA_TAKE_OFF_8F(
		FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, BLACT00_WORK *work, int dir )
{
	int no;
	
	no = FieldOBJ_BlActAnmOffsNo_DirTakeOFFGet( dir );
	
	if( dir != work->old_dir ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameSetOffs( act, 0 );
	}else if( work->old_state != DRAW_STA_TAKE_OFF_8F ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameSetOffs( act, 0 );
	}else if( BLACT_AnmOffsGet(act) != no ){
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameSetOffs( act, 0 );
	}
		
	if( FieldOBJ_DrawPauseCheck(fldobj) == FALSE ){
		BLACT_AnmFrameChg( act, BLACTANM_FRAME_1 );
	}
}

//--------------------------------------------------------------
///	BlActHeroCycle `e[u
//--------------------------------------------------------------
static void (* const DATA_DrawBlActHeroCycle_DrawTbl[])(
		FIELD_OBJ_PTR, BLACT_WORK_PTR, BLACT00_WORK *, int ) =
{
	DrawBlActHeroDraw_STA_STOP,
	DrawBlAct00Draw_STA_WALK_32F_16F,
	DrawBlAct00Draw_STA_WALK_32F_16F,
	DrawBlAct00Draw_STA_WALK_8F,
	DrawBlAct00Draw_STA_WALK_4F,
	DrawBlAct00Draw_STA_WALK_2F,
	DrawBlAct00Draw_STA_WALK_6F,
	DrawBlAct00Draw_STA_WALK_3F,
	DrawBlActHeroDraw_STA_TAKE_OFF_16F,
	DrawBlActHeroDraw_STA_TAKE_OFF_8F,
};

//==============================================================================
//	BlActHero@̑
//==============================================================================
//--------------------------------------------------------------
/**
 * BlActHeroSwim `B
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawBlActHeroSwim_Draw( FIELD_OBJ_PTR fldobj )
{
	int dir;
	BLACT00_WORK *work = FieldOBJ_DrawProcWorkGet( fldobj );
	BLACT_WORK_PTR act = work->act;
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	
	if( FieldOBJ_BlActAddPracFlagCheck(fldobj) == TRUE ){		//ǉ
		return;
	}
	
	if( act == NULL ){
		return;
	}
	
	dir = FieldOBJ_DirDispGet( fldobj );
	
	work->old_dir = dir;
	FieldOBJ_BlActPosSet( fldobj, act );
	
	{
		int no = FieldOBJ_BlActAnmOffsNo_DirWalkGet( dir );
		BLACT_AnmOffsChg( act, no );
		BLACT_AnmFrameSetOffs( act, 0 );
		BLACT_AnmFrameChg( act, 0 );
	}
	
	{
		int vanish = TRUE;
	
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_VANISH) == TRUE ){
			vanish = FALSE;
		}
	
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_HEIGHT_GET_NOT) == TRUE ){
			if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_HEIGHT_VANISH_OFF) == FALSE){
				vanish = FALSE;
			}
		}
		
		BLACT_ObjDrawFlagSet( act, vanish );
	}
	
	work->old_state = FieldOBJ_DrawStatusGet( fldobj );
}

//--------------------------------------------------------------
/**
 * BlActHeroSp `
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawBlActHeroSp_Draw( FIELD_OBJ_PTR fldobj )
{
	int dir;
	BLACT00_WORK *work = FieldOBJ_DrawProcWorkGet( fldobj );
	BLACT_WORK_PTR act = work->act;
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	
	if( FieldOBJ_BlActAddPracFlagCheck(fldobj) == TRUE ){		//ǉ
		return;
	}
	
	if( act == NULL ){
		return;
	}
	
	dir = FieldOBJ_DirDispGet( fldobj );
	
	work->old_dir = dir;
	FieldOBJ_BlActPosSet( fldobj, act );
	
	if( BLACT_AnmOffsGet(act) != 0 ){
		BLACT_AnmOffsChg( act, 0 );
		BLACT_AnmFrameSetOffs( act, 0 );
	}
	
	BLACT_AnmFrameChg( act, BLACTANM_FRAME_1 );
	
	{
		int vanish = TRUE;
	
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_VANISH) == TRUE ){
			vanish = FALSE;
		}
	
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_HEIGHT_GET_NOT) == TRUE ){
			if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_HEIGHT_VANISH_OFF) == FALSE){
				vanish = FALSE;
			}
		}
		
		BLACT_ObjDrawFlagSet( act, vanish );
	}
	
	work->old_state = FieldOBJ_DrawStatusGet( fldobj );
}

//--------------------------------------------------------------
/**
 * BlActHeroWater `B
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawBlActHeroWater_Draw( FIELD_OBJ_PTR fldobj )
{
	int dir,state;
	BLACT00_WORK *work = FieldOBJ_DrawProcWorkGet( fldobj );
	BLACT_WORK_PTR act = work->act;
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	
	if( FieldOBJ_BlActAddPracFlagCheck(fldobj) == TRUE ){		//ǉ
		return;
	}
	
	if( act == NULL ){
		return;
	}
	
	dir = FieldOBJ_DirDispGet( fldobj );
	state = FieldOBJ_DrawStatusGet( fldobj );
	
	switch( state ){
	case DRAW_STA_STOP:
		if( BLACT_AnmOffsGet(act) != 1 ){
			BLACT_AnmOffsChg( act, 1 );
			BLACT_AnmFrameSetOffs( act, 0 );
		}
		
		BLACT_AnmFrameChg( act, BLACTANM_FRAME_1 );
		break;
	default:
		if( BLACT_AnmOffsGet(act) != 0 ){
			BLACT_AnmOffsChg( act, 0 );
			BLACT_AnmFrameSetOffs( act, 0 );
		}
		
		BLACT_AnmFrameChg( act, BLACTANM_FRAME_1 );
	}
	
	work->old_dir = dir;
	FieldOBJ_BlActPosSet( fldobj, act );
	
	{
		int vanish = TRUE;
	
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_VANISH) == TRUE ){
			vanish = FALSE;
		}
	
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_HEIGHT_GET_NOT) == TRUE ){
			if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_HEIGHT_VANISH_OFF) == FALSE){
				vanish = FALSE;
			}
		}
		
		BLACT_ObjDrawFlagSet( act, vanish );
	}
	
	work->old_state = FieldOBJ_DrawStatusGet( fldobj );
}

//==============================================================================
//	r{[hp[c
//==============================================================================
//--------------------------------------------------------------
/**
 * ~t[ZbgB
 * ]t[폜A~AjɔfB
 * @param	act		BLACT_WORK_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActAnmFrameStopSet( BLACT_WORK_PTR act )
{
	fx32 frame,mod;
	
	frame = BLACT_AnmFrameGetOffs( act );
	frame /= FX32_ONE;
	mod = frame % BLACTANM_STEP_FRAME;
	frame -= mod;
	frame *= FX32_ONE;
	
	BLACT_AnmFrameSetOffs( act, frame );
	BLACT_AnmFrameChg( act, 0 );	//ʔf̂
}

//==============================================================================
///	Model00
//==============================================================================
//--------------------------------------------------------------
/**
 * Model00 Ŕ@B
 * `ׂ̈̏sB
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawModel00_Board_Init( FIELD_OBJ_PTR fldobj )
{
	MODEL00_WORK *work;
	
	work = FieldOBJ_DrawProcWorkInit( fldobj, MODEL00_WORK_SIZE );
	work->eoa = FE_FldOBJBoard_Add( fldobj );
}

//--------------------------------------------------------------
/**
 * Model00 ʁ@B
 * `ׂ̈̏sB
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawModel00_SnowBall_Init( FIELD_OBJ_PTR fldobj )
{
	MODEL00_WORK *work;
	
	work = FieldOBJ_DrawProcWorkInit( fldobj, MODEL00_WORK_SIZE );
	work->eoa = FE_FldOBJSnowBall_Add( fldobj );
}

//--------------------------------------------------------------
/**
 * Model00 `B
 * tB[hOBJ`ɕKvȏ擾A`悷B
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawModel00_Draw( FIELD_OBJ_PTR fldobj )
{
}

//--------------------------------------------------------------
/**
 * Model00 폜֐B
 * `Ŏgpm폜
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawModel00_Delete( FIELD_OBJ_PTR fldobj )
{
	MODEL00_WORK *work;
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	
	if( work->eoa != NULL ){
		EOA_Delete( work->eoa );
		work->eoa = NULL;
	}
}

//--------------------------------------------------------------
/**
 * Model00 ޔB
 * `ɕKvȏޔA`Ŏgpm폜
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	int			TRUE=
 */
//--------------------------------------------------------------
void FieldOBJ_DrawModel00_Push( FIELD_OBJ_PTR fldobj )
{
	MODEL00_WORK *work;
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	
	if( work->eoa != NULL ){
		EOA_Delete( work->eoa );
		work->eoa = NULL;
	}
}

//--------------------------------------------------------------
/**
 * Model00 Ŕ@A
 * ޔɍĕ`B
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	int			TRUE=
 */
//--------------------------------------------------------------
void FieldOBJ_DrawModel00_Board_Pop( FIELD_OBJ_PTR fldobj )
{
	MODEL00_WORK *work;
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	
	GF_ASSERT( work->eoa == NULL &&
			"FieldOBJ_DrawModel00_Pop()AN^[oĂȂ\n" );
	
	work->eoa = FE_FldOBJBoard_Add( fldobj );
}

//--------------------------------------------------------------
/**
 * Model00 ʁ@A
 * ޔɍĕ`B
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	int			TRUE=
 */
//--------------------------------------------------------------
void FieldOBJ_DrawModel00_SnowBall_Pop( FIELD_OBJ_PTR fldobj )
{
	MODEL00_WORK *work;
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	
	GF_ASSERT( work->eoa == NULL &&
			"FieldOBJ_DrawModel00_Pop()AN^[oĂȂ\n" );
	
	work->eoa = FE_FldOBJSnowBall_Add( fldobj );
}
