//******************************************************************************
/**
 *
 * @file	fieldobj_drawdata.c
 * @brief	tB[hOBJ`f[^
 * @author	kagaya
 * @data	05.07.20
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "fieldobj.h"

#include "..\data\mmodel\mmodel.naix"	//A[JCuID

//==============================================================================
//	extern
//==============================================================================

//==============================================================================
//	tB[hOBJ `֐`
//==============================================================================
//--------------------------------------------------------------
///	HERO
//--------------------------------------------------------------
static const FIELD_OBJ_DRAW_PROC_LIST DATA_FieldOBJDraw_Hero =
{
	FieldOBJ_DrawBlActHero_Init,
	FieldOBJ_DrawBlActHero_Draw,
	FieldOBJ_DrawBlActHero_Delete,
	FieldOBJ_DrawBlActHero_Push,
	FieldOBJ_DrawBlActHero_Pop,
};

//--------------------------------------------------------------
///	CYCLEHERO
//--------------------------------------------------------------
static const FIELD_OBJ_DRAW_PROC_LIST DATA_FieldOBJDraw_HeroCycle = 
{
	FieldOBJ_DrawBlActHero_Init,
	FieldOBJ_DrawBlActHeroCycle_Draw,
	FieldOBJ_DrawBlActHero_Delete,
	FieldOBJ_DrawBlActHero_Push,
	FieldOBJ_DrawBlActHero_Pop,
};

//--------------------------------------------------------------
///	SWIMHERO
//--------------------------------------------------------------
static const FIELD_OBJ_DRAW_PROC_LIST DATA_FieldOBJDraw_HeroSwim =
{
	FieldOBJ_DrawBlActHero_Init,
	FieldOBJ_DrawBlActHeroSwim_Draw,
	FieldOBJ_DrawBlActHero_Delete,
	FieldOBJ_DrawBlActHero_Push,
	FieldOBJ_DrawBlActHero_Pop,
};

//--------------------------------------------------------------
///	SPHERO
//--------------------------------------------------------------
static const FIELD_OBJ_DRAW_PROC_LIST DATA_FieldOBJDraw_HeroSp =
{
	FieldOBJ_DrawBlActHero_Init,
	FieldOBJ_DrawBlActHeroSp_Draw,
	FieldOBJ_DrawBlActHero_Delete,
	FieldOBJ_DrawBlActHero_Push,
	FieldOBJ_DrawBlActHero_Pop,
};

//--------------------------------------------------------------
///	WATERHERO
//--------------------------------------------------------------
static const FIELD_OBJ_DRAW_PROC_LIST DATA_FieldOBJDraw_HeroWater =
{
	FieldOBJ_DrawBlActHero_Init,
	FieldOBJ_DrawBlActHeroWater_Draw,
	FieldOBJ_DrawBlActHero_Delete,
	FieldOBJ_DrawBlActHero_Push,
	FieldOBJ_DrawBlActHero_Pop,
};

//--------------------------------------------------------------
///	r{[hAN^[gp@ʐlW00
//--------------------------------------------------------------
static const FIELD_OBJ_DRAW_PROC_LIST DATA_FieldOBJDraw_BlAct00 =
{
	FieldOBJ_DrawBlAct00_Init,
	FieldOBJ_DrawBlAct00_Draw,
	FieldOBJ_DrawBlAct00_Delete,
	FieldOBJ_DrawBlAct00_Push,
	FieldOBJ_DrawBlAct00_Pop,
};

//--------------------------------------------------------------
///	r{[hAN^[gp@ʐlW00@AjȂ
//--------------------------------------------------------------
static const FIELD_OBJ_DRAW_PROC_LIST DATA_FieldOBJDraw_BlAct00AnmNon =
{
	FieldOBJ_DrawBlAct00_Init,
	FieldOBJ_DrawBlAct00AnmNon_Draw,
	FieldOBJ_DrawBlAct00_Delete,
	FieldOBJ_DrawBlAct00_Push,
	FieldOBJ_DrawBlAct00_Pop,
};

//--------------------------------------------------------------
///	3Dfgp@W00@Ŕ
//--------------------------------------------------------------
static const FIELD_OBJ_DRAW_PROC_LIST DATA_FieldOBJDraw_Model00Board =
{
	FieldOBJ_DrawModel00_Board_Init,
	FieldOBJ_DrawModel00_Draw,
	FieldOBJ_DrawModel00_Delete,
	FieldOBJ_DrawModel00_Push,
	FieldOBJ_DrawModel00_Board_Pop,
};

//--------------------------------------------------------------
///	؂̎
//--------------------------------------------------------------
static const FIELD_OBJ_DRAW_PROC_LIST DATA_FieldOBJDraw_Seed =
{
	FieldOBJ_DrawSeed_Init,
	FieldOBJ_DrawSeed_Draw,
	FieldOBJ_DrawSeed_Delete,
	FieldOBJ_DrawSeed_Push,
	FieldOBJ_DrawSeed_Pop,
};

//--------------------------------------------------------------
///	r{[hAN^[gp@
//--------------------------------------------------------------
static const FIELD_OBJ_DRAW_PROC_LIST DATA_FieldOBJDraw_BlActBird =
{
	FieldOBJ_DrawBlAct00_Init,
	FieldOBJ_DrawBlActBird_Draw,
	FieldOBJ_DrawBlAct00_Delete,
	FieldOBJ_DrawBlAct00_Push,
	FieldOBJ_DrawBlAct00_Pop,
};

//--------------------------------------------------------------
///	3Dfgp@W00@
//--------------------------------------------------------------
static const FIELD_OBJ_DRAW_PROC_LIST DATA_FieldOBJDraw_Model00SnowBall =
{
	FieldOBJ_DrawModel00_SnowBall_Init,
	FieldOBJ_DrawModel00_Draw,
	FieldOBJ_DrawModel00_Delete,
	FieldOBJ_DrawModel00_Push,
	FieldOBJ_DrawModel00_SnowBall_Pop,
};

//--------------------------------------------------------------
///	NONDRAW
//--------------------------------------------------------------
const FIELD_OBJ_DRAW_PROC_LIST DATA_FieldOBJDraw_Non =
{
	FieldOBJ_DrawNon_Init,
	FieldOBJ_DrawNon_Draw,
	FieldOBJ_DrawNon_Delete,
	FieldOBJ_DrawNon_Push,
	FieldOBJ_DrawNon_Pop,
};

//==============================================================================
//	tB[hOBJ `֐܂Ƃ
//==============================================================================
//--------------------------------------------------------------
///	`֐܂Ƃ߁@тOBJR[hƈv->sɂ
//--------------------------------------------------------------
const FIELD_OBJ_DRAW_PROC_LIST_REG DATA_FieldOBJDrawProcListRegTbl[] =
{
	{ HERO,			&DATA_FieldOBJDraw_Hero },
	{ BABYBOY1,		&DATA_FieldOBJDraw_BlAct00 },
	{ BABYGIRL1,	&DATA_FieldOBJDraw_BlAct00 },
	{ BOY1,			&DATA_FieldOBJDraw_BlAct00 },
	{ BOY2,			&DATA_FieldOBJDraw_BlAct00 },
	{ BOY3,			&DATA_FieldOBJDraw_BlAct00 },
	{ GIRL1,		&DATA_FieldOBJDraw_BlAct00 },
	{ GIRL2,		&DATA_FieldOBJDraw_BlAct00 },
	{ GIRL3,		&DATA_FieldOBJDraw_BlAct00 },
	{ MAN1,			&DATA_FieldOBJDraw_BlAct00 },
	{ MAN2,			&DATA_FieldOBJDraw_BlAct00 },
	{ MAN3,			&DATA_FieldOBJDraw_BlAct00 },
	{ WOMAN1,		&DATA_FieldOBJDraw_BlAct00 },
	{ WOMAN2,		&DATA_FieldOBJDraw_BlAct00 },
	{ WOMAN3,		&DATA_FieldOBJDraw_BlAct00 },
	{ MIDDLEMAN1,	&DATA_FieldOBJDraw_BlAct00 },
	{ MIDDLEWOMAN1,	&DATA_FieldOBJDraw_BlAct00 },
	{ OLDMAN1,		&DATA_FieldOBJDraw_BlAct00 },
	{ OLDWOMAN1,	&DATA_FieldOBJDraw_BlAct00 },
	{ BIGMAN,		&DATA_FieldOBJDraw_BlAct00 },
	{ MOUNT,		&DATA_FieldOBJDraw_BlAct00 },
	{ CYCLEHERO,	&DATA_FieldOBJDraw_HeroCycle },
	{REPORTER,	&DATA_FieldOBJDraw_BlAct00 },
	{CAMERAMAN,	&DATA_FieldOBJDraw_BlAct00 },
	{SHOPM1,	&DATA_FieldOBJDraw_BlAct00 },
	{SHOPW1,	&DATA_FieldOBJDraw_BlAct00 },
	{PCWOMAN1,	&DATA_FieldOBJDraw_BlAct00 },
	{PCWOMAN2,	&DATA_FieldOBJDraw_BlAct00 },
	{PCWOMAN3,	&DATA_FieldOBJDraw_BlAct00 },
	{ASSISTANTM,	&DATA_FieldOBJDraw_BlAct00 },
	{ASSISTANTW,	&DATA_FieldOBJDraw_BlAct00 },
	{BADMAN,	&DATA_FieldOBJDraw_BlAct00 },
	{SKIERM,	&DATA_FieldOBJDraw_BlAct00 },
	{SKIERW,	&DATA_FieldOBJDraw_BlAct00 },
	{POLICEMAN,	&DATA_FieldOBJDraw_BlAct00 },
	{IDOL,	&DATA_FieldOBJDraw_BlAct00 },
	{GENTLEMAN,	&DATA_FieldOBJDraw_BlAct00 },
	{LADY,	&DATA_FieldOBJDraw_BlAct00 },
	{CYCLEM,	&DATA_FieldOBJDraw_BlAct00 },
	{CYCLEW,	&DATA_FieldOBJDraw_BlAct00 },
	{WORKMAN,	&DATA_FieldOBJDraw_BlAct00 },
	{FARMER,	&DATA_FieldOBJDraw_BlAct00 },
	{COWGIRL,	&DATA_FieldOBJDraw_BlAct00 },
	{CLOWN,	&DATA_FieldOBJDraw_BlAct00 },
	{ARTIST,	&DATA_FieldOBJDraw_BlAct00 },
	{SPORTSMAN,	&DATA_FieldOBJDraw_BlAct00 },
	{SWIMMERM,	&DATA_FieldOBJDraw_BlAct00 },
	{SWIMMERW,	&DATA_FieldOBJDraw_BlAct00 },
	{BEACHGIRL,	&DATA_FieldOBJDraw_BlAct00 },
	{BEACHBOY,	&DATA_FieldOBJDraw_BlAct00 },
	{EXPLORE,	&DATA_FieldOBJDraw_BlAct00 },
	{FIGHTER,	&DATA_FieldOBJDraw_BlAct00 },
	{CAMPBOY,	&DATA_FieldOBJDraw_BlAct00 },
	{PICNICGIRL,	&DATA_FieldOBJDraw_BlAct00 },
	{FISHING,	&DATA_FieldOBJDraw_BlAct00 },
	{AMBRELLA,	&DATA_FieldOBJDraw_BlAct00 },
	{SEAMAN,	&DATA_FieldOBJDraw_BlAct00 },
	{BRINGM,	&DATA_FieldOBJDraw_BlAct00 },
	{BRINGW,	&DATA_FieldOBJDraw_BlAct00 },
	{WAITER,	&DATA_FieldOBJDraw_BlAct00 },
	{WAITRESS,	&DATA_FieldOBJDraw_BlAct00 },
	{VETERAN,	&DATA_FieldOBJDraw_BlAct00 },
	{GORGGEOUSM,	&DATA_FieldOBJDraw_BlAct00 },
	{GORGGEOUSW,	&DATA_FieldOBJDraw_BlAct00 },
	{BOY4,	&DATA_FieldOBJDraw_BlAct00 },
	{GIRL4,	&DATA_FieldOBJDraw_BlAct00 },
	{MAN4,	&DATA_FieldOBJDraw_BlAct00 },
	{WOMAN4,	&DATA_FieldOBJDraw_BlAct00 },
	{MAN5,	&DATA_FieldOBJDraw_BlAct00 },
	{WOMAN5,	&DATA_FieldOBJDraw_BlAct00 },
	{MYSTERY,	&DATA_FieldOBJDraw_BlAct00 },
	{PIKACHU,	&DATA_FieldOBJDraw_BlAct00 },
	{PIPPI,	&DATA_FieldOBJDraw_BlAct00 },
	{PURIN,	&DATA_FieldOBJDraw_BlAct00 },
	{KODUCK,	&DATA_FieldOBJDraw_BlAct00 },
	{PRASLE,	&DATA_FieldOBJDraw_BlAct00 },
	{MINUN,	&DATA_FieldOBJDraw_BlAct00 },
	{MARIL,	&DATA_FieldOBJDraw_BlAct00 },
	{ACHAMO,	&DATA_FieldOBJDraw_BlAct00 },
	{ENECO,	&DATA_FieldOBJDraw_BlAct00 },
	{GONBE,	&DATA_FieldOBJDraw_BlAct00 },
	{BABY,	&DATA_FieldOBJDraw_BlAct00 },
	{MIDDLEMAN2,	&DATA_FieldOBJDraw_BlAct00 },
	{MIDDLEWOMAN2,	&DATA_FieldOBJDraw_BlAct00 },
	{ROCK,	&DATA_FieldOBJDraw_BlAct00AnmNon },
	{BREAKROCK,	&DATA_FieldOBJDraw_BlAct00AnmNon },
	{TREE,	&DATA_FieldOBJDraw_BlAct00AnmNon },
	{MONATERBALL,	&DATA_FieldOBJDraw_BlAct00AnmNon },
	{SHADOW,	&DATA_FieldOBJDraw_BlAct00 },
	{BOUGH,	&DATA_FieldOBJDraw_BlAct00 },
	{FALLTREE,	&DATA_FieldOBJDraw_BlAct00 },
	{ BOARD_A, &DATA_FieldOBJDraw_Model00Board },
	{ BOARD_B, &DATA_FieldOBJDraw_Model00Board },
	{ BOARD_C, &DATA_FieldOBJDraw_Model00Board },
	{ BOARD_D, &DATA_FieldOBJDraw_Model00Board },
	{ BOARD_E, &DATA_FieldOBJDraw_Model00Board },
	{ BOARD_F, &DATA_FieldOBJDraw_Model00Board },
	{ HEROINE,	&DATA_FieldOBJDraw_Hero },
	{ CYCLEHEROINE,	&DATA_FieldOBJDraw_HeroCycle },
	{ DOCTOR,	&DATA_FieldOBJDraw_BlAct00 },
	{ SEED, &DATA_FieldOBJDraw_Seed },
	{ SNOWBALL, &DATA_FieldOBJDraw_Model00SnowBall },
	{ GINGABOSS, &DATA_FieldOBJDraw_BlAct00 },
	{ GKANBU1, &DATA_FieldOBJDraw_BlAct00 },
	{ GKANBU2, &DATA_FieldOBJDraw_BlAct00 },
	{ GKANBU3, &DATA_FieldOBJDraw_BlAct00 },
	{ GINGAM, &DATA_FieldOBJDraw_BlAct00 },
	{ GINGAW, &DATA_FieldOBJDraw_BlAct00 },
	{ LEADER1, &DATA_FieldOBJDraw_BlAct00 },
	{ LEADER2, &DATA_FieldOBJDraw_BlAct00 },
	{ LEADER3, &DATA_FieldOBJDraw_BlAct00 },
	{ LEADER4, &DATA_FieldOBJDraw_BlAct00 },
	{ LEADER5, &DATA_FieldOBJDraw_BlAct00 },
	{ LEADER6, &DATA_FieldOBJDraw_BlAct00 },
	{ LEADER7, &DATA_FieldOBJDraw_BlAct00 },
	{ LEADER8, &DATA_FieldOBJDraw_BlAct00 },
	{ BIGFOUR1, &DATA_FieldOBJDraw_BlAct00 },
	{ BIGFOUR2, &DATA_FieldOBJDraw_BlAct00 },
	{ BIGFOUR3, &DATA_FieldOBJDraw_BlAct00 },
	{ BIGFOUR4, &DATA_FieldOBJDraw_BlAct00 },
	{ CHAMPION, &DATA_FieldOBJDraw_BlAct00 },
	{ PAPA, &DATA_FieldOBJDraw_BlAct00 },
	{ MAMA, &DATA_FieldOBJDraw_BlAct00 },
	{ SEVEN1, &DATA_FieldOBJDraw_BlAct00 },
	{ SEVEN2, &DATA_FieldOBJDraw_BlAct00 },
	{ SEVEN3, &DATA_FieldOBJDraw_BlAct00 },
	{ SEVEN4, &DATA_FieldOBJDraw_BlAct00 },
	{ SEVEN5, &DATA_FieldOBJDraw_BlAct00 },
	{ SEVEN6, &DATA_FieldOBJDraw_BlAct00 },
	{ SEVEN7, &DATA_FieldOBJDraw_BlAct00 },
	{ RIVEL, &DATA_FieldOBJDraw_BlAct00 },
	{ BOAT, &DATA_FieldOBJDraw_BlAct00 },
	{ TRAIN, &DATA_FieldOBJDraw_BlAct00 },
	{ SPPOKE1, &DATA_FieldOBJDraw_BlAct00 },
	{ SPPOKE2, &DATA_FieldOBJDraw_BlAct00 },
	{ SPPOKE3, &DATA_FieldOBJDraw_BlAct00 },
	{ SPPOKE4, &DATA_FieldOBJDraw_BlAct00 },
	{ SPPOKE5, &DATA_FieldOBJDraw_BlAct00 },
	{ SPPOKE6, &DATA_FieldOBJDraw_BlAct00 },
	{ SPPOKE7, &DATA_FieldOBJDraw_BlAct00 },
	{ SPPOKE8, &DATA_FieldOBJDraw_BlAct00 },
	{ SPPOKE9, &DATA_FieldOBJDraw_BlAct00 },
	{ SPPOKE10, &DATA_FieldOBJDraw_BlAct00 },
	{ SPPOKE11, &DATA_FieldOBJDraw_BlAct00 },
	{ OBAKE, &DATA_FieldOBJDraw_BlAct00 },
	{ WOMAN6, &DATA_FieldOBJDraw_BlAct00 },
	{ OLDMAN2, &DATA_FieldOBJDraw_BlAct00 },
	{ OLDWOMAN2, &DATA_FieldOBJDraw_BlAct00 },
	{ OOKIDO, &DATA_FieldOBJDraw_BlAct00 },
	{ MIKAN, &DATA_FieldOBJDraw_BlAct00 },
	{ SUNGLASSES, &DATA_FieldOBJDraw_BlAct00 },
	{ TOWERBOSS, &DATA_FieldOBJDraw_BlAct00 },
	{ SNOWCOVER, &DATA_FieldOBJDraw_BlAct00 },
	{ TREECOVER, &DATA_FieldOBJDraw_BlAct00 },
	{ ROCKCOVER, &DATA_FieldOBJDraw_BlAct00 },
	{ BIRD, &DATA_FieldOBJDraw_BlActBird },
	{ BAG, &DATA_FieldOBJDraw_BlAct00 },
	{ MAID, &DATA_FieldOBJDraw_BlAct00 },
	{ SPHERO, &DATA_FieldOBJDraw_HeroSp },
	{ SPHEROINE, &DATA_FieldOBJDraw_HeroSp },
	{ WATERHERO, &DATA_FieldOBJDraw_HeroWater },
	{ WATERHEROINE, &DATA_FieldOBJDraw_HeroWater },
	{ SWIMHERO, &DATA_FieldOBJDraw_HeroSwim },
	{ SWIMHEROINE, &DATA_FieldOBJDraw_HeroSwim },
	{ VENTHOLE, &DATA_FieldOBJDraw_BlAct00 },
	
	{ OBJCODEMAX, NULL },	//I[
};

//==============================================================================
//	tB[hOBJ eNX`܂Ƃ
//==============================================================================
//--------------------------------------------------------------
///	eNX`ID,A[JCuID
///	т͕s
//--------------------------------------------------------------
const FIELD_OBJ_RESMNARC DATA_FieldOBJ_ResmNArcTbl_Tex[] =
{
	{ HERO, NARC_mmodel_hero_nsbtx },
	{ BABYBOY1, NARC_mmodel_babyboy1_nsbtx },
	{ BABYGIRL1, NARC_mmodel_babygirl1_nsbtx },
	{ BOY1, NARC_mmodel_boy1_nsbtx },
	{ BOY2, NARC_mmodel_boy2_nsbtx },
	{ BOY3, NARC_mmodel_boy3_nsbtx },
	{ GIRL1, NARC_mmodel_girl1_nsbtx },
	{ GIRL2, NARC_mmodel_girl2_nsbtx },
	{ GIRL3, NARC_mmodel_girl3_nsbtx },
	{ MAN1, NARC_mmodel_man1_nsbtx },
	{ MAN2, NARC_mmodel_man2_nsbtx },
	{ MAN3, NARC_mmodel_man3_nsbtx },
	{ WOMAN1, NARC_mmodel_woman1_nsbtx },
	{ WOMAN2, NARC_mmodel_woman2_nsbtx },
	{ WOMAN3, NARC_mmodel_woman3_nsbtx },
	{ MIDDLEMAN1, NARC_mmodel_middleman1_nsbtx },
	{ MIDDLEWOMAN1, NARC_mmodel_middlewoman1_nsbtx },
	{ OLDMAN1, NARC_mmodel_oldman1_nsbtx },
	{ OLDWOMAN1, NARC_mmodel_oldwoman1_nsbtx },
	{ BIGMAN, NARC_mmodel_bigman_nsbtx },
	{ MOUNT, NARC_mmodel_mount_nsbtx },
	{ CYCLEHERO, NARC_mmodel_cyclehero_nsbtx },
	{ REPORTER, NARC_mmodel_reporter_nsbtx },
	{ CAMERAMAN,NARC_mmodel_cameraman_nsbtx  },
	{ SHOPM1, NARC_mmodel_shopm1_nsbtx },
	{ SHOPW1, NARC_mmodel_shopw1_nsbtx },
	{ PCWOMAN1, NARC_mmodel_pcwoman1_nsbtx },
	{ PCWOMAN2, NARC_mmodel_pcwoman2_nsbtx },
	{ PCWOMAN3, NARC_mmodel_pcwoman3_nsbtx },
	{ ASSISTANTM, NARC_mmodel_assistantm_nsbtx },
	{ ASSISTANTW, NARC_mmodel_assistantw_nsbtx },
	{ BADMAN, NARC_mmodel_badman_nsbtx },
	{ SKIERM,NARC_mmodel_skierm_nsbtx  },
	{ SKIERW, NARC_mmodel_skierw_nsbtx },
	{ POLICEMAN, NARC_mmodel_policeman_nsbtx },
	{ IDOL, NARC_mmodel_idol_nsbtx },
	{ GENTLEMAN, NARC_mmodel_gentleman_nsbtx },
	{ LADY, NARC_mmodel_lady_nsbtx },
	{ CYCLEM, NARC_mmodel_cyclem_nsbtx },
	{ CYCLEW, NARC_mmodel_cyclew_nsbtx },
	{ WORKMAN, NARC_mmodel_workman_nsbtx },
	{ FARMER, NARC_mmodel_farmer_nsbtx },
	{ COWGIRL, NARC_mmodel_cowgirl_nsbtx },
	{ CLOWN, NARC_mmodel_clown_nsbtx },
	{ ARTIST, NARC_mmodel_artist_nsbtx },
	{ SPORTSMAN, NARC_mmodel_sportsman_nsbtx },
	{ SWIMMERM,NARC_mmodel_swimmerm_nsbtx  },
	{ SWIMMERW, NARC_mmodel_swimmerw_nsbtx },
	{ BEACHGIRL, NARC_mmodel_beachgirl_nsbtx },
	{ BEACHBOY, NARC_mmodel_beachboy_nsbtx },
	{ EXPLORE, NARC_mmodel_explore_nsbtx },
	{ FIGHTER, NARC_mmodel_fighter_nsbtx },
	{ CAMPBOY, NARC_mmodel_campboy_nsbtx },
	{ PICNICGIRL, NARC_mmodel_picnicgirl_nsbtx },
	{ FISHING, NARC_mmodel_fishing_nsbtx },
	{ AMBRELLA, NARC_mmodel_ambrella_nsbtx },
	{ SEAMAN,NARC_mmodel_seaman_nsbtx  },
	{ BRINGM, NARC_mmodel_bringm_nsbtx },
	{ BRINGW, NARC_mmodel_bringw_nsbtx },
	{ WAITER, NARC_mmodel_waiter_nsbtx },
	{ WAITRESS, NARC_mmodel_waitress_nsbtx },
	{ VETERAN, NARC_mmodel_veteran_nsbtx },
	{ GORGGEOUSM, NARC_mmodel_gorggeousm_nsbtx },
	{ GORGGEOUSW, NARC_mmodel_gorggeousw_nsbtx },
	{ BOY4,NARC_mmodel_boy4_nsbtx  },
	{ GIRL4, NARC_mmodel_girl4_nsbtx },
	{ MAN4, NARC_mmodel_man4_nsbtx },
	{ WOMAN4,NARC_mmodel_woman4_nsbtx  },
	{ MAN5, NARC_mmodel_man5_nsbtx },
	{ WOMAN5, NARC_mmodel_woman5_nsbtx },
	{ MYSTERY, NARC_mmodel_mystery_nsbtx },
	{ PIKACHU, NARC_mmodel_pikachu_nsbtx },
	{ PIPPI,NARC_mmodel_pippi_nsbtx  },
	{ PURIN, NARC_mmodel_purin_nsbtx },
	{ KODUCK, NARC_mmodel_koduck_nsbtx },
	{ PRASLE, NARC_mmodel_prasle_nsbtx },
	{ MINUN, NARC_mmodel_minun_nsbtx },
	{ MARIL,NARC_mmodel_maril_nsbtx  },
	{ ACHAMO, NARC_mmodel_achamo_nsbtx },
	{ ENECO,NARC_mmodel_eneco_nsbtx  },
	{ GONBE, NARC_mmodel_gonbe_nsbtx },
	{ BABY, NARC_mmodel_baby_nsbtx },
	{ MIDDLEMAN2, NARC_mmodel_middleman2_nsbtx },
	{ MIDDLEWOMAN2,NARC_mmodel_middlewoman2_nsbtx  },
	{ ROCK, NARC_mmodel_rock_nsbtx },
	{ BREAKROCK, NARC_mmodel_breakrock_nsbtx },
	{ TREE, NARC_mmodel_tree_nsbtx },
	{ MONATERBALL, NARC_mmodel_monaterball_nsbtx },
	{ SHADOW, NARC_mmodel_shadow_nsbtx },
	{ BOUGH, NARC_mmodel_bough_nsbtx },
	{ FALLTREE, NARC_mmodel_falltree_nsbtx },
	{ HEROINE, NARC_mmodel_heroine_nsbtx },
	{ CYCLEHEROINE, NARC_mmodel_cycleheroine_nsbtx },
	{ DOCTOR, NARC_mmodel_doctor_nsbtx },
	{ SEED_00, NARC_mmodel_seed00_a_nsbtx },
	{ SEED_01A, NARC_mmodel_seed01_a_nsbtx },
	{ SEED_01B, NARC_mmodel_seed01_b_nsbtx },
	{ SEED_01C, NARC_mmodel_seed01_c_nsbtx },
	{ GINGABOSS,NARC_mmodel_gingaboss_nsbtx }, 
	{ GKANBU1,NARC_mmodel_gkanbu1_nsbtx }, 
	{ GKANBU2,NARC_mmodel_gkanbu2_nsbtx }, 
	{ GKANBU3,NARC_mmodel_gkanbu3_nsbtx }, 
	{ GINGAM,NARC_mmodel_gingam_nsbtx }, 
	{ GINGAW,NARC_mmodel_gingaw_nsbtx }, 
	{ LEADER1,NARC_mmodel_leader1_nsbtx }, 
	{ LEADER2,NARC_mmodel_leader2_nsbtx }, 
	{ LEADER3,NARC_mmodel_leader3_nsbtx }, 
	{ LEADER4,NARC_mmodel_leader4_nsbtx }, 
	{ LEADER5,NARC_mmodel_leader5_nsbtx }, 
	{ LEADER6,NARC_mmodel_leader6_nsbtx }, 
	{ LEADER7,NARC_mmodel_leader7_nsbtx }, 
	{ LEADER8,NARC_mmodel_leader8_nsbtx }, 
	{ BIGFOUR1,NARC_mmodel_bigfour1_nsbtx }, 
	{ BIGFOUR2,NARC_mmodel_bigfour2_nsbtx }, 
	{ BIGFOUR3,NARC_mmodel_bigfour3_nsbtx }, 
	{ BIGFOUR4,NARC_mmodel_bigfour4_nsbtx }, 
	{ CHAMPION,NARC_mmodel_champion_nsbtx }, 
	{ PAPA,NARC_mmodel_papa_nsbtx }, 
	{ MAMA,NARC_mmodel_mama_nsbtx }, 
	{ SEVEN1,NARC_mmodel_seven1_nsbtx }, 
	{ SEVEN2,NARC_mmodel_seven2_nsbtx }, 
	{ SEVEN3,NARC_mmodel_seven3_nsbtx }, 
	{ SEVEN4,NARC_mmodel_seven4_nsbtx }, 
	{ SEVEN5,NARC_mmodel_seven5_nsbtx }, 
	{ SEVEN6,NARC_mmodel_seven6_nsbtx }, 
	{ SEVEN7,NARC_mmodel_seven7_nsbtx }, 
	{ RIVEL,NARC_mmodel_rivel_nsbtx }, 
	{ BOAT,NARC_mmodel_boat_nsbtx }, 
	{ TRAIN,NARC_mmodel_train_nsbtx }, 
	{ SPPOKE1,NARC_mmodel_sppoke1_nsbtx }, 
	{ SPPOKE2,NARC_mmodel_sppoke2_nsbtx }, 
	{ SPPOKE3,NARC_mmodel_sppoke3_nsbtx }, 
	{ SPPOKE4,NARC_mmodel_sppoke4_nsbtx }, 
	{ SPPOKE5,NARC_mmodel_sppoke5_nsbtx }, 
	{ SPPOKE6,NARC_mmodel_sppoke6_nsbtx }, 
	{ SPPOKE7,NARC_mmodel_sppoke7_nsbtx }, 
	{ SPPOKE8,NARC_mmodel_sppoke8_nsbtx }, 
	{ SPPOKE9,NARC_mmodel_sppoke9_nsbtx }, 
	{ SPPOKE10,NARC_mmodel_sppoke10_nsbtx }, 
	{ SPPOKE11,NARC_mmodel_sppoke11_nsbtx }, 
	{ OBAKE,NARC_mmodel_obake_nsbtx }, 
	{ WOMAN6,NARC_mmodel_woman6_nsbtx }, 
	{ OLDMAN2,NARC_mmodel_oldman2_nsbtx }, 
	{ OLDWOMAN2,NARC_mmodel_oldwoman2_nsbtx }, 
	{ OOKIDO,NARC_mmodel_ookido_nsbtx }, 
	{ MIKAN,NARC_mmodel_mikan_nsbtx }, 
	{ SUNGLASSES,NARC_mmodel_sunglasses_nsbtx }, 
	{ TOWERBOSS,NARC_mmodel_towerboss_nsbtx }, 
	{ SNOWCOVER,NARC_mmodel_snowcover_nsbtx }, 
	{ TREECOVER,NARC_mmodel_treecover_nsbtx }, 
	{ ROCKCOVER,NARC_mmodel_rockcover_nsbtx }, 
	{ BIRD,NARC_mmodel_bird_nsbtx }, 
	{ BAG,NARC_mmodel_bag_nsbtx }, 
	{ MAID,NARC_mmodel_maid_nsbtx }, 
	{ SPHERO, NARC_mmodel_sphero_nsbtx },
	{ SPHEROINE, NARC_mmodel_spheroine_nsbtx },
	{ WATERHERO, NARC_mmodel_waterhero_nsbtx },
	{ WATERHEROINE, NARC_mmodel_waterheroine_nsbtx },
	{ SWIMHERO, NARC_mmodel_swimhero_nsbtx },
	{ SWIMHEROINE, NARC_mmodel_swimheroine_nsbtx },
	{ VENTHOLE, NARC_mmodel_venthole_nsbtx },
	
	{ OBJCODEMAX, 0 },
};

#if 1	//old
const FIELD_OBJ_RESMH DATA_FieldOBJ_ResmH_Tex[] =
{
	{ HERO, "data/hero.nsbtx" },
	{ BABYBOY1, "data/babyboy1.nsbtx" },
	{ BABYGIRL1, "data/babygirl1.nsbtx" },
	{ BOY1, "data/boy1.nsbtx" },
	{ BOY2, "data/boy2.nsbtx" },
	{ BOY3, "data/boy3.nsbtx" },
	{ GIRL1, "data/girl1.nsbtx" },
	{ GIRL2, "data/girl2.nsbtx" },
	{ GIRL3, "data/girl3.nsbtx" },
	{ MAN1, "data/man1.nsbtx" },
	{ MAN2, "data/man2.nsbtx" },
	{ MAN3, "data/man3.nsbtx" },
	{ WOMAN1, "data/woman1.nsbtx" },
	{ WOMAN2, "data/woman2.nsbtx" },
	{ WOMAN3, "data/woman3.nsbtx" },
	{ MIDDLEMAN1, "data/middleman1.nsbtx" },
	{ MIDDLEWOMAN1, "data/middlewoman1.nsbtx" },
	{ OLDMAN1, "data/oldman1.nsbtx" },
	{ OLDWOMAN1, "data/oldwoman1.nsbtx" },
	{ BIGMAN, "data/bigman.nsbtx" },
	{ MOUNT, "data/mount.nsbtx" },
	{ CYCLEHERO, "data/cyclehero.nsbtx" },
	{ REPORTER, "data/reporter.nsbtx" },
	{ CAMERAMAN,"data/cameraman.nsbtx"  },
	{ SHOPM1, "data/shopm1.nsbtx" },
	{ SHOPW1, "data/shopw1.nsbtx" },
	{ PCWOMAN1, "data/pcwoman1.nsbtx" },
	{ PCWOMAN2, "data/pcwoman2.nsbtx" },
	{ PCWOMAN3, "data/pcwoman3.nsbtx" },
	{ ASSISTANTM, "data/assistantm.nsbtx" },
	{ ASSISTANTW, "data/assistantw.nsbtx" },
	{ BADMAN, "data/badman.nsbtx" },
	{ SKIERM,"data/skierm.nsbtx"  },
	{ SKIERW, "data/skierw.nsbtx" },
	{ POLICEMAN, "data/policeman.nsbtx" },
	{ IDOL, "data/idol.nsbtx" },
	{ GENTLEMAN, "data/gentleman.nsbtx" },
	{ LADY, "data/lady.nsbtx" },
	{ CYCLEM, "data/cyclem.nsbtx" },
	{ CYCLEW, "data/cyclew.nsbtx" },
	{ WORKMAN, "data/workman.nsbtx" },
	{ FARMER, "data/farmer.nsbtx" },
	{ COWGIRL, "data/cowgirl.nsbtx" },
	{ CLOWN, "data/clown.nsbtx" },
	{ ARTIST, "data/artist.nsbtx" },
	{ SPORTSMAN, "data/sportsman.nsbtx" },
	{ SWIMMERM,"data/swimmerm.nsbtx"  },
	{ SWIMMERW, "data/swimmerw.nsbtx" },
	{ BEACHGIRL, "data/beachgirl.nsbtx" },
	{ BEACHBOY, "data/beachboy.nsbtx" },
	{ EXPLORE, "data/explore.nsbtx" },
	{ FIGHTER, "data/fighter.nsbtx" },
	{ CAMPBOY, "data/campboy.nsbtx" },
	{ PICNICGIRL, "data/picnicgirl.nsbtx" },
	{ FISHING, "data/fishing.nsbtx" },
	{ AMBRELLA, "data/ambrella.nsbtx" },
	{ SEAMAN,"data/seaman.nsbtx"  },
	{ BRINGM, "data/bringm.nsbtx" },
	{ BRINGW, "data/bringw.nsbtx" },
	{ WAITER, "data/waiter.nsbtx" },
	{ WAITRESS, "data/waitress.nsbtx" },
	{ VETERAN, "data/veteran.nsbtx" },
	{ GORGGEOUSM, "data/gorggeousm.nsbtx" },
	{ GORGGEOUSW, "data/gorggeousw.nsbtx" },
	{ BOY4,"data/boy4.nsbtx"  },
	{ GIRL4, "data/girl4.nsbtx" },
	{ MAN4, "data/man4.nsbtx" },
	{ WOMAN4,"data/woman4.nsbtx"  },
	{ MAN5, "data/man5.nsbtx" },
	{ WOMAN5, "data/woman5.nsbtx" },
	{ MYSTERY, "data/mystery.nsbtx" },
	{ PIKACHU, "data/pikachu.nsbtx" },
	{ PIPPI,"data/pippi.nsbtx"  },
	{ PURIN, "data/purin.nsbtx" },
	{ KODUCK, "data/koduck.nsbtx" },
	{ PRASLE, "data/prasle.nsbtx" },
	{ MINUN, "data/minun.nsbtx" },
	{ MARIL,"data/maril.nsbtx"  },
	{ ACHAMO, "data/achamo.nsbtx" },
	{ ENECO,"data/eneco.nsbtx"  },
	{ GONBE, "data/gonbe.nsbtx" },
	{ BABY, "data/baby.nsbtx" },
	{ MIDDLEMAN2, "data/middleman2.nsbtx" },
	{ MIDDLEWOMAN2,"data/middlewoman2.nsbtx"  },
	{ ROCK, "data/rock.nsbtx" },
	{ BREAKROCK, "data/breakrock.nsbtx" },
	{ TREE, "data/tree.nsbtx" },
	{ MONATERBALL, "data/monaterball.nsbtx" },
	{ SHADOW, "data/shadow.nsbtx" },
	{ BOUGH, "data/bough.nsbtx" },
	{ FALLTREE, "data/falltree.nsbtx" },
	{ HEROINE, "data/heroine.nsbtx" },
	{ CYCLEHEROINE, "data/cycleheroine.nsbtx" },
	{ DOCTOR, "data/doctor.nsbtx" },
	{ SEED_00, "data/seed00_a.nsbtx" },
	{ SEED_01A, "data/seed01_a.nsbtx" },
	{ SEED_01B, "data/seed01_b.nsbtx" },
	{ SEED_01C, "data/seed01_c.nsbtx" },
	{ GINGABOSS,"data/gingaboss.nsbtx" }, 
	{ GKANBU1,"data/gkanbu1.nsbtx" }, 
	{ GKANBU2,"data/gkanbu2.nsbtx" }, 
	{ GKANBU3,"data/gkanbu3.nsbtx" }, 
	{ GINGAM,"data/gingam.nsbtx" }, 
	{ GINGAW,"data/gingaw.nsbtx" }, 
	{ LEADER1,"data/leader1.nsbtx" }, 
	{ LEADER2,"data/leader2.nsbtx" }, 
	{ LEADER3,"data/leader3.nsbtx" }, 
	{ LEADER4,"data/leader4.nsbtx" }, 
	{ LEADER5,"data/leader5.nsbtx" }, 
	{ LEADER6,"data/leader6.nsbtx" }, 
	{ LEADER7,"data/leader7.nsbtx" }, 
	{ LEADER8,"data/leader8.nsbtx" }, 
	{ BIGFOUR1,"data/bigfour1.nsbtx" }, 
	{ BIGFOUR2,"data/bigfour2.nsbtx" }, 
	{ BIGFOUR3,"data/bigfour3.nsbtx" }, 
	{ BIGFOUR4,"data/bigfour4.nsbtx" }, 
	{ CHAMPION,"data/champion.nsbtx" }, 
	{ PAPA,"data/papa.nsbtx" }, 
	{ MAMA,"data/mama.nsbtx" }, 
	{ SEVEN1,"data/seven1.nsbtx" }, 
	{ SEVEN2,"data/seven2.nsbtx" }, 
	{ SEVEN3,"data/seven3.nsbtx" }, 
	{ SEVEN4,"data/seven4.nsbtx" }, 
	{ SEVEN5,"data/seven5.nsbtx" }, 
	{ SEVEN6,"data/seven6.nsbtx" }, 
	{ SEVEN7,"data/seven7.nsbtx" }, 
	{ RIVEL,"data/rivel.nsbtx" }, 
	{ BOAT,"data/boat.nsbtx" }, 
	{ TRAIN,"data/train.nsbtx" }, 
	{ SPPOKE1,"data/sppoke1.nsbtx" }, 
	{ SPPOKE2,"data/sppoke2.nsbtx" }, 
	{ SPPOKE3,"data/sppoke3.nsbtx" }, 
	{ SPPOKE4,"data/sppoke4.nsbtx" }, 
	{ SPPOKE5,"data/sppoke5.nsbtx" }, 
	{ SPPOKE6,"data/sppoke6.nsbtx" }, 
	{ SPPOKE7,"data/sppoke7.nsbtx" }, 
	{ SPPOKE8,"data/sppoke8.nsbtx" }, 
	{ SPPOKE9,"data/sppoke9.nsbtx" }, 
	{ SPPOKE10,"data/sppoke10.nsbtx" }, 
	{ SPPOKE11,"data/sppoke11.nsbtx" }, 
	{ OBAKE,"data/obake.nsbtx" }, 
	{ WOMAN6,"data/woman6.nsbtx" }, 
	{ OLDMAN2,"data/oldman2.nsbtx" }, 
	{ OLDWOMAN2,"data/oldwoman2.nsbtx" }, 
	{ OOKIDO,"data/ookido.nsbtx" }, 
	{ MIKAN,"data/mikan.nsbtx" }, 
	{ SUNGLASSES,"data/sunglasses.nsbtx" }, 
	{ TOWERBOSS,"data/towerboss.nsbtx" }, 
	{ SNOWCOVER,"data/snowcover.nsbtx" }, 
	{ TREECOVER,"data/treecover.nsbtx" }, 
	{ ROCKCOVER,"data/rockcover.nsbtx" }, 
	{ BIRD,"data/rockcover.nsbtx" }, 
	{ BAG,"data/rockcover.nsbtx" }, 
	{ MAID,"data/rockcover.nsbtx" }, 
	
	{ OBJCODEMAX, NULL },
};
#endif

//==============================================================================
//	tB[hOBJ f܂Ƃ
//==============================================================================
//--------------------------------------------------------------
///	fID,pXe[uB
///	т͕s
//--------------------------------------------------------------
const FIELD_OBJ_RESMNARC DATA_FieldOBJ_ResmNArcTbl_Mdl[] =
{
	{ BLACT_MDLID_32x32,NARC_mmodel_billboad_nsbmd },
	{ BLACT_MDLID_16x16, NARC_mmodel_rock_nsbmd },
	{ BLACT_MDLID_16x16_1, NARC_mmodel_breakrock_nsbmd },
	{ BLACT_MDLID_SEED_ME, NARC_mmodel_seed00_a_nsbmd },
	{ BLACT_MDLID_SEED, NARC_mmodel_seed01_a_nsbmd },
	{ BLACT_MDLID_MAX, 0 },
};

#if 1	//old
const FIELD_OBJ_RESMH DATA_FieldOBJ_ResmH_Mdl[] =
{
	{ BLACT_MDLID_32x32,"data/billboad.nsbmd" },
	{ BLACT_MDLID_16x16, "data/rock.nsbmd" },
	{ BLACT_MDLID_16x16_1, "data/breakrock.nsbmd" },
	{ BLACT_MDLID_SEED_ME, "data/seed00_a.nsbmd" },
	{ BLACT_MDLID_SEED, "data/seed01_a.nsbmd" },
	{ BLACT_MDLID_MAX, NULL },
};
#endif

//==============================================================================
//	tB[hOBJ Aj܂Ƃ
//==============================================================================
//--------------------------------------------------------------
///	AjID,pXe[uB
///	т͕s
//--------------------------------------------------------------
const FIELD_OBJ_RESMH DATA_FieldOBJ_ResmH_Anm[] =
{
	{ BLACT_ANMID_NORMAL_0, "data/charaobj_itpconv.dat" },
	{ BLACT_ANMID_HERO_0, "data/hero1_itpconv.dat" },
	{ BLACT_ANMID_SEED, "data/seed00_a_itpconv.dat" },
	{ BLACT_ANMID_HEROCYCLE_0, "data/cyclehero_itpconv.dat" },
	{ BLACT_ANMID_SPHERO, "data/sphero_itpconv.dat" },
	{ BLACT_ANMID_WATERHERO, "data/waterhero_itpconv.dat" },
	{ BLACT_ANMID_SWIMHERO, "data/swimhero_itpconv.dat" },
	{ BLACT_ANMID_BIRD,	"data/bird_itpconv.dat" },
	
	{ BLACT_ANMID_MAX, NULL },
};

//==============================================================================
//	tB[hOBJ Aj[Ve[u
//==============================================================================
//--------------------------------------------------------------
///	@
//--------------------------------------------------------------
static const BLACT_ANIME_TBL DATA_FieldOBJ_BlActAnmTbl_Hero[] =
{
	{ 0, 15, BLACT_ANIM_LOOP },
	{ 16, 31, BLACT_ANIM_LOOP },
	{ 32, 47, BLACT_ANIM_LOOP },
	{ 48, 63, BLACT_ANIM_LOOP },
	{ 64, 79, BLACT_ANIM_LOOP },
	{ 80, 95, BLACT_ANIM_LOOP },
	{ 96, 111, BLACT_ANIM_LOOP },
	{ 112, 127, BLACT_ANIM_LOOP },
	
	{ 0, 0, BLACT_ANIM_CMD_MAX },
};

//--------------------------------------------------------------
///	@]
//--------------------------------------------------------------
static const BLACT_ANIME_TBL DATA_FieldOBJ_BlActAnmTbl_HeroCycle[] =
{
	{ 0, 15, BLACT_ANIM_LOOP },
	{ 16, 31, BLACT_ANIM_LOOP },
	{ 32, 47, BLACT_ANIM_LOOP },
	{ 48, 63, BLACT_ANIM_LOOP },
	{ 64, 71, BLACT_ANIM_LOOP },
	{ 72, 79, BLACT_ANIM_LOOP },
	
	{ 0, 0, BLACT_ANIM_CMD_MAX },
};

//--------------------------------------------------------------
///	@g
//--------------------------------------------------------------
static const BLACT_ANIME_TBL DATA_FieldOBJ_BlActAnmTbl_SwimHero[] =
{
	{ 0, 2, BLACT_ANIM_LOOP },
	{ 3, 5, BLACT_ANIM_LOOP },
	{ 6, 9, BLACT_ANIM_LOOP },
	{ 10, 11, BLACT_ANIM_LOOP },
	
	{ 0, 0, BLACT_ANIM_CMD_MAX },
};

//--------------------------------------------------------------
///	@`Z
//--------------------------------------------------------------
static const BLACT_ANIME_TBL DATA_FieldOBJ_BlActAnmTbl_SpHero[] =
{
	{ 0, 10, BLACT_ANIM_END },
	{ 0, 0, BLACT_ANIM_CMD_MAX },
};

//--------------------------------------------------------------
///	@
//--------------------------------------------------------------
static const BLACT_ANIME_TBL DATA_FieldOBJ_BlActAnmTbl_WaterHero[] =
{
	{ 0, 15, BLACT_ANIM_LOOP },
	{ 16, 28, BLACT_ANIM_LOOP },
	{ 0, 0, BLACT_ANIM_CMD_MAX },
};

//--------------------------------------------------------------
///	l 0
//--------------------------------------------------------------
static const BLACT_ANIME_TBL DATA_FieldOBJ_BlActAnmTbl_Normal0[] =
{
	{ 0, 15, BLACT_ANIM_LOOP },
	{ 16, 31, BLACT_ANIM_LOOP },
	{ 32, 47, BLACT_ANIM_LOOP },
	{ 48, 63, BLACT_ANIM_LOOP },
	{ 0, 0, BLACT_ANIM_CMD_MAX },
};

//--------------------------------------------------------------
///	؂̎
//--------------------------------------------------------------
static const BLACT_ANIME_TBL DATA_FieldOBJ_BlActAnmTbl_Seed0[] =
{
	{ 0, 60, BLACT_ANIM_LOOP },
	{ 0, 0, BLACT_ANIM_CMD_MAX },
};

//--------------------------------------------------------------
///	
//--------------------------------------------------------------
static const BLACT_ANIME_TBL DATA_FieldOBJ_BlActAnmTbl_Bird[] =
{
	{ 0, 7, BLACT_ANIM_LOOP },
	{ 8, 16, BLACT_ANIM_LOOP },
	{ 0, 0, BLACT_ANIM_CMD_MAX },
};

//==============================================================================
//	tB[hOBJ \[XID܂Ƃ
//==============================================================================

//==============================================================================
//	tB[hOBJ M[
//==============================================================================
//--------------------------------------------------------------
///	eNX`@M[
//--------------------------------------------------------------
const int DATA_FieldOBJ_Regular_Tex[] =
{
	BABYBOY1,
	BABYGIRL1,
	BOY1,
	BOY2,
	BOY3,
	GIRL1,
	GIRL2,
	GIRL3,
	MAN1,
	MAN2,
	MAN3,
	WOMAN1,
	WOMAN2,
	WOMAN3,
	MIDDLEMAN1,
	MIDDLEWOMAN1,
	OLDMAN1,
	OLDWOMAN1,
	BIGMAN,
	MOUNT,
	
	OBJCODEMAX,
};

//--------------------------------------------------------------
///	f@M[
//--------------------------------------------------------------
const int DATA_FieldOBJ_Regular_Mdl[] =
{
	BLACT_MDLID_32x32,
	BLACT_MDLID_16x16,
	BLACT_MDLID_16x16_1,
	BLACT_MDLID_MAX,
};

//--------------------------------------------------------------
///	Aj@M[
//--------------------------------------------------------------
const int DATA_FieldOBJ_Regular_Anm[] =
{
	BLACT_ANMID_NORMAL_0,
	BLACT_ANMID_HERO_0,
	BLACT_ANMID_HEROCYCLE_0,
	BLACT_ANMID_MAX,
};

//==============================================================================
//	tB[hOBJ r{[hAN^[wb_[
//==============================================================================
//--------------------------------------------------------------
///	tB[hOBJ@r{[hwb_[pXAIDe[u
///	тfieldobj_code.h \R[hɏ߂Bs
//--------------------------------------------------------------
const FIELD_OBJ_BLACT_HEADER_ID DATA_FieldOBJ_BlActHeaderPathIDTbl[] =
{
	{HERO,BLACT_MDLID_32x32,BLACT_ANMID_HERO_0,DATA_FieldOBJ_BlActAnmTbl_Hero},
    {BABYBOY1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {BABYGIRL1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {BOY1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {BOY2,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {BOY3,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {GIRL1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {GIRL2,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {GIRL3,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {MAN1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {MAN2,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {MAN3,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {WOMAN1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {WOMAN2,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {WOMAN3,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {MIDDLEMAN1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {MIDDLEWOMAN1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {OLDMAN1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {OLDWOMAN1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {BIGMAN,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {MOUNT,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
    {CYCLEHERO,BLACT_MDLID_32x32,BLACT_ANMID_HEROCYCLE_0,DATA_FieldOBJ_BlActAnmTbl_HeroCycle},
	{REPORTER,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{CAMERAMAN,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SHOPM1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SHOPW1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{PCWOMAN1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{PCWOMAN2,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{PCWOMAN3,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{ASSISTANTM,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{ASSISTANTW,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{BADMAN,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SKIERM,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SKIERW,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{POLICEMAN,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{IDOL,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{GENTLEMAN,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{LADY,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{CYCLEM,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{CYCLEW,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{WORKMAN,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{FARMER,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{COWGIRL,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{CLOWN,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{ARTIST,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SPORTSMAN,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SWIMMERM,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SWIMMERW,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{BEACHGIRL,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{BEACHBOY,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{EXPLORE,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{FIGHTER,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{CAMPBOY,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{PICNICGIRL,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{FISHING,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{AMBRELLA,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SEAMAN,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{BRINGM,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{BRINGW,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{WAITER,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{WAITRESS,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{VETERAN,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{GORGGEOUSM,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{GORGGEOUSW,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{BOY4,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{GIRL4,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{MAN4,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{WOMAN4,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{MAN5,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{WOMAN5,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{MYSTERY,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{PIKACHU,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{PIPPI,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{PURIN,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{KODUCK,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{PRASLE,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{MINUN,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{MARIL,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{ACHAMO,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{ENECO,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{GONBE,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{BABY,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{MIDDLEMAN2,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{MIDDLEWOMAN2,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{ROCK,BLACT_MDLID_16x16,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{BREAKROCK,BLACT_MDLID_16x16_1,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{TREE,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{MONATERBALL,BLACT_MDLID_16x16,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SHADOW,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{BOUGH,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{FALLTREE,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{HEROINE,BLACT_MDLID_32x32,BLACT_ANMID_HERO_0,DATA_FieldOBJ_BlActAnmTbl_Hero},
    {CYCLEHEROINE,BLACT_MDLID_32x32,BLACT_ANMID_HEROCYCLE_0,DATA_FieldOBJ_BlActAnmTbl_HeroCycle},
	{DOCTOR,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SEED_00,BLACT_MDLID_SEED_ME,BLACT_ANMID_SEED,DATA_FieldOBJ_BlActAnmTbl_Seed0},
	{SEED_01A,BLACT_MDLID_SEED,BLACT_ANMID_SEED,DATA_FieldOBJ_BlActAnmTbl_Seed0},
	{SEED_01B,BLACT_MDLID_SEED,BLACT_ANMID_SEED,DATA_FieldOBJ_BlActAnmTbl_Seed0},
	{SEED_01C,BLACT_MDLID_SEED,BLACT_ANMID_SEED,DATA_FieldOBJ_BlActAnmTbl_Seed0},
	{GINGABOSS,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{GKANBU1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{GKANBU2,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{GKANBU3,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{GINGAM,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{GINGAW,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{LEADER1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{LEADER2,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{LEADER3,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{LEADER4,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{LEADER5,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{LEADER6,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{LEADER7,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{LEADER8,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{BIGFOUR1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{BIGFOUR2,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{BIGFOUR3,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{BIGFOUR4,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{CHAMPION,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{PAPA,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{MAMA,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SEVEN1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SEVEN2,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SEVEN3,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SEVEN4,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SEVEN5,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SEVEN6,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SEVEN7,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{RIVEL,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{BOAT,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{TRAIN,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SPPOKE1,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SPPOKE2,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SPPOKE3,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SPPOKE4,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SPPOKE5,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SPPOKE6,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SPPOKE7,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SPPOKE8,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SPPOKE9,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SPPOKE10,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SPPOKE11,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{OBAKE,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{WOMAN6,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{OLDMAN2,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{OLDWOMAN2,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{OOKIDO,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{MIKAN,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SUNGLASSES,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{TOWERBOSS,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SNOWCOVER,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{TREECOVER,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{ROCKCOVER,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{BIRD,BLACT_MDLID_32x32,BLACT_ANMID_BIRD,DATA_FieldOBJ_BlActAnmTbl_Bird},
	{BAG,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{MAID,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	{SPHERO,BLACT_MDLID_32x32,BLACT_ANMID_SPHERO,DATA_FieldOBJ_BlActAnmTbl_SpHero },
	{SPHEROINE,BLACT_MDLID_32x32,BLACT_ANMID_SPHERO,DATA_FieldOBJ_BlActAnmTbl_SpHero},
	{SWIMHERO,BLACT_MDLID_32x32,BLACT_ANMID_SWIMHERO,DATA_FieldOBJ_BlActAnmTbl_SwimHero},
	{SWIMHEROINE,BLACT_MDLID_32x32,BLACT_ANMID_SWIMHERO,DATA_FieldOBJ_BlActAnmTbl_SwimHero},
	{WATERHERO,BLACT_MDLID_32x32,BLACT_ANMID_WATERHERO,DATA_FieldOBJ_BlActAnmTbl_WaterHero},
	{WATERHEROINE,BLACT_MDLID_32x32,BLACT_ANMID_WATERHERO,DATA_FieldOBJ_BlActAnmTbl_WaterHero},
	{VENTHOLE,BLACT_MDLID_32x32,BLACT_ANMID_NORMAL_0,DATA_FieldOBJ_BlActAnmTbl_Normal0},
	
	{OBJCODEMAX,BLACT_MDLID_MAX,BLACT_ANMID_MAX,NULL},
};

