//******************************************************************************
/**
 *
 * @file	fieldobj_move.c
 * @brief	tB[hOBJ n
 * @author	kagaya
 * @data	05.07.25
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "map_tool.h"
#include "fieldobj.h"
#include "field_effect.h"

//==============================================================================
//	define
//==============================================================================
//#define DEBUG_FLDOBJ_MOVE_SUB_TEST	//TueXg
#ifdef DEBUG_FLDOBJ_MOVE_SUB_TEST
#define DEBUG_MOVE_SUB_TYPE (EV_TYPE_TRAINER_SPIN_MOVE_L)
#define DEBUG_MOVE_SUB_PARAM (2)
#endif

//==============================================================================
//	vg^Cv
//==============================================================================
static void FldOBJ_MoveBeforeHeight( FIELD_OBJ_PTR fldobj );
static void FldOBJ_MoveStartFirst( FIELD_OBJ_PTR fldobj );
static void FldOBJ_MoveStartSecond( FIELD_OBJ_PTR fldobj );
static void FldOBJ_MoveEnd( FIELD_OBJ_PTR fldobj );

static void FldOBJ_MapAttrSet( FIELD_OBJ_PTR fldobj );
static void FldOBJ_MapAttrProc_MoveStartFirst( FIELD_OBJ_PTR fldobj );
static void FldOBJ_MapAttrProc_MoveStartSecond( FIELD_OBJ_PTR fldobj );
static void FldOBJ_MapAttrProc_MoveEnd( FIELD_OBJ_PTR fldobj );

static void FldOBJ_MapAttrGrassProc_0( FIELD_OBJ_PTR fldobj, MATR now, MATR old );
static void FldOBJ_MapAttrGrassProc_1( FIELD_OBJ_PTR fldobj, MATR now, MATR old );

static void FldOBJ_MapAttrFootMarkProc_1( FIELD_OBJ_PTR fldobj, MATR now, MATR old );

static void FldOBJ_MapAttrSplashProc_1( FIELD_OBJ_PTR fldobj, MATR now, MATR old );

static void FldOBJ_MapAttrShadowProc_0( FIELD_OBJ_PTR fldobj, MATR now, MATR old );
static void FldOBJ_MapAttrShadowProc_1( FIELD_OBJ_PTR fldobj, MATR now, MATR old );

//==============================================================================
//	tB[hOBJ 
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hOBJ 쏉
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveInit( FIELD_OBJ_PTR fldobj )
{
#ifdef DEBUG_FLDOBJ_MOVE_SUB_TEST
	{
		if( FieldOBJ_MoveCodeGet(fldobj) == MV_RT2 ){
			FieldOBJ_EventTypeSet( fldobj, DEBUG_MOVE_SUB_TYPE );
			FieldOBJ_ParamSet( fldobj, DEBUG_MOVE_SUB_PARAM, FLDOBJ_PARAM_1 );
		}
	}
#endif
	
	FieldOBJ_MoveInitProcCall( fldobj );
	FieldOBJ_MoveSubProcInit( fldobj );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_Move( FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_FieldOBJSysStatusBitCheck(fldobj,FLDOBJSYS_STA_BIT_MOVE_PROC_STOP) ){
		return;
	}
	
	FldOBJ_MoveBeforeHeight( fldobj );
	FldOBJ_MoveStartFirst( fldobj );
	
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_ACMD) ){
		FieldOBJ_AcmdAction( fldobj );
	}else if( FieldOBJ_MovePauseCheck(fldobj) == FALSE ){
		if( FieldOBJ_MoveSub(fldobj) == FALSE ){
			FieldOBJ_MoveProcCall( fldobj );
		}
	}
	
	FldOBJ_MoveStartSecond( fldobj );
	FldOBJ_MoveEnd( fldobj );
}

//--------------------------------------------------------------
/**
 * ړJnɍs擾
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_MoveBeforeHeight( FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_HEIGHT_GET_NEED) ){
		FieldOBJ_VecPosNowHeightGetSet( fldobj );
		
		if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_HEIGHT_GET_NOT) == 0 ){
			FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_HEIGHT_GET_NEED );
		}
	}
}

//--------------------------------------------------------------
/**
 * ړJnŔ@1st
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_MoveStartFirst( FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_MOVE_START) ){
		FldOBJ_MapAttrProc_MoveStartFirst( fldobj );
	}
	
	FieldOBJ_StatusBit_OFF( fldobj,
		FLDOBJ_STA_BIT_MOVE_START | FLDOBJ_STA_BIT_JUMP_START );
}

//--------------------------------------------------------------
/**
 * ړJnŔ@2nd
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_MoveStartSecond( FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_MOVE_START) ){
		FldOBJ_MapAttrProc_MoveStartSecond( fldobj );
	}
	
	FieldOBJ_StatusBit_OFF( fldobj,
		FLDOBJ_STA_BIT_MOVE_START | FLDOBJ_STA_BIT_JUMP_START );
}

//--------------------------------------------------------------
/**
 * IŔ
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_MoveEnd( FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_MOVE_END) ){
		FldOBJ_MapAttrProc_MoveEnd( fldobj );
	}
	
	FieldOBJ_StatusBit_OFF( fldobj,
		FLDOBJ_STA_BIT_MOVE_END | FLDOBJ_STA_BIT_JUMP_END );
}

//==============================================================================
//	}bvAgr[g
//==============================================================================
//--------------------------------------------------------------
/**
 * }bvAgr[gZbg
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_MapAttrSet( FIELD_OBJ_PTR fldobj )
{
	int gx = FieldOBJ_OldPosGX_Get( fldobj );
	int gz = FieldOBJ_OldPosGZ_Get( fldobj );
	FIELDSYS_WORK *fsys = FieldOBJ_FieldSysWorkGet( fldobj );
	MATR attr = GetAttributeLSB( fsys, gx, gz );
	FieldOBJ_OldMapAttrSet( fldobj, attr );
	
	gx = FieldOBJ_NowPosGX_Get( fldobj );
	gz = FieldOBJ_NowPosGZ_Get( fldobj );
	attr = GetAttributeLSB( fsys, gx, gz );
	FieldOBJ_NowMapAttrSet( fldobj, attr );
}

//--------------------------------------------------------------
/**
 * JnŔAgr[g 1st
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_MapAttrProc_MoveStartFirst( FIELD_OBJ_PTR fldobj )
{
	FldOBJ_MapAttrSet( fldobj );
	
	if( FieldOBJ_StatusBit_DrawInitCompCheck(fldobj) == TRUE ){
		MATR now = FieldOBJ_NowMapAttrGet( fldobj );
		MATR old = FieldOBJ_OldMapAttrGet( fldobj );
		FldOBJ_MapAttrGrassProc_0( fldobj, now, old );
		FldOBJ_MapAttrShadowProc_0( fldobj, now, old );
	}
}

//--------------------------------------------------------------
/**
 * JnŔAgr[g 2nd
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_MapAttrProc_MoveStartSecond( FIELD_OBJ_PTR fldobj )
{
	FldOBJ_MapAttrSet( fldobj );
	
	if( FieldOBJ_StatusBit_DrawInitCompCheck(fldobj) == TRUE ){
		MATR now = FieldOBJ_NowMapAttrGet( fldobj );
		MATR old = FieldOBJ_OldMapAttrGet( fldobj );
		FldOBJ_MapAttrGrassProc_1( fldobj, now, old );
		FldOBJ_MapAttrFootMarkProc_1( fldobj, now, old );
		FldOBJ_MapAttrSplashProc_1( fldobj, now, old );
		FldOBJ_MapAttrShadowProc_1( fldobj, now, old );
	}
}

//--------------------------------------------------------------
/**
 * IŔAgr[g@end
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_MapAttrProc_MoveEnd( FIELD_OBJ_PTR fldobj )
{
	FldOBJ_MapAttrSet( fldobj );
	
	if( FieldOBJ_StatusBit_DrawInitCompCheck(fldobj) == TRUE ){
		MATR now = FieldOBJ_NowMapAttrGet( fldobj );
		MATR old = FieldOBJ_OldMapAttrGet( fldobj );
		//Ĩ}bvAgr[g֘A
	}
}

//==============================================================================
//	Agr[g@
//==============================================================================
//--------------------------------------------------------------
/**
 * @Jn 0
 * @param	fldobj		FIELD_OBJ_PTR
 * @param	now			݂̃Agr[g
 * @param	old			ߋ̃Agr[g
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_MapAttrGrassProc_0( FIELD_OBJ_PTR fldobj, MATR now, MATR old )
{
	if( MATR_IsGrass(now) == TRUE ){
		FE_FldOBJGrass_Add( fldobj, FALSE );
	}
}

//--------------------------------------------------------------
/**
 * @Jn 1
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	now			݂̃Agr[g
 * @param	old			ߋ̃Agr[g
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_MapAttrGrassProc_1( FIELD_OBJ_PTR fldobj, MATR now, MATR old )
{
	if( MATR_IsGrass(now) == TRUE ){
		FE_FldOBJGrass_Add( fldobj, TRUE );
	}
}

//==============================================================================
//	Agr[g@
//==============================================================================
//--------------------------------------------------------------
/**
 * Ձ@Jn 1
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	now		݂̃Agr[g
 * @param	old		ߋ̃Agr[g
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_MapAttrFootMarkProc_1( FIELD_OBJ_PTR fldobj, MATR now, MATR old )
{
	if( MATR_IsSand(now) == TRUE ){
		FE_FldOBJFootMark_Add( fldobj );
	}
}

//==============================================================================
//	Agr[g@
//==============================================================================
//--------------------------------------------------------------
/**
 * 򖗁@Jn 1
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	now		݂̃Agr[g
 * @param	old		ߋ̃Agr[g
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_MapAttrSplashProc_1( FIELD_OBJ_PTR fldobj, MATR now, MATR old )
{
	if( MATR_IsShoal(now) == TRUE ){
		FE_FldOBJSplash_Add( fldobj );
	}
}

//==============================================================================
///	Agr[g@e
//==============================================================================
//--------------------------------------------------------------
/**
 * e@Jn 0
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	now		݂̃Agr[g
 * @param	old		ߋ̃Agr[g
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_MapAttrShadowProc_0( FIELD_OBJ_PTR fldobj, MATR now, MATR old )
{
	{
		CONST_FIELD_OBJ_SYS_PTR fos = FieldOBJ_FieldOBJSysGet( fldobj );
		
		if( FieldOBJSys_ShadowJoinCheck(fos) == FALSE ){
			return;
		}
	}
	
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_SHADOW_SET) == 0 ){
		int code = FieldOBJ_OBJCodeGet( fldobj );
		
		switch( code ){
		case SEED:
		case BOARD_A:case BOARD_B:case BOARD_C:case BOARD_D:	//etȂR[h 
		case BOARD_E:case BOARD_F:
		case SNOWBALL:
			break;
		default:
			FE_FldOBJShadow_Add( fldobj );
			FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_SHADOW_SET );
		}
	}
	
	FldOBJ_MapAttrShadowProc_1( fldobj, now, old );
}

//--------------------------------------------------------------
/**
 * e@Jn 1
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	now		݂̃Agr[g
 * @param	old		ߋ̃Agr[g
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_MapAttrShadowProc_1( FIELD_OBJ_PTR fldobj, MATR now, MATR old )
{
	{
		CONST_FIELD_OBJ_SYS_PTR fos = FieldOBJ_FieldOBJSysGet( fldobj );
		
		if( FieldOBJSys_ShadowJoinCheck(fos) == FALSE ){
			return;
		}
	}
	
	if( MATR_IsGrass(now) == TRUE ||
		MATR_IsWater(now) == TRUE ||
		MATR_IsShoal(now) == TRUE ){
		FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_SHADOW_VANISH );
	}else{
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_SHADOW_VANISH );
	}
}

//==============================================================================
//	W`FbN
//==============================================================================
//--------------------------------------------------------------
/**
 * wWQ`FbN
 * @param	fos		FIELD_OBJ_SYS_PTR 
 * @param	x		`FbNXW	Obh
 * @param	z		`FbNZW	Obh
 * @retval	u32		qbgrbgBFLDOBJ_MOVE_HIT_BIT_LIM
 */
//--------------------------------------------------------------
u32 FieldOBJ_PosHitCheck( CONST_FIELD_OBJ_SYS_PTR fos, int x, int z )
{
	u32 ret;
	
	ret = FLDOBJ_MOVE_HIT_BIT_NON;
	
	if(	GetHitAttr(FieldOBJSys_FieldSysWorkGet(fos),x,z) == TRUE ){
		ret |= FLDOBJ_MOVE_HIT_BIT_ATTR;
	}
	
	if( FieldOBJ_SearchGPos(fos,x,z) != NULL ){
		ret |= FLDOBJ_MOVE_HIT_BIT_OBJ;
	}
	
	return( ret );
}

//--------------------------------------------------------------
/**
 * tB[hOBJړ`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	vec		ݎW
 * @param	x		ړXW	Obh
 * @param	y		ړYW
 * @param	z		ړZW	Obh
 * @retval	u32		qbgrbgBFLDOBJ_MOVE_HIT_BIT_LIM
 */
//--------------------------------------------------------------
u32 FieldOBJ_MoveHitCheck( CONST_FIELD_OBJ_PTR fldobj, const VecFx32 *vec, int x, int y, int z )
{
	u32 ret;
	
	ret = FLDOBJ_MOVE_HIT_BIT_NON;
	
	if( FieldOBJ_MoveHitCheckLimit(fldobj,x,y,z) == TRUE ){
		ret |= FLDOBJ_MOVE_HIT_BIT_LIM;
	}
	
	{
		s8 flag;
		FIELDSYS_WORK *fsys = FieldOBJ_FieldSysWorkGet( fldobj );
		
		if( MPTL_CheckHitWall(fsys,vec,x,z,&flag) == TRUE ){
			ret |= FLDOBJ_MOVE_HIT_BIT_ATTR;
			
			if( flag != HIT_RES_EQUAL ){
				ret |= FLDOBJ_MOVE_HIT_BIT_HEIGHT;
			}
		}
	}
	
	if( FieldOBJ_MoveHitCheckFellow(fldobj,x,y,z) == TRUE ){
		ret |= FLDOBJ_MOVE_HIT_BIT_OBJ;
	}
	
	return( ret );
}

//--------------------------------------------------------------
/**
 * tB[hOBJړ`FbN@݈ʒu画
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	x		ړXW	Obh
 * @param	y		ړXW
 * @param	z		ړXW	Obh
 * @retval	u32		qbgrbgBFLDOBJ_MOVE_HIT_BIT_LIM
 */
//--------------------------------------------------------------
u32 FieldOBJ_MoveHitCheckNow( CONST_FIELD_OBJ_PTR fldobj, int x, int y, int z )
{
	VecFx32 vec;
	
	FieldOBJ_VecPosGet( fldobj, &vec );
	return( FieldOBJ_MoveHitCheck(fldobj,&vec,x,y,z) );
}

//--------------------------------------------------------------
/**
 * tB[hOBJړ`FbN@݈ʒu+
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	dir		ړBDIR_UP
 * @retval	u32		qbgrbgBFLDOBJ_MOVE_HIT_BIT_LIM
 */
//--------------------------------------------------------------
u32 FieldOBJ_MoveHitCheckDir( CONST_FIELD_OBJ_PTR fldobj, int dir )
{
	int x,y,z;
	
	x = FieldOBJ_NowPosGX_Get( fldobj ) + FieldOBJ_DirAddValueGX( dir );
	y = FieldOBJ_NowPosGY_Get( fldobj );
	z = FieldOBJ_NowPosGZ_Get( fldobj ) + FieldOBJ_DirAddValueGZ( dir );
	
	return( FieldOBJ_MoveHitCheckNow(fldobj,x,y,z) );
}

//--------------------------------------------------------------
/**
 * tB[hOBJm̏Փ˃`FbN
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	x		ړXW	Obh
 * @param	y		ړXW	Obh
 * @param	z		ړXW	Obh
 * @retval	int		TRUE=Փ˃A
 */
//--------------------------------------------------------------
int FieldOBJ_MoveHitCheckFellow( CONST_FIELD_OBJ_PTR fldobj, int x, int y, int z )
{
	int max,hx,hz;
	CONST_FIELD_OBJ_SYS_PTR sys;
	CONST_FIELD_OBJ_PTR fieldobj;
	
	sys = FieldOBJ_FieldOBJSysGet( fldobj );
	fieldobj = FieldOBJSys_FieldOBJWorkGet( sys );
	max = FieldOBJSys_OBJMaxGet( sys );
	
	do{
		if( fieldobj != fldobj ){
			if( FieldOBJ_StatusBit_Check(fieldobj,FLDOBJ_STA_BIT_USE) ){
				if( FieldOBJ_StatusBit_Check(fieldobj,FLDOBJ_STA_BIT_FELLOW_HIT_NON) == 0 ){
					hx = FieldOBJ_NowPosGX_Get( fieldobj );
					hz = FieldOBJ_NowPosGZ_Get( fieldobj );
			
					if( hx == x && hz == z ){
						int hy = FieldOBJ_NowPosGY_Get( fieldobj );
						int sy = hy - y;
						if( sy < 0 ){ sy = -sy; }
						if( sy < H_GRID_FELLOW_SIZE ){
							return( TRUE );
						}
					}
			
					hx = FieldOBJ_OldPosGX_Get( fieldobj );
					hz = FieldOBJ_OldPosGZ_Get( fieldobj );
			
					if( hx == x && hz == z ){
						int hy = FieldOBJ_NowPosGY_Get( fieldobj );
						int sy = hy - y;
						if( sy < 0 ){ sy = -sy; }
						if( sy < H_GRID_FELLOW_SIZE ){
							return( TRUE );
						}
					}
				}
			}
		}
		
		FieldOBJSys_FieldOBJWorkInc( &fieldobj );
		max--;
	}while( max );
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * tB[hOBJړ`FbN
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	x		ړXW	Obh
 * @param	y		ړXW	Obh
 * @param	z		ړXW	Obh
 * @retval	int		TRUE=z
 */
//--------------------------------------------------------------
int FieldOBJ_MoveHitCheckLimit( CONST_FIELD_OBJ_PTR fldobj, int x, int y, int z )
{
	int init,limit,min,max;
	
	init = FieldOBJ_InitPosGX_Get( fldobj );
	limit = FieldOBJ_MoveLimitXGet( fldobj );
	
	if( limit != MOVE_LIMIT_NOT ){
		min = init - limit;
		max = init + limit;
	
		if( min > x || max < x ){
			return( TRUE );
		}
	}
	
	init = FieldOBJ_InitPosGZ_Get( fldobj );
	limit = FieldOBJ_MoveLimitZGet( fldobj );
	
	if( limit != MOVE_LIMIT_NOT ){
		min = init - limit;
		max = init + limit;
	
		if( min > z || max < z ){
			return( TRUE );
		}
	}
	
	return( FALSE );
}

//==============================================================================
//	ObhWړn
//==============================================================================
//--------------------------------------------------------------
///	4ʍW@X
//--------------------------------------------------------------
static const int DATA_GPosX_Dir4AddTbl[] =
{ 0, 0, -1, 1 };

//--------------------------------------------------------------
///	4ʍW@Y
//--------------------------------------------------------------
static const int DATA_GPosY_Dir4AddTbl[] =
{ 0, 0, 0, 0 };

//--------------------------------------------------------------
///	4ʍW@Z
//--------------------------------------------------------------
static const int DATA_GPosZ_Dir4AddTbl[] =
{ -1, 1, 0, 0 };

//--------------------------------------------------------------
/**
 * Xl擾
 * @param	dir		BDIR_UP
 * @retval	int		ObhPʂł̑l
 */
//--------------------------------------------------------------
int FieldOBJ_DirAddValueGX( int dir )
{
	return( DATA_GPosX_Dir4AddTbl[dir] );
}

//--------------------------------------------------------------
/**
 * Zl擾
 * @param	dir		BDIR_UP
 * @retval	int		ObhPʂł̑l
 */
//--------------------------------------------------------------
int FieldOBJ_DirAddValueGZ( int dir )
{
	return( DATA_GPosZ_Dir4AddTbl[dir] );
}

//--------------------------------------------------------------
/**
 * ŌݍWXV
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	dir			ړ
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_NowGPosDirAdd( FIELD_OBJ_PTR fldobj, int dir )
{
	FieldOBJ_OldPosGX_Set( fldobj, FieldOBJ_NowPosGX_Get(fldobj) );
	FieldOBJ_OldPosGY_Set( fldobj, FieldOBJ_NowPosGY_Get(fldobj) );
	FieldOBJ_OldPosGZ_Set( fldobj, FieldOBJ_NowPosGZ_Get(fldobj) );
	
	FieldOBJ_NowPosGX_Add( fldobj, FieldOBJ_DirAddValueGX(dir) );
	FieldOBJ_NowPosGY_Add( fldobj, 0 );
	FieldOBJ_NowPosGZ_Add( fldobj, FieldOBJ_DirAddValueGZ(dir) );
}

//--------------------------------------------------------------
/**
 * ݍWŉߋWXV
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_GPosUpdate( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_OldPosGX_Set( fldobj, FieldOBJ_NowPosGX_Get(fldobj) );
	FieldOBJ_OldPosGY_Set( fldobj, FieldOBJ_NowPosGY_Get(fldobj) );
	FieldOBJ_OldPosGZ_Set( fldobj, FieldOBJ_NowPosGZ_Get(fldobj) );
}

//--------------------------------------------------------------
/**
 * ݂̃ObhWw̃Agr[g擾
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	dir		DIR_UP
 * @retval	u32		MATR
 */
//--------------------------------------------------------------
u32 FieldOBJ_NextDirAttrGet( FIELD_OBJ_PTR fldobj, int dir )
{
	int gx = FieldOBJ_NowPosGX_Get( fldobj ) + FieldOBJ_DirAddValueGX( dir );
	int gz = FieldOBJ_NowPosGZ_Get( fldobj ) + FieldOBJ_DirAddValueGZ( dir );
	FIELDSYS_WORK *fsys = FieldOBJ_FieldSysWorkGet( fldobj );
	MATR attr = GetAttributeLSB( fsys, gx, gz );
	
	return( attr );
}

//==============================================================================
//	3DWn
//==============================================================================
//--------------------------------------------------------------
/**
 * wlwɉZ
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	dir			ړ4BDIR_UP
 * @param	val			ړ(
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_VecPosDirAdd( FIELD_OBJ_PTR fldobj, int dir, fx32 val )
{
	VecFx32 vec;
	
	FieldOBJ_VecPosGet( fldobj, &vec );
	
	switch( dir ){
	case DIR_UP:		vec.z -= val;	break;
	case DIR_DOWN:		vec.z += val;	break;
	case DIR_LEFT:		vec.x -= val;	break;
	case DIR_RIGHT:		vec.x += val;	break;
	}
	
	FieldOBJ_VecPosSet( fldobj, &vec );
}

//--------------------------------------------------------------
/**
 * ݍW獂擾Wɔf
 * FLDOBJ_STA_BIT_HEIGHT_GET_NOT̃Zbgčs
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	dir			ړ4BDIR_UP
 * @param	val			ړ(
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_VecPosNowHeightGetSet( FIELD_OBJ_PTR fldobj )
{
	VecFx32 vec_pos,vec_pos_h;
	
	FieldOBJ_VecPosGet( fldobj, &vec_pos );
	
	vec_pos_h = vec_pos;
//	vec_pos_h.z += FLDOBJ_BLACT_Z_GROUND_OFFS_FX32;
	
	if( FieldOBJ_HeightOFFCheck(fldobj) == FALSE ){
		FIELDSYS_WORK *fsys = FieldOBJ_FieldSysWorkGet( fldobj );
		int ret = FieldOBJTool_GetHeight( fsys, &vec_pos_h );
		
		if( ret == TRUE ){
			vec_pos.y = vec_pos_h.y;
			FieldOBJ_VecPosSet( fldobj, &vec_pos );
			FieldOBJ_OldPosGY_Set( fldobj, FieldOBJ_NowPosGY_Get(fldobj) );
			FieldOBJ_NowPosGY_Set( fldobj, SIZE_H_GRID_FX32(vec_pos.y) );
			FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_HEIGHT_GET_NOT );
		}else{
			FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_HEIGHT_GET_NOT );
		}
	}
}

//--------------------------------------------------------------
/**
 * wlwɉZ
 * @param	dir			ړ4BDIR_UP
 * @param	vec			Ώ
 * @param	val			ړ(
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJTool_VecPosDirAdd( int dir, VecFx32 *vec, fx32 val )
{
	switch( dir ){
	case DIR_UP:		vec->z -= val;	break;
	case DIR_DOWN:		vec->z += val;	break;
	case DIR_LEFT:		vec->x -= val;	break;
	case DIR_RIGHT:		vec->x += val;	break;
	}
}

//--------------------------------------------------------------
/**
 * w肳ꂽObhW̒SʒuWŎ擾
 * @param	gx	ObhXW	
 * @param	gz	ObhZW
 * @param	vec	Wi[
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJTool_GridCenterPosGet( int gx, int gz, VecFx32 *vec )
{
	vec->x = GRID_SIZE_FX32( gx ) + GRID_HALF_FX32;
	vec->z = GRID_SIZE_FX32( gz ) + GRID_HALF_FX32;
}

//--------------------------------------------------------------
/**
 * w肳ꂽWObhPʂɒ
 * @param	gx	ObhXWi[
 * @param	gy	ObhYWi[
 * @param	gz	ObhZWi[
 * @param	vec	ϊW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJTool_VectorGridPosGet( int *gx, int *gy, int *gz, const VecFx32 *vec )
{
	*gx = SIZE_GRID_FX32( vec->x );
	*gy = SIZE_H_GRID_FX32( vec->y );
	*gz = SIZE_GRID_FX32( vec->z );
}

//==============================================================================
//	̑p[c
//==============================================================================
//--------------------------------------------------------------
//	]e[u
//--------------------------------------------------------------
static const int DATA_DirFlipTbl[] =
{ DIR_DOWN, DIR_UP, DIR_RIGHT, DIR_LEFT };

//--------------------------------------------------------------
/**
 * ^ꂽ𔽓]
 * @param	dir		DIR_UP
 * @retval	int		dir̔]
 */
//--------------------------------------------------------------
int FieldOBJTool_DirFlip( int dir )
{
	return( DATA_DirFlipTbl[dir] );
}

//--------------------------------------------------------------
/**
 * ԕ擾
 * @param	ax	ΏA XW
 * @param	az	ΏA ZW
 * @param	bx	ΏB XW
 * @param	bz	ΏB ZW
 * @retval	int	ΏAΏBւ̕ DIR_UP
 */
//--------------------------------------------------------------
int FieldOBJTool_DirRange( int ax, int az, int bx, int bz )
{
	if( ax > bx ){ return( DIR_LEFT ); }
	if( ax < bx ){ return( DIR_RIGHT ); }
	if( az > bz ){ return( DIR_UP ); }
	
	return( DIR_DOWN );
}

//--------------------------------------------------------------
/**
 * 擾
 * @param	fsys	FIELDSYS_WORK *
 * @param	vec		擾X,Y,Zi[|C^BY͍擾ōXV
 * @retval	int		TRUE=擾@FALSE=ݒ薳
 */
//--------------------------------------------------------------
int FieldOBJTool_GetHeight( FIELDSYS_WORK *fsys, VecFx32 *vec )
{
	fx32 y;
	HEIGHT_TYPE flag;
	
	y = GetHeightPack( fsys, vec->y, vec->x, vec->z, &flag );
	
	if( flag == HEIGHT_FAIL ){
		return( FALSE );
	}
	
	vec->y = y;
	return( TRUE );
}

