//******************************************************************************
/**
 *
 * @file	fieldobj_move_1.c
 * @brief	tB[hOBJ@{n1@Tu
 * @author	kagaya
 * @data	05.07.21
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "fieldobj.h"

//==============================================================================
//	define
//==============================================================================

//==============================================================================
//	struct
//==============================================================================

//==============================================================================
//	vg^Cv
//==============================================================================
static void MoveSub_InitProcCall( FIELD_OBJ_PTR fldobj );
static int MoveSub_StartCheckProcCall( FIELD_OBJ_PTR fldobj );
static int MoveSub_MoveProcCall( FIELD_OBJ_PTR fldobj );

static int MoveSub_PosUpdateStartCheck( FIELD_OBJ_PTR fldobj );
static int MoveSub_PosUpdateEndCheck( FIELD_OBJ_PTR fldobj );

static void SubMoveNon_Init( FIELD_OBJ_PTR fldobj );
static int SubMoveNon_StartCheck( FIELD_OBJ_PTR fldobj );
static int SubMoveNon_Move( FIELD_OBJ_PTR fldobj );

static void SubMoveKyoro_Init( FIELD_OBJ_PTR fldobj );
static int SubMoveKyoro_StartCheck( FIELD_OBJ_PTR fldobj );
static int SubMoveKyoro_Move( FIELD_OBJ_PTR fldobj );

static void SubMoveSpinStop_Init( FIELD_OBJ_PTR fldobj );
static int SubMoveSpinStop_StartCheck( FIELD_OBJ_PTR fldobj );
static int SubMoveSpinStop_Move( FIELD_OBJ_PTR fldobj );

void (* const DATA_FldOBJ_EventTypeInitProcTbl[])( FIELD_OBJ_PTR );
int (* const DATA_FldOBJ_EventTypeStartCheckProcTbl[])( FIELD_OBJ_PTR );
int (* const DATA_FldOBJ_EventTypeMoveProcTbl[])( FIELD_OBJ_PTR );

//==============================================================================
//	Tu
//==============================================================================
//--------------------------------------------------------------
/**
 * Tu쏉
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveSubProcInit( FIELD_OBJ_PTR fldobj )
{
	MoveSub_InitProcCall( fldobj );
}

//--------------------------------------------------------------
/**
 * Tu
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=TuɂړA
 */
//--------------------------------------------------------------
int FieldOBJ_MoveSub( FIELD_OBJ_PTR fldobj )
{
	if( MoveSub_StartCheckProcCall(fldobj) == FALSE ){
		return( FALSE );
	}
	
	if( MoveSub_MoveProcCall(fldobj) == FALSE ){
		return( FALSE );
	}
	
	return( TRUE );
}

//==============================================================================
//	Tu쏈@p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * ֐Ăяo
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void MoveSub_InitProcCall( FIELD_OBJ_PTR fldobj )
{
	int type = FieldOBJ_EventTypeGet( fldobj );
	DATA_FldOBJ_EventTypeInitProcTbl[type]( fldobj );
}

//--------------------------------------------------------------
/**
 * `FbN֐Ăяo
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=`FbNɈ
 */
//--------------------------------------------------------------
static int MoveSub_StartCheckProcCall( FIELD_OBJ_PTR fldobj )
{
	int type = FieldOBJ_EventTypeGet( fldobj );
	return( DATA_FldOBJ_EventTypeStartCheckProcTbl[type](fldobj) );
}

//--------------------------------------------------------------
/**
 * ֐Ăяo
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=쒆
 */
//--------------------------------------------------------------
static int MoveSub_MoveProcCall( FIELD_OBJ_PTR fldobj )
{
	int type = FieldOBJ_EventTypeGet( fldobj );
	return( DATA_FldOBJ_EventTypeMoveProcTbl[type](fldobj) );
}

//==============================================================================
//	Tupp[c
//==============================================================================
//--------------------------------------------------------------
/**
 * WXVJn`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=XV
 */
//--------------------------------------------------------------
static int MoveSub_PosUpdateStartCheck( FIELD_OBJ_PTR fldobj )
{
	int now = FieldOBJ_NowPosGX_Get( fldobj );
	int old = FieldOBJ_OldPosGX_Get( fldobj );
	
	if( now != old ){
		return( TRUE );
	}
	
	now = FieldOBJ_NowPosGZ_Get( fldobj );
	old = FieldOBJ_OldPosGZ_Get( fldobj );
	
	if( now != old ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * WXVI`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=I
 */
//--------------------------------------------------------------
static int MoveSub_PosUpdateEndCheck( FIELD_OBJ_PTR fldobj )
{
	int now = FieldOBJ_NowPosGX_Get( fldobj );
	int old = FieldOBJ_OldPosGX_Get( fldobj );
	
	if( now != old ){
		return( FALSE );
	}
	
	now = FieldOBJ_NowPosGZ_Get( fldobj );
	old = FieldOBJ_OldPosGZ_Get( fldobj );
	
	if( now != old ){
		return( FALSE );
	}
	
	return( TRUE );
}

//==============================================================================
//	Tu@
//==============================================================================
//--------------------------------------------------------------
/**
 * Tu쏉@
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void SubMoveNon_Init( FIELD_OBJ_PTR fldobj )
{
}

//--------------------------------------------------------------
/**
 * TuX^[g`FbN@
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		FALSE
 */
//--------------------------------------------------------------
static int SubMoveNon_StartCheck( FIELD_OBJ_PTR fldobj )
{
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * Tu@
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=쒆
 */
//--------------------------------------------------------------
static int SubMoveNon_Move( FIELD_OBJ_PTR fldobj )
{
	return( FALSE );
}

//==============================================================================
//	Tu@~܂Ă낫
//==============================================================================
//--------------------------------------------------------------
///	SUBWORK_KYORO\
//--------------------------------------------------------------
typedef struct
{
	u8 check_seq_no;
	u8 move_seq_no;
	s8 walk_count;
	s8 max_count;
	
	s8 origin_dir;
	s8 dir_type;
	s8 dir_no;
	s8 dir_count;
	s8 wait;
}SUBWORK_KYORO;

#define SUBWORK_KYORO_SIZE (sizeof(SUBWORK_KYORO))

//--------------------------------------------------------------
///	낫
//--------------------------------------------------------------
enum
{
	DIR_H_TYPE = 0,		///<낫
	DIR_V_TYPE,			///<c낫
};

#define KYORO_WAIT_FRAME (8)		///<낫̍
#define KYORO_COUNT_MAX (4)			///<낫񐔍ő

//--------------------------------------------------------------
/**
 * ~܂Ă낫@
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void SubMoveKyoro_Init( FIELD_OBJ_PTR fldobj )
{
	SUBWORK_KYORO *work;
	
	work = FieldOBJ_MoveSubProcWorkInit( fldobj, SUBWORK_KYORO_SIZE );
	work->max_count = FieldOBJ_ParamGet( fldobj, FLDOBJ_PARAM_1 );
}

//--------------------------------------------------------------
/**
 * ~܂Ă낫@X^[g`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=A
 */
//--------------------------------------------------------------
static int SubMoveKyoro_StartCheck( FIELD_OBJ_PTR fldobj )
{
	SUBWORK_KYORO *work;
	
	work = FieldOBJ_MoveSubProcWorkGet( fldobj );
	
	switch( work->check_seq_no ){
	case 0:														//ړJnĎ
		if( MoveSub_PosUpdateStartCheck(fldobj) == TRUE ){
			work->check_seq_no++;
		}
		
		break;
	case 1:														//ړIĎ
		if( MoveSub_PosUpdateEndCheck(fldobj) == FALSE ){
			break;
		}
		
		work->walk_count++;
		
		if( work->walk_count < work->max_count ){
			work->check_seq_no = 0;
			break;
		}
		
		work->check_seq_no++;
	case 2:														//ړĎ
		if( FieldOBJ_StatusBitCheck_Move(fldobj) == TRUE ){
			GF_ASSERT( MoveSub_PosUpdateStartCheck(fldobj) == TRUE &&
				"SubMoveKyoro_StartCheck()Ώۂ̈ړ@ُ" );
			break;
		}
		
		work->check_seq_no++;
		work->walk_count = 0;
		work->move_seq_no = 0;
	case 3:														//Tu쒆
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * ~܂Ă낫@
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=쒆
 */
//--------------------------------------------------------------
static int SubMoveKyoro_Move( FIELD_OBJ_PTR fldobj )
{
	SUBWORK_KYORO *work;
	
	work = FieldOBJ_MoveSubProcWorkGet( fldobj );
	
	switch( work->move_seq_no ){
	case 0:														//
		{
			int type_tbl[4] = {DIR_H_TYPE,DIR_H_TYPE,DIR_V_TYPE,DIR_V_TYPE};
			int dir = FieldOBJ_DirDispGet( fldobj );
			work->origin_dir = dir;
			work->dir_type = type_tbl[dir];
			work->move_seq_no++;
		}
	case 1:														//Zbg	
		{
			int dir_tbl[2][2] = { {DIR_LEFT,DIR_RIGHT},{DIR_UP,DIR_DOWN} };
			int dir = dir_tbl[work->dir_type][work->dir_no];
			int code = FieldOBJ_AcmdCodeDirChange( dir, AC_DIR_U );
			FieldOBJ_CmdSet( fldobj, code );
			work->move_seq_no++;
		}
	case 2:
		{
			if( FieldOBJ_CmdAction(fldobj) == FALSE ){
				return( TRUE );
			}
			
			work->move_seq_no++;
		}
	case 3:
		{
			work->wait++;
			
			if( work->wait < KYORO_WAIT_FRAME ){
				return( TRUE );
			}
			
			work->wait = 0;
			work->dir_count++;
			
			if( work->dir_count < KYORO_COUNT_MAX ){
				work->dir_no = (work->dir_no + 1) & 0x01;
				work->move_seq_no = 1;
				return( TRUE );
			}
			
			FieldOBJ_DirDispCheckSet( fldobj, work->origin_dir );
			work->move_seq_no++;
			work->dir_count = 0;
			work->check_seq_no = 0;
		}
	}
	
	return( FALSE );
}

//==============================================================================
//	Tu@~܂ăNN
//==============================================================================
//--------------------------------------------------------------
///	SUBWORK_SPIN_STOP\
//--------------------------------------------------------------
typedef struct
{
	u8 check_seq_no;
	u8 move_seq_no;
	s8 walk_count;
	s8 max_count;
	
	s8 origin_dir;
	s8 dir_type;
	s8 dir_no;
	s8 dir_count;
	s8 wait;
}SUBWORK_SPIN_STOP;

#define SUBWORK_SPIN_STOP_SIZE (sizeof(SUBWORK_SPIN_STOP))

//--------------------------------------------------------------
///	]
//--------------------------------------------------------------
enum
{
	SPIN_STOP_L_TYPE = 0,		///<]
	SPIN_STOP_R_TYPE,			///<E]
};

#define SPIN_STOP_WAIT_FRAME (8)	///<]̊
#define SPIN_STOP_COUNT_MAX (4)		///<]ő吔

//--------------------------------------------------------------
/**
 * ~܂ăNN@
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void SubMoveSpinStop_Init( FIELD_OBJ_PTR fldobj )
{
	int type;
	SUBWORK_SPIN_STOP *work;
	
	work = FieldOBJ_MoveSubProcWorkInit( fldobj, SUBWORK_SPIN_STOP_SIZE );
	work->max_count = FieldOBJ_ParamGet( fldobj, FLDOBJ_PARAM_1 );
	
	type = FieldOBJ_EventTypeGet( fldobj );
	
	if( type == EV_TYPE_TRAINER_SPIN_STOP_L ){
		type = SPIN_STOP_L_TYPE;
	}else{
		type = SPIN_STOP_R_TYPE;
	}
	
	work->dir_type = type;
}

//--------------------------------------------------------------
/**
 * ~܂ăNN@X^[g`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=A
 */
//--------------------------------------------------------------
static int SubMoveSpinStop_StartCheck( FIELD_OBJ_PTR fldobj )
{
	SUBWORK_SPIN_STOP *work;
	
	work = FieldOBJ_MoveSubProcWorkGet( fldobj );
	
	switch( work->check_seq_no ){
	case 0:														//ړJnĎ
		if( MoveSub_PosUpdateStartCheck(fldobj) == TRUE ){
			work->check_seq_no++;
		}
		
		break;
	case 1:														//ړIĎ
		if( MoveSub_PosUpdateEndCheck(fldobj) == FALSE ){
			break;
		}
		
		work->walk_count++;
		
		if( work->walk_count < work->max_count ){
			work->check_seq_no = 0;
			break;
		}
		
		work->check_seq_no++;
	case 2:														//ړĎ
		if( FieldOBJ_StatusBitCheck_Move(fldobj) == TRUE ){
			GF_ASSERT( MoveSub_PosUpdateStartCheck(fldobj) == TRUE &&
				"SubMoveKyoro_StartCheck()Ώۂ̈ړ@ُ" );
			break;
		}
		
		work->check_seq_no++;
		work->walk_count = 0;
		work->move_seq_no = 0;
	case 3:														//Tu쒆
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * ~܂ăNN@
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=쒆
 */
//--------------------------------------------------------------
static int SubMoveSpinStop_Move( FIELD_OBJ_PTR fldobj )
{
	SUBWORK_KYORO *work;
	int spin_tbl[2][4] =
	{ {DIR_UP,DIR_LEFT,DIR_DOWN,DIR_RIGHT},{DIR_UP,DIR_RIGHT,DIR_DOWN,DIR_LEFT} };
	
	work = FieldOBJ_MoveSubProcWorkGet( fldobj );
	
	switch( work->move_seq_no ){
	case 0:														//
		{
			int i,dir = FieldOBJ_DirDispGet( fldobj );
			
			for( i = 0; (i < DIR_4_MAX && dir != spin_tbl[work->dir_type][i]); i++ ){}
			GF_ASSERT( i < DIR_4_MAX && "SubMoveKyoro_Move()ُ" );
			
			work->origin_dir = dir;
			work->dir_no = (i + 1) % SPIN_STOP_COUNT_MAX;		//+1=1
			work->move_seq_no++;
		}
	case 1:														//Zbg	
		{
			int dir = spin_tbl[work->dir_type][work->dir_no];
			int code = FieldOBJ_AcmdCodeDirChange( dir, AC_DIR_U );
			FieldOBJ_CmdSet( fldobj, code );
			work->move_seq_no++;
		}
	case 2:
		{
			if( FieldOBJ_CmdAction(fldobj) == FALSE ){
				return( TRUE );
			}
			
			work->move_seq_no++;
		}
	case 3:
		{
			work->wait++;
			
			if( work->wait < SPIN_STOP_WAIT_FRAME ){
				return( TRUE );
			}
			
			work->wait = 0;
			work->dir_count++;
			
			if( work->dir_count < SPIN_STOP_COUNT_MAX ){
				work->dir_no = (work->dir_no + 1) % SPIN_STOP_COUNT_MAX;
				work->move_seq_no = 1;
				return( TRUE );
			}
			
			FieldOBJ_DirDispCheckSet( fldobj, work->origin_dir );
			work->move_seq_no++;
			work->dir_count = 0;
			work->check_seq_no = 0;
		}
	}
	
	return( FALSE );
}

//==============================================================================
//	data
//==============================================================================
//--------------------------------------------------------------
//	Cxg^Cvʏ֐ EV_TYPE_NORMAL̒lɈv
//--------------------------------------------------------------
static void (* const DATA_FldOBJ_EventTypeInitProcTbl[])( FIELD_OBJ_PTR ) =
{
	SubMoveNon_Init, //EV_TYPE_NORMAL
	SubMoveNon_Init, //EV_TYPE_TRAINER
	SubMoveNon_Init, //EV_TYPE_TRAINER_EYEALL
	SubMoveNon_Init, //EV_TYPE_ITEM
	SubMoveKyoro_Init, //EV_TYPE_TRAINER_KYORO
	SubMoveSpinStop_Init, //EV_TYPE_TRAINER_SPIN_STOP_L
	SubMoveSpinStop_Init, //EV_TYPE_TRAINER_SPIN_STOP_R
	SubMoveNon_Init, //EV_TYPE_TRAINER_SPIN_MOVE_L
	SubMoveNon_Init, //EV_TYPE_TRAINER_SPIN_MOVE_R
	SubMoveNon_Init, //EV_TYPE_TRAINER_ESCAPE
	SubMoveNon_Init, //EV_TYPE_TRAINER_SWIM_H
};

//--------------------------------------------------------------
//	Cxg^CvʃX^[g`FbN֐@EV_TYPE_NORMAL̒lɈv
//--------------------------------------------------------------
static int (* const DATA_FldOBJ_EventTypeStartCheckProcTbl[])( FIELD_OBJ_PTR ) =
{
	SubMoveNon_StartCheck, //EV_TYPE_NORMAL
	SubMoveNon_StartCheck, //EV_TYPE_TRAINER
	SubMoveNon_StartCheck, //EV_TYPE_TRAINER_EYEALL
	SubMoveNon_StartCheck, //EV_TYPE_ITEM
	SubMoveKyoro_StartCheck, //EV_TYPE_TRAINER_KYORO
	SubMoveSpinStop_StartCheck, //EV_TYPE_TRAINER_SPIN_STOP_L
	SubMoveSpinStop_StartCheck, //EV_TYPE_TRAINER_SPIN_STOP_R
	SubMoveNon_StartCheck, //EV_TYPE_TRAINER_SPIN_MOVE_L
	SubMoveNon_StartCheck, //EV_TYPE_TRAINER_SPIN_MOVE_R
	SubMoveNon_StartCheck, //EV_TYPE_TRAINER_ESCAPE
	SubMoveNon_StartCheck, //EV_TYPE_TRAINER_SWIM_H
};

//--------------------------------------------------------------
//	Cxg^Cvʓ֐ EV_TYPE_NORMAL̒lɈv
//--------------------------------------------------------------
static int (* const DATA_FldOBJ_EventTypeMoveProcTbl[])( FIELD_OBJ_PTR ) =
{
	SubMoveNon_Move, //EV_TYPE_NORMAL
	SubMoveNon_Move, //EV_TYPE_TRAINER
	SubMoveNon_Move, //EV_TYPE_TRAINER_EYEALL
	SubMoveNon_Move, //EV_TYPE_ITEM
	SubMoveKyoro_Move, //EV_TYPE_TRAINER_KYORO
	SubMoveSpinStop_Move, //EV_TYPE_TRAINER_SPIN_STOP_L
	SubMoveSpinStop_Move, //EV_TYPE_TRAINER_SPIN_STOP_R
	SubMoveNon_Move, //EV_TYPE_TRAINER_SPIN_MOVE_L
	SubMoveNon_Move, //EV_TYPE_TRAINER_SPIN_MOVE_R
	SubMoveNon_Move, //EV_TYPE_TRAINER_ESCAPE
	SubMoveNon_Move, //EV_TYPE_TRAINER_SWIM_H
};
