//===========================================================================
/**
 * @file	fieldsys.c
 * @brief	Q[C
 * @author	tamada	GAME FREAK Inc.
 *
 */
//===========================================================================
#include "common.h"

#define __FIELDSYS_H_GLOBAL__
#include "fieldsys.h"

#include "field/field.h"
#include "system/main.h"
#include "system\render_oam.h"

#include "fieldmap.h"
#include "fieldmap_work.h"

#include "field_event.h"

#include "system/savedata.h"

#include "ev_mapchange.h"		//EventSet_FirstMapIn

#include "zonedata.h"


#include "system/pm_overlay.h"
#include "field/situation.h"
#include "field/situation_local.h"

#include "communication/communication.h"  // ʐM̂
#include "comm_player.h"  // ʐM̂

#include "ev_check.h"		//EV_REQUEST

#include "demo/title.h"

#include "mapdefine.h"

#include "field_poketch.h"


FS_EXTERN_OVERLAY( fieldmap );
//FS_EXTERN_OVERLAY( fieldmap2 );

static FIELDSYS_WORK * GameSystem_Init(PROC * proc);
static BOOL GameSystem_Main(FIELDSYS_WORK * fsys);

static void SetFirstEvent(FIELDSYS_WORK * fsys);

static void FieldMap_Control(FIELDSYS_WORK * fsys);
/*---------------------------------------------------------------------------*
 *---------------------------------------------------------------------------*/

//------------------------------------------------------------------
/**
 * @brief	䃏[Np\̒`
 */
//------------------------------------------------------------------
typedef struct _CONTROL_WORK{
	PROC * mainproc;		///<CvZXێ[N
	PROC * subproc;			///<TuvZXێ[N
	BOOL pause_flag;		///<|[YtOifobOpj
	BOOL end_flag;			///<ItOifobOpHj
};

//------------------------------------------------------------------
/**
 * @brief	C䃏[N
 */
//------------------------------------------------------------------
static FIELDSYS_WORK	* FieldSysWork;

//===========================================================================
//
//
//		Q[CvZX֐
//
//
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	Q[CvZXFF傩
 */
//------------------------------------------------------------------
static PROC_RESULT DebugNewGameMainProc_Init(PROC * proc, int * seq)
{
	MAINWORK * main = PROC_GetParentWork(proc);
	GameData_SetDebugNewGame(main->savedata);

	FieldSysWork = GameSystem_Init(proc);
	SetFirstEvent(FieldSysWork);
	return PROC_RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	Q[CvZXFFReBj[
 */
//------------------------------------------------------------------
static PROC_RESULT ContinueGameMainProc_Init(PROC * proc, int * seq)
{
	MAINWORK * main = PROC_GetParentWork(proc);
	GameData_SetContinueData(main->savedata);

	FieldSysWork = GameSystem_Init(proc);
	EventSet_ContinueMapIn(FieldSysWork);
	//SetFirstEvent(FieldSysWork);
	return PROC_RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	Q[CvZXFFReBj[
 */
//------------------------------------------------------------------
static PROC_RESULT GameMainProc_Init(PROC * proc, int * seq)
{
	FieldSysWork = GameSystem_Init(proc);
	SetFirstEvent(FieldSysWork);
	return PROC_RES_FINISH;
}


//------------------------------------------------------------------
/**
 * @brief	Q[CvZXFC
 */
//------------------------------------------------------------------
static PROC_RESULT GameMainProc_Main(PROC * proc, int * seq)
{
	FIELDSYS_WORK * fsys = PROC_GetWork(proc);

	if (GameSystem_Main(fsys)) {
		return PROC_RES_FINISH;
	} else {
		return PROC_RES_CONTINUE;
	}
}
//------------------------------------------------------------------
/**
 * @brief	Q[CvZXFI
 *
 * ۂɂ͌Ă΂邱Ƃ͂Ȃƍl
 */
//------------------------------------------------------------------
static PROC_RESULT GameMainProc_End(PROC * proc, int * seq)
{
	FIELDSYS_WORK * fsys = PROC_GetWork(proc);

	Main_SetNextProc(NO_OVERLAY_ID, &TitleProcData);
	sys_FreeMemoryEz(fsys->ctrl);
	PROC_FreeWork(proc);
	sys_DeleteHeap(HEAPID_WORLD);
	sys_DeleteHeap(HEAPID_EVENT);
	return PROC_RES_FINISH;
}

//------------------------------------------------------------------
//------------------------------------------------------------------
const PROC_DATA GameMainProcData = {
	GameMainProc_Init,
	GameMainProc_Main,
	GameMainProc_End,
	NO_OVERLAY_ID
};
//------------------------------------------------------------------
//------------------------------------------------------------------
const PROC_DATA DebugNewGameProcData = {
	DebugNewGameMainProc_Init,
	GameMainProc_Main,
	GameMainProc_End,
	NO_OVERLAY_ID
};

//------------------------------------------------------------------
//------------------------------------------------------------------
const PROC_DATA ContinueGameProcData = {
	ContinueGameMainProc_Init,
	GameMainProc_Main,
	GameMainProc_End,
	NO_OVERLAY_ID
};
//===========================================================================
//
//	֐
//
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	tB[h}bvC
 * @param	fsys	tB[h䃏[Nւ̃|C^
 */
//------------------------------------------------------------------
void GameSystem_CreateFieldProc(FIELDSYS_WORK * fsys)
{
	GF_ASSERT(fsys->ctrl->subproc == NULL);
	GF_ASSERT(fsys->ctrl->mainproc == NULL);
	Overlay_Load( FS_OVERLAY_ID( fieldmap ), OVERLAY_LOAD_NOT_SYNCHRONIZE );
	//Overlay_Load( FS_OVERLAY_ID( fieldmap2 ), OVERLAY_LOAD_NOT_SYNCHRONIZE );
	fsys->main_mode_flag = FALSE;
	fsys->ctrl->pause_flag = FALSE;
	fsys->ctrl->mainproc = PROC_Create(&FieldProcData, fsys, HEAPID_WORLD);
}

//------------------------------------------------------------------
/**
 * @brief	tB[h}bvCINGXg
 * @param	fsys	tB[h䃏[Nւ̃|C^
 */
//------------------------------------------------------------------
void GameSystem_FinishFieldProc(FIELDSYS_WORK * fsys)
{
	fsys->main_mode_flag = FALSE;
}
//------------------------------------------------------------------
/**
 * @brief	tB[h}bvC̑݃`FbN
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @retval	TRUE	tB[h}bvC݂Ă
 * @retval	FALSE	tB[h}bvC݂͑ĂȂ
 */
//------------------------------------------------------------------
BOOL GameSystem_CheckFieldProcExists(FIELDSYS_WORK * fsys)
{
	return (fsys->ctrl->mainproc != NULL);
}

//------------------------------------------------------------------
/**
 * @brief	tB[h}bvC`FbN
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @retval	TRUE	tB[h}bvC삵Ă
 * @retval	FALSE	tB[h}bvC͓삵ĂȂ
 *					iTuvZX쒆AEIj
 */
//------------------------------------------------------------------
BOOL GameSystem_CheckFieldMain(FIELDSYS_WORK * fsys)
{
	if (fsys->ctrl->mainproc != NULL && fsys->main_mode_flag) {
		return TRUE;
	} else {
		return FALSE;
	}
}

//------------------------------------------------------------------
/**
 * @brief	tB[hTuvZX̑݃`FbN
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @retval	TRUE	tB[hTuvZX݂Ă
 * @retval	FALSE	tB[hTuvZX݂͑ĂȂ
 */
//------------------------------------------------------------------
BOOL GameSystem_CheckSubProcExists(FIELDSYS_WORK * fsys)
{
	return (fsys->ctrl->subproc != NULL);
}

//------------------------------------------------------------------
/**
 * @brief	tB[hTuvZX̐
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	pdata	vZXf[^
 * @param	param	vZXɓnp[^
 */
//------------------------------------------------------------------
void GameSystem_StartSubProc(FIELDSYS_WORK * fsys, const PROC_DATA * pdata, void * param)
{
	GF_ASSERT(fsys->ctrl->subproc == NULL);
	GameSystem_FinishFieldProc(fsys);
	fsys->ctrl->subproc = PROC_Create(pdata, param, HEAPID_WORLD);
}

//------------------------------------------------------------------
/**
 * @brief	Q[C̏I
 * @param	fsys	tB[h䃏[Nւ̃|C^
 */
//------------------------------------------------------------------
void GameSystem_End(FIELDSYS_WORK * fsys)
{
	fsys->ctrl->end_flag = TRUE;
}

//===========================================================================
//
//
//		֐
//
//
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	tB[h
 * @param	proc		vZXւ̃|C^
 * @return	FIELDSYS_WORK	tB[hC䃏[Nւ̃|C^
 */
//------------------------------------------------------------------
static FIELDSYS_WORK * GameSystem_Init(PROC * proc)
{
	MAINWORK * main;
	FIELDSYS_WORK * fsys;

	//[hq[vm(mۂςȂ)
	//sys_CreateHeap( HEAPID_BASE_APP, HEAPID_WORLD, 0x20000 );
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_WORLD, 0x1c000 );
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_EVENT, 0x04000 );

	//tB[hC䃏[Nm
	fsys = PROC_AllocWork(proc, sizeof(FIELDSYS_WORK), HEAPID_WORLD);
	MI_CpuClear8(fsys, sizeof(FIELDSYS_WORK));

	//tB[hp[Nm
	fsys->ctrl = sys_AllocMemory(HEAPID_WORLD, sizeof(CONTROL_WORK));
	fsys->ctrl->mainproc = NULL;
	fsys->ctrl->subproc = NULL;
	fsys->ctrl->pause_flag = FALSE;
	fsys->ctrl->end_flag = FALSE;

	//Z[uf[^ւ̃|C^蓖
	main = PROC_GetParentWork(proc);
	fsys->savedata = main->savedata;

	fsys->event = NULL;

	fsys->location = Situation_GetNowLocation(SaveData_GetSituation(fsys->savedata));


	return fsys;
}

//------------------------------------------------------------------
//------------------------------------------------------------------
static void SetFirstEvent(FIELDSYS_WORK * fsys)
{
	LOCATION_WORK start_pos;

	start_pos = *Situation_GetNowLocation(SaveData_GetSituation(fsys->savedata));
	EventSet_FirstMapIn(fsys, &start_pos);
}
//===========================================================================
/**
 * 
 * C֐
 *
 */
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	TuvZXĂяo
 * @param	proc	TuvZX|C^ێ郏[Nւ̃|C^
 */
//------------------------------------------------------------------
static void ProcCall(PROC ** proc)
{
	if (*proc) {
		if (ProcMain(*proc)) {
			PROC_Delete(*proc);
			*proc = NULL;
		}
	}
}
//------------------------------------------------------------------
/**
 * @brief	Q[C
 * @param	fsys	tB[hC䃏[Nւ̃|C^
 * @retval	TRUE	I
 * @retval	FALSE	p
 */
//------------------------------------------------------------------
BOOL GameSystem_Main(FIELDSYS_WORK * fsys)
{
	BOOL event_end;

    FieldMap_Control(fsys);
	event_end = FieldEvent_Control(fsys);
	if(event_end == TRUE)
	{
		//|Pb`X[v
		Field_SendPoketchInfo( fsys, POKETCH_SEND_SLEEP, FALSE );
	}


	if (fsys->ctrl->mainproc) {
		ProcCall(&fsys->ctrl->mainproc);
		if (fsys->ctrl->mainproc == NULL) {
			Overlay_UnloadID( FS_OVERLAY_ID(fieldmap) );
			//Overlay_UnloadID( FS_OVERLAY_ID(fieldmap2) );
		}
	} else if (fsys->ctrl->subproc) {
		ProcCall(&fsys->ctrl->subproc);
	}

	if (fsys->ctrl->end_flag && !fsys->event
			&& !fsys->ctrl->mainproc && !fsys->ctrl->subproc) {
		//INGXgACxgTuvZXCvZX
		//ȂΏI
		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * @ACxg`FbN
 *
 * @param	fsys		FIELDSYS_WORK
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void FieldMap_Control(FIELDSYS_WORK * fsys)
{
	EV_REQUEST	req;
    BOOL bMoveControl = FALSE;

    //|[YԂłȂA
    //tB[hC삵Ă
    //CxgĂȂꍇA
    //	e폈s
    if (!fsys->ctrl->pause_flag
        && fsys->main_mode_flag
        && FieldEvent_Check(fsys) == FALSE) {
        bMoveControl = TRUE;
    }
    
    if(CommPlayerIsControl()){  // ʐMĂ{ʐMŃv[[Ƃ\
        if(bMoveControl){
            Player_MoveStateUpdate( fsys->player );
            SetRequest( &req, fsys, sys.trg, sys.cont );
            if( CheckRequestComm( &req, fsys ) == TRUE ){
                // ͓ɂ邱ƂȂ
            }
        }
        CommPlayersMove(fsys, bMoveControl);  // ʐMړ
    }
    else if (fsys->location->zone_id == ZONE_ID_UNION)
	{//jI[̏ꍇi̔̓^RȂ̂łƂłƒj
		if(bMoveControl) {
            Player_MoveStateUpdate( fsys->player );
            SetRequest( &req, fsys, sys.trg, sys.cont );
            if( CheckRequestUnion( &req, fsys ) == TRUE ){
				//CxgNȀɓ
			}else{
				Player_MoveControl( fsys->player, fsys->map_cont_dat, DIR_NOT, req.trg, req.cont );
			}
		}
	}
	else{ // ʐMĂȂʂ̏
        if(bMoveControl){
            Player_MoveStateUpdate( fsys->player );
            SetRequest( &req, fsys, sys.trg, sys.cont );
            if( CheckRequest( &req, fsys ) == TRUE ){
                StopPlaceName(fsys->fldmap->place_name_cont);	//n\LZ
				BoardSetDirect( fsys, BOARD_REQ_DEL );	// Ŕjij
				//|Pb`X[v
				Field_SendPoketchInfo( fsys, POKETCH_SEND_SLEEP, TRUE );
            }
            else{
                Player_MoveControl( fsys->player, fsys->map_cont_dat, DIR_NOT, req.trg, req.cont );
            }
        }
    }

}


//===========================================================================
/**
 * 
 * Av^XNݒ(tB[h̓z[hԂɂȂ)
 *
 */
//===========================================================================
void FieldSystemProc_SeqHold(void)
{
	FieldSysWork->ctrl->pause_flag = TRUE;
    CommDisableSendMoveData();  // ړ֎~
}


//===========================================================================
/**
 * 
 * Av^XNI(tB[hA)
 *
 */
//===========================================================================
void FieldSystemProc_SeqHoldEnd(void)
{
	FieldSysWork->ctrl->pause_flag = FALSE;
    CommEnableSendMoveData();  //ړ
}


//===========================================================================
//
// |Pb`֘A
//
//===========================================================================
//------------------------------------------------------------------
//------------------------------------------------------------------
///I[o[CW[extern錾łB
FS_EXTERN_OVERLAY(ol_poketch);
FS_EXTERN_OVERLAY(ol_before_poketch);

void FieldPoketch_Init( FIELDSYS_WORK * fsys )
{
	POKETCH_DATA* poketch_data = SaveData_GetPoketchData( fsys->savedata );

	if( PoketchData_GetPoketchGetFlag( poketch_data ) )
	{
		Overlay_Load( FS_OVERLAY_ID( ol_poketch ), OVERLAY_LOAD_NOT_SYNCHRONIZE );
		PoketchInit( fsys, &fsys->fldmap->poketch, fsys->savedata, fsys->bgl, REND_OAM_GetOamManagerInstance(REND_OAM_SUB) );
	}
	else
	{
		Overlay_Load( FS_OVERLAY_ID( ol_before_poketch ), OVERLAY_LOAD_NOT_SYNCHRONIZE );
		BeforePoketchInit( fsys->bgl );
	}
}

void FieldPoketch_QuitReq( FIELDSYS_WORK * fsys )
{
	POKETCH_DATA* poketch_data = SaveData_GetPoketchData( fsys->savedata );

	if( PoketchData_GetPoketchGetFlag( poketch_data ) )
	{
		PoketchQuitReq( fsys->fldmap->poketch );
	}
	else
	{
		BeforePoketchQuitReq( fsys->bgl );
	}
}

u8 FieldPoketch_QuitWait( FIELDSYS_WORK * fsys )
{
	POKETCH_DATA* poketch_data = SaveData_GetPoketchData( fsys->savedata );

	if( PoketchData_GetPoketchGetFlag( poketch_data ) )
	{
		if( PoketchQuitWait( fsys->fldmap->poketch ) ){
			fsys->fldmap->poketch = NULL;
			Overlay_UnloadID( FS_OVERLAY_ID( ol_poketch ) );
			return TRUE;
		}
	}
	else
	{
		if( BeforePoketchQuitWait( fsys->bgl ) )
		{
			Overlay_UnloadID( FS_OVERLAY_ID( ol_before_poketch ) );
			return TRUE;
		}
	}
	return FALSE;
}

struct _POKETCH_WORK* GetPoketchMainWorkPtr(void)
{
	if (FieldSysWork->fldmap == NULL) {
		return NULL;
	}
	return FieldSysWork->fldmap->poketch;
}


//===========================================================================
//
//
//
//===========================================================================
//------------------------------------------------------------------
//------------------------------------------------------------------
GF_BGL_INI * FieldBglIniGet( void * fsys )
{
	FIELDSYS_WORK * wk = (FIELDSYS_WORK *)fsys;

	return wk->bgl;
}

//------------------------------------------------------------------
/**
 * @brief	Z[uf[^ւ̃|C^擾
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @return	SAVEDATA	Z[uf[^ւ̃|C^
 */
//------------------------------------------------------------------
SAVEDATA * GameSystem_GetSaveData(void * fsys)
{
	return ((FIELDSYS_WORK *)fsys)->savedata;
}

