//==============================================================================================
/**
 * @file	fld_bgm.c
 * @brief	tB[hTEh
 * @author	Satoshi Nohara
 * @date	2005.10.14
 */
//==============================================================================================
#include "common.h"
#include "fieldsys.h"
#include "system/snd_tool.h"
#include "system/gamedata.h"		//POKE_NUM_MAX
#include "mapdefine.h"				//ZONE_ID_C01
#include "field_light.h"			//GetLightNight
#include "zonedata.h"				//ZoneData_GetBGMID
#include "player.h"					//HERO_FORM_SWIM
#include "fld_bgm.h"
#include "field/situation_local.h"

#include "battle/battle_common.h"	//CN[hɕKv
#include "poketool/tr_tool.h"
#include "battle/trtype_def.h"


//==============================================================================================
//
//	ϐ
//
//==============================================================================================
//Q[Jn(ĊJ)ɍXVI
static u8 light_night_status = 0;						//0=A1=


//==============================================================================================
//
//	vg^Cv錾
//
//==============================================================================================
void Snd_GameOverSet();
void Snd_RestartSet( FIELDSYS_WORK* fsys );

//tB[hBGMio[擾
u16 Snd_FieldBgmNoGet( FIELDSYS_WORK* fsys, int zone_id );
u16 Snd_PcBgmNoGet( FIELDSYS_WORK* fsys, u16 bgm_no );

//"][܂p"tF[hAEg  BGMĐ(tB[hp)
BOOL Snd_FadeOutNextPlayCall( FIELDSYS_WORK* fsys, u16 seq_no, int mode );

//"}bvJڐp"@tF[hAEg  BGMĐ(tB[hp)
BOOL Snd_MapChangeFadeOutNextPlayCall( FIELDSYS_WORK* fsys, u16 seq_no, int mode );

//ev_mapchange.cp̊֐
BOOL Snd_MapChangeFadeOutNextPlaySub( FIELDSYS_WORK* fsys, int zone_id, int mode );

//gbNtF[h
BOOL Snd_TrackFadeCall( FIELDSYS_WORK* fsys, u16 seq_no );
const TRACK_FADE_DATA* Snd_TrackFadeDataSearch( u16 seq_no );

//[J֐
static BOOL Snd_LightNightFlagCheck( FIELDSYS_WORK* fsys );
static void Snd_BgmFadeOutTimeGet( FIELDSYS_WORK* fsys, int mode, int* frame, int* next_wait );

//BGMio[擾
u16 Snd_EyeBgmGet( int tr_id );
u16 Snd_BattleBgmGet( u32 fight_type );


//==============================================================================================
//
//	f[^
//
//==============================================================================================
//ӁI }CiX10`15ƂĈĂ
#include "data/sound/dpmusfade.dat"				//gbNtF[hf[^


//==============================================================================================
//
//	֐
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	Q[I[o[ɂ鏈(field_encount.cĂ΂)
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_GameOverSet()
{
	//SĂ̍Đ̃V[PX~
	Snd_Stop();

	//SẴ|[YtONA
	Snd_PauseClearAll();

	return;
}

//--------------------------------------------------------------
/**
 * @brief	Q[I[o[ɍĊJ鎞̏(field_encount.cĂ΂)
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_RestartSet( FIELDSYS_WORK* fsys )
{
	u16 bgm_no;

	//tB[hV[tB[hV[̃[ĥŁA
	//xV[NAĂAtB[hf[^[h֐i
	Snd_SceneSet( SND_SCENE_DUMMY );

	//tB[hf[^[h
	bgm_no = Snd_FieldBgmNoGet( fsys, fsys->location->zone_id );
	Snd_DataSetByScene( SND_SCENE_FIELD, Snd_PcBgmNoGet(fsys,bgm_no), 1 );

	//tF[hC
	Snd_BgmFadeIn(BGM_VOL_MAX, BGM_FADEIN_RESTART_TIME, BGM_FADEIN_START_VOL_MIN);

	return;
}

//--------------------------------------------------------------
/**
 * @brief	BGMwZbg
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	bgm_no	BGMio[
 *
 * @retval	none
 *
 * }bvBGMw肪Zbg
 * ]BGM̐ȂǂɎgp
 */
//--------------------------------------------------------------
void Snd_FieldBgmSetSpecial( FIELDSYS_WORK* fsys, u16 bgm_no )
{
	u16* situation_bgm	= Situation_GetBGMWork( SaveData_GetSituation(fsys->savedata) );
	*situation_bgm		= bgm_no;
	return;
}

//--------------------------------------------------------------
/**
 * @brief	BGMwQbg
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	"BGMio["
 *
 * }bvBGMw肪Zbg
 * ]BGM̐ȂǂɎgp
 */
//--------------------------------------------------------------
u16 Snd_FieldBgmGetSpecial( FIELDSYS_WORK* fsys )
{
	u16* situation_bgm	= Situation_GetBGMWork( SaveData_GetSituation(fsys->savedata) );
	return (*situation_bgm);
}

//--------------------------------------------------------------
/**
 * @brief	BGMwNA
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	none
 *
 * }bvBGMw肪NA
 * ]BGM̐ȂǂɎgp
 */
//--------------------------------------------------------------
void Snd_FieldBgmClearSpecial( FIELDSYS_WORK* fsys )
{
	u16* situation_bgm	= Situation_GetBGMWork( SaveData_GetSituation(fsys->savedata) );
	*situation_bgm		= 0;
	return;
}

//--------------------------------------------------------------
/**
 * @brief	tB[hBGMio[擾
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	zone_id	][ID
 *
 * @retval	"tB[hBGMio["
 *
 * }bvǗ\͒ڌȂŁÅ֐ʂBGMio[擾
 */
//--------------------------------------------------------------
u16 Snd_FieldBgmNoGet( FIELDSYS_WORK* fsys, int zone_id )
{
	PLAYER_STATE_PTR player;
	int status;
	u16 bgm_no;

	player = fsys->player;
	status = Player_FormGet(player);

	//g蒆`FbN
	if( status == HERO_FORM_SWIM ){
		//return SEQ_NAMINORI;
	}
	
	//Cxg֘Ã`FbN
	//if( "AWg苒" )
	//return SEQ_AZITO;
	
	//}bvǗ\BGMio[Ԃ
	bgm_no = ZoneData_GetBGMID( zone_id );

#if 0
	//|PZ̋Ȃ
	if( bgm_no == SEQ_PC_01 ){
//		if( GetLightNight(fsys->light_cont_data) == FALSE ){	//FALSE=ATRUE=
		if( GetLightNight() == FALSE ){	//FALSE=ATRUE=
			bgm_no = SEQ_PC_01;
		}else{
			bgm_no = SEQ_PC_02;
		}
	}
#endif

#if 1
	//BGMw肪ZbgĂ
	if( Snd_FieldBgmGetSpecial(fsys) != 0 ){
		bgm_no = Snd_FieldBgmGetSpecial( fsys );
	}
#endif

	return bgm_no;
}

//--------------------------------------------------------------
/**
 * @brief	|PZBGMio[擾
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	bgm_no	BGMio[
 *
 * @retval	"BGMio["
 */
//--------------------------------------------------------------
u16 Snd_PcBgmNoGet( FIELDSYS_WORK* fsys, u16 bgm_no )
{
	//|PZ̋Ȃ
	if( bgm_no == SEQ_PC_01 ){
		OS_Printf( "hiru yoru = %d\n", GetLightNight() );
		if( GetLightNight() == FALSE ){	//FALSE=ATRUE=
			return SEQ_PC_01;
		}else{
			return SEQ_PC_02;
		}
	}
	return bgm_no;
}

//--------------------------------------------------------------
/**
 * @brief	"][܂p"@tF[hAEg  BGMĐ(tB[hp)
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	seq_no	V[PXio[
 * @param	mode	[h(fld_bgm.hQ)
 *
 * @retval	"0=ȂA1=Jn"
 *
 * tB[hȊÓÅ֐gpĉI
 * Snd_BgmFadeOutNextPlaySet(...);
 *
 * ][܂płBHÃ][܂Ɏgp܂B
 * }bvJڂɂ͎gpł܂B
 */
//--------------------------------------------------------------
BOOL Snd_FadeOutNextPlayCall( FIELDSYS_WORK* fsys, u16 seq_no, int mode )
{
	const TRACK_FADE_DATA* p_track;
	PLAYER_STATE_PTR player;
	int frame,next_wait,status;
	u8 chg;

	player = fsys->player;
	status = Player_FormGet(player);

	//ύXBGMio[ABGMio[Ɠ`FbN
	if( seq_no == Snd_NowBgmNoGet(fsys) ){
		return 0;		//Ȃ
	}

	//][f[^ւ́ANULLȂ̂ŃANZXĂ̓_I
	if( fsys->light_cont_data != NULL ){
//		chg = GetLightNight(fsys->light_cont_data);	//FALSE=ATRUE=
		chg = GetLightNight();	//FALSE=ATRUE=
	}else{
		chg = 0xff;	
	}

	//CxgŁAABGMPLAYER_BGMŖ炵ȂA}bvJڂƁA
	//PLAYER_FIELD|[YԂ̂܂܂ɂȂĂI
	//][؂ւ̓|[YSăNAĂȂ͂I
	
	//SẴ|[YtONA
	Snd_PauseClearAll();

	//̏o肩A][܂ɂāAtF[hAEgԂςI
	Snd_BgmFadeOutTimeGet( fsys, mode, &frame, &next_wait );

	//gbNtF[hf[^
	p_track = Snd_TrackFadeDataSearch( seq_no );

	if( (status == HERO_FORM_CYCLE_R) || (status == HERO_FORM_CYCLE_D) ){
		//]ԂɏĂ鎞̓tF[hAEgtF[hC
		Snd_FadeOutNextFadeInSet(SND_SCENE_FIELD, seq_no, frame, next_wait, 
									BGM_FADEIN_CYCLE_TIME, chg, p_track);
	}else{
		//ʏ̓tF[hAEgJn
		Snd_FadeOutNextPlaySet(SND_SCENE_FIELD, seq_no, frame, next_wait, chg, p_track);
	}

	return 1;
}

//--------------------------------------------------------------
/**
 * @brief	"}bvJڐp"@tF[hAEg  BGMĐ(tB[hp)
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	seq_no	V[PXio[
 * @param	mode	[h(fld_bgm.hQ)
 *
 * @retval	"0=ȂA1=Jn"
 *
 * }bvJڐpłBA_Wɓ鎞Ɏgp܂B
 * HÃ][܂ɂ͎gpł܂B
 */
//--------------------------------------------------------------
BOOL Snd_MapChangeFadeOutNextPlayCall( FIELDSYS_WORK* fsys, u16 seq_no, int mode )
{
	const TRACK_FADE_DATA* p_track;
	int frame,next_wait;
	u8 chg;

	/*

	//}bv`FW̃R}hŁA
	//
	//PABGMύX邩`FbN
	//QAύX鎞́A
	//RAtF[hAEg
	//SAtF[hAEg҂
	//܂ł
	//PABGM[hčĐ
	//ɕƃ^C~O₷B
	//A̓^C~OĂB

	//ƁAFLAG_CHANGEŃTEh[ÑNGXgBGMBGMio[āA
	//ɒlĂABGM点悤ɂĂƂ悢B
	//Snd_FieldBgmNoGetŁACxg̃`FbNAXNvgőSĂ悤ɂȂ̂ŁB
	
	*/

	//ύXBGMio[ABGMio[Ɠ`FbN
	if( seq_no == Snd_NowBgmNoGet(fsys) ){
		return 0;		//Ȃ
	}

	//][f[^ւ́ANULLȂ̂ŃANZXĂ̓_I
	if( fsys->light_cont_data != NULL ){
//		chg = GetLightNight(fsys->light_cont_data);	//FALSE=ATRUE=
		chg = GetLightNight();	//FALSE=ATRUE=
	}else{
		chg = 0xff;	
	}

	//CxgŁAABGMPLAYER_BGMŖ炵ȂA}bvJڂƁA
	//PLAYER_FIELD|[YԂ̂܂܂ɂȂĂI
	//][؂ւ̓|[YSăNAĂȂ͂I
	
	//SẴ|[YtONA
	Snd_PauseClearAll();

	//̏o肩A][܂ɂāAtF[hAEgԂςI
	Snd_BgmFadeOutTimeGet( fsys, mode, &frame, &next_wait );

	//gbNtF[hf[^
	p_track = Snd_TrackFadeDataSearch( seq_no );

	//tF[hAEgJn
	Snd_FadeOutNextPlaySet(SND_SCENE_FIELD, seq_no, frame, next_wait, chg, p_track);

	return 1;
}

//--------------------------------------------------------------
/**
 * @brief	"}bvJڐp"@ev_mapchange.cp̊֐
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	zone_id	][ID
 * @param	mode	[h(fld_bgm.hQ)
 *
 * @retval	"0=ȂA1=Jn"
 *
 * }bvJڐpłBA_Wɓ鎞Ɏgp܂B
 * HÃ][܂ɂ͎gpł܂B
 */
//--------------------------------------------------------------
BOOL Snd_MapChangeFadeOutNextPlaySub( FIELDSYS_WORK* fsys, int zone_id, int mode )
{
	u16 bgm_no = Snd_FieldBgmNoGet( fsys, zone_id );
	return Snd_MapChangeFadeOutNextPlayCall( fsys, Snd_PcBgmNoGet(fsys,bgm_no), mode );
}

//--------------------------------------------------------------
/**
 * @brief	gbNtF[hJn
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	seq_no		BGMio[
 *
 * @retval	"0=ȂA1=Jn"
 */
//--------------------------------------------------------------
BOOL Snd_TrackFadeCall( FIELDSYS_WORK* fsys, u16 seq_no )
{
	const TRACK_FADE_DATA* p_track;
	int i,ret;
	u8 chg;

	//][f[^ւ́ANULLȂ̂ŃANZXĂ̓_I
	if( fsys->light_cont_data == NULL ){
		return 0;
	}

	if( Snd_LightNightFlagCheck(fsys) == FALSE ){
		return 0;		//Ȃ
	}

	//gbNtF[hf[^
	p_track = Snd_TrackFadeDataSearch( seq_no );
	if( p_track == NULL ){
		return 0;		//Ȃ
	}

	chg = GetLightNight();	//FALSE=ATRUE=

	//gbNtF[hZbg(seqno,fadedata,lightnight)
	Snd_TrackFadeSet( seq_no, chg, p_track );

	return 1;
}

//--------------------------------------------------------------
/**
 * @brief	gbNtF[hf[^
 *
 * @param	seq_no		BGMio[
 *
 * @retval	"NULL=ȂAȊO=f[^AhX"
 */
//--------------------------------------------------------------
const TRACK_FADE_DATA* Snd_TrackFadeDataSearch( u16 seq_no )
{
	int i;

	for( i=0; i < TRACK_FADE_TBL_MAX ;i++ ){

		//V[PXio[𕡐̃}bvɓĂ̂ŁA
		//}bv`FbNĂ܂ƁA̕e[u쐬Ȃ΂ȂI
		
		//V[PXio[`FbN
		if( track_fade_tbl[i].seq_no == seq_no ){
			return &track_fade_tbl[i];				
		}
	}

	return NULL;
}


//==============================================================================================
//
//	[J֐
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	Ɩ邪؂ւ擾
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 *
 * @retval	"0=ȂA1=؂ւ"
 */
//--------------------------------------------------------------
static BOOL Snd_LightNightFlagCheck( FIELDSYS_WORK* fsys )
{
//	u8 chg = GetLightNight(fsys->light_cont_data);	//FALSE=ATRUE=
	u8 chg = GetLightNight();	//FALSE=ATRUE=

	if( Snd_LightNightFlagGet() != chg ){
		return TRUE;								//p[gtF[hĂяoI
	}

	return FALSE;									//Ȃ
}

//--------------------------------------------------------------
/**
 * @brief	tF[hAEgԎ擾
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	mode		[h(fld_bgm.hQ)
 * @param	frame		tF[hAEgt[i[|C^
 * @param	next_wait	BGM炷܂ł̃t[i[|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void Snd_BgmFadeOutTimeGet( FIELDSYS_WORK* fsys, int mode, int* frame, int* next_wait )
{
	//}bvǗ\ŁA][̃^Cv(AtB[hAAȂ)
	//ʂł悤ɂȂÃ[h͂ȂH

	//̏o肩A][܂ɂāAtF[hAEgԂςI
	
	switch( mode ){

	//̏o
	case BGM_FADE_ROOM_MODE:
		*frame		= BGM_FADE_ROOM_TIME;
		*next_wait	= 0;
		break;

	//tB[h̐؂ւ
	case BGM_FADE_FIELD_MODE:
		*frame		= BGM_FADE_FIELD_TIME;
		*next_wait	= 0;
		break;

	//Ȁo
	case BGM_FADE_CAVE_MODE:
		*frame		= BGM_FADE_CAVE_TIME;
		*next_wait	= BGM_NEXT_WAIT_CAVE_TIME;
		break;

	//̑
	case BGM_FADE_OTHERS_MODE:
		*frame		= BGM_FADE_OTHERS_TIME;
		*next_wait	= 0;
		break;
	};

	return;
}

//--------------------------------------------------------------
/**
 * @brief	g[i[BGM擾(XNvgĂ΂)
 *
 * @param	tr_id	g[i[ID
 *
 * @retval	none
 */
//--------------------------------------------------------------
u16 Snd_EyeBgmGet( int tr_id )
{
	u8 type;
	u16 bgm;

#if 0

	switch( GetTrainerSex(tr_id) ){

	case EYE_BOY:			bgm = MUS_BOYEYE; break;
	case EYE_GIRL:			bgm = MUS_GIRLEYE; break;
	case EYE_LITTLE_GIRL:	bgm = MUS_SYOUJOEYE; break;
	case EYE_AYASII:		bgm = MUS_AYASII; break;
	case EYE_HAGESII:		bgm = MUS_HAGESHII; break;
	case EYE_KAKKOII:		bgm = MUS_KAKKOII; break;
	case EYE_AQUADAN:		bgm = MUS_AQA_0; break;
	case EYE_MAGUMADAN:		bgm = MUS_MGM0;	break;
	case EYE_SWIMMER:		bgm = MUS_SWIMEYE; break;
	case EYE_FUTAGO:		bgm = MUS_HUTAGO; break;
	case EYE_SITENNOU:		bgm = MUS_SITENNOU; break;
	case EYE_DEBU:			bgm = MUS_YAMA_EYE; break;
	case EYE_INTERVIEWER:	bgm = MUS_INTER_V; break;
	case EYE_GENTLEMAN:		bgm = MUS_TEST; break;

	default:
		bgm = MUS_AYASII;
		break;				//G[
	}

#else

	//12ROMp̉
	
	type = (u8)TT_TrainerDataParaGet( tr_id, ID_TD_tr_type );

	switch( type ){

	//
	case TRTYPE_MINI:
	case TRTYPE_FUTAGO:
	case TRTYPE_CYCLINGW:
	case TRTYPE_BREEDERW:
	case TRTYPE_DAISUKIW:
	case TRTYPE_ELITEW:
	case TRTYPE_WAITRESS:
	case TRTYPE_RANGERW:
	case TRTYPE_SWIMMERW:
	case TRTYPE_ESPW:
	case TRTYPE_COLDELITEW:
	case TRTYPE_SKIERW:
	case TRTYPE_SCHOOLG:
	case TRTYPE_COWGIRL:
		bgm = SEQ_EYE_001;
		break;

	//o
	case TRTYPE_AROMA:
		bgm = SEQ_EYE_LADY;
		break;

	//j
	case TRTYPE_TANPAN:
	case TRTYPE_CAMPB:
	case TRTYPE_PICNICG:
	case TRTYPE_MUSHI:
	case TRTYPE_MOUNT:
	case TRTYPE_FISHING:
	case TRTYPE_CYCLINGM:
	case TRTYPE_ARTIST:
	case TRTYPE_BREEDERM:
	case TRTYPE_JOGGER:
	case TRTYPE_DAISUKIM:
	case TRTYPE_POKEGIRL:
	case TRTYPE_LOVELOVE:
	case TRTYPE_ELITEM:
	case TRTYPE_VETERAN:
	case TRTYPE_SHINOBI:
	case TRTYPE_DRAGON:
	case TRTYPE_BIRD:
	case TRTYPE_DOUBLETEAM:
	case TRTYPE_PRINCE:
	case TRTYPE_PRINCESS:
	case TRTYPE_GENTLE:
	case TRTYPE_MADAM:
	case TRTYPE_SISTER:
	case TRTYPE_COLLECTOR:
	case TRTYPE_POLICE:
	case TRTYPE_RANGERM:
	case TRTYPE_SCIENTIST:
	case TRTYPE_SWIMMERM:
	case TRTYPE_UKIWAB:
	case TRTYPE_UKIWAG:
	case TRTYPE_SAILOR:
	case TRTYPE_ANEOTOUTO:
	case TRTYPE_ISEKI:
	case TRTYPE_ESPM:
	case TRTYPE_GAMBLER:
	case TRTYPE_COLDELITEM:
	case TRTYPE_SKIERM:
	case TRTYPE_HEADS:
	case TRTYPE_PIERROT:
	case TRTYPE_WORKER:
	case TRTYPE_SCHOOLB:
	case TRTYPE_LEADER1:
	case TRTYPE_RIVAL:
		bgm = SEQ_EYE_BOY;
		break;

	//ogK[AƁAM^Xg
	case TRTYPE_BATTLEG:
	case TRTYPE_KARATE:
	case TRTYPE_GUITARIST:
		bgm = SEQ_EYE_FIGHT;
		break;

	//MKc
	//case TRTYPE_GINGA:
	//	bgm = SEQ_EYE_GINGA;
	//	break;

	default:
		bgm = SEQ_EYE_001;
		break;
	};

#endif

	return bgm;
}

//--------------------------------------------------------------
/**
 * @brief	퓬BGM擾
 *
 * @param	fight_type	퓬ʃtO
 *
 * @retval	none
 */
//--------------------------------------------------------------
u16 Snd_BattleBgmGet( u32 fight_type )
{
	u16 bgm;

#if 0

	//if(FightType&FIGHT_TYPE_HAIKEI_SET)

#else

	//12ROMp̉
	
	switch( fight_type ){

	//쐶
	case FIGHT_TYPE_YASEI:
		bgm = SEQ_BA_POKE;
		break;

	//g[i[
	case FIGHT_TYPE_TRAINER:
	case FIGHT_TYPE_2vs2:
	case FIGHT_TYPE_SIO:
	case FIGHT_TYPE_MULTI:
	case FIGHT_TYPE_TAG:
		bgm = SEQ_BA_GYM;
		break;

	default:
		//bgm = SEQ_FIGHT0101;	//G[
		bgm = SEQ_BA_POKE;	//G[
		break;
	};

#endif

	return bgm;
}


