//==============================================================================================
/**
 * @file	fld_bgm.h
 * @brief	tB[hTEh
 * @author	Satoshi Nohara
 * @date	2005.10.14
 */
//==============================================================================================
#ifndef __FLD_BGM_H__
#define __FLD_BGM_H__

#include "field_common.h"


//==============================================================================================
//
//	extern錾
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	Q[I[o[ɂ鏈(field_encount.cĂ΂)
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_GameOverSet();

//--------------------------------------------------------------
/**
 * @brief	Q[I[o[ɍĊJ鎞̏(field_encount.cĂ΂)
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_RestartSet( FIELDSYS_WORK* fsys );

//--------------------------------------------------------------
/**
 * @brief	BGMwZbg
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	bgm_no	BGMio[
 *
 * @retval	none
 *
 * }bvBGMw肪Zbg
 * ]BGM̐ȂǂɎgp
 */
//--------------------------------------------------------------
extern void Snd_FieldBgmSetSpecial( FIELDSYS_WORK* fsys, u16 bgm_no );

//--------------------------------------------------------------
/**
 * @brief	BGMwQbg
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	"BGMio["
 *
 * }bvBGMw肪Zbg
 * ]BGM̐ȂǂɎgp
 */
//--------------------------------------------------------------
extern u16 Snd_FieldBgmGetSpecial( FIELDSYS_WORK* fsys );

//--------------------------------------------------------------
/**
 * @brief	BGMwNA
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	none
 *
 * }bvBGMw肪NA
 * ]BGM̐ȂǂɎgp
 */
//--------------------------------------------------------------
extern void Snd_FieldBgmClearSpecial( FIELDSYS_WORK* fsys );

//--------------------------------------------------------------
/**
 * @brief	tB[hBGMio[擾
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	zone_id	][ID
 *
 * @retval	"tB[hBGMio["
 */
//--------------------------------------------------------------
extern u16 Snd_FieldBgmNoGet( FIELDSYS_WORK* fsys, int zone_id );

//--------------------------------------------------------------
/**
 * @brief	|PZBGMio[擾
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	bgm_no	BGMio[
 *
 * @retval	"BGMio["
 */
//--------------------------------------------------------------
extern u16 Snd_PcBgmNoGet( FIELDSYS_WORK* fsys, u16 bgm_no );

//--------------------------------------------------------------
/**
 * @brief	"][܂p"@tF[hAEg  BGMĐ(tB[hp)
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	seq_no	V[PXio[
 * @param	mode	[h(fld_bgm.hQ)
 *
 * @retval	"0=ȂA1=Jn"
 *
 * tB[hȊÓÅ֐gpĉI
 * Snd_BgmFadeOutNextPlaySet(...);
 *
 * ][܂płBHÃ][܂Ɏgp܂B
 * }bvJڂɂ͎gpł܂B
 */
//--------------------------------------------------------------
extern BOOL Snd_FadeOutNextPlayCall( FIELDSYS_WORK* fsys, u16 seq_no, int mode );

//--------------------------------------------------------------
/**
 * @brief	"}bvJڐp"@tF[hAEg  BGMĐ(tB[hp)
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	seq_no	V[PXio[
 * @param	mode	[h(fld_bgm.hQ)
 *
 * @retval	"0=ȂA1=Jn"
 *
 * }bvJڐpłBA_Wɓ鎞Ɏgp܂B
 * HÃ][܂ɂ͎gpł܂B
 */
//--------------------------------------------------------------
extern BOOL Snd_MapChangeFadeOutNextPlayCall( FIELDSYS_WORK* fsys, u16 seq_no, int mode );

//--------------------------------------------------------------
/**
 * @brief	"}bvJڐp"@ev_mapchange.cp̊֐
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	zone_id	][ID
 * @param	mode	[h(fld_bgm.hQ)
 *
 * @retval	"0=ȂA1=Jn"
 *
 * }bvJڐpłBA_Wɓ鎞Ɏgp܂B
 * HÃ][܂ɂ͎gpł܂B
 */
//--------------------------------------------------------------
extern BOOL Snd_MapChangeFadeOutNextPlaySub( FIELDSYS_WORK* fsys, int zone_id, int mode );

//--------------------------------------------------------------
/**
 * @brief	gbNtF[hJn
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	seq_no		BGMio[
 *
 * @retval	"0=ȂA1=tF[hJn"
 */
//--------------------------------------------------------------
extern BOOL Snd_TrackFadeCall( FIELDSYS_WORK* fsys, u16 seq_no );

//--------------------------------------------------------------
/**
 * @brief	gbNtF[hf[^
 *
 * @param	seq_no		BGMio[
 *
 * @retval	"NULL=ȂAȊO=f[^AhX"
 */
//--------------------------------------------------------------
extern const TRACK_FADE_DATA* Snd_TrackFadeDataSearch( u16 seq_no );

//--------------------------------------------------------------
/**
 * @brief	tB[h̃|PRg[
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	none
 *
 * vC[q[vōĐĂI
 */
//--------------------------------------------------------------
extern void Snd_FieldPMVoiceControl( FIELDSYS_WORK* fsys );

//--------------------------------------------------------------
/**
 * @brief	g[i[BGM擾(XNvgĂ΂)
 *
 * @param	tr_id	g[i[ID
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern u16 Snd_EyeBgmGet( int tr_id );

//--------------------------------------------------------------
/**
 * @brief	퓬BGM擾
 *
 * @param	fight_type	퓬ʃtO
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern u16 Snd_BattleBgmGet( u32 fight_type );


#endif


