/**
 *	@file	fld_debst.c
 *	@brief	tB[hfobOj[@풓̈
 *	@author	Miyuki Iwasawa
 *	@date	06.03.16
 *
 *	tB[hfobOj[\[Xŏ풓ė~̂͂
 */

#ifdef PM_DEBUG
#include "common.h"
#include "system/bmp_list.h"
#include "system/bmp_menu.h"
#include "fld_bmp.h"
#include "system/fontproc.h"
#include "fieldmap.h"
#include "fieldsys.h"
#include "ev_mapchange.h"
#include "fld_debug.h"
#include "zonedata.h"
#include "system/builddate.h"
#include "system/window.h"
#include "mapdefine.h"
#include "system/snd_tool.h"
#include "field/field.h"
#include "field/field_matrix.h"

#include "application/worldmap/townmap.h"



//SkyJump
typedef struct _DEB_SKYJUMP{
	FIELDSYS_WORK* fsys;
	void* pWork;
	int	seq;
}DEB_SKYJUMP;

/**
 *	@brief	fobOԃRg[^XN
 */
extern void FieldTMap_CallDataSet(FIELDSYS_WORK* fsys,TOWNMAP_PARAM *tp,int mode);
static void DebugSkyjumpTask(TCB_PTR tcb,void* work)
{
	DEB_SKYJUMP	*wp = (DEB_SKYJUMP*)work;
	TOWNMAP_PARAM* twork;

	switch(wp->seq){
	case 0:
		FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKOUT );
		break;
	case 1:
		if(IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) == FALSE){
			return;
		}
		//^E}bv@ԃ[hĂяo
		wp->pWork = sys_AllocMemory(HEAPID_BASE_DEBUG,sizeof(TOWNMAP_PARAM));
		FieldTMap_CallDataSet(wp->fsys,wp->pWork,TMAP_MJUMP);
		FieldTMap_SetProc(wp->fsys,wp->pWork);
		break;
	case 2:
		//^E}bvvZXI҂
		if(FieldEvent_Cmd_WaitSubProcEnd(wp->fsys)){
			return;
		}
		//tB[hvZXA
		FieldEvent_Cmd_SetMapProc(wp->fsys);
		break;
	case 3:
		//tB[hvZXJnI҂
		if(!FieldEvent_Cmd_WaitMapProcStart(wp->fsys)){
			return;
		}
		//ubNCNGXg
		FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKIN );
		break;
	case 4:
		//tF[hC҂
		if ( !IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) ){
			return;
		}
		//p[^擾
		twork = (TOWNMAP_PARAM*)wp->pWork;
		if(!twork->retval){
			break;
		}

		//Wv
		EventSet_MapChange(wp->fsys,
			twork->ret_zone,DOOR_ID_JUMP_CODE,
			twork->ret_x*32+16,twork->ret_z*32+16, DIR_DOWN);
		break;
	case 5:
		sys_FreeMemoryEz(wp->pWork);
		sys_FreeMemoryEz(wp);
		TCB_Delete(tcb);
		return;
	}
	wp->seq++;
}


/**
 *	@brief	fobOԁ@^XNo^
 */
void DebugSkyJump_CreateTask(FIELDSYS_WORK* fsys)
{
	DEB_SKYJUMP *wp;

	//ԃ^XN쐬
	wp = sys_AllocMemory(HEAPID_BASE_DEBUG,sizeof(DEB_SKYJUMP));
	MI_CpuClear8(wp,sizeof(DEB_SKYJUMP));

	wp->fsys = fsys;
	TCB_Add(DebugSkyjumpTask,wp,0);
}

#endif	//PM_DEBUG
