//============================================================================================
/**
 *	@file	fld_debug.c
 *	@brief	tB[hfobOj[p\[X
 *
 *	@date	04/12/17
 *	@author	Game Freak Inc.
 */
//============================================================================================

#ifdef	PM_DEBUG


#include "common.h"
#include "system/bmp_list.h"
#include "system/bmp_menu.h"
#include "fld_bmp.h"
#include "system/fontproc.h"
#include "fieldmap.h"
#include "fieldsys.h"
#include "debug_saito.h"
#include "d_tomoya.h"
#include "d_taya.h"

#include "ev_mapchange.h"
#include "fld_debug.h"
#include "zonedata.h"
#include "div_map.h"
#include <ctype.h>
#include "system/builddate.h"
#include "system/window.h"

#include "mapdefine.h"

#include "system/snd_tool.h"
#include "field/field.h"
#include "poketool/poke_tool.h"
#include "poketool/status_rcv.h"
#include "poketool/pokeparty.h"
#include "itemtool/myitem.h"
#include "itemtool/itemsym.h"

#include "system/pm_rtc.h"
#include "gflib/strbuf.h"
#include "gflib/strbuf_family.h"
#include "field/field_matrix.h"

#include "fieldmap_work.h"			//FIELDMAP_WORK
#include "fieldmap_func.h"			//FLDMAPFUNC_`

/********************************************************************/
/*                                                                  */
/*	O[o`													*/
/*                                                                  */
/********************************************************************/
//pFunc	DebugUserfunc	= {0};
//u8		DebugUserWindow = {0};
static  int DebugStressFlg= FALSE;

typedef struct _FLD_DEB_DAT{
	u8	work;
	u16 DebugList;
	u16 DebugCursor;
	BMPLIST_WORK *blistWk;
	FIELDSYS_WORK * fsys;
	GF_BGL_BMPWIN* pBmpwin;
	BMPLIST_DATA * menulist;
	void (*finish_func)(FIELDSYS_WORK *);
}FLD_DEB_DAT;

///gmm烁j[Ƃp̃Xg`\
typedef struct _GMM_MENU_PARAM{
	u32	str_id;	///<bZ[WID
	u32	param;	///<p[^
}GMM_MENU_PARAM;

/********************************************************************/
/*                                                                  */
/*	[J`													*/
/*                                                                  */
/********************************************************************/
//fobOڃEChEf[^
#define	FDBG_LIST_PX1		(0)		//wW1
#define	FDBG_LIST_PY1		(1+4)		//xW1
#define	FDBG_LIST_PX2		(20)	//wW2
#define	FDBG_LIST_PY2		(4)		//xW2
#define	FDBG_LIST_SX		(12)	//wTCY
#define	FDBG_LIST_SY		(18)	//xTCY
#define	FDBG_LIST_PL		(FLD_SYSFONT_PAL)	//pbgio[
#define	FDBG_LIST_CH		(8)

//}bvEChEf[^
#define	FDBG_INFO_PX1		(0)		//wW1
#define	FDBG_INFO_PY1		(17)	//xW1
#define	FDBG_INFO_PX2		(0)		//wW2
#define	FDBG_INFO_PY2		(0)		//xW2
#define	FDBG_INFO_SX		(30)	//wTCY
#define	FDBG_INFO_SY		(3)		//xTCY
#define	FDBG_INFO_PL		(FLD_SYSFONT_PAL)	//pbgio[
#define	FDBG_INFO_CH		(FDBG_LIST_CH + FDBG_LIST_SX * FDBG_LIST_SY)

//EChEf[^
#define	FDBG_RSLT_PX		(0)		//wW
#define	FDBG_RSLT_PY		(16)	//xW
#define	FDBG_RSLT_SX		(30)	//wTCY
#define	FDBG_RSLT_SY		(4)		//xTCY
#define	FDBG_RSLT_PL		(FLD_SYSFONT_PAL)	//pbgio[
#define	FDBG_RSLT_CH		(8)

//p[U[EChEf[^
#define	FDBG_USER_PX		(5)		//wW
#define	FDBG_USER_PY		(1)		//xW
#define	FDBG_USER_SX		(20)	//wTCY
#define	FDBG_USER_SY		(16)	//xTCY
#define	FDBG_USER_PL		(FLD_SYSFONT_PAL)	//pbgio[
#define	FDBG_USER_CH		(8)

#define STRESS_INFO_PAL_OFFSET	(64)
#define	STRESS_INFO_PAL_SIZE	(32)

static void	FieldDebugListControlTask(TCB_PTR tcb,void* work);
static void	FieldDebugListExitTask(TCB_PTR tcb,void* work);

//static void	FieldDebugExitNextProc(pFunc func,TCB_PTR tcb,void* work);
static void	FieldDebugExitMsg(void* msg,TCB_PTR tcb,void* work);
static void	FieldDebugExitMsgFont(u8 f_index,void* msg,TCB_PTR tcb,void* work);
static void	FieldDebugExit(TCB_PTR tcb,void* work);
static void FieldDebugExitCall(TCB_PTR tcb, void * work);

static void LocalMsgPrint(GF_BGL_BMPWIN *pWin,u8 w_index,u8 f_index,void* msg,u8 x,u8 y);
static FLD_DEB_DAT * FieldDebugListCreate(
		FIELDSYS_WORK * fsys, const BMPLIST_DATA * list, int count);
static FLD_DEB_DAT * FieldDebugListCreateGMM(
		FIELDSYS_WORK * fsys,int arcID,const GMM_MENU_PARAM * list, int count,TCB_FUNC func);
static void	FieldDebugListFree(void* work);

static void	InfoCallBack2(BMPLIST_WORK* lw,u32 param,u8 y);

static void FieldDebugTamadaListSet(FIELDSYS_WORK * fsys);
static void FieldDebugMapChangeList(FIELDSYS_WORK * fsys);
static void FieldDebugRTCListSet(FIELDSYS_WORK * fsys);

void FieldBitMapWinCgxSet( GF_BGL_INI * ini);

extern void DebugMoriMenuInit(GF_BGL_INI *ini, FIELDSYS_WORK *fsys);
extern void DebugWatanabeMenuInit( void* fsys );
extern void DebugTomoInit(void);
extern void DebugNakamuraInit( void * fsys );
extern void DebugMiyukiInit(void* fsys);
extern void DebugSogabeMenuInit(FIELDSYS_WORK* fsys);
extern void DebugGotoMenuInit(FIELDSYS_WORK* fsys);
extern void DebugNoharaMenuInit( FIELDSYS_WORK* fsys );
extern void DebugMatsudaInit(FIELDSYS_WORK *fsys);
extern void DebugKagayaMenuInit( FIELDSYS_WORK *fsys );

extern BMP_MENULIST_DATA * BMP_MENULIST_CreateByList( u32 heapID,
		u32 maxElems, const BMP_MENULIST_DATA * data);
/********************************************************************/
/*                                                                  */
/*				j[֐										*/
/*                                                                  */
/********************************************************************/


//--------------------------------------------------------------------
///j[:uX^bt悤vu킽Ȃׁv
//--------------------------------------------------------------------
static void Debug_staff_watanabe(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT* wk = (FLD_DEB_DAT*)work;
	void* fsys = (void*)wk->fsys;
	
	FieldDebugExitCall(tcb, work);

	DebugWatanabeMenuInit(fsys);
//	FieldDebugExit(tcb,work);
}

//--------------------------------------------------------------------
///j[:uX^bt悤vuv
//--------------------------------------------------------------------
static void Debug_staff_mori(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;
	GF_BGL_INI *ini  = (GF_BGL_INI *)wk->fsys->bgl;

	FieldDebugExitCall(tcb, work);

	DebugMoriMenuInit(ini, wk->fsys);
}

//--------------------------------------------------------------------
///j[:uX^bt悤vuƂ݂v
//--------------------------------------------------------------------
static void Debug_staff_tomomiti(TCB_PTR tcb,void* work)
{
	
	// ĂԂƗĂ܂̂ňUI悤ɂ
	FieldDebugExit(tcb,work);

#if 0
	FieldDebugExitCall(tcb, work);

	DebugTomoInit();
#endif
}

//--------------------------------------------------------------------
///j[:uX^bt悤vuȂނv
//--------------------------------------------------------------------
static void Debug_staff_nakahiro(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;
	void * tmp = (void *)wk->fsys;

	FieldDebugExitCall(tcb, work);

	DebugNakamuraInit( tmp );
}
//--------------------------------------------------------------------
///j[:uX^bt悤vuƂv
//--------------------------------------------------------------------
static void Debug_staff_saitou(TCB_PTR tcb,void* work)
{
	FIELDSYS_WORK * fsys;
	FLD_DEB_DAT	*wp;
	wp = (FLD_DEB_DAT*)work;
	fsys = wp->fsys;
	
	FieldDebugExitCall(tcb, work);

	DBGSAI_MapNumDebugListSet(fsys);
}
//--------------------------------------------------------------------
///j[:uX^bt悤vuƂv
//--------------------------------------------------------------------
static void Debug_staff_tomoya(TCB_PTR tcb,void* work)
{
	FieldDebugExitCall(tcb, work);

	DebugListSetOfTomoya(((FLD_DEB_DAT *)work)->fsys);
//	FieldDebugExit(tcb,work);
}

//--------------------------------------------------------------------
///j[:uX^bt悤vu킳v
//--------------------------------------------------------------------
static void Debug_staff_miyuki(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;
	void * tmp = (void *)wk->fsys;

	FieldDebugExitCall(tcb, work);

	DebugMiyukiInit(tmp);
}


//--------------------------------------------------------------------
//j[ځF
//--------------------------------------------------------------------
extern void DebugSkyJump_CreateTask(FIELDSYS_WORK* fsys);
static void Debug_skyjump(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;

	//ԃ^XN쐬
	DebugSkyJump_CreateTask(wk->fsys);	
	FieldDebugExitCall(tcb, work);
}


//--------------------------------------------------------------------
///j[:uX^bt悤vuׁv
//--------------------------------------------------------------------
static void Debug_staff_sogabe(TCB_PTR tcb,void* work)
{
#if 0
	FLD_DEB_DAT* wk = (FLD_DEB_DAT*)work;
	void* fsys = (void*)wk->fsys;
	
	FieldDebugExitCall(tcb, work);
	DebugSogabeMenuInit(fsys);
#endif
	FieldDebugExit(tcb,work);
}

//--------------------------------------------------------------------
///j[:uX^bt悤vu܂v
//--------------------------------------------------------------------
static void Debug_staff_tamada(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;
	FIELDSYS_WORK * fsys = wk->fsys;
	FieldDebugExitCall(tcb, work);
	FieldDebugTamadaListSet(fsys);
}


//--------------------------------------------------------------------
///j[:uX^bt悤vu܂v
//--------------------------------------------------------------------
static void Debug_staff_matsuda(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT *fdd = work;
	
	FieldDebugExitCall(tcb, work);

	DebugMatsudaInit(fdd->fsys);
}

//--------------------------------------------------------------------
///j[:uX^bt悤vuv
//--------------------------------------------------------------------
static void Debug_staff_kagaya(TCB_PTR tcb,void* work)
{
#if 0
	FieldDebugExit(tcb,work);
#else
	FLD_DEB_DAT *fdd = work;
	FieldDebugExitCall(tcb, work);
	DebugKagayaMenuInit(fdd->fsys);
#endif
}


//--------------------------------------------------------------------
///j[:uX^bt悤vû͂v
//--------------------------------------------------------------------
static void Debug_staff_nohara(TCB_PTR tcb,void* work)
{
	FieldDebugExitCall(tcb, work);
	DebugNoharaMenuInit( ((FLD_DEB_DAT *)work)->fsys );
}

//--------------------------------------------------------------------
///j[:uX^bt悤vuv
//--------------------------------------------------------------------
static void Debug_staff_taya(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;

	FieldDebugExitCall(tcb, work);
	DebugTayaMenuInit( (void*)(wk->fsys) );
}

//--------------------------------------------------------------------
///j[:uX^bt悤vuƂv
//--------------------------------------------------------------------
static void Debug_staff_gotou(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT* wk = (FLD_DEB_DAT*)work;
	void* fsys = (void*)wk->fsys;
	
	FieldDebugExitCall(tcb, work);
	DebugGotoMenuInit(fsys);
#if 0
	FieldDebugExit(tcb,work);
#endif
}


extern void DebugCommMenuInit(void* pFSys);  // d_ohno.c
//--------------------------------------------------------------------
///j[:uX^bt悤vúv
//--------------------------------------------------------------------
static void Debug_staff_ohno(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;
	void * tmp = (void *)wk->fsys;

	FieldDebugExitCall(tcb, work);

	DebugCommMenuInit(tmp);  // tB[hVXen
//	FieldDebugExit(tcb,work);
}

//--------------------------------------------------------------------
/*
 *	@brief	j[:eXg
 */
//--------------------------------------------------------------------
static void Debug_test_func(void)
{
	if(sys.trg & PAD_BUTTON_A){
//		DebugUserfunc = NULL;
	}
}

//׏\LZbg֐
void DebugStressDispSet(const BOOL inFlg)
{
	DebugStressFlg = inFlg;
	
	if (DebugStressFlg){
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_ON );
	}else{
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
	}
}


//--------------------------------------------------------------------
///j[ځFӂ`FbNpvgS\ON
//--------------------------------------------------------------------
static void Debug_huka_check_on(TCB_PTR tcb,void* work)
{
	if(DebugStressFlg==0){
		DebugStressFlg = 1;
	}else{
		DebugStressFlg = 0;
	}
	
	if (DebugStressFlg){
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_ON );
	}else{
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
	}
	
	FieldDebugExit(tcb,work);
	
}

//--------------------------------------------------------------------
///j[ځFʒumF̂߂̕\ON
//--------------------------------------------------------------------
static void Debug_ichi_check_on(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT	* wp = (FLD_DEB_DAT	*)work;

	if(DebugStressFlg==0){
		GF_BGL_ScrClear( wp->fsys->bgl, FLD_MBGFRM_EFFECT1 );
		DebugStressFlg = 2;
	}else{
		DebugStressFlg = 0;
		GF_BGL_ScrClear( wp->fsys->bgl, FLD_MBGFRM_EFFECT1 );
//		GF_BGL_ScrFill( FLD_MBGFRM_EFFECT1, 0, 0, 0, 32, 24, 0 );
	}
	
	if (DebugStressFlg){
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_ON );
	}else{
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
	}
	
	FieldDebugExit(tcb,work);
	
}

//--------------------------------------------------------------------
///j[ځF}bvWv(㉺)
//--------------------------------------------------------------------
static void Debug_map_jump_up_down(TCB_PTR tcb,void* work)
{
	FIELDSYS_WORK * fsys;
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;	
	fsys = wk->fsys;

    // fobOj[炢ꍇ ꏊɉ悤ɂ܂
    // 閧nɍ~Ƃ܂ׂł k.ohno
    Debug_ChangeUnderGroundDirect(fsys, 47, 384);
/**	
	{
		const CONNECT_DATA * connect;
		connect = DebugGetSxyData(fsys->location->area_id, fsys->location->zone_id, 0);
		if (connect == NULL) {
			;
		}
		EventSet_MapChange(fsys, connect->link_area_id,
				connect->link_zone_id, connect->link_door_id, 0, 0, DIR_DOWN );
	}
*/	
	FieldDebugExit(tcb,work);
	
}

//--------------------------------------------------------------------
///j[ځF}bvWv
//--------------------------------------------------------------------
static void Debug_map_jump(TCB_PTR tcb,void* work)
{
	FIELDSYS_WORK * fsys;
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;	
	fsys = wk->fsys;

	FieldDebugExitCall(tcb, work);

	DBGSAI_JumpMapControl(fsys);

}

//--------------------------------------------------------------------
///j[ځF jI[
//--------------------------------------------------------------------
static void Debug_map_jump_union(TCB_PTR tcb, void* work)
{
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;
	FieldDebugExit(tcb,work);

	EventSet_UnionRoomMapChange(wk->fsys);
}


//--------------------------------------------------------------------
///j[ځFntB[h Town01ɋWv(n}̉p)
//--------------------------------------------------------------------
static void Debug_map_jump_t01(TCB_PTR tcb, void* work)
{
	FLD_DEB_DAT* wk = (FLD_DEB_DAT *)work;
	FieldDebugExit(tcb,work);

	EventSet_MapChange(wk->fsys, ZONE_ID_T01, DOOR_ID_JUMP_CODE, 3*32+16, 27*32+16, DIR_DOWN);
}

//--------------------------------------------------------------------
///j[ځF mZWWv
//--------------------------------------------------------------------
static void Debug_map_jump_gym01_00_00(TCB_PTR tcb, void* work)
{
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;
	FieldDebugExit(tcb,work);

	EventSet_MapChange(wk->fsys, ZONE_ID_C06GYM0101, DOOR_ID_JUMP_CODE, 16, 16, DIR_DOWN);
}

//--------------------------------------------------------------------
///j[ځFXg/ǂłWvj[Rg[
//--------------------------------------------------------------------
//------------------------------------------------------------------
/**
 *	@brief	tB[hfobOWvpC^XN
 *
 *	@param	tcb		TCB_PTR:Ăяo^XNubNւ̃|C^
 *	@param	work	void*:Ăяo^XNubN[Nւ̃|C^
 */
//------------------------------------------------------------------
static void FieldDebugListJumpMenuTask(TCB_PTR tcb,void* work)
{
	s32	ret_code;
	TCB_FUNC	func;
	FLD_DEB_DAT	*wp;
	u16 x,z;

	wp = (FLD_DEB_DAT*)work;

	ret_code = BmpListMain(wp->blistWk);
	//L[씻
	if(sys.trg & PAD_BUTTON_A){
		if(ret_code){
			x = z = 0;
			GetBlockPosFromZoneID(ret_code,&x,&z);
			//wp->fsys->field_zone_id = ret_code;
			//wp->fsys->field_x = x*32+16;
			//wp->fsys->field_z = z*32+16;
			EventSet_MapChange(wp->fsys,
					ret_code, DOOR_ID_JUMP_CODE, x*32+16, z*32+16, DIR_DOWN);
				//wp->fsys->field_zone_id,DOOR_ID_JUMP_CODE,
				//wp->fsys->field_x,wp->fsys->field_z, DIR_DOWN);
		}
		FieldDebugExit(tcb,work);
		return;
	}
	//j[LZ
	if(sys.trg & PAD_BUTTON_B){
		if (wp->finish_func != NULL) {
			FIELDSYS_WORK * fsys = wp->fsys;
			void (*func)(FIELDSYS_WORK*) = wp->finish_func;
			FieldDebugExitCall(tcb,work);
			func(wp->fsys);
		} else {
			FieldDebugExit(tcb,work);
		}
		return;
	}
}
//--------------------------------------------------------------------
///j[ځFXgWvj[ڒ`
//--------------------------------------------------------------------
#include "msgdata/msg.naix"
#include "msgdata/msg_debug_list_jump.h"

static const GMM_MENU_PARAM FieldDebugListJumpMenu1[] = {
	{ msg_label_listjump1,	BMPLIST_RABEL},			//x01
	{ msg_buil01_00_00,	ZONE_ID_C03R0101},	//
	{ msg_buil02_00_00,	ZONE_ID_C04R0202},	//
	{ msg_buil03_00_00,	ZONE_ID_C04R0203},	//
	{ msg_buil04_00_00,	ZONE_ID_C04R0302},	//
	{ msg_buil05_00_00,	ZONE_ID_C03R0102},	//
	{ msg_buil06_00_00,	ZONE_ID_C03R0104},	//
	{ msg_buil07_00_00,	ZONE_ID_C05R0101},	//
	{ msg_buil08_00_00,	ZONE_ID_C05R0102},	//
	{ msg_love01_00_00,	ZONE_ID_C05R0201},	//
	{ msg_grow01_00_00,	ZONE_ID_T04R0101},	//
	{ msg_bike01_00_00,	ZONE_ID_C04R0101},	//
	{ msg_scho01_00_00,	ZONE_ID_C01R0701},	//
	{ msg_gate01_00_00,	ZONE_ID_R206R0201},	//
	{ msg_gate02_00_00,	ZONE_ID_R218R0101},	//
	{ msg_gate03_00_00,	ZONE_ID_C04R0401},	//
	{ msg_d12r0101,		ZONE_ID_D12R0101},	//
	{ msg_t04r0101,		ZONE_ID_T04R0101},	//
	{ msg_exit_listjump,		 0x00000000},		//00:
};
static const GMM_MENU_PARAM FieldDebugListJumpMenu2[] = {
	{ msg_label_listjump2,	BMPLIST_RABEL},			//x01
	{ msg_libra01_00_00,ZONE_ID_C02R0101},	//
	{ msg_libra02_00_00,ZONE_ID_C02R0102},	//
	{ msg_libra03_00_00,ZONE_ID_C02R0103},	//
	{ msg_wise01_00_00,	ZONE_ID_T05R0101},	//
	{ msg_muse01_00_00,	ZONE_ID_C03R0401},	//
	{ msg_comp01_00_00,	ZONE_ID_C01R0101},	//
	{ msg_comp02_00_00,	ZONE_ID_C01R0102},	//
	{ msg_comp03_00_00,	ZONE_ID_C01R0103},	//
	{ msg_shouse01_00_00,ZONE_ID_C07R0101},	//
	{ msg_phouse01_00_00,ZONE_ID_D02R0101},	//
	{ msg_exit_listjump,		 0x00000000},		//00:
};
static const GMM_MENU_PARAM FieldDebugListJumpMenuGym[] = {
	{ msg_label_listjump_gym,	BMPLIST_RABEL},			//x01
	{ msg_gym01_00_00,	ZONE_ID_C06GYM0101},	//
	{ msg_gym02_00_00,	ZONE_ID_C02GYM0101},	//
	{ msg_gym03_00_00,	ZONE_ID_C03GYM0101},	//
	{ msg_gym0401_00_00,	ZONE_ID_C04GYM0101},	//
	{ msg_gym0402_00_00,	ZONE_ID_C04GYM0102},	//
	{ msg_gym0501_00_00,	ZONE_ID_C05GYM0101},	//
	{ msg_gym0502_00_00,	ZONE_ID_C05GYM0102},	//
	{ msg_gym0503_00_00,	ZONE_ID_C05GYM0103},	//
	{ msg_gym0504_00_00,	ZONE_ID_C05GYM0104},	//
	{ msg_gym06_00_00,	ZONE_ID_C09GYM0101},	//
	{ msg_gym07_00_00,	ZONE_ID_C07GYM0101},	//
	{ msg_gym0801_00_00,	ZONE_ID_C08GYM0101},	//
	{ msg_gym0802_00_00,	ZONE_ID_C08GYM0102},	//
	{ msg_gym0803_00_00,	ZONE_ID_C08GYM0103},	//
	{ msg_exit_listjump,		 0x00000000},		//00:
};
//--------------------------------------------------------------------
///j[ځFWWv
//--------------------------------------------------------------------
static void Debug_map_jump_list_gym(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT * wp = (FLD_DEB_DAT *)work;
	FIELDSYS_WORK * fsys = wp->fsys;
	FieldDebugExitCall(tcb, work);
	
	wp = FieldDebugListCreateGMM(fsys, NARC_msg_debug_list_jump_dat,
			FieldDebugListJumpMenuGym, NELEMS(FieldDebugListJumpMenuGym),FieldDebugListJumpMenuTask);
	wp->finish_func = FieldDebugListSet;

	//CxgtbN
	FieldSystemProc_SeqHold();
}
//--------------------------------------------------------------------
///j[ځFXgWv1
//--------------------------------------------------------------------
static void Debug_map_jump_list(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT * wp = (FLD_DEB_DAT *)work;
	FIELDSYS_WORK * fsys = wp->fsys;
	FieldDebugExitCall(tcb, work);
	
	wp = FieldDebugListCreateGMM(fsys, NARC_msg_debug_list_jump_dat,
			FieldDebugListJumpMenu1, NELEMS(FieldDebugListJumpMenu1),FieldDebugListJumpMenuTask);
	wp->finish_func = FieldDebugListSet;

	//CxgtbN
	FieldSystemProc_SeqHold();
}

//--------------------------------------------------------------------
///j[ځFXgWv2
//--------------------------------------------------------------------
static void Debug_map_jump_list2(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT * wp = (FLD_DEB_DAT *)work;
	FIELDSYS_WORK * fsys = wp->fsys;
	FieldDebugExitCall(tcb, work);
	
	wp = FieldDebugListCreateGMM(fsys, NARC_msg_debug_list_jump_dat,
			FieldDebugListJumpMenu2, NELEMS(FieldDebugListJumpMenu2),FieldDebugListJumpMenuTask);
	wp->finish_func = FieldDebugListSet;

	//CxgtbN
	FieldSystemProc_SeqHold();
}
//--------------------------------------------------------------------
///j[ځFǂłWv
//--------------------------------------------------------------------
static void Debug_map_jump_flex(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT * wp = (FLD_DEB_DAT *)work;
	FIELDSYS_WORK * fsys = wp->fsys;
	FieldDebugExitCall(tcb, work);
	
	wp = FieldDebugListCreateGMM(fsys, 0,
			NULL, ZONE_ID_MAX-2,FieldDebugListJumpMenuTask);
	wp->finish_func = FieldDebugListSet;
}

//--------------------------------------------------------------------
///j[ځFAEgW\
//--------------------------------------------------------------------
static void Debug_out_range_disp(TCB_PTR tcb,void* work)
{
	FIELDSYS_WORK * fsys;
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;	
	fsys = wk->fsys;

	SetDebugOutRangeFlg();
	FieldDebugExit(tcb,work);
	
}

extern void DebugItemMakeInit( void * fsys );
//--------------------------------------------------------------------
///j[ځF f[^EACe
//--------------------------------------------------------------------
static void Debug_itemmake(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;
	void * tmp = (void *)wk->fsys;

	FieldDebugExitCall(tcb, work);

	DebugItemMakeInit( tmp );
}

extern void DebugPokemonMakeInit( void * fsys );
//--------------------------------------------------------------------
///j[ځF f[^E|P
//--------------------------------------------------------------------
static void Debug_pokemonmake(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;
	void * tmp = (void *)wk->fsys;

	FieldDebugExitCall(tcb, work);
	DebugPokemonMakeInit( tmp );
}

//--------------------------------------------------------------------
///j[ځF̑̃}bvؑ
//--------------------------------------------------------------------
static void Debug_jump_other(TCB_PTR tcb, void * work)
{
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;
	FIELDSYS_WORK * fsys = wk->fsys;
	FieldDebugExitCall(tcb, work);
	FieldDebugMapChangeList(fsys);
}
//--------------------------------------------------------------------
/**
 * @brief	j[ځF^Cgɖ߂
 *
 * [NĂ邩ǂ̃`FbNpH
 */

//--------------------------------------------------------------------
static void Debug_return_title(TCB_PTR tcb, void * work)
{
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;
	void * fsys = (void *)wk->fsys;

	EventSet_ReturnToTitle(fsys);
	FieldDebugExit(tcb,work);
}

//--------------------------------------------------------------------
///j[ځFAgr[gmF
//--------------------------------------------------------------------
static void Debug_check_attribute(TCB_PTR tcb,void* work)
{
	FIELDSYS_WORK * fsys;
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;	
	fsys = wk->fsys;

	FieldDebugExitCall(tcb, work);
	DBGSAI_CheckAttribute(fsys);
}

//--------------------------------------------------------------------
///j[:uƂv
//--------------------------------------------------------------------
static void Debug_control_time(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT	* wk = (FLD_DEB_DAT *)work;
	FIELDSYS_WORK * fsys = wk->fsys;
	FieldDebugExitCall(tcb, work);
	FieldDebugRTCListSet(fsys);
}

//==============================================================================
//
//
//
//==============================================================================
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static const u16 Rabel01[]	= {ka_,n_,si_,yo_,u_,EOM_};
static const u16 Rabel02[]	= {SU_,TA_,TTU_,HU_,yo_,u_,EOM_};
static const u16 Rabel03[]	= {ZI_,YYA_,N_,PU_,EOM_};
static const u16 Rabel04[]	= {A_,U_,TO_,RE_,N_,ZI_,EOM_};
static const u16 Rabel05[]	= {DE_,bou_,TA_,sa_,ku_,se_,i_,EOM_};
static const u16 Rabel06[]	= {SI_,SU_,TE_,MU_,EOM_};

static const u16 Msg02_01[]	= {wa_,ta_,na_,be_,EOM_};
static const u16 Msg02_02[]	= {mo_,ri_,EOM_};
static const u16 Msg02_03[]	= {na_,ka_,mu_,ra_,EOM_};
static const u16 Msg02_04[]	= {to_,mo_,mi_,ti_,EOM_};
static const u16 Msg02_05[]	= {sa_,i_,to_,u_,EOM_};
static const u16 Msg02_06[]	= {to_,mo_,ya_,EOM_};
static const u16 Msg02_07[]	= {i_,wa_,sa_,wa_,EOM_};

static const u16 Msg02_08[]	= {so_,ga_,be_,EOM_};
static const u16 Msg02_09[]	= {ta_,ma_,da_,EOM_};
static const u16 Msg02_10[]	= {ma_,tu_,da_,EOM_};
static const u16 Msg02_11[]	= {ka_,ga_,ya_,EOM_};
static const u16 Msg02_12[]	= {no_,ha_,ra_,EOM_};
static const u16 Msg02_13[]	= {ta_,ya_,EOM_};
static const u16 Msg02_14[]	= {go_,to_,u_,EOM_};
static const u16 Msg02_15[]	= {o_,o_,no_,EOM_};

static const u16 Msg02_16[] = { hu_,ka_,TI_,EE_,TTU_,KU_,EOM_ };
static const u16 Msg02_17[] = { i_,ti_,TI_,EE_,TTU_,KU_,EOM_ };
static const u16 Msg02_19[] = { ki_,ri_,ka_,e_,EOM_ };

static const u16 Msg02_24[] = { ka_,ku_,ni_,n_,EOM_ };
static const u16 Msg02_25[] = { so_,ra_,wo_,to_,bu_,EOM_ };

static const u16 Msg02_27[] = { ZI_,MU_,ZI_,YYA_,N_,PU_,EOM_ };
static const u16 Msg02_28[] = { RI_,SU_,TO_,ZI_,YYA_,N_,PU_,EOM_ };
static const u16 Msg02_29[] = { RI_,SU_,TO_,ZI_,YYA_,N_,PU_,n2_,EOM_ };
static const u16 Msg02_30[] = { do_,ko_,de_,mo_,ZI_,YYA_,N_,PU_,EOM_ };

static const u16 Msg05_01[] = { PO_,KE_,MO_,N_,EOM_ };
static const u16 Msg05_02[] = { A_,I_,TE_,MU_,EOM_ };

static const u16 Msg03_01[] = { zi_,ka_,n_,EOM_ };
static const u16 Msg03_02[] = { MA_,TTU_,PU_,so_,no_,ta_,EOM_ };

static const BMPLIST_DATA FieldDebugList[] = {
	{(void*)Rabel01,BMPLIST_RABEL},
	{(void*)Msg02_16,(u32)Debug_huka_check_on},
	{(void*)Msg02_17,(u32)Debug_ichi_check_on},
	{(void*)Msg02_24,(u32)Debug_check_attribute},
	{(void*)Rabel06,BMPLIST_RABEL},
	{(void*)Msg03_01, (u32)Debug_control_time},
	{(void*)Rabel03,BMPLIST_RABEL},
	{(void*)Msg02_25,(u32)Debug_skyjump},
	{(void*)Msg02_27,(u32)Debug_map_jump_list_gym},
	{(void*)Msg02_28,(u32)Debug_map_jump_list},
	{(void*)Msg02_29,(u32)Debug_map_jump_list2},
	{(void*)Msg02_30,(u32)Debug_map_jump_flex},
	{(void*)Msg03_02,(u32)Debug_jump_other},
	{(void*)Rabel04,BMPLIST_RABEL},
	{(void*)Msg02_19,(u32)Debug_out_range_disp},
	{(void*)Rabel05,BMPLIST_RABEL},
	{(void*)Msg05_01,(u32)Debug_pokemonmake},
	{(void*)Msg05_02,(u32)Debug_itemmake},
	{(void*)Rabel02,BMPLIST_RABEL},
	{(void*)Msg02_01,(u32)Debug_staff_watanabe},
	{(void*)Msg02_09,(u32)Debug_staff_tamada},
	{(void*)Msg02_08,(u32)Debug_staff_sogabe},
	{(void*)Msg02_02,(u32)Debug_staff_mori},
	{(void*)Msg02_04,(u32)Debug_staff_tomomiti},
	{(void*)Msg02_10,(u32)Debug_staff_matsuda},
	{(void*)Msg02_11,(u32)Debug_staff_kagaya},
	{(void*)Msg02_03,(u32)Debug_staff_nakahiro},
	{(void*)Msg02_12,(u32)Debug_staff_nohara},
	{(void*)Msg02_13,(u32)Debug_staff_taya},
	{(void*)Msg02_07,(u32)Debug_staff_miyuki},
	{(void*)Msg02_05,(u32)Debug_staff_saitou},
	{(void*)Msg02_14,(u32)Debug_staff_gotou},
	{(void*)Msg02_06,(u32)Debug_staff_tomoya},
	{(void*)Msg02_15,(u32)Debug_staff_ohno},
};

/********************************************************************/
/*                                                                  */
/*	tB[hfobOj[Xgݒ							*/
/*                                                                  */
/********************************************************************/
//------------------------------------------------------------------
/**
 *	@brief	tB[hfobOj[Xgݒ
 *
 *	@param	fsys
 */
//------------------------------------------------------------------
void FieldDebugListSet(FIELDSYS_WORK * fsys)
{
	FLD_DEB_DAT * wp;
	wp = FieldDebugListCreate(fsys, FieldDebugList, NELEMS(FieldDebugList));
	wp->finish_func = NULL;

	//CxgtbN
	FieldSystemProc_SeqHold();
	return;
}


//============================================================================================
//============================================================================================
static const u16 MsgJump_UG[] = { zi_,yyo_,u_,ge_,EOM_ };
static const u16 MsgJump_XZ[] = { Z__,X__,si_,te_,i_,EOM_ };
static const u16 MsgJump_Union[] = { YU_,NI_,O_,N_,EOM_ };
static const u16 MsgJump_T01[] = { ZI_,YYA_,N_,PU_,T__,n0_,n1_,EOM_ };
static const u16 MsgJump_Title[] = { TA_,I_,TO_,RU_,he_,mo_,do_,ru_,EOM_ };
static const u16 MsgJump_GYM01[] = { ZI_,YYA_,N_,PU_,g__,y__,m__,n0_,n1_,EOM_ };

//--------------------------------------------------------------------
//--------------------------------------------------------------------
static const BMPLIST_DATA FieldDebugJumpList[] = {
	{(void*)MsgJump_UG,(u32)Debug_map_jump_up_down},
	{(void*)MsgJump_XZ,(u32)Debug_map_jump},
	{(void*)MsgJump_Union,(u32)Debug_map_jump_union},
	{(void*)MsgJump_T01,(u32)Debug_map_jump_t01},
	{(void*)MsgJump_GYM01,(u32)Debug_map_jump_gym01_00_00},
	{(void*)MsgJump_Title,(u32)Debug_return_title},
};

//--------------------------------------------------------------------
//--------------------------------------------------------------------
static void FieldDebugMapChangeList(FIELDSYS_WORK * fsys)
{
	FLD_DEB_DAT * wp;
	wp = FieldDebugListCreate(fsys, FieldDebugJumpList, NELEMS(FieldDebugJumpList));
	wp->finish_func = FieldDebugListSet;

	//CxgtbN
	FieldSystemProc_SeqHold();
}

//============================================================================================
//============================================================================================
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static void Debug_tamada_01(TCB_PTR tcb, void* work)
{
	FLD_DEB_DAT * wk = work;
	u16 item;

	item = ITEM_SUKUSUKUKOYASI;
	do {
		if (MyItem_CheckItem(SaveData_GetMyItem(wk->fsys->savedata), item, 1, HEAPID_FIELD)) {
			item ++;
		} else {
			MyItem_AddItem(SaveData_GetMyItem(wk->fsys->savedata), item, 1, HEAPID_FIELD);
			Snd_SePlay(SEQ_SE_DP_SELECT);
			break;
		}
	}while (item <= ITEM_NEBANEBAKOYASI);

	//FieldDebugListSet(((FLD_DEB_DAT*)work)->fsys);
	//FieldDebugExitCall(tcb,work);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static void Debug_tamada_02(TCB_PTR tcb, void* work)
{
	FLD_DEB_DAT * wk = work;
	u16 item;
	item = ITEM_KURABONOMI;
	do {
		if (MyItem_CheckItem(SaveData_GetMyItem(wk->fsys->savedata), item, 1, HEAPID_FIELD)) {
			item ++;
		} else {
			MyItem_AddItem(SaveData_GetMyItem(wk->fsys->savedata), item, 1, HEAPID_FIELD);
			Snd_SePlay(SEQ_SE_DP_SELECT);
			break;
		}
	}while (item <= ITEM_64NOMI);

	//FieldDebugListSet(((FLD_DEB_DAT*)work)->fsys);
	//FieldDebugExitCall(tcb,work);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static void Debug_tamada_03(TCB_PTR tcb, void * work)
{
	FLD_DEB_DAT * wk = work;

	if (!MyItem_CheckItem(SaveData_GetMyItem(wk->fsys->savedata), 
				ITEM_HOERUKOZYOURO, 1, HEAPID_FIELD)) {
		MyItem_AddItem(SaveData_GetMyItem(wk->fsys->savedata),
				ITEM_HOERUKOZYOURO, 1, HEAPID_FIELD);
		Snd_SePlay(SEQ_SE_DP_SELECT);
	}
}

//--------------------------------------------------------------------
//--------------------------------------------------------------------
static const u16 MsgTamadaRabel[] = { ta_,ma_,da_,ME_,NI_,YYU_,EOM_ };
static const u16 MsgTamada01[] = { ko_,ya_,si_,EOM_ };
static const u16 MsgTamada02[] = { ki_,no_,mi_,EOM_ };
static const u16 MsgTamada03[] = { zi_,yyo_,u_,ro_,EOM_ };

static const BMPLIST_DATA FieldDebugTamadaList[] = {
	{(void*)MsgTamadaRabel, BMPLIST_RABEL},
	{(void*)MsgTamada01, (u32)Debug_tamada_01},
	{(void*)MsgTamada02, (u32)Debug_tamada_02},
	{(void*)MsgTamada03, (u32)Debug_tamada_03},
};

//--------------------------------------------------------------------
//--------------------------------------------------------------------
static void FieldDebugTamadaListSet(FIELDSYS_WORK * fsys)
{
	FLD_DEB_DAT * wp;
	wp = FieldDebugListCreate(fsys, FieldDebugTamadaList, NELEMS(FieldDebugTamadaList));
	wp->finish_func = FieldDebugListSet;

	//CxgtbN
	FieldSystemProc_SeqHold();
}
//============================================================================================
//============================================================================================
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static void Debug_RTC_Normal(TCB_PTR tcb, void * work)
{
	DEBUG_StopFakeTime();
	Snd_SePlay(SEQ_SE_DP_SELECT);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static void Debug_RTC_Fix08_00(TCB_PTR tcb, void * work)
{
	DEBUG_StartFakeFixTime(8, 0);
	Snd_SePlay(SEQ_SE_DP_SELECT);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static void Debug_RTC_Fix12_00(TCB_PTR tcb, void * work)
{
	DEBUG_StartFakeFixTime(12, 0);
	Snd_SePlay(SEQ_SE_DP_SELECT);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static void Debug_RTC_Fix18_00(TCB_PTR tcb, void * work)
{
	DEBUG_StartFakeFixTime(18, 0);
	Snd_SePlay(SEQ_SE_DP_SELECT);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static void Debug_RTC_Fix22_00(TCB_PTR tcb, void * work)
{
	DEBUG_StartFakeFixTime(22, 0);
	Snd_SePlay(SEQ_SE_DP_SELECT);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static void Debug_RTC_Fix02_00(TCB_PTR tcb, void * work)
{
	DEBUG_StartFakeFixTime(2, 0);
	Snd_SePlay(SEQ_SE_DP_SELECT);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static void Debug_RTC_x600(TCB_PTR tcb, void * work)
{
	DEBUG_StartFakeTime(600);
	Snd_SePlay(SEQ_SE_DP_SELECT);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static void Debug_RTC_x60(TCB_PTR tcb, void * work)
{
	DEBUG_StartFakeTime(60);
	Snd_SePlay(SEQ_SE_DP_SELECT);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static const u16 MsgRTCMenu[] = { zi_,ka_,n_,spc_,so_,u_,sa_,EOM_ };
static const u16 MsgRTCNormal[] = {D__,S__,zi_,ka_,n_,EOM_ };
static const u16 MsgRTCFix08_00[] = {n0_,n8_,colon_,n0_,n0_,EOM_ };
static const u16 MsgRTCFix12_00[] = {n1_,n2_,colon_,n0_,n0_,EOM_ };
static const u16 MsgRTCFix18_00[] = {n1_,n8_,colon_,n0_,n0_,EOM_ };
static const u16 MsgRTCFix22_00[] = {n2_,n2_,colon_,n0_,n0_,EOM_ };
static const u16 MsgRTCFix02_00[] = {n0_,n2_,colon_,n0_,n0_,EOM_ };
static const u16 MsgRTCx60[] = {zi_,ka_,n_,n6_,n0_,ba_,i_,EOM_ };
static const u16 MsgRTCx600[] = {zi_,ka_,n_,n6_,n0_,n0_,ba_,i_,EOM_ };

static const BMPLIST_DATA FieldDebugRTCList[] = {
	{(void*)MsgRTCMenu, BMPLIST_RABEL},
	{(void*)MsgRTCNormal, (u32)Debug_RTC_Normal},
	{(void*)MsgRTCx60,	 (u32)Debug_RTC_x60},
	{(void*)MsgRTCx600,	(u32)Debug_RTC_x600},
	{(void*)MsgRTCFix08_00, (u32)Debug_RTC_Fix08_00},
	{(void*)MsgRTCFix12_00, (u32)Debug_RTC_Fix12_00},
	{(void*)MsgRTCFix18_00, (u32)Debug_RTC_Fix18_00},
	{(void*)MsgRTCFix22_00, (u32)Debug_RTC_Fix22_00},
	{(void*)MsgRTCFix02_00, (u32)Debug_RTC_Fix02_00},
};

//--------------------------------------------------------------------
//--------------------------------------------------------------------
static void FieldDebugRTCListSet(FIELDSYS_WORK * fsys)
{
	FLD_DEB_DAT * wp;
	wp = FieldDebugListCreate(fsys, FieldDebugRTCList, NELEMS(FieldDebugRTCList));
	wp->finish_func = FieldDebugListSet;

	//CxgtbN
	FieldSystemProc_SeqHold();
}

//============================================================================================
//
//
//		tB[hfobOj[ʏ
//
//
//============================================================================================
/********************************************************************/
/*                                                                  */
/*				f[^S											*/
/*                                                                  */
/********************************************************************/
//------------------------------------------------------------------
//	rbg}bvVXepf[^
//------------------------------------------------------------------
static const u8 FieldDebugListPos[][4] = {
	{FDBG_LIST_PX1,FDBG_LIST_PY1,FDBG_INFO_PX1,FDBG_INFO_PY1},
	{FDBG_LIST_PX2,FDBG_LIST_PY2,FDBG_INFO_PX2,FDBG_INFO_PY2},
};

static const BMPWIN_DAT	FieldDebugListWindowData = {
	GF_BGL_FRAME3_M,
	FDBG_LIST_PX1,FDBG_LIST_PY1,
	FDBG_LIST_SX,FDBG_LIST_SY,FDBG_LIST_PL,FDBG_LIST_CH
};

static const BMPWIN_DAT	FieldDebugInfoWindowData = {
	GF_BGL_FRAME3_M,
	FDBG_INFO_PX1,FDBG_INFO_PY1,
	FDBG_INFO_SX,FDBG_INFO_SY,FDBG_INFO_PL,FDBG_INFO_CH
};

static const BMPWIN_DAT	FieldDebugRsltWindowData = {
	GF_BGL_FRAME3_M,
	FDBG_RSLT_PX,FDBG_RSLT_PY,
	FDBG_RSLT_SX,FDBG_RSLT_SY,FDBG_RSLT_PL,FDBG_RSLT_CH
};

static const BMPWIN_DAT	FieldDebugUserWindowData = {
	GF_BGL_FRAME3_M,
	FDBG_USER_PX,FDBG_USER_PY,
	FDBG_USER_SX,FDBG_USER_SY,FDBG_USER_PL,FDBG_USER_CH
};

//------------------------------------------------------------------
//	ڃXgf[^
//------------------------------------------------------------------
static const BMPLIST_HEADER FieldDebugListHeader = {
	NULL,				//\f[^|C^
	NULL,				//J[\ړƂ̃R[obN֐
	InfoCallBack2,		//PsƂ̃R[obN֐
	NULL,				//GF_BGL_BMPWIN\̃f[^ւ̃|C^
	0,					//Xgڐ
	8,					//\ő區ڐ
	2,					//x\wW
	12,					//ڕ\wW
	1,					//J[\\wW
	8,					//\xW
	FBMP_COL_WHITE,		//F
	FBMP_COL_BLACK,		//wiF
	FBMP_COL_BLK_SDW,	//eF
	0,					//Ԋuw
	0,					//Ԋux
	BMPLIST_LRKEY_SKIP,	//y[WXLbv^Cv
	POKE_SYS,			//w
	0,					//afJ[\(allow)\tO(0:ON,1:OFF)
	NULL,				//[N|C^
};

//------------------------------------------------------------------
//	XgVXẽR[obNs\
//------------------------------------------------------------------
static void	InfoCallBack2(BMPLIST_WORK* lw,u32 param,u8 y)
{
	if(param == BMPLIST_RABEL){
		BmpListTmpColorChange(lw,FBMP_COL_RED_SDW,FBMP_COL_BLACK,FBMP_COL_RED);
	}else{
		BmpListTmpColorChange(lw,FBMP_COL_WHITE,FBMP_COL_BLACK,FBMP_COL_BLK_SDW);
	}
}


///bIɂɍ쐬(FLDpWindowLN^ړ)

//------------------------------------------------------------------
/**
 *	@brief	[U[w̃EBhELN^ƃpbgVRAMɃZbg
 *
 *	@param	none
 *	@return none
 */
//------------------------------------------------------------------
void FieldBitMapWinCgxSet( GF_BGL_INI * ini )
{
	MenuWinGraphicSet( ini, GF_BGL_FRAME3_M, MENU_WIN_CGX_NUM, MENU_WIN_PAL, 0, HEAPID_FIELD );
}

/********************************************************************/
/*                                                                  */
/*	fobOXgݒ												*/
/*                                                                  */
/********************************************************************/
static void		FieldDebugListInit(FLD_DEB_DAT* wp)
{
	if((wp->DebugList == 0)&&(wp->DebugCursor == 0)){
		wp->DebugList	= 0;
		wp->DebugCursor	= 1;
	}
}

//------------------------------------------------------------------
/**
 *	@brief	tB[hfobOj[^XNj^XN
 *
 *	[NGÅJsĂ̂ŁAfobOj[JɕKĂŉ
 *
 *	@param	tcb		TCB_PTR:tB[hfobOj[C^XNւ̃|C^
 *	@param	work	void*:FLD_DEB_DAT^[Nւ̃|C^
 */
//------------------------------------------------------------------
static void FieldDebugListExitTask(TCB_PTR tcb,void* work)
{
	//[NJ
	sys_FreeMemoryEz(work);
	TCB_Delete(tcb);

	//OBJ̓~
	FieldSystemProc_SeqHoldEnd();
	return;
}
//--------------------------------------------------------------------
/**
 *	@brief	[JbZ[W
 *
 *	@param	w_index	u8:BMPWindowIndexNo
 *	@param	f_index	u8:tHgIndexNo
 *	@param	msg		void*:`惁bZ[Wւ̃|C^
 *
 */ 
//--------------------------------------------------------------------
static void LocalMsgPrint(GF_BGL_BMPWIN *pWin,u8 w_index,u8 f_index,void* msg,u8 x,u8 y)
{
	MSG_PRINT_HEADER mph;

	//debug
	mph.msg			= msg;
	mph.fnt_index	= f_index;			//gptHgINDEX
	mph.start_x		= x;				//EChE\JnwItZbg
	mph.start_y		= y;				//EChE\JnxItZbg
	mph.write_x		= mph.start_x;		//EChE`wItZbg
	mph.write_y		= mph.start_y;		//EChE`xItZbg
	mph.space_x		= 0;				//Ԋuw
	mph.space_y		= 0;				//Ԋux
	mph.style		= 0;				//tHgX^C
	mph.f_col		= FBMP_COL_WHITE;	//Fio[()
	mph.b_col		= FBMP_COL_BLACK;	//wiFio[()
	mph.s_col		= FBMP_COL_BLACK;	//eF@io[()
	mph.dot_tbl		= 0;				//gphbge[u
	mph.bmpwin		= pWin;				//GF_BGL_BMPWIN*
	GF_MSG_PrintExpand(&mph,MSG_NO_PUT,NULL);
}

//------------------------------------------------------------------
/**
 * @brief	tB[hfobOj[Xg̐
 * @param	fsys
 * @param	list
 * @param	count
 */
//------------------------------------------------------------------
static FLD_DEB_DAT * FieldDebugListCreate(FIELDSYS_WORK * fsys, const BMPLIST_DATA * list, int count)
{
	BMPLIST_HEADER bmplist_h;
	TCB_PTR	pTcb = NULL;
	FLD_DEB_DAT *wp = NULL;

	wp = sys_AllocMemory(HEAPID_FIELD,sizeof(FLD_DEB_DAT));
	if(wp == NULL){
		//[NGA擾łȂΉȂ
		OS_Printf("field debug menu crate failed\n");
		return NULL;
	}
	MI_CpuClear8(wp,sizeof(FLD_DEB_DAT));

	wp->fsys = fsys;

	//C^XNǉ
	pTcb = TCB_Add(FieldDebugListControlTask,wp,0);


	//fobOj[pϐ
	FieldDebugListInit(wp);

	//fobOj[pEBhELN^&pbgZbg
	FieldBitMapWinCgxSet( wp->fsys->bgl );

	//BITMAPǉ
	wp->pBmpwin = GF_BGL_BmpWinAllocGet(HEAPID_FIELD,1);
	GF_BGL_BmpWinAddEx(wp->fsys->bgl,wp->pBmpwin,&FieldDebugListWindowData);

	//BMPXgݒ
	wp->menulist = BMP_MENULIST_CreateByList(HEAPID_FIELD, count, list);
	bmplist_h = FieldDebugListHeader;
	bmplist_h.list = wp->menulist;
	bmplist_h.win = wp->pBmpwin;
	bmplist_h.count = count;
	wp->blistWk = BmpListSet(&(bmplist_h),wp->DebugList,wp->DebugCursor,HEAPID_FIELD);

	return wp;
}

//------------------------------------------------------------------
/**
 * @brief	tB[hfobOj[Xg̐(gmm當擾)
 * @param	fsys
 * @param	arcID	gmm̃A[JCuID
 * @param	list	j[Xg
 * @param	count	j[Xg̗vf
 * @param	func	CRg[̃|C^(NULL=FieldDebugListControlTask)
 *
 *  FieldDebugListFree(void* work)LĂ悢
 */
//------------------------------------------------------------------
static FLD_DEB_DAT * FieldDebugListCreateGMM(FIELDSYS_WORK * fsys,int arcID,const GMM_MENU_PARAM * list, int count,TCB_FUNC func)
{
	BMPLIST_HEADER bmplist_h;
	TCB_PTR	pTcb = NULL;
	FLD_DEB_DAT *wp = NULL;
	int i;

	wp = sys_AllocMemory(HEAPID_FIELD,sizeof(FLD_DEB_DAT));
	if(wp == NULL){
		//[NGA擾łȂΉȂ
		OS_Printf("field debug menu crate failed\n");
		return NULL;
	}
	MI_CpuClear8(wp,sizeof(FLD_DEB_DAT));

	wp->fsys = fsys;

	//C^XNǉ
	if(func == NULL){
		pTcb = TCB_Add(FieldDebugListControlTask,wp,0);
	}else{
		pTcb = TCB_Add(func,wp,0);
	}

	//fobOj[pϐ
	FieldDebugListInit(wp);

	//fobOj[pEBhELN^&pbgZbg
	FieldBitMapWinCgxSet( wp->fsys->bgl );

	//BITMAPǉ
	wp->pBmpwin = GF_BGL_BmpWinAllocGet(HEAPID_FIELD,1);
	GF_BGL_BmpWinAddEx(wp->fsys->bgl,wp->pBmpwin,&FieldDebugListWindowData);

	//BMPXgݒ
	wp->menulist = BMP_MENULIST_Create(count,HEAPID_FIELD);

	if(list != NULL){
		MSGDATA_MANAGER* msgman;

		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,arcID,HEAPID_FIELD);

		for(i = 0;i < count;i++){
			BMP_MENULIST_AddArchiveString(wp->menulist,
				msgman, list[i].str_id, list[i].param );
		}
		MSGMAN_Delete(msgman);
	}else{
		//ǂłWvp̓ʏ
		STRCODE	tmpbuf[128];
		STRBUF	*mstr = STRBUF_Create(128,HEAPID_BASE_DEBUG);
		for(i = 0;i < count;i++){
			PM_strclear(tmpbuf,EOM_,128);
			STRBUF_Clear(mstr);
			
			//][擾
			if(ASCIIcode2DSuni(0,(u8*)ZoneData_GetZoneName(i+2),tmpbuf)){
				tmpbuf[0] = EOM_;
			}
			STRBUF_SetStringCode(mstr,tmpbuf);
			BMP_MENULIST_AddString(wp->menulist,mstr,i+2);
		}
		STRBUF_Delete(mstr);
	}

	bmplist_h = FieldDebugListHeader;
	bmplist_h.list = wp->menulist;
	bmplist_h.win = wp->pBmpwin;
	bmplist_h.count = count;
	wp->blistWk = BmpListSet(&(bmplist_h),wp->DebugList,wp->DebugCursor,HEAPID_FIELD);

	return wp;
}

//------------------------------------------------------------------
/**
 *	@brief	tB[hfobOj[Xg̔j
 *
 *	@param	work	void*:
 */
//------------------------------------------------------------------
static void FieldDebugListFree(void* work)
{
	FLD_DEB_DAT	*wp;

	wp = (FLD_DEB_DAT*)work;

	//BMPEBhEOFF
	GF_BGL_BmpWinOff(wp->pBmpwin);

	//BMPXgj
	BMP_MENULIST_Delete(wp->menulist);
	BmpListExit(wp->blistWk,&(wp->DebugList),&(wp->DebugCursor));

	//BMPWindow
	GF_BGL_BmpWinDel(wp->pBmpwin);

	//[N
	sys_FreeMemoryEz(wp->pBmpwin);
	return;
}

#if 0
//--------------------------------------------------------------------
/**
 *	@brief	ڍs葱(pʂֈڍs)ڍs悩璼ڃtB[hA
 *
 *	@param	func	pFunc:ڍs郁CvV[W
 *	@param	tcb		TCB_PTR:Ăяo^XNubNւ̃|C^
 *	@param	work	void*:Ăяo^XNubN[Nւ̃|C^
 */
//--------------------------------------------------------------------
static void	FieldDebugExitNextProc(pFunc func,TCB_PTR tcb,void* work)
{
	//BMPXgJ
	FieldDebugListFree(work);
	FieldDebugListExitTask(tcb,work);

	sys_MainProcChange(func);
}
#endif

//------------------------------------------------------------------
/**
 *	@brief	fobOj[IbZ[W\Wait
 *
 *	@param	tcb		TCB_PTR:Ăяo^XNubNւ̃|C^
 *	@param	work	void*:Ăяo^XNubN[Nւ̃|C^
 */
//------------------------------------------------------------------
static void	FieldDebugListExitMsgWait(TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT	*wp;

	wp = (FLD_DEB_DAT*)work;

	if(sys.trg & PAD_BUTTON_A){
		GF_BGL_BmpWinOff(wp->pBmpwin);
		GF_BGL_BmpWinDel(wp->pBmpwin);

		TCB_ChangeFunc(tcb,FieldDebugListExitTask);
	}
}

//------------------------------------------------------------------
/**
 *	@brief	fobOj[I(IbZ[W\ɃXgj)
 *
 *	@param	msg		void*:IbZ[Wzւ̃|C^
 *	@param	tcb		TCB_PTR:Ăяo^XNubNւ̃|C^
 *	@param	work	void*:Ăяo^XNubN[Nւ̃|C^
 */
//------------------------------------------------------------------
static void	FieldDebugExitMsg(void* msg,TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT	*wp;
	wp = (FLD_DEB_DAT*)work;

	FieldDebugListFree(work);

	//rbg}bvǉ
//	wp->work = GF_BGL_BmpAdd2(wp->fsys->bgl,&FieldDebugRsltWindowData);
	GF_BGL_BmpWinAddEx(wp->fsys->bgl,wp->pBmpwin,&FieldDebugRsltWindowData);
	GF_BGL_BmpWinDataFill(wp->pBmpwin,(FBMP_COL_BLACK));	//Lf[^
	LocalMsgPrint(wp->pBmpwin,wp->work,POKE_9x12,msg,2,2);
	GF_BGL_BmpWinOn(wp->pBmpwin);

	TCB_ChangeFunc(tcb,FieldDebugListExitMsgWait);
}

//------------------------------------------------------------------
/**
 *	@brief	fobOj[I(IbZ[W\ɃXgj)
 *	tHgw
 *
 *	@param	f_index	u8:tHgwIndexNo
 *	@param	msg		void*:IbZ[Wzւ̃|C^
 *	@param	tcb		TCB_PTR:Ăяo^XNubNւ̃|C^
 *	@param	work	void*:Ăяo^XNubN[Nւ̃|C^
 */
//------------------------------------------------------------------
static void	FieldDebugExitMsgFont(u8 f_index,void* msg,TCB_PTR tcb,void* work)
{
	FLD_DEB_DAT	*wp;
	wp = (FLD_DEB_DAT*)work;

	FieldDebugListFree(work);

	//rbg}bvǉ
	//wp->work = GF_BGL_BmpAdd2(wp->fsys->bgl,&FieldDebugRsltWindowData);
	GF_BGL_BmpWinAddEx(wp->fsys->bgl,wp->pBmpwin,&FieldDebugRsltWindowData);

	GF_BGL_BmpWinDataFill(wp->pBmpwin,(FBMP_COL_BLACK));	//Lf[^
	LocalMsgPrint(wp->pBmpwin,wp->work,f_index,msg,2,2);
	GF_BGL_BmpWinOn(wp->pBmpwin);

	TCB_ChangeFunc(tcb,FieldDebugListExitMsgWait);
}


//------------------------------------------------------------------
/**
 *	@brief	tB[hfobȌI֑J
 *
 *	fobOj[p[NƃXg̔js
 *	@param	tcb		TCB_PTR:Ăяo^XNubNւ̃|C^
 *	@param	work	void*:Ăяo^XNubN[Nւ̃|C^
 */
//------------------------------------------------------------------
static void FieldDebugExit(TCB_PTR tcb,void* work)
{
	//Xg̊J
	FieldDebugListFree(work);
	//tB[hfobO^XNʏI
	TCB_ChangeFunc(tcb,FieldDebugListExitTask);
	return;
}
//------------------------------------------------------------------
/**
 * @brief	tB[hfobOj[I
 */
//------------------------------------------------------------------
static void FieldDebugExitCall(TCB_PTR tcb,void* work)
{
	//Xg̊J
	FieldDebugListFree(work);

	//[NJ
	sys_FreeMemoryEz(work);
	TCB_Delete(tcb);

	//OBJ̓~
	//FieldSystemProc_SeqHoldEnd();
	return;
}

//------------------------------------------------------------------
/**
 *	@brief	tB[hfobOC^XN
 *
 *	@param	tcb		TCB_PTR:Ăяo^XNubNւ̃|C^
 *	@param	work	void*:Ăяo^XNubN[Nւ̃|C^
 */
//------------------------------------------------------------------
static void FieldDebugListControlTask(TCB_PTR tcb,void* work)
{
	s32	ret_code;
	TCB_FUNC	func;
	FLD_DEB_DAT	*wp;
	
	wp = (FLD_DEB_DAT*)work;

	ret_code = BmpListMain(wp->blistWk);

	//L[씻
	if(sys.trg & PAD_BUTTON_A){
		if(ret_code){
			func = (TCB_FUNC)ret_code;
			func(tcb,work);
		}
		return;
	}
	//j[LZ
	if(sys.trg & PAD_BUTTON_B){
		if (wp->finish_func != NULL) {
			FIELDSYS_WORK * fsys = wp->fsys;
			void (*func)(FIELDSYS_WORK*) = wp->finish_func;
			FieldDebugExitCall(tcb,work);
			func(wp->fsys);
		} else {
			FieldDebugExit(tcb,work);
		}
		return;
	}
}

//===========================================================================
//===========================================================================
#include "gflib/strbuf_family.h"
//------------------------------------------------------------------
/**
 * @brief	Xg
 * @param	maxElems	󂯎郊Xg̑傫
 * @param	data		Xgւ̃|C^
 * @param	heapID		gpq[vID
 * @return	BMP_MENULIST_DATA Xgւ̃|C^
 */
//------------------------------------------------------------------
BMP_MENULIST_DATA * BMP_MENULIST_CreateByList(u32 heapID,
		u32 maxElems, const BMP_MENULIST_DATA * data)
{
	int i;
	BMP_MENULIST_DATA * list;
	STRBUF * strbuf;

	strbuf = STRBUF_Create(100, heapID);
	list = BMP_MENULIST_Create(maxElems, heapID);
	for (i = 0; i < maxElems; i++) {
		STRBUF_SetStringCode(strbuf, data[i].str);
		BMP_MENULIST_AddString(list, strbuf, data[i].param);
	}
	STRBUF_Delete(strbuf);

	return list;
}



//============================================================================================
//
//
//		fobOp\֘A
//
//
//============================================================================================

#ifdef DEBUG_BG1_PRINT

#define SCREEN_CHARA_W		(32)
#define	DEBUG_TICK_MAX	(4)

static u16 store_ticks[DEBUG_TICK_MAX];
static u16 store_max_ticks[DEBUG_TICK_MAX];
static char *palwork;
static NNSG2dPaletteData *pal;


//------------------------------------------------------------------
/**
 * 
 * DEBUG 1XN[f
 * 
 **/
//------------------------------------------------------------------
static void DebugCharPut(u16 *screen, char c, int x, int y)
{
	if(c==0x20){
		c = 0x29;
	}
	if(c=='='){
		c = 0x30+10;
	}
	if(c=='-'){   // }CiX\oĂȂ̂Mɒu
		c = 'M';
	}
	screen[x+y*SCREEN_CHARA_W] = 0x2000+(c-0x2F);
}

//------------------------------------------------------------------
/**
 * 
 * DEBUG XN[f
 * 
 **/
//------------------------------------------------------------------
static void DebugStrPut(GF_BGL_INI *ini, char *str,int x, int y)
{
	int  n=0;
	u16  *screen;
	screen = GF_BGL_ScreenAdrsGet( ini, FLD_MBGFRM_EFFECT1 );

	while(str[n]!=0){
		DebugCharPut(screen,str[n],x+n,y);
		n++;
	}
}


extern BOOL CommUnderIsDebugStop(void);
//------------------------------------------------------------------
/**
 * 
 * DEBUG `(tB[hpABG1ʂɕ`j
 * 
 * sȂAuO`XA`abi啶̂݁jAAXy[Xv\
 * 
 * 
 **/
//------------------------------------------------------------------
void DebugBgPrint(GF_BGL_INI *ini, FIELDSYS_WORK *fsys)
{

#ifdef DEBUG_3DDRAW_COUNT	
	s32 result;
	char str[100];
	

	if(DebugStressFlg == 0){
		return;
	}
	if(fsys->stop_debug_print==1){
		return;
	}

    if(CommUnderIsDebugStop()){
        return;
    }
	//lW
//	sprintf(str,"X = %03d, Z = %03d  ",FX_Whole(map3Ddata->actor[0].global.x),FX_Whole(map3Ddata->actor[0].global.z));
	sprintf(str,"GRIDX = %03d, GRIDZ = %03d  ",Player_NowGPosXGet(fsys->player),Player_NowGPosZGet(fsys->player));
	DebugStrPut(ini, str,1,1);


	if(DebugStressFlg==2){
		VecFx32 pos;
		Player_VecPosGet(fsys->player,&pos);
		sprintf(str,"X = %05d,    Z = %05d  ",FX_Whole(pos.x),FX_Whole(pos.z));
		DebugStrPut(ini, str,1,2);
		GF_BGL_LoadScreenReq( ini,FLD_MBGFRM_EFFECT1 );	//fobOʂ̃XN[]
		return ;
	}
	//WIgGW󂯎|S
	sprintf(str,"REG POLY LIST = %04d",G3X_GetPolygonListRamCount());
	DebugStrPut(ini,str,1,2);

	//NitroSystemɓn|S
	sprintf(str,"MDL POLY LIST = %04d",simple_3DDrawPolygonGet());
	DebugStrPut(ini,str,1,3);

	//WIgGW󂯎_
	sprintf(str,"REG VTX COUNT = %04d",G3X_GetVtxListRamCount());
	DebugStrPut(ini,str,1,4);

	//NitroSystemɓn_
	sprintf(str,"MDL VTX COUNT = %04d",simple_3DDrawVertexGet());
	DebugStrPut(ini,str,1,5);

	//NitroSystemŃ|S`Ăяo
	sprintf(str,"DRAW COUNT    = %04d",simple_3DDrawNumGet());
	DebugStrPut(ini,str,1,6);

	//eNX`VRAMɓ]ĂeNX`̗
	sprintf(str,"VRAM TEX    = %06d",simple_3DVramTexSizeGet());
	DebugStrPut(ini,str,1,7);	

	//pbgVRAMɓ]Ăpbg̗
	sprintf(str,"PAL  TEX    = %06d",simple_3DVramPalSizeGet());
	DebugStrPut(ini,str,1,8);


	//eׂ̕^C}[Ŏ擾
	DEBUG_PrintTickResult(ini, str, 1, 9);

    // make\
	sprintf(str,"BUILD %s %s", BuildDate, BuildTime);
    {
        int i;
        for(i=0;str[i]!=0;i++){
            str[i] = toupper(str[i]);
        }
        DebugStrPut(ini,str, 1, 12);
    }

    {
        u8 macAddress[WM_SIZE_MACADDR];

        OS_GetMacAddress(macAddress);
        sprintf(str, "MAC %02X%02X%02X%02X%02X%02X\n",
                    macAddress[0],macAddress[1],macAddress[2],
                    macAddress[3],macAddress[4],macAddress[5]);
        DebugStrPut(ini,str,1,13);
    }

    
	GF_BGL_LoadScreenReq( ini,FLD_MBGFRM_EFFECT1 );	//fobOʂ̃XN[]
#endif	
}

//--------------------------------------------------------------------
// fobO\̂߂PALEד]
//--------------------------------------------------------------------
void DebugBgCharPalSet(GF_BGL_INI *ini)
{
	pal = GF_BGL_NTRCHR_PalLoad( (void*)&palwork, HEAPID_FIELD,"data/nfont.NCLR");
	GF_BGL_NTRCHR_CharLoad( ini, FLD_MBGFRM_EFFECT1, "data/nfont.NCGR", 0);
	GX_LoadBGPltt( pal->pRawData, STRESS_INFO_PAL_OFFSET, STRESS_INFO_PAL_SIZE);

}
//--------------------------------------------------------------------
//	pbgp[NJ
//--------------------------------------------------------------------
void DebugBgCharPalFree(void)
{
	// DEBUGp̃pbg̈
	sys_FreeMemoryEz(palwork);
}

#ifdef	DEBUG_BG1_PRINT
static void DebugBgPrint_Create(FLDMAPFUNC_WORK * fwk, FIELDSYS_WORK * fsys, void * work)
{
	GF_BGL_PrioritySet(FLD_MBGFRM_EFFECT1, 0);
	//ftHg͔\ɂƂ
	DebugStressDispSet(FALSE);
	//fobO\pLN^Epbg]
	DebugBgCharPalSet(fsys->bgl);
}

static void DebugBgPrint_Delete(FLDMAPFUNC_WORK * fwk, FIELDSYS_WORK * fsys, void * work)
{
	DebugBgCharPalFree();
}

static void DebugBgPrint_Update(FLDMAPFUNC_WORK * fwk, FIELDSYS_WORK * fsys, void * work)
{
	DebugBgPrint(fsys->bgl,fsys);
}

static const FLDMAPFUNC_DATA DebugBgPrtData = {
	FLDMAP_PRI_DEBUGPRINT,
	0,
	DebugBgPrint_Create,
	DebugBgPrint_Delete,
	DebugBgPrint_Update,
};

void Debug_Entry_StressPrintTask(FIELDSYS_WORK * fsys)
{
	FLDMAPFUNC_Create(fsys->fldmap->fmapfunc_sys, &DebugBgPrtData);
}
#endif


//============================================================================================
//
//
//			fobOp׃`FbN֘A
//
//
//============================================================================================

//--------------------------------------------------------------------
/**
 * @brief	fobOp׊ȈՃj^A
 */
//--------------------------------------------------------------------
void DEBUG_InitTick(void)
{
	OS_SetTick(0);
}

//--------------------------------------------------------------------
/**
 * @brief	fobOp׊ȈՃj^ARXg̎擾
 * @param	id	ێ[NIDw
 */
//--------------------------------------------------------------------
void DEBUG_StoreTick(int id)
{
	SDK_ASSERT(0 <= id && id < DEBUG_TICK_MAX);
	store_ticks[id] = OS_TicksToMicroSeconds(OS_GetTick());
	if (store_ticks[id] > store_max_ticks[id]) {
		store_max_ticks[id] = store_ticks[id];
	}
	OS_SetTick(0);
}

//--------------------------------------------------------------------
/**
 * @brief	fobOp׍ől̃NA
 */
//--------------------------------------------------------------------
void DEBUG_ClearMaxTick(void)
{
	int i;
	for (i = 0; i < DEBUG_TICK_MAX; i++) {
		store_max_ticks[i] = 0;
	}
}
//--------------------------------------------------------------------
/**
 * @brief
 * @param	x, y
 */
//--------------------------------------------------------------------
void DEBUG_PrintTickResult(GF_BGL_INI *ini, char * str, int x, int y)
{
	int i;
	int result= 0;

	//e֐̊ԂɖߍTick̕\
	DebugStrPut(ini,"TICKS ", x, y);	
	for (i = 0; i < DEBUG_TICK_MAX; i++) {
		sprintf(str, "-%05d", store_ticks[i]);
		DebugStrPut(ini,str, x + 6 + 6 * i, y);
		sprintf(str, " %05d", store_max_ticks[i]);
		DebugStrPut(ini,str, x + 6 + 6 * i, y + 1);
	}

	//C[vԂɑ΂Ẵp[Ze[W
	for(i=0;i<DEBUG_TICK_MAX;i++){
		result += store_ticks[i];
	}
									// POOp[ZgŁA1Sync̃NbN(1Sync+SyncVblankԂ܂)262CŊ
	sprintf(str,"MAINSTRESS = %d  ",(100*result)/(16700 * (192+262)/262));
	DebugStrPut(ini,str, x, y+2);

}


#endif //DEBUG_BG1_PRINT


#endif	//PM_DEBUG
