/**
 *	@file	fld_mailbox.c
 *	@brief	tB[h[{bNX
 *	@author	Miyuki Iwasawa
 *	@date	06.03.03
 */

#include "common.h"
#include "fld_bmp.h"
#include "fntsys.h"
#include "talk_msg.h"
#include "system/bmp_list.h"
#include "system/bmp_menu.h"
#include "system/bmp_tool.h"
#include "system/window.h"
#include "system/fontproc.h"
#include "system/brightness.h"
#include "system/wipe.h"
#include "system/buflen.h"
#include "system/pm_str.h"
#include "system/arc_util.h"
#include "gflib/strbuf.h"
#include "gflib/strbuf_family.h"
#include "field/fieldsys.h"
#include "field/field.h"
#include "field/field_event.h"

#include "savedata/mail_util.h"
#include "application/mailtool.h"
#include "msgdata/msg_mailbox.h"
#include "msgdata/msg.naix"

typedef struct _MAIL_LIST{
	u8	id;
	u8	valid;
	u8	prev;
	u8	next;

	STRBUF	*name;
}MAIL_LIST;

typedef struct{
	u32	str_id;
	u32	param;
}MENU_PARAM;

typedef struct _MAIL_BOX_MAIN{
	int	heapID;
	int* end_flag;
	int	seq;
	int wipe_f;
	TCB_PTR		tcb;
	TCB_FUNC	next_tcb;
	
	u8	listEnd;
	u8	listStart;
	u8	listSize;
	u8	selectID;
	MAIL_LIST	mailList[MAIL_STOCK_PASOCOM];

	MAIL_PARAM	*param;
	MAIL_BLOCK* pBlock;

	FIELDSYS_WORK*	fsys;
	u16		List;
	u16		Cursor;
	BMPLIST_HEADER	bmplist_h;
	BMPLIST_WORK* blistWk; 
	BMPLIST_DATA* menulist; 

	GF_BGL_INI* bgl;
	GF_BGL_BMPWIN bmpwin;

#ifdef PM_DEBUG
	u16	deb_flag;	///<fobORpĈݗLȃtO
	u16 deb_design;	///<fobÔݗLȃfUCtO
#endif	//PM_DEBUG
}MAIL_BOX_MAIN;

void EventCmd_MailBoxCall( GMEVENT_CONTROL *event);

//===============================================
//萔`
//===============================================
#define MAILBOX_CGX_START	(1)
#define MAILBOX_FRAME	(GF_BGL_FRAME3_M)
#define MAILBOX_FPAL	(FLD_SYSFONT_PAL)

#define MLIST_WIN_SX	(12)
#define MLIST_WIN_SY	(22)
#define MLIST_WIN_PX	(31-MLIST_WIN_SX)
#define MLIST_WIN_PY	(23-MLIST_WIN_SY)
#define MLIST_WIN_CGXNUM	(MLIST_WIN_SX*MLIST_WIN_SY)
#define MLIST_WIN_CGX	(MAILBOX_CGX_START)

#define MENU_WIN_SX	(14)
#define MENU_WIN_SY	(8)
#define MENU_WIN_PX	(1)
#define MENU_WIN_PY	(1)
#define MENU_WIN_CGXNUM	(MENU_WIN_SX*((MENU_WIN_SY+1)*2))
#define MENU_WIN_CGX	(MLIST_WIN_CGX+MLIST_WIN_CGXNUM)

#define BMPL_MENU_WIN_CGX	(MENU_WIN_CGX+MENU_WIN_CGXNUM)
#define BMPL_TALK_WIN_CGX	(BMPL_MENU_WIN_CGX+MENU_WIN_CGX_SIZ)
#define BMPL_MENU_WIN_PAL	(FLD_MENUFRAME_PAL)
#define BMPL_TALK_WIN_PAL	(FLD_MESFRAME_PAL)
///	XgVXẽR[obNs\
static void	InfoCallBack(BMPLIST_WORK* lw,u32 param,u8 y)
{
	if(param == BMPLIST_RABEL){
		BmpListTmpColorChange(lw,FBMP_COL_BLU_SDW,FBMP_COL_BLACK,FBMP_COL_BLUE);
	}else{
		BmpListTmpColorChange(lw,FBMP_COL_BLACK,FBMP_COL_WHITE,FBMP_COL_BLK_SDW);
	}
}

//------------------------------------------------------------------
///	ڃXgf[^
//------------------------------------------------------------------
static const BMPLIST_HEADER MailListHeader = {
	NULL,			//\f[^|C^
	NULL,				//J[\ړƂ̃R[obN֐
	InfoCallBack,		//PsƂ̃R[obN֐
	NULL,				//GF_BGL_BMPWIN\̃f[^ւ̃|C^
	0,			//Xgڐ
	10,					//\ő區ڐ
	2,					//x\wW
	10,					//ڕ\wW
	1,					//J[\\wW
	0,					//\xW
	FBMP_COL_BLACK,		//F
	FBMP_COL_WHITE,		//wiF
	FBMP_COL_BLK_SDW,	//eF
	0,					//Ԋuw
	1,					//Ԋux
	BMPLIST_LRKEY_SKIP,	//y[WXLbv^Cv
	FONT_SYSTEM,		//w
	0,					//afJ[\(allow)\tO(0:ON,1:OFF)
	NULL,				//[N|C^
};

#define MAILMENU_EXIT	(0xFFFF)
#define MAILMENU_BUFLEN	(10)

typedef enum{
 BOX_MENU_VIEW,
 BOX_MENU_DEL,
 BOX_MENU_TRANS,
 BOX_MENU_EXIT,
}BOX_MENU;

static const MENU_PARAM normalMenu[] = {
 {msg_view,BOX_MENU_VIEW},
 {msg_del,BOX_MENU_DEL},
 {msg_trans,BOX_MENU_TRANS},
 {msg_exit,BOX_MENU_EXIT},
};

//===============================================
///vg^Cv
//===============================================
void MailBox_Call(void* fsys,int* end_flag);
static void MailBox_Exit(MAIL_BOX_MAIN* wk);
//

static void MailBox_ExitCall(TCB_PTR tcb,void* work);
static void MailBox_MailListInit(TCB_PTR tcb,void* work);
static void MailBox_MailListKeyIn(TCB_PTR tcb,void* work);
static void MailBox_MailListExit(TCB_PTR tcb,void* work);
static void MailBox_SelectListInit(TCB_PTR tcb,void* work);
static void MailBox_SelectListKeyIn(TCB_PTR tcb,void* work);
static void MailBox_MailCall(TCB_PTR tcb,void* work);

//*********************************************************************
//[JTu
static void mbox_NextTcb(MAIL_BOX_MAIN* wk,TCB_FUNC first,TCB_FUNC second);
static void mbox_MAIL_LIST_Clear(MAIL_LIST* dat,u8 id);
static void mbox_MAIL_LIST_ArrayInit(MAIL_LIST* dat,u8 num,int heapID);
static void mbox_MAIL_LIST_ArrayEnd(MAIL_LIST* dat,u8 num);
static void mbox_MailListInit(MAIL_BOX_MAIN* wk);
static void mbox_SelectListInit(MAIL_BOX_MAIN* wk);
static void mbox_MailListEnd(MAIL_BOX_MAIN* wk);

static void mbox_GetSaveData(MAIL_BOX_MAIN* wk,SAVEDATA* savedata,int heapID);
static void mbox_MailReturnBag(MAIL_BOX_MAIN* wk);

//===============================================
///O[o
//===============================================
/**
 *	@brief	[{bNXĂяo
 */
void MailBox_Call(void* fsys,int* end_flag)
{
	MAIL_BOX_MAIN* wk = NULL;

	sys_CreateHeap(HEAPID_BASE_APP,HEAPID_MAILBOX,0x1000);
	
	//[NGA擾
	HeapStatePush();

	wk = sys_AllocMemory(HEAPID_MAILBOX,sizeof(MAIL_BOX_MAIN));
	MI_CpuClear8(wk,sizeof(MAIL_BOX_MAIN));

	wk->end_flag = end_flag;

#ifdef PM_DEBUG
	//fobOtOɗp
	wk->deb_flag = *end_flag;
	*end_flag = 0;
#endif	//PM_DEBUG
	
	wk->fsys = (FIELDSYS_WORK*)fsys;
	wk->heapID = HEAPID_MAILBOX;
	wk->listEnd = 0;
	wk->listStart = 0xFF;

	//MAIL_LIST\̔z̏
	mbox_MAIL_LIST_ArrayInit(wk->mailList,MAIL_STOCK_PASOCOM,wk->heapID);
	//Z[uf[^擾
	mbox_GetSaveData(wk,GameSystem_GetSaveData(wk->fsys),wk->heapID);

	//j[쐬
	mbox_MailListInit(wk);
	
	wk->tcb = TCB_Add(MailBox_MailListKeyIn,wk,0);
}
/**
 *	@brief	[{bNXI
 */
void MailBox_Exit(MAIL_BOX_MAIN* wk)
{
	TCB_Delete(wk->tcb);
	*(wk->end_flag) = 1;	//ItOON

	//MAIL_LIST\̔z񃊃\[X̉
	mbox_MAIL_LIST_ArrayEnd(wk->mailList,MAIL_STOCK_PASOCOM);
	sys_FreeMemoryEz(wk);

	HeapStatePop();
	HeapStateCheck(wk->heapID);	
	sys_DeleteHeap(wk->heapID);
}

//==================================================
//CXg֘A^XN
//==================================================
/**
 *	@brief	[{bNXIR[
 */
static void MailBox_ExitCall(TCB_PTR tcb,void* work)
{
	MAIL_BOX_MAIN* wk = (MAIL_BOX_MAIN*)work;

	MailBox_Exit(wk);
}

/**
 *	@brief	[{bNXCXg
 */
static void MailBox_MailListInit(TCB_PTR tcb,void* work)
{
	MAIL_BOX_MAIN* wk = (MAIL_BOX_MAIN*)work;

	mbox_MailListInit(wk);
	TCB_ChangeFunc(tcb,MailBox_MailListKeyIn);
}

/**
 *	@brief	[{bNXCXgRg[
 *	
 */
static void MailBox_MailListKeyIn(TCB_PTR tcb,void* work)
{
	MAIL_BOX_MAIN* wk = (MAIL_BOX_MAIN*)work;
	s32	ret_code;

	ret_code = BmpListMain(wk->blistWk);

	if(sys.trg & PAD_BUTTON_CANCEL){
		mbox_NextTcb(wk,MailBox_MailListExit,MailBox_ExitCall);
		return;
	}
	if(sys.trg & PAD_BUTTON_DECIDE){
		switch(ret_code){
		case BMPMENU_NULL:
		case BMPMENU_CANCEL:
		case MAILMENU_EXIT:
			mbox_NextTcb(wk,MailBox_MailListExit,MailBox_ExitCall);
			break;
		default:
			wk->selectID = ret_code;
			mbox_NextTcb(wk,MailBox_MailListExit,MailBox_SelectListInit);
			break;
		}
	}
	return;	
}

/**
 *	@brief	[{bNXCXgI
 *	
 */
static void MailBox_MailListExit(TCB_PTR tcb,void* work)
{
	MAIL_BOX_MAIN* wk = (MAIL_BOX_MAIN*)work;
	
	mbox_MailListEnd(wk);

	TCB_ChangeFunc(tcb,wk->next_tcb);
}

/**
 *	@brief	[{bNXZNgXg
 */
static void MailBox_SelectListInit(TCB_PTR tcb,void* work)
{
	MAIL_BOX_MAIN* wk = (MAIL_BOX_MAIN*)work;
	
	mbox_SelectListInit(wk);
	TCB_ChangeFunc(tcb,MailBox_SelectListKeyIn);
}

/**
 *	@brief	[{bNXZNgXgL[擾
 */
static void MailBox_SelectListKeyIn(TCB_PTR tcb,void* work)
{
	MAIL_BOX_MAIN* wk = (MAIL_BOX_MAIN*)work;
	s32	ret_code;

	ret_code = BmpListMain(wk->blistWk);

	if(sys.trg & PAD_BUTTON_CANCEL){
		mbox_NextTcb(wk,MailBox_MailListExit,MailBox_MailListInit);
		return;
	}
#ifdef PM_DEBUG
	if(wk->deb_flag){
		if(sys.trg & PAD_KEY_RIGHT){
			wk->deb_design = (wk->deb_design+1)%4;
		}else if(sys.trg & PAD_KEY_LEFT){
			wk->deb_design = (wk->deb_design+3)%4;
		}	
	}
#endif
	if(sys.trg & PAD_BUTTON_DECIDE){
		switch(ret_code){
		case BMPMENU_NULL:
		case BMPMENU_CANCEL:
		case BOX_MENU_TRANS:
		case BOX_MENU_EXIT:
			mbox_NextTcb(wk,MailBox_MailListExit,MailBox_MailListInit);
			break;
		case BOX_MENU_DEL:
			mbox_MailReturnBag(wk);
			mbox_NextTcb(wk,MailBox_MailListExit,MailBox_MailListInit);
			break;
		case BOX_MENU_VIEW:
		default:
			TCB_ChangeFunc(tcb,MailBox_MailCall);
//			mbox_NextTcb(wk,MailBox_MailListExit,MailBox_MailCall);
			break;
		}
	}
	return;	
	
}

/**
 *	@brief	[R}hĂяo^XN
 */
static void MailBox_MailCall(TCB_PTR tcb,void* work)
{
	MAIL_BOX_MAIN* wk = (MAIL_BOX_MAIN*)work;

	switch(wk->seq){
	case 0:
		wk->wipe_f = 0;
		WIPE_Start(WIPE_PATTERN_WMS,
				WIPE_TYPE_FADEOUT,
				WIPE_TYPE_FADEOUT,0x0000,COMM_BRIGHTNESS_SYNC,1,wk->heapID,&(wk->wipe_f)
				);
		break;
	case 1:
		if(!wk->wipe_f){
			return;
		}
		mbox_MailListEnd(wk);

		if(wk->mailList[wk->selectID].valid){
			wk->param =  FieldMailView_InitCall(wk->fsys,
				MAILBLOCK_PASOCOM,wk->selectID,wk->heapID);
		}else{
#ifdef PM_DEBUG 
			wk->param =  FieldMailCreate_InitCall( wk->fsys ,
				MAILBLOCK_PASOCOM,wk->selectID,wk->deb_design,wk->heapID);
#else
			//ɗ邱Ƃ͖nY
			wk->param = FieldMailView_InitCall(wk->fsys,
				MAILBLOCK_NULL,0,wk->heapID);
#endif
		}
		break;
	case 2:
		//vZXI҂
		if(FieldEvent_Cmd_WaitSubProcEnd(wk->fsys)){
			return;
		}
		if((wk->mailList[wk->selectID].valid == 0) &&  MailSys_IsDataCleate(wk->param)){
			MailSys_PushDataToSave(wk->param);
			wk->mailList[wk->selectID].valid = 1;
			STRBUF_SetStringCode(wk->mailList[wk->selectID].name,MailData_GetWriterName(wk->param->pDat));
		}
		MailSys_ReleaseCallWork(wk->param);
		//tB[h}bvvZXA
		FieldEvent_Cmd_SetMapProc(wk->fsys);
		break;
	case 3:
		//tB[hvZXJnI҂
		if(!FieldEvent_Cmd_WaitMapProcStart(wk->fsys)){
			return;
		}
		//CxgtbN
		FieldSystemProc_SeqHold();

		wk->wipe_f = 0;
		WIPE_Start(WIPE_PATTERN_WMS,
				WIPE_TYPE_FADEIN,
				WIPE_TYPE_FADEIN,0x0000,COMM_BRIGHTNESS_SYNC,1,wk->heapID,&(wk->wipe_f)
				);
		break;
	case 4:
		if(!wk->wipe_f){
			return;
		}
		//j[A
		wk->seq = 0;
		mbox_MailListInit(wk);
		TCB_ChangeFunc(tcb,MailBox_MailListKeyIn);
		break;
	}
	wk->seq++;
	return;
}

/**
 *	@brief	[{bNXCXg^XN
 */
static void mbox_MailListInit(MAIL_BOX_MAIN* wk)
{
	u8	i = 0,size = 0;
	MAIL_LIST	*pl;

	static const BMPWIN_DAT bmp = { MAILBOX_FRAME,
		MLIST_WIN_PX, MLIST_WIN_PY,
		MLIST_WIN_SX, MLIST_WIN_SY, MAILBOX_FPAL, MLIST_WIN_CGX
	};

	wk->bgl = FieldBglIniGet(wk->fsys);

	//EBhEOtBbNZbg
	MenuWinGraphicSet(wk->bgl, MAILBOX_FRAME,
			BMPL_MENU_WIN_CGX, BMPL_MENU_WIN_PAL, MENU_TYPE_SYSTEM, wk->heapID);

	TalkWinGraphicSet(wk->bgl,MAILBOX_FRAME,
			BMPL_TALK_WIN_CGX, BMPL_TALK_WIN_PAL, 0, wk->heapID);
	
	SystemFontPaletteLoad(PALTYPE_MAIN_BG,MAILBOX_FPAL*32,wk->heapID);
	TalkFontPaletteLoad(PALTYPE_MAIN_BG,FLD_MESFONT_PAL*32,wk->heapID);

	//BMPj[Xg쐬(TCY+[߂]m)
	wk->menulist = BMP_MENULIST_Create(wk->listSize+1,wk->heapID);
	GF_BGL_BmpWinAddEx(wk->bgl,&(wk->bmpwin),&bmp);
	GF_BGL_BmpWinDataFill(&wk->bmpwin,WINCLR_COL(FBMP_COL_WHITE));
	
	for(i = 0;i < MAIL_STOCK_PASOCOM;i++){
		
		pl = &(wk->mailList[i]);
		//C^[擾
		if(!pl->valid){
#ifdef PM_DEBUG			
			if(!wk->deb_flag){
				continue;
			}
#else
			continue;
#endif	//PM_DEBUG
		}
		BMP_MENULIST_AddString(wk->menulist,pl->name,pl->id);
		size++;
	}
	//u߂vǉ
	{
		MSGDATA_MANAGER*	pMsg;
		STRBUF	*buf;
		
		pMsg = MSGMAN_Create(MSGMAN_TYPE_DIRECT,ARC_MSG,
					NARC_msg_mailbox_dat,wk->heapID);

		buf = STRBUF_Create(MAILMENU_BUFLEN,wk->heapID);
		MSGMAN_GetString(pMsg,msg_exit,buf);
		
		BMP_MENULIST_AddString(wk->menulist,buf,MAILMENU_EXIT);
	
		STRBUF_Delete(buf);
		MSGMAN_Delete(pMsg);
		size++;
	}
	
	//BMPXgݒ
	MI_CpuCopy8((void*)&MailListHeader,(void*)&(wk->bmplist_h),sizeof(BMPLIST_HEADER));
	wk->Cursor = 0;
	wk->List = 0;
	wk->bmplist_h.win = &(wk->bmpwin);
	wk->bmplist_h.list = wk->menulist;
	wk->bmplist_h.work = (void*)wk->blistWk;
	wk->bmplist_h.count = size;
	wk->blistWk = BmpListSet(&(wk->bmplist_h),wk->List,wk->Cursor,wk->heapID);
	
	BmpMenuWinWrite( &wk->bmpwin, WINDOW_TRANS_ON, BMPL_MENU_WIN_CGX, BMPL_MENU_WIN_PAL );	
	GF_BGL_LoadScreenV_Req(wk->bgl,MAILBOX_FRAME);	
}

/**
 *	@brief	[{bNXZNgXg
 */
static void mbox_SelectListInit(MAIL_BOX_MAIN* wk)
{
	u8	i = 0,size = 0;

	static const BMPWIN_DAT bmp = { MAILBOX_FRAME,
		MENU_WIN_PX, MENU_WIN_PY,
		MENU_WIN_SX, MENU_WIN_SY, MAILBOX_FPAL, MENU_WIN_CGX
	};

	//BMPj[Xg쐬
	size = NELEMS(normalMenu);
	wk->menulist = BMP_MENULIST_Create(size,wk->heapID);
	GF_BGL_BmpWinAddEx(wk->bgl,&(wk->bmpwin),&bmp);
	GF_BGL_BmpWinDataFill(&wk->bmpwin,WINCLR_COL(FBMP_COL_WHITE));
	
	{
		MSGDATA_MANAGER* msgman;

		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,
					NARC_msg_mailbox_dat,wk->heapID);

		for(i = 0;i < size;i++){
			BMP_MENULIST_AddArchiveString(wk->menulist,
				msgman, normalMenu[i].str_id, normalMenu[i].param );
		}
		MSGMAN_Delete(msgman);
	}
	
	//BMPXgݒ
	MI_CpuCopy8((void*)&MailListHeader,(void*)&(wk->bmplist_h),sizeof(BMPLIST_HEADER));
	wk->Cursor = 0;
	wk->List = 0;
	wk->bmplist_h.win = &(wk->bmpwin);
	wk->bmplist_h.list = wk->menulist;
	wk->bmplist_h.work = (void*)wk->blistWk;
	wk->bmplist_h.count = size;
	wk->bmplist_h.line = 4;
	wk->bmplist_h.page_skip = BMPLIST_NO_SKIP;
	wk->blistWk = BmpListSet(&(wk->bmplist_h),wk->List,wk->Cursor,wk->heapID);
	
	BmpMenuWinWrite( &wk->bmpwin, WINDOW_TRANS_ON, BMPL_MENU_WIN_CGX, BMPL_MENU_WIN_PAL );	
	GF_BGL_LoadScreenV_Req(wk->bgl,MAILBOX_FRAME);	
	
}

/**
 *	@brief	[{bNXCXg̈^XN
 */
static void mbox_MailListEnd(MAIL_BOX_MAIN* wk)
{
	//BMPWINj
	GF_BGL_BmpWinOff(&(wk->bmpwin));	//WindowOFF
	
	//BMPXg̊J
	BmpMenuWinClear( &(wk->bmpwin),WINDOW_TRANS_ON);
	BmpListExit(wk->blistWk,&(wk->List),&(wk->Cursor));	//Xgj
	BMP_MENULIST_Delete(wk->menulist);	//j[j
	GF_BGL_BmpWinDel(&(wk->bmpwin));	//BMP Window Del

	GF_BGL_LoadScreenV_Req(wk->bgl,MAILBOX_FRAME);	
}

/**
 *	@brief	
 */
//===================================================
//[J
//===================================================
/**
 *	@brief	TCBt@NV`FW
 */
static void mbox_NextTcb(MAIL_BOX_MAIN* wk,TCB_FUNC first,TCB_FUNC second)
{
	TCB_ChangeFunc(wk->tcb,first);
	wk->next_tcb = second;
}

/**
 *	@brief	MAP_LIST\̂Ԃɏ
 */
static void mbox_MAIL_LIST_Clear(MAIL_LIST* dat,u8 id)
{
	dat->id = id;
	dat->valid = 0;
	dat->prev = 0;
	dat->next = 0;
	if(dat->name != NULL){
		STRBUF_Clear(dat->name);
	}
}

/**
 *	@brief	MAP_LIST\̔z
 */
static void mbox_MAIL_LIST_ArrayInit(MAIL_LIST* dat,u8 num,int heapID)
{
	u8 i = 0;

	for(i = 0;i < num;i++){
		dat[i].name = STRBUF_Create(BUFLEN_PERSON_NAME,heapID);
		mbox_MAIL_LIST_Clear(dat,i);
	}
}

/**
 *	@brief	MAP_LIST\̔z̃\[X
 */
static void mbox_MAIL_LIST_ArrayEnd(MAIL_LIST* dat,u8 num)
{
	u8 i = 0;

	for(i = 0;i < num;i++){
		if(dat[i].name != NULL){
			STRBUF_Delete(dat[i].name);
		}
	}
}

/**
 *	brief	Z[uf[^擾
 */
static void mbox_GetSaveData(MAIL_BOX_MAIN* wk,SAVEDATA* savedata,int heapID)
{
	u8 i = 0,prev = 0,start = 0xFF,end = 0;
	int id;
	MAIL_BLOCK* pBlock;
	MAIL_DATA* mail;
	
	MAIL_LIST	*pNow,*pLast;
	
	pBlock = SaveData_GetMailBlock(savedata);
	wk->pBlock = pBlock;

	//f[^擾e|쐬
	mail = MailData_CreateWork(heapID);
	
	for(i = 0;i < MAIL_STOCK_PASOCOM;i++){
		MAIL_GetMailData(pBlock,MAILBLOCK_PASOCOM,i,mail);

		pNow = &(wk->mailList[i]);
		pLast = &(wk->mailList[wk->listEnd]);
	
		mbox_MAIL_LIST_Clear(pNow,i);
		
		pNow->id = i;
		if(!MailData_IsEnable(mail)){
#ifdef PM_DEBUG			
			if(wk->deb_flag){
				wk->listSize++;
			}
#endif
			continue;
		}
		pNow->valid = 1;	//LtOOn
		STRBUF_SetStringCode(pNow->name,MailData_GetWriterName(mail));

		//zXg쐬
		pNow->prev = wk->listEnd;
		pLast->next = pNow->id;

		wk->listEnd = pNow->id;	//ŌXV
		wk->listSize++;
		if(wk->listStart == 0xFF){
			wk->listStart = i;	//X^[gNO擾
		}
	}

	//zXg
	wk->mailList[wk->listEnd].next = wk->listStart;
	wk->mailList[wk->listStart].prev = wk->listEnd;
	
	//[[Nj
	sys_FreeMemoryEz(mail);
}

/**
 *	@brief	[obOɖ߂
 */
static void mbox_MailReturnBag(MAIL_BOX_MAIN* wk)
{
	MAIL_LIST* pNow;

	pNow = &(wk->mailList[wk->selectID]);
	
	if(!pNow->valid){
		return;
	}
		
	//[ACeobOɒǉ

	//[f[^Xg폜

	wk->mailList[pNow->prev].next = pNow->next;
	wk->mailList[pNow->next].prev = pNow->prev;

	mbox_MAIL_LIST_Clear(pNow,wk->selectID);

	//[Z[uf[^NA
	MAIL_DelMailData(wk->pBlock,MAILBLOCK_PASOCOM,wk->selectID);
}



//========================================================
//	XNvgR}h
//========================================================
typedef struct _MAILBOX_EVENT{
	int	ret_val;
	int	seq;
}MAILBOX_EVENT;

//--------------------------------------------------------------
/**
 * @brief	[{bNXCxg 
 * @param	ev	GMEVENT_CONTROL *
 * @retval	BOOL	TRUE=CxgI
 */
//--------------------------------------------------------------
static BOOL MyPCEvent_MailBox( GMEVENT_CONTROL *ev )
{
	FIELDSYS_WORK *fsys = FieldEvent_GetFieldSysWork( ev );
	MAILBOX_EVENT *wk = FieldEvent_GetSpecialWork( ev );

#if 1
	switch (wk->seq) {
	case 0:
		//[{bNX^XNo^
		MailBox_Call(fsys,&(wk->ret_val));
		wk->seq++;
		break;
	case 1:
		if(!wk->ret_val){
			return FALSE;
		}
		sys_FreeMemoryEz(wk);
		return TRUE;
	}
	return FALSE;
#endif
}

//--------------------------------------------------------------
/**
 * @brief	[{bNXTuCxgĂяo
 * @param	event	GMEVENT_CONTROL*
 * @param	dir		ړ
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void EventCmd_MailBoxCall( GMEVENT_CONTROL *event)
{
	FIELDSYS_WORK *fsys = FieldEvent_GetFieldSysWork( event );
#if 1
	MAILBOX_EVENT *wk = sys_AllocMemoryLo( HEAPID_WORLD,sizeof(MAILBOX_EVENT));
	
	wk->ret_val = 0;
	wk->seq = 0;
#endif
	FieldEvent_Call( fsys->event, MyPCEvent_MailBox, wk);
}

