//============================================================================================
/**
 * @file	fld_menu.c
 * @brief	tB[hj[
 * @author	Hiroyuki Nakamura
 * @date	2004.11.05
 */
//============================================================================================
#include "common.h"
#include "system/procsys.h"
#include "system/bmp_menu.h"
#include "system/bmp_list.h"
#include "system/fontproc.h"
#include "system/lib_pack.h"
#include "system/pm_str.h"
#include "system/window.h"
#include "system/snd_tool.h"
#include "system/wordset.h"
#include "system/clact_tool.h"
#include "system/menu_gra.naix"
#include "poketool/pokeparty.h"
#include "itemtool/item.h"
#include "itemtool/myitem.h"
#include "application/bag.h"
#include "application/pokelist.h"
#include "application/p_status.h"
#include "application/trainer_card.h"
#include "application/nuts_tag.h"
#include "application/config_tool.h"
#include "application/mailtool.h"
#include "application/zukanlist/zkn_sys.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_fieldmenu.h"
#include "fld_bmp.h"
#include "fieldmap.h"
#include "fieldsys.h"
#include "field_event.h"
#include "field_skill.h"
#include "field_clact.h"
#include "ev_mapchange.h"
#include "itemuse.h"
#include "ev_time.h"

#include "tr_card_setup.h"

#include "communication/communication.h"	// ȈՉb̂߂ɕKv
#include "comm_union_beacon.h"				// ȈՉb̂߂ɕKv

#define FLD_MENU_H_GLOBAL
#include "fld_menu.h"

#include "system\mystatus.h"
#include "field\field.h"

#include "script.h"
#include "../fielddata/script/common_scr_def.h"		//SCRID_REPORT

#include "report.h"


//============================================================================================
//	萔`
//============================================================================================
enum {
	MENU_POS_ZUKAN = 0,
	MENU_POS_POKEMON,
	MENU_POS_BAG,
	MENU_POS_HERO,
	MENU_POS_REPORT,
	MENU_POS_CONFIG,
	MENU_POS_EXIT,
	MENU_POS_CHAT,
};

// Zgp
typedef struct {
	u16	poke;	// |Pʒu
	u16	waza;	// Z
}SKILL_USE;

// [쐬
typedef struct {
	u16	item;
	u8	pos;
	u8	mode;
}FM_MAIL_WORK;



//============================================================================================
//	vg^Cv錾
//============================================================================================
extern void D_ChangeUnderGroundDirect(struct _FIELDSYS_WORK * fsys);

static BOOL GMEVENT_FieldMenu(GMEVENT_CONTROL * event);
static void FieldMenuSet( GMEVENT_CONTROL * event );
static void FieldMenuSelect( GMEVENT_CONTROL * event );
static u32 FieldMenuListMake( FLD_MENU * wk, u8 * list );
static void FieldMenuListExit( FLD_MENU * wk );

static void FldMenu_ZukanInit( GMEVENT_CONTROL * event );
static void FldMenu_ZukanCall( GMEVENT_CONTROL * event );
static void FldMenu_ZukanWait( GMEVENT_CONTROL * event );

static void FldMenu_PokemonInit( GMEVENT_CONTROL * event );
static void FldMenu_PokemonCall( GMEVENT_CONTROL * event );
static void FldMenu_PokemonWait( GMEVENT_CONTROL * event );

static void FldMenu_BagInit( GMEVENT_CONTROL * event );
static void FldMenu_BagCall( GMEVENT_CONTROL * event );
static void FldMenu_BagWait( GMEVENT_CONTROL * event );

static void FldMenu_ReportInit( GMEVENT_CONTROL * event );
static void FldMenu_ReportWait( GMEVENT_CONTROL * event );
static void FldMenu_ReportCall( GMEVENT_CONTROL * event );

static void SubApp_PStatusWait( GMEVENT_CONTROL * event );

static void FldMenu_TrCardInit( GMEVENT_CONTROL * event );
static void FldMenu_TrCardCall( GMEVENT_CONTROL * event );
static void FldMenu_TrCardWait( GMEVENT_CONTROL * event );

static void FldMenu_TownMapWait( GMEVENT_CONTROL * event );

static void FldMenu_FantasyNoteWait( GMEVENT_CONTROL * event );

static void FldMenu_MailWait( GMEVENT_CONTROL * event );

static void FldMenu_PorutoCaseWait( GMEVENT_CONTROL * event );

static void FldMenu_NutsTagCall( GMEVENT_CONTROL * event, u16 item );
static void FldMenu_NutsTagWait( GMEVENT_CONTROL * event );

static void FldMenu_ConfigInit( GMEVENT_CONTROL* event);
static void FldMenu_ConfigCall( GMEVENT_CONTROL* event);
static void FldMenu_ConfigWait( GMEVENT_CONTROL* event);

static void FldMenu_ChatWait( GMEVENT_CONTROL * event );
static void FldMenu_ChatCall( GMEVENT_CONTROL * event );
static void FldMenu_ChatInit( GMEVENT_CONTROL * event );


//============================================================================================
//	O[oϐ
//============================================================================================
static const u32 FldMenuData[][2] =
{
	{ msg_menu_00, (u32)FldMenu_ZukanInit },		// 
	{ msg_menu_01, (u32)FldMenu_PokemonInit },		// |P
	{ msg_menu_02, (u32)FldMenu_BagInit },			// obO
	{ msg_menu_03, (u32)FldMenu_TrCardInit },		// l
	{ msg_menu_04, (u32)FldMenu_ReportInit },		// |[g
	{ msg_menu_05, (u32)FldMenu_ConfigInit },		// Ă
	{ msg_menu_06, (u32)BMPLIST_CANCEL },			// Ƃ
	{ msg_menu_07, (u32)FldMenu_ChatInit }			// `bg
};

// |PXguvĂ΂obÕf[^
static const u8 PokeList_ItemSetBagList[] = {
	BAG_POKE_EVENT, BAG_POKE_NORMAL, BAG_POKE_NUTS, BAG_POKE_DRUG,
	BAG_POKE_BALL, BAG_POKE_BATTLE, BAG_POKE_SEAL, BAG_POKE_WAZA, 0xff
};


//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
#define	FLDMENU_CLA_CHR_RES_MAX		( 8 )
#define	FLDMENU_CLA_PAL_RES_MAX		( 1 )
#define	FLDMENU_CLA_CEL_RES_MAX		( 2 )
#define	FLDMENU_CLA_ANM_RES_MAX		( 2 )

enum {
	FLDMENU_CLA_CHR_H_ID_CURSOR	= 13528,
	FLDMENU_CLA_CHR_H_ID_ICON,
};
enum {
	FLDMENU_CLA_PAL_H_ID = 13528,
};
enum {
	FLDMENU_CLA_CEL_H_ID_CURSOR	= 13528,
	FLDMENU_CLA_CEL_H_ID_ICON,
};
enum {
	FLDMENU_CLA_ANM_H_ID_CURSOR	= 13528,
	FLDMENU_CLA_ANM_H_ID_ICON,
};

static const TCATS_RESOURCE_FILE_LIST CatsFileList = {
	"data/fmenu_chr.resdat",	// LN^
	"data/fmenu_pal.resdat",	// pbg
	"data/fmenu_cell.resdat",	// Z
	"data/fmenu_canm.resdat",	// ZAj
	NULL,						// }`Z
	NULL,						// }`ZAj
	"data/fmenu_h.cldat"		// wb_[
};

// ZAN^[̃wb_ID
/*
enum {
	CLA_ID_SELCURCOR = 0,	// IJ[\
	CLA_ID_ICON_ZUKAN,		// }ӃACR
	CLA_ID_ICON_POKEMON,	// |PXgACR
	CLA_ID_ICON_BAG,		// obOACR
	CLA_ID_ICON_HERO,		// g[i[J[hACR
	CLA_ID_ICON_REPORT,		// |[gACR
	CLA_ID_ICON_CONFIG,		// ݒACR
	CLA_ID_ICON_CLOSE,		// ACR
	CLA_ID_ICON_BAG_F		// obOij
};
*/

#define	CLA_ID_ICON_START	( 1 )
enum {
	ICON_ZUKAN,		// }ӃACR
	ICON_POKEMON,	// |PXgACR
	ICON_BAG,		// obOACR
	ICON_HERO,		// g[i[J[hACR
	ICON_REPORT,	// |[gACR
	ICON_CONFIG,	// ݒACR
	ICON_CLOSE,		// ACR
	ICON_BAG_F,		// obOij
	ICON_CHAT,		// `bg
};


// ZAN^[o^ꏊ
#define	CLA_SET_CURSOR	( 0 )	// IJ[\
#define	CLA_SET_ICON	( 1 )	// ACR

#define	CLA_CURSOR_PX	( 204 )
#define	CLA_CURSOR_PY	( 20 )
#define	CLA_ICON_PX		( 174 )
#define	CLA_ICON_PY		( 20 )
#define	CLA_ICON_SPC_Y	( 24 )

enum {
	ICON_ANM_STOP = 0,
	ICON_ANM_CHANGE,
	ICON_ANM_SELECT,
};

static const TCATS_OBJECT_ADD_PARAM	ActAddParam[] =
{
	{	// J[\
		0,
		CLA_CURSOR_PX, CLA_CURSOR_PY, 0,
		0, 1, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ACR
		1,
		CLA_ICON_PX, CLA_ICON_PY, 0,
		0, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
};

static const TCATS_OBJECT_ADD_PARAM_S ActAddParam_S[] =
{
	{	// J[\
		CLA_CURSOR_PX, CLA_CURSOR_PY, 0,
		0, 1, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		{
			FLDMENU_CLA_CHR_H_ID_CURSOR, FLDMENU_CLA_PAL_H_ID,
			FLDMENU_CLA_CEL_H_ID_CURSOR, FLDMENU_CLA_ANM_H_ID_CURSOR, 0, 0,
		},
		0, 0
	},
	{	// ACRP
		CLA_ICON_PX, CLA_ICON_PY, 0,
		0, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN,
		{
			FLDMENU_CLA_CHR_H_ID_ICON, FLDMENU_CLA_PAL_H_ID,
			FLDMENU_CLA_CEL_H_ID_ICON, FLDMENU_CLA_ANM_H_ID_ICON, 0, 0,
		},
		0, 0
	},
};



static void CellActSet( FLD_MENU * wk, u8 * list, u32 max, u8 sex );
static void CellActDelete( FLD_MENU * wk );
static void CellActAnm( FLD_MENU * wk );
static void CursorMove( CLACT_WORK_PTR cwp, u32 cur_pos );
static void IconAnmChange( CLACT_WORK_PTR cwp, u16 anm, u16 pal );
static void MoveIconAnmChg( FLD_MENU * wk, u16 old_pos, u16 new_pos );
static void SelectIconAnmCheck( CLACT_WORK_PTR cwp );
//static void IconCharChg( FLD_MENU * wk, u32 id, u32 num );


static void CellActSet( FLD_MENU * wk, u8 * list, u32 max, u8 sex )
{
	TCATS_RESOURCE_NUM_LIST	crnl = {
		FLDMENU_CLA_CHR_RES_MAX, FLDMENU_CLA_PAL_RES_MAX,
		FLDMENU_CLA_CEL_RES_MAX, FLDMENU_CLA_ANM_RES_MAX, 0, 0
	};
	u32	i;

	FieldCellActSet_S( &wk->fcat, &crnl, FLDMENU_CLACT_MAX, HEAPID_WORLD );

	FldClact_LoadResPlttArc(
		&wk->fcat, ARC_MENU_GRA,
		NARC_menu_gra_fmenu_obj_NCLR, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN, FLDMENU_CLA_PAL_H_ID );

	FldClact_LoadResCellArc(
		&wk->fcat, ARC_MENU_GRA, NARC_menu_gra_fmenu_cur_NCER, 0, FLDMENU_CLA_CEL_H_ID_CURSOR );

	FldClact_LoadResCellAnmArc(
		&wk->fcat, ARC_MENU_GRA, NARC_menu_gra_fmenu_cur_NANR, 0, FLDMENU_CLA_ANM_H_ID_CURSOR );

	FldClact_LoadResourceCharArc(
		&wk->fcat, ARC_MENU_GRA, NARC_menu_gra_fmenu_cur_NCGR,
		0, NNS_G2D_VRAM_TYPE_2DMAIN, FLDMENU_CLA_CHR_H_ID_CURSOR );

	wk->cap[CLA_SET_CURSOR] = FieldCellActAdd_S( &wk->fcat, &ActAddParam_S[CLA_SET_CURSOR] );

	CursorMove( wk->cap[CLA_SET_CURSOR]->act, wk->pos );


	FldClact_LoadResCellArc(
		&wk->fcat, ARC_MENU_GRA, NARC_menu_gra_fmenu_obj_NCER, 0, FLDMENU_CLA_CEL_H_ID_ICON );

	FldClact_LoadResCellAnmArc(
		&wk->fcat, ARC_MENU_GRA, NARC_menu_gra_fmenu_obj_NANR, 0, FLDMENU_CLA_ANM_H_ID_ICON );

	FldClact_LoadResourceCharArc(
		&wk->fcat, ARC_MENU_GRA, NARC_menu_gra_fmenu_obj_NCGR,
		0, NNS_G2D_VRAM_TYPE_2DMAIN, FLDMENU_CLA_CHR_H_ID_ICON );

	for( i=0; i<max; i++ ){
		TCATS_OBJECT_ADD_PARAM_S	prm;

		prm = ActAddParam_S[CLA_SET_ICON];
		prm.y += CLA_ICON_SPC_Y * i;

		if( list[i] == MENU_POS_BAG && sex == 1 ){
			prm.anm = ICON_BAG_F * 3;
		}else{
			prm.anm = list[i] * 3;
		}

		wk->cap[CLA_SET_ICON+i] = FieldCellActAdd_S( &wk->fcat, &prm );

		{
			VecFx32 sca = { FX32_ONE, FX32_ONE, FX32_ONE };
			CLACT_SetScaleAffine( wk->cap[CLA_SET_ICON+i]->act, &sca, CLACT_AFFINE_NORMAL );
		}
	}
	IconAnmChange( wk->cap[CLA_SET_ICON+wk->pos]->act, ICON_ANM_SELECT, 1 );

	wk->clact_max = max + 1;


	GF_Disp_GX_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );
}


static void CellActDelete( FLD_MENU * wk )
{
	u16	i;

	for( i=0; i<wk->clact_max; i++ ){
		CATS_ActorPointerDelete_S( wk->cap[i] );
	}
	FieldCellActDelete_S( &wk->fcat );
}

static void CellActAnm( FLD_MENU * wk )
{
	u16	i;

	for( i=0; i<wk->clact_max; i++ ){
		CLACT_AnmFrameChg( wk->cap[i]->act, FX32_ONE );
	}
}

static void CursorMove( CLACT_WORK_PTR cwp, u32 cur_pos )
{
	VecFx32	act_pos;

	act_pos = *(CLACT_GetMatrix( cwp ));
	act_pos.y = ( CLA_CURSOR_PY + CLA_ICON_SPC_Y * cur_pos ) * FX32_ONE;
	CLACT_SetMatrix( cwp, &act_pos );
}


static void IconAnmChange( CLACT_WORK_PTR cwp, u16 anm, u16 pal )
{
	u32	now_anm = CLACT_AnmGet( cwp );

	CLACT_AnmChg( cwp, (now_anm/3)*3+anm );
	CLACT_PaletteNoChgAddTransPlttNo( cwp, pal );
}

static void MoveIconAnmChg( FLD_MENU * wk, u16 old_pos, u16 new_pos )
{
	IconAnmChange( wk->cap[CLA_SET_ICON+old_pos]->act, ICON_ANM_STOP, 0 );
	IconAnmChange( wk->cap[CLA_SET_ICON+new_pos]->act, ICON_ANM_CHANGE, 1 );
}

static void SelectIconAnmCheck( CLACT_WORK_PTR cwp )
{
	if( ( CLACT_AnmGet( cwp ) % 3 ) != ICON_ANM_CHANGE ){
		return;
	}
	if( CLACT_AnmActiveCheck( cwp ) == FALSE ){
		IconAnmChange( cwp, ICON_ANM_SELECT, 1 );
	}
}



//============================================================================================
//============================================================================================









//--------------------------------------------------------------------------------------------
/**
 * @brief	tB[hj[N
 * @param	work
 *
 */
//--------------------------------------------------------------------------------------------
static FLD_MENU * MenuWorkAllocSet(void)
{
	FLD_MENU * wk;

	wk = sys_AllocMemory( HEAPID_WORLD, sizeof(FLD_MENU) );
	wk->seq = FLD_MENU_SEQ_INIT;
	wk->pos = 0;
	wk->app_wk = NULL;

	return wk;
}

void FieldMenuInit( struct _FIELDSYS_WORK * repw, u32 * flg )
{
	FLD_MENU * wk = MenuWorkAllocSet();

	wk->ev_flg = *flg;

	if( Player_MoveForceStopCheck( repw->player ) == TRUE ){
		Player_MoveForceStop( repw->player, Player_DirGet(repw->player) );
	}

	FieldEvent_Set(repw, GMEVENT_FieldMenu, wk);
}

void FieldMenuEvChg( FIELDSYS_WORK * repw )
{
	FLD_MENU * wk;
	
	// ̃[N
	//sys_FreeMemoryEz( FieldEvent_GetSpecialWork(repw->event) );
	
	// j[[N쐬
	Snd_SePlay( SEQ_SE_DP_WIN_OPEN );
	wk = MenuWorkAllocSet();
	FieldEvent_Change( repw->event, GMEVENT_FieldMenu, wk );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	tB[hCxgFj[
 * @param	event	tB[hCxgpp[^
 * @retval	TRUE	CxgI
 * @retval	FALSE	Cxgp
 */
//--------------------------------------------------------------------------------------------
static BOOL GMEVENT_FieldMenu(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork(event);
	wk = FieldEvent_GetSpecialWork(event);

	switch( wk->seq ){
	case FLD_MENU_SEQ_INIT:
		FieldOBJSys_MoveStopAll( fsys->fldobjsys );
		FieldMenuSet( event );
		wk->seq = FLD_MENU_SEQ_SELECT;
		break;

	case FLD_MENU_SEQ_SELECT:
		FieldMenuSelect( event );
		break;

	case FLD_MENU_SEQ_ZUKAN_CALL:
		FldMenu_ZukanCall( event );
		break;
	case FLD_MENU_SEQ_ZUKAN_WAIT:
		FldMenu_ZukanWait( event );
		break;

	case FLD_MENU_SEQ_POKEMON_CALL:
		FldMenu_PokemonCall( event );
		break;
	case FLD_MENU_SEQ_POKEMON_WAIT:
		FldMenu_PokemonWait( event );
		break;

	case FLD_MENU_SEQ_BAG_CALL:
		FldMenu_BagCall( event );
		break;
	case FLD_MENU_SEQ_BAG_WAIT:
		FldMenu_BagWait( event );
		break;

	case FLD_MENU_SEQ_TR_CARD_CALL:
		FldMenu_TrCardCall( event );
		break;
	case FLD_MENU_SEQ_TR_CARD_WAIT:
		FldMenu_TrCardWait( event );
		break;

	case FLD_MENU_SEQ_REPORT_CALL:
		FldMenu_ReportCall( event );
		break;
	case FLD_MENU_SEQ_REPORT_WAIT:
		FldMenu_ReportWait( event );
		break;

	case FLD_MENU_SEQ_CONFIG_CALL:
		FldMenu_ConfigCall( event );
		break;
	case FLD_MENU_SEQ_CONFIG_WAIT:
		FldMenu_ConfigWait( event );
		break;

	case FLD_MENU_SEQ_CHAT_CALL:
		FldMenu_ChatCall( event );
		break;
	case FLD_MENU_SEQ_CHAT_WAIT:
		FldMenu_ChatWait( event );
		break;


	case FLD_MENU_SEQ_PSTATUS_WAIT:
		SubApp_PStatusWait( event );
		break;


	case FLD_MENU_SEQ_SKILL_USE_INIT:
		//tB[h}bvvZXJn҂
		if( FieldEvent_Cmd_WaitMapProcStart(fsys) ){
			//ubNCNGXg
			FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKIN );
			wk->seq = FLD_MENU_SEQ_SKILL_USE;
			break;
		}
		break;
	case FLD_MENU_SEQ_SKILL_USE:
		if( IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) ){
			SKILL_USE * suwk = wk->app_wk;
			FieldSkill_EvChange( fsys, suwk->poke, suwk->waza );
			sys_FreeMemoryEz( suwk );
		}
		break;

	case FLD_MENU_SEQ_NTAG_WAIT:
		FldMenu_NutsTagWait( event );
		break;

	case FLD_MENU_SEQ_TOWNMAP_WAIT:
		FldMenu_TownMapWait( event );
		break;

	case FLD_MENU_SEQ_TANKENSET_INIT:
		//tB[h}bvvZXJn҂
		if( FieldEvent_Cmd_WaitMapProcStart(fsys) ){
			//ubNCNGXg
			FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKIN );
			wk->seq = FLD_MENU_SEQ_TANKENSET_USE;
			break;
		}
		break;
	case FLD_MENU_SEQ_TANKENSET_USE:
		if( IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) ){
			D_ChangeUnderGroundDirect( fsys );
//			BmpMenuExit( wk->mw, NULL );
//			BmpMenuWinClear( &wk->win, WINDOW_TRANS_ON );
//			GF_BGL_BmpWinDel( &wk->win );
			sys_FreeMemory( HEAPID_WORLD, wk );
		}
		break;

	case FLD_MENU_SEQ_FNOTE_WAIT:
		FldMenu_FantasyNoteWait( event );
		break;

	case FLD_MENU_SEQ_MAIL_WAIT:
		FldMenu_MailWait( event );
		break;

	case FLD_MENU_SEQ_PORUTO_CASE:
		FldMenu_PorutoCaseWait( event );
		break;

	case FLD_MENU_SEQ_AGAIN:	// 
		//tB[h}bvvZXJn҂
		if (FieldEvent_Cmd_WaitMapProcStart(fsys)) {
			FieldOBJSys_MoveStopAll( fsys->fldobjsys );
			FieldMenuSet( event );
			//ubNCNGXg
			FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKIN );
//			wk->seq = FLD_MENU_SEQ_BLACK_IN_REQ;
			wk->seq = FLD_MENU_SEQ_WAIT_BLACK_IN;
		}
		break;

	case FLD_MENU_SEQ_BLACK_IN_END:
		//tB[h}bvvZXJn҂
		if(FieldEvent_Cmd_WaitMapProcStart(fsys)) {
			//ubNCNGXg
			FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKIN );
			wk->seq = FLD_MENU_SEQ_BLACK_IN_END_WAIT;
		}
		break;

	case FLD_MENU_SEQ_BLACK_IN_END_WAIT:
		if( IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) ){
			sys_FreeMemory( HEAPID_WORLD, wk );
			FieldOBJSys_MoveStopAllClear( fsys->fldobjsys );
			return TRUE;
		}
		break;

	case FLD_MENU_SEQ_END_NOMENU:
		//j[łɕĂԂŏI
		sys_FreeMemory( HEAPID_WORLD, wk );
		FieldOBJSys_MoveStopAllClear( fsys->fldobjsys );
		return TRUE;

	case FLD_MENU_SEQ_END:
		{
//			int select=wk->ret;

			FieldMenuListExit( wk );
			BmpMenuWinClear( &wk->win, WINDOW_TRANS_OFF );
			GF_BGL_LoadScreenV_Req( wk->win.ini, wk->win.frmnum );
			GF_BGL_BmpWinDel( &wk->win );
			sys_FreeMemory( HEAPID_WORLD, wk );
			FieldOBJSys_MoveStopAllClear( fsys->fldobjsys );
		}
		return TRUE;

/*
	case FLD_MENU_SEQ_BLACK_IN_REQ:
		FieldOBJSys_MoveStopAll( fsys->fldobjsys );
		FieldMenuSet( event );
		wk->seq = FLD_MENU_SEQ_WAIT_BLACK_IN;
		break;
*/
	case FLD_MENU_SEQ_WAIT_BLACK_IN:
		if ( IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) ){
			wk->seq = FLD_MENU_SEQ_SELECT;
		}
		break;
	}

	if( wk->mw != NULL ){
		CellActAnm( wk );
		CLACT_Draw( wk->fcat.cas );
	}

	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * tB[hj[쐬
 *
 * @param	event	tB[hCxgpp[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void FieldMenuSet( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;
	MSGDATA_MANAGER * man;
	BMPMENU_HEADER	hed;
	u32	i, max;
	u8	list[ FIELD_MENU_MAX ];

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	max = FieldMenuListMake( wk, list );

	GF_BGL_BmpWinAdd(
		fsys->bgl, &wk->win, FLD_MBGFRM_FONT, FLD_MENU_WIN_PX, FLD_MENU_WIN_PY,
//		FLD_MENU_WIN_SX, max*3, FLD_MENU_WIN_PAL, FLD_MENU_WIN_CGX );
		FLD_MENU_WIN_SX, max*3, FLD_MSG_WIN_PAL, FLD_MENU_WIN_CGX );

	MenuWinGraphicSet(
		fsys->bgl, FLD_MBGFRM_FONT, MENU_WIN_CGX_NUM, MENU_WIN_PAL, MENU_TYPE_FIELD, HEAPID_WORLD );
	BmpMenuWinWrite( &wk->win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );

	man = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_fieldmenu_dat, HEAPID_WORLD );
	wk->ld = BMP_MENULIST_Create( max, HEAPID_WORLD );
	for( i=0; i<max; i++ ){
		if( list[i] == MENU_POS_HERO ){
			WORDSET * wset;
			STRBUF * expb;
			STRBUF * strb;
			
			wset = WORDSET_Create( HEAPID_WORLD );
			expb = STRBUF_Create( BUFLEN_PERSON_NAME, HEAPID_WORLD );
			strb = MSGMAN_AllocString( man, FldMenuData[list[i]][0] );

			WORDSET_RegisterPlayerName( wset, 0, SaveData_GetMyStatus(fsys->savedata) );
			WORDSET_ExpandStr( wset, expb, strb );

			BMP_MENULIST_AddString( wk->ld, expb, list[i] );

			STRBUF_Delete( strb );
			STRBUF_Delete( expb );
			WORDSET_Delete( wset );
		}else{
			BMP_MENULIST_AddArchiveString(
				wk->ld, man, FldMenuData[list[i]][0], list[i] );
		}
	}
	MSGMAN_Delete( man );

	hed.menu  = wk->ld;
	hed.win   = &wk->win;
	hed.font  = FONT_TALK;
	hed.x_max = 1;
	hed.y_max = max;
	hed.line_spc = 8;
	hed.c_disp_f = 1;
	if( max >= 4 ){
		hed.loop_f = 1;
	}else{
		hed.loop_f = 0;
	}
	wk->mw = BmpMenuAdd_NoTrans(
				&hed, 28, 4, wk->pos, HEAPID_WORLD, PAD_BUTTON_CANCEL|PAD_BUTTON_START );

	GF_BGL_BmpWinOnVReq( &wk->win );

	CellActSet( wk, list, max, MyStatus_GetMySex(SaveData_GetMyStatus(fsys->savedata)) );
}

//--------------------------------------------------------------------------------------------
/**
 * j[Xg쐬
 *
 * @param	event	tB[hCxgpp[^
 * @param	list	Xg쐬ꏊ
 *
 * @return	ڐ
 */
//--------------------------------------------------------------------------------------------
static u32 FieldMenuListMake( FLD_MENU * wk, u8 * list )
{
	u32	max = 0;

	// `bg
	if( ( wk->ev_flg & FLD_MENU_VANISH_CHAT ) == 0 ){
		list[max] = MENU_POS_CHAT;
		max++;
	}
	// }
	if( ( wk->ev_flg & FLD_MENU_VANISH_ZUKAN ) == 0 ){
		list[max] = MENU_POS_ZUKAN;
		max++;
	}
	// |PXg
	if( ( wk->ev_flg & FLD_MENU_VANISH_PLIST ) == 0 ){
		list[max] = MENU_POS_POKEMON;
		max++;
	}
	// obO
	if( ( wk->ev_flg & FLD_MENU_VANISH_BAG ) == 0 ){
		list[max] = MENU_POS_BAG;
		max++;
	}
	// g[i[J[h
	if( ( wk->ev_flg & FLD_MENU_VANISH_TRCARD ) == 0 ){
		list[max] = MENU_POS_HERO;
		max++;
	}
	// |[g
	if( ( wk->ev_flg & FLD_MENU_VANISH_REPORT ) == 0 ){
		list[max] = MENU_POS_REPORT;
		max++;
	}
	// ݒ
	if( ( wk->ev_flg & FLD_MENU_VANISH_CONFIG ) == 0 ){
		list[max] = MENU_POS_CONFIG;
		max++;
	}
	// 
	if( ( wk->ev_flg & FLD_MENU_VANISH_CLOSE ) == 0 ){
		list[max] = MENU_POS_EXIT;
		max++;
	}

	return max;
}

//--------------------------------------------------------------------------------------------
/**
 * j[폜
 *
 * @param	wk		j[[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void FieldMenuListExit( FLD_MENU * wk )
{
	CellActDelete( wk );

	BmpMenuExit( wk->mw, NULL );

	BMP_MENULIST_Delete( wk->ld );

	wk->mw = NULL;
}

//--------------------------------------------------------------------------------------------
/**
 * I
 *
 * @param	wk		j[[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void FieldMenuSelect( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;
	u16	cur;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	cur = BmpMenuCursorPosGet( wk->mw );
	wk->ret = BmpMenuMain_SE( wk->mw, SE_FLD_MENU_SELECT );
	wk->pos = BmpMenuCursorPosGet( wk->mw );

	if( cur != wk->pos ){
//		CursorMove( wk->cwp[CLA_SET_CURSOR], wk->pos );
		CursorMove( wk->cap[CLA_SET_CURSOR]->act, wk->pos );
		MoveIconAnmChg( wk, cur, wk->pos );
	}

	SelectIconAnmCheck( wk->cap[CLA_SET_ICON+wk->pos]->act );

	switch( wk->ret ){
	case BMPLIST_NULL:
		break;
	case BMPLIST_CANCEL:
		wk->seq = FLD_MENU_SEQ_END;
		break;
	default:
		if( FldMenuData[wk->ret][1] == BMPLIST_CANCEL ){
			wk->seq = FLD_MENU_SEQ_END;
		}else if( FldMenuData[wk->ret][1] != BMPLIST_NULL ){
			GMEVENT_FUNC func = (GMEVENT_FUNC)FldMenuData[wk->ret][1];
			func( event );
		}
	}
}




//=============================================================================================
//=============================================================================================
//	j[F
//=============================================================================================
//=============================================================================================
static void FldMenu_ZukanInit( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKOUT );

	wk->seq = FLD_MENU_SEQ_ZUKAN_CALL;
}

static void FldMenu_ZukanCall( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;
	ZKN_PEARENT_DATA * p_pearent;
	ZUKAN_WORK * p_zukan;
	MYSTATUS * p_mystatus;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == FALSE ){
		return;
	}

	FieldMenuListExit( wk );
	GF_BGL_BmpWinDel( &wk->win );

	p_pearent = sys_AllocMemory( HEAPID_WORLD, sizeof(ZKN_PEARENT_DATA) );
	p_zukan   = SaveData_GetZukanWork( fsys->savedata );
	p_mystatus = SaveData_GetMyStatus( fsys->savedata );
	p_pearent->cp_zukansave_data = p_zukan;
	p_pearent->cp_hero_data = p_mystatus;
	p_pearent->time_zone = EVTIME_GetTimeZone( fsys );
	FieldZukan_SetProc( fsys, p_pearent );

	wk->app_wk = p_pearent;
	wk->seq = FLD_MENU_SEQ_ZUKAN_WAIT;
}

static void FldMenu_ZukanWait( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	// TuvZXI҂
	if( FieldEvent_Cmd_WaitSubProcEnd( fsys ) ) {
		return;
	}

	//tB[h}bvvZXA
	FieldEvent_Cmd_SetMapProc( fsys );

	if( wk->app_wk != NULL ){
		sys_FreeMemory( HEAPID_WORLD, wk->app_wk );
	}

//	wk->pos = MENU_POS_ZUKAN;
	wk->seq = FLD_MENU_SEQ_AGAIN;
}


//=============================================================================================
//=============================================================================================
//	j[F|P
//=============================================================================================
//=============================================================================================
static void FldMenu_PokemonInit( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKOUT );

	wk->seq = FLD_MENU_SEQ_POKEMON_CALL;
}

static void FldMenu_PokemonCall( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == FALSE ){
		return;
	}

	FieldMenuListExit( wk );
	GF_BGL_BmpWinDel( &wk->win );

	wk->app_wk = FieldPokeList_SetProc( fsys, 0 );

	wk->seq = FLD_MENU_SEQ_POKEMON_WAIT;
}

static const u8 PST_PageTbl_Normal[] = {
	PST_PAGE_INFO,			// u|P傤قv
	PST_PAGE_MEMO,			// ug[i[v
	PST_PAGE_PARAM,			// u|P̂傭v
	PST_PAGE_CONDITION,		// uRfBVv
	PST_PAGE_B_SKILL,		// u킴v
	PST_PAGE_C_SKILL,		// uReXg킴v
	PST_PAGE_RET,			// uǂv
	PST_PAGE_MAX
};

static const u8 PST_PageTbl_WazaSet[] = {
	PST_PAGE_B_SKILL,		// u킴v
	PST_PAGE_C_SKILL,		// uReXg킴v
//	PST_PAGE_RET,			// uǂv
	PST_PAGE_MAX
};

static void FldMenu_PokemonWait( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	// TuvZXI҂
	if( FieldEvent_Cmd_WaitSubProcEnd( fsys ) ) {
		return;
	}

	{
		PLIST_DATA * dat = (PLIST_DATA *)sys_AllocMemory( HEAPID_WORLD, sizeof(PLIST_DATA) );

		memcpy( dat, wk->app_wk, sizeof(PLIST_DATA) );
		sys_FreeMemoryEz( wk->app_wk );

		switch( dat->ret_mode ){
		case PL_RET_STATUS:
			{
				PSTATUS_DATA * psd = sys_AllocMemory( HEAPID_WORLD, sizeof(PSTATUS_DATA) );

				psd->ppd  = SaveData_GetTemotiPokemon(fsys->savedata);
				psd->ppt  = PST_PP_TYPE_POKEPARTY;
				psd->pos  = dat->ret_sel;
				psd->max  = (u8)PokeParty_GetPokeCount( psd->ppd );
				psd->waza = 0;
				psd->mode = PST_MODE_NORMAL;
				PokeStatus_PageSet( psd, PST_PageTbl_Normal );
				FieldPokeStatus_SetProc( fsys, psd );
				wk->app_wk = psd;
				wk->seq = FLD_MENU_SEQ_PSTATUS_WAIT;
			}
			break;

		case PL_RET_WAZASET:
			{
				PSTATUS_DATA * psd = sys_AllocMemory( HEAPID_WORLD, sizeof(PSTATUS_DATA) );

				psd->ppd  = SaveData_GetTemotiPokemon(fsys->savedata);
				psd->ppt  = PST_PP_TYPE_POKEPARTY;
				psd->pos  = dat->ret_sel;
				psd->max  = 1;
				psd->waza = dat->waza;
				psd->mode = PST_MODE_WAZAADD;
				PokeStatus_PageSet( psd, PST_PageTbl_WazaSet );
				FieldPokeStatus_SetProc( fsys, psd );

				wk->app_wk = psd;
				{
					u32 * item = sys_AllocMemory( HEAPID_WORLD, 4 );
					*item = dat->item;
					wk->tmp_wk = item;
				}
				wk->seq = FLD_MENU_SEQ_PSTATUS_WAIT;
			}
			break;

		case PL_RET_MAILSET:
			{
				MAIL_PARAM * mail;

				mail = FieldMailCreate_InitCall(
						fsys, MAILBLOCK_TEMOTI, dat->ret_sel,
						ItemMailDesignGet(dat->item), HEAPID_WORLD );
				wk->app_wk = mail;
				if( dat->mode == PL_MODE_ITEMSET_RET ){
					wk->tmp_wk = FieldMenu_MailWorkMake( 
									dat->item, FM_MAIL_MODE_MAKE_LIST, dat->ret_sel );
				}else{
					wk->tmp_wk = FieldMenu_MailWorkMake(
									dat->item, FM_MAIL_MODE_MAKE_BAG, dat->ret_sel );
				}
				wk->seq = FLD_MENU_SEQ_MAIL_WAIT;
			}
			break;

		case PL_RET_MAILREAD:
			{
				MAIL_PARAM * mail;
				POKEMON_PARAM * pp;

				pp = PokeParty_GetMemberPointer(
						SaveData_GetTemotiPokemon(fsys->savedata), dat->ret_sel );
				mail = FieldMailViewPoke_InitCall( fsys, pp, HEAPID_WORLD );
				wk->app_wk = mail;
				wk->tmp_wk = FieldMenu_MailWorkMake( dat->item, FM_MAIL_MODE_READ, dat->ret_sel );
				wk->seq = FLD_MENU_SEQ_MAIL_WAIT;
			}
			break;

		case PL_RET_ITEMSET:	// obO̎ACeI
			{
				MYITEM * myitem;
				void * myst;
				u32 * sel_pos;

				// I|Pʒuޔ
				sel_pos = (u32 *)sys_AllocMemory( HEAPID_WORLD, 4 );
				*sel_pos = dat->ret_sel;
				wk->tmp_wk = (void *)sel_pos;

				myitem = SaveData_GetMyItem( fsys->savedata );
				myst   = SaveData_GetMyStatus( fsys->savedata );
				wk->app_wk = MyItem_MakeBagData( myitem, PokeList_ItemSetBagList, HEAPID_WORLD );
				BagSystemDataSet( wk->app_wk, 0, BAG_MODE_ITEMSET, myst );
				GameSystem_StartSubProc( fsys, &BagProcData, wk->app_wk );
			}
			wk->seq = FLD_MENU_SEQ_BAG_WAIT;
			break;

		case PL_RET_IWAKUDAKI:		// j[ ZF킭
		case PL_RET_IAIGIRI:		// j[ ZF
		case PL_RET_SORAWOTOBU:		// j[ ZFƂ
		case PL_RET_KIRIBARAI:		// j[ ZF΂炢
		case PL_RET_KAIRIKI:		// j[ ZF肫
		case PL_RET_NAMINORI:		// j[ ZFȂ݂̂
		case PL_RET_ROCKCLIMB:		// j[ ZFbNNC
		case PL_RET_TAKINOBORI:		// j[ ZF̂ڂ
		case PL_RET_FLASH:			// j[ ZFtbV
		case PL_RET_TELEPORT:		// j[ ZFe|[g
		case PL_RET_ANAWOHORU:		// j[ ZFȂق
		case PL_RET_AMAIKAORI:		// j[ ZF܂
			{
				SKILL_USE * suwk = sys_AllocMemory( HEAPID_WORLD, sizeof(SKILL_USE) );
				suwk->poke = dat->ret_sel;
				suwk->waza = dat->ret_mode - PL_RET_IAIGIRI;
				wk->app_wk = suwk;
			}
			FieldEvent_Cmd_SetMapProc( fsys );
			wk->seq = FLD_MENU_SEQ_SKILL_USE_INIT;
			break;

		case PL_RET_BAG:			// obO֖߂
			wk->app_wk = FieldBag_SetProc( fsys );
			wk->seq    = FLD_MENU_SEQ_BAG_WAIT;
			break;

		default:
			if( dat->mode == PL_MODE_ITEMUSE || dat->mode == PL_MODE_ITEMSET ||
				dat->mode == PL_MODE_WAZASET || dat->mode == PL_MODE_WAZASET_RET ){
				wk->app_wk = FieldBag_SetProc( fsys );
				wk->seq    = FLD_MENU_SEQ_BAG_WAIT;
			}else{
				//tB[h}bvvZXA
				FieldEvent_Cmd_SetMapProc( fsys );
//				wk->pos = MENU_POS_POKEMON;
				wk->seq = FLD_MENU_SEQ_AGAIN;
			}
		}
		sys_FreeMemoryEz( dat );
	}
}


//=============================================================================================
//=============================================================================================
//	j[FobO
//=============================================================================================
//=============================================================================================
static void FldMenu_BagInit( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKOUT );

	wk->seq = FLD_MENU_SEQ_BAG_CALL;
}

static void FldMenu_BagCall( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == FALSE ){
		return;
	}

	FieldMenuListExit( wk );
	GF_BGL_BmpWinDel( &wk->win );

	wk->app_wk = FieldBag_SetProc( fsys );

	wk->seq = FLD_MENU_SEQ_BAG_WAIT;
}

static void FldMenu_BagWait( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	// TuvZXI҂
	if( FieldEvent_Cmd_WaitSubProcEnd( fsys ) ) {
		return;
	}

	{
		BAG_DATA * dat = BagSystemDataAlloc( HEAPID_WORLD );

		memcpy( dat, wk->app_wk, BagSystemDataSizeGet() );
		sys_FreeMemoryEz( wk->app_wk );

		switch( BagSysReturnModeGet( dat ) ){
		case BAG_RET_USE:		// 
			{
				ITEMUSE_FUNC func;
				s32	use_id;
				u16	item;

				item   = BagSysReturnItemGet( dat );
				use_id = ItemParamGet( item, ITEM_PRM_FIELD, HEAPID_WORLD );
				func   = (ITEMUSE_FUNC)ItemUse_FuncGet( use_id );
				func( event, item );
			}
			break;

		case BAG_RET_TAG:		// ^O݂
			FldMenu_NutsTagCall( event, BagSysReturnItemGet(dat) );
			break;

		case BAG_RET_ITEMSET:	// 
			{
				PLIST_DATA * pld;

				pld  = sys_AllocMemory( HEAPID_WORLD, sizeof(PLIST_DATA) );
				memset( pld, 0, sizeof(PLIST_DATA) );
				pld->pp     = SaveData_GetTemotiPokemon(fsys->savedata);
				pld->myitem = SaveData_GetMyItem( fsys->savedata );
				pld->type = PL_TYPE_SINGLE;
				pld->mode = PL_MODE_ITEMSET;
				pld->item = BagSysReturnItemGet( dat );
				GameSystem_StartSubProc( fsys, &PokeListProcData, pld );
				wk->app_wk = pld;
				wk->seq = FLD_MENU_SEQ_POKEMON_WAIT;
			}
			break;

		case BAG_RET_POKEITEMSET:	// |PXguv
			{
				POKEPARTY * party;
				POKEMON_PARAM * pp;
				u32 pos;
				u16	item;

				party = SaveData_GetTemotiPokemon( fsys->savedata );
				pos   = *(u32 *)wk->tmp_wk;
				item  = BagSysReturnItemGet( dat );
				pp    = PokeParty_GetMemberPointer( party, pos );

				sys_FreeMemoryEz( wk->tmp_wk );

				if( ItemMailCheck( item ) == TRUE && PokeParaGet( pp, ID_PARA_item, NULL ) == 0 ){
					MAIL_PARAM * mail;
					FM_MAIL_WORK * make;

					mail = FieldMailCreate_InitCall(
							fsys, MAILBLOCK_TEMOTI, pos,
							ItemMailDesignGet(item), HEAPID_WORLD );
					wk->app_wk = mail;
					wk->tmp_wk = FieldMenu_MailWorkMake( item, FM_MAIL_MODE_MAKE_LIST, (u8)pos );
					wk->seq = FLD_MENU_SEQ_MAIL_WAIT;
				}else{
					PLIST_DATA * pld;

					pld  = sys_AllocMemory( HEAPID_WORLD, sizeof(PLIST_DATA) );
					memset( pld, 0, sizeof(PLIST_DATA) );
					pld->pp     = party;
					pld->myitem = SaveData_GetMyItem( fsys->savedata );
					pld->type = PL_TYPE_SINGLE;
					pld->item = BagSysReturnItemGet( dat );
					pld->ret_sel = (u8)pos;
					if( pld->item == 0 ){
						pld->mode = PL_MODE_FIELD;
					}else{
						pld->mode = PL_MODE_ITEMSET_RET;
					}
					GameSystem_StartSubProc( fsys, &PokeListProcData, pld );
					wk->app_wk = pld;
					wk->seq = FLD_MENU_SEQ_POKEMON_WAIT;
				}
			}
			break;

		case BAG_RET_CANCEL:
		default:
			//tB[h}bvvZXA
			FieldEvent_Cmd_SetMapProc( fsys );
//			wk->pos = MENU_POS_BAG;
			wk->seq = FLD_MENU_SEQ_AGAIN;
		}
		sys_FreeMemoryEz( dat );
	}
}


//=============================================================================================
//=============================================================================================
//	j[Filj
//=============================================================================================
//=============================================================================================
static void FldMenu_TrCardInit( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKOUT );

	wk->seq = FLD_MENU_SEQ_TR_CARD_CALL;
}

static void FldMenu_TrCardCall( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == FALSE ){
		return;
	}

	FieldMenuListExit( wk );
	GF_BGL_BmpWinDel( &wk->win );

	wk->app_wk = TRCSET_AllocTrainerCardData( HEAPID_WORLD );
	TRCSET_MakeTrainerInfo( 1, fsys, (TR_CARD_DATA *)wk->app_wk );

	FieldTrCard_SetProc( fsys, (TR_CARD_DATA *)wk->app_wk );

	wk->seq = FLD_MENU_SEQ_TR_CARD_WAIT;
}

static void FldMenu_TrCardWait( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	// TuvZXI҂
	if( FieldEvent_Cmd_WaitSubProcEnd( fsys ) ) {
		return;
	}

	TRCSET_FreeTrainerCardData( wk->app_wk );
	//tB[h}bvvZXA
	FieldEvent_Cmd_SetMapProc( fsys );
	wk->seq = FLD_MENU_SEQ_AGAIN;
}


//=============================================================================================
//=============================================================================================
//	j[F|[g
//=============================================================================================
//=============================================================================================
typedef struct {
	void * infowin;		///<Z[uEBhEp|C^
	int result;			///<Z[uʎ󂯎p[N
}FLDMENU_REPORT_WORK;

///j[ځF|[gF
static void FldMenu_ReportInit( GMEVENT_CONTROL * event )
{
	FLD_MENU * wk   = FieldEvent_GetSpecialWork( event );

	//tB[hj[
	FieldMenuListExit( wk );
	BmpMenuWinClear( &wk->win, WINDOW_TRANS_OFF );
	GF_BGL_LoadScreenV_Req( wk->win.ini, wk->win.frmnum );
	GF_BGL_BmpWinDel( &wk->win );

	wk->seq = FLD_MENU_SEQ_REPORT_CALL;
}

///j[ځF|[gFĂяo
static void FldMenu_ReportCall( GMEVENT_CONTROL * event )
{
	FLD_MENU * wk   = FieldEvent_GetSpecialWork( event );
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork( event );
	FLDMENU_REPORT_WORK * repwk;

/*
	//tB[hj[
	FieldMenuListExit( wk );
	BmpMenuWinClear( &wk->win, WINDOW_TRANS_OFF );
	GF_BGL_LoadScreenV_Req( wk->win.ini, wk->win.frmnum );
	GF_BGL_BmpWinDel( &wk->win );
*/

	//|[g񐶐
	wk->app_wk = sys_AllocMemory(HEAPID_EVENT, sizeof(FLDMENU_REPORT_WORK));
	repwk = wk->app_wk;
	repwk->infowin = ReportInfo_Create(fsys, HEAPID_WORLD, FLD_MBGFRM_FONT);
	ReportInfo_WriteWindow(repwk->infowin);
	//ʎ󂯎p[N
	repwk->result = FALSE;
	
	EventCall_Script( event, SCRID_REPORT, NULL, &repwk->result );

	wk->seq = FLD_MENU_SEQ_REPORT_WAIT;
}

///j[ځF|[gFʏ
static void FldMenu_ReportWait( GMEVENT_CONTROL * event )
{
	FLD_MENU * wk   = FieldEvent_GetSpecialWork( event );
	FLDMENU_REPORT_WORK * repwk = wk->app_wk;

	ReportInfo_EraseWindow(repwk->infowin);
	ReportInfo_Delete(repwk->infowin);
	wk->seq = FLD_MENU_SEQ_INIT;
	if( repwk->result == FALSE ){		//Z[uĂȂ
		wk->seq = FLD_MENU_SEQ_INIT;
	}else{								//Z[u
		wk->seq = FLD_MENU_SEQ_END_NOMENU;
	}
	sys_FreeMemoryEz(repwk);
}


//=============================================================================================
//=============================================================================================
//	j[FĂ
//=============================================================================================
//=============================================================================================
static void FldMenu_ConfigInit( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKOUT );

	wk->seq = FLD_MENU_SEQ_CONFIG_CALL;
}

static void FldMenu_ConfigCall( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == FALSE ){
		return;
	}

	FieldMenuListExit( wk );
	GF_BGL_BmpWinDel( &wk->win );

	wk->app_wk = FieldConfig_SetProc( fsys );

	wk->seq = FLD_MENU_SEQ_CONFIG_WAIT;
}

static void FldMenu_ConfigWait( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	// TuvZXI҂
	if( FieldEvent_Cmd_WaitSubProcEnd( fsys ) ) {
		return;
	}

	//
	sys_FreeMemoryEz( wk->app_wk );
	//tB[h}bvvZXA
	FieldEvent_Cmd_SetMapProc( fsys );
	wk->seq = FLD_MENU_SEQ_AGAIN;
}


//=============================================================================================
//=============================================================================================
//	j[F`bg
//=============================================================================================
//=============================================================================================
static void FldMenu_ChatInit( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKOUT );

	wk->seq = FLD_MENU_SEQ_CHAT_CALL;
}

static void FldMenu_ChatCall( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == FALSE ){
		return;
	}

	FieldMenuListExit( wk );
	GF_BGL_BmpWinDel( &wk->win );

	wk->app_wk = PMSI_PARAM_Create( PMSI_MODE_SENTENCE, PMSI_GUIDANCE_DEFAULT, fsys->savedata, HEAPID_WORLD );
	FieldProc_SetPmsInput( fsys, (PMSI_PARAM*)wk->app_wk );

	wk->seq = FLD_MENU_SEQ_CHAT_WAIT;
}

static void FldMenu_ChatWait( GMEVENT_CONTROL * event )
{
	PMS_DATA pmsdata;

	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	// TuvZXI҂
	if( FieldEvent_Cmd_WaitSubProcEnd( fsys ) ) {
		return;
	}

	// ȈՉbXVH
	if ( PMSI_PARAM_CheckCanceled( wk->app_wk )==0 ){

		// ȈՉb擾
		PMSI_PARAM_GetInputDataSentence( wk->app_wk,  &pmsdata);

		// ʐM[N݂ĂȂ
		if(CommMPIsInitialize()){
			// r[Rf[^̊ȈՉb & ʐMf[^ɔf
//			CommMPSetMyPMS( &pmsdata );
//			CommMPFlashMyBss();
			Union_PMSReWrite( &pmsdata );							// r[Rf[^ɔf
			Union_SetMyPmsData( fsys->union_work, &pmsdata );		// jI[NŕۑĂʂɕ\
		}
		
	}
	
	//
//	sys_FreeMemoryEz( wk->app_wk );
	PMSI_PARAM_Delete( (PMSI_PARAM*)wk->app_wk );

	//tB[h}bvvZXA
	FieldEvent_Cmd_SetMapProc( fsys );
	wk->seq = FLD_MENU_SEQ_AGAIN;
}




//=============================================================================================
//=============================================================================================
//	TuAvFXe[^X
//=============================================================================================
//=============================================================================================
static void SubApp_PStatusWait( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	// TuvZXI҂
	if( FieldEvent_Cmd_WaitSubProcEnd( fsys ) ) {
		return;
	}

//	wk->app_wk = FieldPokeList_SetProc( fsys, 0 );
//	wk->seq = FLD_MENU_SEQ_POKEMON_WAIT;

	{
		PSTATUS_DATA * dat = sys_AllocMemory( HEAPID_WORLD, sizeof(PSTATUS_DATA) );

		memcpy( dat, wk->app_wk, sizeof(PSTATUS_DATA) );
		sys_FreeMemoryEz( wk->app_wk );

		switch( dat->mode ){
		case PST_MODE_WAZAADD:	// Zo/ZY
			{
				PLIST_DATA * pld;
				u32 * item;

				pld  = sys_AllocMemory( HEAPID_WORLD, sizeof(PLIST_DATA) );
				item = (u32 *)wk->tmp_wk;
				memset( pld, 0, sizeof(PLIST_DATA) );
				pld->pp     = SaveData_GetTemotiPokemon(fsys->savedata);
				pld->myitem = SaveData_GetMyItem( fsys->savedata );
				pld->type = PL_TYPE_SINGLE;
				pld->mode = PL_MODE_WAZASET_RET;
				pld->item = (u16)*item;
				pld->ret_sel = dat->pos;
				pld->waza = dat->waza;
				pld->waza_pos = dat->ret_sel;
				GameSystem_StartSubProc( fsys, &PokeListProcData, pld );
				sys_FreeMemoryEz( wk->tmp_wk );
				wk->app_wk = pld;
				wk->seq = FLD_MENU_SEQ_POKEMON_WAIT;
			}
			break;

		default:
			wk->app_wk = FieldPokeList_SetProc( fsys, dat->pos );
			wk->seq = FLD_MENU_SEQ_POKEMON_WAIT;
		}
		sys_FreeMemoryEz( dat );
	}
}


//=============================================================================================
//=============================================================================================
//	TuAvF؂̎^O
//=============================================================================================
//=============================================================================================
static void FldMenu_NutsTagCall( GMEVENT_CONTROL * event, u16 item )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;
	MYITEM * myitem;
	u8	i;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	wk->app_wk = NutsTagSystemDataAlloc( HEAPID_WORLD );
	myitem = SaveData_GetMyItem( fsys->savedata );
	NutsTagPutDataSet( wk->app_wk, item, TAG_ON );
	for( i=0; i<ITEM_NUTS_MAX; i++ ){
		item = NutsIDItemGet( i );
		if( MyItem_CheckItem( myitem, item, 1, HEAPID_WORLD ) == TRUE ){
			NutsTagPutDataSet( wk->app_wk, item, TAG_OFF );
		}
	}
	FieldNutsTag_SetProc( fsys, wk->app_wk );
	wk->seq = FLD_MENU_SEQ_NTAG_WAIT;
}

static void FldMenu_NutsTagWait( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	// TuvZXI҂
	if( FieldEvent_Cmd_WaitSubProcEnd( fsys ) ) {
		return;
	}

	sys_FreeMemory( HEAPID_WORLD, wk->app_wk );
	wk->app_wk = FieldBag_SetProc( fsys );
	wk->seq    = FLD_MENU_SEQ_BAG_WAIT;
}


//=============================================================================================
//=============================================================================================
//	TuAvF^E}bv
//=============================================================================================
//=============================================================================================
static void FldMenu_TownMapWait( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	// TuvZXI҂
	if( FieldEvent_Cmd_WaitSubProcEnd( fsys ) ) {
		return;
	}

	sys_FreeMemory( HEAPID_WORLD, wk->app_wk );
	wk->app_wk = FieldBag_SetProc( fsys );
	wk->seq    = FLD_MENU_SEQ_BAG_WAIT;
}


//=============================================================================================
//=============================================================================================
//	TuAvF`m[g
//=============================================================================================
//=============================================================================================
static void FldMenu_FantasyNoteWait( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	// TuvZXI҂
	if( FieldEvent_Cmd_WaitSubProcEnd( fsys ) ) {
		return;
	}

	wk->app_wk = FieldBag_SetProc( fsys );
	wk->seq    = FLD_MENU_SEQ_BAG_WAIT;
}


//=============================================================================================
//=============================================================================================
//	TuAvF[
//=============================================================================================
//=============================================================================================
static void FM_MailMakeTrue( FIELDSYS_WORK * fsys, FLD_MENU * wk, u8 list_mode );

static void FldMenu_MailWait( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	// TuvZXI҂
	if( FieldEvent_Cmd_WaitSubProcEnd( fsys ) ) {
		return;
	}

	{
		FM_MAIL_WORK * mw = wk->tmp_wk;

		switch( mw->mode ){
		case FM_MAIL_MODE_VIEW:		// [
			MailSys_ReleaseCallWork( wk->app_wk );
			wk->app_wk = FieldBag_SetProc( fsys );
			wk->seq    = FLD_MENU_SEQ_BAG_WAIT;
			break;

		case FM_MAIL_MODE_READ:		// [ǂ
			MailSys_ReleaseCallWork( wk->app_wk );
			wk->app_wk = FieldPokeList_SetProc( fsys, mw->pos );
			wk->seq = FLD_MENU_SEQ_POKEMON_WAIT;
			break;

		case FM_MAIL_MODE_MAKE_LIST:	// [i|PXgj
			if( MailSys_IsDataCleate( wk->app_wk ) == TRUE ){
				FM_MailMakeTrue( fsys, wk, PL_MODE_MAILSET_BAG );
			}else{
				MailSys_ReleaseCallWork( wk->app_wk );
				wk->app_wk = FieldPokeList_SetProc( fsys, mw->pos );
				wk->seq = FLD_MENU_SEQ_POKEMON_WAIT;
			}
			break;

		case FM_MAIL_MODE_MAKE_BAG:		// [iobOj
			if( MailSys_IsDataCleate( wk->app_wk ) == TRUE ){
				FM_MailMakeTrue( fsys, wk, PL_MODE_MAILSET );
			}else{
				MailSys_ReleaseCallWork( wk->app_wk );
				wk->app_wk = FieldBag_SetProc( fsys );
				wk->seq    = FLD_MENU_SEQ_BAG_WAIT;
			}
			break;
		}
		sys_FreeMemoryEz( wk->tmp_wk );
	}
}

void * FieldMenu_MailWorkMake( u16 item, u8 mode, u8 poke_pos )
{
	FM_MAIL_WORK * mw = sys_AllocMemory( HEAPID_WORLD, sizeof(FM_MAIL_WORK) );

	mw->item = item;
	mw->pos  = poke_pos;
	mw->mode = mode;
	return (void *)mw;
}

static void FM_MailMakeTrue( FIELDSYS_WORK * fsys, FLD_MENU * wk, u8 list_mode )
{
	FM_MAIL_WORK * mw;
	PLIST_DATA * pld;

	mw  = wk->tmp_wk;
	pld = sys_AllocMemory( HEAPID_WORLD, sizeof(PLIST_DATA) );
	memset( pld, 0, sizeof(PLIST_DATA) );
	pld->pp      = SaveData_GetTemotiPokemon(fsys->savedata);
	pld->myitem  = SaveData_GetMyItem( fsys->savedata );
	pld->type    = PL_TYPE_SINGLE;
	pld->item    = mw->item;
	pld->ret_sel = mw->pos;
	pld->mode    = list_mode;

	MailSys_PushDataToSavePoke( wk->app_wk, PokeParty_GetMemberPointer(pld->pp,mw->pos) );
	MailSys_ReleaseCallWork( wk->app_wk );

	GameSystem_StartSubProc( fsys, &PokeListProcData, pld );
	wk->app_wk = pld;
	wk->seq = FLD_MENU_SEQ_POKEMON_WAIT;
}



//=============================================================================================
//=============================================================================================
//	TuAvF|gP[X
//=============================================================================================
//=============================================================================================
static void FldMenu_PorutoCaseWait( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	// TuvZXI҂
	if( FieldEvent_Cmd_WaitSubProcEnd( fsys ) ) {
		return;
	}

	PorutoSys_ReleaseCallWork( wk->app_wk );

	wk->app_wk = FieldBag_SetProc( fsys );
	wk->seq    = FLD_MENU_SEQ_BAG_WAIT;
}


//=============================================================================================
//=============================================================================================
//=============================================================================================
//=============================================================================================
//=============================================================================================
//=============================================================================================
//	ݒ
//=============================================================================================
typedef struct {
	u8	talk_spd;
	u8	btl_eff;
	u8	btl_type;
	u8	win_type;
}CONFIG_DATA;

static CONFIG_DATA ConfigData;

#define	MSG_SPEED_SLOW		( 8 )
#define	MSG_SPEED_NORMAL	( 4 )
#define	MSG_SPEED_FAST		( 1 )

static u8 test_msg_speed = 0;

void MsgSpeedSet( u8 num )
{
	test_msg_speed = num;
}

u8 MsgSpeedGet(void)
{
	if( test_msg_speed == 0 ){
		return MSG_SPEED_SLOW;
	}else if( test_msg_speed == 1 ){
		return MSG_SPEED_NORMAL;
	}
	return MSG_SPEED_FAST;
/*
	if( ConfigData.talk_spd == 0 ){
		return MSG_SPEED_SLOW;
	}else if( ConfigData.talk_spd == 1 ){
		return MSG_SPEED_NORMAL;
	}
	return MSG_SPEED_FAST;
*/
//	return MSG_SPEED_NORMAL;
}

u8 TalkWinNumGet(void)
{
	return ConfigData.win_type;
}





