//******************************************************************************
/**
 * 
 * @file	fldeff_dbgornament.c
 * @brief	tB[hOBJ nzu
 * @author	k.ohno
 * @data	05.11.29
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "field_effect.h"
#include "fieldobj.h"
#include "fldeff_dbgornament.h"

//==============================================================================
//	define
//==============================================================================
//#define DEBUG_DBGORNAMENT_WRITE_OFF	//`Œnzu`OFF

//#define DBGORNAMENT_DRAW_Z_OFFSET (FX32_ONE*(3))
#define DBGORNAMENT_DRAW_Z_OFFSET (FX32_ONE*(5))			///<nzu`ItZbgZ

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	FE_DBGORNAMENT\
//--------------------------------------------------------------
typedef struct _TAG_FE_DBGORNAMENT
{
	int heap_id;
	FE_SYS_PTR fes;
	NNSG3dRenderObj render;
	NNSG3dResMdl *model;
	NNSG3dResFileHeader *res_file;
}FE_DBGORNAMENT;

#define FE_DBGORNAMENT_SIZE (sizeof(FE_DBGORNAMENT)) ///<FE_DBGORNAMENTTCY

//--------------------------------------------------------------
///	DBGORNAMENT_ADD_H\
//--------------------------------------------------------------
typedef struct
{
	int init_gx;
	int init_gz;
	FIELDSYS_WORK *fsys;
	FE_SYS_PTR fes;
	FE_DBGORNAMENT_PTR dbgornament;						///<FE_DBGORNAMENT_PTR
}DBGORNAMENT_ADD_H;

#define DBGORNAMENT_ADD_H_SIZE (sizeof(DBGORNAMENT_ADD_H)) ///<DBGORNAMENT_ADD_HTCY

//--------------------------------------------------------------
///	DBGORNAMENT_WORK\
//--------------------------------------------------------------
typedef struct
{
    int counter;    // 
	int obj_id;									///<nzuΏOBJID
	int zone_id;								///<nzuΏۃ][ID
	int vanish_sw;								///<\SW
	DBGORNAMENT_ADD_H head;							///<ǉDBGORNAMENT_ADD_H
}DBGORNAMENT_WORK;

#define DBGORNAMENT_WORK_SIZE (sizeof(DBGORNAMENT_WORK))	///<DBGORNAMENT_WORKTCY

//==============================================================================
//	vg^Cv
//==============================================================================
static FE_DBGORNAMENT_PTR DbgOrnament_AllocMemory( int heap_id );
static void DbgOrnament_FreeMemory( FE_DBGORNAMENT_PTR sd );

static void DbgOrnament_GraphicInit( FE_DBGORNAMENT_PTR sd );
static void DbgOrnament_GraphicDelete( FE_DBGORNAMENT_PTR sd );

static const EOA_H_NPP DATA_EoaH_DbgOrnament;

//==============================================================================
//	nzu@VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * nzu
 * @param	fes		FE_SYS_PTR
 * @param	heap_id	q[vID
 * @retval	FE_DBGORNAMENT_PTR	FE_DBGORNAMENT_PTR
 */
//--------------------------------------------------------------
FE_DBGORNAMENT_PTR FE_DbgOrnament_Init( FE_SYS_PTR fes, int heap_id )
{
	FE_DBGORNAMENT_PTR sd;

	sd = DbgOrnament_AllocMemory( heap_id );
	sd->heap_id = heap_id;
	sd->fes = fes;
	
	DbgOrnament_GraphicInit( sd );
	
	return( sd );
}

//--------------------------------------------------------------
/**
 * nzu폜
 * @param	sd		FE_DBGORNAMENT_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_DbgOrnament_Delete( FE_DBGORNAMENT_PTR sd )
{
	DbgOrnament_GraphicDelete( sd );
	DbgOrnament_FreeMemory( sd );
}

//==============================================================================
//	nzu	p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * nzum
 * @param	heap_id		q[vID
 * @retval	FE_DBGORNAMENT_PTR	mۂFE_DBGORNAMENT_PTR
 */
//--------------------------------------------------------------
static FE_DBGORNAMENT_PTR DbgOrnament_AllocMemory( int heap_id )
{
	FE_DBGORNAMENT_PTR sd;
	
	sd = sys_AllocMemory( heap_id, FE_DBGORNAMENT_SIZE );
	GF_ASSERT( sd != NULL && "DbgOrnament_AllocMemory()mێs" );
	
	memset( sd, 0, FE_DBGORNAMENT_SIZE );
	return( sd );
}

//--------------------------------------------------------------
/**
 * nzu폜
 * @param	sd	FE_DBGORNAMENT_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void DbgOrnament_FreeMemory( FE_DBGORNAMENT_PTR sd )
{
	sys_FreeMemory( sd->heap_id, sd );
}

//==============================================================================
//	nzu@OtBbN
//==============================================================================
//--------------------------------------------------------------
/**
 * nzu OtBbN
 * @param	sd	FE_DBGORNAMENT_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void DbgOrnament_GraphicInit( FE_DBGORNAMENT_PTR sd )
{
	NNS_G3dRenderObjInit( &sd->render, sd->model );
	simple_3DModelSet( sd->heap_id, "data/dummy_s_hole.nsbmd",
                       &sd->render, &sd->model, &sd->res_file );
}

//--------------------------------------------------------------
/**
 * nzu OtBbN폜
 * @param	sd	FE_DBGORNAMENT_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void DbgOrnament_GraphicDelete( FE_DBGORNAMENT_PTR sd )
{
    sys_FreeMemory( sd->heap_id, sd->res_file );
}

//==============================================================================
//	nzu@EOA
//==============================================================================
//--------------------------------------------------------------
/**
 * nzuǉ
 * @param	fldobj		FIELD_OBJ_PTR
 * @retval	EOA_PTR
 */
//--------------------------------------------------------------
EOA_PTR FE_DbgOrnament_Add(  FIELDSYS_WORK *fsys, int x, int z, int liveTime )
{
	int param,pri;
	DBGORNAMENT_ADD_H head;
	FE_SYS_PTR fes;
	VecFx32 mtx;
    EOA_PTR eoa;
	DBGORNAMENT_WORK *work;
	
    fes = fsys->fes;
	head.fes = fes;
	head.dbgornament = FE_DbgOrnamentPtrGet( fes );
	head.init_gx = x;
	head.init_gz = z;
	head.fsys = fsys;
	mtx.x = GRID_SIZE_FX32( x ) + (FX32_ONE * 9 );
	mtx.y = 0;
	mtx.z = GRID_SIZE_FX32( z );
	param = 0;
	eoa = FE_EoaAddNpp( fes, &DATA_EoaH_DbgOrnament, &mtx, param, &head, 0xff );
	work = EOA_LocalWorkGet( eoa );
    work->counter = liveTime;
    return eoa;
}

//--------------------------------------------------------------
/**
 * EOA nzu@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	int		TRUE=IBFALSE=ُI
 */
//--------------------------------------------------------------
static int EoaDbgOrnament_Init( EOA_PTR eoa, void *wk )
{
	DBGORNAMENT_WORK *work;
	const DBGORNAMENT_ADD_H *head;
    VecFx32 vec;
	
	work = wk;
	head = EOA_AddPtrGet( eoa );
	work->head = *head;

	vec.x = GRID_SIZE_FX32( work->head.init_gx ) + (FX32_ONE * 9 );
	vec.z = GRID_SIZE_FX32( work->head.init_gz );
    vec.y = 0;
    
	EOA_MatrixSet( eoa, &vec );

    work->counter = 20;// @@OO test time
    
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * EOA nzu@폜
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaDbgOrnament_Delete( EOA_PTR eoa, void *wk )
{
}

//--------------------------------------------------------------
/**
 * EOA nzu@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaDbgOrnament_Move( EOA_PTR eoa, void *wk )
{
    DBGORNAMENT_WORK *work;
	work = wk;

    if(work->counter > 0){
        work->counter--;
        if(work->counter == 0){
            EOA_Delete( eoa );
        }
    }
}

//--------------------------------------------------------------
/**
 * EOA nzu@`
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaDbgOrnament_Draw( EOA_PTR eoa, void *wk )
{
	DBGORNAMENT_WORK *work;
	
	work = wk;
	
    {
		VecFx32 vec;
		VecFx32 scale = { FX32_ONE, FX32_ONE, FX32_ONE };
		MtxFx33 rot	  = { FX32_ONE, 0,0,0, FX32_ONE, 0,0,0,FX32_ONE};
		
		EOA_MatrixGet( eoa, &vec );
		
		vec.x += -(FX32_ONE * 1) / 2;
		vec.y += -(FX32_ONE * 1);
		vec.z += DBGORNAMENT_DRAW_Z_OFFSET;

        {    // Jts
            const MtxFx43* pCamInv = NNS_G3dGlbGetInvCameraMtx();
            MtxFx33 Mat33;
            
            Rot360_to_MtxFx33(&rot, 90, 0, 0);
            MTX_Copy43To33(pCamInv, &Mat33);
            MTX_Concat33(&rot, &Mat33, &rot);
        }

        simple_3DModelDraw_1mat1shape( &work->head.dbgornament->render, &vec, &rot, &scale );
	}
}

//--------------------------------------------------------------
///	nzuEOA_H
//--------------------------------------------------------------
static const EOA_H_NPP DATA_EoaH_DbgOrnament =
{
	DBGORNAMENT_WORK_SIZE,
	EoaDbgOrnament_Init,
	EoaDbgOrnament_Delete,
	EoaDbgOrnament_Move,
	EoaDbgOrnament_Draw,
};

