//******************************************************************************
/**
 * 
 * @file	fldeff_exclamation.c
 * @brief	ꖇ|S np I}[N
 * @author	k.ohno
 * @data	05.02.13
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "field_effect.h"
#include "fieldobj.h"
#include "fldeff_exclamation.h"

//==============================================================================
//	define
//==============================================================================

#define EXCLAMATION_FLDOBJ_Y_MOVE_START ((FX32_ONE*6))				///<
#define EXCLAMATION_FLDOBJ_Y_OFFSET ((FX32_ONE*25))				///<tB[hOBJYItZbg
#define EXCLAMATION_FLDOBJ_Z_OFFSET ((FX32_ONE*-10))					///<tB[hOBJZItZbg
#define EXCLAMATION_END_FRAME (30)									///<It[	

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	FE_EXCLAMATION\
//--------------------------------------------------------------
typedef struct _TAG_FE_EXCLAMATION
{
	int heap_id;
	int add_count;
	int draw_init;
	FE_SYS_PTR fes;
	NNSG3dRenderObj render;
	NNSG3dResMdl *model;
	NNSG3dResFileHeader *res_file;
	FIELD_OBJ_PTR fldobj;						///<̑ΏFIELD_OBJ_PTR
}FE_EXCLAMATION;

#define FE_EXCLAMATION_SIZE (sizeof(FE_EXCLAMATION)) ///<FE_EXCLAMATIONTCY

//--------------------------------------------------------------
///	EXCLAMATION_ADD_H\
//--------------------------------------------------------------
typedef struct
{
	FE_SYS_PTR fes;
	FE_EXCLAMATION_PTR exclamation;						///<FE_EXCLAMATION_PTR
	FIELD_OBJ_PTR fldobj;						///<̑ΏFIELD_OBJ_PTR
}EXCLAMATION_ADD_H;

#define EXCLAMATION_ADD_H_SIZE (sizeof(EXCLAMATION_ADD_H)) ///<EXCLAMATION_ADD_HTCY

//--------------------------------------------------------------
///	EXCLAMATION_WORK\
//--------------------------------------------------------------
typedef struct
{
	int seq_no;									///<ԍ
	int frame;									///<t[
	int obj_id;									///<ΏOBJID
	int zone_id;								///<Ώۃ][ID
	int vanish_sw;								///<\SW
	int end_sw;									///<ISW
	VecFx32 offset;								///<ItZbg
	VecFx32 move;								///<ړ
	EXCLAMATION_ADD_H head;							///<ǉEXCLAMATION_ADD_H
}EXCLAMATION_WORK;

#define EXCLAMATION_WORK_SIZE (sizeof(EXCLAMATION_WORK))	///<EXCLAMATION_WORKTCY

//==============================================================================
//	vg^Cv
//==============================================================================
static FE_EXCLAMATION_PTR Exclamation_AllocMemory( int heap_id );
static void Exclamation_FreeMemory( FE_EXCLAMATION_PTR sd );

static void Exclamation_GraphicInit( FE_EXCLAMATION_PTR sd );
static void Exclamation_GraphicDelete( FE_EXCLAMATION_PTR sd );

static const EOA_H_NPP DATA_EoaH_Exclamation;

//==============================================================================
//	@VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * 
 * @param	fes		FE_SYS_PTR
 * @param	heap_id	q[vID
 * @retval	FE_EXCLAMATION_PTR	FE_EXCLAMATION_PTR
 */
//--------------------------------------------------------------
FE_EXCLAMATION_PTR FE_Exclamation_Init( FE_SYS_PTR fes, int heap_id )
{
	FE_EXCLAMATION_PTR sd;

	sd = Exclamation_AllocMemory( heap_id );
	sd->heap_id = heap_id;
	sd->fes = fes;
	
	Exclamation_GraphicInit( sd );
	
	return( sd );
}

//--------------------------------------------------------------
/**
 * 폜
 * @param	sd		FE_EXCLAMATION_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_Exclamation_Delete( FE_EXCLAMATION_PTR sd )
{
	Exclamation_GraphicDelete( sd );
	Exclamation_FreeMemory( sd );
}

//==============================================================================
//		p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * m
 * @param	heap_id		q[vID
 * @retval	FE_EXCLAMATION_PTR	mۂFE_EXCLAMATION_PTR
 */
//--------------------------------------------------------------
static FE_EXCLAMATION_PTR Exclamation_AllocMemory( int heap_id )
{
	FE_EXCLAMATION_PTR sd;
	
	sd = sys_AllocMemory( heap_id, FE_EXCLAMATION_SIZE );
	GF_ASSERT( sd != NULL && "Exclamation_AllocMemory()mێs" );
	
	memset( sd, 0, FE_EXCLAMATION_SIZE );
	return( sd );
}

//--------------------------------------------------------------
/**
 * 폜
 * @param	sd	FE_EXCLAMATION_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Exclamation_FreeMemory( FE_EXCLAMATION_PTR sd )
{
	sys_FreeMemory( sd->heap_id, sd );
}

//==============================================================================
//	@OtBbN
//==============================================================================
//--------------------------------------------------------------
/**
 *  OtBbN
 * @param	sd	FE_EXCLAMATION_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Exclamation_GraphicInit( FE_EXCLAMATION_PTR sd )
{
	NNS_G3dRenderObjInit( &sd->render, sd->model );
	simple_3DModelSet( sd->heap_id, "data/ug_exclamation.nsbmd",
                       &sd->render, &sd->model, &sd->res_file );
}

//--------------------------------------------------------------
/**
 *  OtBbN폜
 * @param	sd	FE_EXCLAMATION_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Exclamation_GraphicDelete( FE_EXCLAMATION_PTR sd )
{
    sys_FreeMemory( sd->heap_id, sd->res_file );
}

//==============================================================================
//	@EOA
//==============================================================================
//--------------------------------------------------------------
/**
 * gbvǉ
 * @param	fldobj		FIELD_OBJ_PTR
 * @retval	EOA_PTR
 */
//--------------------------------------------------------------
EOA_PTR FE_Exclamation_Add(  FIELD_OBJ_PTR fldobj )
{
	int param,pri;
	EXCLAMATION_ADD_H head;
	FE_SYS_PTR fes;
	VecFx32 mtx;
    EOA_PTR eoa;
	EXCLAMATION_WORK *work;
	
	fes = FE_FieldOBJ_FE_SYS_PTR_Get( fldobj );
	head.fes = fes;
	head.exclamation = FE_ExclamationPtrGet( fes );
	head.fldobj = fldobj;

    FieldOBJ_VecPosGet( fldobj, &mtx );
	param = 0;

	eoa = FE_EoaAddNpp( fes, &DATA_EoaH_Exclamation, &mtx, param, &head, 0xff );
    return eoa;
}

//--------------------------------------------------------------
/**
 * EOA @
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	int		TRUE=IBFALSE=ُI
 */
//--------------------------------------------------------------
static int EoaExclamation_Init( EOA_PTR eoa, void *wk )
{
	EXCLAMATION_WORK *work;
	const EXCLAMATION_ADD_H *head;
    VecFx32 vec;
	
	work = wk;
	head = EOA_AddPtrGet( eoa );
	work->head = *head;

	work->obj_id = FieldOBJ_OBJIDGet( work->head.fldobj );
	work->zone_id = FieldOBJ_ZoneIDGet( work->head.fldobj );
	work->move.y = EXCLAMATION_FLDOBJ_Y_MOVE_START;

    FieldOBJ_VecPosGet( work->head.fldobj, &vec );

    EOA_MatrixSet( eoa, &vec );

    
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * EOA @폜
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaExclamation_Delete( EOA_PTR eoa, void *wk )
{
}

//--------------------------------------------------------------
/**
 * EOA @
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaExclamation_Move( EOA_PTR eoa, void *wk )
{
	EXCLAMATION_WORK *work;
	FIELD_OBJ_PTR fldobj;
	VecFx32 vec;
	
	work = wk;
    fldobj = work->head.fldobj;
	
	GF_ASSERT( FE_FldOBJ_CheckSameID(fldobj,work->obj_id,work->zone_id) != FALSE &&
		"쒆ɑΏۂ̃tB[hOBJ폜܂" );
	
    FieldOBJ_VecPosGet( fldobj, &vec );
    vec.z += EXCLAMATION_FLDOBJ_Z_OFFSET;
    EOA_MatrixSet( eoa, &vec );

}

//--------------------------------------------------------------
/**
 * EOA @`
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaExclamation_Draw( EOA_PTR eoa, void *wk )
{
	EXCLAMATION_WORK *work;
	
	work = wk;
	
    {
		VecFx32 vec;
		VecFx32 scale = { FX32_ONE, FX32_ONE, FX32_ONE };
		MtxFx33 rot	  = { FX32_ONE, 0,0,0, FX32_ONE, 0,0,0,FX32_ONE};
		
		EOA_MatrixGet( eoa, &vec );
		
		vec.y += EXCLAMATION_FLDOBJ_Y_OFFSET;
        vec.z += - (FX32_ONE*5);

        {    // Jts
            const MtxFx43* pCamInv = NNS_G3dGlbGetInvCameraMtx();
            MtxFx33 Mat33;
            
            Rot360_to_MtxFx33(&rot, 90, 0, 0);
            MTX_Copy43To33(pCamInv, &Mat33);
            MTX_Concat33(&rot, &Mat33, &rot);
        }
        simple_3DModelDraw_1mat1shape( &work->head.exclamation->render, &vec, &rot, &scale );
	}
}

//--------------------------------------------------------------
///	EOA_H
//--------------------------------------------------------------
static const EOA_H_NPP DATA_EoaH_Exclamation =
{
	EXCLAMATION_WORK_SIZE,
	EoaExclamation_Init,
	EoaExclamation_Delete,
	EoaExclamation_Move,
	EoaExclamation_Draw,
};

