//******************************************************************************
/**
 * 
 * @file	fldeff_footmark.c
 * @brief	tB[hOBJ
 * @author	kagaya
 * @data	05.07.13
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "field_effect.h"
#include "fieldobj.h"
#include "fldeff_footmark.h"

//==============================================================================
//	define
//==============================================================================
#define FOOTMARK_VANISH_START_FRAME (20)						///<_ŊJnt[(ԗ40)
#define FOOTMARK_VANISH_END_FRAME (28)							///<_ŏIt[(ԗ56)

//--------------------------------------------------------------
///	Վ
//--------------------------------------------------------------
enum
{
	FOOTMARK_WALK_UP = 0,										///<Ձ@
	FOOTMARK_WALK_DOWN,											///<Ձ@
	FOOTMARK_WALK_LEFT,											///<Ձ@
	FOOTMARK_WALK_RIGHT,										///<Ձ@E
	FOOTMARK_CYCLE_UD,											///<]ԑ ㉺
	FOOTMARK_CYCLE_LR,											///<]ԑ E
	FOOTMARK_CYCLE_UL,											///<]ԑ ㍶
	FOOTMARK_CYCLE_UR,											///<]ԑ E
	FOOTMARK_CYCLE_DL,											///<]ԑ 
	FOOTMARK_CYCLE_DR,											///<]ԑ E
	FOOTMARK_MAX,												///<Սő吔
};

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	FE_FOOTMARK\
//--------------------------------------------------------------
typedef struct _TAG_FE_FOOTMARK
{
	int heap_id;
	FE_SYS_PTR fes;
	NNSG3dRenderObj render[FOOTMARK_MAX];
	NNSG3dResMdl *model[FOOTMARK_MAX];
	NNSG3dResFileHeader *res_file[FOOTMARK_MAX];
}FE_FOOTMARK;

#define FE_FOOTMARK_SIZE (sizeof(FE_FOOTMARK)) ///<FE_FOOTMARKTCY

//--------------------------------------------------------------
///	FOOTMARK_ADD_H\
//--------------------------------------------------------------
typedef struct
{
	NNSG3dRenderObj render;
	NNSG3dResMdl *model;
}FOOTMARK_ADD_H;

//--------------------------------------------------------------
///	FOOTMARK_WORK\
//--------------------------------------------------------------
typedef struct
{
	int seq_no;
	int type;
	int frame;
	int vanish_sw;
	int alpha;
	NNSG3dRenderObj render;
	NNSG3dResMdl *model;
}FOOTMARK_WORK;

#define FOOTMARK_WORK_SIZE (sizeof(FOOTMARK_WORK))

//==============================================================================
//	vg^Cv
//==============================================================================
static FE_FOOTMARK_PTR FootMark_AllocMemory( int heap_id );
static void FootMark_FreeMemory( FE_FOOTMARK_PTR fm );

static void FootMark_GraphicInit( FE_FOOTMARK_PTR fm );
static void FootMark_GraphicDelete( FE_FOOTMARK_PTR fm );
static NNSG3dRenderObj FootMark_TypeRenderGet(
		FE_FOOTMARK_PTR fm, int type, int now_dir, int old_dir );
static NNSG3dResMdl * FootMark_TypeMdlGet(
		FE_FOOTMARK_PTR fm, int type, int now_dir, int old_dir );

static const char * const DATA_3DModelFile_FootMark[FOOTMARK_MAX];
static const int DATA_FootMarkCycleDirTbl[DIR_4_MAX][DIR_4_MAX];
static const EOA_H_NPP DATA_EoaH_FootMark;

//==============================================================================
//	Ձ@VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * Տ
 * @param	fes		FE_SYS_PTR
 * @param	heap_id	q[vID
 * @retval	FE_FOOTMARK_PTR		FE_FOOTMARK_PTR
 */
//--------------------------------------------------------------
FE_FOOTMARK_PTR FE_FootMark_Init( FE_SYS_PTR fes, int heap_id )
{
	FE_FOOTMARK_PTR fm;
	
	fm = FootMark_AllocMemory( heap_id );
	fm->heap_id = heap_id;
	fm->fes = fes;
	
	FootMark_GraphicInit( fm );
	
	return( fm );
}

//--------------------------------------------------------------
/**
 * Ս폜
 * @param	fm		FE_FOOTMARK_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_FootMark_Delete( FE_FOOTMARK_PTR fm )
{
	FootMark_GraphicDelete( fm );
	FootMark_FreeMemory( fm );
}

//==============================================================================
//		p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * Ճm
 * @param	heap_id		q[vID
 * @retval	FE_FOOTMARK_PTR	mۂFE_FOOTMARK_PTR
 */
//--------------------------------------------------------------
static FE_FOOTMARK_PTR FootMark_AllocMemory( int heap_id )
{
	FE_FOOTMARK_PTR fm;
	
	fm = sys_AllocMemory( heap_id, FE_FOOTMARK_SIZE );
	GF_ASSERT( fm != NULL && "FootMark_AllocMemory()mێs" );
	
	memset( fm, 0, FE_FOOTMARK_SIZE );
	return( fm );
}

//--------------------------------------------------------------
/**
 * Ճ폜
 * @param	sd	FE_FOOTMARK_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FootMark_FreeMemory( FE_FOOTMARK_PTR fm )
{
	sys_FreeMemory( fm->heap_id, fm );
}

//==============================================================================
//	Ձ@OtBbN
//==============================================================================
//--------------------------------------------------------------
/**
 *  OtBbN
 * @param	fm		FE_FOOTMARK_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FootMark_GraphicInit( FE_FOOTMARK_PTR fm )
{
	int i;
	const char *path;
	
	for( i = 0; i < FOOTMARK_MAX; i++ ){
//		NNS_G3dRenderObjInit( &fm->render[i], fm->model[i] );
		
		path = DATA_3DModelFile_FootMark[i];
		simple_3DModelSet( fm->heap_id, path, &fm->render[i], &fm->model[i], &fm->res_file[i] );
	}
}

//--------------------------------------------------------------
/**
 * Ձ@OtBbN
 * @param	fm		FE_FOOTMARK_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FootMark_GraphicDelete( FE_FOOTMARK_PTR fm )
{
	int i;
	
	for( i = 0; i < FOOTMARK_MAX; i++ ){
		sys_FreeMemory( fm->heap_id, fm->res_file[i] );
	}
}

//--------------------------------------------------------------
/**
 * w^Cṽ_擾
 * @param	fm		FE_FOOTMARK_PTR
 * @param	type	FOOTMARK_TYPE_NORMAL
 * @param	now_dir	݂̌ DIR_UP
 * @param	old_dir	ߋ̌ DIR_UP
 * @retval	NNSG3dRenderObj w̃_
 */
//--------------------------------------------------------------
static NNSG3dRenderObj FootMark_TypeRenderGet(
		FE_FOOTMARK_PTR fm, int type, int now_dir, int old_dir )
{
	int no;
	NNSG3dRenderObj render;
	
	no = 0;
	
	switch( type ){
	case FOOTMARK_TYPE_NORMAL:
		no = FOOTMARK_WALK_UP + now_dir;
		break;
	case FOOTMARK_TYPE_CYCLE:
		no = DATA_FootMarkCycleDirTbl[old_dir][now_dir];
		break;
	}
	
	GF_ASSERT( no < FOOTMARK_MAX && "FootMark_TypeRenderGet()s\n" );
	
	render = fm->render[no];
	return( render );
}

//--------------------------------------------------------------
/**
 * w^Cṽf擾
 * @param	fm		FE_FOOTMARK_PTR
 * @param	type	FOOTMARK_TYPE_NORMAL
 * @param	now_dir	݂̌ DIR_UP
 * @param	old_dir	ߋ̌ DIR_UP
 * @retval	NNSG3dMdl w̃_
 */
//--------------------------------------------------------------
static NNSG3dResMdl * FootMark_TypeMdlGet(
		FE_FOOTMARK_PTR fm, int type, int now_dir, int old_dir )
{
	int no;
	NNSG3dResMdl *model;
	
	no = 0;
	
	switch( type ){
	case FOOTMARK_TYPE_NORMAL:
		no = FOOTMARK_WALK_UP + now_dir;
		break;
	case FOOTMARK_TYPE_CYCLE:
		no = DATA_FootMarkCycleDirTbl[old_dir][now_dir];
		break;
	}
	
	GF_ASSERT( no < FOOTMARK_MAX && "FootMark_TypeMdlGet()s\n" );
	
	model = fm->model[no];
	return( model );
}

//==============================================================================
//	Ձ@EOA
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hOBJՒǉ
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	eoa		EOA_PTR
 */
//--------------------------------------------------------------
EOA_PTR FE_FldOBJFootMark_Add( FIELD_OBJ_PTR fldobj )
{
	int type,now_dir;
	EOA_PTR eoa;
	FE_SYS_PTR fes;
	FE_FOOTMARK_PTR fm;
	FOOTMARK_ADD_H head;
	
	fes = FE_FieldOBJ_FE_SYS_PTR_Get( fldobj );
	fm = FE_FootMarkPtrGet( fes );
	
	type = FOOTMARK_TYPE_NORMAL;
	
	if( FieldOBJ_OBJCodeGet(fldobj) == CYCLEHERO ){	//
		type = FOOTMARK_TYPE_CYCLE;
	}
	
	now_dir = FieldOBJ_DirDispGet( fldobj );
	
	{
		int old_dir = FieldOBJ_DirDispOldGet( fldobj );
		head.render = FootMark_TypeRenderGet( fm, type, now_dir, old_dir );
		head.model = FootMark_TypeMdlGet( fm, type, now_dir, old_dir );
	}
	
	{
		VecFx32 vec;
		FIELDSYS_WORK *fsys = FieldOBJ_FieldSysWorkGet( fldobj );
		int pri = FE_FldOBJ_TCBPriGet( fldobj, 1 );
		int x = FieldOBJ_OldPosGX_Get( fldobj );
//		int y = FieldOBJ_OldPosGY_Get( fldobj );
		int z = FieldOBJ_OldPosGZ_Get( fldobj );
		vec.x = GRID_SIZE_FX32( x ) + FLDOBJ_VEC_X_GRID_OFFS_FX32;
		vec.z = GRID_SIZE_FX32( z ) + FLDOBJ_VEC_Z_GRID_OFFS_FX32;
		
		vec.y = FieldOBJ_VecPosYGet( fldobj );
		
		if( now_dir == DIR_LEFT || now_dir == DIR_RIGHT ){
//			vec.z += FX32_ONE * 4;
		}
		
		if( FieldOBJTool_GetHeight(fsys,&vec) == FALSE ){
			vec.y = 0;
		}else{
			vec.y += 0;
		}
		
		eoa = FE_EoaAddNpp( fes, &DATA_EoaH_FootMark, &vec, type, &head, pri );
	}
	
	return( eoa );
}

//--------------------------------------------------------------
/**
 * EOA Ձ@
 * @param	eoa	EOA_PTR
 * @param	wk	eoa work *
 * @retval	int TRUE=IBFALSE=ُI
 */
//--------------------------------------------------------------
static int EoaFootMark_Init( EOA_PTR eoa, void *wk )
{
	FOOTMARK_WORK *work;
	const FOOTMARK_ADD_H *head;
	
	work = wk;
	work->type = EOA_AddParamGet( eoa );
	
	head = EOA_AddPtrGet( eoa );
	work->render = head->render;
	work->model = head->model;
	work->alpha = 31;
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * EOA Ձ@폜
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaFootMark_Delete( EOA_PTR eoa, void *wk )
{
}

//--------------------------------------------------------------
/**
 * EOA Ձ@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaFootMark_Move( EOA_PTR eoa, void *wk )
{
	FOOTMARK_WORK *work;
	
	work = wk;
	
	switch( work->seq_no ){
	case 0:
		work->frame++;
		
		if( work->frame >= FOOTMARK_VANISH_START_FRAME ){
			work->seq_no++;
		}
		
		break;
	case 1:
		work->alpha -= 1;
		
		if( work->alpha < 0 ){
			EOA_Delete( eoa );
			return;
		}
	}
}

//--------------------------------------------------------------
/**
 * EOA Ձ@`
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaFootMark_Draw( EOA_PTR eoa, void *wk )
{
	FOOTMARK_WORK *work;
	
	work = wk;
	
	if( work->vanish_sw == TRUE ){
		return;
	}
	
	{
		VecFx32 vec;
		VecFx32 scale = { FX32_ONE, FX32_ONE, FX32_ONE };
		MtxFx33 rot	  = { FX32_ONE, 0,0,0, FX32_ONE, 0,0,0,FX32_ONE};
		
		EOA_MatrixGet( eoa, &vec );
		
		NNS_G3dMdlUseMdlAlpha( work->model );
		NNS_G3dMdlSetMdlAlphaAll( work->model, work->alpha );
		simple_3DModelDraw( &work->render, &vec, &rot, &scale );
	}
}

//==============================================================================
//	data
//==============================================================================
//--------------------------------------------------------------
///	imde[u@тFOOTMARK_WALK_UP̒lɈv
//--------------------------------------------------------------
static const char * const DATA_3DModelFile_FootMark[FOOTMARK_MAX] =
{
	"data/f_mark_u.nsbmd",
	"data/f_mark_d.nsbmd",
	"data/f_mark_l.nsbmd",
	"data/f_mark_r.nsbmd",
	"data/c_mark_u.nsbmd",
	"data/c_mark_l.nsbmd",
	"data/c_mark_ul.nsbmd",
	"data/c_mark_ur.nsbmd",
	"data/c_mark_dl.nsbmd",
	"data/c_mark_dr.nsbmd",
};

//--------------------------------------------------------------
///	]ԑՃe[u [ߋ][ݕ]
//--------------------------------------------------------------
static const int DATA_FootMarkCycleDirTbl[DIR_4_MAX][DIR_4_MAX] =
{
	{FOOTMARK_CYCLE_UD,FOOTMARK_CYCLE_UD,FOOTMARK_CYCLE_UR,FOOTMARK_CYCLE_UL},
	{FOOTMARK_CYCLE_UD,FOOTMARK_CYCLE_UD,FOOTMARK_CYCLE_DR,FOOTMARK_CYCLE_DL},
	{FOOTMARK_CYCLE_DL,FOOTMARK_CYCLE_UL,FOOTMARK_CYCLE_LR,FOOTMARK_CYCLE_LR},
	{FOOTMARK_CYCLE_DR,FOOTMARK_CYCLE_UR,FOOTMARK_CYCLE_LR,FOOTMARK_CYCLE_LR},
};

//--------------------------------------------------------------
///	EOA_H
//--------------------------------------------------------------
static const EOA_H_NPP DATA_EoaH_FootMark =
{
	FOOTMARK_WORK_SIZE,
	EoaFootMark_Init,
	EoaFootMark_Delete,
	EoaFootMark_Move,
	EoaFootMark_Draw,
};

/*
f̒lQƂ悤ɂȂ
void NNS_G3dMdlUseMdlDiff(NNSG3dResMdl* pMdl);
void NNS_G3dMdlUseMdlAmb(NNSG3dResMdl* pMdl);
void NNS_G3dMdlUseMdlSpec(NNSG3dResMdl* pMdl);
void NNS_G3dMdlUseMdlEmi(NNSG3dResMdl* pMdl);
void NNS_G3dMdlUseMdlLightEnableFlag(NNSG3dResMdl* pMdl);
void NNS_G3dMdlUseMdlPolygonMode(NNSG3dResMdl* pMdl);
void NNS_G3dMdlUseMdlCullMode(NNSG3dResMdl* pMdl);
void NNS_G3dMdlUseMdlPolygonID(NNSG3dResMdl* pMdl);

void NNS_G3dMdlUseMdlAlpha(NNSG3dResMdl* pMdl);

void NNS_G3dMdlUseMdlFogEnableFlag(NNSG3dResMdl* pMdl);
void NNS_G3dMdlUseMdlDepthTestCond(NNSG3dResMdl* pMdl);
void NNS_G3dMdlUseMdl1Dot(NNSG3dResMdl* pMdl);
void NNS_G3dMdlUseMdlFarClip(NNSG3dResMdl* pMdl);
void NNS_G3dMdlUseMdlXLDepthUpdate(NNSG3dResMdl* pMdl);

f̒lύX
void NNS_G3dMdlSetMdlDiffAll(NNSG3dResMdl* pMdl, GXRgb col);
void NNS_G3dMdlSetMdlAmbAll(NNSG3dResMdl* pMdl, GXRgb col);
void NNS_G3dMdlSetMdlSpecAll(NNSG3dResMdl* pMdl, GXRgb col);
void NNS_G3dMdlSetMdlEmiAll(NNSG3dResMdl* pMdl, GXRgb col);
void NNS_G3dMdlSetMdlLightEnableFlagAll(NNSG3dResMdl* pMdl, int light);
void NNS_G3dMdlSetMdlPolygonModeAll(NNSG3dResMdl* pMdl, GXPolygonMode polyMode);
void NNS_G3dMdlSetMdlCullModeAll(NNSG3dResMdl* pMdl, GXCull cullMode);
void NNS_G3dMdlSetMdlPolygonIDAll(NNSG3dResMdl* pMdl, int polygonID);
void NNS_G3dMdlSetMdlAlphaAll(NNSG3dResMdl* pMdl, int alpha);
void NNS_G3dMdlSetMdlFogEnableFlagAll(NNSG3dResMdl* pMdl, BOOL flag);
void NNS_G3dMdlSetMdlDepthTestCondAll(NNSG3dResMdl* pMdl, BOOL flag);
void NNS_G3dMdlSetMdl1DotAll(NNSG3dResMdl* pMdl, BOOL flag);
void NNS_G3dMdlSetMdlFarClipAll(NNSG3dResMdl* pMdl, BOOL flag);
void NNS_G3dMdlSetMdlXLDepthUpdateAll(NNSG3dResMdl* pMdl, BOOL flag);
*/
