//******************************************************************************
/**
 * 
 * @file	fldeff_grass.c
 * @brief	tB[hOBJ
 * @author	kagaya
 * @data	05.07.13
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "field_effect.h"
#include "fieldobj.h"

#include "fldeff_grass.h"
#include "map_tool.h"

//==============================================================================
//	define
//==============================================================================
///\ʒu@Obh̃ItZbgX
#define GRASS_GIRD_VEC_OFFS_X (FLDOBJ_VEC_X_GRID_OFFS_FX32);
///\ʒu@Obh̃ItZbgZ
//#define GRASS_GIRD_VEC_OFFS_Z (FLDOBJ_VEC_Z_GRID_OFFS_FX32+FLDOBJ_BLACT_Z_GROUND_OFFS_FX32);
#define GRASS_GIRD_VEC_OFFS_Z \
	(FLDOBJ_VEC_Z_GRID_OFFS_FX32+FLDOBJ_BLACT_Z_GROUND_OFFS_FX32+(FX32_ONE*4));
///\ʒu@nʂ̃ItZbgY
#define GRASS_GROUND_OFFS_Y (FX32_ONE)

///hAjt[
#define GRASS_SHAKE_FRAME (12)

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	FE_GRASS\
//--------------------------------------------------------------
typedef struct _TAG_FE_GRASS
{
	int heap_id;
	FE_SYS_PTR fes;
}FE_GRASS;

#define FE_GRASS_SIZE (sizeof(FE_GRASS))	///<FE_GRASSTCY

//--------------------------------------------------------------
///	GRASS_ADD_H\
//--------------------------------------------------------------
typedef struct
{
	int init_gx;								///<X Obh
	int init_gy;								///<Y
	int init_gz;								///<Z
	FIELDSYS_WORK *fsys;						///<FIELDSYS_WORK *
	FE_SYS_PTR fes;								///<FE_SYS_PTR
	FE_GRASS_PTR kusa;							///<FE_GRASS_PTR
	FIELD_OBJ_PTR fldobj;						///<ΏۂFIELD_OBJ_PTR
}GRASS_ADD_H;

#define GRASS_ADD_H_SIZE (sizeof(GRASS_ADD_H))	///<GRASS_ADD_HTCY

//--------------------------------------------------------------
///	GRASS_WORK\
//--------------------------------------------------------------
typedef struct
{
	int seq_no;									///<ԍ
	int obj_id;									///<ΏۃtB[hOBJ OBJ ID
	int zone_id;								///<ΏۃtB[hOBJ ZONE ID
	int frame;									///<t[
	GRASS_ADD_H head;							///<ǉGRASS_ADD_H
	BLACT_WORK_PTR act;							///<r{[hAN^[
}GRASS_WORK;

#define GRASS_WORK_SIZE (sizeof(GRASS_WORK))	///<GRASS_WORKTCY

//==============================================================================
//	vg^Cv
//==============================================================================
static FE_GRASS_PTR Grass_AllocMemory( int heap_id );
static void Grass_FreeMemory( FE_GRASS_PTR kusa );

static void Grass_GraphicInit( FE_GRASS_PTR grass );
static void Grass_GraphicDelete( FE_GRASS_PTR grass );

static const EOA_H_NPP DATA_EoaH_Grass;
const BLACT_ANIME_TBL DATA_BlActAnmTbl_Grass[];

//==============================================================================
//		VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * 
 * @param	fes		FE_SYS_PTR
 * @param	heap_id	q[vID
 * @retval	FE_GRASS_PTR	FE_GRASS_PTR
 */
//--------------------------------------------------------------
FE_GRASS_PTR FE_Grass_Init( FE_SYS_PTR fes, int heap_id )
{
	FE_GRASS_PTR kusa;
	
	kusa = Grass_AllocMemory( heap_id );
	kusa->heap_id = heap_id;
	kusa->fes = fes;
	
	Grass_GraphicInit( kusa );
	
	return( kusa );
}

//--------------------------------------------------------------
/**
 * 폜
 * @param	kusa		FE_GRASS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_Grass_Delete( FE_GRASS_PTR kusa )
{
	FE_SYS_PTR fes;
	
	fes = kusa->fes;
	
	Grass_GraphicDelete( kusa );
	Grass_FreeMemory( kusa );
}

//==============================================================================
//	@OtBbN
//==============================================================================
//--------------------------------------------------------------
/**
 * @OtBbN
 * @param	kusa	FE_GRASS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Grass_GraphicInit( FE_GRASS_PTR kusa )
{
	FE_BlActResmAdd_Mdl( kusa->fes, FE_RESMID_MDL_GRASS, "data/kusaeff.nsbmd" );
	FE_BlActResmAdd_Anm( kusa->fes, FE_RESMID_ANM_GRASS, "data/kusaeff_itpconv.dat" );
	FE_BlActResmAdd_Tex( kusa->fes, FE_RESMID_TEX_GRASS, "data/kusaeff.nsbtx" );
	
	FE_BlActHeaderManageAddResmID( kusa->fes, FE_BLACT_H_ID_GRASS,
			FE_RESMID_MDL_GRASS, FE_RESMID_ANM_GRASS,
			FE_RESMID_TEX_GRASS, FE_BLACT_TEX_VRAM,
			DATA_BlActAnmTbl_Grass );
}

//--------------------------------------------------------------
/**
 * @OtBbN폜
 * @param	kusa	FE_GRASS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Grass_GraphicDelete( FE_GRASS_PTR kusa )
{
	FE_BlActResmDelete_Mdl( kusa->fes, FE_RESMID_MDL_GRASS );
	FE_BlActResmDelete_Anm( kusa->fes, FE_RESMID_ANM_GRASS );
	FE_BlActResmDelete_Tex( kusa->fes, FE_RESMID_TEX_GRASS );
	
	FE_BlActHeaderManageFree( kusa->fes, FE_BLACT_H_ID_GRASS );
}

//==============================================================================
//	p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * m
 * @param	heap_id		q[vID
 * @retval	FE_GRASS_PTR	mۂFE_GRASS_PTR
 */
//--------------------------------------------------------------
static FE_GRASS_PTR Grass_AllocMemory( int heap_id )
{
	FE_GRASS_PTR kusa;
	
	kusa = sys_AllocMemory( heap_id, FE_GRASS_SIZE );
	GF_ASSERT( kusa != NULL && "Grass_AllocMemory()mێs" );
	
	memset( kusa, 0, FE_GRASS_SIZE );
	return( kusa );
}

//--------------------------------------------------------------
/**
 * J
 * @param	kusa	FE_GRASS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Grass_FreeMemory( FE_GRASS_PTR kusa )
{
	sys_FreeMemory( kusa->heap_id, kusa );
}

//==============================================================================
//	@EOA
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hOBJpǉ
 * @param	fldobj		FIELD_OBJ_PTR
 * @param	shake		TRUE=ꂩJnBFALSE=hȂJn
 * @retval	nothing		
 */
//--------------------------------------------------------------
void FE_FldOBJGrass_Add( FIELD_OBJ_PTR fldobj, int shake )
{
	int pri;
	VecFx32 mtx;
	GRASS_ADD_H head;
	FE_SYS_PTR fes;
	EOA_PTR eoa;
	
	fes = FE_FieldOBJ_FE_SYS_PTR_Get( fldobj );
	
	head.init_gx = FieldOBJ_NowPosGX_Get( fldobj );
	head.init_gy = FieldOBJ_NowPosGY_Get( fldobj );
	head.init_gz = FieldOBJ_NowPosGZ_Get( fldobj );
	head.fes = fes;
	head.fsys = FE_FieldSysWorkGet( fes );
	head.kusa = FE_GrassPtrGet( fes );
	head.fldobj = fldobj;
	
	FieldOBJ_VecPosGet( fldobj, &mtx );
	pri = FE_FldOBJ_TCBPriGet( fldobj, 1 );
	eoa = FE_EoaAddNpp( fes, &DATA_EoaH_Grass, &mtx, shake, &head, pri );
}

//--------------------------------------------------------------
/**
 * EOA @
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	int		TRUE=IBFALSE=ُI
 */
//--------------------------------------------------------------
static int EoaGrass_Init( EOA_PTR eoa, void *wk )
{
	int gx,gz;
	VecFx32 vec;
	GRASS_WORK *work;
	const GRASS_ADD_H *head;
	
	work = wk;
	head = EOA_AddPtrGet( eoa );
	
	work->head = *head;
	work->obj_id = FieldOBJ_OBJIDGet( work->head.fldobj );
	work->zone_id = FieldOBJ_ZoneIDGet( work->head.fldobj );
	
	vec.x = GRID_SIZE_FX32( work->head.init_gx ) + GRASS_GIRD_VEC_OFFS_X;
	vec.z = GRID_SIZE_FX32( work->head.init_gz ) + GRASS_GIRD_VEC_OFFS_Z;
	
	vec.y = FieldOBJ_VecPosYGet( work->head.fldobj );
	
	FieldOBJTool_GetHeight( work->head.fsys, &vec );
//	vec.y += GRASS_GROUND_OFFS_Y;
	
	EOA_MatrixSet( eoa, &vec );
	work->act = FE_BlActAddID( work->head.fes, FE_BLACT_H_ID_GRASS, &vec );
	
	if( EOA_AddParamGet(eoa) == FALSE ){						//hȂ
		work->seq_no = 1;
	}
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * EOA @폜
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaGrass_Delete( EOA_PTR eoa, void *wk )
{
	GRASS_WORK *work;
	
	work = wk;
	BLACT_Delete( work->act );
}

//--------------------------------------------------------------
/**
 * EOA @
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaGrass_Move( EOA_PTR eoa, void *wk )
{
	int frame;
	GRASS_WORK *work;
	FIELD_OBJ_PTR fldobj;
	
	work = wk;
	fldobj = work->head.fldobj;
	
	if( FE_FldOBJ_CheckSameID(fldobj,work->obj_id,work->zone_id) == FALSE ){
		EOA_Delete( eoa );
		return;
	}
	
	switch( work->seq_no ){
	case 0:													//h
		BLACT_AnmFrameChg( work->act, FX32_ONE );
		frame = BLACT_AnmFrameGetOffs( work->act ) / FX32_ONE;
		
		if( frame >= GRASS_SHAKE_FRAME ){
			work->seq_no = 1;
		}
		
		break;
	case 1:
		BLACT_AnmFrameSet( work->act, (GRASS_SHAKE_FRAME*FX32_ONE) );
		work->seq_no = 2;
	case 2:
		if( FE_FldOBJ_CheckSameID(fldobj,work->obj_id,work->zone_id) == FALSE ){
			EOA_Delete( eoa );
			return;
		}
		
		{
			int gx,gz;
			
			gx = FieldOBJ_NowPosGX_Get( fldobj );
			gz = FieldOBJ_NowPosGZ_Get( fldobj );
			
			if( work->head.init_gx != gx || work->head.init_gz != gz ){
				EOA_Delete( eoa );
				return;
			}
		}
		
		break;
	}
}

//--------------------------------------------------------------
/**
 * EOA @`
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaGrass_Draw( EOA_PTR eoa, void *wk )
{
	VecFx32 vec;
	GRASS_WORK *work;
	FIELD_OBJ_PTR fldobj;
	
	work = wk;
	fldobj = work->head.fldobj;
	
	if( FE_FldOBJ_CheckSameID(fldobj,work->obj_id,work->zone_id) == FALSE ){
		EOA_Delete( eoa );
		return;
	}
	
	EOA_MatrixGet( eoa, &vec );
	BLACT_MatrixSet( work->act, &vec );
}

//--------------------------------------------------------------
///	EOA_H
//--------------------------------------------------------------
static const EOA_H_NPP DATA_EoaH_Grass =
{
	GRASS_WORK_SIZE,
	EoaGrass_Init,
	EoaGrass_Delete,
	EoaGrass_Move,
	EoaGrass_Draw,
};

//--------------------------------------------------------------
///	Aj
//--------------------------------------------------------------
static const BLACT_ANIME_TBL DATA_BlActAnmTbl_Grass[] =
{
	{ 0, GRASS_SHAKE_FRAME, BLACT_ANIM_LOOP },
	{ 0, 0, BLACT_ANIM_CMD_MAX },
};

//==============================================================================
//	n
//==============================================================================
static const EOA_H_NPP DATA_EoaH_CommTrapGrass;

//--------------------------------------------------------------
//	TIKA_GRASS_ADD_H\
//--------------------------------------------------------------
typedef struct
{
	int init_gx;
	int init_gz;
	FIELDSYS_WORK *fsys;
	FE_SYS_PTR fes;
	FE_GRASS_PTR kusa;
}TIKA_GRASS_ADD_H;

//--------------------------------------------------------------
//	np[N
//--------------------------------------------------------------
typedef struct
{
	int seq_no;
	int end_flag;
	TIKA_GRASS_ADD_H head;
	BLACT_WORK_PTR act;
}TIKA_GRASS_WORK;

#define TIKA_GRASS_WORK_SIZE (sizeof(TIKA_GRASS_WORK))

//--------------------------------------------------------------
/**
 * n㩗pǉ
 * @param	fsys		FIELDSYS_WORK *
 * @param	x			ObhXW
 * @param	z			ObhZW
 * @retval	EOA_PTR		EOA_PTR
 */
//--------------------------------------------------------------
EOA_PTR FE_CommTrapGrass_Add( FIELDSYS_WORK *fsys, int x, int z )
{
	VecFx32 mtx;
	TIKA_GRASS_ADD_H head;
	FE_SYS_PTR fes;
	EOA_PTR eoa;
	
	fes = fsys->fes;
	
	head.init_gx = x;
	head.init_gz = z;
	head.fes = fes;
	head.fsys = fsys;
	head.kusa = FE_GrassPtrGet( fes );
	
	mtx.x = GRID_SIZE_FX32( x ) + (FX32_ONE * 9 );
	mtx.y = 0;
	mtx.z = GRID_SIZE_FX32( z ) + (FX32_ONE * 15 );
	
	eoa = FE_EoaAddNpp( fes, &DATA_EoaH_CommTrapGrass, &mtx, 0, &head, 0xff );
	return( eoa );
}

//--------------------------------------------------------------
/**
 * n㩗pAjI`FbN
 * @param	EOA_PTR		FE_CommTrapGrass_Add()߂l
 * @retval	int		TRUE=IBFALSE=܂
 */
//--------------------------------------------------------------
int FE_CommTrapGrass_AnimeCheck( EOA_PTR eoa )
{
	TIKA_GRASS_WORK *work;
	
	work = EOA_LocalWorkGet( eoa );
	return( work->end_flag );
}

//--------------------------------------------------------------
/**
 * EOA n@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	int		TRUE=IBFALSE=ُI
 */
//--------------------------------------------------------------
static int EoaCommTrapGrass_Init( EOA_PTR eoa, void *wk )
{
	VecFx32 mtx;
	TIKA_GRASS_WORK *work;
	const TIKA_GRASS_ADD_H *head;
	
	work = wk;
	head = EOA_AddPtrGet( eoa );
	work->head = *head;
	
	EOA_MatrixGet( eoa, &mtx );
	work->act = FE_BlActAddID( work->head.fes, FE_BLACT_H_ID_GRASS, &mtx );
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * EOA n@폜
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaCommTrapGrass_Delete( EOA_PTR eoa, void *wk )
{
	TIKA_GRASS_WORK *work;
	
	work = wk;
	BLACT_Delete( work->act );
}

//--------------------------------------------------------------
/**
 * EOA n@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaCommTrapGrass_Move( EOA_PTR eoa, void *wk )
{
	int frame;
	TIKA_GRASS_WORK *work;
	
	work = wk;
	
	switch( work->seq_no ){
	case 0:													//h
		BLACT_AnmFrameChg( work->act, FX32_ONE );
		frame = BLACT_AnmFrameGetOffs( work->act ) / FX32_ONE;
		
		if( frame >= GRASS_SHAKE_FRAME ){
			work->end_flag = TRUE;
			work->seq_no = 1;
		}
		
		break;
	case 1:
		break;
	}
}

//--------------------------------------------------------------
/**
 * EOA n@`
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaCommTrapGrass_Draw( EOA_PTR eoa, void *wk )
{
	VecFx32 mtx;
	TIKA_GRASS_WORK *work;
	
	work = wk;
	EOA_MatrixGet( eoa, &mtx );
	BLACT_MatrixSet( work->act, &mtx );
}

//--------------------------------------------------------------
///	EOA_H
//--------------------------------------------------------------
static const EOA_H_NPP DATA_EoaH_CommTrapGrass =
{
	TIKA_GRASS_WORK_SIZE,
	EoaCommTrapGrass_Init,
	EoaCommTrapGrass_Delete,
	EoaCommTrapGrass_Move,
	EoaCommTrapGrass_Draw,
};

/////////////////////////////////////////////////////////////////////////
//==============================================================================
//	ꑐGJEg
//==============================================================================
static const EOA_H_NPP DATA_EoaH_EncGrass;

//--------------------------------------------------------------
//	\
//--------------------------------------------------------------
typedef struct
{
	int init_gx;
	int init_gz;
	FIELDSYS_WORK *fsys;
	FE_SYS_PTR fes;
	FE_GRASS_PTR kusa;
}ENC_GRASS_ADD_H;

//--------------------------------------------------------------
//	ꑐp[N
//--------------------------------------------------------------
typedef struct
{
	int seq_no;
	int end_flag;
	ENC_GRASS_ADD_H head;
	BLACT_WORK_PTR act;
}ENC_GRASS_WORK;

#define ENC_GRASS_WORK_SIZE (sizeof(ENC_GRASS_WORK))

//--------------------------------------------------------------
/**
 * ꑐǉ
 * @param	fsys		FIELDSYS_WORK *
 * @param	x			ObhXW
 * @param	z			ObhZW
 * @retval	EOA_PTR		EOA_PTR
 */
//--------------------------------------------------------------
EOA_PTR FE_EncGrass_Add( FIELDSYS_WORK *fsys, int x, int z )
{
	VecFx32 mtx;
	ENC_GRASS_ADD_H head;
	FE_SYS_PTR fes;
	EOA_PTR eoa;
	
	fes = fsys->fes;
	
	head.init_gx = x;
	head.init_gz = z;
	head.fes = fes;
	head.fsys = fsys;
	head.kusa = FE_GrassPtrGet( fes );
	
	mtx.x = GRID_SIZE_FX32( x ) + (FX32_ONE * 9 );
	mtx.y = 0;
	mtx.z = GRID_SIZE_FX32( z ) + (FX32_ONE * 15 );
	
	eoa = FE_EoaAddNpp( fes, &DATA_EoaH_EncGrass, &mtx, 0, &head, 0xff );
	return( eoa );
}

//--------------------------------------------------------------
/**
 * n㩗pAjI`FbN
 * @param	EOA_PTR		FE_CommTrapGrass_Add()߂l
 * @retval	int		TRUE=IBFALSE=܂
 */
//--------------------------------------------------------------
int FE_EncGrass_AnimeCheck( EOA_PTR eoa )
{
	ENC_GRASS_WORK *work;
	
	work = EOA_LocalWorkGet( eoa );
	return( work->end_flag );
}

//--------------------------------------------------------------
/**
 * EOA ꑐ@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	int		TRUE=IBFALSE=ُI
 */
//--------------------------------------------------------------
static int EoaEncGrass_Init( EOA_PTR eoa, void *wk )
{
	VecFx32 vec;
	ENC_GRASS_WORK *work;
	const ENC_GRASS_ADD_H *head;
	
	work = wk;
	head = EOA_AddPtrGet( eoa );
	work->head = *head;

	vec.x = GRID_SIZE_FX32( work->head.init_gx ) + GRASS_GIRD_VEC_OFFS_X;
	vec.z = GRID_SIZE_FX32( work->head.init_gz ) + GRASS_GIRD_VEC_OFFS_Z;
	
	vec.y = 0;
	
//	GetHeightPack_old( work->head.fsys, &vec );
	FieldOBJTool_GetHeight( work->head.fsys, &vec );
	vec.y += GRASS_GROUND_OFFS_Y;

	EOA_MatrixSet( eoa, &vec );
	
	work->act = FE_BlActAddID( work->head.fes, FE_BLACT_H_ID_GRASS, &vec );
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * EOA ꑐ@폜
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaEncGrass_Delete( EOA_PTR eoa, void *wk )
{
	ENC_GRASS_WORK *work;
	
	work = wk;
	BLACT_Delete( work->act );
}

//--------------------------------------------------------------
/**
 * EOA ꑐ@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaEncGrass_Move( EOA_PTR eoa, void *wk )
{
	int frame;
	ENC_GRASS_WORK *work;
	
	work = wk;
	
	switch( work->seq_no ){
	case 0:													//h
		BLACT_AnmFrameChg( work->act, FX32_ONE );
		frame = BLACT_AnmFrameGetOffs( work->act ) / FX32_ONE;
		
		if( frame >= GRASS_SHAKE_FRAME ){
			work->end_flag = TRUE;
			work->seq_no = 1;
		}
		
		break;
	case 1:
		break;
	}
}

//--------------------------------------------------------------
/**
 * EOA ꑐ@`
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaEncGrass_Draw( EOA_PTR eoa, void *wk )
{
	VecFx32 mtx;
	ENC_GRASS_WORK *work;
	
	work = wk;
	EOA_MatrixGet( eoa, &mtx );
	BLACT_MatrixSet( work->act, &mtx );
}

//--------------------------------------------------------------
///	EOA_H
//--------------------------------------------------------------
static const EOA_H_NPP DATA_EoaH_EncGrass =
{
	TIKA_GRASS_WORK_SIZE,
	EoaEncGrass_Init,
	EoaEncGrass_Delete,
	EoaEncGrass_Move,
	EoaEncGrass_Draw,
};


