//******************************************************************************
/**
 * 
 * @file	fldeff_gyoe.c
 * @brief	tB[hOBJ傦[
 * @author	kagaya
 * @data	05.07.13
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "field_effect.h"
#include "fieldobj.h"
#include "fldeff_gyoe.h"

//==============================================================================
//	define
//==============================================================================
#define GYOE_FLDOBJ_Y_OFFSET ((FX32_ONE*32))				///<tB[hOBJYItZbg
#define GYOE_FLDOBJ_Z_OFFSET ((FX32_ONE*1))					///<tB[hOBJZItZbg
#define GYOE_FLDOBJ_Y_MOVE_START ((FX32_ONE*6))				///<MG[

#define GYOE_END_FRAME (30)									///<MG[It[	

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	FE_GYOE\
//--------------------------------------------------------------
typedef struct _TAG_FE_GYOE
{
	int heap_id;
	int add_count;
	int draw_init;
	FE_SYS_PTR fes;
}FE_GYOE;

#define FE_GYOE_SIZE (sizeof(FE_GYOE)) ///<FE_GYOETCY

//--------------------------------------------------------------
///	GYOE_ADD_H\
//--------------------------------------------------------------
typedef struct
{
	FE_SYS_PTR fes;								///<FE_SYS_PTR
	FE_GYOE_PTR gyoe;							///<FE_GYOE_PTR
	FIELD_OBJ_PTR fldobj;						///<傦[̑ΏFIELD_OBJ_PTR
}GYOE_ADD_H;

#define GYOE_ADD_H_SIZE (sizeof(GYOE_ADD_H)) ///<GYOE_ADD_HTCY

//--------------------------------------------------------------
///	GYOE_WORK\
//--------------------------------------------------------------
typedef struct
{
	int seq_no;									///<ԍ
	int frame;									///<t[
	int obj_id;									///<傦[ΏOBJID
	int zone_id;								///<傦[Ώۃ][ID
	int vanish_sw;								///<\SW
	int end_sw;									///<ISW
	VecFx32 offset;								///<ItZbg
	VecFx32 move;								///<ړ
	GYOE_ADD_H head;							///<ǉGYOE_ADD_H
	BLACT_WORK_PTR act;							///<r{[hAN^[
}GYOE_WORK;

#define GYOE_WORK_SIZE (sizeof(GYOE_WORK))	///<GYOE_WORKTCY

//==============================================================================
//	vg^Cv
//==============================================================================
static FE_GYOE_PTR Gyoe_AllocMemory( int heap_id );
static void Gyoe_FreeMemory( FE_GYOE_PTR gyoe );
static void Gyoe_AddCountUp( FE_GYOE_PTR gyoe );
static void Gyoe_AddCountDown( FE_GYOE_PTR gyoe );

static void Gyoe_GraphicInit( FE_GYOE_PTR gyoe );
static void Gyoe_GraphicDelete( FE_GYOE_PTR gyoe );
static void Gyoe_GraphicCheckInit( FE_GYOE_PTR gyoe );
static void Gyoe_GraphicCheckDelete( FE_GYOE_PTR gyoe );

static const EOA_H_NPP DATA_EoaH_Gyoe;
const BLACT_ANIME_TBL DATA_BlActAnmTbl_Gyoe[];

//==============================================================================
//	傦[@VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * 傦[
 * @param	fes		FE_SYS_PTR
 * @param	heap_id	q[vID
 * @retval	FE_GYOE_PTR	FE_GYOE_PTR
 */
//--------------------------------------------------------------
FE_GYOE_PTR FE_Gyoe_Init( FE_SYS_PTR fes, int heap_id )
{
	FE_GYOE_PTR gyoe;
	
	gyoe = Gyoe_AllocMemory( heap_id );
	gyoe->heap_id = heap_id;
	gyoe->fes = fes;
	
	return( gyoe );
}

//--------------------------------------------------------------
/**
 * 傦[폜
 * @param	gyoe		FE_GYOE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_Gyoe_Delete( FE_GYOE_PTR gyoe )
{
	Gyoe_GraphicDelete( gyoe );
	Gyoe_FreeMemory( gyoe );
}

//==============================================================================
//	傦[	p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * 傦[m
 * @param	heap_id		q[vID
 * @retval	FE_GYOE_PTR	mۂFE_GYOE_PTR
 */
//--------------------------------------------------------------
static FE_GYOE_PTR Gyoe_AllocMemory( int heap_id )
{
	FE_GYOE_PTR gyoe;
	
	gyoe = sys_AllocMemory( heap_id, FE_GYOE_SIZE );
	GF_ASSERT( gyoe != NULL && "Gyoe_AllocMemory()mێs" );
	
	memset( gyoe, 0, FE_GYOE_SIZE );
	return( gyoe );
}

//--------------------------------------------------------------
/**
 * 傦[폜
 * @param	gyoe	FE_GYOE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Gyoe_FreeMemory( FE_GYOE_PTR gyoe )
{
	sys_FreeMemory( gyoe->heap_id, gyoe );
}

//--------------------------------------------------------------
/**
 * MG[JEg
 * @param	gyoe	FE_GYOE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Gyoe_AddCountUp( FE_GYOE_PTR gyoe )
{
	gyoe->add_count++;
}

//--------------------------------------------------------------
/**
 * MG[fNg
 * @param	gyoe	FE_GYOE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Gyoe_AddCountDown( FE_GYOE_PTR gyoe )
{
	gyoe->add_count--;
	
	GF_ASSERT( gyoe->add_count >= 0 &&
		"Gyoe_AddCountDown()@MG[̒ǉƍ폜̉񐔂Ȃ" );
}

//==============================================================================
//	傦[@OtBbN
//==============================================================================
//--------------------------------------------------------------
/**
 * 傦[ OtBbN
 * @param	gyoe	FE_GYOE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Gyoe_GraphicInit( FE_GYOE_PTR gyoe )
{
	if( gyoe->draw_init == FALSE ){
		gyoe->draw_init = TRUE;
		FE_BlActResmAdd_Mdl( gyoe->fes, FE_RESMID_MDL_GYOE, "data/sisen_ef.nsbmd" );
		FE_BlActResmAdd_Anm( gyoe->fes, FE_RESMID_ANM_GYOE, "data/kusaeff_itpconv.dat" );
		FE_BlActResmAdd_Tex( gyoe->fes, FE_RESMID_TEX_GYOE, "data/sisen_ef.nsbtx" );
		
		FE_BlActHeaderManageAddResmID( gyoe->fes, FE_BLACT_H_ID_GYOE,
			FE_RESMID_MDL_GYOE, FE_RESMID_ANM_GYOE,
			FE_RESMID_TEX_GYOE, FE_BLACT_TEX_VRAM,
			DATA_BlActAnmTbl_Gyoe );
	}
}

//--------------------------------------------------------------
/**
 * 傦[ OtBbN폜
 * @param	gyoe	FE_GYOE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Gyoe_GraphicDelete( FE_GYOE_PTR gyoe )
{
	if( gyoe->draw_init == TRUE ){
		gyoe->draw_init = FALSE;
		
		FE_BlActResmDelete_Mdl( gyoe->fes, FE_RESMID_MDL_GYOE );
		FE_BlActResmDelete_Anm( gyoe->fes, FE_RESMID_ANM_GYOE );
		FE_BlActResmDelete_Tex( gyoe->fes, FE_RESMID_TEX_GYOE );
		
		FE_BlActHeaderManageFree( gyoe->fes, FE_BLACT_H_ID_GYOE );
	}
}

//--------------------------------------------------------------
/**
 * OtBbN
 * @param	gyoe FE_GYOE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Gyoe_GraphicCheckInit( FE_GYOE_PTR gyoe )
{
	if( gyoe->add_count == 0 ){
		Gyoe_GraphicInit( gyoe );
	}
}

//--------------------------------------------------------------
/**
 * OtBbN폜
 * @param	gyoe FE_GYOE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Gyoe_GraphicCheckDelete( FE_GYOE_PTR gyoe )
{
	if( gyoe->add_count == 0 ){
		Gyoe_GraphicDelete( gyoe );
	}
}

//==============================================================================
//	傦[@EOA
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hOBJp傦[ǉ
 * @param	fldobj		FIELD_OBJ_PTR
 * @retval	EOA_PTR		ǉEOA_PTR
 */
//--------------------------------------------------------------
EOA_PTR FE_FldOBJGyoe_Add( FIELD_OBJ_PTR fldobj )
{
	int pri;
	GYOE_ADD_H head;
	FE_SYS_PTR fes;
	VecFx32 mtx;
	EOA_PTR eoa;
	
	fes = FE_FieldOBJ_FE_SYS_PTR_Get( fldobj );
	
	head.fes = fes;
	head.gyoe = FE_GyoePtrGet( fes );
	head.fldobj = fldobj;
	
	FieldOBJ_VecPosGet( fldobj, &mtx );
	
	pri = FieldOBJ_TCBStandardPriorityGet( fldobj ) + 1;	//tB[hOBJ
	eoa = FE_EoaAddNpp( fes, &DATA_EoaH_Gyoe, &mtx, 0, &head, pri );
	
	return( eoa );
}

//--------------------------------------------------------------
/**
 * tB[hOBJp傦[I`FbN
 * @param	eoa		MG[EOA
 * @retval	int		TRUE=I
 */
//--------------------------------------------------------------
int FE_FldOBJGyoe_EndCheck( EOA_PTR eoa )
{
	GYOE_WORK *work;
	
	work = EOA_LocalWorkGet( eoa );
	return( work->end_sw );
}

//--------------------------------------------------------------
/**
 * EOA 傦[@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	int		TRUE=IBFALSE=ُI
 */
//--------------------------------------------------------------
static int EoaGyoe_Init( EOA_PTR eoa, void *wk )
{
	VecFx32 vec;
	GYOE_WORK *work;
	const GYOE_ADD_H *head;
	
	work = wk;
	head = EOA_AddPtrGet( eoa );
	
	work->head = *head;
	work->obj_id = FieldOBJ_OBJIDGet( work->head.fldobj );
	work->zone_id = FieldOBJ_ZoneIDGet( work->head.fldobj );
	work->move.y = GYOE_FLDOBJ_Y_MOVE_START;
		
	Gyoe_GraphicCheckInit( work->head.gyoe );					//OtBbN
	
	EOA_MatrixGet( eoa, &vec );
	work->act = FE_BlActAddID( work->head.fes, FE_BLACT_H_ID_GYOE, &vec );
	
	Gyoe_AddCountUp( work->head.gyoe );							//JEgAbv
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * EOA 傦[@폜
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaGyoe_Delete( EOA_PTR eoa, void *wk )
{
	GYOE_WORK *work;
	
	work = wk;
	
	BLACT_Delete( work->act );									//AN^[폜
	Gyoe_AddCountDown( work->head.gyoe );						//JEg_E
	Gyoe_GraphicCheckDelete( work->head.gyoe );					//OtBbN폜
}

//--------------------------------------------------------------
/**
 * EOA 傦[@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaGyoe_Move( EOA_PTR eoa, void *wk )
{
	GYOE_WORK *work;
	FIELD_OBJ_PTR fldobj;
	VecFx32 vec;
	
	work = wk;
	fldobj = work->head.fldobj;
	
	GF_ASSERT( FE_FldOBJ_CheckSameID(fldobj,work->obj_id,work->zone_id) != FALSE &&
		"MG[쒆ɑΏۂ̃tB[hOBJ폜܂" );
	
	switch( work->seq_no ){
	case 0:
		FieldOBJ_VecPosGet( fldobj, &vec );
		vec.y += GYOE_FLDOBJ_Y_OFFSET;
		vec.z += GYOE_FLDOBJ_Z_OFFSET;
		EOA_MatrixSet( eoa, &vec );
		
		work->offset.y += work->move.y;
		
		if( work->offset.y ){
			work->move.y -= FX32_ONE * 2;
		}else{
			work->move.y = 0;
			work->seq_no++;
		}
		
		break;
	case 1:		
		work->frame++;
		
		if( work->frame >= GYOE_END_FRAME ){
			work->seq_no++;
			work->end_sw = TRUE;
		}
		
		break;
	case 2:
		break;
	}
}

//--------------------------------------------------------------
/**
 * EOA 傦[@`
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaGyoe_Draw( EOA_PTR eoa, void *wk )
{
	VecFx32 vec;
	GYOE_WORK *work;
	
	work = wk;
	
	if( work->vanish_sw == TRUE ){
		return;
	}
	
	EOA_MatrixGet( eoa, &vec );
	
	vec.x += work->offset.x;
	vec.y += work->offset.y;
	vec.z += work->offset.z;
	
	BLACT_MatrixSet( work->act, &vec );
}

//--------------------------------------------------------------
///	傦[EOA_H
//--------------------------------------------------------------
static const EOA_H_NPP DATA_EoaH_Gyoe =
{
	GYOE_WORK_SIZE,
	EoaGyoe_Init,
	EoaGyoe_Delete,
	EoaGyoe_Move,
	EoaGyoe_Draw,
};

//--------------------------------------------------------------
///	MG[Aj
//--------------------------------------------------------------
static const BLACT_ANIME_TBL DATA_BlActAnmTbl_Gyoe[] =
{
	{ 0, 1, BLACT_ANIM_LOOP },
	{ 0, 0, BLACT_ANIM_CMD_MAX },
};

