//******************************************************************************
/**
 * 
 * @file	fldeff_hole.c
 * @brief	tB[hOBJ 
 * @author	k.ohno
 * @data	05.11.29
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "field_effect.h"
#include "fieldobj.h"
#include "fldeff_hole.h"

//==============================================================================
//	define
//==============================================================================
//#define DEBUG_HOLE_WRITE_OFF	//`㩕`OFF

//#define HOLE_DRAW_Z_OFFSET (FX32_ONE*(3))
#define HOLE_DRAW_Z_OFFSET (FX32_ONE*(5))			///<㩕`ItZbgZ

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	FE_HOLE\
//--------------------------------------------------------------
typedef struct _TAG_FE_HOLE
{
	int heap_id;
	FE_SYS_PTR fes;
	NNSG3dRenderObj render;
	NNSG3dResMdl *model;
	NNSG3dResFileHeader *res_file;
}FE_HOLE;

#define FE_HOLE_SIZE (sizeof(FE_HOLE)) ///<FE_HOLETCY

//--------------------------------------------------------------
///	HOLE_ADD_H\
//--------------------------------------------------------------
typedef struct
{
	int init_gx;
	int init_gz;
	FIELDSYS_WORK *fsys;
	FE_SYS_PTR fes;
	FE_HOLE_PTR hole;						///<FE_HOLE_PTR
}HOLE_ADD_H;

#define HOLE_ADD_H_SIZE (sizeof(HOLE_ADD_H)) ///<HOLE_ADD_HTCY

//--------------------------------------------------------------
///	HOLE_WORK\
//--------------------------------------------------------------
typedef struct
{
    int counter;    // 
	int obj_id;									///<㩑ΏOBJID
	int zone_id;								///<㩑Ώۃ][ID
	int vanish_sw;								///<\SW
	HOLE_ADD_H head;							///<ǉHOLE_ADD_H
}HOLE_WORK;

#define HOLE_WORK_SIZE (sizeof(HOLE_WORK))	///<HOLE_WORKTCY

//==============================================================================
//	vg^Cv
//==============================================================================
static FE_HOLE_PTR Hole_AllocMemory( int heap_id );
static void Hole_FreeMemory( FE_HOLE_PTR sd );

static void Hole_GraphicInit( FE_HOLE_PTR sd );
static void Hole_GraphicDelete( FE_HOLE_PTR sd );

static const EOA_H_NPP DATA_EoaH_Hole;

//==============================================================================
//	㩁@VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * 㩏
 * @param	fes		FE_SYS_PTR
 * @param	heap_id	q[vID
 * @retval	FE_HOLE_PTR	FE_HOLE_PTR
 */
//--------------------------------------------------------------
FE_HOLE_PTR FE_Hole_Init( FE_SYS_PTR fes, int heap_id )
{
	FE_HOLE_PTR sd;

	sd = Hole_AllocMemory( heap_id );
	sd->heap_id = heap_id;
	sd->fes = fes;
	
	Hole_GraphicInit( sd );
	
	return( sd );
}

//--------------------------------------------------------------
/**
 * 㩍폜
 * @param	sd		FE_HOLE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_Hole_Delete( FE_HOLE_PTR sd )
{
	Hole_GraphicDelete( sd );
	Hole_FreeMemory( sd );
}

//==============================================================================
//		p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * 㩃m
 * @param	heap_id		q[vID
 * @retval	FE_HOLE_PTR	mۂFE_HOLE_PTR
 */
//--------------------------------------------------------------
static FE_HOLE_PTR Hole_AllocMemory( int heap_id )
{
	FE_HOLE_PTR sd;
	
	sd = sys_AllocMemory( heap_id, FE_HOLE_SIZE );
	GF_ASSERT( sd != NULL && "Hole_AllocMemory()mێs" );
	
	memset( sd, 0, FE_HOLE_SIZE );
	return( sd );
}

//--------------------------------------------------------------
/**
 * 㩃폜
 * @param	sd	FE_HOLE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Hole_FreeMemory( FE_HOLE_PTR sd )
{
	sys_FreeMemory( sd->heap_id, sd );
}

//==============================================================================
//	㩁@OtBbN
//==============================================================================
//--------------------------------------------------------------
/**
 *  OtBbN
 * @param	sd	FE_HOLE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Hole_GraphicInit( FE_HOLE_PTR sd )
{
	NNS_G3dRenderObjInit( &sd->render, sd->model );
	simple_3DModelSet( sd->heap_id, "data/hole.nsbmd",
                       &sd->render, &sd->model, &sd->res_file );
}

//--------------------------------------------------------------
/**
 *  OtBbN폜
 * @param	sd	FE_HOLE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Hole_GraphicDelete( FE_HOLE_PTR sd )
{
    sys_FreeMemory( sd->heap_id, sd->res_file );
}

//==============================================================================
//	㩁@EOA
//==============================================================================
//--------------------------------------------------------------
/**
 * gbvǉ
 * @param	fldobj		FIELD_OBJ_PTR
 * @retval	EOA_PTR
 */
//--------------------------------------------------------------
EOA_PTR FE_Hole_Add(  FIELDSYS_WORK *fsys, int x, int z, int liveTime )
{
	int param,pri;
	HOLE_ADD_H head;
	FE_SYS_PTR fes;
	VecFx32 mtx;
    EOA_PTR eoa;
	HOLE_WORK *work;
	
    fes = fsys->fes;
	head.fes = fes;
	head.hole = FE_HolePtrGet( fes );
	head.init_gx = x;
	head.init_gz = z;
	head.fsys = fsys;
	mtx.x = GRID_SIZE_FX32( x ) + (FX32_ONE * 9 );
	mtx.y = 0;
	mtx.z = GRID_SIZE_FX32( z );
	param = 0;
	eoa = FE_EoaAddNpp( fes, &DATA_EoaH_Hole, &mtx, param, &head, 0xff );
	work = EOA_LocalWorkGet( eoa );
    work->counter = liveTime;
    return eoa;
}

//--------------------------------------------------------------
/**
 * EOA 㩁@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	int		TRUE=IBFALSE=ُI
 */
//--------------------------------------------------------------
static int EoaHole_Init( EOA_PTR eoa, void *wk )
{
	HOLE_WORK *work;
	const HOLE_ADD_H *head;
    VecFx32 vec;
	
	work = wk;
	head = EOA_AddPtrGet( eoa );
	work->head = *head;

	vec.x = GRID_SIZE_FX32( work->head.init_gx ) + (FX32_ONE * 9 );
	vec.z = GRID_SIZE_FX32( work->head.init_gz );
    vec.y = 0;
    
	EOA_MatrixSet( eoa, &vec );

    work->counter = 20;// @@OO test time
    
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * EOA 㩁@폜
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaHole_Delete( EOA_PTR eoa, void *wk )
{
}

//--------------------------------------------------------------
/**
 * EOA 㩁@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaHole_Move( EOA_PTR eoa, void *wk )
{
    HOLE_WORK *work;
	work = wk;

    if(work->counter > 0){
        work->counter--;
        if(work->counter == 0){
        }
    }
}

//--------------------------------------------------------------
/**
 * EOA 㩁@`
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaHole_Draw( EOA_PTR eoa, void *wk )
{
	HOLE_WORK *work;
	
	work = wk;
	
    {
		VecFx32 vec;
		VecFx32 scale = { FX32_ONE*2, FX32_ONE*2, FX32_ONE*2 };
		MtxFx33 rot	  = { FX32_ONE, 0,0,0, FX32_ONE, 0,0,0,FX32_ONE};
		
		EOA_MatrixGet( eoa, &vec );
		
		vec.x += -(FX32_ONE * 1) / 2;
		vec.y += -(FX32_ONE * 1);
		vec.z += HOLE_DRAW_Z_OFFSET;
		simple_3DModelDraw( &work->head.hole->render, &vec, &rot, &scale );
	}
}

//--------------------------------------------------------------
///	EOA_H
//--------------------------------------------------------------
static const EOA_H_NPP DATA_EoaH_Hole =
{
	HOLE_WORK_SIZE,
	EoaHole_Init,
	EoaHole_Delete,
	EoaHole_Move,
	EoaHole_Draw,
};

