//******************************************************************************
/**
 * 
 * @file	fldeff_reflect.c
 * @brief	tB[hOBJf肱
 * @author	kagaya
 * @data	05.07.13
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "field_effect.h"
#include "fieldobj.h"
#include "player.h"
#include "map_tool.h"

#include "fldeff_reflect.h"

//==============================================================================
//	define
//==============================================================================
#define REF_SCALE_X_UP (FX32_ONE+(FX32_ONE/8))
#define REF_SCALE_X_DOWN (FX32_ONE-(FX32_ONE/8))
#define REF_SCALE_X_SPEED (FX32_ONE/64)

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	FE_REFLECT\
//--------------------------------------------------------------
typedef struct _TAG_FE_REFLECT
{
	int heap_id;
	FE_SYS_PTR fes;
}FE_REFLECT;

#define FE_REFLECT_SIZE (sizeof(FE_REFLECT))	///<FE_REFLECTTCY

//--------------------------------------------------------------
///	REF_ADD_H\
//--------------------------------------------------------------
typedef struct
{
	FIELDSYS_WORK *fsys;
	FE_SYS_PTR fes;
	FE_REFLECT_PTR fe_ref;
	FIELD_OBJ_PTR fldobj;
}REF_ADD_H;

#define REF_ADD_H_SIZE (sizeof(REF_ADD_H))		///<REF_ADD_HTCY

//--------------------------------------------------------------
///	REF_WORK\
//--------------------------------------------------------------
typedef struct
{
	int obj_id;
	int zone_id;
	int obj_code;
	REF_ADD_H head;
	BLACT_WORK_PTR act;
	VecFx32 scale;
	fx32 scale_val_x;
}REF_WORK;

#define REF_WORK_SIZE (sizeof(REF_WORK))		///<REF_WORKTCY

//==============================================================================
//	vg^Cv
//==============================================================================
static void Reflect_GraphicInit( FE_REFLECT_PTR ref );
static void Reflect_GraphicDelete( FE_REFLECT_PTR ref );

static const EOA_H_NPP DATA_EoaH_Reflect;

//==============================================================================
//	f肱	VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * f肱ݏ
 * @param	fes		FE_SYS_PTR
 * @param	heap_id	q[vID
 * @retval	FE_REFLECT_PTR	FE_REFLECT_PTR
 */
//--------------------------------------------------------------
FE_REFLECT_PTR FE_Reflect_Init( FE_SYS_PTR fes, int heap_id )
{
	FE_REFLECT_PTR ref;
	
	ref = sys_AllocMemory( heap_id, FE_REFLECT_SIZE );
	GF_ASSERT( ref != NULL && "FE_Reflect_Init()mێs" );
	memset( ref, 0, FE_REFLECT_SIZE );
	
	ref->heap_id = heap_id;
	ref->fes = fes;
	
	Reflect_GraphicInit( ref );
	return( ref );
}

//--------------------------------------------------------------
/**
 * f肱ݍ폜
 * @param	ref			FE_REFLECT_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_Reflect_Delete( FE_REFLECT_PTR ref )
{
	Reflect_GraphicDelete( ref );
	sys_FreeMemory( ref->heap_id, ref );
}

//==============================================================================
//	f肱݁@OtBbN
//==============================================================================
//--------------------------------------------------------------
/**
 * @OtBbN
 * @param	ref		FE_REFLECT_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Reflect_GraphicInit( FE_REFLECT_PTR ref )
{
	FE_BlActResmAdd_Mdl( ref->fes, FE_RESMID_MDL_REFLECT, "data/mirror.nsbmd" );
}

//--------------------------------------------------------------
/**
 * f肱݁@OtBbN폜
 * @param	ref		FE_REFLECT_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Reflect_GraphicDelete( FE_REFLECT_PTR ref )
{
	FE_BlActResmDelete_Mdl( ref->fes, FE_RESMID_MDL_REFLECT );
}

//==============================================================================
//	f肱݁@EOA
//==============================================================================
//--------------------------------------------------------------
/**
 * f肱ݒǉ
 * @param	fldobj	ΏFIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_FldOBJReflect_Add( FIELD_OBJ_PTR fldobj )
{
	int pri;
	VecFx32 mtx;
	REF_ADD_H head;
	EOA_PTR eoa;
	
	head.fsys = FieldOBJ_FieldSysWorkGet( fldobj );
	head.fes = FE_FieldOBJ_FE_SYS_PTR_Get( fldobj );
	head.fe_ref = FE_ReflectPtrGet( head.fes );
	head.fldobj = fldobj;
	
	FieldOBJ_VecPosGet( fldobj, &mtx );
	pri = FE_FldOBJ_TCBPriGet( fldobj, 1 );
	eoa = FE_EoaAddNpp( head.fes, &DATA_EoaH_Reflect, &mtx, 0, &head, pri );
}

//--------------------------------------------------------------
/**
 * EOA f肱݁@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	int		TRUE=I FALSE=ُI
 */
//--------------------------------------------------------------
static int EoaReflect_Init( EOA_PTR eoa, void *wk )
{
	VecFx32 vec = { 0, 0, 0 };
	REF_WORK *work;
	const REF_ADD_H *head;
	
	work = wk;
	head = EOA_AddPtrGet( eoa );
	work->head = *head;
	
	work->obj_id = FieldOBJ_OBJIDGet( work->head.fldobj );
	work->zone_id = FieldOBJ_ZoneIDGet( work->head.fldobj );
	work->obj_code = FieldOBJ_OBJCodeGet( work->head.fldobj );
	
	work->scale.x = FX32_ONE;
	work->scale.y = FX32_ONE;
	work->scale.z = FX32_ONE;
	work->scale_val_x = REF_SCALE_X_SPEED;
	
	{
		void *mdl;
		BLACT_HEADER act_head;
		
		{
			int code = FieldOBJ_OBJCodeGet( work->head.fldobj );
			CONST_FIELD_OBJ_SYS_PTR fos = FieldOBJ_FieldOBJSysGet( work->head.fldobj );
			int ret = FieldOBJ_BlActHeaderGetOBJCode( fos, code, &act_head );
			GF_ASSERT( ret != FALSE && "EoaReflect_Init()ΏۃtB[hOBJwb_[o^" );
		}
		
		{
			void *mdl = FE_BlActResmSearch_Mdl( work->head.fes, FE_RESMID_MDL_REFLECT );
			GF_ASSERT( mdl != NULL && "EoaReflect_Init() fo^" );
			act_head.ImdRes = mdl;
		}
		
		work->act = FE_BlActAdd( work->head.fes, &act_head, &vec );
	}
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * EOA f肱݁@폜
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaReflect_Delete( EOA_PTR eoa, void *wk )
{
	REF_WORK *work;
	
	work = wk;
	BLACT_Delete( work->act );
}

//--------------------------------------------------------------
/**
 * EOA f肱݁@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaReflect_Move( EOA_PTR eoa, void *wk )
{
	REF_WORK *work;
	FIELD_OBJ_PTR fldobj;
	
	work = wk;
	fldobj = work->head.fldobj;
	
	if( work->obj_code != FieldOBJ_OBJCodeGet(fldobj) ||
		FE_FldOBJ_CheckSameID(fldobj,work->obj_id,work->zone_id) == FALSE ){
		EOA_Delete( eoa );
		return;
	}
	
	{
		work->scale.x += work->scale_val_x;
		
		if( work->scale.x >= REF_SCALE_X_UP ){
			work->scale.x = REF_SCALE_X_UP;
			work->scale_val_x = -work->scale_val_x;
		}else if( work->scale.x <= REF_SCALE_X_DOWN ){
			work->scale.x = REF_SCALE_X_DOWN;
			work->scale_val_x = -work->scale_val_x;
		}
	}
	
	{
		int ret;
		VecFx32 vec;
		
		FieldOBJ_VecPosGet( fldobj, &vec );
		vec.z += GRID_SIZE_FX32( 1 ) / 2;
		
//		ret = GetHeightPack_old( work->head.fsys, &vec );
		ret = FieldOBJTool_GetHeight( work->head.fsys, &vec );
		
		if( ret == FALSE ){
			vec.y = 0;
		}else{
			vec.y -= (FX32_ONE * 20) + (FX32_ONE / 1);
		}
		
		EOA_MatrixSet( eoa, &vec );
	}
}

//--------------------------------------------------------------
/**
 * EOA f肱݁@`
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaReflect_Draw( EOA_PTR eoa, void *wk )
{
	REF_WORK *work;
	
	work = wk;
	
	{
		FIELD_OBJ_PTR fldobj = work->head.fldobj;
		
		if( work->obj_code != FieldOBJ_OBJCodeGet(fldobj) ||
			FE_FldOBJ_CheckSameID(fldobj,work->obj_id,work->zone_id) == FALSE ){
			EOA_Delete( eoa );
			return;
		}
	}
	
	{
		VecFx32 vec;
		
		EOA_MatrixGet( eoa, &vec );
		BLACT_MatrixSet( work->act, &vec );
	}
	
	{
		BLACT_ScaleSet( work->act, &work->scale );
	}
	
	{
		BLACT_WORK_PTR act = FieldOBJ_DrawBlAct00_BlActPtrGet( work->head.fldobj );
		BLACT_AnmOffsChg( work->act, BLACT_AnmOffsGet(act) );
		BLACT_AnmFrameSet( work->act, BLACT_AnmFrameGet(act) );
	}
}

//--------------------------------------------------------------
///	f肱EOA_H
//--------------------------------------------------------------
static const EOA_H_NPP DATA_EoaH_Reflect =
{
	REF_WORK_SIZE,
	EoaReflect_Init,
	EoaReflect_Delete,
	EoaReflect_Move,
	EoaReflect_Draw,
};

