//******************************************************************************
/**
 * 
 * @file	fldeff_ripple.c
 * @brief	tB[hOBJ@g
 * @author	kagaya
 * @data	05.07.13
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "field_effect.h"
#include "fieldobj.h"
#include "fldeff_ripple.h"

//==============================================================================
//	define
//==============================================================================
//#define DEBUG_RIPPLE_WRITE_OFF	//`Őg`OFF

//#define RIPPLE_DRAW_Z_OFFSET (FX32_ONE*(3))
//#define RIPPLE_DRAW_Z_OFFSET (FX32_ONE*(5))			///<g`ItZbgZ
//#define RIPPLE_DRAW_Z_OFFSET (FX32_ONE*(3))

#define RIPPLE_ON_FRAME (30)
#define RIPPLE_OFF_FRAME (RIPPLE_ON_FRAME+30)

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	FE_RIPPLE\
//--------------------------------------------------------------
typedef struct _TAG_FE_RIPPLE
{
	int heap_id;
	FE_SYS_PTR fes;
	NNSG3dRenderObj render;
	NNSG3dResMdl *model;
	NNSG3dResFileHeader *res_file;
	
	NNSG3dAnmObj *pAnmObj;
	NNSG3dResTex pTex;
	NNSFndAllocator allocator;
	void *anm_file;
}FE_RIPPLE;

#define FE_RIPPLE_SIZE (sizeof(FE_RIPPLE)) ///<FE_RIPPLETCY

//--------------------------------------------------------------
///	RIPPLE_ADD_H\
//--------------------------------------------------------------
typedef struct
{
	FE_SYS_PTR fes;					///<FE_SYS_PTR
	FE_RIPPLE_PTR ripple;		///<FE_RIPPLE_PTR
}RIPPLE_ADD_H;

#define RIPPLE_ADD_H_SIZE (sizeof(RIPPLE_ADD_H)) ///<RIPPLE_ADD_HTCY

//--------------------------------------------------------------
///	RIPPLE_WORK\
//--------------------------------------------------------------
typedef struct
{
	int vanish_sw;								///<\SW
	int frame;									///<\t[
	RIPPLE_ADD_H head;						///<ǉRIPPLE_ADD_H
}RIPPLE_WORK;

#define RIPPLE_WORK_SIZE (sizeof(RIPPLE_WORK))	///<RIPPLE_WORKTCY

//==============================================================================
//	vg^Cv
//==============================================================================
static FE_RIPPLE_PTR Ripple_AllocMemory( int heap_id );
static void Ripple_FreeMemory( FE_RIPPLE_PTR ripple );

static void Ripple_GraphicInit( FE_RIPPLE_PTR ripple );
static void Ripple_GraphicDelete( FE_RIPPLE_PTR ripple );

static const EOA_H_NPP DATA_EoaH_Ripple;

//==============================================================================
//	g@VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * g䏉
 * @param	fes		FE_SYS_PTR
 * @param	heap_id	q[vID
 * @retval	FE_RIPPLE_PTR	FE_RIPPLE_PTR
 */
//--------------------------------------------------------------
FE_RIPPLE_PTR FE_Ripple_Init( FE_SYS_PTR fes, int heap_id )
{
	FE_RIPPLE_PTR ripple;
	
	ripple = Ripple_AllocMemory( heap_id );
	ripple->heap_id = heap_id;
	ripple->fes = fes;
	
	Ripple_GraphicInit( ripple );
	
	return( ripple );
}

//--------------------------------------------------------------
/**
 * g폜
 * @param	ripple		FE_RIPPLE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_Ripple_Delete( FE_RIPPLE_PTR ripple )
{
	Ripple_GraphicDelete( ripple );
	Ripple_FreeMemory( ripple );
}

//==============================================================================
//	g	p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * g䃁m
 * @param	heap_id		q[vID
 * @retval	FE_RIPPLE_PTR	mۂFE_RIPPLE_PTR
 */
//--------------------------------------------------------------
static FE_RIPPLE_PTR Ripple_AllocMemory( int heap_id )
{
	FE_RIPPLE_PTR ripple;
	
	ripple = sys_AllocMemory( heap_id, FE_RIPPLE_SIZE );
	GF_ASSERT( ripple != NULL && "Ripple_AllocMemory()mێs" );
	
	memset( ripple, 0, FE_RIPPLE_SIZE );
	return( ripple );
}

//--------------------------------------------------------------
/**
 * g䃁폜
 * @param	ripple	FE_RIPPLE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Ripple_FreeMemory( FE_RIPPLE_PTR ripple )
{
	sys_FreeMemory( ripple->heap_id, ripple );
}

//==============================================================================
//	g@OtBbN
//==============================================================================
//--------------------------------------------------------------
/**
 * g OtBbN
 * @param	ripple	FE_RIPPLE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Ripple_GraphicInit( FE_RIPPLE_PTR ripple )
{
	simple_3DModelSet( ripple->heap_id, "data/ripple.nsbmd",
			&ripple->render, &ripple->model, &ripple->res_file );
#if 0	
	FE_3DAnime_AllocatorInit( &ripple->allocator, ripple->heap_id, 4 );
	
	ripple->anm_file =
		FE_3DAnime_FileLoad( ripple->heap_id, "data/ripple.nsbtp",
			&ripple->model, &ripple->pAnmObj,
			&ripple->pTex, &ripple->allocator );
#endif
}

//--------------------------------------------------------------
/**
 * g OtBbN폜
 * @param	ripple	FE_RIPPLE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Ripple_GraphicDelete( FE_RIPPLE_PTR ripple )
{
	sys_FreeMemory( ripple->heap_id, ripple->res_file );
}

//==============================================================================
//	g@EOA
//==============================================================================
//--------------------------------------------------------------
/**
 * gǉ
 * @param	fldobj	ΏۂƂȂFIELD_OBJ_PTR
 * @param	gx		\ObhXW
 * @param	gz		\ObhZW
 * @retval	EOA_PTR	gEOA_PTR
 */
//--------------------------------------------------------------
EOA_PTR FE_FldOBJRippleSet( FIELD_OBJ_PTR fldobj, int gx, int gz )
{
	int pri,param;
	RIPPLE_ADD_H head;
	VecFx32 mtx = { 0, 0, 0 };
	
	head.fes = FE_FieldOBJ_FE_SYS_PTR_Get( fldobj );
	head.ripple = FE_RipplePtrGet( head.fes );
	
	param = 0;
	pri = FE_FldOBJ_TCBPriGet( fldobj, 1 );
	return( FE_EoaAddNpp(head.fes,&DATA_EoaH_Ripple,&mtx,param,&head,pri) );
}

//--------------------------------------------------------------
/**
 * EOA g@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	int		TRUE=IBFALSE=ُI
 */
//--------------------------------------------------------------
static int EoaRipple_Init( EOA_PTR eoa, void *wk )
{
	RIPPLE_WORK *work = wk;
	const RIPPLE_ADD_H *head = EOA_AddPtrGet( eoa );
	
	work->head = *head;
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * EOA g@폜
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaRipple_Delete( EOA_PTR eoa, void *wk )
{
	RIPPLE_WORK *work = wk;
}

//--------------------------------------------------------------
/**
 * EOA g@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaRipple_Move( EOA_PTR eoa, void *wk )
{
	RIPPLE_WORK *work = wk;
}

//--------------------------------------------------------------
/**
 * EOA g@`
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaRipple_Draw( EOA_PTR eoa, void *wk )
{
	RIPPLE_WORK *work;
	
	work = wk;
	
	if( work->vanish_sw == TRUE ){
		return;
	}
	
	{
		work->frame++;
	}
	
	{
		VecFx32 vec;
		VecFx32 scale = { FX32_ONE, FX32_ONE, FX32_ONE };
		MtxFx33 rot	  = { FX32_ONE, 0,0,0, FX32_ONE, 0,0,0,FX32_ONE};
		
		EOA_MatrixGet( eoa, &vec );
		simple_3DModelDraw( &work->head.ripple->render, &vec, &rot, &scale );
	}
}

//==============================================================================
//	data
//==============================================================================
//--------------------------------------------------------------
///	gEOA_H
//--------------------------------------------------------------
static const EOA_H_NPP DATA_EoaH_Ripple =
{
	RIPPLE_WORK_SIZE,
	EoaRipple_Init,
	EoaRipple_Delete,
	EoaRipple_Move,
	EoaRipple_Draw,
};


//==============================================================================
//	debug
//==============================================================================
