//******************************************************************************
/**
 * 
 * @file	fldeff_rockride.c
 * @brief	tB[hOBJ@@Ǐ|P
 * @author	kagaya
 * @data	05.07.13
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "field_effect.h"
#include "fieldobj.h"
#include "fldeff_rockride.h"

//==============================================================================
//	define
//==============================================================================
//#define DEBUG_ROCKRIDE_WRITE_OFF	//`ŕǏ|P`OFF

//#define ROCKRIDE_DRAW_Z_OFFSET (FX32_ONE*(3))
//#define ROCKRIDE_DRAW_Z_OFFSET (FX32_ONE*(5))			///<Ǐ|P`ItZbgZ
//#define ROCKRIDE_DRAW_Z_OFFSET (FX32_ONE*(3))				

#define ROCKRIDE_RIDE_Y_OFFSET (FX32_ONE*8)				///<g|Pւ̕\ItZbgY
#define ROCKRIDE_RIDE_Z_OFFSET (FX32_ONE*4)				///<g|Pւ̕\ItZbgZ

#define ROCKRIDE_SHAKE_VALUE (0x0400)					///<hꕝ
#define ROCKRIDE_SHAKE_MAX (FX32_ONE*4)

#define ROCKRIDE_ON_FRAME (30)
#define ROCKRIDE_OFF_FRAME (ROCKRIDE_ON_FRAME+30)

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	FE_ROCKRIDE\
//--------------------------------------------------------------
typedef struct _TAG_FE_ROCKRIDE
{
	int heap_id;
	int add_count;
	int draw_init;
	FE_SYS_PTR fes;
	NNSG3dRenderObj render;
	NNSG3dResMdl *model;
	NNSG3dResFileHeader *res_file;
}FE_ROCKRIDE;

#define FE_ROCKRIDE_SIZE (sizeof(FE_ROCKRIDE)) ///<FE_ROCKRIDETCY

//--------------------------------------------------------------
///	ROCKRIDE_ADD_H\
//--------------------------------------------------------------
typedef struct
{
	int init_dir;					///<\
	FE_SYS_PTR fes;					///<FE_SYS_PTR
	FIELDSYS_WORK *fsys;			///<FIELDSYS_WORK
	FE_ROCKRIDE_PTR rockride;		///<FE_ROCKRIDE_PTR
	FIELD_OBJ_PTR fldobj;			///<FIELD_OBJ_PTR
}ROCKRIDE_ADD_H;

#define ROCKRIDE_ADD_H_SIZE (sizeof(ROCKRIDE_ADD_H)) ///<ROCKRIDE_ADD_HTCY

//--------------------------------------------------------------
///	ROCKRIDE_WORK\
//--------------------------------------------------------------
typedef struct
{
	int vanish_sw;								///<\SW
	int dir;									///<
	int frame;									///<\t[
	int joint;									///<ڑtO
	ROCKRIDE_ADD_H head;						///<ǉROCKRIDE_ADD_H
}ROCKRIDE_WORK;

#define ROCKRIDE_WORK_SIZE (sizeof(ROCKRIDE_WORK))	///<ROCKRIDE_WORKTCY

//==============================================================================
//	vg^Cv
//==============================================================================
static FE_ROCKRIDE_PTR RockRide_AllocMemory( int heap_id );
static void RockRide_FreeMemory( FE_ROCKRIDE_PTR rockride );
static void RockRide_AddCountUp( FE_ROCKRIDE_PTR rockride );
static void RockRide_AddCountDown( FE_ROCKRIDE_PTR rockride );

static void RockRide_GraphicInit( FE_ROCKRIDE_PTR rockride );
static void RockRide_GraphicDelete( FE_ROCKRIDE_PTR rockride );
static void RockRide_GraphicCheckInit( FE_ROCKRIDE_PTR rockride );
static void RockRide_GraphicCheckDelete( FE_ROCKRIDE_PTR rockride );

static const EOA_H_NPP DATA_EoaH_RockRide;

//==============================================================================
//	Ǐ|P@VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * Ǐ|P
 * @param	fes		FE_SYS_PTR
 * @param	heap_id	q[vID
 * @retval	FE_ROCKRIDE_PTR	FE_ROCKRIDE_PTR
 */
//--------------------------------------------------------------
FE_ROCKRIDE_PTR FE_RockRide_Init( FE_SYS_PTR fes, int heap_id )
{
	FE_ROCKRIDE_PTR rockride;
	
	rockride = RockRide_AllocMemory( heap_id );
	rockride->heap_id = heap_id;
	rockride->fes = fes;
	
	return( rockride );
}

//--------------------------------------------------------------
/**
 * Ǐ|P폜
 * @param	rockride		FE_ROCKRIDE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_RockRide_Delete( FE_ROCKRIDE_PTR rockride )
{
	RockRide_GraphicDelete( rockride );
	RockRide_FreeMemory( rockride );
}

//==============================================================================
//	Ǐ|P	p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * Ǐ|Pm
 * @param	heap_id		q[vID
 * @retval	FE_ROCKRIDE_PTR	mۂFE_ROCKRIDE_PTR
 */
//--------------------------------------------------------------
static FE_ROCKRIDE_PTR RockRide_AllocMemory( int heap_id )
{
	FE_ROCKRIDE_PTR rockride;
	
	rockride = sys_AllocMemory( heap_id, FE_ROCKRIDE_SIZE );
	GF_ASSERT( rockride != NULL && "RockRide_AllocMemory()mێs" );
	
	memset( rockride, 0, FE_ROCKRIDE_SIZE );
	return( rockride );
}

//--------------------------------------------------------------
/**
 * Ǐ|P폜
 * @param	rockride	FE_ROCKRIDE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void RockRide_FreeMemory( FE_ROCKRIDE_PTR rockride )
{
	sys_FreeMemory( rockride->heap_id, rockride );
}

//--------------------------------------------------------------
/**
 * Ǐ萔JEg
 * @param	rockride	FE_ROCKRIDE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void RockRide_AddCountUp( FE_ROCKRIDE_PTR rockride )
{
	rockride->add_count++;
}

//--------------------------------------------------------------
/**
 * Ǐ萔fNg
 * @param	rockride	FE_ROCKRIDE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void RockRide_AddCountDown( FE_ROCKRIDE_PTR rockride )
{
	rockride->add_count--;
	
	GF_ASSERT( rockride->add_count >= 0 &&
		"RockRide_AddCountDown()@Ǐ̒ǉƍ폜̉񐔂Ȃ" );
}

//==============================================================================
//	Ǐ|P@OtBbN
//==============================================================================
//--------------------------------------------------------------
/**
 * Ǐ|P OtBbN
 * @param	rockride	FE_ROCKRIDE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void RockRide_GraphicInit( FE_ROCKRIDE_PTR rockride )
{
	if( rockride->draw_init == FALSE ){
		rockride->draw_init = TRUE;
		simple_3DModelSet( rockride->heap_id, "data/rock_ride.nsbmd",
				&rockride->render, &rockride->model, &rockride->res_file );
	}
}

//--------------------------------------------------------------
/**
 * Ǐ|P OtBbN폜
 * @param	rockride	FE_ROCKRIDE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void RockRide_GraphicDelete( FE_ROCKRIDE_PTR rockride )
{
	if( rockride->draw_init == TRUE ){
		rockride->draw_init = FALSE;
		sys_FreeMemory( rockride->heap_id, rockride->res_file );
	}
}

//--------------------------------------------------------------
/**
 * OtBbN
 * @param	rockride	FE_ROCKRIDE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void RockRide_GraphicCheckInit( FE_ROCKRIDE_PTR rockride )
{
	if( rockride->add_count == 0 ){
		RockRide_GraphicInit( rockride );
	}
}

//--------------------------------------------------------------
/**
 * OtBbN폜
 * @param	rockride	FE_ROCKRIDE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void RockRide_GraphicCheckDelete( FE_ROCKRIDE_PTR rockride )
{
	if( rockride->add_count == 0 ){
		RockRide_GraphicDelete( rockride );
	}
}

//==============================================================================
//	Ǐ|P@EOA
//==============================================================================
//--------------------------------------------------------------
/**
 * EOA Ǐ|Pǉ
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	gx		\ObhX
 * @param	gz		\ObhZ
 * @param	dir		\
 * @param	joint	TRUE=fldobj̍Wɐڑ FALSE=Ȃ
 * @retval	EOA_PTR	ǉꂽ|PEOA_PTR
 */
//--------------------------------------------------------------
EOA_PTR FE_FldOBJRockRidePoke_Add( FIELD_OBJ_PTR fldobj, int gx, int gz, int dir, int joint )
{
	int pri;
	EOA_PTR eoa;
	ROCKRIDE_ADD_H head;
	VecFx32 mtx = {0,0,0};
	FE_SYS_PTR fes = FE_FieldOBJ_FE_SYS_PTR_Get( fldobj );
	
	head.init_dir = dir;
	head.fes = fes;
	head.fsys = FieldOBJ_FieldSysWorkGet( fldobj );
	head.rockride = FE_RockRidePtrGet( fes );
	head.fldobj = fldobj;
		
	if( joint == FALSE ){
		mtx.x = GRID_SIZE_FX32( gx ) + FLDOBJ_VEC_X_GRID_OFFS_FX32;
		mtx.z = GRID_SIZE_FX32( gz ) + FLDOBJ_VEC_Z_GRID_OFFS_FX32;
		FieldOBJTool_GetHeight( head.fsys, &mtx );
	}else{
		FieldOBJ_VecPosGet( fldobj, &mtx );
	}
	
	pri = FE_FldOBJ_TCBPriGet( fldobj, 1 );
	eoa = FE_EoaAddNpp( fes, &DATA_EoaH_RockRide, &mtx, joint, &head, pri );
	
	return( eoa );
}

//--------------------------------------------------------------
/**
 * Ǐ|P̐ڑtOZbg
 * @param	eoa		EOA_PTR
 * @param	joint	TRUE=ڑ FALSE=ڑ
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_FldOBJRockRidePokeJointFlagSet( EOA_PTR eoa, int joint )
{
	ROCKRIDE_WORK *work = EOA_LocalWorkGet( eoa );
	work->joint = joint;
}

//--------------------------------------------------------------
/**
 * EOA Ǐ|P@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	int		TRUE=IBFALSE=ُI
 */
//--------------------------------------------------------------
static int EoaRockRide_Init( EOA_PTR eoa, void *wk )
{
	ROCKRIDE_WORK *work = wk;
	const ROCKRIDE_ADD_H *head = EOA_AddPtrGet( eoa );
	
	work->head = *head;
	work->dir = head->init_dir;
	work->joint = EOA_AddParamGet( eoa );
	
	RockRide_GraphicCheckInit( work->head.rockride );
	RockRide_AddCountUp( work->head.rockride );
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * EOA Ǐ|P@폜
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaRockRide_Delete( EOA_PTR eoa, void *wk )
{
	ROCKRIDE_WORK *work = wk;
	
	RockRide_AddCountDown( work->head.rockride );
	RockRide_GraphicCheckDelete( work->head.rockride );
}

//--------------------------------------------------------------
/**
 * EOA Ǐ|P@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaRockRide_Move( EOA_PTR eoa, void *wk )
{
	ROCKRIDE_WORK *work = wk;
	FIELD_OBJ_PTR fldobj = work->head.fldobj;
	
	if( work->joint == FALSE ){
		return;
	}
	
	{
		VecFx32 offs = { 0, 0, 0 };
		FieldOBJ_VecDrawOffsOutSideSet( fldobj, &offs );
	}
	
	{
		VecFx32 vec;
		FieldOBJ_VecPosGet( fldobj, &vec );
		vec.y += 0;
		EOA_MatrixSet( eoa, &vec );
	}
}

//--------------------------------------------------------------
/**
 * EOA Ǐ|P@`
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaRockRide_Draw( EOA_PTR eoa, void *wk )
{
	ROCKRIDE_WORK *work;
	
	work = wk;
	
	if( work->vanish_sw == TRUE ){
		return;
	}
	
	{
		work->frame++;
	}
	
	{
		VecFx32 vec;
		VecFx32 scale = { FX32_ONE, FX32_ONE, FX32_ONE };
		MtxFx33 rot	  = { FX32_ONE, 0,0,0, FX32_ONE, 0,0,0,FX32_ONE};
		
		switch( work->dir ){
		case DIR_UP:	Rot360_to_MtxFx33( &rot, 0, 180, 0 ); break;
		case DIR_DOWN:	Rot360_to_MtxFx33( &rot, 0, 0, 0 ); break;
		case DIR_LEFT:	Rot360_to_MtxFx33( &rot, 0, 270, 0 ); break;
		case DIR_RIGHT:	Rot360_to_MtxFx33( &rot, 0, 90, 0 ); break;
		}
		
		EOA_MatrixGet( eoa, &vec );
		simple_3DModelDraw( &work->head.rockride->render, &vec, &rot, &scale );
	}
}

//==============================================================================
//	data
//==============================================================================
//--------------------------------------------------------------
///	Ǐ|PEOA_H
//--------------------------------------------------------------
static const EOA_H_NPP DATA_EoaH_RockRide =
{
	ROCKRIDE_WORK_SIZE,
	EoaRockRide_Init,
	EoaRockRide_Delete,
	EoaRockRide_Move,
	EoaRockRide_Draw,
};


//==============================================================================
//	debug
//==============================================================================
#ifdef DEBUG_ROCKRIDE_ROT
void DEBUG_RockRide_Rot( EOA_PTR eoa, int x, int y, int z )
{
	ROCKRIDE_WORK *work = EOA_LocalWorkGet( eoa );
	work->rot_x += x;
	if( work->rot_x >= 360 ){ work->rot_x = 0; }
	if( work->rot_x < 0 ){ work->rot_x = 360 - work->rot_x; }
	work->rot_y += y;
	if( work->rot_y >= 360 ){ work->rot_y = 0; }
	if( work->rot_y < 0 ){ work->rot_y = 360 - work->rot_y; }
	work->rot_z += z;
	if( work->rot_z >= 360 ){ work->rot_z = 0; }
	if( work->rot_z < 0 ){ work->rot_z = 360 - work->rot_z; }
}
#endif
