//******************************************************************************
/**
 * 
 * @file	fldeff_seed.c
 * @brief	tB[hOBJ؂̎֘AGtFNg
 * @author	kagaya
 * @data	05.07.13
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "field_effect.h"
#include "fieldobj.h"
#include "fldeff_seed.h"
#include "seedsys.h"

//==============================================================================
//	define
//==============================================================================
//--------------------------------------------------------------
///	fobO
//--------------------------------------------------------------

//--------------------------------------------------------------
///	Cލő
//--------------------------------------------------------------
#define SEEDGROUND_KIND (SEEDGROUND_FULL+1)

//--------------------------------------------------------------
///	\ItZbg
//--------------------------------------------------------------
//#define SG_DRAW_Z_OFFSET (FX32_ONE*(3))
#define SG_DRAW_X_OFFSET (FX32_ONE*2)
#define SG_DRAW_Y_OFFSET (FX32_ONE*(0))
#define SG_DRAW_Z_OFFSET (FX32_ONE*(0))

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	FE_SEEDGROUND\
//--------------------------------------------------------------
typedef struct _TAG_FE_SEEDGROUND
{
	int heap_id;
	FE_SYS_PTR fes;
	NNSG3dRenderObj render[SEEDGROUND_KIND];
	NNSG3dResMdl *model[SEEDGROUND_KIND];
	NNSG3dResFileHeader *res_file[SEEDGROUND_KIND];
}FE_SEEDGROUND;

#define FE_SEEDGROUND_SIZE (sizeof(FE_SEEDGROUND)) ///<FE_SEEDGROUNDTCY

//--------------------------------------------------------------
///	SEEDGROUND_ADD_H\
//--------------------------------------------------------------
typedef struct
{
	FE_SYS_PTR fes;								///<FE_SYS_PTR
	FE_SEEDGROUND_PTR sg;						///<FE_SEEDGROUND_PTR
	FIELD_OBJ_PTR fldobj;						///<؂̎y̑ΏFIELD_OBJ_PTR
}SEEDGROUND_ADD_H;

#define SEEDGROUND_ADD_H_SIZE (sizeof(SEEDGROUND_ADD_H)) ///<SEEDGROUND_ADD_HTCY

//--------------------------------------------------------------
///	SG_WORK\
//--------------------------------------------------------------
typedef struct
{
	int obj_id;									///<؂̎yΏOBJID
	int zone_id;								///<؂̎yΏۃ][ID
	int vanish_sw;								///<\SW
	int dry;									///<
	SEEDGROUND_ADD_H head;						///<ǉSEEDGROUND_ADD_H
}SG_WORK;

#define SG_WORK_SIZE (sizeof(SG_WORK))			///<SG_WORKTCY

//==============================================================================
//	vg^Cv
//==============================================================================
static FE_SEEDGROUND_PTR SG_AllocMemory( int heap_id );
static void SG_FreeMemory( FE_SEEDGROUND_PTR sd );

static void SG_GraphicInit( FE_SEEDGROUND_PTR sd );
static void SG_GraphicDelete( FE_SEEDGROUND_PTR sd );

static const EOA_H_NPP DATA_EoaH_SeedGround;

static const char * const DATA_SeedGroundMdlFilePathTbl[SEEDGROUND_KIND];

//==============================================================================
//	؂̎y@VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * ؂̎y
 * @param	fes		FE_SYS_PTR
 * @param	heap_id	q[vID
 * @retval	FE_SEEDGROUND_PTR	FE_SEEDGROUND_PTR
 */
//--------------------------------------------------------------
FE_SEEDGROUND_PTR FE_SeedGround_Init( FE_SYS_PTR fes, int heap_id )
{
	FE_SEEDGROUND_PTR sg;
	
	sg = SG_AllocMemory( heap_id );
	sg->heap_id = heap_id;
	sg->fes = fes;
	
	SG_GraphicInit( sg );
	
	return( sg );
}

//--------------------------------------------------------------
/**
 * ؂̎y폜
 * @param	sd		FE_SEEDGROUND_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_SeedGround_Delete( FE_SEEDGROUND_PTR sg )
{
	SG_GraphicDelete( sg );
	SG_FreeMemory( sg );
}

//==============================================================================
//	؂̎y	p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * ؂̎ym
 * @param	heap_id		q[vID
 * @retval	FE_SEEDGROUND_PTR	mۂFE_SEEDGROUND_PTR
 */
//--------------------------------------------------------------
static FE_SEEDGROUND_PTR SG_AllocMemory( int heap_id )
{
	FE_SEEDGROUND_PTR sg;
	
	sg = sys_AllocMemory( heap_id, FE_SEEDGROUND_SIZE );
	GF_ASSERT( sg != NULL && "SG_AllocMemory()mێs" );
	
	memset( sg, 0, FE_SEEDGROUND_SIZE );
	return( sg );
}

//--------------------------------------------------------------
/**
 * ؂̎y폜
 * @param	sg	FE_SEEDGROUND_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void SG_FreeMemory( FE_SEEDGROUND_PTR sg )
{
	sys_FreeMemory( sg->heap_id, sg );
}

//==============================================================================
//	؂̎y@OtBbN
//==============================================================================
//--------------------------------------------------------------
/**
 * ؂̎y OtBbN
 * @param	sg	FE_SEEDGROUND_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void SG_GraphicInit( FE_SEEDGROUND_PTR sg )
{
	int i = 0;
	
	do{
		simple_3DModelSet( sg->heap_id, DATA_SeedGroundMdlFilePathTbl[i],
			&sg->render[i], &sg->model[i], &sg->res_file[i] );
		i++;
	}while( i < SEEDGROUND_KIND );
}

//--------------------------------------------------------------
/**
 * ؂̎y OtBbN폜
 * @param	sg	FE_SEEDGROUND_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void SG_GraphicDelete( FE_SEEDGROUND_PTR sg )
{
	int i = 0;
	
	do{
		sys_FreeMemory( sg->heap_id, sg->res_file[i] );
		i++;
	}while( i < SEEDGROUND_KIND );
}

//==============================================================================
//	؂̎y@EOA
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hOBJp؂̎yǉ
 * @param	fldobj		FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_FldOBJSeedGround_Add( FIELD_OBJ_PTR fldobj )
{
	int param,pri;
	SEEDGROUND_ADD_H head;
	FE_SYS_PTR fes;
	VecFx32 mtx;
	
	fes = FE_FieldOBJ_FE_SYS_PTR_Get( fldobj );
	
	head.fes = fes;
	head.sg = FE_SeedGroundPtrGet( fes );
	head.fldobj = fldobj;
	
	FieldOBJ_VecPosGet( fldobj, &mtx );
	
	param = 0;	//Iɂ͂Ȃ񂩂̃p^
	
	pri = FieldOBJ_TCBStandardPriorityGet( fldobj ) + 1;	//tB[hOBJ
	FE_EoaAddNpp( fes, &DATA_EoaH_SeedGround, &mtx, param, &head, pri );
}

//--------------------------------------------------------------
/**
 * EOA ؂̎y@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	int		TRUE=IBFALSE=ُI
 */
//--------------------------------------------------------------
static int EoaSeedGround_Init( EOA_PTR eoa, void *wk )
{
	SG_WORK *work;
	const SEEDGROUND_ADD_H *head;
	
	work = wk;
	head = EOA_AddPtrGet( eoa );
	work->head = *head;
	
	work->obj_id = FieldOBJ_OBJIDGet( work->head.fldobj );
	work->zone_id = FieldOBJ_ZoneIDGet( work->head.fldobj );
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * EOA ؂̎y@폜
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaSeedGround_Delete( EOA_PTR eoa, void *wk )
{
}

//--------------------------------------------------------------
/**
 * EOA ؂̎y@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaSeedGround_Move( EOA_PTR eoa, void *wk )
{
	SG_WORK *work;
	FIELD_OBJ_PTR fldobj;
	
	work = wk;
	fldobj = work->head.fldobj;
	
	if( FE_FldOBJ_CheckSameID(fldobj,work->obj_id,work->zone_id) == FALSE ){
		EOA_Delete( eoa );										//ł͂Ȃ
		return;
	}
	
	work->vanish_sw = FALSE;
	
	if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_VANISH) == TRUE || 
		SeedSys_GetSeedStatus(FieldOBJ_FieldSysWorkGet(fldobj),fldobj) == SEEDSTAT_NOTHING ){
		work->vanish_sw = TRUE;									//\
		return;
	}
	
	{
		work->dry = SeedSys_GetGroundStatus( FieldOBJ_FieldSysWorkGet(fldobj), fldobj );
	}
	
	{
		VecFx32 vec;
		
		FieldOBJ_VecPosGet( fldobj, &vec );
		EOA_MatrixSet( eoa, &vec );
	}
}

//--------------------------------------------------------------
/**
 * EOA ؂̎y@`
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaSeedGround_Draw( EOA_PTR eoa, void *wk )
{
	SG_WORK *work;
	
	work = wk;
	
	if( work->vanish_sw == TRUE ){
		return;
	}
	
	{
		VecFx32 vec;
		VecFx32 scale = { FX32_ONE, FX32_ONE, FX32_ONE };
		MtxFx33 rot	  = { FX32_ONE, 0,0,0, FX32_ONE, 0,0,0,FX32_ONE};
		
		EOA_MatrixGet( eoa, &vec );
		
//		vec.x;
//		vec.y;
		vec.z += SG_DRAW_Z_OFFSET;
		simple_3DModelDraw( &work->head.sg->render[work->dry], &vec, &rot, &scale );
	}
}

//--------------------------------------------------------------
///	؂̎yEOA_H
//--------------------------------------------------------------
static const EOA_H_NPP DATA_EoaH_SeedGround =
{
	SG_WORK_SIZE,
	EoaSeedGround_Init,
	EoaSeedGround_Delete,
	EoaSeedGround_Move,
	EoaSeedGround_Draw,
};

//==============================================================================
//	data
//==============================================================================
//--------------------------------------------------------------
///	탂fOf[^t@CpXe[uBSEEDGROUND_DRY̕тɈv
//--------------------------------------------------------------
static const char * const DATA_SeedGroundMdlFilePathTbl[SEEDGROUND_KIND] =
{
	{ "data/seed_ground01.nsbmd" },
	{ "data/seed_ground02.nsbmd" },
	{ "data/seed_ground03.nsbmd" },
};

