//******************************************************************************
/**
 * 
 * @file	fldeff_snowball.c
 * @brief	tB[hOBJ
 * @author	kagaya
 * @data	05.07.13
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "field_effect.h"
#include "fieldobj.h"

#include "fldeff_snowball.h"

//==============================================================================
//	define
//==============================================================================

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	FE_SNOWBALL\
//--------------------------------------------------------------
typedef struct _TAG_FE_SNOWBALL
{
	int heap_id;
	FE_SYS_PTR fes;
	NNSG3dRenderObj render;
	NNSG3dResMdl *model;
	NNSG3dResFileHeader *res_file;
}FE_SNOWBALL;

#define FE_SNOWBALL_SIZE (sizeof(FE_SNOWBALL)) 					///<FE_SNOWBALLTCY

//--------------------------------------------------------------
///	SNOWBALL_ADD_H\
//--------------------------------------------------------------
typedef struct
{
	FE_SYS_PTR fes;
	FE_SNOWBALL_PTR sball;
	FIELD_OBJ_PTR fldobj;
}SNOWBALL_ADD_H;

//--------------------------------------------------------------
///	EOA_SNOWBALL_WORK\
//--------------------------------------------------------------
typedef struct
{
	int seq_no;
	int obj_id;
	int zone_id;
	SNOWBALL_ADD_H head;
}EOA_SNOWBALL_WORK;

#define EOA_SNOWBALL_WORK_SIZE (sizeof(EOA_SNOWBALL_WORK))

//==============================================================================
//	vg^Cv
//==============================================================================
static FE_SNOWBALL_PTR SnowBall_AllocMemory( int heap_id );
static void SnowBall_FreeMemory( FE_SNOWBALL_PTR sball );

static void SnowBall_GraphicInit( FE_SNOWBALL_PTR sball );
static void SnowBall_GraphicDelete( FE_SNOWBALL_PTR sball );

static const EOA_H_NPP DATA_EoaH_SnowBall;

//==============================================================================
//	ʁ@VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * ʏ
 * @param	fes		FE_SYS_PTR
 * @param	heap_id	q[vID
 * @retval	FE_SNOWBALL_PTR		FE_FOOTMARK_PTR
 */
//--------------------------------------------------------------
FE_SNOWBALL_PTR FE_SnowBall_Init( FE_SYS_PTR fes, int heap_id )
{
	FE_SNOWBALL_PTR sball;
	
	sball = SnowBall_AllocMemory( heap_id );
	sball->heap_id = heap_id;
	sball->fes = fes;
	
	SnowBall_GraphicInit( sball );
	
	return( sball );
}

//--------------------------------------------------------------
/**
 * ʍ폜
 * @param	sball		FE_SNOWBALL_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_SnowBall_Delete( FE_SNOWBALL_PTR sball )
{
	SnowBall_GraphicDelete( sball );
	SnowBall_FreeMemory( sball );
}

//==============================================================================
//		p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * ʃm
 * @param	heap_id		q[vID
 * @retval	FE_SNOWBALL_PTR	mۂFE_FOOTMARK_PTR
 */
//--------------------------------------------------------------
static FE_SNOWBALL_PTR SnowBall_AllocMemory( int heap_id )
{
	FE_SNOWBALL_PTR sball;
	
	sball = sys_AllocMemory( heap_id, FE_SNOWBALL_SIZE );
	GF_ASSERT( sball != NULL && "SnowBall_AllocMemory()mێs" );
	
	memset( sball, 0, FE_SNOWBALL_SIZE );
	return( sball );
}

//--------------------------------------------------------------
/**
 * ʃ폜
 * @param	sd	FE_SNOWBALL_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void SnowBall_FreeMemory( FE_SNOWBALL_PTR sball )
{
	sys_FreeMemory( sball->heap_id, sball );
}

//==============================================================================
//	ʁ@OtBbN
//==============================================================================
//--------------------------------------------------------------
/**
 *  OtBbN
 * @param	sball		FE_SNOWBALL_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void SnowBall_GraphicInit( FE_SNOWBALL_PTR sball )
{
	simple_3DModelSet( sball->heap_id, "data/gym06_o1.nsbmd",
			&sball->render, &sball->model, &sball->res_file );
}

//--------------------------------------------------------------
/**
 * ʁ@OtBbN폜
 * @param	sball		FE_SNOWBALL_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void SnowBall_GraphicDelete( FE_SNOWBALL_PTR sball )
{
	sys_FreeMemory( sball->heap_id, sball->res_file );
}

//==============================================================================
//	ʁ@EOA
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hOBJʒǉ
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	eoa		EOA_PTR
 */
//--------------------------------------------------------------
EOA_PTR FE_FldOBJSnowBall_Add( FIELD_OBJ_PTR fldobj )
{
	EOA_PTR eoa;
	FE_SYS_PTR fes;
	FE_SNOWBALL_PTR sball;
	SNOWBALL_ADD_H head;
	
	fes = FE_FieldOBJ_FE_SYS_PTR_Get( fldobj );
	sball = FE_SnowBallPtrGet( fes );
	
	head.fes = fes;
	head.sball = sball;
	head.fldobj = fldobj;
	
	{
		VecFx32 mtx = {0,0,0};
		int pri = FE_FldOBJ_TCBPriGet( fldobj, 1 );
		eoa = FE_EoaAddNpp( fes, &DATA_EoaH_SnowBall, &mtx, 0, &head, pri );
	}
	
	return( eoa );
}

//--------------------------------------------------------------
/**
 * EOA ʁ@
 * @param	eoa	EOA_PTR
 * @param	wk	eoa work *
 * @retval	int TRUE=IBFALSE=ُI
 */
//--------------------------------------------------------------
static int EoaSnowBall_Init( EOA_PTR eoa, void *wk )
{
	EOA_SNOWBALL_WORK *work;
	const SNOWBALL_ADD_H *head;
	
	work = wk;
	head = EOA_AddPtrGet( eoa );
	work->head = *head;
	
	work->obj_id = FieldOBJ_OBJIDGet( work->head.fldobj );
	work->zone_id = FieldOBJ_ZoneIDGet( work->head.fldobj );
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * EOA ʁ@폜
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaSnowBall_Delete( EOA_PTR eoa, void *wk )
{
}

//--------------------------------------------------------------
/**
 * EOA ʁ@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaSnowBall_Move( EOA_PTR eoa, void *wk )
{
	EOA_SNOWBALL_WORK *work;
	FIELD_OBJ_PTR fldobj;
	
	work = wk;
	fldobj = work->head.fldobj;
	
	if( FE_FldOBJ_CheckSameID(fldobj,work->obj_id,work->zone_id) == FALSE ){
		EOA_Delete( eoa );
		return;
	}
	
	{
		VecFx32 mtx,d_mtx;
		
		FieldOBJ_VecPosGet( fldobj, &mtx );
		FieldOBJ_VecDrawOffsGet( fldobj, &d_mtx );
		
		mtx.x += d_mtx.x + FLDOBJ_BLACT_X_GROUND_OFFS_FX32;
		mtx.y += d_mtx.y + FLDOBJ_BLACT_Y_GROUND_OFFS_FX32;
		mtx.z += d_mtx.z + FLDOBJ_BLACT_Z_GROUND_OFFS_FX32 - (FX32_ONE * 6);
		
		EOA_MatrixSet( eoa, &mtx );
	}
}

//--------------------------------------------------------------
/**
 * EOA ʁ@`
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaSnowBall_Draw( EOA_PTR eoa, void *wk )
{
	EOA_SNOWBALL_WORK *work;
	
	work = wk;
	
	{
		VecFx32 vec;
		VecFx32 scale = { FX32_ONE, FX32_ONE, FX32_ONE };
		MtxFx33 rot	  = { FX32_ONE, 0,0,0, FX32_ONE, 0,0,0,FX32_ONE};
		
		EOA_MatrixGet( eoa, &vec );
		simple_3DModelDraw( &work->head.sball->render, &vec, &rot, &scale );
	}
}

//==============================================================================
//	data
//==============================================================================
//--------------------------------------------------------------
///	EOA_H
//--------------------------------------------------------------
static const EOA_H_NPP DATA_EoaH_SnowBall =
{
	EOA_SNOWBALL_WORK_SIZE,
	EoaSnowBall_Init,
	EoaSnowBall_Delete,
	EoaSnowBall_Move,
	EoaSnowBall_Draw,
};
