//******************************************************************************
/**
 * 
 * @file	fldeff_splash.c
 * @brief	tB[hOBJ
 * @author	kagaya
 * @data	05.07.13
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "field_effect.h"
#include "fieldobj.h"

#include "fldeff_splash.h"
#include "map_tool.h"

//==============================================================================
//	define
//==============================================================================
#define SPLASH_ANIME_FRAME (12)				///<򖗃Ajt[

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	FE_SPLASH\
//--------------------------------------------------------------
typedef struct _TAG_FE_SPLASH
{
	int heap_id;
	FE_SYS_PTR fes;
}FE_SPLASH;

#define FE_SPLASH_SIZE (sizeof(FE_SPLASH))	///<FE_SPLASHTCY

//--------------------------------------------------------------
///	SPLASH_ADD_H\
//--------------------------------------------------------------
typedef struct
{
	FIELDSYS_WORK *fsys;
	FE_SYS_PTR fes;
	FE_SPLASH_PTR spl;
	FIELD_OBJ_PTR fldobj;
}SPLASH_ADD_H;

//--------------------------------------------------------------
///	SPLASH_WORK\
//--------------------------------------------------------------
typedef struct
{
	int seq_no;
	int obj_id;
	int zone_id;
	int frame;
	SPLASH_ADD_H head;
	BLACT_WORK_PTR act;
}SPLASH_WORK;

#define SPLASH_WORK_SIZE (sizeof(SPLASH_WORK))

//==============================================================================
//	vg^Cv
//==============================================================================
static FE_SPLASH_PTR Splash_AllocMemory( int heap_id );
static void Splash_FreeMemory( FE_SPLASH_PTR spl );

static void Splash_GraphicInit( FE_SPLASH_PTR spl );
static void Splash_GraphicDelete( FE_SPLASH_PTR spl );

static const EOA_H_NPP DATA_EoaH_Splash;
const BLACT_ANIME_TBL DATA_BlActAnmTbl_Splash[];

//==============================================================================
//		VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * 򖗏
 * @param	fes		FE_SYS_PTR
 * @param	heap_id	q[vID
 * @retval	FE_SPLASH_PTR FE_SPLASH_PTR
 */
//--------------------------------------------------------------
FE_SPLASH_PTR FE_Splash_Init( FE_SYS_PTR fes, int heap_id )
{
	FE_SPLASH_PTR spl;
	
	spl = Splash_AllocMemory( heap_id );
	spl->heap_id = heap_id;
	spl->fes = fes;
	
	Splash_GraphicInit( spl );
	
	return( spl );
}

//--------------------------------------------------------------
/**
 * 򖗍폜
 * @param	kusa		FE_SPLASH_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_Splash_Delete( FE_SPLASH_PTR spl )
{
	FE_SYS_PTR fes;
	
	fes = spl->fes;
	
	Splash_GraphicDelete( spl );
	Splash_FreeMemory( spl );
}

//--------------------------------------------------------------
/**
 * 򖗃m
 * @param	heap_id		q[vID
 * @retval	FE_SPLASH_PTR	mۂFE_SPLASH_PTR
 */
//--------------------------------------------------------------
static FE_SPLASH_PTR Splash_AllocMemory( int heap_id )
{
	FE_SPLASH_PTR spl;
	
	spl = sys_AllocMemory( heap_id, FE_SPLASH_SIZE );
	GF_ASSERT( spl != NULL && "Splash_AllocMemory()mێs" );
	
	memset( spl, 0, FE_SPLASH_SIZE );
	return( spl );
}

//--------------------------------------------------------------
/**
 * 򖗃J
 * @param	spl		FE_SPLASH_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Splash_FreeMemory( FE_SPLASH_PTR spl )
{
	sys_FreeMemory( spl->heap_id, spl );
}

//==============================================================================
//	򖗁@OtBbN
//==============================================================================
//--------------------------------------------------------------
/**
 * @OtBbN
 * @param	spl	FE_GRASS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Splash_GraphicInit( FE_SPLASH_PTR spl )
{
	FE_BlActResmAdd_Mdl( spl->fes, FE_RESMID_MDL_SPLASH, "data/shibuki.nsbmd" );
	FE_BlActResmAdd_Anm( spl->fes, FE_RESMID_ANM_SPLASH, "data/shibuki_itpconv.dat" );
	FE_BlActResmAdd_Tex( spl->fes, FE_RESMID_TEX_SPLASH, "data/shibuki.nsbtx" );
	
	FE_BlActHeaderManageAddResmID( spl->fes, FE_BLACT_H_ID_SPLASH,
			FE_RESMID_MDL_SPLASH, FE_RESMID_ANM_SPLASH,
			FE_RESMID_TEX_SPLASH, FE_BLACT_TEX_VRAM,
			DATA_BlActAnmTbl_Splash );
}

//--------------------------------------------------------------
/**
 * 򖗁@OtBbN폜
 * @param	spl	FE_SPLASH_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Splash_GraphicDelete( FE_SPLASH_PTR spl )
{
	FE_BlActResmDelete_Mdl( spl->fes, FE_RESMID_MDL_SPLASH );
	FE_BlActResmDelete_Anm( spl->fes, FE_RESMID_ANM_SPLASH );
	FE_BlActResmDelete_Tex( spl->fes, FE_RESMID_TEX_SPLASH );
	
	FE_BlActHeaderManageFree( spl->fes, FE_BLACT_H_ID_SPLASH );
}

//==============================================================================
//	EOA 
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hOBJp򖗒ǉ
 * @param	fldobj		FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_FldOBJSplash_Add( FIELD_OBJ_PTR fldobj )
{
	SPLASH_ADD_H head;
	FE_SYS_PTR fes;
	EOA_PTR eoa;
	
	fes = FE_FieldOBJ_FE_SYS_PTR_Get( fldobj );
	
	head.fsys = FieldOBJ_FieldSysWorkGet( fldobj );
	head.fes = fes;
	head.spl = FE_SplashPtrGet( fes );
	head.fldobj = fldobj;
	
	{
		VecFx32 vec = {0,0,0};
		int pri = FE_FldOBJ_TCBPriGet( fldobj, 1 );
		eoa = FE_EoaAddNpp( fes, &DATA_EoaH_Splash, &vec, 0, &head, pri );
	}
}

//--------------------------------------------------------------
/**
 * EOA 򖗁@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	int		TRUE=IBFALSE=ُI
 */
//--------------------------------------------------------------
static int EoaSplash_Init( EOA_PTR eoa, void *wk )
{
	VecFx32 vec = { 0,0,0 };
	SPLASH_WORK *work;
	const SPLASH_ADD_H *head;
	
	work = wk;
	head = EOA_AddPtrGet( eoa );
	
	work->head = *head;
	work->obj_id = FieldOBJ_OBJIDGet( work->head.fldobj );
	work->zone_id = FieldOBJ_ZoneIDGet( work->head.fldobj );
	
	EOA_MatrixSet( eoa, &vec );
	work->act = FE_BlActAddID( work->head.fes, FE_BLACT_H_ID_SPLASH, &vec );
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * EOA 򖗁@폜
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaSplash_Delete( EOA_PTR eoa, void *wk )
{
	SPLASH_WORK *work;
	
	work = wk;
	BLACT_Delete( work->act );
}

//--------------------------------------------------------------
/**
 * EOA 򖗁@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaSplash_Move( EOA_PTR eoa, void *wk )
{
	int frame;
	SPLASH_WORK *work;
	FIELD_OBJ_PTR fldobj;
	
	work = wk;
	fldobj = work->head.fldobj;
	
	if( FE_FldOBJ_CheckSameID(fldobj,work->obj_id,work->zone_id) == FALSE ){
		EOA_Delete( eoa );
		return;
	}
	
	switch( work->seq_no ){
	case 0:													//h
		BLACT_AnmFrameChg( work->act, FX32_ONE );
		frame = BLACT_AnmFrameGetOffs( work->act ) / FX32_ONE;
		
		if( frame >= SPLASH_ANIME_FRAME ){
			EOA_Delete( eoa );
			return;
		}
		
		break;
	}
}

//--------------------------------------------------------------
/**
 * EOA 򖗁@`
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaSplash_Draw( EOA_PTR eoa, void *wk )
{
	VecFx32 vec,d_vec;
	SPLASH_WORK *work;
	FIELD_OBJ_PTR fldobj;
	
	work = wk;
	fldobj = work->head.fldobj;
	
	if( FE_FldOBJ_CheckSameID(fldobj,work->obj_id,work->zone_id) == FALSE ){
		EOA_Delete( eoa );
		return;
	}
	
	FieldOBJ_VecPosGet( fldobj, &vec );
	FieldOBJ_VecDrawOffsGet( fldobj, &d_vec );
	
	vec.x += d_vec.x;
	vec.y += d_vec.y;
	vec.z += d_vec.z;
	vec.z += FX32_ONE * 8;
	BLACT_MatrixSet( work->act, &vec );
}

//==============================================================================
//	data
//==============================================================================
//--------------------------------------------------------------
///	EOA_H
//--------------------------------------------------------------
static const EOA_H_NPP DATA_EoaH_Splash =
{
	SPLASH_WORK_SIZE,
	EoaSplash_Init,
	EoaSplash_Delete,
	EoaSplash_Move,
	EoaSplash_Draw,
};

//--------------------------------------------------------------
///	򖗃Aj
//--------------------------------------------------------------
static const BLACT_ANIME_TBL DATA_BlActAnmTbl_Splash[] =
{
	{ 0, SPLASH_ANIME_FRAME, BLACT_ANIM_END },
	{ 0, 0, BLACT_ANIM_CMD_MAX },
};
