//******************************************************************************
/**
 * 
 * @file	fldeff_trap.c
 * @brief	tB[hOBJ 
 * @author	k.ohno
 * @data	05.11.29
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "field_effect.h"
#include "fieldobj.h"
#include "fldeff_trap.h"

//==============================================================================
//	define
//==============================================================================
//#define DEBUG_TRAP_WRITE_OFF	//`㩕`OFF

//#define TRAP_DRAW_Z_OFFSET (FX32_ONE*(3))
#define TRAP_DRAW_Z_OFFSET (FX32_ONE*(5))			///<㩕`ItZbgZ

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	FE_TRAP\
//--------------------------------------------------------------
typedef struct _TAG_FE_TRAP
{
	int heap_id;
	FE_SYS_PTR fes;
	NNSG3dRenderObj render;
	NNSG3dResMdl *model;
	NNSG3dResFileHeader *res_file;
}FE_TRAP;

#define FE_TRAP_SIZE (sizeof(FE_TRAP)) ///<FE_TRAPTCY

//--------------------------------------------------------------
///	TRAP_ADD_H\
//--------------------------------------------------------------
typedef struct
{
	int init_gx;
	int init_gz;
	FIELDSYS_WORK *fsys;
	FE_SYS_PTR fes;
	FE_TRAP_PTR trap;						///<FE_TRAP_PTR
}TRAP_ADD_H;

#define TRAP_ADD_H_SIZE (sizeof(TRAP_ADD_H)) ///<TRAP_ADD_HTCY

//--------------------------------------------------------------
///	TRAP_WORK\
//--------------------------------------------------------------
typedef struct
{
    int counter;    // 
	int obj_id;									///<㩑ΏOBJID
	int zone_id;								///<㩑Ώۃ][ID
	int vanish_sw;								///<\SW
	TRAP_ADD_H head;							///<ǉTRAP_ADD_H
}TRAP_WORK;

#define TRAP_WORK_SIZE (sizeof(TRAP_WORK))	///<TRAP_WORKTCY

//==============================================================================
//	vg^Cv
//==============================================================================
static FE_TRAP_PTR Trap_AllocMemory( int heap_id );
static void Trap_FreeMemory( FE_TRAP_PTR sd );

static void Trap_GraphicInit( FE_TRAP_PTR sd );
static void Trap_GraphicDelete( FE_TRAP_PTR sd );

static const EOA_H_NPP DATA_EoaH_Trap;

//==============================================================================
//	㩁@VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * 㩏
 * @param	fes		FE_SYS_PTR
 * @param	heap_id	q[vID
 * @retval	FE_TRAP_PTR	FE_TRAP_PTR
 */
//--------------------------------------------------------------
FE_TRAP_PTR FE_Trap_Init( FE_SYS_PTR fes, int heap_id )
{
	FE_TRAP_PTR sd;

	sd = Trap_AllocMemory( heap_id );
	sd->heap_id = heap_id;
	sd->fes = fes;
	
	Trap_GraphicInit( sd );
	
	return( sd );
}

//--------------------------------------------------------------
/**
 * 㩍폜
 * @param	sd		FE_TRAP_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_Trap_Delete( FE_TRAP_PTR sd )
{
	Trap_GraphicDelete( sd );
	Trap_FreeMemory( sd );
}

//==============================================================================
//		p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * 㩃m
 * @param	heap_id		q[vID
 * @retval	FE_TRAP_PTR	mۂFE_TRAP_PTR
 */
//--------------------------------------------------------------
static FE_TRAP_PTR Trap_AllocMemory( int heap_id )
{
	FE_TRAP_PTR sd;
	
	sd = sys_AllocMemory( heap_id, FE_TRAP_SIZE );
	GF_ASSERT( sd != NULL && "Trap_AllocMemory()mێs" );
	
	memset( sd, 0, FE_TRAP_SIZE );
	return( sd );
}

//--------------------------------------------------------------
/**
 * 㩃폜
 * @param	sd	FE_TRAP_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Trap_FreeMemory( FE_TRAP_PTR sd )
{
	sys_FreeMemory( sd->heap_id, sd );
}

//==============================================================================
//	㩁@OtBbN
//==============================================================================
//--------------------------------------------------------------
/**
 *  OtBbN
 * @param	sd	FE_TRAP_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Trap_GraphicInit( FE_TRAP_PTR sd )
{
	NNS_G3dRenderObjInit( &sd->render, sd->model );
	simple_3DModelSet( sd->heap_id, "data/kage.nsbmd",
                       &sd->render, &sd->model, &sd->res_file );
}

//--------------------------------------------------------------
/**
 *  OtBbN폜
 * @param	sd	FE_TRAP_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Trap_GraphicDelete( FE_TRAP_PTR sd )
{
    sys_FreeMemory( sd->heap_id, sd->res_file );
}

//==============================================================================
//	㩁@EOA
//==============================================================================
//--------------------------------------------------------------
/**
 * gbvǉ
 * @param	fldobj		FIELD_OBJ_PTR
 * @retval	EOA_PTR
 */
//--------------------------------------------------------------
EOA_PTR FE_Trap_Add(  FIELDSYS_WORK *fsys, int x, int z, int liveTime )
{
	int param,pri;
	TRAP_ADD_H head;
	FE_SYS_PTR fes;
	VecFx32 mtx;
    EOA_PTR eoa;
	TRAP_WORK *work;
	
    fes = fsys->fes;
	head.fes = fes;
	head.trap = FE_TrapPtrGet( fes );
	head.init_gx = x;
	head.init_gz = z;
	head.fsys = fsys;
	mtx.x = GRID_SIZE_FX32( x ) + (FX32_ONE * 9 );
	mtx.y = 0;
	mtx.z = GRID_SIZE_FX32( z );
	param = 0;
	eoa = FE_EoaAddNpp( fes, &DATA_EoaH_Trap, &mtx, param, &head, 0xff );
	work = EOA_LocalWorkGet( eoa );
    work->counter = liveTime;
    return eoa;
}

//--------------------------------------------------------------
/**
 * EOA 㩁@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	int		TRUE=IBFALSE=ُI
 */
//--------------------------------------------------------------
static int EoaTrap_Init( EOA_PTR eoa, void *wk )
{
	TRAP_WORK *work;
	const TRAP_ADD_H *head;
    VecFx32 vec;
	
	work = wk;
	head = EOA_AddPtrGet( eoa );
	work->head = *head;

	vec.x = GRID_SIZE_FX32( work->head.init_gx ) + (FX32_ONE * 9 );
	vec.z = GRID_SIZE_FX32( work->head.init_gz );
    vec.y = 0;
    
	EOA_MatrixSet( eoa, &vec );

    work->counter = 20;// @@OO test time
    
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * EOA 㩁@폜
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaTrap_Delete( EOA_PTR eoa, void *wk )
{
}

//--------------------------------------------------------------
/**
 * EOA 㩁@
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaTrap_Move( EOA_PTR eoa, void *wk )
{
    TRAP_WORK *work;
	work = wk;

    if(work->counter > 0){
        work->counter--;
        if(work->counter == 0){
            EOA_Delete( eoa );
        }
    }
}

//--------------------------------------------------------------
/**
 * EOA 㩁@`
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void EoaTrap_Draw( EOA_PTR eoa, void *wk )
{
	TRAP_WORK *work;
	
	work = wk;
	
    {
		VecFx32 vec;
		VecFx32 scale = { FX32_ONE, FX32_ONE, FX32_ONE };
		MtxFx33 rot	  = { FX32_ONE, 0,0,0, FX32_ONE, 0,0,0,FX32_ONE};
		
		EOA_MatrixGet( eoa, &vec );
		
		vec.x += -(FX32_ONE * 1) / 2;
		vec.y += -(FX32_ONE * 1);
		vec.z += TRAP_DRAW_Z_OFFSET;
		simple_3DModelDraw_1mat1shape( &work->head.trap->render, &vec, &rot, &scale );
	}
}

//--------------------------------------------------------------
///	EOA_H
//--------------------------------------------------------------
static const EOA_H_NPP DATA_EoaH_Trap =
{
	TRAP_WORK_SIZE,
	EoaTrap_Init,
	EoaTrap_Delete,
	EoaTrap_Move,
	EoaTrap_Draw,
};

