//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		fog_sys.c
 *@brief	tHOVXe
 *@author	tomoya takahashi
 *@data		2005.04.27
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#define __FOG_SYS_H_GLOBAL
#include "common.h"
#include "fog_sys.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
 */
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	tHOf[^\
//=====================================
typedef struct _FOG_DATA{
	BOOL	flag;		// on/offtO----(TRUE / FALSE)
	s32		fog_mode;	// tHO[h----J[ƃAt@ɂ/At@݂̂(0 / 1)
	s32		fog_slope;	// 肮----(0`10)	0<10ŔZł
	int		offset;		// ǂ̃fvXl炩邩

	GXRgb	color;		// tHOJ[
	int alpha;			// (0`31)	BGւ̓ߓx

	char	fog_tbl_data[32];		// RQiK̃tHOe[u	(Zx0`127)
}FOG_DATA;


//----------------------------------------------------------------------------
/**
 *					vg^Cv錾
 */
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
/**
 *					O[oϐ錾
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	tHOf[^ۑ̈쐬
//-------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *@brief	tHOf[^ۑ̈쐬
 *
 *@param	none
 *
 *@return	FOG_DATA_PTR	쐬ꂽtHOf[^ۑ̈
 *
 *
 */
//-----------------------------------------------------------------------------
FOG_DATA_PTR FogSys_Init(void)
{
	FOG_DATA_PTR fog_data;
	fog_data = sys_AllocMemory(HEAPID_FIELD, sizeof(FOG_DATA));
	MI_CpuClear32(fog_data, sizeof(FOG_DATA));

	return fog_data;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	tHOf[^ۑ̈j
 *
 *@param	pFogData	tHOf[^ۑ̈̃|C^wAhX
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void FogSys_Delete(FOG_DATA_PTR* pFogData)
{
	sys_FreeMemory(HEAPID_FIELD, *pFogData);
	*pFogData = NULL;
}

//-------------------------------------
//	̃tHȌԂ擾
//-------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *@brief	ON/OFFtO擾
 *
 *@param	FogData		tHOf[^ۑ̈
 *
 *@return	BOOL	ON:TRUE		OFF:FALSE
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL GetFogFlag(FOG_DATA_PTR FogData)
{
	return FogData->flag;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	tHO[h擾
 *
 *@param	FogData		tHOf[^ۑ̈
 *
 *@return	int			tHO[h
 *
 *
 */
//-----------------------------------------------------------------------------
int GetFogMode(FOG_DATA_PTR FogData)
{
	return FogData->fog_mode;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	tHÔ擾
 *
 *@param	FogData		tHOf[^ۑ̈
 *
 *@return	int			tHÔl
 *
 *
 */
//-----------------------------------------------------------------------------
int GetFogSlope(FOG_DATA_PTR FogData)
{
	return FogData->fog_slope;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	tHÔn߂fvXl擾
 *
 *@param	FogData		tHOf[^ۑ̈
 *
 *@return	int			tHÔn߂fvXl
 *
 *
 */
//-----------------------------------------------------------------------------
int GetFogOffset(FOG_DATA_PTR FogData)
{
	return FogData->offset;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	tHOJ[擾
 *
 *@param	FogData		tHOf[^ۑ̈
 *
 *@return	GXRgb		tHOJ[
 *
 *
 */
//-----------------------------------------------------------------------------
GXRgb GetFogColor(FOG_DATA_PTR FogData)
{
	return FogData->color;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	tHÕl擾
 *
 *@param	FogData		tHOf[^ۑ
 *
 *@return	int			l
 *
 *
 */
//-----------------------------------------------------------------------------
int GetFogAlpha(FOG_DATA_PTR FogData)
{
	return FogData->alpha;
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	tHOe[u擾
 *
 *@param	FogData		tHOf[^ۑ̈
 *
 *@return	const char*	tHOe[u|C^	(vf32ł)
 *
 *
 */
//-----------------------------------------------------------------------------
const char* GetFogTbl(FOG_DATA_PTR FogData)
{
	return FogData->fog_tbl_data;
}

//-------------------------------------
//	tHOf[^ݒ
//-------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *@brief	tHOf[^ۑ̈ɐݒ肵A`ɔf
 *
 *@param	FogData		tHOf[^ۑ̈
 *@param	cont		tO			lύXf[^ނ̒萔bŎw肷FOG_SYS_ALL͑SĐݒ
 *@param	flag		tHOtO
 *@param	fogMode		tHO[h
 *@param	fogSlope	tHÔ
 *@param	offset		tHÔn߂fvXl
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SetFogData(FOG_DATA_PTR FogData, int cont, BOOL flag, int fogMode, int fogSlope, int offset)
{
	if(cont & FOG_SYS_FLAG){
		FogData->flag		= flag;
	}
	if(cont & FOG_SYS_MODE){
		FogData->fog_mode	= fogMode;
	}
	if(cont & FOG_SYS_SLOPE){
		FogData->fog_slope	= fogSlope;
	}
	if(cont & FOG_SYS_OFFSET){
		FogData->offset		= offset;
	}

	G3X_SetFog(FogData->flag,
			FogData->fog_mode,
			FogData->fog_slope,
			FogData->offset);
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	tHOJ[ۑ̈ɐݒ肵A`ɔf
 *
 *@param	FogData		tHOf[^ۑ̈
 *@param	cont		tO			lύXf[^ނ̒萔bŎw肷FOG_SYS_ALL͑SĐݒ
 *@param	color		J[
 *@param	alpha		l
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SetFogColor(FOG_DATA_PTR FogData,int cont,  GXRgb color, int alpha)
{
	if(cont & FOG_SYS_RGB){
		FogData->color = color;
	}
	if(cont & FOG_SYS_ALPHA){
		FogData->alpha = alpha;
	}

	G3X_SetFogColor(FogData->color, FogData->alpha);
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	tHOe[uۑ̈ɐݒ肵A`ɔf
 *
 *@param	FogData			tHOf[^ۑ̈
 *@param	char* fog_tbl	tHOe[u
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SetFogTbl(FOG_DATA_PTR FogData, const char* fog_tbl)
{
	MI_CpuCopy32(fog_tbl, FogData->fog_tbl_data, 32);
	
	G3X_SetFogTable((u32*)FogData->fog_tbl_data);	
}
