//============================================================================================
/**
 * @file	goods_data.c
 * @brief	ObYTCYA蔻̎擾
 * @author	saito
 * @date	2006.02.27
 */
//============================================================================================
#include "goods_data.h"

typedef struct GOOD_SIZZE_INFO_tag
{
	u8 SizeX;
	u8 SizeZ;
	u8 HitData[9];
    u8 shopData[3];
}GOODS_SIZE_INFO;

#include "../fielddata/base_goods/goods_size_info.dat"

//------------------------------------------------------------------
/**
 * @brief	ObY擾
 * @param	inGoodsIndex		ObYio[
 * @return	u8					ObỶ
 */
//------------------------------------------------------------------
const u8 GOODS_GetGoodsSizeX(const int inGoodsIndex)
{
	return 2;//Ƃ肠
	return GoodsSizeInfo[inGoodsIndex].SizeX;
}

//------------------------------------------------------------------
/**
 * @brief	ObYc擾
 * @param	inGoodsIndex		ObYio[
 * @return	u8					ObY̏c
 */
//------------------------------------------------------------------
const u8 GOODS_GetGoodsSizeZ(const int inGoodsIndex)
{
	return 2;//Ƃ肠
	return GoodsSizeInfo[inGoodsIndex].SizeZ;
}

//------------------------------------------------------------------
/**
 * @brief	ObYf[^擾
 * @param	inGoodsIndex		ObYio[
 * @return	u8*					ObY̓f[^̔z擪AhX
 */
//------------------------------------------------------------------
const u8 *GOODS_GetGoodsHitData(const int inGoodsIndex)
{
	return GoodsSizeInfo[inGoodsIndex].HitData;
}

//------------------------------------------------------------------
/**
 * @brief	SHOPł̃ObYގ擾
 * @param	inGoodsIndex		ObYio[
 * @return	StoneType_e
 */
//------------------------------------------------------------------
const u8 GOODS_GetGoodsChangeStoneType(const int inGoodsIndex)
{
	return GoodsSizeInfo[inGoodsIndex].shopData[0];
}
//------------------------------------------------------------------
/**
 * @brief	SHOPł̃ObYŏ[g擾
 * @param	inGoodsIndex		ObYio[
 * @return	carat 1-99
 */
//------------------------------------------------------------------
const u8 GOODS_GetGoodsChangeStoneCaratMin(const int inGoodsIndex)
{
	return GoodsSizeInfo[inGoodsIndex].shopData[1];
}
//------------------------------------------------------------------
/**
 * @brief	SHOPł̃ObYő僌[g擾
 * @param	inGoodsIndex		ObYio[
 * @return	carat 1-99
 */
//------------------------------------------------------------------
const u8 GOODS_GetGoodsChangeStoneCaratMax(const int inGoodsIndex)
{
	return GoodsSizeInfo[inGoodsIndex].shopData[2];
}
