//==============================================================================================
/**
 * @file	guinness_win.c
 * @brief	MlXEBhE
 * @author	Satoshi Nohara
 * @date	2006.03.01
 */
//==============================================================================================
#include "common.h"
#include "gflib/msg_print.h"			//STRCODE
#include "system/msgdata.h"				//MSGMAN_TYPE_DIRECT
#include "system/fontproc.h"
#include "system/snd_tool.h"
#include "system/pm_str.h"
#include "system/bmp_menu.h"
#include "system/bmp_list.h"
#include "system\wordset.h"				//WORDSET_ExpandStr
#include "fieldsys.h"
#include "fieldmap.h"
#include "fld_bmp.h"
#include "talk_msg.h"
#include "guinness_win.h"

#include "msgdata/msg.naix"				//NARC_msg_??_dat

#include "system/window.h"

#include "msgdata/msg.naix"				//NARC_msg_??_dat
#include "msgdata/msg_ev_win.h"			//msg_ev_win_016


//==============================================================================================
//
//	extern錾
//
//==============================================================================================
//BGȂ̂ŁA1̕\͂ȂƎv
//extern u8 MsgSpeedGet(void);


//==============================================================================================
//
//	vg^Cv錾
//
//==============================================================================================
void EventCmd_GuinnessWin( GMEVENT_CONTROL* event, u8 x, u8 y, u8 cursor, u8 cancel, WORDSET* wordset );

static BOOL GMEVENT_GuinnessWin( GMEVENT_CONTROL* event );

static void GuinnessWin_Init( FIELDSYS_WORK* fsys, GUINNESS_WIN_WORK* wk, u8 cancel, WORDSET* wordset );
static void GuinnessWin_Start( GUINNESS_WIN_WORK* wk, u8 x, u8 y, u8 cursor );

static void BmpList_list_make( GUINNESS_WIN_WORK* wk, u32 msg_id, u32 param  );
static void BmpList_h_default_set(GUINNESS_WIN_WORK* wk);
static void	BmpList_CallBack( BMPLIST_WORK* lw, u32 param, u8 y );

static void ListMake_01( GUINNESS_WIN_WORK* wk );
static void talk_msg_print( GUINNESS_WIN_WORK* wk, u16 msg_id, u32 wait );

//eV[PX
static void NextSeqSet( GUINNESS_WIN_WORK* wk, u8 next_seq );
static void seq_list_sub( GUINNESS_WIN_WORK* wk );
static void seq_ranking_sub( GUINNESS_WIN_WORK* wk );
static void seq_yesno_sub( GUINNESS_WIN_WORK* wk );
static void seq_del_sub( GUINNESS_WIN_WORK* wk );
static void seq_end_sub( GUINNESS_WIN_WORK* wk );


//==============================================================================================
//
//	`
//
//==============================================================================================
#define GUINNESS_WIN_FONT		(FONT_SYSTEM)	//tHgw
//#define GUINNESS_WIN_FONT	(FONT_TALK)			//tHgw

#define GUINNESS_WIN_MSG_BUF_SIZE	(32*2)		//bZ[Wobt@TCY

//BMPj[
#define GUINNESS_WIN_MENU_MAX	(12)			//j[ڂ̍ő吔

//BMPXg
#define GUINNESS_WIN_LIST_MAX	(16)			//Xgڂ̍ő吔

//BMPXgwb_[`
#define EV_LIST_LINE			(6)				//\ő區ڐ
#define EV_LIST_RABEL_X			(1)				//x\wW
#define EV_LIST_DATA_X			(12)			//ڕ\wW
#define EV_LIST_LINE_Y			(8)				//\xW

//V[PX`
enum{
	SEQ_LIST,
	SEQ_RANKING,
	SEQ_YESNO,
	SEQ_DEL,
	SEQ_END,
};


//==============================================================================================
//
//	CfbNXu`
//
//==============================================================================================
#define MSG_INDEX_SINGLE_BTL		(msg_ev_win_007)	//uVOogv
#define MSG_INDEX_DOUBLE_BTL		(msg_ev_win_008)	//u_uogv
#define MSG_INDEX_MULTI_BTL			(msg_ev_win_010)	//u}`ogv
#define MSG_INDEX_MULTI_COMM_BTL	(msg_ev_win_010)	//u}`ogv
#define MSG_INDEX_WIFI_BTL			(msg_ev_win_010)	//uWi-Fiogv
#define MSG_INDEX_AVERAGE_WIN		(msg_ev_win_021)	//uւ񂵂傤v
//...
//...
#define MSG_INDEX_FISHING			(msg_ev_win_051)	//u肠v

#define MSG_INDEX_WIN				(msg_ev_win_003)	//u傤v
#define MSG_INDEX_CLOSE				(msg_ev_win_012)	//uƂv
#define MSG_INDEX_START				(msg_ev_win_011)	//uǂ̂񂵂傤낭݂܂Hv
#define MSG_INDEX_DEL				(msg_ev_win_041)	//uĂłHv


//==============================================================================================
//
//	CGX
//
//==============================================================================================
#define GUINNESS_WIN_SX				(20)			//EBhETCY
#define GUINNESS_WIN_SY				(14)			//EBhETCY

//fld_bmp.hQ
enum{
	GUINNESS_LIST_CGX_NUM =		(1),				//1
	GUINNESS_WIN_CGX_NUM =		(MENU_WIN_CGX_NUM),	//473

	GUINNESS_YESNO_CGX_NUM =	(GUINNESS_WIN_CGX_NUM - (FLD_YESNO_WIN_SX * FLD_YESNO_WIN_SY))
	//GUINNESS_YESNO_CGX_NUM =	(FLD_YESNO_WIN_CGX),//277
	//GUINNESS_YESNO_CGX_NUM =	(GUINNESS_LIST_CGX_NUM + GUINNESS_WIN_SX * GUINNESS_WIN_SY),//281
	//GUINNESS_YESNO_CGX_NUM =	(512),
};

#if 0
OS_Printf("CGX_NUM = %d\n",(FLD_YESNO_WIN_CGX) );										//277
OS_Printf("CGX_NUM = %d\n",(GUINNESS_LIST_CGX_NUM+GUINNESS_WIN_SX*GUINNESS_WIN_SY));	//281
OS_Printf("CGX_NUM = %d\n",(FLD_MSG_WIN_CGX) );											//301
OS_Printf("CGX_NUM = %d\n",(MENU_WIN_CGX_NUM) );										//473
#endif


//==============================================================================================
//
//	\
//
//==============================================================================================
struct _GUINNESS_WIN_WORK{
	FIELDSYS_WORK * fsys;						//FIELDSYS_WORK̃|C^

 	GF_BGL_BMPWIN bmpwin;						//BMPEBhEf[^
 	GF_BGL_BMPWIN talk_bmpwin;					//bBMPEBhEf[^
	
	STRBUF* msg_buf[GUINNESS_WIN_MENU_MAX];		//bZ[Wf[^̃|C^
	MSGDATA_MANAGER* msgman;					//bZ[W}l[W[
	WORDSET* wordset;							//PZbg

	u8 seq;										//V[PXio[
	u8 cancel;									//LZ
	u8 list_no;									//j[ڂ̉Ԗڂ
	u8 del_mode;								//폜[htO

	u16 work1;									//[N1
	u16 work2;									//[N2
 
	BMPMENU_WORK* mw;							//u͂EvEBhE

	//BMPXg
	BMPLIST_HEADER ListH;						//BMPXgwb_[
	BMPLIST_WORK* lw;							//BMPXgf[^
	u16 list_bak;								//XgʒuobNAbv
	u16 cursor_bak;								//J[\ʒuobNAbv
	BMPLIST_DATA list_Data[GUINNESS_WIN_LIST_MAX];	//Xgf[^
};

//u͂EvEBhEf[^
static const BMPWIN_DAT YesNoBmpDat = {
	FLD_MBGFRM_FONT, FLD_YESNO_WIN_PX, FLD_YESNO_WIN_PY,
	FLD_YESNO_WIN_SX, FLD_YESNO_WIN_SY, FLD_YESNO_WIN_PAL, GUINNESS_YESNO_CGX_NUM
};


//==============================================================================================
//
//	OĂяo֐	
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	Cxg[R}hFMlXEBhEĂяo
 *
 * @param	x			EBhE\XW
 * @param	y			EBhE\XW
 * @param	cursor		J[\ʒu
 * @param	cancel		BLZtO(TRUE=LAFALSE=)
 * @param	wordset		WORDSET^̃|C^
 * @param	talk_bmpwin	GF_BGL_BMPWIN^̃|C^(bBMPWINn)
 *
 * @retval	none
 */
//--------------------------------------------------------------
void EventCmd_GuinnessWin( GMEVENT_CONTROL* event, u8 x, u8 y, u8 cursor, u8 cancel, WORDSET* wordset )
{
	GUINNESS_WIN_WORK* wk;
	FIELDSYS_WORK* fsys = FieldEvent_GetFieldSysWork(event);

	//Jn
	Snd_SePlay( SE_GUINNESS_WIN_START );

	wk = sys_AllocMemory( HEAPID_FIELD, sizeof(GUINNESS_WIN_WORK) );
	if( wk == NULL ){
		GF_ASSERT( (0) && "MlXEBhEmێsI" );
		return;	//Ȃ
	}
	memset( wk, 0, sizeof(GUINNESS_WIN_WORK) );

	//[N	
	GuinnessWin_Init( fsys, wk, cancel, wordset );

	//brbg}bvEBhEf[^ǉ
	FldTalkBmpAdd( wk->fsys->bgl, &wk->talk_bmpwin ,FLD_MBGFRM_FONT);
	FldTalkWinPut( &wk->talk_bmpwin );
	talk_msg_print( wk, MSG_INDEX_START, MSG_ALLPUT );

	//Xg쐬
	ListMake_01( wk );

	//BmpList_list_make( wk, MSG_INDEX_WIN, 0 );

	GuinnessWin_Start( wk, x, y, cursor );

	FieldEvent_Call( event, GMEVENT_GuinnessWin, wk );
	return;
}


//==============================================================================================
//
//
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	CxgEBhE@[N
 *
 * @param	wk			GUINNESS_WIN_WORK^̃|C^
 * @param	cancel		BLZtO(TRUE=LAFALSE=)
 * @param	wordset		WORDSET^̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void GuinnessWin_Init( FIELDSYS_WORK* fsys, GUINNESS_WIN_WORK* wk, u8 cancel, WORDSET* wordset )
{
	int i;

	//bZ[Wf[^}l[W[쐬
	wk->msgman = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, 
									NARC_msg_ev_win_dat, HEAPID_FIELD );

	//PZbgW[쐬
	wk->wordset = WORDSET_Create( HEAPID_FIELD );
	//wk->wordset	= wordset;		//XNvgp

	wk->fsys		= fsys;
	wk->cancel		= cancel;
	wk->list_no		= 0;

	for( i=0; i < GUINNESS_WIN_LIST_MAX ;i++ ){
		wk->list_Data[i].str	= NULL;
		wk->list_Data[i].param	= 0;
	}

	//MSGMAN_Creatěɏ
	for( i=0; i < GUINNESS_WIN_MENU_MAX ;i++ ){
		wk->msg_buf[i] = STRBUF_Create( GUINNESS_WIN_MSG_BUF_SIZE, HEAPID_FIELD );
	}

	return;
}

//--------------------------------------------------------------
/**
 * @brief	BMPXg@Jn
 *
 * @param	wk			GUINNESS_WIN_WORK^̃|C^
 * @param	x			EBhE\XW
 * @param	y			EBhE\XW
 * @param	cursor		J[\ʒu
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void GuinnessWin_Start( GUINNESS_WIN_WORK* wk, u8 x, u8 y, u8 cursor )
{
	//\ő區ڐ`FbN
	GF_BGL_BmpWinAdd( wk->fsys->bgl, &wk->bmpwin, FLD_MBGFRM_FONT, x, y, 
									GUINNESS_WIN_SX, GUINNESS_WIN_SY, 
									FLD_SYSFONT_PAL, GUINNESS_LIST_CGX_NUM );


	//ƂőΉ
	//xTCY͕\ڐȂƂ́AςɂȂI

	//j[EBhẼOtBbNZbg(409-511gp)
	MenuWinGraphicSet(
		wk->fsys->bgl, FLD_MBGFRM_FONT, GUINNESS_WIN_CGX_NUM, MENU_WIN_PAL, 0, HEAPID_FIELD );

	//j[EBhE`
	BmpMenuWinWrite(&wk->bmpwin, WINDOW_TRANS_OFF, GUINNESS_WIN_CGX_NUM, MENU_WIN_PAL);

	//Xgwb_[ݒ
	BmpList_h_default_set(wk);

	wk->lw = BmpListSet( (const BMPLIST_HEADER*)&wk->ListH, 0, cursor, HEAPID_FIELD );

	return;
}

//--------------------------------------------------------------
/**
 * @brief	BMPXg	Xg쐬
 *
 * @param	wk			GUINNESS_WIN_WORK^̃|C^
 * @param	msg_id		bZ[WID
 * @param	param		BMPLISTp[^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void BmpList_list_make( GUINNESS_WIN_WORK* wk, u32 msg_id, u32 param  )
{
	int i;
	void* msg;

	SDK_ASSERTMSG( wk->list_no < GUINNESS_WIN_LIST_MAX, "XgڐI[o[I" );

	MSGMAN_GetString( wk->msgman, msg_id, wk->msg_buf[wk->list_no] );
	wk->list_Data[ wk->list_no ].str = (const void *)wk->msg_buf[wk->list_no];
	//*st = (const void *)&wk->msg_buf[wk->list_no][0];

	if( param == GUINNESS_WIN_LIST_LABEL ){
		wk->list_Data[ wk->list_no ].param = BMPLIST_RABEL;
		//*pa = BMPLIST_RABEL;
	}else{
		wk->list_Data[ wk->list_no ].param = param;
		//*pa = param;
	}

	wk->list_no++;

	return;
}

//--------------------------------------------------------------
/**
 * @brief	BMPXg	wb_[ݒ
 *
 * @param	wk			GUINNESS_WIN_WORK^̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void BmpList_h_default_set(GUINNESS_WIN_WORK* wk)
{
	wk->ListH.list		= wk->list_Data;
	wk->ListH.call_back = NULL;
	wk->ListH.icon		= BmpList_CallBack;
	wk->ListH.win		= &wk->bmpwin;

	wk->ListH.count		= wk->list_no;
	wk->ListH.line		= EV_LIST_LINE;

	wk->ListH.rabel_x	= EV_LIST_RABEL_X;
	wk->ListH.data_x	= EV_LIST_DATA_X;
	wk->ListH.cursor_x	= 0;
	wk->ListH.line_y	= EV_LIST_LINE_Y;

	wk->ListH.f_col		= FBMP_COL_BLACK;
	wk->ListH.b_col		= FBMP_COL_WHITE;		
	wk->ListH.s_col		= FBMP_COL_BLK_SDW;

	wk->ListH.msg_spc	= 0;
	wk->ListH.line_spc	= 16;
	wk->ListH.page_skip	= BMPLIST_LRKEY_SKIP;
	wk->ListH.font		= GUINNESS_WIN_FONT;
	wk->ListH.c_disp_f	= 0;

	return;
}

//--------------------------------------------------------------
/**
 * @brief	XgVXẽR[obNs\
 *
 * @param	lw			BMPLIST_WORK^̃|C^
 * @param	param		I^[p[^
 * @param	y			
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void	BmpList_CallBack(BMPLIST_WORK* lw,u32 param,u8 y)
{
	if( param == BMPLIST_RABEL ){
		BmpListTmpColorChange( lw, FBMP_COL_RED, FBMP_COL_WHITE, FBMP_COL_RED_SDW );
	}else{
		BmpListTmpColorChange( lw, FBMP_COL_BLACK, FBMP_COL_WHITE, FBMP_COL_BLK_SDW );
	}

	return;
}

//--------------------------------------------------------------
/**
 * @brief	CxgC
 *
 * @param	event		GMEVENT_CONTROL^̃|C^
 *
 * @retval	"FALSE=pATRUE=I"
 */
//--------------------------------------------------------------
static BOOL GMEVENT_GuinnessWin( GMEVENT_CONTROL* event )
{
	u32	ret;
	GUINNESS_WIN_WORK* wk = FieldEvent_GetSpecialWork(event);

	switch( wk->seq ){

	//Xg(ڂI)
	case SEQ_LIST:
		seq_list_sub( wk );
		break;

	//LO
	case SEQ_RANKING:
		seq_ranking_sub( wk );
		break;

	//u͂EvI
	case SEQ_YESNO:
		seq_yesno_sub( wk );
		break;

	//폜
	case SEQ_DEL:
		seq_del_sub( wk );
		break;

	//I
	case SEQ_END:
		seq_end_sub( wk );
		sys_FreeMemoryEz( wk );
		return TRUE;			//II
	};

	return FALSE;
};


//==============================================================================================
//
//	eV[PX
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	V[PX	Zbg
 *
 * @param	wk			GUINNESS_WIN_WORK^̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void NextSeqSet( GUINNESS_WIN_WORK* wk, u8 next_seq )
{
	wk->seq = next_seq;
	return;
}

//--------------------------------------------------------------
/**
 * @brief	V[PX	Xg
 *
 * @param	wk			GUINNESS_WIN_WORK^̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void seq_list_sub( GUINNESS_WIN_WORK* wk )
{
	u32 ret = BmpListMain( wk->lw );

	switch( ret ){

	case BMPLIST_NULL:
		break;

	case BMPLIST_CANCEL:
		NextSeqSet( wk, SEQ_END );
		break;

	default:
		wk->work1 = ret;						//Il[Nɑ
		NextSeqSet( wk, SEQ_RANKING );
		break;;
	};

	return;
}

//--------------------------------------------------------------
/**
 * @brief	V[PX	LO
 *
 * @param	wk			GUINNESS_WIN_WORK^̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void seq_ranking_sub( GUINNESS_WIN_WORK* wk )
{
	u32 ret;

	if( sys.trg & PAD_BUTTON_SELECT ){
		wk->del_mode = 1;					//폜[hON
		return;
	}

	ret = BmpListMain( wk->lw );

	switch( ret ){

	case BMPLIST_NULL:
		break;

	case BMPLIST_CANCEL:
		if( wk->del_mode == 1 ){;
			wk->del_mode = 0;				//폜[hOFF
		}

		NextSeqSet( wk, SEQ_LIST );
		break;

	default:
		//폜[hON
		if( wk->del_mode == 1 ){;
			wk->work1 = ret;				//Il[Nɑ

			wk->mw = BmpYesNoSelectInit( wk->fsys->bgl, &YesNoBmpDat, 
											GUINNESS_WIN_CGX_NUM, MENU_WIN_PAL, HEAPID_FIELD );

			talk_msg_print( wk, MSG_INDEX_DEL, MSG_ALLPUT );

			NextSeqSet( wk, SEQ_YESNO );
		}
		break;
	};

	return;
}

//--------------------------------------------------------------
/**
 * @brief	V[PX	u͂Ev
 *
 * @param	wk			GUINNESS_WIN_WORK^̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void seq_yesno_sub( GUINNESS_WIN_WORK* wk )
{
	u32 ret  = BmpYesNoSelectMain( wk->mw, HEAPID_FIELD );

	if( ret == 0 ){								//͂
		NextSeqSet( wk, SEQ_DEL );
	}else if( ret == BMPMENU_CANCEL ){			//ALZ
		NextSeqSet( wk, SEQ_RANKING );
	}

	return;
}

//--------------------------------------------------------------
/**
 * @brief	V[PX	폜
 *
 * @param	wk			GUINNESS_WIN_WORK^̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void seq_del_sub( GUINNESS_WIN_WORK* wk )
{
	//IĂf[^폜
	//

	//f[^\[g
	//
		
	//ĕ`
	//
		
	NextSeqSet( wk, SEQ_RANKING );

	return;
}

//--------------------------------------------------------------
/**
 * @brief	V[PX	I
 *
 * @param	wk			GUINNESS_WIN_WORK^̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void seq_end_sub( GUINNESS_WIN_WORK* wk )
{
	int i;

	Snd_SePlay( SE_DECIDE );	//ӁI

	//bEBhEI
	BmpTalkWinClear( &wk->talk_bmpwin, WINDOW_TRANS_ON );
	GF_BGL_BmpWinDel( &wk->talk_bmpwin );

	//XgI
	BmpListExit( wk->lw, NULL, NULL );
	BmpMenuWinClear( wk->ListH.win, WINDOW_TRANS_ON );
	GF_BGL_BmpWinDel( &wk->bmpwin );

	for( i=0; i < GUINNESS_WIN_MENU_MAX ;i++ ){
		STRBUF_Delete( wk->msg_buf[i] );
	}

	WORDSET_Delete( wk->wordset );
	MSGMAN_Delete( wk->msgman );

	return;
}


//==============================================================================================
//
//
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	bEBhEɃbZ[Wꊇ\
 *
 * @param	wk			GUINNESS_WIN_WORK^̃AhX
 * @param	msg_id		bZ[WID
 * @param	wait		bZ[WEFCg
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void talk_msg_print( GUINNESS_WIN_WORK* wk, u16 msg_id, u32 wait )
{
	STRBUF* tmp_buf = STRBUF_Create( GUINNESS_WIN_MSG_BUF_SIZE, HEAPID_FIELD );
	STRBUF* tmp_buf2= STRBUF_Create( GUINNESS_WIN_MSG_BUF_SIZE, HEAPID_FIELD );

	//bZ[WNA
	GF_BGL_BmpWinDataFill( &wk->talk_bmpwin, (FBMP_COL_WHITE) );

	MSGMAN_GetString( wk->msgman, msg_id, tmp_buf );

	//o^ꂽPgĕWJ
	WORDSET_ExpandStr( wk->wordset, tmp_buf2, tmp_buf );

	GF_STR_PrintSimple( &wk->talk_bmpwin, FONT_TALK, tmp_buf2, 0, 0, wait, NULL );

	STRBUF_Delete( tmp_buf );
	STRBUF_Delete( tmp_buf2 );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	\邩`FbNăXg쐬01
 *
 * @param	wk			GUINNESS_WIN_WORK^̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void ListMake_01( GUINNESS_WIN_WORK* wk )
{
	//VOogA
	if( 1 ){
		BmpList_list_make( wk, MSG_INDEX_SINGLE_BTL, 0 );
	}

	//_uogA
	if( 1 ){
		BmpList_list_make( wk, MSG_INDEX_DOUBLE_BTL, 1 );
	}

	//}`ogA
	if( 1 ){
		BmpList_list_make( wk, MSG_INDEX_MULTI_BTL, 2 );
	}

	//ʐM}`ogA
	if( 1 ){
		BmpList_list_make( wk, MSG_INDEX_MULTI_COMM_BTL, 3 );
	}

	//Wi-FiogA
	if( 1 ){
		BmpList_list_make( wk, MSG_INDEX_WIFI_BTL, 4 );
	}

	//og^[ϘAA
	if( 1 ){
		BmpList_list_make( wk, MSG_INDEX_AVERAGE_WIN, 5 );
	}

	BmpList_list_make( wk, MSG_INDEX_CLOSE, 6 );			//uƂv
	return;
}


