//============================================================================================
/**
 * @file	haight_check.c
 * @brief	擾֘A
 * @author	Nozomu Saito
 * @date	2005.05.06
 */
//============================================================================================
#include "common.h"
#include "height.h"
#include "../debug_saito.h"
#define MAX_GET_POL	(10)

#define GRID_ENTRY_ONE_DATA	(2)	//2oCgf[^24oCg
#define LINE_ONE_DATA	(5)		//2oCgf[^510oCg
#define Z_VAL_OFFSET_L(data_idx)	( data_idx*LINE_ONE_DATA+1 )
#define Z_VAL_OFFSET_H(data_idx)	( data_idx*LINE_ONE_DATA+2 )

#define LINE_Z_VAL(list,idx)	( (list[Z_VAL_OFFSET_H(data_idx)]<<16) | list[Z_VAL_OFFSET_L(data_idx)] )

static BOOL	BinSearch(const u16 *inDataList,const u16 inDataSize,const fx32 inZ_Val,u16 *outIndex);

static const BOOL GetVertexEqualHeight(const VecFx32 *inTarget,
										const VecFx32 *inVec1,
										const VecFx32 *inVec2,
										const VecFx32 *inVec3,
										fx32 *outHeight);
static const BOOL GetEdgeEqualHeightXZFlat(	const VecFx32 *inTarget,
											const VecFx32 *inVec1,
											const VecFx32 *inVec2,
											const VecFx32 *inVec3,
											fx32 *outHeight);


//static int FirstIdx;
/**
 
*/
//---------------------------------------------------------------------------------------------------------
/**
 *	ΖʂoƂ̈ړ␳B
 *	ΖʂoƂ́AnړƂړʂ
 *	@param	inMoveVal		ړ
 *	@param	inNewVec		W
 *	@param	inOldVec		ݍW
 *
 *	@retval	VecFx32			Cړʁiړj
*/
//---------------------------------------------------------------------------------------------------------
VecFx32 MoveRevise(fx32 inMoveVal,VecFx32 inNewVec,VecFx32 inOldVec)
{
	VecFx32 vec,dstVec;
	VecFx32 dmyVec = {0,0,0};
	
	VEC_Subtract(&inNewVec,&inOldVec,&vec);
	VEC_Normalize(&vec, &vec);
	VEC_MultAdd(inMoveVal,&vec,&dmyVec,&dstVec);
	
	return dstVec;
}

//---------------------------------------------------------------------------------------------------------
/**
 *	|SCfbNX|S_f[^擾
 *	@param	inMAp3DInfo		}bv		
 *	@param	inIdx			|Sf[^CfbNX
 *	@param	outVertex		_f[^i[|C^
 *	
 *	@retval	none
*/
//---------------------------------------------------------------------------------------------------------
static void GetPolygonVertex(MHI_CONST_PTR inMap3DInfo, u16 inIdx, VecFx32 *outVertex)
{
	outVertex[0] = inMap3DInfo->VertexArray[inMap3DInfo->PolygonData[inIdx].vtx_idx0];
	outVertex[1] = inMap3DInfo->VertexArray[inMap3DInfo->PolygonData[inIdx].vtx_idx1];
	outVertex[2] = inMap3DInfo->VertexArray[inMap3DInfo->PolygonData[inIdx].vtx_idx2];
}


//---------------------------------------------------------------------------------------------------------
/**
 *	|SCfbNX|S̖@擾
 *	@param	inMAp3DInfo		}bv		
 *	@param	inIdx			|Sf[^CfbNX
 *	@param	outVertex		@f[^i[|C^
 *	
 *	@retval	none
*/
//---------------------------------------------------------------------------------------------------------
static void GetPolygonNrm(MHI_CONST_PTR inMap3DInfo, u16 inIdx, VecFx32 *outVertex)
{
	*outVertex = inMap3DInfo->NormalArray[inMap3DInfo->PolygonData[inIdx].nrm_idx];
}


/**
\[gpz̏
*/
static void InitArray(HEIGHT_ARRAY *outArray)
{
	int i;
	for(i=0;i<MAX_GET_POL;i++){
		outArray[i].Height = 0;
		outArray[i].Prev = -1;
		outArray[i].Next = -1;
	}
}

/**
 zf[^̃\[g()
*/
static void SortArray(int inCount, HEIGHT_ARRAY *ioArray)
{
	int i;
	int prev;
	for(i=0;i<=inCount-1;i++){
		if (ioArray[i].Height<ioArray[inCount].Height){
			prev = ioArray[i].Prev;
			ioArray[i].Prev = inCount;
			ioArray[inCount].Next = i;
			ioArray[inCount].Prev = prev;
			if (prev>=0){
				ioArray[prev].Next = inCount;
			}
			//FirstIdx = inCount;
			return;
		}else{
			ioArray[inCount].Prev = i;
			ioArray[i].Next = inCount;
		}
	}
	if (inCount>0){
		ioArray[inCount].Next = ioArray[i].Next;
		ioArray[i].Next = inCount;
		ioArray[inCount].Prev = i;
	}
	return;
}

//
//---------------------------------------------------------------------------------------------------------
/**
 *@Z\[gĂf[^2T
 *	@param	inDataList		f[^Xg		
 *	@param	inDataSize		f[^TCY
 *	@param	inZ_Val			Zl
 *	@param	outIndex		f[^CfbNX
 *	
 *	@retval	BOOL	TRUE:f[^@FALSE:f[^
*/
//---------------------------------------------------------------------------------------------------------
static BOOL	BinSearch(const u16 *inDataList,const u16 inDataSize,const fx32 inZ_Val,u16 *outIndex)
{
	int min,max; 
	u32 data_idx;
	fx32 z_val;
	if (inDataSize == 0){
		OS_Printf("Z\[gf[^܂\n");
		return FALSE;//f[^ȂȂ̂ŁATI
	}else if (inDataSize == 1){
		*outIndex = 0;//TI
		return TRUE;
	}

	min = 0;
	max = inDataSize-1;
	data_idx = max/2;
	
	do{
///OS_Printf("min_max:%d,%d\n",min,max);		
		z_val = LINE_Z_VAL(inDataList,data_idx);
///OS_Printf("%d z_val:%x\n",data_idx,z_val);
		if (z_val>inZ_Val){	//Tp
			if (max-1 > min){
				max = data_idx;
				data_idx = (min+max)/2;
			}else{				//TI
				*outIndex = data_idx;
				return TRUE;
			}
		}else{					//Tp
			if (min+1 < max){
				min = data_idx;
				data_idx = (min+max)/2;
			}else{				//TI
				*outIndex = data_idx+1;
				return TRUE;
			}
		}
	}while(1);

	return FALSE;
	//fobOF~菈
	
	;
}


//-擾̑܂Ȑ-
//݂̂wCyl番ObhCfbNX擾
//ObhCfbNXΏۃ|SCfbNXXg(Obh̒ɓĂ|S̃Xg)擾
//XgTCY擾A̕[v
//|Sf[^V[PXANZX
//OsAqbgAzɃ|SCfbNXo^
//z񂩂Af[^擾i\[gɑΉ\j

/**
 
*/
//---------------------------------------------------------------------------------------------------------
/**
 *	wyW獂擾
 *	@param	*inTarget		ݍWixl͖j		
 *	@param	*outY			߂i[fx32^|C^
 *	
 *	@retval	BOOL			TRUE:擾ł	FALSE:擾łȂ
*/
//---------------------------------------------------------------------------------------------------------
BOOL GetHeight(const VecFx32 *inTarget, fx32 *outY)
{
#if 0	
	VecFx32 vertex[3];
	VecFx32 target,nrm;
	fx32 temp1,temp2;
	BOOL result;
	u16 i,pol_index;
	fx32 d,y;
	int pol_count;
	int tbl_size,tbl_idx,tbl_x_idx,tbl_z_idx;
	HEIGHT_ARRAY height_array[MAX_GET_POL];
	fx32 tbl_x,tbl_z;

	MAP_3D_INFO				map_3d_info;
	
	result = FALSE;
	target = *inTarget;
	target.y = 0;
	pol_count = 0;
	InitArray(height_array);

	//Tvf[^Zbg
	{
		map_3d_info.SceneSplit = &maptest04_SceneSplit;		//Obh
		map_3d_info.BoxParam = maptest04_BoxParam;			//1Obh̏
		map_3d_info.PolygonParam = maptest04_PolygonParam;	//|Sf[^
		map_3d_info.VertexArray = maptest04_VtxArray;		//}bv̒_f[^
		map_3d_info.NormalArray = maptest04_Normal;			//|S̖@f[^
	}
/**	
	{
		BOOL    open_is_ok;
		FSFile file;
		int test_buf;
		int res;
		const char  path[] = {"/data/test.txt"};
		FS_InitFile(&file);
		open_is_ok = FS_OpenFile( &file, path );
		OS_Printf("FS_OpenFile(\"%s\") ... %s!\n", path, open_is_ok ? "OK" : "ERROR");

		if (open_is_ok== TRUE){
			test_buf = 256;
			res = FS_WriteFile(&file, path, 1);
			OS_Printf("%d\n", res);
			FS_CloseFile( &file );
		}
	}
*/
	//{e[uo
	tbl_x = inTarget->x - map_3d_info.SceneSplit->start.x;
	if (tbl_x < 0){
		tbl_x = 0;
	}
	tbl_z = inTarget->z - map_3d_info.SceneSplit->start.z;
	if (tbl_z < 0){
		tbl_z = 0;
	}

	tbl_x = FX_Div(tbl_x, map_3d_info.SceneSplit->size.x);
	tbl_x_idx = (int)(tbl_x>>12);
	if (tbl_x_idx >= map_3d_info.SceneSplit->sub.v0){
		tbl_x_idx = map_3d_info.SceneSplit->sub.v0-1;
	}
	tbl_z = FX_Div(tbl_z, map_3d_info.SceneSplit->size.z);
	tbl_z_idx = (int)(tbl_z>>12);
	if (tbl_z_idx >= map_3d_info.SceneSplit->sub.v2){
		tbl_z_idx = map_3d_info.SceneSplit->sub.v2-1;
	}

	tbl_idx = tbl_x_idx + (tbl_z_idx * map_3d_info.SceneSplit->sub.v2);
	tbl_size = map_3d_info.BoxParam[tbl_idx].num;

	//FirstIdx = 0;
	
	//擾pObhf[^ɓo^Ăf[^[vāAĂ|So
	for(i=0;i<tbl_size;i++){
		pol_index = map_3d_info.BoxParam[tbl_idx].pList[i];
		//_f[^擾
		GetPolygonVertex(&map_3d_info,pol_index, vertex);
		//ZXʂɎˉe
		vertex[0].y = 0;
		vertex[1].y = 0;
		vertex[2].y = 0;
		//Op`̓O
		result = BG3D_CheckTriangleIO(&target,vertex[0],vertex[1],vertex[2]);
		if (result == TRUE){//Op`
			//@擾
			GetPolygonNrm(&map_3d_info,pol_index, &nrm);
			//ʂ̕ɕKvȃf[^i_ʂ镽ʂ̃ItZbgj擾
			d = map_3d_info.PolygonParam[pol_index].paramD;
			//ʂ̕荂擾
			y = -(FX_Mul(nrm.x, target.x)+FX_Mul(nrm.z, target.z)+d);
			y = FX_Div(y, nrm.y);
			height_array[pol_count].Height = y;
			//z̃\[gisł͋@\Ă܂BΉ\j
			SortArray(pol_count,height_array);
			pol_count++;
			if (pol_count >= MAX_GET_POL){
				break;
			}
			///break;
		}
	}

	if (pol_count > 1){//|Sf[^ꂽƂ
		pol_index = 0;
		temp1 = Max(inTarget->y,height_array[0].Height) - Min(inTarget->y,height_array[0].Height);
		//ׂẴ|Sf[^̍߁A݂̍Ɉԋ߂Io
		for(i=1;i<pol_count;i++){
			temp2 = Max(inTarget->y,height_array[i].Height) - Min(inTarget->y,height_array[i].Height);
			if (temp1>temp2){
				temp1 = temp2;
				pol_index = i;
			}
		}
		*outY = height_array[pol_index].Height;
		return TRUE;
	}else if(pol_count == 1){
		*outY = height_array[0].Height;
		return TRUE;
	}
#if 1	
	if (pol_count != 0){
		*outY = height_array[0].Height;
		return TRUE;
	}
#endif	
	return FALSE;
#endif
	return FALSE;
}

//---------------------------------------------------------------------------------------------------------
/**
 *	wyW獂擾
 *	@param	*inTarget		ݍWixl͖j		
 *	@param	*outY			߂i[fx32^|C^
 *	
 *	@retval	BOOL			TRUE:擾ł	FALSE:擾łȂ
*/
//---------------------------------------------------------------------------------------------------------
BOOL GetHeight2(const VecFx32 *inTarget, fx32 *outY)
{
	return FALSE;
}


//---------------------------------------------------------------------------------------------------------
/**
 *	wyW獂擾(r{[hpɕ␳Łj
 *  n`ɖĂ܂Ȃ悤Ɏۂ̍WWYĔ肵Ă܂
 *
 *	@param	*inTarget		ݍWixl͖j		
 *	@param	*outY			߂i[fx32^|C^
 *	
 *	@retval	BOOL			TRUE:擾ł	FALSE:擾łȂ
*/
//---------------------------------------------------------------------------------------------------------
BOOL GetHeight3(const VecFx32 *inTarget, fx32 *outY)
{
	return FALSE;
}

//---------------------------------------------------------------------------------------------------------
/**
 *	擾
 *
 *	@param	inNowY			YW	
 *	@param	inX				߂XW
 *	@param	inZ				߂ZW
 *	@param	inMap3DInfo		
 *	@param	outY			i[obt@
 *	
 *	@retval	BOOL			TRUE:擾ł	FALSE:擾łȂ
*/
//---------------------------------------------------------------------------------------------------------
BOOL GetHeightForBlock(const fx32 inNowY, const fx32 inX, const fx32 inZ, MHI_CONST_PTR inMap3DInfo,fx32 *outY)
{
	VecFx32 vertex[3];
	VecFx32 target,nrm;
	fx32 temp1,temp2;
	BOOL result;
	u16 i,pol_index;
	fx32 d,y;
	int pol_count;
	u32 line_num,tbl_idx,tbl_x_idx,tbl_z_idx;
	HEIGHT_ARRAY height_array[MAX_GET_POL];
	fx32 tbl_x,tbl_z;

	u32 offset_idx;

	u16 line_data_idx;
	u16 line_index;
	u16 polygon_num;

	const u16 *line_list;

	if (inMap3DInfo->DataValid == FALSE){
		return FALSE;
	}
	///OS_Printf_saitou("grid_%x,%x\n",inX,inZ);
	result = FALSE;
	//ZXʂɎˉe
	target.x = inX;
	target.y = 0;
	target.z = inZ;
	pol_count = 0;
	InitArray(height_array);
	//{e[uo
	tbl_x = inX - inMap3DInfo->SplitGridData->StartX;
	if (tbl_x < 0){
		tbl_x = 0;
	}
	tbl_z = inZ - inMap3DInfo->SplitGridData->StartZ;
	if (tbl_z < 0){
		tbl_z = 0;
	}

	tbl_x = FX_Div(tbl_x, inMap3DInfo->SplitGridData->SizeX);
	tbl_x_idx = (int)(tbl_x>>12);
	if (tbl_x_idx >= inMap3DInfo->SplitGridData->NumX){
		tbl_x_idx = inMap3DInfo->SplitGridData->NumX-1;
	}
	tbl_z = FX_Div(tbl_z, inMap3DInfo->SplitGridData->SizeZ);
	tbl_z_idx = (int)(tbl_z>>12);
	if (tbl_z_idx >= inMap3DInfo->SplitGridData->NumZ){
		tbl_z_idx = inMap3DInfo->SplitGridData->NumZ-1;
	}

	tbl_idx = tbl_x_idx + (tbl_z_idx * inMap3DInfo->SplitGridData->NumZ);
	line_num = inMap3DInfo->GridDataTbl[tbl_idx*GRID_ENTRY_ONE_DATA];
	line_data_idx = inMap3DInfo->GridDataTbl[tbl_idx*GRID_ENTRY_ONE_DATA+1];
#if 1	
///OS_Printf("grid_index:%d\n",tbl_idx);
///OS_Printf("line_data_idx = %d\n",line_data_idx);
///OS_Printf("line_num = %d\n",line_num);
#endif
	line_list = &inMap3DInfo->LineDataTbl[line_data_idx*LINE_ONE_DATA];
	//擾pObhf[^ɓo^Ă郉Cf[^2TāAĂ|S݂郉Co
	if ( BinSearch(line_list,line_num,target.z,&line_index)==FALSE){
///OS_Printf("NOTHING\n");		
		return FALSE;
	}
///OS_Printf("line_index = %d\n",line_index);

	polygon_num = line_list[line_index*LINE_ONE_DATA];
///OS_Printf("polygon_num = %d\n",polygon_num);
	offset_idx = (line_list[(line_index*LINE_ONE_DATA)+4]<<16) | line_list[(line_index*LINE_ONE_DATA)+3];

///OS_Printf("offset_idx:%d\n",offset_idx);

	//擾pObhCf[^ɓo^Ăf[^[vāAĂ|So
	for(i=0;i<polygon_num;i++){
				pol_index = inMap3DInfo->PolyIDList[offset_idx+i];
///OS_Printf("pol_index:%d\n",pol_index);
		//_f[^擾
		GetPolygonVertex(inMap3DInfo,pol_index, vertex);
		//ZXʂɎˉe
		vertex[0].y = 0;
		vertex[1].y = 0;
		vertex[2].y = 0;
		//Op`̓O
		///result = BG3D_CheckTriangleIO(&target,vertex[0],vertex[1],vertex[2]);
		result = BG3D_CheckTriangleIObyZX(target,vertex[0],vertex[1],vertex[2]);
		if (result == TRUE){//Op`
			//@擾
			GetPolygonNrm(inMap3DInfo,pol_index, &nrm);
			//ʂ̕ɕKvȃf[^i_ʂ镽ʂ̃ItZbgj擾
			d = inMap3DInfo->PolygonData[pol_index].paramD;
			//ʂ̕荂擾
			y = -(FX_Mul(nrm.x, target.x)+FX_Mul(nrm.z, target.z)+d);
			y = FX_Div(y, nrm.y);
			height_array[pol_count].Height = y;
			//z̃\[gisł͋@\Ă܂BΉ\j
			///SortArray(pol_count,height_array);
			pol_count++;
///OS_Printf("%d\n",i);
///OS_Printf("D=%d\n",d);
			if (pol_count >= MAX_GET_POL){
				break;
			}
			///break;
		}
	}//end for
	

	if (pol_count > 1){//|Sf[^ꂽƂ
///OS_Printf("!!\n");		
		pol_index = 0;
		temp1 = Max(inNowY,height_array[0].Height) - Min(inNowY,height_array[0].Height);
		//ׂẴ|Sf[^̍߁A݂̍Ɉԋ߂Io
		for(i=1;i<pol_count;i++){
			temp2 = Max(inNowY,height_array[i].Height) - Min(inNowY,height_array[i].Height);
			if (temp1>temp2){
				temp1 = temp2;
				pol_index = i;
			}
		}
		*outY = height_array[pol_index].Height;
		return TRUE;
	}else if(pol_count == 1){
		*outY = height_array[0].Height;
		return TRUE;
	}
	OS_Printf("Ȃ\n");
#if 1	
	if (pol_count != 0){
		*outY = height_array[0].Height;
		return TRUE;
	}
#endif	
	return FALSE;
}

#ifdef PM_DEBUG

#define EQ_NO	(0)
#define EQ_12	(1)
#define EQ_23	(2)
#define EQ_31	(3)

//---------------------------------------------------------------------------------------------------------
/**
 *	2DʂɂāAwR_̂AQ_Ɠ`FbNi꒼ɂ邩`FbNj
 *
 *	@param	inTarget			wW	
 *	@param	inVal1				W1
 *	@param	inVal2				W2
 *	@param	inVal3				W3
 *	@param	outEqual			ʂi[obt@
 *	
 *	@retval	BOOL			TRUE:꒼		FALSE:꒼ł͂Ȃ
*/
//---------------------------------------------------------------------------------------------------------
static const BOOL Check2DLine(	const fx32 *inTarget,
								const fx32 *inVal1,
								const fx32 *inVal2,
								const fx32 *inVal3,
								u8 *outEqual){
	u8 count;
	count = 0;
	if (*inTarget == *inVal1){
		count++;
	}
	if (*inTarget == *inVal2){
		count++;
	}
	if (*inTarget == *inVal3){
		count++;
	}
	
	if (count == 2){
		//꒼
		if (*inVal1 == *inVal2){
			*outEqual = EQ_12;
		}else if(*inVal2 == *inVal3){
			*outEqual = EQ_23;
		}else{	//*inVal3 == *inVal1
			*outEqual = EQ_31;
		}
		return TRUE;
	}else{
		//ɂȂ
		*outEqual = EQ_NO;
		return FALSE;
	}
}

//---------------------------------------------------------------------------------------------------------
/**
 *	w_Ԃ̏ɂA̕ӂQ_̍ꍇA̍Ԃ
 *
 *	@param	inTarget			wW	
 *	@param	inVec1				W1
 *	@param	inVec2				W2
 *	@param	inVec3				W3
 *	@param	outHeight			ʂi[obt@
 *	
 *	@retval	BOOL			TRUE:ꍂ		FALSE:ꍂł͂Ȃ
*/
//---------------------------------------------------------------------------------------------------------
static const BOOL GetEdgeEqualHeightXZFlat(	const VecFx32 *inTarget,
											const VecFx32 *inVec1,
											const VecFx32 *inVec2,
											const VecFx32 *inVec3,
											fx32 *outHeight)
{
	BOOL rc;
	u8 eq;

	//_3̂ƃ^[Qbĝr
	rc = Check2DLine(&inTarget->x, &inVec1->x, &inVec2->x, &inVec3->x, &eq);
	if (!rc){
		rc = Check2DLine(&inTarget->z, &inVec1->z, &inVec2->z, &inVec3->z, &eq);
	}

	if (rc){
		//`FbN
		if (eq == EQ_12){
			if (inVec1->y == inVec2->y){
				*outHeight = inVec1->y;
				rc = TRUE;
			}
		}else if (eq == EQ_23){
			if (inVec2->y == inVec3->y){
				*outHeight = inVec2->y;
				rc = TRUE;
			}
		}else if (eq == EQ_31){
			if (inVec3->y == inVec1->y){
				*outHeight = inVec3->y;
				rc = TRUE;
			}
		}else{	//EQ_NO
			*outHeight = 0;
			rc = FALSE;
		}
	}
	return rc;
}

//---------------------------------------------------------------------------------------------------------
/**
 *	w__(3_)ƓW̏ꍇA̍Ԃ
 *
 *	@param	inTarget			wW	
 *	@param	inVec1				W1
 *	@param	inVec2				W2
 *	@param	inVec3				W3
 *	@param	outHeight			ʂi[obt@
 *	
 *	@retval	BOOL			TRUE:ꍂ		FALSE:ꍂł͂Ȃ
*/
//---------------------------------------------------------------------------------------------------------
static const BOOL GetVertexEqualHeight(const VecFx32 *inTarget,
										const VecFx32 *inVec1,
										const VecFx32 *inVec2,
										const VecFx32 *inVec3,
										fx32 *outHeight)
{
	BOOL rc;
	if ( (inTarget->x == inVec1->x)&&(inTarget->z == inVec1->z) ){
		*outHeight = inVec1->y;
		rc = TRUE;
	}else if ( (inTarget->x == inVec2->x)&&(inTarget->z == inVec2->z) ){
		*outHeight = inVec2->y;
		rc = TRUE;
	}else if ( (inTarget->x == inVec3->x)&&(inTarget->z == inVec3->z) ){
		*outHeight = inVec3->y;
		rc = TRUE;
	}else{
		*outHeight = 0;
		rc = FALSE;
	}
	return rc;
}

//---------------------------------------------------------------------------------------------------------
/**
 *	w肳ꂽꏊ̍f[^𒲂ׂ
 *
 *	@param	inX			XW
 *	@param	inZ			ZW
 *	@param	inMap3DInfo	
 *	@param	inDetail	ڍ׏KvƂ邩̃tO
 *	
 *	@retval	u8			`FbN
*/
//---------------------------------------------------------------------------------------------------------
u8 HC_DebugCheckHeight(const fx32 inX, const fx32 inZ, MHI_CONST_PTR inMap3DInfo, const BOOL inDetail)
{
	VecFx32 vertex[3];
	VecFx32 target,nrm;
	fx32 temp1,temp2;
	BOOL result;
	u16 i,pol_index;
	fx32 d,y;
	int pol_count;
	u32 line_num,tbl_idx,tbl_x_idx,tbl_z_idx;
	HEIGHT_ARRAY height_array[MAX_GET_POL];
	fx32 tbl_x,tbl_z;

	u32 offset_idx;

	u16 line_data_idx;
	u16 line_index;
	u16 polygon_num;

	const u16 *line_list;

	VecFx32 vec[3];

	if (inMap3DInfo->DataValid == FALSE){
		OS_Printf("f[^\̂Ȃ\n");
		return 0;
	}

	result = FALSE;
	//ZXʂɎˉe
	target.x = inX;
	target.y = 0;
	target.z = inZ;
	pol_count = 0;
	InitArray(height_array);
	//{e[uo
	tbl_x = inX - inMap3DInfo->SplitGridData->StartX;
	if (tbl_x < 0){
		tbl_x = 0;
	}
	tbl_z = inZ - inMap3DInfo->SplitGridData->StartZ;
	if (tbl_z < 0){
		tbl_z = 0;
	}

	tbl_x = FX_Div(tbl_x, inMap3DInfo->SplitGridData->SizeX);
	tbl_x_idx = (int)(tbl_x>>12);
	if (tbl_x_idx >= inMap3DInfo->SplitGridData->NumX){
		tbl_x_idx = inMap3DInfo->SplitGridData->NumX-1;
	}
	tbl_z = FX_Div(tbl_z, inMap3DInfo->SplitGridData->SizeZ);
	tbl_z_idx = (int)(tbl_z>>12);
	if (tbl_z_idx >= inMap3DInfo->SplitGridData->NumZ){
		tbl_z_idx = inMap3DInfo->SplitGridData->NumZ-1;
	}

	tbl_idx = tbl_x_idx + (tbl_z_idx * inMap3DInfo->SplitGridData->NumZ);
	line_num = inMap3DInfo->GridDataTbl[tbl_idx*GRID_ENTRY_ONE_DATA];
	line_data_idx = inMap3DInfo->GridDataTbl[tbl_idx*GRID_ENTRY_ONE_DATA+1];

	line_list = &inMap3DInfo->LineDataTbl[line_data_idx*LINE_ONE_DATA];
	//擾pObhf[^ɓo^Ă郉Cf[^2TāAĂ|S݂郉Co
	if ( BinSearch(line_list,line_num,target.z,&line_index)==FALSE){
		if (inDetail){
			OS_Printf("񕪒Ts\n");
		}
		return 3;		//Ȃ
	}
	polygon_num = line_list[line_index*LINE_ONE_DATA];
	offset_idx = (line_list[(line_index*LINE_ONE_DATA)+4]<<16) | line_list[(line_index*LINE_ONE_DATA)+3];
///OS_Printf("target = %x,%x\n",target.x,target.z);	
	//擾pObhCf[^ɓo^Ăf[^[vāAĂ|So
	for(i=0;i<polygon_num;i++){
				pol_index = inMap3DInfo->PolyIDList[offset_idx+i];
		//_f[^擾
		GetPolygonVertex(inMap3DInfo,pol_index, vertex);
///OS_Printf("vert:%x,%x,%x\n",vertex[0].y,vertex[1].y,vertex[2].y);
		vec[0] = vertex[0];
		vec[1] = vertex[1];
		vec[2] = vertex[2];
		//ZXʂɎˉe
		vertex[0].y = 0;
		vertex[1].y = 0;
		vertex[2].y = 0;
		//Op`̓O
		result = BG3D_CheckTriangleIObyZX(target,vertex[0],vertex[1],vertex[2]);
		if (result == TRUE){//Op`
/**
			OS_Printf("tri_vert:%x,%x,%x %x,%x,%x %x,%x,%x\n",
		vertex[0].x,vec_y[0],vertex[0].z,
		vertex[1].x,vec_y[1],vertex[1].z,
		vertex[2].x,vec_y[2],vertex[2].z);
*/
///OS_Printf("target:%x,%x\n",target.x,target.z);
			//_qbg`FbN
			if ( GetVertexEqualHeight(&target,&vec[0],&vec[1],&vec[2], &y) ){
				height_array[pol_count].Height = y;
				///OS_Printf("_Ƀqbg\n");
			}
			//wyʂɕsȕӂɃqbgĂ邩`FbN
			else if( GetEdgeEqualHeightXZFlat(&target,&vec[0],&vec[1],&vec[2], &y) ){
				height_array[pol_count].Height = y;
				///OS_Printf("ӂɃqbg\n");

			}
			//ʏ擾
			else{
				//@擾
				GetPolygonNrm(inMap3DInfo,pol_index, &nrm);
///				OS_Printf("nrm:%x,%x,%x\n",nrm.x,nrm.y,nrm.z);			
				//ʂ̕ɕKvȃf[^i_ʂ镽ʂ̃ItZbgj擾
				d = inMap3DInfo->PolygonData[pol_index].paramD;
				//ʂ̕荂擾
				y = -(FX_Mul(nrm.x, target.x)+FX_Mul(nrm.z, target.z)+d);
				y = FX_Div(y, nrm.y);
				height_array[pol_count].Height = y;
			}
			
			//z̃\[gisł͋@\Ă܂BΉ\j
			pol_count++;
			if (pol_count >= MAX_GET_POL){
				break;
			}
			///break;
		}
	}//end for
	
	if (pol_count > 1){//|Sf[^ꂽƂ
		pol_index = 0;
		temp1 = height_array[0].Height;
		//ׂẴ|Sf[^̍߁A݂̍Ɉԋ߂Io
		for(i=1;i<pol_count;i++){
			temp2 = height_array[i].Height;
			if (temp1!=temp2){
				if (inDetail){
					int c;
///					OS_Printf("W:%x,%x  ",inX,inZ);
///					OS_Printf("̃jbg%dwł\n",pol_count);
					OS_Printf("oF");
					for(c=0;c<pol_count;c++){
						OS_Printf("%x,", height_array[c].Height);
					}
					OS_Printf("\n");
				}
				return 1;
			}
		}
		if (inDetail){
			OS_Printf("%x\n",temp1);
			return 2;
		}
	}else if(pol_count == 1){
		///OS_Printf("PlaneOnly:%x\n",height_array[0].Height);
		return 0;
	}
	//Ȃ
	return 3;
}


#endif	//PM_DEBUG
