//============================================================================================
/**
 * @file	height_ex.c
 * @brief	gf[^
 * @author	Nozomu Saito
 * @date	2005.12.05
 */
//============================================================================================
#include "common.h"
#include "../height_def.h"

typedef struct EX_HEIGHT_DATA_tag
{
	int StartGridX;
	int StartGridZ;
	int SizeGridX;
	int SizeGridZ;
	fx32 Height;
	BOOL Valid;
}EX_HEIGHT_DATA;

typedef struct EX_HEIGHT_LIST_tag
{
	int Num;
	EX_HEIGHT_DATA *ExHeightData;
}EX_HEIGHT_LIST;

static BOOL HitCheckExHeightFromData(	const int inGridX,
										const int inGridZ,
										const EX_HEIGHT_DATA *inExHeightData );

//--------------------------------------------------------------------------------------------
/**
 * gf[^̃qbg`FbN
 *
 * @param	inGridX			`FbNObhXW
 * @param	inGridZ			`FbNObhZW
 * @param	inExHeightData	gf[^ւ̃|C^
 *
 * @return	BOOL	TRUE:qbg	FALSE:m[qbg
 */
//--------------------------------------------------------------------------------------------
static BOOL HitCheckExHeightFromData(	const int inGridX,
										const int inGridZ,
										const EX_HEIGHT_DATA *inExHeightData )
{
	//f[^ȂqbgȂƂ݂Ȃ
	if (inExHeightData->Valid == FALSE){
		return FALSE;
	}
#if 0	
#ifdef DEBUG_ONLY_FOR_saitou	
OS_Printf("local_printt search%d,%d\n",inGridX,inGridZ);	
#endif
#endif
	{
		int st_x = inExHeightData->StartGridX;
		int st_z = inExHeightData->StartGridZ;
		int end_x = st_x+inExHeightData->SizeGridX-1;
		int end_z = st_z+inExHeightData->SizeGridZ-1;

		if ( (st_x<=inGridX)&&(inGridX<=end_x)&&
				(st_z<=inGridZ)&&(inGridZ<=end_z) ){
#if 0			
#ifdef DEBUG_ONLY_FOR_saitou			
OS_Printf("local_print HIT!!\n");
#endif
#endif
			return TRUE;
		}
	}
	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * gf[^̃AP[g
 *
 * @param	inNum		mۂf[^
 * @param	inHeapID	mۂq[vID
 *
 * @return	EHL_PTR	mۂ̈̐擪|C^
 */
//--------------------------------------------------------------------------------------------
EHL_PTR EXH_AllocExHeightList(const u8 inNum, const u8 inHeapID)
{
	u8 i;
	EHL_PTR ehl_p;
	ehl_p = sys_AllocMemory( inHeapID, sizeof(EX_HEIGHT_LIST) );
	ehl_p->ExHeightData = sys_AllocMemory( inHeapID, sizeof(EX_HEIGHT_DATA)*inNum );
	ehl_p->Num = inNum;
	//f[^𖳌
	for(i=0;i<inNum;i++){
		ehl_p->ExHeightData[i].Valid = FALSE;
	}
	
	return ehl_p;
}

//--------------------------------------------------------------------------------------------
/**
 * gf[^̃ZbgAbv
 *
 * @param	inIndex		擾鍂f[^̃CfbNX
 * @param	inStX			̈JnObhXW
 * @param	instZ			̈JnObhZW
 * @param	inSizX			̈Obh
 * @param	inSizZ			̈Obhc
 * @param	inHeight		̈
 * @param	outExHeightList	gf[^ւ̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void EXH_SetUpExHeightData(	const u8 inIndex,
							const int inStX,
							const int inStZ,
							const int inSizX,
							const int inSizZ,
							const fx32 inHeight,
							EHL_PTR outExHeightList )
{
	outExHeightList->ExHeightData[inIndex].StartGridX = inStX;
	outExHeightList->ExHeightData[inIndex].StartGridZ = inStZ;
	outExHeightList->ExHeightData[inIndex].SizeGridX = inSizX;
	outExHeightList->ExHeightData[inIndex].SizeGridZ = inSizZ;
	outExHeightList->ExHeightData[inIndex].Height = inHeight;
	outExHeightList->ExHeightData[inIndex].Valid = TRUE;
}

//--------------------------------------------------------------------------------------------
/**
 * gf[^
 *
 * @param	outExHeightData	gf[^̐擪|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void EXH_FreeExHeightList(EHL_PTR outExHeightList)
{
	sys_FreeMemoryEz(outExHeightList->ExHeightData);
	sys_FreeMemoryEz(outExHeightList);
}

//--------------------------------------------------------------------------------------------
/**
 * gf[^̃qbg`FbN
 *
 * @param	inGridX			`FbNObhXW
 * @param	inGridZ			`FbNObhZW
 * @param	inExHeightList	gf[^ւ̃|C^
 *
 * @return	BOOL	TRUE:qbg	FALSE:m[qbg
 */
//--------------------------------------------------------------------------------------------
BOOL EXH_HitCheckExHeight(	const int inGridX,
							const int inGridZ,
							EHL_CONST_PTR inExHeightList,
							u8 *outIndex)
{
	u8 i;
	BOOL rc;
	EX_HEIGHT_DATA *ehd_p;

	GF_ASSERT((outIndex != NULL)&&"i[ϐNULL");

	for(i=0;i<inExHeightList->Num;i++){
		ehd_p = &inExHeightList->ExHeightData[i];
		if ( HitCheckExHeightFromData( inGridX, inGridZ, ehd_p ) ){
			*outIndex = i;
			return TRUE;
		}
	}
	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * gf[^獂擾(Xg)
 *
 * @param	inIndex	gf[^CfbNX
 * @param	inExHeightList	gf[^ւ̃|C^
 *
 * @return	fx32	
 */
//--------------------------------------------------------------------------------------------
fx32 EXH_GetExHeight(const u8 inIndex, EHL_CONST_PTR inExHeightList)
{
	GF_ASSERT((inIndex<inExHeightList->Num)&&"gf[^̃CfbNXI[o[");
	GF_ASSERT((inExHeightList->ExHeightData[inIndex].Valid)&&"f[^͖ł");
	return inExHeightList->ExHeightData[inIndex].Height;
}

//--------------------------------------------------------------------------------------------
/**
 * gf[^̍Zbg(Xg)
 *
 * @param	inIndex	gf[^CfbNX
 * @param	inHeight		̈
 * @param	outExHeightList	gf[^ւ̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void EXH_SetExHeight(	const u8 inIndex,
						const fx32 inHeight,
						EHL_PTR outExHeightList )
{
	GF_ASSERT((inIndex<outExHeightList->Num)&&"gf[^̃CfbNXI[o[");
	outExHeightList->ExHeightData[inIndex].Height = inHeight;
}

//--------------------------------------------------------------------------------------------
/**
 * gf[^̗LE(Xg)
 *
 * @param	inIndex	gf[^CfbNX
 * @param	inValid			TRUE:L	FALSE:
 * @param	outExHeightData	gf[^ւ̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void EXH_SetExHeightValid(	const u8 inIndex,
							const BOOL inValid,
							EHL_PTR outExHeightList )
{
	GF_ASSERT((inIndex<outExHeightList->Num)&&"gf[^̃CfbNXI[o[");
	outExHeightList->ExHeightData[inIndex].Valid = inValid;
}

#if 0
//--------------------------------------------------------------------------------------------
/**
 * gf[^̎擾
 *
 * @param	inIndex		擾鍂f[^̃CfbNX
 *
 * @return	EHD_PTR		gf[^ւ̃|C^
 */
//--------------------------------------------------------------------------------------------
EHD_PTR GetExHeightData(const u8 inIndex, EHL_PTR inExHeightList)
{
	GF_ASSERT((inIndex<inExHeightList->Num)&"gf[^̃CfbNXI[o[");
	return inExHeightList->ExHeightData;
}

//--------------------------------------------------------------------------------------------
/**
 * gf[^̃ZbgAbv
 *
 * @param	inStX			̈JnObhXW
 * @param	instZ			̈JnObhZW
 * @param	inSizX			̈Obh
 * @param	inSizZ			̈Obhc
 * @param	inHeight		̈
 * @param	outExHeightData	gf[^ւ̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void SetUpExHeightData(	const int inStX,
						const int inStZ,
						const int inSizX,
						const int inSizZ,
						const fx32 inHeigt,
						EHD_PTR outExHeightData )
{
	outExHeightData->StartGridX = inStX;
	outExHeightData->StartGridZ = inStZ;
	outExHeightData->SizeGridX = inSizX;
	outExHeightData->SizeGridZ = inSizZ;
	outExHeightData->Heigt = inHeight;
	outExHeightData->Valid = TRUE;
}

//--------------------------------------------------------------------------------------------
/**
 * gf[^̍Zbg
 *
 * @param	inHeight		̈
 * @param	outExHeightData	gf[^ւ̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void SetExHeight(	const fx32 inHeigt,
					EHD_PTR outExHeightData )
{
	outExHeightData->Heigt = inHeight;
}

//--------------------------------------------------------------------------------------------
/**
 * gf[^̗LE
 *
 * @param	inValid			TRUE:L	FALSE:
 * @param	outExHeightData	gf[^ւ̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void SetExHeightValid(	const BOOL inValid,
					EHD_PTR outExHeightData )
{
	outExHeightData->Valid = inValid;
}
//--------------------------------------------------------------------------------------------
/**
 * gf[^獂擾
 *
 * @param	inExHeightData	gf[^ւ̃|C^
 *
 * @return	fx32	
 */
//--------------------------------------------------------------------------------------------
fx32 GetExHeightFromData(EHD_CONST_PTR inExHeightData)
{
	GF_ASSERT(inExHeightData->Valid&"f[^͖ł");
	return inExHeightData->Height;
}

#endif
