//=============================================================================
/**
 * @file	honey_tree_enc.c
 * @bfief	hGJEg
 * @author	Nozomu Saito
 *
 *
 */
//=============================================================================
#include "common.h"
#include "honey_tree_enc.h"
#include "map_tool.h"
#include "player.h"
#include "fieldsys.h"
#include "..\fielddata\script\common_scr_def.h"		//for SCRID_HONEY_TREE
#include "honey_tree_def.h"
#include "..\fielddata\maptable\zone_id.h"

#include "poketool/monsno.h"	//

#include "../fielddata/build_model/build_model_id.h"

#include "savedata/honeytree_data.h"

///#define HONEY_TREE_MAX	(33)

#define START_TIME	(24*60)		//h̎ 2460

#define ENC_START_TIME	(18*60)	//GJEg\Ȏԁ@1860

typedef enum{
	TH_ENC_TBL_NORM,
	TH_ENC_TBL_RARE,
	TH_ENC_TBL_G_RARE,
}HT_ENC_TBL;

typedef enum{
	SWAY_LV_NONE,		//hȂ
	SWAY_LV_NORMAL,		//ʏh
	SWAY_LV_GRATE,		//h
	SWAY_LV_G_GRATE,	//̂h
}SWAY_LV;

enum{
	HTE_NONE,
	HTE_NORMAL,
	HTE_RARE,
	HTE_GRATE_RARE,
};

typedef struct HONEY_DATA_ANM_tag
{
//	int Time;			//h
//	u16 State;			//؂̏
//	u8 TblMonsNo;		//e[uX^[ԍ
//	u8 TblNo;			//GJEge[uԍ
//	u8 RareLv;			//Ax	nYAʏAAAA
//	u8 SwayLv;			//hꃂ[V̓x
	u8 AnimeNo;
	BOOL AnimeFlg;
}HONEY_DATA_ANM;

typedef struct HONEY_TREE_tag
{
//	u8 TreeNo;			//OGJEg؂̃io[
	HONEY_DATA_ANM HoneyData[HONEY_TREE_MAX];
}HONEY_TREE_ANM;

//h؂̃][Xg
static const int HoneyTreeZoneList[HONEY_TREE_MAX] = {
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_R209,
	ZONE_ID_R210A,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_R212A,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_R215,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
	ZONE_ID_C01,
};
#ifdef PM_DEBUG
static HONEY_TREE_ANM DebugHoneyTree;
#endif
#if 0
static HONEY_TREE DebugHoneyTree = {
	HONEY_TREE_MAX,
	{
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
		{0,HONEY_SPREAD_OK,0,0,0},
	}
};
#endif
//m[}e[u
static const int HoneyTreeNormMonsTbl[] = 
{
	MONSNO_KYATAPII,
	MONSNO_KEMUSSO,
	MONSNO_BIIDORU,
	MONSNO_TORANSERU,
	MONSNO_PIKATYUU,	//V|PɃ`FW\
	MONSNO_TAMATAMA
};

//Ae[u
static const int HoneyTreeRareMonsTbl[] = 
{
	MONSNO_TORANSERU,
	MONSNO_PIKATYUU,	//V|PɃ`FW\
	MONSNO_TAMATAMA,
	MONSNO_KYATAPII,
	MONSNO_HERAKUROSU,	
	MONSNO_EIPAMU
};

//Ae[u
static const int HoneyTreeRareGMonsTbl[] = 
{
	MONSNO_KABIGON,
	MONSNO_KABIGON,
	MONSNO_KABIGON,
	MONSNO_KABIGON,
	MONSNO_KABIGON,	
	MONSNO_KABIGON
};

static const * const HoneyTreeMonsTbl[] = {
	HoneyTreeNormMonsTbl,
	HoneyTreeRareMonsTbl,
	HoneyTreeRareGMonsTbl,
};

static void SetRareLv(const BOOL inHit, u8 *outRare);
static void SetHoneyTreeTblMonsNo(u8 *outTblMonsNo);
static void SetHoneyTreeAnimation(FIELDSYS_WORK *fsys, M3DOL_PTR inMap3DObjList, const int inBlockIdx);
static u8 GetTreeNoFromZoneID(const int inZoneID);
static const int SetHoneyTreeEncTbl(const u8 inRareLv);
static const int SetSwayLv(const u8 inRareLv);
static const BOOL GetAnimeNoForHoneyTree(const int inSwayLv, u8 *outAnimeNo);
static const BOOL CheckHoneyTreeEncTime(const int inTime);
#if 0
//==============================================================================
/**
 * ؂̏
 *
 * @param   inHeapID		q[vID
 * 
 * @retval	HT_PTR			؃f[^|C^		
 * 
 */
//==============================================================================
HT_PTR HTE_InitHoneyTree(const u8 inHeapID)
{
	u8 i;
	HT_PTR honey_tree_p;
	honey_tree_p = sys_AllocMemory(inHeapID, sizeof(HONEY_TREE));
	honey_tree_p->TreeNo = HONEY_TREE_MAX;
	for(i=0;i<HONEY_TREE_MAX;i++){
		honey_tree_p->HoneyData[i].Time = 0;
		honey_tree_p->HoneyData[i].State = HONEY_SPREAD_OK;
		honey_tree_p->HoneyData[i].TblMonsNo = 0;
		honey_tree_p->HoneyData[i].TblNo = 0;
		honey_tree_p->HoneyData[i].RareLv = 0;
		honey_tree_p->HoneyData[i].SwayLv = 0;
	}
	return honey_tree_p;
}

//==============================================================================
/**
 * 
 *
 * @param	outHoneyTree	؃f[^|C^	
 * 
 * @retval  none		
 */
//==============================================================================
void HTE_FreeHoneyTree(HT_PTR outHoneyTree)
{
	sys_FreeMemoryEz(outHoneyTree);
	outHoneyTree = NULL;
}
#endif
//==============================================================================
/**
 * h؂̐ڐG`FbN
 *
 * @param	fsys		tB[hVXe|C^
 * @param	outScrID	XNvgIDi[AhX
 *
 * @return	BOOL	TRUE:HIT@FALSE:NO HIT
 */
//==============================================================================
BOOL HTE_CheckHoneyTree(FIELDSYS_WORK *fsys, int *outScrID)
{
	TARGET_RECT rect;
	int x,z;
	BOOL rc;

	*outScrID = SCRID_HONEY_TREE;
	//@W擾(Obh)
	x = Player_NowGPosXGet( fsys->player );
	z = Player_NowGPosZGet( fsys->player );
	
	//@擾
	//@̑O1Obh̋`쐬
	MPTL_MakeTargetRect( x, z, 0, -1, 1, 1, &rect);

	rc = MPTL_CheckMap3DObjInRect(	fsys,
									BMID_TREEEFF,			//h
									&rect,
									NULL);
	return rc;
}

//==============================================================================
/**
 * ݂][̖h؂̃Xe[g擾
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @return	u16			؂̃Xe[g
 */
//==============================================================================
u16 HTE_GetNowLocHoneyTreeState(FIELDSYS_WORK *fsys)
{
	u8 tree_no;
	HT_PTR ptr;
	HONEY_DATA *data;
	//݂̃][ID擾
	tree_no = GetTreeNoFromZoneID(fsys->location->zone_id);
	GF_ASSERT(tree_no!=HONEY_TREE_MAX&&"h؂o^Ă܂" );

	ptr = HTSave_GetHoneyTree(fsys->savedata);
	data = HTSave_GetHoneyDataPtr(tree_no, ptr);
	if ( data->State ==HONEY_SPREAD_ENCOUNT/*CheckHoneyTreeEncTime(data->Time)*/ ){
		return HONEY_SPREAD_ENCOUNT;//GJEg
		//return DebugHoneyTree.HoneyData[tree_no].State;
	}else{
		return HONEY_SPREAD_OK;	//h
	}
}

//==============================================================================
/**
 * ݂][̖h؂̃ZbgAbv
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @return	none
 */
//==============================================================================
void HTE_SetupNowLocHoneyTree(FIELDSYS_WORK *fsys)
{
	u8 tree_no;
	HT_PTR ptr;
	HONEY_DATA *data;
	//݂̃][ID擾
	tree_no = GetTreeNoFromZoneID(fsys->location->zone_id);
	GF_ASSERT(tree_no!=HONEY_TREE_MAX&&"h؂o^Ă܂" );
	
	ptr = HTSave_GetHoneyTree(fsys->savedata);
	data = HTSave_GetHoneyDataPtr(tree_no, ptr);
	
	data->Time = START_TIME;
	data->State = HONEY_SPREAD_OK;
	//g[i[IDAԍ
	
	//O̖؂ƔrB؂ȂAÕ|PƂ̃GJEgȂ(9œ)
	if (HTSave_GetBeforeTreeNo(ptr) == tree_no){
		if ( (gf_rand()%100 ) <90){	//|PƃGJEg
			//Xe[gZbg
			data->State = /*HONEY_SPREAD_ALREADY*/HONEY_SPREAD_ENCOUNT;
			//Ƃ肠GJEg;
			return;
		}
	}
	{	//ĒI
		SetRareLv(FALSE, &data->RareLv);
		//nYȊOȂ
		if (data->RareLv != HTE_NONE){
			SetHoneyTreeTblMonsNo(&data->TblMonsNo);
			//e[u
			data->TblNo = SetHoneyTreeEncTbl( data->RareLv );
			//Xe[gZbg
			data->State = /*HONEY_SPREAD_ALREADY*/HONEY_SPREAD_ENCOUNT;
			//Ƃ肠GJEg
		}
		//؂̗h
		data->SwayLv = SetSwayLv(data->RareLv);
	}
}

//==============================================================================
/**
 * h؂̐퓬㏈
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @return	none
 */
//==============================================================================
void HTE_SetHoneyTreeInfoAfterBtl(FIELDSYS_WORK *fsys)
{
	u8 tree_no;
	HT_PTR ptr;
	HONEY_DATA *data;
	
	tree_no = GetTreeNoFromZoneID(fsys->location->zone_id);
	GF_ASSERT(tree_no!=HONEY_TREE_MAX&&"h؂o^Ă܂" );

	ptr = HTSave_GetHoneyTree(fsys->savedata);
	data = HTSave_GetHoneyDataPtr(tree_no, ptr);
	
	//؂̔ԍL
	HTSave_SetBeforeTreeNo(tree_no, ptr);
	data->Time = 0;
	data->State = HONEY_SPREAD_OK;
	//AjXgbv
	if (DebugHoneyTree.HoneyData[tree_no].AnimeFlg){
		u8 idx;
		M3DO_PTR obj_ptr;
		M3DOL_PTR obj_list;
		NNSG3dRenderObj *render_obj;
		//[JCfbNX擾
		idx = GetNowLocalIndex(fsys->map_cont_dat);
		//naiXg擾
		Get3DObjListFromLocalIdx(idx, fsys->map_cont_dat, &obj_list);
		obj_ptr = M3DO_GetMap3DObjDataFromID(obj_list, BMID_TREEEFF);
		render_obj = M3DO_GetRenderObj(obj_ptr);
		if (obj_ptr != NULL){
			F3DA_RemoveFld3DAnime(	fsys->field_3d_anime,
									render_obj,
									BMID_TREEEFF,
									DebugHoneyTree.HoneyData[tree_no].AnimeNo);
		}
		DebugHoneyTree.HoneyData[tree_no].AnimeFlg = FALSE;
		OS_Printf("hꑐAjXgbv\n");
	}
	//X^[e[uԍ͏Ȃ!!
}
#if 0
//==============================================================================
/**
 * h؂̃Aj[VZbgC
 *
 * @param	outMonsTblNo		X^[e[uio[i[obt@
 *
 * @return	none
 */
//==============================================================================
void HTE_SetHoneyTreeAnimation(FIELDSYS_WORK *fsys, M3DOL_PTR inMap3DObjList)
{
	M3DO_PTR ptr;
	//div̎ubN3DOBJXg
	//ubÑ][ID擾
	//擾][ɖh؂邩𒲂ׂ
	//ꍇÃubN3DOBJV[PVANZX
	//؂ꍇA̖؂̏擾Aǂ̃AjKp邩𔻒
	if ( DebugHoneyTree.HoneyData[0].State == HONEY_SPREAD_ENCOUNT){
		//𕪊
		//Aj[VZbgiAĵ̂́AubNAEgɍς܂Ăj
		ptr = M3DO_GetMap3DObjDataFromID(inMap3DObjList, 26);
		if (ptr != NULL){
			SetFld3DAnime(	FLD_3D_ANIME_STATION_SUB,
							GetFld3DAnimeCode(26),
							M3DO_GetRenderObj(ptr),
							fsys->field_3d_anime	);
		}
	}
}
#endif

//==============================================================================
/**
 * h؂̃Ax
 *
 * @param	inHit		tO
 * @param	outRare		Axi[obt@		
 * 
 * @return	none
 */
//==============================================================================
static void SetRareLv(const BOOL inHit, u8 *outRare)
{
	int rand;
	rand = gf_rand()%100;
	if (inHit){
		if(rand<1){			//1%
			*outRare = HTE_GRATE_RARE;	//A
		}else if(rand<10){	//9%
			*outRare = HTE_NONE;		//nY
		}else if(rand<30){	//20%
			*outRare = HTE_NORMAL;	//ʏ
		}else{				//70%
			*outRare = HTE_RARE;	//A
		}
	}else{
		if(rand<10){	//10%
			*outRare = HTE_NONE;		//nY
		}else if(rand<30){	//20%
			*outRare = HTE_RARE;	//A
		}else{				//70%
			*outRare = HTE_NORMAL;	//ʏ
		}
	}
}

//==============================================================================
/**
 * h؂̃GJEgX^[e[uio[
 *
 * @param	outTblMonsNo		X^[e[uio[i[obt@
 *
 * @return	none
 */
//==============================================================================
static void SetHoneyTreeTblMonsNo(u8 *outTblMonsNo)
{
	int rand;
	rand = gf_rand()%100;
	if(rand<5){			//5%
		*outTblMonsNo = 5;
	}else if(rand<10){	//5%
		*outTblMonsNo = 4;
	}else if(rand<20){	//10%
		*outTblMonsNo = 3;
	}else if(rand<40){	//20%
		*outTblMonsNo = 2;
	}else if(rand<60){	//20%
		*outTblMonsNo = 1;
	}else{				//40%
		*outTblMonsNo = 0;
	}
}

//==============================================================================
/**
 * hGJEge[u
 *
 * @param	inRareLv		Ax
 *
 * @return	int				e[uԍ
 */
//==============================================================================
static const int SetHoneyTreeEncTbl(const u8 inRareLv)
{
	int tbl_no;
	if (inRareLv == HTE_GRATE_RARE){	//A
		tbl_no = TH_ENC_TBL_G_RARE;
	}else if(inRareLv == HTE_RARE){		//A
		tbl_no = TH_ENC_TBL_RARE;
	}else{								//m[}
		tbl_no = TH_ENC_TBL_NORM;
	}
	return tbl_no;
}

//==============================================================================
/**
 * hZbg
 *
 * @param	inRareLv		Ax
 *
 * @return	int				h
 */
//==============================================================================
static const int SetSwayLv(const u8 inRareLv)
{
	int sway_lv;
	int rand;
	rand = gf_rand()%100;
	
	if (inRareLv == HTE_GRATE_RARE){	//A
		if (rand<5){		//5%
			sway_lv = SWAY_LV_GRATE;
		}else if(rand<6){	//1%
			sway_lv = SWAY_LV_NORMAL;
		}else if(rand<7){	//1%
			sway_lv = SWAY_LV_NONE;
		}else{				//93%
			sway_lv = SWAY_LV_G_GRATE;
		}
	}else if(inRareLv == HTE_RARE){		//A
		if (rand<75){		//75%
			sway_lv = SWAY_LV_GRATE;
		}else if(rand<95){	//20%
			sway_lv = SWAY_LV_NORMAL;
		}else if(rand<96){	//1%
			sway_lv = SWAY_LV_NONE;
		}else{				//4%
			sway_lv = SWAY_LV_G_GRATE;
		}
	}else if(inRareLv == HTE_NORMAL){	//m[}
		if (rand<19){		//19%
			sway_lv = SWAY_LV_GRATE;
		}else if(rand<79){	//60%
			sway_lv = SWAY_LV_NORMAL;
		}else if(rand<99){	//20%
			sway_lv = SWAY_LV_NONE;
		}else{				//1%
			sway_lv = SWAY_LV_G_GRATE;
		}
	}else{								//nY
		if (rand<1){		//1%
			sway_lv = SWAY_LV_GRATE;
		}else if(rand<19){	//18%
			sway_lv = SWAY_LV_NORMAL;
		}else if(rand<99){	//80%
			sway_lv = SWAY_LV_NONE;
		}else{				//1%
			sway_lv = SWAY_LV_G_GRATE;
		}
	}
	return sway_lv;
}

//==============================================================================
/**
 * hAjio[̃Zbg
 * Ajio[́Afield_3d_anime.c̃Aje[uɈˑ܂
 *
 * @param	inRareLv		h
 * @oaram	outAnimeNo		Ajio[@0Fm[}@1h@2F̂h
 *
 * @return	BOOL			TRUEFAj	FALSEFAjȂ
 */
//==============================================================================
static const BOOL GetAnimeNoForHoneyTree(const int inSwayLv, u8 *outAnimeNo)
{
	u8 anime_no;	//Ajio[
	BOOL rc;
	rc = TRUE;
	if (inSwayLv == SWAY_LV_G_GRATE){
		*outAnimeNo = 2;
	}else if (inSwayLv == SWAY_LV_GRATE){
		*outAnimeNo = 1;
	}else if (inSwayLv == SWAY_LV_NORMAL){
		*outAnimeNo = 0;
	}else{
		rc = FALSE;
	}
	return rc;
}

//==============================================================================
/**
 * h؂̃Aj[VZbgC
 *
 * @param	fsys			tB[hVXe|C^
 * @param	inMap3DObjList	}bv3DOBJXg
 * @param	inBlockIdx		ubNCfbNX
 *
 * @return	none
 */
//==============================================================================
static void SetHoneyTreeAnimation(FIELDSYS_WORK *fsys, M3DOL_PTR inMap3DObjList, const int inBlockIdx)
{
	u16 zone_id;
	u8 tree_no;
	
	//ubÑ][ID擾
	zone_id = World_GetZoneIDFromBlockIdx(fsys->World, inBlockIdx);
	//擾][hc͖h肷ꏊ𒲂ׂ
	tree_no = GetTreeNoFromZoneID(zone_id);

	if (tree_no != HONEY_TREE_MAX){
		HT_PTR ptr;
		HONEY_DATA *data;
		M3DO_PTR obj_ptr;

		ptr = HTSave_GetHoneyTree(fsys->savedata);
		data = HTSave_GetHoneyDataPtr(tree_no, ptr);	
		
		//h肷ꏊ̏ꍇȀꏊ́Ah؂̏󋵂擾
		if ( /*DebugHoneyTree.HoneyData[tree_no].State == HONEY_SPREAD_ENCOUNT*/
				/*CheckHoneyTreeEncTime(data->Time)*/data->State == HONEY_SPREAD_ENCOUNT ){
			BOOL rc;
			u8 anime_no;
			//𕪊
			rc = GetAnimeNoForHoneyTree(data->SwayLv, &anime_no);
			
			if(!rc){
				return;
			}
			
			//Aj[VZbgiAĵ̂́AubNAEgɍς܂Ăj
			obj_ptr = M3DO_GetMap3DObjDataFromID(inMap3DObjList, BMID_TREEEFF);
			if (obj_ptr != NULL){
				NNSG3dRenderObj *render_obj;
				render_obj = M3DO_GetRenderObj(obj_ptr);
				//łɃAjĂ邩Ȃ̂ŁAŁAAjItɂ
				F3DA_RemoveFld3DAnime(	fsys->field_3d_anime,
										render_obj,
										BMID_TREEEFF,
										DebugHoneyTree.HoneyData[tree_no].AnimeNo);

				DebugHoneyTree.HoneyData[tree_no].AnimeNo = anime_no;
				DebugHoneyTree.HoneyData[tree_no].AnimeFlg = rc;
				
				F3DA_SetFld3DAnime(	BMID_TREEEFF, anime_no, TRUE,
									render_obj,
									fsys->field_3d_anime	);
			}
		}
	}
}

//==============================================================================
/**
 * ][ID疨h؂̃io[擾
 *
 * @param	inZoneID		][ID
 *
 * @return	u8				؃io[
 */
//==============================================================================
static u8 GetTreeNoFromZoneID(const int inZoneID)
{
	u8 i;
	for(i=0;i<HONEY_TREE_MAX;i++){
		if (inZoneID == HoneyTreeZoneList[i]){
			return i;
		}
	}
	return i;
}

//==============================================================================
/**
 * GJEgł鎞Ԃ`FbN
 *
 * @param	inTime		
 *
 * @return  BOOL	TRUE:GJEg		FALSEFGJEgs
 */
//==============================================================================
static const BOOL CheckHoneyTreeEncTime(const int inTime)
{
	if ( (0<inTime)&&(inTime<=ENC_START_TIME) ){
		return TRUE;
	}else{
		return FALSE;
	}
}


//==============================================================================
/**
 * h؂̃GJEg|P擾
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @return	int			X^[io[
 */
//==============================================================================
int HTE_GetHoneyTreeMonster(FIELDSYS_WORK *fsys)
{
	u8 tree_no;
	//݂̃][ID擾
	tree_no = GetTreeNoFromZoneID(fsys->location->zone_id);
	GF_ASSERT(tree_no!=HONEY_TREE_MAX&&"h؂o^Ă܂" );
	{
		const int *tbl;
		HT_PTR ptr;
		HONEY_DATA *data;

		ptr = HTSave_GetHoneyTree(fsys->savedata);
		data = HTSave_GetHoneyDataPtr(tree_no, ptr);
		
		tbl = HoneyTreeMonsTbl[data->TblNo];
		{
			int i;
			OS_Printf("e[u\n");
			for(i=0;i<5;i++){
				OS_Printf("%d,",tbl[i]);
			}
			OS_Printf("\n");
		}

		return tbl[data->TblMonsNo];
	}
}

void HTE_SetHoneyTreeAnimeCallBack(void* work, const int inBlockIndex, const M3DOL_PTR inObjList)
{
	FIELDSYS_WORK *fsys;
	int zone_id;
	u8 tree_no;
	if (inBlockIndex<0){
		return;
	}

	fsys = (FIELDSYS_WORK *)work;
	SetHoneyTreeAnimation(fsys, inObjList, inBlockIndex);
}

//==============================================================================
/**
 * h؂̎ԍXV
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @return	none
 */
//==============================================================================
void HTE_UpdateHoneyTreeTime(FIELDSYS_WORK *fsys, const int inDiffMinute)
{
	int i;
	HT_PTR ptr;
	HONEY_DATA *data;

	ptr = HTSave_GetHoneyTree(fsys->savedata);
	
	for(i=0;i<HONEY_TREE_MAX;i++){
		data = HTSave_GetHoneyDataPtr(i, ptr);
		if (data->Time != 0){
			data->Time -= inDiffMinute;
			if (data->Time < 0){
				data->Time = 0;
			}
		}
	}
}
