//============================================================================================
/**
 * @file	itemuse.c
 * @bfief	tB[hACegp
 * @author	Hiroyuki Nakamura
 * @date	05.12.12
 */
//============================================================================================
#include "common.h"

#include "system/procsys.h"
#include "system/bmp_menu.h"
#include "system/bmp_list.h"
#include "system/clact_tool.h"
#include "poketool/pokeparty.h"
#include "itemtool/item.h"
#include "itemtool/myitem.h"

#include "application/pokelist.h"
#include "application/poru_tool.h"

#include "field_common.h"
#include "fieldsys.h"
#include "field_event.h"
#include "field_clact.h"
#include "field_subproc.h"
#include "fld_menu.h"


//============================================================================================
//	vg^Cv錾
//============================================================================================
extern void * FieldMenuTMap_SetProc( FIELDSYS_WORK * fsys );

static void ItemUse_Recover( GMEVENT_CONTROL * event, u16 item );
static void ItemUse_Townmap( GMEVENT_CONTROL * event, u16 item );
static void ItemUse_Tankenset( GMEVENT_CONTROL * event, u16 item );
static void ItemUse_Cycle( GMEVENT_CONTROL * event, u16 item );
static void ItemUse_FantasyNote( GMEVENT_CONTROL * event, u16 item );
static void ItemUse_WazaMachine( GMEVENT_CONTROL * event, u16 item );
static void ItemUse_Mail( GMEVENT_CONTROL * event, u16 item );
static void ItemUse_Kinomi( GMEVENT_CONTROL * event, u16 item );
static void ItemUse_PrtCase( GMEVENT_CONTROL * event, u16 item );

//static void ItemUse_Evolution( GMEVENT_CONTROL * event, u16 item );


//============================================================================================
//	O[oϐ
//============================================================================================
static const u32 ItemUseTbl[] = {
	NULL,						// 000:_~[
	(u32)ItemUse_Recover,		// 001:
	(u32)ItemUse_Townmap,		// 002:^E}bv
	(u32)ItemUse_Tankenset,		// 003:TZbg
	(u32)ItemUse_Cycle,			// 004:]
	(u32)ItemUse_FantasyNote,	// 005:`m[g
	(u32)ItemUse_WazaMachine,	// 006:Z}V
	(u32)ItemUse_Mail,			// 007:[
	(u32)ItemUse_Kinomi,		// 008:̂
	(u32)ItemUse_PrtCase,		// 009:|gP[X

//	(u32)ItemUse_Evolution,		// 003:i
};


const u32 ItemUse_FuncGet( u32 id )
{
	return ItemUseTbl[id];
}



// 001:
static void ItemUse_Recover( GMEVENT_CONTROL * event, u16 item )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;
	PLIST_DATA * pld;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );
	pld  = sys_AllocMemory( HEAPID_WORLD, sizeof(PLIST_DATA) );

	memset( pld, 0, sizeof(PLIST_DATA) );
	pld->pp     = SaveData_GetTemotiPokemon(fsys->savedata);
	pld->myitem = SaveData_GetMyItem( fsys->savedata );
	pld->type = PL_TYPE_SINGLE;
	pld->mode = PL_MODE_ITEMUSE;
	pld->item = item;
	GameSystem_StartSubProc( fsys, &PokeListProcData, pld );

	wk->app_wk = pld;
	wk->seq = FLD_MENU_SEQ_POKEMON_WAIT;
}

// 002:^E}bv
static void ItemUse_Townmap( GMEVENT_CONTROL * event, u16 item )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	wk->app_wk = FieldMenuTMap_SetProc( fsys );
	wk->seq = FLD_MENU_SEQ_TOWNMAP_WAIT;
}

// 003:TZbg
static void ItemUse_Tankenset( GMEVENT_CONTROL * event, u16 item )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	FieldEvent_Cmd_SetMapProc( fsys );
	wk->seq = FLD_MENU_SEQ_TANKENSET_INIT;
}

// 004:]
static void ItemUse_Cycle( GMEVENT_CONTROL * event, u16 item )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	if( Player_FormGet( fsys->player ) == HERO_FORM_CYCLE ){
		Player_RequestSet( fsys->player, HERO_REQBIT_NORMAL );
	}else{
		Player_RequestSet( fsys->player, HERO_REQBIT_CYCLE );
	}

	FieldEvent_Cmd_SetMapProc( fsys );
	wk->seq = FLD_MENU_SEQ_BLACK_IN_END;
}

// 005:`m[g
static void ItemUse_FantasyNote( GMEVENT_CONTROL * event, u16 item )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	FieldFantasyNote_SetProc( fsys, NULL );
	wk->seq = FLD_MENU_SEQ_FNOTE_WAIT;
}

// 006:Z}V
static void ItemUse_WazaMachine( GMEVENT_CONTROL * event, u16 item )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;
	PLIST_DATA * pld;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );
	pld  = sys_AllocMemory( HEAPID_WORLD, sizeof(PLIST_DATA) );

	memset( pld, 0, sizeof(PLIST_DATA) );
	pld->pp     = SaveData_GetTemotiPokemon(fsys->savedata);
	pld->myitem = SaveData_GetMyItem( fsys->savedata );
	pld->type = PL_TYPE_SINGLE;
	pld->mode = PL_MODE_WAZASET;
	pld->item = item;
	pld->waza = GetWazaNoItem( item );
	GameSystem_StartSubProc( fsys, &PokeListProcData, pld );

	wk->app_wk = pld;
	wk->seq = FLD_MENU_SEQ_POKEMON_WAIT;
}

// 007:[
static void ItemUse_Mail( GMEVENT_CONTROL * event, u16 item )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;
	MAIL_PARAM * mail;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );
	mail = FieldMailView_InitCall( fsys, MAILBLOCK_NULL, ItemMailDesignGet(item), HEAPID_WORLD );

	wk->tmp_wk = FieldMenu_MailWorkMake( item, FM_MAIL_MODE_VIEW, 0 );
	wk->app_wk = mail;
	wk->seq = FLD_MENU_SEQ_MAIL_WAIT;
}


// 008:̂
static void ItemUse_Kinomi( GMEVENT_CONTROL * event, u16 item )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;
	FIELD_OBJ_PTR	obj;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );
/*
	SXY_HeroFrontObjGet( fsys, &obj );
	if( obj != NULL ){
		if( SeedSys_EnableSetKinomi( fsys, obj ) == TRUE ){
			return;
		}
	}
*/
	ItemUse_Recover( event, item );
}

// 009:|gP[X
static void ItemUse_PrtCase( GMEVENT_CONTROL * event, u16 item )
{
	FIELDSYS_WORK * fsys;
	FLD_MENU * wk;
	PORUTO_PARAM * prt;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );
	prt  = FieldPorutoCase_InitCall( fsys, HEAPID_WORLD );

	wk->app_wk = prt;
	wk->seq = FLD_MENU_SEQ_PORUTO_CASE;
}

// i
static void ItemUse_Evolution( GMEVENT_CONTROL * event, u16 item )
{
}

