//============================================================================================
/**
 * @file	map_jump.c
 * @brief	}bvWv
 * @date	2006.02.07
 * @author	Nozomu Saito
 */
//============================================================================================
#include "common.h"
#include "fieldsys.h"
#include "field_event.h"
#include "location.h"
#include "ev_mapchange.h"
#include "field_3d_anime_ev.h"
#include "system/snd_tool.h"		//ꂪȂƁAfld_bgm.hŃG[o
#include "fld_bgm.h"

#include "map_jump_def.h"
#include "map_jump.h"

#include "fieldmap.h"		//for FieldFadeWipeSet

#include "map_attr.h"		//for attribute

static BOOL MJUMPEVT_MapChangeParent(GMEVENT_CONTROL * event);

static BOOL MJUMPEVT_MapFadeOutMat(GMEVENT_CONTROL * event);
static BOOL MJUMPEVT_MapFadeOutDoor(GMEVENT_CONTROL * event);
static BOOL MJUMPEVT_MapFadeOutEsca(GMEVENT_CONTROL * event);
static BOOL MJUMPEVT_MapFadeOutStairs(GMEVENT_CONTROL * event);

static BOOL MJUMPEVT_MapFadeInDoor(GMEVENT_CONTROL * event);
static BOOL MJUMPEVT_MapFadeInEsca(GMEVENT_CONTROL * event);
static BOOL MJUMPEVT_MapFadeInStairs(GMEVENT_CONTROL * event);

static void SetEscalatorIOPos(FIELDSYS_WORK *fsys);
static void SetStairsIOPos(FIELDSYS_WORK *fsys);
//tF[hAEgGtFNgXg
		//Ki
static const MAP_JUMP_FUNC MapJumpFadeOutFuncTbl[MAP_JUMP_TYPE_MAX] = {
	MJUMPEVT_MapFadeOutMat,		//hAiOj
	MJUMPEVT_MapFadeOutDoor,	//hAiOj
	MJUMPEVT_MapFadeOutEsca,	//GXJ[^[
	MJUMPEVT_MapFadeOutStairs,	//Ki
};

//tF[hCGtFNgXg
		//Ki
static const MAP_JUMP_FUNC MapJumpFadeInFuncTbl[MAP_JUMP_TYPE_MAX] = {
	MJUMPEVT_MapFadeInDoor,		//hAiOj
	MJUMPEVT_MapFadeInDoor,		//hAiOj
	MJUMPEVT_MapFadeInEsca,		//GXJ[^[
	MJUMPEVT_MapFadeInStairs,	//Ki
};

//}bvWvʕ\ʒu␳֐Q
static const MAP_JUMP_POS_SET MapJumpPosSetFuncTbl[MAP_JUMP_TYPE_MAX] = {
	NULL,						//hAiOj
	NULL,						//hAiOj
	SetEscalatorIOPos,			//GXJ[^[
	SetStairsIOPos,				//Ki
};

typedef struct {
	int seq;							///<V[PXێ[N
	int call_seq;						///<R[V[PX[N
	LOCATION_WORK next;					///<}bvJڐwp[N
	///FLD_3D_ANIME_WORK_PTR DoorAnimeWork;
	void	*JumpEffectWork;
	int JumpType;
}EVENT_MAPCHG_WORK;

//-----------------------------------------------------------------------------
/**
 * @brief	}bvJڃCxgZbg(hAAj)
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	zone		Jڐ}bṽ][w
 * @param	door_id		Jڐ}bvł̏oow
 * @param	x			Jڐ}bvłXObhʒu
 * @param	z			Jڐ}bvłYObhʒu
 * @param	dir			Jڐ}bvł̏
 *
 * Jڐ}bv̂ǂɏo邩͎̏̃}bvǂݍނ܂ł͂킩Ȃ͂Ȃ̂
 * {͍Ww͖ʂȂǁAÔ߁B܂GAƃ][̊֌W͍čl̂
 * GAwȂȂ\B
 */
//-----------------------------------------------------------------------------
void MJUMP_ChangeMap(FIELDSYS_WORK * fsys, const int zone, const int door_id,
						const int inX, const int inZ, const int inDir, const int inType )
{
	EVENT_MAPCHG_WORK * emw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_MAPCHG_WORK));
	emw->seq = 0;
	emw->call_seq = 0;
	//P[Vf[^쐬
	SetLocation(&emw->next, zone, door_id, inX, inZ, inDir);

	//Wv^CvZbg
	emw->JumpType = inType;

	//}bvWvCxg쐬
	FieldEvent_Set(fsys, MJUMPEVT_MapChangeParent, emw);
/**	
	if (is_in){		//hAJē
		FieldEvent_Set(fsys, GMEVENT_DoorMapChange, mcw);
	}else{			//o
		FieldEvent_Set(fsys, GMEVENT_MatMapChange, mcw);
	}
*/	
}

//-----------------------------------------------------------------------------
// @brief	}bvJڃCxg
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapChangeParent(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);

	switch (emw->seq) {
	case 0:		//Wv^CvʂɃtF[hAEg̃CxgR[
		emw->call_seq = 0;
		FieldEvent_Call(event, MapJumpFadeOutFuncTbl[emw->JumpType], emw);
		(emw->seq) ++;
		break;
	case 1:	//tB[hvZXI
		EventCmd_FinishFieldMap(event);
		(emw->seq) ++;
		break;
	case 2:	//ۂɃf[^V}bvɏ
		EventCmd_MapChangeByLocation(event, &emw->next);
		(emw->seq) ++;
		break;
	case 3:	//tB[hvZXJn
		EventCmd_StartFieldMap(event);
		(emw->seq) ++;
		break;
	case 4:
		//Wv^CvʂɁA@̏\WɃItZbg
		if (MapJumpPosSetFuncTbl[emw->JumpType] != NULL){
			MapJumpPosSetFuncTbl[emw->JumpType](fsys);
		}
		(emw->seq) ++;
		break;
	case 5:	//Wv^CvʂɃtF[hC̃CxgR[
		emw->call_seq = 0;
		FieldEvent_Call(event, MapJumpFadeInFuncTbl[emw->JumpType], emw);
		(emw->seq) ++;
		break;
	case 6:		//I
		sys_FreeMemoryEz(emw);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
// @brief	0:}bgtF[hAEg}bvJڃCxg(CxgR[)
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeOutMat(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);

	switch (emw->call_seq) {
	case 0:
		Snd_SePlay( SEQ_SE_DP_KAIDAN2 );

		//"}bvJڐp"tF[hAEg  BGMĐ
		{
			LOCATION_WORK* location = &emw->next;
			Snd_MapChangeFadeOutNextPlaySub( fsys, location->zone_id, BGM_FADE_ROOM_MODE );
		}
		
		EventCmd_FieldFadeOut(event);
		(emw->call_seq) ++;
		break;
	case 1:
		return TRUE;
	}
	return FALSE;
}
//-----------------------------------------------------------------------------
// @brief	1:hAtF[hAEg}bvJڃCxg(CxgR[)
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeOutDoor(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	FLD_3D_ANIME_WORK_PTR	anime_work;
	switch (emw->call_seq) {
	case 0:	//hAAj[Nm
		emw->JumpEffectWork = Fld3DAnm_AllocEvent3DAnimeWork();
		anime_work = (FLD_3D_ANIME_WORK_PTR)emw->JumpEffectWork;
		Fld3DAnm_EventSetGrid(	Player_NowGPosXGet( fsys->player ),
								Player_NowGPosZGet( fsys->player ),
								anime_work	);
		(emw->call_seq) ++;
		break;
	case 1:	//hAAj
		anime_work = (FLD_3D_ANIME_WORK_PTR)emw->JumpEffectWork;
		if ( Fld3DAnm_EventDoorInAnime(fsys, anime_work) ){
			Fld3DAnm_FreeEvent3DAnimeWork(emw->JumpEffectWork);	//hAAj[N
			(emw->call_seq) ++;
		}
		break;		
	case 2:	
		//"}bvJڐp"tF[hAEg  BGMĐ
		{
			LOCATION_WORK* location = &emw->next;
			Snd_MapChangeFadeOutNextPlaySub( fsys, location->zone_id, BGM_FADE_ROOM_MODE );
		}
		
		EventCmd_FieldFadeOut(event);
		(emw->call_seq) ++;
		break;
	case 3:		//I
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
// @brief	2:GXJ[^[tF[hAEg}bvJڃCxg(CxgR[)
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeOutEsca(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	FLD_3D_ANIME_WORK_PTR	anime_work;
	switch (emw->call_seq) {
	case 0:	//Aj[Nm
		emw->JumpEffectWork = Fld3DAnm_AllocEvent3DAnimeWork();
		anime_work = (FLD_3D_ANIME_WORK_PTR)emw->JumpEffectWork;
		Fld3DAnm_EventSetGrid(	Player_NowGPosXGet( fsys->player ),
								Player_NowGPosZGet( fsys->player ),
								anime_work	);
		(emw->call_seq) ++;
		break;
	case 1:	//GXJ[^[Aj
		anime_work = (FLD_3D_ANIME_WORK_PTR)emw->JumpEffectWork;
		if ( Fld3DAnm_EventEscalatorAnime(fsys, anime_work) ){
			Fld3DAnm_FreeEvent3DAnimeWork(emw->JumpEffectWork);	//Aj[N
			(emw->call_seq) ++;
		}
		break;		
	case 2:	
		//"}bvJڐp"tF[hAEg  BGMĐ
		{
			LOCATION_WORK* location = &emw->next;
			Snd_MapChangeFadeOutNextPlaySub( fsys, location->zone_id, BGM_FADE_ROOM_MODE );
		}
		
		///EventCmd_FieldFadeOut(event);
		(emw->call_seq) ++;
		break;
	case 3:		//I
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
// @brief	3:KitF[hAEg}bvJڃCxg(CxgR[)
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeOutStairs(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	FIELD_OBJ_PTR fop;
	switch (emw->call_seq) {
	case 0:	//@ړ
		fop = Player_FieldOBJGet( fsys->player );
		
		if( /*FieldOBJ_AcmdSetCheck(fop) == TRUE*/1 ){	//AjZbgł邩?
			int dir;
			dir = Player_DirGet( fsys->player );
			if (dir == DIR_LEFT){	//
				FieldOBJ_AcmdSet(fop,AC_WALK_L_16F);	//oBCӂ̃AjZbg
			}else if (dir == DIR_RIGHT){	//E
				FieldOBJ_AcmdSet(fop,AC_WALK_R_16F);	//oBCӂ̃AjZbg
			}else{
				GF_ASSERT(0&&"@̌s");
			}
		}else{
			GF_ASSERT(0&&"Ajo^łȂ");
		}
		(emw->call_seq) ++;
		break;
	case 1:
		fop = Player_FieldOBJGet( fsys->player );
		if( FieldOBJ_AcmdEndCheck(fop) == TRUE ){	//AjI`FbN
			FieldOBJ_AcmdEnd(fop); //AjI	
			(emw->call_seq) ++;
		}
		break;
	case 2:
		//tF[hAEgJn
		///FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKOUT );
		FieldFadeWipeSet(FLD_DISP_BRIGHT_BLACKOUT, fsys);
		
		(emw->call_seq) ++;
		break;
	case 3:	
		if (IsFinishedFieldFadeWipe(fsys)) {
			//"}bvJڐp"tF[hAEg  BGMĐ
			{
				LOCATION_WORK* location = &emw->next;
				Snd_MapChangeFadeOutNextPlaySub( fsys, location->zone_id, BGM_FADE_ROOM_MODE );
			}
			(emw->call_seq) ++;
		}
		break;
	case 4:		//I
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
// @brief	0,1:}bgAhAtF[hC}bvJڃCxg(CxgR[)
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeInDoor(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	FLD_3D_ANIME_WORK_PTR	anime_work;
	switch (emw->call_seq) {
	case 0:
		{
			u8 attr;
			FIELD_OBJ_PTR player = Player_FieldOBJGet( fsys->player );
			//V}bvɃhA邩𒲂ׂ<<hAAgr[g`FbNɐ؂ւ\
			attr = GetAttributeLSB( fsys,
									Player_NowGPosXGet( fsys->player ),
									Player_NowGPosZGet( fsys->player ) );
			if (MATR_IsDoor(attr)){
				//@\
				FieldOBJ_StatusBitSet_Vanish( player, TRUE );
				(emw->call_seq) = 1;
			}else{
				//@\
				FieldOBJ_StatusBitSet_Vanish( player, FALSE );
				EventCmd_FieldFadeIn(event);
				(emw->call_seq) = 4;
			}
			//_WAgr[g`FbNɒǉ
		}
		break;
	case 1:
		//hAAj[Nm
		emw->JumpEffectWork = (FLD_3D_ANIME_WORK_PTR)Fld3DAnm_AllocEvent3DAnimeWork();
		anime_work = emw->JumpEffectWork;
		Fld3DAnm_EventSetGrid(	Player_NowGPosXGet( fsys->player ),
								Player_NowGPosZGet( fsys->player ),
								anime_work	);
		(emw->call_seq) ++;
		break;
	case 2:			//hAAj
		anime_work = emw->JumpEffectWork;
		if ( Fld3DAnm_EventDoorOutAnime(fsys, anime_work) ){
			Fld3DAnm_FreeEvent3DAnimeWork(anime_work);	//hAAj[N
			{
				FIELD_OBJ_PTR player = Player_FieldOBJGet( fsys->player );
				//@\
				FieldOBJ_StatusBitSet_Vanish( player, FALSE );
			}
			return TRUE;
		}
		break;
	case 3:	//_WƂ̎̏
		//@PO
		(emw->call_seq) ++;
	case 4:
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
// @brief	2:GXJ[^[tF[hC}bvJڃCxg(CxgR[)
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeInEsca(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	FLD_3D_ANIME_WORK_PTR	anime_work;
	switch (emw->call_seq) {
	case 0:	//Aj[Nm
		emw->JumpEffectWork = Fld3DAnm_AllocEvent3DAnimeWork();
		anime_work = (FLD_3D_ANIME_WORK_PTR)emw->JumpEffectWork;
		Fld3DAnm_EventSetGrid(	Player_NowGPosXGet( fsys->player ),
								Player_NowGPosZGet( fsys->player ),
								anime_work	);
		(emw->call_seq) ++;
		break;
	case 1:	//GXJ[^[Aj
		anime_work = (FLD_3D_ANIME_WORK_PTR)emw->JumpEffectWork;
		if ( Fld3DAnm_EventEscalatorAnimeR(fsys, anime_work) ){
			Fld3DAnm_FreeEvent3DAnimeWork(emw->JumpEffectWork);	//Aj[N
			(emw->call_seq) ++;
		}
		break;		
	case 2:			//I
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
// @brief	3:KitF[hC}bvJڃCxg(CxgR[)
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeInStairs(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	FIELD_OBJ_PTR fop;
	switch (emw->call_seq) {
	case 0:	//@ړ
		//tF[hCJn
		///FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKIN );
		FieldFadeWipeSet(FLD_DISP_BRIGHT_BLACKIN, fsys);
		fop = Player_FieldOBJGet( fsys->player );
		
		if( /*FieldOBJ_AcmdSetCheck(fop) == TRUE*/1 ){	//AjZbgł邩?
			int dir;
			dir = Player_DirGet( fsys->player );
			if (dir == DIR_LEFT){	//
				FieldOBJ_AcmdSet(fop,AC_WALK_L_16F);	//oBCӂ̃AjZbg
			}else if (dir == DIR_RIGHT){	//E
				FieldOBJ_AcmdSet(fop,AC_WALK_R_16F);	//oBCӂ̃AjZbg
			}else{
				GF_ASSERT(0&&"@̌s");
			}
		}else{
			GF_ASSERT(0&&"Ajo^łȂ");
		}
		(emw->call_seq) ++;
		break;
	case 1:	
		fop = Player_FieldOBJGet( fsys->player );
		if( FieldOBJ_AcmdEndCheck(fop) == TRUE ){	//AjI`FbN
			FieldOBJ_AcmdEnd(fop); //AjI	
			(emw->call_seq) ++;
		}
		break;
	case 2:	
		if (IsFinishedFieldFadeWipe(fsys)) {
			(emw->call_seq) ++;
		}
		break;
	case 3:		//I
		return TRUE;
	}
	return FALSE;

}

//-----------------------------------------------------------------------------
// @brief 2:WvAGXJ[^[Aj[VlA@̏ʒuύX
//-----------------------------------------------------------------------------
static void SetEscalatorIOPos(FIELDSYS_WORK *fsys)
{
	int x,z,dir;
	
	//}bvoʒu獶ւPObh̏ꏊɎ@oiGXJ[^[̂Ƃ̂݁j
	//@̍W,擾
	dir = Player_DirGet( fsys->player );
	x = Player_NowGPosXGet( fsys->player );
	z = Player_NowGPosZGet( fsys->player );
	//WZbg
	Player_GPosInit( fsys->player, x-1, z, dir );
}

//-----------------------------------------------------------------------------
// @brief 3:WvAKiAj[VlA@̏ʒuύX
//-----------------------------------------------------------------------------
static void SetStairsIOPos(FIELDSYS_WORK *fsys)
{
	int x,z,dir;
	u8 attr;
	//@݂̌āA}bvoʒu獶EPObhꂽꏊɎ@o
	//@̍W,\n
	x = Player_NowGPosXGet( fsys->player );
	z = Player_NowGPosZGet( fsys->player );
	attr = GetAttributeLSB( fsys, x, z );
	if (MATR_IsRightStairs(attr)){//EKȉꍇ
		x++;	//EւPObh
		dir = DIR_LEFT;
	}else if(MATR_IsLeftStairs(attr)){	//Kȉꍇ
		x--;	//ւPObh
		dir = DIR_RIGHT;
	}else{
		//GF_ASSERT(0&&"KiAgr[g͂Ă܂");
		OS_Printf("KiAgr[g͂Ă܂\n");
	}
	//WZbg
	Player_GPosInit( fsys->player, x, z, dir );
}

