//============================================================================================
/**
 * @file	mapdata_warp.c
 * @brief	[vpf[^֘A\[X
 * @date	2005.12.19
 */
//============================================================================================

#include "common.h"

#include "mapdata_warp.h"

#include "mapdefine.h"
#include "fieldobj_code.h"		//DIR_UP DIR_DOWN
#include "ev_mapchange.h"		//DOOR_ID_JUMP_CODE

//͂̃V{`
#include "../fielddata/warpdata/warpdata.h"

//============================================================================================
//============================================================================================
//------------------------------------------------------------------
//------------------------------------------------------------------
typedef struct {
	int room_id, room_gx, room_gz;
	int fld_id, fld_gx, fld_gz;
}WARPDATA;

//͂̃f[^`
#include "../fielddata/warpdata/warpdata.c"


//============================================================================================
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	[vID̐K
 * @param	warp_id		[vID
 * @return	int			K[vID
 *
 * sȒl͕ϊB1IW0IWɕϊB
 */
//------------------------------------------------------------------
static int RegulateWarpID(int warp_id)
{
	if(warp_id <= 0 || warp_id >= WARP_ID_MAX) {
		GF_ASSERT_MSG(0, "sȃ[vIDi%djłB\n", warp_id);
		warp_id = 1;		//iłł͂Ƃ肠̂
	}
	warp_id --;		//1 origin --> 0 origin
	return warp_id;
}

//------------------------------------------------------------------
/**
 * @brief	[vꏊ̎擾
 * @param	warp_id		[vID
 * @param	loc			ꏊ󂯎LOCATION_WORKւ̃|C^
 */
//------------------------------------------------------------------
void WARPDATA_GetWarpLocation(int warp_id, LOCATION_WORK * loc)
{
	warp_id = RegulateWarpID(warp_id);

	loc->zone_id = WarpData[warp_id].fld_id;
	loc->door_id = DOOR_ID_JUMP_CODE;
	loc->grid_x = WarpData[warp_id].fld_gx;
	loc->grid_z = WarpData[warp_id].fld_gz;
	loc->dir = DIR_DOWN;
}

//------------------------------------------------------------------
/**
 * @brief	ꏊ̎擾
 * @param	warp_id		[vID
 * @param	loc			ꏊ󂯎LOCATION_WORKւ̃|C^
 */
//------------------------------------------------------------------
void WARPDATA_GetRevivalLocation(int warp_id, LOCATION_WORK * loc)
{
	warp_id = RegulateWarpID(warp_id);

	loc->zone_id = WarpData[warp_id].room_id;
	loc->door_id = DOOR_ID_JUMP_CODE;
	loc->grid_x = WarpData[warp_id].room_gx;
	loc->grid_z = WarpData[warp_id].room_gz;
	loc->dir = DIR_UP;
}

//------------------------------------------------------------------
/**
 * @brief	[vID̎擾
 * @param	zone_id		][ID
 * @retval	int			[vIDiPIWj
 * @retval	0			Ȃ
 */
//------------------------------------------------------------------
int WARPDATA_SearchWarpData(int zone_id)
{
	int i;
	for (i = 0; i < WARP_ID_MAX; i++) {
		if (WarpData[i].room_id == zone_id) {
			return i + 1;
		}
	}
	return 0;
}


