//============================================================================================
/**
 * @file	mapdata_weather.c
 * @brief
 * @author	tamada GAME FREAK inc.
 * @date	2006.03.11
 */
//============================================================================================

#include "common.h"

#include "fieldsys.h"

#include "mapdata_weather.h"
#include "mapdata_weather_def.h"

#include "zonedata.h"

#include "system/pm_rtc.h"
#include "situation_local.h"
#include "evtime_local.h"

#define	CAL_RAIN		(WEATHER_SYS_RAIN)
#define	CAL_STRAIN		(WEATHER_SYS_STORM)
#define CAL_SPARK		(WEATHER_SYS_SPARK)
#define	CAL_RAINBOW		(WEATHER_SYS_RAINBOW)
#define	CAL_CLOUDINESS	(WEATHER_SYS_SUNNY)
#define	CAL_SNOW		(WEATHER_SYS_SNOW)
#define	CAL_SNOWSTORM	(WEATHER_SYS_SNOW_STORM_BG)
#define CAL_SNOWSTORM_H	(WEATHER_SYS_SNOW_D)
#define	CAL_DIAMONDDUST	(WEATHER_SYS_SNOW_D)
#define	CAL_FOG			(WEATHER_SYS_FOGM)
#define	CAL_SUNNY		(WEATHER_SYS_SUNNY)
#define	CAL_SANDSTORM	(WEATHER_SYS_STORM_BG)
#define	CAL_VOLCANO		(WEATHER_SYS_VOLCANO)
#define	CAL_HEATHAZE	(WEATHER_SYS_SUNNY)	/* Ƃ肠Ȃ̂ */

#include "caldata.dat"
//============================================================================================
//============================================================================================
//------------------------------------------------------------------
//------------------------------------------------------------------
int WeatherData_Get(FIELDSYS_WORK * fsys, int now_zone_id)
{
	int weather;

	weather = ZoneData_GetWeatherID(now_zone_id);
#ifdef	DEBUG_ONLY_FOR_tamada
		OS_Printf("WEATHER ID = %d\n",weather);
#endif
	if (weather < WEATHER_SYS_CAL_START) {
		return weather;
	}

	{
		int ofs;
		EVTIME * tm = Situation_GetEvTime(SaveData_GetSituation(fsys->savedata));
		ofs = GF_RTC_GetDaysOffset(&tm->sv_date) - 1;
		GF_ASSERT(ofs >= 0 && ofs < 366);
#ifdef	DEBUG_ONLY_FOR_tamada
		OS_Printf("OFFSET = %d:", ofs);
#endif
		weather = WeatherCalendar[10 * ofs + (weather - WEATHER_SYS_CAL_START)];
#ifdef	DEBUG_ONLY_FOR_tamada
		OS_Printf("NEW WEATHER ID = %d\n",weather);
#endif
	}
	return weather;

}


//============================================================================================
//============================================================================================
//------------------------------------------------------------------
//------------------------------------------------------------------

