//=============================================================================
/**
 * @file	mapresource.c
 * @bfief	tB[h}bv\[X\z
 * @author	mori         GAME FREAK inc.
 *
 *
 */
//=============================================================================

#include "common.h"
#include "height_def.h"
#include "calctool.h"
#include "str_tool.h"

#include "fieldsys.h"
#include "worldmap.h"
#include "mapresource.h"
#include "debug_saito.h"

#include "mapdefine.h"
#include "zonedata.h"
#include "mat_shp.h"
//#include "field_camera.h"
#include "system/arc_tool.h"
#include "situation_local.h"

///#define DEBUG_TEX_INFO		//eNX`\

#define BUILD_MODEL_MAX	(512)

//GbW}[LOe[u
static const GXRgb gEdgeColorField[8] = {
    GX_RGB(0, 0, 0),
    GX_RGB(4, 4, 4),
    GX_RGB(4, 4, 4),
    GX_RGB(4, 4, 4),
    GX_RGB(4, 4, 4),
    GX_RGB(4, 4, 4),
    GX_RGB(4, 4, 4),
    GX_RGB(4, 4, 4)
};
//GbW}[LOe[u
static const GXRgb gEdgeColorOther[8] = {
    GX_RGB(4, 4, 4),
    GX_RGB(4, 4, 4),
    GX_RGB(4, 4, 4),
    GX_RGB(4, 4, 4),
    GX_RGB(4, 4, 4),
    GX_RGB(4, 4, 4),
    GX_RGB(4, 4, 4),
    GX_RGB(4, 4, 4)
};
enum {
	CAMERA_TYPE1,
	CAMERA_TYPE2,
	CAMERA_TYPE3,
}CAMERA_TYPE;

enum { 
	LIGHT_TYPE1,
	LIGHT_TYPE2,
}LIGHT_TYPE;

typedef struct MAP_RES_SETUP_WORK_tag
{
	int AreaID;
	FLD_3D_ANM_MNG_PTR FldAnmMng;
	u16  Num;
	int Seq;
}MAP_RES_SETUP_WORK;

typedef struct RESOURCE_PARAM_tag
{
	u16 model_set;			//fZbgCfbNX
	u16 tex_set;		//n`eNX`ZbgCfbNX
	u16 move_model_set;		//샂fZbgCfbNX
	u16 light;				//CgtO
}RESOURCE_PARAM;

//-}bv\[X\(worldmap番)------------------------------------------------------
typedef struct _MAP_RESOURCE{
	int 				modelTableNum;	///< modelTablefOf[^̐
	NNSG3dResFileHeader	*model[BUILD_MODEL_MAX];	///< fOf[^̃|C^̃e[u
	void*				pTexFile;		///< eNX`[t@Ĉւ̃|C^
	void*				pBmTexFile;		///< zufeNX`[t@Ĉւ̃|C^
	NNSG3dResTex		*Tex;			///< eNX`\[X
	NNSG3dResTex		*BmTex;			///< zufeNX`\[X

	MSD_PTR				MatShpData;		///< 3cnaĩ}eAAVFCvΉf[^
	
	RESOURCE_PARAM ResourceParam;

	MAP_RES_SETUP_WORK *SetupWork;

	u16 *ModelFile;
	
}MAP_RESOURCE;


#ifdef PM_DEBUG
static void DebugPrintTexInfo(NNSG3dResTex *pTex);
#endif

static void CollapseResourceMemory(void* memBlock, NNSG3dResTex* texture)
{
    u8* texImgStartAddr;
    u32 newSize;

    // eNX`^pbǵA4x4COMPȊÕeNX`E4x4COMP̃eNX`Epbg
    // ̏ԂŊi[Ă܂B4x4COMPȊÕeNX`̊JnAhXȍ~
    // svɂȂ܂BȂA4x4COMPtH[}bgȊÕeNX`C[W݂Ȃ
    // ꍇłtexture->texInfo.ofsTexɂ͓K؂ȒlĂ܂B
    SDK_ASSERT(texture->texInfo.ofsTex != 0);
    texImgStartAddr = (u8*)texture + texture->texInfo.ofsTex;

    // q[v̐擪eNX`C[W܂ł̃TCY
    newSize = (u32)(texImgStartAddr - (u8*)memBlock);

    // ubNk܂B
    // ̌ʁAeNX`C[W̃̓q[vɕԋp܂B
    ///(void)NNS_FndResizeForMBlockExpHeap(G3DDemo_AppHeap, memBlock, newSize);
	sys_CutMemoryBlockSize( memBlock, newSize );
}
#if 0
//==============================================================================
/**
 * MAP_RESOURCE
 *
 * @param   area_id		GAID
 * @param	field_3d_anime	3cAj
 *
 * @retval  MAP_RESOURCE_PTR	mۂMAPRESOURCẼ|C^
 */
//==============================================================================
MAP_RESOURCE_PTR MapResourceInit(const int area_id, FLD_3D_ANM_MNG_PTR field_3d_anime)
{
#ifdef PM_DEBUG
	static int debug_tex_size;
#endif
	MAP_RESOURCE_PTR mapresource;
	char name[256];
	u16 *modelfile;
	u16  num,i,no;
	
	mapresource                = sys_AllocMemory(HEAPID_FIELD,sizeof(MAP_RESOURCE));
#ifdef DEBUG_ONLY_FOR_saitou	
	OS_Printf("local_print AREA_ID:%d\n",area_id);
#endif
	//A[JCuGAf[^擾
	ArchiveDataLoad(&mapresource->ResourceParam, ARC_AREA_DATA, area_id);
#ifdef DEBUG_ONLY_FOR_saitou	
	OS_Printf("local_print TEX_LOAD:%d\n",mapresource->ResourceParam.tex_set);
#endif

	//n`pʃeNX`ǂݍ
	mapresource->Tex = NULL;

	//AreaIDɑΉʃeNX`t@Cǂݍ
	mapresource->pTexFile = ArchiveDataLoadMalloc(	ARC_AREA_TEX_SET,
													mapresource->ResourceParam.tex_set,
													HEAPID_FIELD );
	// eNX`t@C擾
	mapresource->Tex = NNS_G3dGetTex((NNSG3dResFileHeader*) mapresource->pTexFile );
	{
		BOOL rc;
#ifdef PM_DEBUG
		{
			int szTex;
			// KvȃTCY擾
			szTex    = NNS_G3dTexGetRequiredSize(mapresource->Tex);
			OS_Printf("MAPtexsize = %d\n",szTex);
		}
#endif
		//eNX`uq`lփ[h
		rc = LoadVRAMTexture(mapresource->Tex);
		
		GF_ASSERT(rc && "eNX`VRAMmێs");
	}
	//̂j
	CollapseResourceMemory(mapresource->pTexFile, mapresource->Tex);

	//
	for(i=0;i<BUILD_MODEL_MAX;i++){
		mapresource->model[i] = NULL;
	}
	mapresource->MatShpData = NULL;

	//GAfOf[^Xgǂݍ
	modelfile = ArchiveDataLoadMalloc(	ARC_AREA_BUILD_MODEL,
										mapresource->ResourceParam.model_set,
										HEAPID_FIELD );
	
	num=0;
	num = modelfile[0];
#ifdef DEBUG_ONLY_FOR_saitou
	OS_Printf("local_print objct_num = %d\n",num);
#endif		


	debug_tex_size = 0;	
	//|C^unowv͊1sǂݔ΂ꂽmodelTable̓ewĂ̂ŎStrTok̓pX擾ɂȂ
	for(i=0;i<num;i++){
		no = modelfile[i+1];//f[^̓1Ԗڂi0Ԗڂ͌j
#ifdef DEBUG_ONLY_FOR_saitou
		OS_Printf("local_print model_no = %d\n",no);
#endif
		mapresource->model[no] = ArchiveDataLoadMalloc( ARC_3D_STRUCT, no, HEAPID_FIELD );
		{
			int type;
			type = GetFld3DAnimationType(no);
			//AjZbg
			if ((type == FLD_3D_ANIME_STATION) || (type == FLD_3D_ANIME_STATION_SUB)){
				NNSG3dResMdl* model;
				model = NNS_G3dGetMdlByIdx(NNS_G3dGetMdlSet(mapresource->model[no]), 0);
				F3DA_AddField3DAnime(	no,
										0,
										LOOP_INFINIT,
										0,
										FALSE,
										FALSE,
										model,
										field_3d_anime	);
			}
		}
				
		//eNX`WJ
		{
			BOOL rc;
			NNSG3dResTex *tex;
			
			// eNX`t@C擾
			tex = NNS_G3dGetTex((NNSG3dResFileHeader*) mapresource->model[no] );
			if(tex == NULL){
				continue;	//ƂƃeNX`Ȃ
			}

			//eNX`uq`lփ[h
#ifdef PM_DEBUG
		{
			int szTex;
			// KvȃTCY擾
			szTex    = NNS_G3dTexGetRequiredSize(tex);
			OS_Printf("texsize = %d\n",szTex);
			debug_tex_size+=szTex;
		}
#endif
			rc = LoadVRAMTexture(tex);
			GF_ASSERT(rc && "eNX`VRAMmێs");
			rc = BindTexture(mapresource->model[no], tex);
			GF_ASSERT(rc && "3cnaieNX`oChs");
		}
	}//end for
		
	//_~[f[^͏풓Ƃ
	if (mapresource->model[0] == NULL){
		BOOL rc;
		NNSG3dResTex *tex;
		mapresource->model[0] = ArchiveDataLoadMalloc( ARC_3D_STRUCT, 0, HEAPID_FIELD );
		
		// eNX`t@C擾
		tex = NNS_G3dGetTex((NNSG3dResFileHeader*) mapresource->model[0] );
		if(tex != NULL){
			//eNX`uq`lփ[h
			rc = LoadVRAMTexture(tex);
			GF_ASSERT(rc && "eNX`VRAMmێs");
			rc = BindTexture(mapresource->model[0], tex);
			GF_ASSERT(rc && "3cnaieNX`oChs");
		}
	}

	sys_FreeMemoryEz(modelfile);

	//}eAAVFCvΉf[^[h
	mapresource->MatShpData = AllocMatShpData();
	sprintf(name,"fielddata/build_model/build_model_matshp.dat");
	LoadMatShape(name, mapresource->MatShpData);

OS_Printf("model_tex_size_total=%d\n",debug_tex_size);
	
	return mapresource;
}
#endif
//==============================================================================
/**
 * MAP_RESOURCẼAP[V
 *
 * @param   area_id		GAID
 * @param	field_3d_anime	3cAj
 *
 * @retval  MAP_RESOURCE_PTR	mۂMAPRESOURCẼ|C^
 */
//==============================================================================
MAP_RESOURCE_PTR AllocMapResource(const int area_id, FLD_3D_ANM_MNG_PTR field_3d_anime)
{
	MAP_RESOURCE_PTR mapresource;
	mapresource	= sys_AllocMemory(HEAPID_FIELD,sizeof(MAP_RESOURCE));
#ifdef DEBUG_ONLY_FOR_saitou	
	OS_Printf("local_print AREA_ID:%d\n",area_id);
#endif
	//[N̊m
	mapresource->SetupWork = sys_AllocMemoryLo(HEAPID_FIELD,sizeof(MAP_RES_SETUP_WORK));
	mapresource->SetupWork->AreaID = area_id;
	mapresource->SetupWork->FldAnmMng = field_3d_anime;
	mapresource->SetupWork->Seq = 0;
	return mapresource;
}

//==============================================================================
/**
 * }bv\[XZbgAbv
 *
 * @param   outMapResource		MAPRESOURCẼ|C^
 *
 * @retval  BOOL		TRUE:I	FALSE:p	
 */
//==============================================================================
BOOL SetupMapResource(MAP_RESOURCE_PTR outMapResource)
{
#ifdef PM_DEBUG
	static int debug_tex_size;
#endif
	MAP_RES_SETUP_WORK *work = outMapResource->SetupWork;
	
	switch(work->Seq){
	case 0:
		//A[JCuGAf[^擾
		ArchiveDataLoad(&outMapResource->ResourceParam, ARC_AREA_DATA, work->AreaID);
#ifdef DEBUG_ONLY_FOR_saitou	
		OS_Printf("local_print TEX_LOAD:%d\n",outMapResource->ResourceParam.tex_set);
#endif
		//GAfOf[^Xgǂݍ
		outMapResource->ModelFile = ArchiveDataLoadMalloc(	ARC_AREA_BUILD_MODEL,
															outMapResource->ResourceParam.model_set,
															HEAPID_FIELD );
	
		work->Num = outMapResource->ModelFile[0];

		GF_ASSERT(work->Num<BUILD_MODEL_MAX&&"zufo^I[o[");	
		
		//n`pʃeNX`ǂݍ
		outMapResource->Tex = NULL;
		//AreaIDɑΉʃeNX`t@Cǂݍ
		outMapResource->pTexFile = ArchiveDataLoadMalloc(	ARC_AREA_TEX_SET,
															outMapResource->ResourceParam.tex_set,
															HEAPID_FIELD );
		//zufeNX`Zbgǂݍ
		outMapResource->pBmTexFile = ArchiveDataLoadMalloc(	ARC_BM_TEX_SET,
															outMapResource->ResourceParam.model_set,
															HEAPID_FIELD );

		// eNX`t@C擾
		outMapResource->Tex = NNS_G3dGetTex((NNSG3dResFileHeader*) outMapResource->pTexFile );
		if (work->Num != 0){
			outMapResource->BmTex = NNS_G3dGetTex((NNSG3dResFileHeader*) outMapResource->pBmTexFile );
		}else{
			outMapResource->BmTex = NULL;
		}
		//GbW}[LO
		G3X_EdgeMarking(TRUE);
		if (outMapResource->ResourceParam.light == 0) {
			G3X_SetEdgeColorTable(gEdgeColorField);
		} else {
			G3X_SetEdgeColorTable(gEdgeColorOther);
		}
		(work->Seq)++;
		break;

	case 1:
		{
			BOOL rc;
#ifdef DEBUG_TEX_INFO
			DebugPrintTexInfo(outMapResource->Tex);
#endif
			//eNX`uq`lփ[h
			rc = LoadVRAMTexture(outMapResource->Tex);
			GF_ASSERT(rc && "eNX`VRAMmێs");
		}
		//̂j
		CollapseResourceMemory(outMapResource->pTexFile, outMapResource->Tex);

		(work->Seq)++;
		break;
		
	case 2:
		if (outMapResource->BmTex != NULL){
			BOOL rc;
#ifdef DEBUG_TEX_INFO
			DebugPrintTexInfo(outMapResource->BmTex);
#endif		
			//eNX`uq`lփ[h
			rc = LoadVRAMTexture(outMapResource->BmTex);
			GF_ASSERT(rc && "eNX`VRAMmێs");
		
			//̂j
			CollapseResourceMemory(outMapResource->pBmTexFile, outMapResource->BmTex);
		}
		
		(work->Seq)++;
		break;
	case 3:
		{
			int i;
			//
			for(i=0;i<BUILD_MODEL_MAX;i++){
				outMapResource->model[i] = NULL;
			}
			outMapResource->MatShpData = NULL;
/**
			//GAfOf[^Xgǂݍ
			work->ModelFile = ArchiveDataLoadMalloc(	ARC_AREA_BUILD_MODEL,
														outMapResource->ResourceParam.model_set,
														HEAPID_FIELD );
	
			work->Num = work->ModelFile[0];
*/			
#ifdef DEBUG_ONLY_FOR_saitou
			OS_Printf("local_print objct_num = %d\n",work->Num);
#endif		
			debug_tex_size = 0;	
		}

		(work->Seq)++;
		break;
	
	case 4:
		{
			int i;
			u16 no;
			//|C^unowv͊1sǂݔ΂ꂽmodelTable̓ewĂ̂ŎStrTok̓pX擾ɂȂ
			for(i=0;i<work->Num;i++){
				no = outMapResource->ModelFile[i+1];//f[^̓1Ԗڂi0Ԗڂ͌j
#ifdef DEBUG_ONLY_FOR_saitou
				OS_Printf("local_print model_no = %d\n",no);
#endif
				GF_ASSERT((outMapResource->model[no]==NULL)&&"zuf̂Qdo^̉\");
				outMapResource->model[no] = ArchiveDataLoadMalloc( ARC_3D_STRUCT, no, HEAPID_FIELD );
				{
					//AjZbg
					NNSG3dResMdl* model;
					model = NNS_G3dGetMdlByIdx(NNS_G3dGetMdlSet(outMapResource->model[no]), 0);
/**					
					F3DA_AddField3DAnime(	no,
											0,
											LOOP_INFINIT,
											0,
											FALSE,
											FALSE,
											FALSE,
											model,
											outMapResource->BmTex,
											work->FldAnmMng	);
*/											
					F3DA_AddField3DAnimeEasy(	no,
												model,
												outMapResource->BmTex,
												work->FldAnmMng	);
				}
				
				//eNX`oCh
				{
					BOOL rc;
					rc = BindTexture(outMapResource->model[no], outMapResource->BmTex);
					GF_ASSERT(rc && "3cnaieNX`oChs");
				}
#ifdef DEBUG_TEX_INFO				
				{
					NNSG3dResTex *tex;
					// eNX`t@C擾
					tex = NNS_G3dGetTex((NNSG3dResFileHeader*) outMapResource->model[no] );
					if(tex != NULL){
						DebugPrintTexInfo(tex);
					}
				}
#endif				
#if 0				
				//eNX`WJ
				{
					BOOL rc;
					NNSG3dResTex *tex;
			
					// eNX`t@C擾
					tex = NNS_G3dGetTex((NNSG3dResFileHeader*) outMapResource->model[no] );
					if(tex == NULL){
						continue;	//ƂƃeNX`Ȃ
					}

					//eNX`uq`lփ[h
#ifdef PM_DEBUG
					{
						int szTex;
						// KvȃTCY擾
						szTex    = NNS_G3dTexGetRequiredSize(tex);
						OS_Printf("texsize = %d\n",szTex);
						debug_tex_size+=szTex;
					}
#endif
					rc = LoadVRAMTexture(tex);
					GF_ASSERT(rc && "eNX`VRAMmێs");
					rc = BindTexture(outMapResource->model[no], tex);
					GF_ASSERT(rc && "3cnaieNX`oChs");
				}
#endif	//20060127 del				
			}//end for
		}

		(work->Seq)++;
		break;
	case 5:
		
		//_~[f[^͏풓Ƃ
		if (outMapResource->model[0] == NULL){
			BOOL rc;
			NNSG3dResTex *tex;
			outMapResource->model[0] = ArchiveDataLoadMalloc( ARC_3D_STRUCT, 0, HEAPID_FIELD );
		
			// eNX`t@C擾
			tex = NNS_G3dGetTex((NNSG3dResFileHeader*) outMapResource->model[0] );
			if(tex != NULL){
				//eNX`uq`lփ[h
				rc = LoadVRAMTexture(tex);
				GF_ASSERT(rc && "eNX`VRAMmێs");
				rc = BindTexture(outMapResource->model[0], tex);
				GF_ASSERT(rc && "3cnaieNX`oChs");
			}
		}
		///sys_FreeMemoryEz(work->ModelFile);
		{
			char name[256];
			//}eAAVFCvΉf[^[h
			outMapResource->MatShpData = AllocMatShpData();
			sprintf(name,"fielddata/build_model/build_model_matshp.dat");
			LoadMatShape(name, outMapResource->MatShpData);
		}

OS_Printf("model_tex_size_total=%d\n",debug_tex_size);
		//[N̉
		sys_FreeMemoryEz(outMapResource->SetupWork);
		outMapResource->SetupWork = NULL;
		return TRUE;
	}
	return FALSE;
}

//==============================================================================
/**
 * }bv\[XZbgAbvi1syncŃZbgAbvj
 *
 * @param   outMapResource		MAPRESOURCẼ|C^
 *
 * @retval  none	
 */
//==============================================================================
void SetupMapResourceQuick(MAP_RESOURCE_PTR outMapResource)
{
#ifdef PM_DEBUG
	static int debug_tex_size;
#endif
	MAP_RES_SETUP_WORK *work = outMapResource->SetupWork;
	
	//A[JCuGAf[^擾
	ArchiveDataLoad(&outMapResource->ResourceParam, ARC_AREA_DATA, work->AreaID);
	
#ifdef DEBUG_ONLY_FOR_saitou	
	OS_Printf("local_print TEX_LOAD:%d\n",outMapResource->ResourceParam.tex_set);
#endif

	//GAfOf[^Xgǂݍ
	outMapResource->ModelFile = ArchiveDataLoadMalloc(	ARC_AREA_BUILD_MODEL,
														outMapResource->ResourceParam.model_set,
														HEAPID_FIELD );
	work->Num = outMapResource->ModelFile[0];

	GF_ASSERT(work->Num<BUILD_MODEL_MAX&&"zufo^I[o[");
	
	//n`pʃeNX`ǂݍ
	outMapResource->Tex = NULL;
	//AreaIDɑΉʃeNX`t@Cǂݍ
	outMapResource->pTexFile = ArchiveDataLoadMalloc(	ARC_AREA_TEX_SET,
														outMapResource->ResourceParam.tex_set,
														HEAPID_FIELD );
	//zufeNX`Zbgǂݍ
	outMapResource->pBmTexFile = ArchiveDataLoadMalloc(	ARC_BM_TEX_SET,
														outMapResource->ResourceParam.model_set,
														HEAPID_FIELD );
	// eNX`t@C擾
	outMapResource->Tex = NNS_G3dGetTex((NNSG3dResFileHeader*) outMapResource->pTexFile );
	if (work->Num != 0){
		outMapResource->BmTex = NNS_G3dGetTex((NNSG3dResFileHeader*) outMapResource->pBmTexFile );
	}else{
		outMapResource->BmTex = NULL;
	}

	{
		BOOL rc;
#ifdef DEBUG_TEX_INFO
		DebugPrintTexInfo(outMapResource->Tex);
#endif
		//eNX`uq`lփ[h
		rc = LoadVRAMTexture(outMapResource->Tex);
		GF_ASSERT(rc && "eNX`VRAMmێs");
	}
	//̂j
	CollapseResourceMemory(outMapResource->pTexFile, outMapResource->Tex);
	
	if (outMapResource->BmTex != NULL){
		BOOL rc;
#ifdef DEBUG_TEX_INFO
		DebugPrintTexInfo(outMapResource->BmTex);
#endif		
		//eNX`uq`lփ[h
		rc = LoadVRAMTexture(outMapResource->BmTex);
		GF_ASSERT(rc && "eNX`VRAMmێs");
		//̂j
		CollapseResourceMemory(outMapResource->pBmTexFile, outMapResource->BmTex);
	}
	
	{
		int i;
		//
		for(i=0;i<BUILD_MODEL_MAX;i++){
			outMapResource->model[i] = NULL;
		}
		outMapResource->MatShpData = NULL;
/**		
		//GAfOf[^Xgǂݍ
		work->ModelFile = ArchiveDataLoadMalloc(	ARC_AREA_BUILD_MODEL,
													outMapResource->ResourceParam.model_set,
													HEAPID_FIELD );
	
		work->Num = work->ModelFile[0];
*/		
#ifdef DEBUG_ONLY_FOR_saitou
		OS_Printf("local_print objct_num = %d\n",work->Num);
#endif		
		debug_tex_size = 0;	
	}

	{
		int i;
		u16 no;
		//|C^unowv͊1sǂݔ΂ꂽmodelTable̓ewĂ̂ŎStrTok̓pX擾ɂȂ
		for(i=0;i<work->Num;i++){
			no = outMapResource->ModelFile[i+1];//f[^̓1Ԗڂi0Ԗڂ͌j
#ifdef DEBUG_ONLY_FOR_saitou
			OS_Printf("local_print model_no = %d\n",no);
#endif
			GF_ASSERT((outMapResource->model[no]==NULL)&&"zuf̂Qdo^̉\");
			outMapResource->model[no] = ArchiveDataLoadMalloc( ARC_3D_STRUCT, no, HEAPID_FIELD );
			{
				//AjZbg
				NNSG3dResMdl* model;
				model = NNS_G3dGetMdlByIdx(NNS_G3dGetMdlSet(outMapResource->model[no]), 0);
/**				
				F3DA_AddField3DAnime(	no,
										0,
										LOOP_INFINIT,
										0,
										FALSE,
										FALSE,
										FALSE,
										model,
										outMapResource->BmTex,
										work->FldAnmMng	);
*/
				F3DA_AddField3DAnimeEasy(	no,
											model,
											outMapResource->BmTex,
											work->FldAnmMng	);
			}

			//eNX`oCh
			{
				BOOL rc;
				rc = BindTexture(outMapResource->model[no], outMapResource->BmTex);
				GF_ASSERT(rc && "3cnaieNX`oChs");
			}
#ifdef DEBUG_TEX_INFO				
			{
				NNSG3dResTex *tex;
				// eNX`t@C擾
				tex = NNS_G3dGetTex((NNSG3dResFileHeader*) outMapResource->model[no] );
				if(tex != NULL){
					DebugPrintTexInfo(tex);
				}
			}
#endif				
				
		}//end for
	}

		
	//_~[f[^͏풓Ƃ
	if (outMapResource->model[0] == NULL){
		BOOL rc;
		NNSG3dResTex *tex;
		outMapResource->model[0] = ArchiveDataLoadMalloc( ARC_3D_STRUCT, 0, HEAPID_FIELD );

		OS_Printf("uĂȂ̂ŁA_~[o^\n");
		
		// eNX`t@C擾
		tex = NNS_G3dGetTex((NNSG3dResFileHeader*) outMapResource->model[0] );
		if(tex != NULL){
			//eNX`uq`lփ[h
			rc = LoadVRAMTexture(tex);
			GF_ASSERT(rc && "eNX`VRAMmێs");
			rc = BindTexture(outMapResource->model[0], tex);
			GF_ASSERT(rc && "3cnaieNX`oChs");
			//eNX`oCh
			{
				BOOL rc;
				rc = BindTexture(outMapResource->model[0], tex);
				GF_ASSERT(rc && "3cnaieNX`oChs");
			}
		}
	}
#if	1
		G3X_EdgeMarking(TRUE);
		if (outMapResource->ResourceParam.light == 0) {
			G3X_SetEdgeColorTable(gEdgeColorField);
		} else {
			G3X_SetEdgeColorTable(gEdgeColorOther);
		}
#endif
	///sys_FreeMemoryEz(work->ModelFile);
	{
		char name[256];
		//}eAAVFCvΉf[^[h
		outMapResource->MatShpData = AllocMatShpData();
		sprintf(name,"fielddata/build_model/build_model_matshp.dat");
		LoadMatShape(name, outMapResource->MatShpData);
	}

OS_Printf("model_tex_size_total=%d\n",debug_tex_size);
		//[N̉
	sys_FreeMemoryEz(outMapResource->SetupWork);
	outMapResource->SetupWork = NULL;
}

#if 0
//==============================================================================
/**
 * }bv\[X쐬AZbgAbv
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @retval  MAP_RESOURCE_PTR	mۂMAPRESOURCẼ|C^
 */
//==============================================================================
void SetupMapResource(FIELDSYS_WORK *fsys)
{
	int camera_id = Situation_GetCameraID(SaveData_GetSituation(fsys->savedata));
	FieldCameraInit(
			Player_VecPosPtrGet(fsys->player), fsys, camera_id);	// Jݒ
			//Player_VecPosPtrGet(fsys->player), fsys, CAMERA_TYPE1);	// Jݒ
/**
	if (ptr->ResourceParam.light == 0 ){
		light_idx = LIGHT_TYPE2;
	}else{
		light_idx = LIGHT_TYPE1;
	}
	fsys->light_cont_data = InitLightCont(fsys->glst_data, light_idx);
*/	
}
#endif
//==============================================================================
/**
 * GAɑΉfOf[^t@C̎擾
 *
 * @param   index		fID
 * @param   mapresource		WORLD_MAP̃|C^
 *
 * @retval  NNSG3dResFileHeader**		fOf[^̃|C^
 */
//==============================================================================
NNSG3dResFileHeader** GetMapResourceModelRes(const int index, const MAP_RESOURCE_PTR mapresource)
{
	GF_ASSERT((mapresource!=NULL) && "mapresourcemapm");
#ifdef PM_DEBUG
	if (mapresource->model[index] == NULL){
		OS_Printf("index = %d zufo^G[ _~[\܂\n",index);
		GF_ASSERT(mapresource->model[0]!=NULL&&"_~[o^ĂȂ\n");
		//NULLf[^A_~[{bNXԂ悤ɂĂ
		return &(mapresource->model[0]);	
	}
#endif
	
	
	///GF_ASSERT((mapresource->model[index] != NULL)&&"fOf[^o^Ă܂");
	return &(mapresource->model[index]);	
	
}

//==============================================================================
/**
 * MAP_RESOURCẺ
 *
 * @param   mapresource		MAP_RESOURCẼ|C^
 *
 * @retval  none		
 */
//==============================================================================
void ReleaseMapResource(MAP_RESOURCE_PTR *mapresource)
{
	int i;

	//}eAAVFCvΉf[^
	if ((*mapresource)->MatShpData != NULL){
		FreeMatShpData((*mapresource)->MatShpData);
	}

	for(i=0;i<BUILD_MODEL_MAX;i++){
		if((*mapresource)->model[i]!=NULL){
			sys_FreeMemoryEz((*mapresource)->model[i]);
		}
	}
	sys_FreeMemoryEz((*mapresource)->ModelFile);
	
	sys_FreeMemoryEz((*mapresource)->pTexFile);			// tB[hʃeNX`
	(*mapresource)->pTexFile   = NULL;
	sys_FreeMemoryEz((*mapresource)->pBmTexFile);			// zufeNX`
	(*mapresource)->pBmTexFile   = NULL;
	sys_FreeMemoryEz((*mapresource));						// [h}bv
	(*mapresource) = NULL;
}

//==============================================================================
/**
 * eNX`t@C̎̂̃|C^Ԃ
 *
 * @param   mapresource		WORLD_MAP̃|C^
 *
 * @retval  NNSG3dResTex *		eNX`f[^̃|C^
 */
//==============================================================================
NNSG3dResTex *GetMapResourceTexturePTR(const MAP_RESOURCE_PTR mapresource)
{
	GF_ASSERT((mapresource!=NULL) && "mapresourcemapm");

	return mapresource->Tex;	
}

//==============================================================================
/**
 * eNX`t@C̎̂̃|C^Ԃ
 *
 * @param   mapresource		WORLD_MAP̃|C^
 *
 * @retval  NNSG3dResTex *		eNX`f[^̃|C^
 */
//==============================================================================
NNSG3dResTex *GetMapResourceBmTexturePTR(const MAP_RESOURCE_PTR mapresource)
{
	GF_ASSERT((mapresource!=NULL) && "mapresourcemapm");

	return mapresource->BmTex;	
}

//==============================================================================
/**
 * }eAAVFCvΉf[^ւ̃|C^擾֐
 *
 * @param   mapresource		}bv\[X̃|C^
 *
 * @retval  MSD_CONST_PTR	}eAAVFCvΉf[^ւ̃|C^
 */
//==============================================================================

MSD_CONST_PTR GetMatShpDataPtr(const MAP_RESOURCE_PTR mapresource)
{
	return mapresource->MatShpData;
}

//==============================================================================
/**
 * CgLǂ̎擾֐
 *
 * @param   mapresource		}bv\[X̃|C^
 *
 * @retval  BOOL	TRUE:CgL		FALSE:Cg
 */
//==============================================================================
BOOL MAPRES_IsValidLight(const MAP_RESOURCE_PTR mapresource)
{
	if (mapresource->ResourceParam.light){
		return TRUE;
	}else{
		return FALSE;
	}
}

//==============================================================================
/**
 * CgCfbNX擾
 *
 * @param   mapresource		}bv\[X̃|C^
 *
 * @retval  light_idx	CgCfbNX
 */
//==============================================================================
u8 MAPRES_GetLightIndex(const MAP_RESOURCE_PTR mapresource)
{
	u8 light_idx; 
	if (mapresource->ResourceParam.light == 0 ){
		light_idx = LIGHT_TYPE2;
	}else{
		light_idx = LIGHT_TYPE1;
	}
	return light_idx;
}


#ifdef PM_DEBUG
BOOL CheckResourceEntry(const MAP_RESOURCE_PTR mapresource, const int inID)
{
	if ( mapresource->model[inID] == NULL ){
		return FALSE;
	}else{
		return TRUE;
	}
}

static void DebugPrintTexInfo(NNSG3dResTex *pTex)
{
	int szTex,numTex;
	// KvȃTCY擾
	szTex    = NNS_G3dTexGetRequiredSize(pTex);
	numTex = pTex->dict.numEntry;
	OS_Printf("texsize = %d\n",szTex);
	OS_Printf("texnum = %d\n",numTex);
	{
		u32 fmt;
		int w,h;
		int i;
		int size;
		int total;
		total = 0;
		for(i=0;i<numTex;i++){
			const NNSG3dResName* name = NNS_G3dGetResNameByIdx(&pTex->dict, i);
			const NNSG3dResDictTexData* texData = NNS_G3dGetTexDataByName(pTex, name);
			fmt = (texData->texImageParam >> 26) & 7;
			size = (texData->extraParam & 0x3ff) * ( (texData->extraParam >> 11) & 0x3ff );
			switch(fmt){
			case 1:
				//RES_PRINTF("a3i5");
				break;
			case 2:
				//RES_PRINTF("palette4");
				size/=4;
				break;
			case 3:
				//RES_PRINTF("palette16");
				size/=2;
				break;
			case 4:
				//RES_PRINTF("palette256");
				break;
			case 5:
				//RES_PRINTF("tex4x4");
				break;
			case 6:
				//RES_PRINTF("a5i3");
				break;
			case 7:
				//RES_PRINTF("direct");
				break;
			}
			total+=size;
			OS_Printf("fmt=%d\n",fmt );
			OS_Printf("Addr=%d\n",(texData->texImageParam & 0xffff) << 3 );
		}//end for
	}
}

#endif //PM_DEBUG

