//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		motion_bl.c
 *@brief	[Vu[
 *@author	 tomoya takahashi
 *@data		2005.07.27
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include "common.h"
#define __MOTION_BL_H_GLOBAL
#include "motion_bl.h"
#include "system/lib_pack.h"

#include "gflib/itask.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	[Vu[IuWFNg
//	
//=====================================
typedef struct _MOTION_BL_TASK{
	GXVRamLCDC		lcdc;		// LCDC
	MOTION_BL_DATA	data;
	TCB_PTR			tcb;	
} MOTION_BL_TASK;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void VBlankLCDCChange(TCB_PTR tcb, void* work);	// LCDC̏Ԃݒ肷^XN
static void MOTION_BL_Task(TCB_PTR tcb, void* work);		// [Vu[^XN



//----------------------------------------------------------------------------
/**
 *
 *@brief	[Vu[gԂɏ
 *
 *@param	init		f[^
 *
 *@return	MOTION_BL_PTR	[Vu[IuWFNg
 *
 *
 */
//-----------------------------------------------------------------------------
MOTION_BL_PTR MOTION_BL_Init(MOTION_BL_DATA* init)
{
	TCB_PTR task;
	MOTION_BL_PTR mb;
	
	// [Vu[^XNZbg
	task = PMDS_taskAdd(MOTION_BL_Task, sizeof(MOTION_BL_TASK), 5, init->heap_id);
	mb = TCB_GetWork(task);

	mb->data = *init;
	mb->tcb = task;

	
	
	mb->lcdc = GX_GetBankForLCDC();
	

	GX_SetCapture(
			mb->data.sz,			// Lv`TCY
			mb->data.mode,			// Lv`[h
            mb->data.a,				// Lv`uhA
            mb->data.b,				// Lv`uhB
            mb->data.dest,			// ]Vram
            16,						// uhWA
            0);						// uhWB	

	// LCDC`FW
	VWaitTCB_Add( VBlankLCDCChange, mb, 0 );
//	addVBlankData(mb, VBlankLCDCChange);

	return mb;
}



//----------------------------------------------------------------------------
/**
 *
 *@brief	[Vu[̉
 *
 *@param	data		[Vu[IuWF
 *@param	dispMode	̃fBXvC[h
 *@param	bgMode		BG[h
 *@param	bg0_2d3d	BGORDɎgp邩
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void MOTION_BL_Delete(MOTION_BL_PTR* data, GXDispMode dispMode, GXBGMode bgMode, GXBG0As bg0_2d3d)
{
	

	// OtBbN[h߂
	GX_SetGraphicsMode(dispMode, bgMode,bg0_2d3d);

	GX_SetBankForLCDC((*data)->lcdc);
	
	switch((*data)->data.dispMode){
	case GX_DISPMODE_VRAM_A:
		MI_CpuClearFast( (void*)HW_LCDC_VRAM_A, HW_VRAM_A_SIZE );
		break;
	case GX_DISPMODE_VRAM_B:
		MI_CpuClearFast( (void*)HW_LCDC_VRAM_B, HW_VRAM_B_SIZE );
		break;
	case GX_DISPMODE_VRAM_C:
		MI_CpuClearFast( (void*)HW_LCDC_VRAM_C, HW_VRAM_C_SIZE );
		break;
	case GX_DISPMODE_VRAM_D:
		MI_CpuClearFast( (void*)HW_LCDC_VRAM_D, HW_VRAM_D_SIZE );
		break;
	default:
		GX_SetBankForLCDC(GX_VRAM_LCDC_NONE);
		break;
	}
		
	
	// ^XNj
	PMDS_taskDel((*data)->tcb);
	*data = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	rŃp[^ύX
 *
 *@param	data	[Vu[IuWF
 *@param	eva		uhWA
 *@param	evb		uhWB
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void MOTION_BL_ParamChg(MOTION_BL_PTR data, int eva, int evb)
{
	data->data.eva = eva;
	data->data.evb = evb;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	[Vu[@Lv`^XN
 *
 *@param	tcb		^XN|C^
 *@param	work	[Vu[f[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void MOTION_BL_Task(TCB_PTR tcb, void* work)
{
	MOTION_BL_PTR mb = work;
	
	GX_SetCapture(
			mb->data.sz,			// Lv`TCY
			mb->data.mode,			// Lv`[h
            mb->data.a,				// Lv`uhA
            mb->data.b,				// Lv`uhB
            mb->data.dest,			// ]Vram
            mb->data.eva,			// uhWA
            mb->data.evb);			// uhWB
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LCDC̏Ԃݒ肷^XN
 *
 *@param	work	ݒ肷lĂ
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void VBlankLCDCChange(TCB_PTR tcb, void* work)
{
	MOTION_BL_PTR mb = (MOTION_BL_PTR)work;

		
	
	// `Vramݒ
	switch(mb->data.dispMode){
	case GX_DISPMODE_VRAM_A:
		GX_SetBankForLCDC(GX_VRAM_LCDC_A);
		break;
	case GX_DISPMODE_VRAM_B:
		GX_SetBankForLCDC(GX_VRAM_LCDC_B);
		break;
	case GX_DISPMODE_VRAM_C:
		GX_SetBankForLCDC(GX_VRAM_LCDC_C);
		break;
	case GX_DISPMODE_VRAM_D:
		GX_SetBankForLCDC(GX_VRAM_LCDC_D);
		break;
	default:
		GX_SetBankForLCDC(GX_VRAM_LCDC_NONE);
		break;
	}

	// OtBbN[hݒ
	GX_SetGraphicsMode(mb->data.dispMode, mb->data.bgMode,mb->data.bg0_2d3d);	

	TCB_Delete( tcb );
}
