//******************************************************************************
/**
 *
 * @file	player.c
 * @brief	@
 * @author	kagaya
 * @data	05.08.03
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "fieldobj.h"
#include "player.h"
#include "div_map.h"
#include "field_effect.h"

#include "mapdefine.h"

//==============================================================================
//	define
//==============================================================================
//--------------------------------------------------------------
///	rbg
//--------------------------------------------------------------
#define JIKI_MOVE_BIT_NON				(0)			///<
#define JIKI_MOVE_BIT_FORCE 			(1<<0)		///<ړ
#define JIKI_MOVE_BIT_UNDER_OFF			(1<<1)		///<
#define JIKI_MOVE_BIT_CYCLE_BRAKE		(1<<3)		///<]ԃu[L

//==============================================================================
//	struct
//==============================================================================
//--------------------------------------------------------------
//	PLAYER_STATE\
//--------------------------------------------------------------
struct _TAG_PLAYER_STATE
{
	u32 move_bit;											///<tO
	u32 request_bit;										///<NGXg
	u32 set_ac;												///<ZbgAj[VR[h
	int move_value;											///< OBJ_MOVE_VALUE_STOP
	int move_state;											///< OBJ_MOVE_STATE_OFF
	int form;												///<` HERO_FORM_NORMAL
	int sex;												///< PM_MALE
	int speed;												///<@Xs[h
	int input_key_dir_x;									///<L[͕
	int input_key_dir_z;									///<L[͕
	FIELD_OBJ_PTR fldobj;									///<@ptB[hOBJ *
	EOA_PTR joint_eoa;										///<ڑEOA
	PLAYER_SAVE_DATA *savedata;
	const PLAYER_SAVE_DATA *save;							///<Z[uf[^Q*
}PLAYER_STATE;

#define PLAYER_STATE_SIZE (sizeof(PLAYER_STATE))

//==============================================================================
//	static
//==============================================================================
static PLAYER_STATE_PTR Jiki_WorkAlloc( void );
static void Jiki_WorkInit( PLAYER_STATE_PTR jiki, int form, int sex, PLAYER_SAVE_DATA *save );
static void Jiki_FieldOBJAdd(
		PLAYER_STATE_PTR jiki, CONST_FIELD_OBJ_SYS_PTR fos, int obj, int dir, int x, int z );
static FIELD_OBJ_PTR Jiki_FieldOBJSearch( CONST_FIELD_OBJ_SYS_PTR fos );

static void Jiki_MoveBitSet( PLAYER_STATE_PTR jiki, u32 bit );
static void Jiki_MoveBitON( PLAYER_STATE_PTR jiki, u32 bit );
static void Jiki_MoveBitOFF( PLAYER_STATE_PTR jiki, u32 bit );
static u32 Jiki_MoveBitCheck( PLAYER_STATE_PTR jiki, u32 bit );
static void Jiki_SaveDataPtrSet( PLAYER_STATE_PTR jiki, PLAYER_SAVE_DATA *save );

//==============================================================================
//	debug
//==============================================================================

//==============================================================================
//	@
//==============================================================================
//--------------------------------------------------------------
/**
 * @
 * @param	fos			CONST_FIELD_OBJ_SYS_PTR
 * @param	x			ǉObhXW
 * @param	z			ǉObhYW
 * @param	dir			 DIR_UP
 * @param	form		@`ԁ@HERO_FORM_NORMAL
 * @param	sex			ʁ@PM_MALE
 * @param	save		PLAYER_SAVE_DATA * NULL=QƂȂ
 * @retval	PLAYER_STATE_PTR	ǉꂽPLAYER_STATE_PTR
 */
//--------------------------------------------------------------
PLAYER_STATE_PTR Player_Init( CONST_FIELD_OBJ_SYS_PTR fos,
		int x, int z, int dir, int form, int sex, PLAYER_SAVE_DATA *save )
{
	PLAYER_STATE_PTR jiki;
	
	jiki = Jiki_WorkAlloc();
	Jiki_WorkInit( jiki, form, sex, save );
	
	{
		int code = Player_FormSexOBJCodeGet( form, sex );
		Jiki_FieldOBJAdd( jiki, fos, code, dir, x, z );
	}
	
#ifdef PLAYER_DEBUG
	DEBUG_Player_Init( jiki );
#endif
	
	return( jiki );
}

//--------------------------------------------------------------
/**
 * @@tB[hOBJgpĕ
 * @param	fos			CONST_FIELD_OBJ_SYS_PTR
 * @param	save		PLAYER_SAVE_DATA *
 * @retval	PLAYER_STATE_PTR	ǉꂽPLAYER_STATE_PTR
 */
//--------------------------------------------------------------
PLAYER_STATE_PTR Player_FieldOBJUseRecover(
		CONST_FIELD_OBJ_SYS_PTR fos, PLAYER_SAVE_DATA *save )
{
	PLAYER_STATE_PTR jiki;
	FIELD_OBJ_PTR fldobj;
	
	jiki = Jiki_WorkAlloc();
	fldobj = Jiki_FieldOBJSearch( fos );
	
	{
		int code = FieldOBJ_OBJCodeGet( fldobj );
		int form = Player_OBJCodeFormGet( code );
		int sex = Player_OBJCodeSexGet( code );
		Jiki_WorkInit( jiki, form, sex, save );
	}
	
	{
		FieldOBJ_StatusBit_ON(
				fldobj,
				FLDOBJ_STA_BIT_ZONE_DEL_NOT |
				FLDOBJ_STA_BIT_HEIGHT_VANISH_OFF );
		Player_FieldOBJSet( jiki, fldobj );
	}
	
#ifdef PLAYER_DEBUG
	DEBUG_Player_Init( jiki );
#endif
	
	return( jiki );
}

//--------------------------------------------------------------
/**
 * @@`揉
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_DrawInit( PLAYER_STATE_PTR jiki )
{
	int code;
	FIELD_OBJ_PTR fldobj;
	CONST_FIELD_OBJ_SYS_PTR fos;
	
	fldobj = Player_FieldOBJGet( jiki );
	GF_ASSERT( fldobj != NULL && "Player_DrawInit() @tB[hOBJ܂" );
	
	fos = FieldOBJ_FieldOBJSysGet( fldobj );
	code = FieldOBJ_OBJCodeGet( fldobj );
	FieldOBJ_BlActResmRegularAdd_Tex( fos, code );
	
	FE_PlayerExitArrow_Add( jiki );
}

//--------------------------------------------------------------
/**
 * @폜
 * @param	player			JPLAYER_STATE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_Delete( PLAYER_STATE_PTR jiki )
{
	FieldOBJ_Delete( Player_FieldOBJGet(jiki) );		//@ޔAAo܂ŉō폜
	sys_FreeMemoryEz( jiki );
}

//--------------------------------------------------------------
/**
 * @p[Nm
 * @param	nothing
 * @retval	PLAYER_STATE_PTR	mۂPLAYER_STATE_PTR
 */
//--------------------------------------------------------------
static PLAYER_STATE_PTR Jiki_WorkAlloc( void )
{
	PLAYER_STATE_PTR jiki;
	
	jiki = sys_AllocMemory( HEAPID_WORLD, PLAYER_STATE_SIZE );
	GF_ASSERT( jiki != NULL && "player init work alloc error" );
	memset( jiki, 0, PLAYER_STATE_SIZE );
	
	return( jiki );
}

//--------------------------------------------------------------
/**
 * @[N
 * @param	jiki	PLAYER_STATE_PTR
 * @param	form	HERO_FORM_NORMAL
 * @param	sex		PM_MALE
 * @param	save	PLAYER_SAVE_DATA *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Jiki_WorkInit( PLAYER_STATE_PTR jiki, int form, int sex, PLAYER_SAVE_DATA *save )
{
	Player_MoveValueSet( jiki, OBJ_MOVE_VALUE_STOP );
	Player_MoveStateSet( jiki, OBJ_MOVE_STATE_OFF );
	Player_FormSet( jiki, form );
	Player_SexSet( jiki, sex );
	Player_RequestBit_Set( jiki, HERO_REQBIT_NON );
	Player_MoveBitSet_UnderOFF( jiki, TRUE );
	Player_MoveSpeedSet( jiki, JIKI_SPEED_0 );
	Player_InputKeyDirXSet( jiki, DIR_NOT );
	Player_InputKeyDirZSet( jiki, DIR_NOT );
	Player_AcmdCodeSet( jiki, ACMD_NOT );
	Jiki_SaveDataPtrSet( jiki, save );
}

//--------------------------------------------------------------
/**
 * @tB[hOBJǉ
 * @param	jiki		PLAYER_STATE_PTR
 * @param	fos			FIELD_OBJ_SYS_PTR
 * @param	obj			OBJR[hBHERO
 * @param	dir			BDIR_UP
 * @param	x			ObhXW
 * @param	y			ObhYW
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Jiki_FieldOBJAdd(
		PLAYER_STATE_PTR jiki, CONST_FIELD_OBJ_SYS_PTR fos, int obj, int dir, int x, int z )
{
	FIELD_OBJ_PTR fldobj;
	
	fldobj = FieldOBJ_AddHMake( fos, x, z, dir, obj, MV_PLAYER, ZONE_ID_NOTHING );
	GF_ASSERT( fldobj != NULL && "player init obj add error" );
	
	FieldOBJ_OBJIDSet( fldobj, FLDOBJ_ID_PLAYER );
	FieldOBJ_EventTypeSet( fldobj, 0 );
	FieldOBJ_EventFlagSet( fldobj, 0 );
	FieldOBJ_EventIDSet( fldobj, 0 );
	FieldOBJ_ParamSet( fldobj, 0, FLDOBJ_PARAM_0 );
	FieldOBJ_ParamSet( fldobj, 0, FLDOBJ_PARAM_1 );
	FieldOBJ_ParamSet( fldobj, 0, FLDOBJ_PARAM_2 );
	FieldOBJ_MoveLimitXSet( fldobj, MOVE_LIMIT_NOT );
	FieldOBJ_MoveLimitZSet( fldobj, MOVE_LIMIT_NOT );
	
	FieldOBJ_StatusBit_ON(
			fldobj,
			FLDOBJ_STA_BIT_ZONE_DEL_NOT |
			FLDOBJ_STA_BIT_HEIGHT_VANISH_OFF );
	
	Player_FieldOBJSet( jiki, fldobj );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ玩@tB[hOBJ@O
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @retval	FIELD_OBJ_PTR	@tB[hOBJ
 */
//--------------------------------------------------------------
FIELD_OBJ_PTR Player_FieldOBJSearch( CONST_FIELD_OBJ_SYS_PTR fos )
{
	int i = 0;
	FIELD_OBJ_PTR fldobj = NULL;
	
	while( FieldOBJSys_FieldOBJSearch(fos,&fldobj,&i,FLDOBJ_STA_BIT_USE) ){
		if( FieldOBJ_MoveCodeGet(fldobj) == MV_PLAYER ){
			break;
		}
	}
	
	return( fldobj );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ玩@tB[hOBJ
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @retval	FIELD_OBJ_PTR	@tB[hOBJ
 */
//--------------------------------------------------------------
static FIELD_OBJ_PTR Jiki_FieldOBJSearch( CONST_FIELD_OBJ_SYS_PTR fos )
{
	FIELD_OBJ_PTR fldobj = Player_FieldOBJSearch( fos );
	GF_ASSERT( fldobj != NULL && "Jiki_FieldOBJSearch()@tB[hOBJ" );
	return( fldobj );
}

//==============================================================================
//	PLAYER_STATE@Q
//==============================================================================
//--------------------------------------------------------------
/**
 * @̌擾
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		DIR_UP
 */
//--------------------------------------------------------------
int Player_DirGet( const PLAYER_STATE_PTR jiki )
{
	return( FieldOBJ_DirDispGet(Player_FieldOBJGet(jiki)) );
}

//--------------------------------------------------------------
/**
 * @̌Zbg
 * @param	jiki	PLAYER_STATE_PTR
 * @param	dir		DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_DirSet( PLAYER_STATE_PTR jiki, int dir )
{
	FieldOBJ_DirDispCheckSet( Player_FieldOBJGet(jiki), dir );
}

//--------------------------------------------------------------
/**
 * @̈ړ擾
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		DIR_UP
 */
//--------------------------------------------------------------
int Player_DirMoveGet( const PLAYER_STATE_PTR jiki )
{
	return( FieldOBJ_DirMoveGet(Player_FieldOBJGet(jiki)) );
}

//--------------------------------------------------------------
/**
 * @݃ObhXW擾
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		ObhXW
 */
//--------------------------------------------------------------
int Player_NowGPosXGet( const PLAYER_STATE_PTR jiki )
{
	return( FieldOBJ_NowPosGX_Get(Player_FieldOBJGet(jiki)) );
}

//--------------------------------------------------------------
/**
 * @݃ObhZW擾
 * @param	jiki		PLAYER_STATE_PTR
 * @retval	int		ObhZW
 */
//--------------------------------------------------------------
int Player_NowGPosZGet( const PLAYER_STATE_PTR jiki )
{
	return( FieldOBJ_NowPosGZ_Get(Player_FieldOBJGet(jiki)) );
}

//--------------------------------------------------------------
/**
 * @ߋObhXW擾
 * @param	jiki		PLAYER_STATE_PTR
 * @retval	int		ObhXW
 */
//--------------------------------------------------------------
int Player_OldGPosXGet( const PLAYER_STATE_PTR jiki )
{
	return( FieldOBJ_OldPosGX_Get(Player_FieldOBJGet(jiki)) );
}

//--------------------------------------------------------------
/**
 * @ߋObhZW擾
 * @param	jiki		PLAYER_STATE_PTR
 * @retval	int		ObhZW
 */
//--------------------------------------------------------------
int Player_OldGPosZGet( const PLAYER_STATE_PTR jiki )
{
	return( FieldOBJ_OldPosGZ_Get(Player_FieldOBJGet(jiki)) );
}

//--------------------------------------------------------------
/**
 * @3DW擾
 * @param	jiki	PLAYER_STATE_PTR
 * @param	vec		Wi[
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_VecPosGet( const PLAYER_STATE_PTR jiki, VecFx32 *vec )
{
	FieldOBJ_VecPosGet( Player_FieldOBJGet(jiki), vec );
}

//--------------------------------------------------------------
/**
 * @3DW|C^擾
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	VecFx32	@W*
 */
//--------------------------------------------------------------
const VecFx32 * Player_VecPosPtrGet( const PLAYER_STATE_PTR jiki )
{
	return( FieldOBJ_VecPosPtrGet(Player_ConstFieldOBJGet(jiki)) );
}

//--------------------------------------------------------------
/**
 * @3DItZbgW|C^擾
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	VecFx32	@W*
 */
//--------------------------------------------------------------
VecFx32 * Player_VecDrawOffsPtrGet( PLAYER_STATE_PTR jiki )
{
	return( FieldOBJ_VecDrawOffsPtrGet(Player_FieldOBJGet(jiki)) );
}

//--------------------------------------------------------------
/**
 * @ԂZbg
 * @param	jiki		PLAYER_STATE_PTR
 * @param	val		OBJ_MOVE_VALUE_STOP
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_MoveValueSet( PLAYER_STATE_PTR jiki, int val )
{
	jiki->move_value = val;
}

//--------------------------------------------------------------
/**
 * @Ԃ擾
 * @param	jiki		PLAYER_STATE_PTR
 * @retval	int		OBJ_MOVE_VALUE_STOP
 */
//--------------------------------------------------------------
int Player_MoveValueGet( const PLAYER_STATE_PTR jiki )
{
	return( jiki->move_value );
}

//--------------------------------------------------------------
/**
 * @󋵂Zbg
 * @param	jiki		PLAYER_STATE_PTR
 * @param	state OBJ_MOVE_STATE_OFF
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_MoveStateSet( PLAYER_STATE_PTR jiki, int state )
{
	jiki->move_state = state;
}

//--------------------------------------------------------------
/**
 * @󋵂擾
 * @param	jiki		PLAYER_STATE_PTR
 * @retval	int		OBJ_MOVE_STATE_OFF
 */
//--------------------------------------------------------------
int Player_MoveStateGet( const PLAYER_STATE_PTR jiki )
{
	return( jiki->move_state );
}

//--------------------------------------------------------------
/**
 * @̕\ON,OFFw
 * @param	jiki		PLAYER_STATE_PTR
 * @param	flag		TRUE=\AFALSE=\
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_DispON_OFF_Set( PLAYER_STATE_PTR jiki, int flag )
{
	FIELD_OBJ_PTR fldobj;
	
	fldobj = Player_FieldOBJGet( jiki );
	
	if( flag == TRUE ){
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_VANISH );
	}else{
		FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_VANISH );
	}
}

//--------------------------------------------------------------
/**
 * @̕\ON,OFFtO擾
 * @param	jiki		PLAYER_STATE_PTR
 * @retval	int			TRUE=\AFALSE=\
 */
//--------------------------------------------------------------
int Player_DispON_OFF_Get( const PLAYER_STATE_PTR jiki )
{
	int ret;
	
	ret = FieldOBJ_StatusBit_CheckEasy( Player_FieldOBJGet(jiki), FLDOBJ_STA_BIT_VANISH );
	
	if( ret == TRUE ){
		return( FALSE );
	}
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * @̃tB[hOBJ *Zbg
 * @param	jiki			PLAYER_STATE_PTR
 * @param	fldobj			FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_FieldOBJSet( PLAYER_STATE_PTR jiki, FIELD_OBJ_PTR fldobj )
{
	jiki->fldobj = fldobj;
}

//--------------------------------------------------------------
/**
 * @̃tB[hOBJ *擾
 * @param	jiki			PLAYER_STATE_PTR
 * @retval	FIELD_OBJ_PTR 	FIELD_OBJ_PTR
 */
//--------------------------------------------------------------
FIELD_OBJ_PTR Player_FieldOBJGet( PLAYER_STATE_PTR jiki )
{
	return( jiki->fldobj );
}

//--------------------------------------------------------------
/**
 * @̃tB[hOBJ *擾 const
 * @param	jiki			PLAYER_STATE_PTR
 * @retval	FIELD_OBJ_PTR 	FIELD_OBJ_PTR
 */
//--------------------------------------------------------------
CONST_FIELD_OBJ_PTR Player_ConstFieldOBJGet( const PLAYER_STATE_PTR jiki )
{
	return( jiki->fldobj );
}

//--------------------------------------------------------------
/**
 * @̌`ԃZbg
 * @param	jiki	PLAYER_STATE_PTR
 * @param	form	HERO_FORM_NORMAL
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_FormSet( PLAYER_STATE_PTR jiki, int form )
{
	jiki->form = form;
}

//--------------------------------------------------------------
/**
 * @̌`Ԃ擾
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		HERO_FORM_NORMAL
 */
//--------------------------------------------------------------
int Player_FormGet( PLAYER_STATE_PTR jiki )
{
	GF_ASSERT( jiki != NULL && "Player_FormGet()@sĂȂ" );
	return( jiki->form );
}

//--------------------------------------------------------------
/**
 * @NGXgrbgON
 * @param	jiki	PLAYER_STATE_PTR
 * @param	bit		HERO_REQBIT_NORMAL
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_RequestBit_ON( PLAYER_STATE_PTR jiki, u32 bit )
{
	jiki->request_bit |= bit;
}

//--------------------------------------------------------------
/**
 * @NGXgrbgZbg
 * @param	jiki	PLAYER_STATE_PTR
 * @param	bit		HERO_REQBIT_NORMAL
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_RequestBit_Set( PLAYER_STATE_PTR jiki, u32 bit )
{
	jiki->request_bit = bit;
}

//--------------------------------------------------------------
/**
 * @NGXgrbg擾
 * @param	jiki	PLAYER_STATE_PTR
 * @param	bit		HERO_REQBIT_NORMAL
 * @retval	nothing
 */
//--------------------------------------------------------------
u32 Player_RequestBit_Get( PLAYER_STATE_PTR jiki )
{
	return( jiki->request_bit );
}

//--------------------------------------------------------------
/**
 * ʃZbg
 * @param	jiki	PLAYER_STATE_PTR
 * @param	sex		PM_MALE
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_SexSet( PLAYER_STATE_PTR jiki, int sex )
{
	jiki->sex = sex;
}

//--------------------------------------------------------------
/**
 * ʎ擾
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		PM_MALE
 */
//--------------------------------------------------------------
int Player_SexGet( PLAYER_STATE_PTR jiki )
{
	return( jiki->sex );
}

//--------------------------------------------------------------
/**
 * @rbg@Zbg
 * @param	jiki	PLYAER_STATE_PTR
 * @param	bit		Zbgl JIKI_MOVE_BIT_NON
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Jiki_MoveBitSet( PLAYER_STATE_PTR jiki, u32 bit )
{
	jiki->move_bit = bit;
}

//--------------------------------------------------------------
/**
 * @rbgON
 * @param	jiki	PLAYER_STATE_PTR
 * @param	bit		JIKI_MOVE_BIT_FORCE
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Jiki_MoveBitON( PLAYER_STATE_PTR jiki, u32 bit )
{
	jiki->move_bit |= bit;
}

//--------------------------------------------------------------
/**
 * @rbgOFF
 * @param	jiki	PLAYER_STATE_PTR
 * @param	bit		JIKI_MOVE_BIT_FORCE
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Jiki_MoveBitOFF( PLAYER_STATE_PTR jiki, u32 bit )
{
	jiki->move_bit &= ~bit;
}

//--------------------------------------------------------------
/**
 * @rbg̃`FbN
 * @param	jiki	PLAYER_STATE_PTR
 * @param	bit		JIKI_MOVE_BIT_FORCE
 * @retval	u32		rbg&bit
 */
//--------------------------------------------------------------
static u32 Jiki_MoveBitCheck( PLAYER_STATE_PTR jiki, u32 bit )
{
	return( (jiki->move_bit&bit) );
}

//--------------------------------------------------------------
/**
 * @x擾
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		JIKI_SPEED_0
 */
//--------------------------------------------------------------
int Player_MoveSpeedGet( PLAYER_STATE_PTR jiki )
{
	return( jiki->speed );
}

//--------------------------------------------------------------
/**
 * @xZbg
 * @param	jiki	PLAYER_STATE_PTR
 * @param	speed	JIKI_SPEED_0
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_MoveSpeedSet( PLAYER_STATE_PTR jiki, int speed )
{
	jiki->speed = speed;
}

//--------------------------------------------------------------
/**
 * @x̑@őlw
 * @param	jiki	PLAYER_STATE_PTR
 * @param	add		l
 * @param	max		xő
 * @retval	int		̑x
 */
//--------------------------------------------------------------
int Player_MoveSpeedAdd( PLAYER_STATE_PTR jiki, int add, int max )
{
	jiki->speed += add;
	if( jiki->speed > max ){ jiki->speed = max; }
	return( jiki->speed );
}

//--------------------------------------------------------------
/**
 * @L[XZbg
 * @param	jiki	PLAYER_STATE_PTR
 * @param	dir		DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_InputKeyDirXSet( PLAYER_STATE_PTR jiki, int dir )
{
	jiki->input_key_dir_x = dir;
}

//--------------------------------------------------------------
/**
 * @L[X擾
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		DIR_UP
 */
//--------------------------------------------------------------
int Player_InputKeyDirXGet( PLAYER_STATE_PTR jiki )
{
	return( jiki->input_key_dir_x );
}

//--------------------------------------------------------------
/**
 * @L[ZZbg
 * @param	jiki	PLAYER_STATE_PTR
 * @param	dir		DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_InputKeyDirZSet( PLAYER_STATE_PTR jiki, int dir )
{
	jiki->input_key_dir_z = dir;
}

//--------------------------------------------------------------
/**
 * @L[Z擾
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		DIR_UP
 */
//--------------------------------------------------------------
int Player_InputKeyDirZGet( PLAYER_STATE_PTR jiki )
{
	return( jiki->input_key_dir_z );
}

//--------------------------------------------------------------
/**
 * @L[X,ZZbg
 * @param	jiki	PLAYER_STATE_PTR
 * @param	dir_x	DIR_UP
 * @param	dir_z	DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_InputKeyDirSet( PLAYER_STATE_PTR jiki, int dir_x, int dir_z )
{
	Player_InputKeyDirXSet( jiki, dir_x );
	Player_InputKeyDirZSet( jiki, dir_z );
}

//--------------------------------------------------------------
/**
 * @ڑEOAZbg
 * @param	jiki	PLAYER_STATE_PTR
 * @param	eoa		ڑEOA_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_JointEoaSet( PLAYER_STATE_PTR jiki, EOA_PTR eoa )
{
	jiki->joint_eoa = eoa;
}

//--------------------------------------------------------------
/**
 * @ڑEOA擾
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	EOA_PTR	ڑEOA_PTR
 */
//--------------------------------------------------------------
EOA_PTR Player_JointEoaGet( PLAYER_STATE_PTR jiki )
{
	return( jiki->joint_eoa );
}

//--------------------------------------------------------------
/**
 * PLAYER_SAVE_DATAZbg
 * @param	jiki	PLAYER_STATE_PTR
 * @param	save	PLAYER_SAVE_DATA *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Jiki_SaveDataPtrSet( PLAYER_STATE_PTR jiki, PLAYER_SAVE_DATA *save )
{
	jiki->savedata = save;
}

//--------------------------------------------------------------
/**
 * PLAYER_SAVE_DATA擾
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	PLAYER_SAVE_DATA PLAYER_SAVE_DATA*
 */
//--------------------------------------------------------------
PLAYER_SAVE_DATA * Player_SaveDataPtrGet( PLAYER_STATE_PTR jiki )
{
	return( jiki->savedata );
}

//--------------------------------------------------------------
/**
 * @Aj[VR}hR[hZbg
 * @param	jiki	PLAYER_STATE_PTR
 * @param	ac		AjR[hAC_DIR_U
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_AcmdCodeSet( PLAYER_STATE_PTR jiki, u32 ac )
{
	jiki->set_ac = ac;
}

//--------------------------------------------------------------
/**
 * @Aj[VR}hR[h擾
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	u32		AjR[h AC_DIR_U
 */
//--------------------------------------------------------------
u32 Player_AcmdCodeGet( PLAYER_STATE_PTR jiki )
{
	return( jiki->set_ac );
}

//==============================================================================
//	vC[Z[uf[^
//==============================================================================
//--------------------------------------------------------------
/**
 * PLAYER_SAVE_DATA
 * @param	jikisave	PLAYER_SAVE_DATA *
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_SaveDataInit( PLAYER_SAVE_DATA *save )
{
	save->gear_type = GEAR_3;
	save->shoes_flag = FALSE;
}

//--------------------------------------------------------------
/**
 * PLAYER_SAVE_DATA_bV`FbN
 * @param	jikisave	PLAYER_SAVE_DATA *
 * @retval	int			TRUE=_bVł@FALSE=oȂ
 */
//--------------------------------------------------------------
int Player_SaveDataDashCheck( PLAYER_SAVE_DATA *save )
{
	if( save != NULL ){
		if( save->shoes_flag == TRUE ){
			return( TRUE );
		}
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * PLAYER_SAVE_DATA_bVtOZbg
 * @param	jikisave	PLAYER_SAVE_DATA *
 * @param	flag		TRUE=_bVł FALSE=oȂ
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_SaveDataDashSet( PLAYER_SAVE_DATA *save, int flag )
{
	if( flag == TRUE ){
		save->shoes_flag = TRUE;
	}else{
		save->shoes_flag = FALSE;
	}
}

//--------------------------------------------------------------
/**
 * PLAYER_SAVE_DATAMA^Cv擾
 * @param	jikisave	PLAYER_SAVE_DATA *
 * @retval	int			GEAR_3,GEAR4
 */
//--------------------------------------------------------------
int Player_SaveDataGearCheck( PLAYER_SAVE_DATA *save )
{
	if( save == NULL ){
		return( GEAR_3 );
	}
	
	return( save->gear_type );
}

//--------------------------------------------------------------
/**
 * PLAYER_SAVE_DATAMA^CvZbg
 * @param	jikisave	PLAYER_SAVE_DATA *
 * @param	gear		GEAR_3,GEAR4
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_SaveDataGearSet( PLAYER_SAVE_DATA *save, int gear )
{
	if( save != NULL ){
		save->gear_type = gear;
	}
}

//--------------------------------------------------------------
/**
 * @Z[uf[^MAZbg
 * @param	jiki	PLAYER_STATE_PTR
 * @param	gear	GEAR_3
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_SaveDataGetGearSet( PLAYER_STATE_PTR jiki, int gear )
{
	PLAYER_SAVE_DATA *save = Player_SaveDataPtrGet( jiki );
	Player_SaveDataGearSet( save, gear );
}

//--------------------------------------------------------------
/**
 * @Z[uf[^MA擾
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		GEAR_3
 */
//--------------------------------------------------------------
int Player_SaveDataGetGearGet( PLAYER_STATE_PTR jiki )
{
	PLAYER_SAVE_DATA *save = Player_SaveDataPtrGet( jiki );
	return( Player_SaveDataGearCheck(save) );
}

//==============================================================================
//	p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * @WXV	݈ʒuōXV
 * @param	jiki			PLAYER_STATE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_GPosNowUpdate( const PLAYER_STATE_PTR jiki )
{
	FieldOBJ_GPosUpdate( Player_FieldOBJGet(jiki) );
}

//--------------------------------------------------------------
/**
 * @WXV	
 * @param	jiki			PLAYER_STATE_PTR
 * @param	dir			ړ
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_GPosAddDir( PLAYER_STATE_PTR jiki, int dir )
{
	FieldOBJ_NowGPosDirAdd( Player_FieldOBJGet(jiki), dir );
}

//--------------------------------------------------------------
/**
 * @WA
 * @param	jiki	PLAYER_STATE_PTR
 * @param	x		ObhXW
 * @param	z		ObhZW
 * @param	dir		 DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_GPosInit( PLAYER_STATE_PTR jiki, int x, int z, int dir )
{
	FIELD_OBJ_PTR fldobj;
	
	fldobj = Player_FieldOBJGet( jiki );
	FieldOBJ_GPosDirInit( fldobj, x, 0, z, dir );
	
	Player_MoveValueSet( jiki, OBJ_MOVE_VALUE_STOP );
	Player_MoveStateSet( jiki, OBJ_MOVE_STATE_OFF );
}

//--------------------------------------------------------------
/**
 * @YWZbgBW
 * @param	jiki	PLAYER_STATE_PTR
 * @param	y		
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_VecPosYSet( PLAYER_STATE_PTR jiki, fx32 y )
{
	VecFx32 vec;
	FIELD_OBJ_PTR fldobj = Player_FieldOBJGet( jiki );
	
	FieldOBJ_VecPosGet( fldobj, &vec );
	
	vec.y = y;
	FieldOBJ_VecPosSet( fldobj, &vec );
}

//--------------------------------------------------------------
/**
 * @̍擾ON OFFs
 * @param	jiki	PLAYER_STATE_PTR
 * @param	flag	TRUE=擾@FALSE=擾Ȃ
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_HeightGet_ON_OFF( PLAYER_STATE_PTR jiki, int flag )
{
	FIELD_OBJ_PTR fldobj = Player_FieldOBJGet( jiki );
	
	if( flag == TRUE ){
		FieldOBJ_StatusBitSet_HeightGetOFF( fldobj, FALSE );
	}else{
		FieldOBJ_StatusBitSet_HeightGetOFF( fldobj, TRUE );
	}
}

//--------------------------------------------------------------
/**
 * OBJR[h琫ʎ擾
 * @param	code	HERO
 * @retval	int		PM_MALE
 */
//--------------------------------------------------------------
int Player_OBJCodeSexGet( int code )
{
	switch( code ){
	case HERO:
	case CYCLEHERO:
		return( PM_MALE );
	}
	
	return( PM_FEMALE );
}

//--------------------------------------------------------------
/**
 * `ԂƐʂ玩@OBJR[h擾
 * @param	form	HERO_FORM_NORMAL
 * @param	sex		PM_MALE
 * @retval	int		HERO
 */
//--------------------------------------------------------------
int Player_FormSexOBJCodeGet( int form, int sex )
{
	if( sex == PM_MALE ){
		switch( form ){
		case HERO_FORM_NORMAL:	return( HERO );
		case HERO_FORM_CYCLE:	return( CYCLEHERO );
		case HERO_FORM_SWIM:	return( SWIMHERO );
		case HERO_FORM_DIVING:	return( SWIMHERO );
		case HERO_DRAWFORM_SP:		return( SPHERO );
		case HERO_DRAWFORM_WATER:	return( WATERHERO );
		}
	}else{
		switch( form ){
		case HERO_FORM_NORMAL:	return( HEROINE );
		case HERO_FORM_CYCLE:	return( CYCLEHEROINE );
		case HERO_FORM_SWIM:	return( SWIMHEROINE );
		case HERO_FORM_DIVING:	return( SWIMHEROINE );
		case HERO_DRAWFORM_SP:		return( SPHEROINE );
		case HERO_DRAWFORM_WATER:	return( WATERHEROINE );
		}
	}
		
	GF_ASSERT( 0 && "Player_FormSexOBJCodeGet() forms" );
	return( HERO );
}

//--------------------------------------------------------------
/**
 * OBJR[h玩@`Ԃ擾
 * @param	code	HERO
 * @retval	int		HERO_FORM_NORMAL
 */
//--------------------------------------------------------------
int Player_OBJCodeFormGet( int code )
{
	switch( code ){
	case HERO:
	case HEROINE:				return( HERO_FORM_NORMAL );
	case CYCLEHERO:
	case CYCLEHEROINE:			return( HERO_FORM_CYCLE );
	}
		
	GF_ASSERT( 0 && "Player_OBJCodeFormGet() codes" );
	return( HERO_FORM_NORMAL );
}

//--------------------------------------------------------------
/**
 * FIELDSYS_WORKPLAYER_STATE_PTR擾
 * @param	fsys	FIELDSYS_WORK *
 * @retval	PLAYER_STATE_PTR	PLAYER_STATE_PTR
 */
//--------------------------------------------------------------
PLAYER_STATE_PTR Player_FieldSysWorkPlayerGet( FIELDSYS_WORK *fsys )
{
	return( fsys->player );
}

//==============================================================================
//	@rbg
//==============================================================================
//--------------------------------------------------------------
/**
 * @rbg@ړ𑀍삷
 * @param	jiki	PLAYER_STATE_PTR
 * @param	flag	TRUE=ON,FALSE=OFF
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_MoveBitSet_Force( PLAYER_STATE_PTR jiki, int flag )
{
	if( flag == TRUE ){
		Jiki_MoveBitON( jiki, JIKI_MOVE_BIT_FORCE );
	}else{
		Jiki_MoveBitOFF( jiki, JIKI_MOVE_BIT_FORCE );
	}
}

//--------------------------------------------------------------
/**
 * @rbg@ړ`FbN
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		TRUE=ړ
 */
//--------------------------------------------------------------
int Player_MoveBitCheck_Force( PLAYER_STATE_PTR jiki )
{
	if( Jiki_MoveBitCheck(jiki,JIKI_MOVE_BIT_FORCE) ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * @rbg@𑀍삷
 * @param	jiki	PLAYER_STATE_PTR
 * @param	flag	TRUE=ON,FALSE=OFF
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_MoveBitSet_UnderOFF( PLAYER_STATE_PTR jiki, int flag )
{
	if( flag == TRUE ){
		Jiki_MoveBitON( jiki, JIKI_MOVE_BIT_UNDER_OFF );
	}else{
		Jiki_MoveBitOFF( jiki, JIKI_MOVE_BIT_UNDER_OFF );
	}
}

//--------------------------------------------------------------
/**
 * @rbg@`FbN
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		TRUE=
 */
//--------------------------------------------------------------
int Player_MoveBitCheck_UnderOFF( PLAYER_STATE_PTR jiki )
{
	if( Jiki_MoveBitCheck(jiki,JIKI_MOVE_BIT_UNDER_OFF) ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * @rbg@]ԃu[LZbg
 * @param	jiki	PLAYER_STATE_PTR
 * @param	flag	TRUE=u[L@FALSE=
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_MoveBitSet_CycleBrake( PLAYER_STATE_PTR jiki, int flag )
{
	if( flag == TRUE ){
		Jiki_MoveBitON( jiki, JIKI_MOVE_BIT_CYCLE_BRAKE );
	}else{
		Jiki_MoveBitOFF( jiki, JIKI_MOVE_BIT_CYCLE_BRAKE );
	}
}

//--------------------------------------------------------------
/**
 * @rbg@]ԃu[L`FbN
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		TRUE=u[LA@FALSE=u[L
 */
//--------------------------------------------------------------
int Player_MoveBitCheck_CycleBrake( PLAYER_STATE_PTR jiki )
{
	if( Jiki_MoveBitCheck(jiki,JIKI_MOVE_BIT_CYCLE_BRAKE) ){
		return( TRUE );
	}
	
	return( FALSE );
}
