//******************************************************************************
/**
 *
 * @file	player_event.c
 * @brief	@Cxg
 * @author	kagaya
 * @data	05.08.03
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "fieldobj.h"
#include "player.h"
#include "field_event.h"

//==============================================================================
//	define
//==============================================================================
//#define DEBUG_KABE_COUNT

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	KAIRIKI_WORK\́@̓Cxg
//--------------------------------------------------------------
typedef struct
{
	int seq_no;
	int dir;
	FIELDSYS_WORK *fsys;
	PLAYER_STATE_PTR jiki;
	FIELD_OBJ_PTR fldobj;
}KAIRIKI_WORK;

#define KAIRIKI_WORK_SIZE (sizeof(KAIRIKI_WORK))

//--------------------------------------------------------------
///	SNOWBALL_WORK\́@ʃCxg
//--------------------------------------------------------------
typedef struct
{
	int seq_no;
	FIELDSYS_WORK *fsys;
	PLAYER_STATE_PTR jiki;
	FIELD_OBJ_PTR fldobj;
}SNOWBALL_WORK;

#define SNOWBALL_WORK_SIZE (sizeof(SNOWBALL_WORK))

//--------------------------------------------------------------
///	NAMINORI_WORK\
//--------------------------------------------------------------
typedef struct
{
	int seq_no;
	int dir;
	int frame;
	FIELDSYS_WORK *fsys;
	PLAYER_STATE_PTR jiki;
	FIELD_OBJ_PTR fldobj;
	EOA_PTR eoa_poke;
}NAMINORI_WORK;

#define NAMINORI_WORK_SIZE (sizeof(NAMINORI_WORK))

//--------------------------------------------------------------
///	NAMINORI_END_WORK\
//--------------------------------------------------------------
typedef struct
{
	int seq_no;
	int dir;
	FIELDSYS_WORK *fsys;
	PLAYER_STATE_PTR jiki;
	FIELD_OBJ_PTR fldobj;
	EOA_PTR eoa_poke;
}NAMINORI_END_WORK;

#define NAMINORI_END_WORK_SIZE (sizeof(NAMINORI_END_WORK))

//--------------------------------------------------------------
///	ROCKRIDE_WORK\
//--------------------------------------------------------------
typedef struct
{
	int seq_no;
	int dir;
	int count;
	FIELDSYS_WORK *fsys;
	PLAYER_STATE_PTR jiki;
	FIELD_OBJ_PTR fldobj;
	EOA_PTR eoa_poke;
}ROCKRIDE_WORK;

#define ROCKRIDE_WORK_SIZE (sizeof(ROCKRIDE_WORK))

//==============================================================================
//	static
//==============================================================================
static void (* const DATA_RequestTbl[HERO_REQBIT_MAX])( PLAYER_STATE_PTR jiki );

static int JikiEventCheck_MoveHitEvent( FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki, int dir );

static int JikiEventCheck_Kairiki(
		FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki, int dir, int val );
static void JikiEvent_KairikiSet(
		int dir, FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki, FIELD_OBJ_PTR fldobj );
static BOOL JikiEvent_Kairiki( GMEVENT_CONTROL *ev );

static void JikiEvent_NaminoriSet( FIELDSYS_WORK *fsys, int dir );
static void JikiEvent_NaminoriCall( FIELDSYS_WORK *fsys, int dir );
static BOOL JikiEvent_Naminori( GMEVENT_CONTROL *ev );

static int JikiEventCheck_NaminoriEnd(
		FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki, int dir, int val );
static void JikiEvent_NaminoriEndSet( int dir, FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki );
static BOOL JikiEvent_NaminoriEnd( GMEVENT_CONTROL *ev );

static int JikiEventCheck_ForceMoveHitEvent( FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki );

static int JikiEventCheck_SnowBall( FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki );
static void JikiEvent_SnowBallSet(
		FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki, FIELD_OBJ_PTR fldobj );
static BOOL JikiEvent_SnowBall( GMEVENT_CONTROL *ev );

static void JikiEvent_KabeNoboriSet( int dir, FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki );
static void JikiEvent_KabeNoboriCall( FIELDSYS_WORK *fsys, int dir );
static BOOL JikiEvent_KabeNobori( GMEVENT_CONTROL *ev );

static void Jiki_DrawReset( PLAYER_STATE_PTR jiki, int code );
static FIELD_OBJ_PTR Jiki_DirOBJSearch( PLAYER_STATE_PTR jiki, int dir );
static void * Jiki_EventWorkAlloc( int size );
static void Jiki_EventWorkFree( void *work );

//==============================================================================
//	@@NGXg
//==============================================================================
//--------------------------------------------------------------
/**
 * @NGXgZbg
 * @param	jiki	PLAYER_STATE_PTR
 * @param	req		NGXg HERO_REQBIT_NORMAL
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_RequestSet( PLAYER_STATE_PTR jiki, u32 req )
{
	Player_RequestBit_ON( jiki, req );
}

//--------------------------------------------------------------
/**
 * @NGXgt
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_Request( PLAYER_STATE_PTR jiki )
{
	u32 i = 0;
	u32 req = Player_RequestBit_Get( jiki );
	do{ if((req&0x01)){DATA_RequestTbl[i](jiki);} req >>= 1; }while( ++i < HERO_REQBIT_MAX );
	Player_RequestBit_Set( jiki, HERO_REQBIT_NON );
}

//--------------------------------------------------------------
/**
 * @NGXg@Qs
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void JikiReq_Normal( PLAYER_STATE_PTR jiki )
{
	int code;
	
	code = Player_FormSexOBJCodeGet( HERO_FORM_NORMAL, Player_SexGet(jiki) );
	Jiki_DrawReset( jiki, code );
	
	Player_FormSet( jiki, HERO_FORM_NORMAL );
	
	Player_MoveBitSet_CycleBrake( jiki, FALSE );
	Player_MoveSpeedSet( jiki, JIKI_SPEED_0 );
	
	{
		EOA_PTR eoa = Player_JointEoaGet( jiki );
		if( eoa != NULL ){ EOA_Delete( eoa ); }
		Player_JointEoaSet( jiki, NULL );
	}
}

//--------------------------------------------------------------
/**
 * @NGXg@]Ԃ
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void JikiReq_Cycle( PLAYER_STATE_PTR jiki )
{
	int code;
	
	code = Player_FormSexOBJCodeGet( HERO_FORM_CYCLE, Player_SexGet(jiki) );
	Jiki_DrawReset( jiki, code );
	Player_FormSet( jiki, HERO_FORM_CYCLE );
	Player_MoveBitSet_CycleBrake( jiki, FALSE );
	Player_MoveSpeedSet( jiki, JIKI_SPEED_0 );
	
	{
		EOA_PTR eoa = Player_JointEoaGet( jiki );
		if( eoa != NULL ){ EOA_Delete( eoa ); }
		Player_JointEoaSet( jiki, NULL );
	}
}

//--------------------------------------------------------------
/**
 * @NGXg@Ȃ݂̂
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void JikiReq_Naminori( PLAYER_STATE_PTR jiki )
{
	int code;
	
	code = Player_FormSexOBJCodeGet( HERO_FORM_SWIM, Player_SexGet(jiki) );
	Jiki_DrawReset( jiki, code );
	Player_FormSet( jiki, HERO_FORM_SWIM );
	
	Player_MoveBitSet_CycleBrake( jiki, FALSE );
	Player_MoveSpeedSet( jiki, JIKI_SPEED_0 );
	
	{
		EOA_PTR eoa = Player_JointEoaGet( jiki );
		if( eoa != NULL ){ EOA_Delete( eoa ); }
		Player_JointEoaSet( jiki, NULL );
	}
	
	{
		int dir = Player_DirGet( jiki );
		FIELD_OBJ_PTR fldobj = Player_FieldOBJGet( jiki );
		FIELDSYS_WORK *fsys = FieldOBJ_FieldSysWorkGet( fldobj );
		EOA_PTR eoa = FE_FldOBJNamiPokeSet( fldobj, 0, 0, dir, TRUE );	//ڑ W0
		Player_JointEoaSet( jiki, eoa );
	}
}

//--------------------------------------------------------------
/**
 * @NGXg@𖳌
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void JikiReq_UnderOFF( PLAYER_STATE_PTR jiki )
{
	Player_MoveBitSet_UnderOFF( jiki, TRUE );
}

//--------------------------------------------------------------
/**
 * @NGXg@
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void JikiReq_Water( PLAYER_STATE_PTR jiki )
{
	int code;
	
	code = Player_FormSexOBJCodeGet( HERO_DRAWFORM_WATER, Player_SexGet(jiki) );
	Jiki_DrawReset( jiki, code );
}

//--------------------------------------------------------------
///	NGXge[u тHERO_REQBIT_NONɈv
//--------------------------------------------------------------
static void (* const DATA_RequestTbl[HERO_REQBIT_MAX])( PLAYER_STATE_PTR jiki ) =
{
	JikiReq_Normal,	//HERO_REQBIT_NORMAL
	JikiReq_Cycle,	//HERO_REQBIT_CYCLE
	JikiReq_Naminori,	//HERO_REQBIT_SWIM
	JikiReq_UnderOFF,	//HERO_REQBIT_UNDER_OFF
	JikiReq_Water,		//HERO_REQBIT_WATER
};

//==============================================================================
//	@`nCxg
//==============================================================================
//--------------------------------------------------------------
/**
 * @`nCxg`FbN
 * @param	fsys	FIELDSYS_WORK
 * @param	jiki	PLAYER_STATE_PTR
 * @param	dir		L[͕ DIR_UP
 * @param	flag	Cxg\tO
 * @retval	int		TRUE=@Cxg
 */
//--------------------------------------------------------------
int Player_EventMoveCheck( FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki, int dir, u32 flag )
{
	if( Player_MoveBitCheck_Force(jiki) == TRUE ){
		if( JikiEventCheck_ForceMoveHitEvent(fsys,jiki) == TRUE ){
			return( TRUE );
		}
		
		return( FALSE );
	}
	
	if( dir == DIR_NOT ){
		return( FALSE );
	}
	
	if( Player_MoveStartCheck(jiki,dir) == FALSE ){
		return( FALSE );
	}
	
	if( JikiEventCheck_MoveHitEvent(fsys,jiki,dir) == TRUE ){
		return( TRUE );
	}
	
	return( FALSE );
}

//==============================================================================
//	ړqbgnCxg
//==============================================================================
//--------------------------------------------------------------
/**
 * ړqbgnCxg`FbN
 * @param	fsys	FIELDSYS_WORK
 * @param	jiki	PLAYER_STATE_PTR
 * @param	dir		L[͕ DIR_UP
 * @retval	int		TRUE=Cxg FALSE=
 */
//--------------------------------------------------------------
static int JikiEventCheck_MoveHitEvent( FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki, int dir )
{
	int val = Player_MoveSelectValueCheck( jiki, dir );
	
	if( JikiEventCheck_Kairiki(fsys,jiki,dir,val) == TRUE ){
		return( TRUE );
	}
	
	if( JikiEventCheck_NaminoriEnd(fsys,jiki,dir,val) == TRUE ){
		return( TRUE );
	}
	
	return( FALSE );
}

//==============================================================================
//	Cxg@肫
//==============================================================================
//--------------------------------------------------------------
/**
 * 肫ړ`FbN
 * @param	fsys	FIELDSYS_WORK *
 * @param	jiki	PLAYER_STATE_PTR
 * @param	dir		is DIR_UP
 * @param	val		dirɂ鎩@ OBJ_MOVE_VALUE_STOP
 * @retval	int		TRUE=肫
 */
//--------------------------------------------------------------
static int JikiEventCheck_Kairiki(
		FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki, int dir, int val )
{
	if( val != OBJ_MOVE_VALUE_WALK ){
		return( FALSE );
	}
	
	{
		FIELD_OBJ_PTR fldobj = Jiki_DirOBJSearch( jiki, dir );
	
		if( fldobj == NULL ){
			return( FALSE );
		}
	
		{
			int code = FieldOBJ_OBJCodeGet( fldobj );
			
			if( code != ROCK ){
				return( FALSE );
			}
		}
	
		OS_Printf( "肫₪݂܂@" );
		
		{
			u32 ret = FieldOBJ_MoveHitCheckDir( fldobj, dir );
			ret &= ~FLDOBJ_MOVE_HIT_BIT_LIM;	//ړ͖
			
			if( ret != FLDOBJ_MOVE_HIT_BIT_NON ){
				OS_Printf( "͏Qɂ艟o܂\n" );
				return( FALSE );
			}
		}
	
		//ɏo`FbNKv
		OS_Printf( "肫JnII\n" );
		JikiEvent_KairikiSet( dir, fsys, jiki, fldobj );
		return( TRUE );
	}
}

//--------------------------------------------------------------
/**
 * 肫Cxg
 * @param	dir		ړ
 * @param	fsys	FIELDSYS_WORK *
 * @param	jiki	PLAYER_STATE_PTR
 * @param	fldobj	ΏۂFIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void JikiEvent_KairikiSet(
		int dir, FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki, FIELD_OBJ_PTR fldobj )
{
	KAIRIKI_WORK *work = Jiki_EventWorkAlloc( KAIRIKI_WORK_SIZE );
	
	work->dir = dir;
	work->fsys = fsys;
	work->fldobj = fldobj;
	work->jiki = jiki;
	FieldEvent_Set( fsys, JikiEvent_Kairiki, work );
}

//--------------------------------------------------------------
/**
 * 肫Cxg 
 * @param ev	GMEVENT_CONTROL *
 * @retval	BOOL	TRUE=CxgI
 */
//--------------------------------------------------------------
static BOOL JikiEvent_Kairiki( GMEVENT_CONTROL *ev )
{
	KAIRIKI_WORK *work = FieldEvent_GetSpecialWork( ev );
	FIELD_OBJ_PTR jikiobj = Player_FieldOBJGet( work->jiki );
	FIELD_OBJ_PTR fldobj = work->fldobj;
	
	switch( work->seq_no ){
	case 0:
		if( FieldOBJ_AcmdSetCheck(fldobj) == FALSE ){
			break;
		}
		
		if( FieldOBJ_AcmdSetCheck(jikiobj) == FALSE ){
			if( Player_MoveCancellCheck(work->jiki) == FALSE ){
				break;
			}
		}
		
		{
			int code = FieldOBJ_AcmdCodeDirChange( work->dir, AC_WALK_U_16F );
			FieldOBJ_AcmdSet( fldobj, code );
			
			code = FieldOBJ_AcmdCodeDirChange( work->dir, AC_STAY_WALK_U_8F );
			FieldOBJ_AcmdSet( jikiobj, code );
		}
		
		work->seq_no++;
		break;
	case 1:
		if( FieldOBJ_AcmdEndCheck(fldobj) == FALSE ){
			break;
		}
		
		if( FieldOBJ_AcmdEndCheck(jikiobj) == FALSE ){
			break;
		}
		
		FieldOBJ_AcmdEnd( fldobj );
		FieldOBJ_AcmdEnd( jikiobj );
		work->seq_no++;
	case 2:
		Jiki_EventWorkFree( work );
		return( TRUE );
	}
	
	return( FALSE );
}

//==============================================================================
//	Ȃ݂̂Jn
//==============================================================================
//--------------------------------------------------------------
/**
 * Ȃ݂̂Cxg
 * @param	dir		zu
 * @param	fsys	FIELDSYS_WORK *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void JikiEvent_NaminoriSet( FIELDSYS_WORK *fsys, int dir )
{
	NAMINORI_WORK *work = Jiki_EventWorkAlloc( NAMINORI_WORK_SIZE );
	
	work->dir = dir;
	work->fsys = fsys;
	work->jiki = fsys->player;
	work->fldobj = Player_FieldOBJGet( work->jiki );
	
	FieldEvent_Set( fsys, JikiEvent_Naminori, work );
}

//--------------------------------------------------------------
/**
 * Ȃ݂̂TuCxg
 * @param	dir		zu
 * @param	fsys	FIELDSYS_WORK *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void JikiEvent_NaminoriCall( FIELDSYS_WORK *fsys, int dir )
{
	NAMINORI_WORK *work = Jiki_EventWorkAlloc( NAMINORI_WORK_SIZE );
	
	work->dir = dir;
	work->fsys = fsys;
	work->jiki = fsys->player;
	work->fldobj = Player_FieldOBJGet( work->jiki );
	
	FieldEvent_Call( fsys->event, JikiEvent_Naminori, work );
}

//--------------------------------------------------------------
/**
 * Ȃ݂̂Cxg@Oďo
 * @param	dir		zu
 * @param	fsys	FIELDSYS_WORK *
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_EventNaminoriStart( int dir, FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki )
{
	JikiEvent_NaminoriSet( fsys, dir );
}

//--------------------------------------------------------------
/**
 * Ȃ݂̂Cxg@TuCxgďo
 * @param	event	GMEVENT_CONTROL
 * @param	dir		gs@DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
void EventCmd_NaminoriCall( GMEVENT_CONTROL *event, int dir )
{
	FIELDSYS_WORK *fsys = FieldEvent_GetFieldSysWork( event );
	JikiEvent_NaminoriCall( fsys, dir );
}

//--------------------------------------------------------------
/**
 * @CxgAgr[g`FbN@Ȃ݂̂
 * @param	attr	Agr[g
 * @retval	int		TRUE=gn`
 */
//--------------------------------------------------------------
int Player_EventAttrCheck_Naminori( u32 attr )
{
	if( MATR_IsWater(attr) == TRUE ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * gCxg 
 * @param	ev	GMEVENT_CONTROL *
 * @retval	BOOL	TRUE=CxgI
 */
//--------------------------------------------------------------
static BOOL JikiEvent_Naminori( GMEVENT_CONTROL *ev )
{
	NAMINORI_WORK *work = FieldEvent_GetSpecialWork( ev );
	
	switch( work->seq_no ){
	case 0:	//`Z
		{
			int code = Player_FormSexOBJCodeGet( HERO_DRAWFORM_SP, Player_SexGet(work->jiki) );
			Jiki_DrawReset( work->jiki, code );
		}
		
		work->seq_no++;
		break;
	case 1:	//`Z҂
		work->frame++;
			
		if( work->frame > 10 ){
			work->frame = 0;
			work->seq_no++;
		}
		break;
	case 2:
		{	//1ObhɃ|Po
			int gx = Player_NowGPosXGet( work->jiki ) +
				FieldOBJ_DirAddValueGX( work->dir );
			int gz = Player_NowGPosZGet( work->jiki ) +
				FieldOBJ_DirAddValueGZ( work->dir );
			work->eoa_poke = FE_FldOBJNamiPokeSet( work->fldobj, gx, gz, work->dir, FALSE );
			
			Player_JointEoaSet( work->jiki, work->eoa_poke );
			Player_FormSet( work->jiki, HERO_FORM_SWIM );
		}
		
		work->seq_no++;
		break;
	case 3:	//ɖ߂
		work->frame++;
			
		if( work->frame > 10 ){
			int code = Player_FormSexOBJCodeGet( HERO_FORM_NORMAL, Player_SexGet(work->jiki) );
			Jiki_DrawReset( work->jiki, code );
			work->frame = 0;
			work->seq_no++;
		}
		
		break;
	case 4:
		if( FieldOBJ_AcmdSetCheck(work->fldobj) == TRUE ){
			int code = FieldOBJ_AcmdCodeDirChange( work->dir, AC_JUMP_U_1G_8F );
			FieldOBJ_AcmdSet( work->fldobj, code );
			work->seq_no++;
		}
		
		break;
	case 5:
		if( FieldOBJ_AcmdEndCheck(work->fldobj) == FALSE ){
			break;
		}
		
		FieldOBJ_AcmdEnd( work->fldobj );
		FE_FldOBJNamiPokeJointFlagSet( work->eoa_poke, TRUE );
		
		{
			int code = Player_FormSexOBJCodeGet( HERO_FORM_SWIM, Player_SexGet(work->jiki) );
			Jiki_DrawReset( work->jiki, code );
		}
		
		Jiki_EventWorkFree( work );
		return( TRUE );
	}
	
	return( FALSE );
}

//==============================================================================
//	gI
//==============================================================================
//--------------------------------------------------------------
/**
 * Ȃ݂̂I`FbN
 * @param	fsys	FIELDSYS_WORK *
 * @param	jiki	PLAYER_STATE_PTR
 * @param	dir		is DIR_UP
 * @param	val		dirɂ鎩@ړ󋵁@OBJ_MOVE_VALUE_STOP
 * @retval	int		TRUE=gIJn
 */
//--------------------------------------------------------------
static int JikiEventCheck_NaminoriEnd(
		FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki, int dir, int val )
{
	if( val != OBJ_MOVE_VALUE_WALK || Player_FormGet(jiki) != HERO_FORM_SWIM ){
		return( FALSE );
	}
	
	{
		FIELD_OBJ_PTR fldobj = Player_FieldOBJGet( jiki );
		u32 ret = Player_MoveHitCheck( jiki, fldobj, dir );
		
		if( ret == JIKI_MOVE_HIT_BIT_WATER ){
			return( FALSE );
		}
		
		ret &= ~JIKI_MOVE_HIT_BIT_WATER;
			
		if( ret != JIKI_MOVE_HIT_BIT_NON ){
			return( FALSE );
		}
	}
	
	OS_Printf( "㗤Jn\n" );
	JikiEvent_NaminoriEndSet( dir, fsys, jiki );
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * Ȃ݂̂ICxg
 * @param	dir		ړ
 * @param	fsys	FIELDSYS_WORK *
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void JikiEvent_NaminoriEndSet( int dir, FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki )
{
	NAMINORI_END_WORK *work = Jiki_EventWorkAlloc( NAMINORI_END_WORK_SIZE );
	
	work->dir = dir;
	work->fsys = fsys;
	work->jiki = jiki;
	work->fldobj = Player_FieldOBJGet( jiki );
	work->eoa_poke = Player_JointEoaGet( jiki );
	GF_ASSERT( work->eoa_poke != NULL && "JikiEvent_NaminoriEndSet()Ȃ݂̂|P" );
	
	FieldEvent_Set( fsys, JikiEvent_NaminoriEnd, work );
}

//--------------------------------------------------------------
/**
 * gICxg 
 * @param	ev	GMEVENT_CONTROL *
 * @retval	BOOL	TRUE=CxgI
 */
//--------------------------------------------------------------
static BOOL JikiEvent_NaminoriEnd( GMEVENT_CONTROL *ev )
{
	NAMINORI_END_WORK *work = FieldEvent_GetSpecialWork( ev );
	
	switch( work->seq_no ){
	case 0:
		if( FieldOBJ_AcmdSetCheck(work->fldobj) == TRUE ){
			int code = Player_FormSexOBJCodeGet( HERO_FORM_NORMAL, Player_SexGet(work->jiki) );
			Jiki_DrawReset( work->jiki, code );
			
			code = FieldOBJ_AcmdCodeDirChange( work->dir, AC_JUMP_U_1G_8F );
			FieldOBJ_AcmdSet( work->fldobj, code );
			FE_FldOBJNamiPokeJointFlagSet( work->eoa_poke, FALSE );
			work->seq_no++;
		}
		
		break;
	case 1:
		if( FieldOBJ_AcmdEndCheck(work->fldobj) == FALSE ){
			break;
		}
		
		FieldOBJ_AcmdEnd( work->fldobj );
		EOA_Delete( work->eoa_poke );
		Player_JointEoaSet( work->jiki, NULL );
		Player_FormSet( work->jiki, HERO_FORM_NORMAL );
		
		Jiki_EventWorkFree( work );
		return( TRUE );
	}
	
	return( FALSE );
}

//==============================================================================
//	ړqbgCxg
//==============================================================================
//--------------------------------------------------------------
/**
 * ړqbgnCxg`FbN
 * @param	fsys	FIELDSYS_WORK
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		TRUE=Cxg FALSE=
 */
//--------------------------------------------------------------
static int JikiEventCheck_ForceMoveHitEvent( FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki )
{
	FIELD_OBJ_PTR fldobj = Player_FieldOBJGet( jiki );
	
	if( FieldOBJ_AcmdSetCheck(fldobj) == FALSE ){			//ړ
		return( FALSE );
	}
	
	if( JikiEventCheck_SnowBall(fsys,jiki) == TRUE ){
		return( TRUE );
	}
	
	return( FALSE );
}

//==============================================================================
//	ړCxg@ʔj
//==============================================================================
//--------------------------------------------------------------
/**
 * ʔj`FbN
 * @param	fsys	FIELDSYS_WORK *
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		TRUE=Cxg
 */
//--------------------------------------------------------------
static int JikiEventCheck_SnowBall( FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki )
{
	if( Player_MoveSpeedGet(jiki) < JIKI_SPEED_SNOWBALL_BREAK ){
		return( FALSE );
	}
	
	{
		int dir = Player_DirMoveGet( jiki );
		FIELD_OBJ_PTR fldobj = Jiki_DirOBJSearch( jiki, dir );
	
		if( fldobj == NULL ){
			return( FALSE );
		}
	
		{
			int code = FieldOBJ_OBJCodeGet( fldobj );
				
			if( code != SNOWBALL ){
				return( FALSE );
			}
		}
		
		OS_Printf( "ʔjCxg\n" );
	
		JikiEvent_SnowBallSet( fsys, jiki, fldobj );
	}
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * ʔjCxg
 * @param	fsys	FIELDSYS_WORK *
 * @param	jiki	PLAYER_STATE_PTR
 * @param	fldobj	ΏۂFIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void JikiEvent_SnowBallSet(
		FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki, FIELD_OBJ_PTR fldobj )
{
	SNOWBALL_WORK *work = Jiki_EventWorkAlloc( SNOWBALL_WORK_SIZE );
	
	work->seq_no = 0;
	work->fsys = fsys;
	work->fldobj = fldobj;
	work->jiki = jiki;
	FieldEvent_Set( fsys, JikiEvent_SnowBall, work );
}

//--------------------------------------------------------------
/**
 * ʃCxg 
 * @param ev	GMEVENT_CONTROL *
 * @retval	BOOL	TRUE=CxgI
 */
//--------------------------------------------------------------
static BOOL JikiEvent_SnowBall( GMEVENT_CONTROL *ev )
{
	SNOWBALL_WORK *work = FieldEvent_GetSpecialWork( ev );
	FIELD_OBJ_PTR jikiobj = Player_FieldOBJGet( work->jiki );
	FIELD_OBJ_PTR fldobj = work->fldobj;
	
	switch( work->seq_no ){
	case 0:
		if( FieldOBJ_AcmdSetCheck(fldobj) == FALSE ){
			break;
		}
		
		if( FieldOBJ_AcmdSetCheck(jikiobj) == FALSE ){
			if( Player_MoveCancellCheck(work->jiki) == FALSE ){
				break;
			}
		}
		
		work->seq_no++;
	case 1:
		FieldOBJ_Delete( fldobj );
		Jiki_EventWorkFree( work );
		return( TRUE );
	}
	
	return( FALSE );
}

//==============================================================================
//	`@ׂ̂ڂ
//==============================================================================
int (* const DATA_KabeNoboriEventTbl[])( ROCKRIDE_WORK *work );

//--------------------------------------------------------------
//	ǏċAv
//--------------------------------------------------------------
#define RET_AGAIN (TRUE+1)

//--------------------------------------------------------------
/**
 * ׂ̂ڂCxg
 * @param	dir		ړ
 * @param	fsys	FIELDSYS_WORK *
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void JikiEvent_KabeNoboriSet( int dir, FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki )
{
	ROCKRIDE_WORK *work = Jiki_EventWorkAlloc( ROCKRIDE_WORK_SIZE );
	
	work->dir = dir;
	work->fsys = fsys;
	work->jiki = jiki;
	work->fldobj = Player_FieldOBJGet( jiki );
	
	FieldEvent_Set( fsys, JikiEvent_KabeNobori, work );
}

//--------------------------------------------------------------
/**
 * ׂ̂ڂTuCxg
 * @param	dir		ړ
 * @param	fsys	FIELDSYS_WORK *
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void JikiEvent_KabeNoboriCall( FIELDSYS_WORK *fsys, int dir )
{
	ROCKRIDE_WORK *work = Jiki_EventWorkAlloc( ROCKRIDE_WORK_SIZE );
	
	work->dir = dir;
	work->fsys = fsys;
	work->jiki = fsys->player;
	work->fldobj = Player_FieldOBJGet( work->jiki );
	
	FieldEvent_Call( fsys->event, JikiEvent_KabeNobori, work );
}

//--------------------------------------------------------------
/**
 * ǂ̂ڂCxgO
 * @param	dir		ړ
 * @param	fsys	FIELDSYS_WORK *
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void Player_EventKabeNoboriStart( int dir, FIELDSYS_WORK *fsys, PLAYER_STATE_PTR jiki )
{
	JikiEvent_KabeNoboriSet( dir, fsys, jiki );
}

//--------------------------------------------------------------
/**
 * ǂ̂ڂTuCxgĂяo
 * @param	event	GMEVENT_CONTROL*
 * @param	dir		ړ
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void EventCmd_KabeNoboriCall( GMEVENT_CONTROL *event, int dir )
{
	FIELDSYS_WORK *fsys = FieldEvent_GetFieldSysWork( event );
	JikiEvent_KabeNoboriCall( fsys, dir );
}

//--------------------------------------------------------------
/**
 * @CxgAgr[g`FbN@Ǐ
 * @param	attr	Agr[g
 * @param	dir		i DIR_UP
 * @retval	int		TRUE=Ǐn`
 */
//--------------------------------------------------------------
int Player_EventAttrCheck_KabeNobori( u32 attr, int dir )
{
	switch( dir ){
	case DIR_UP:
	case DIR_DOWN:
		if( MATR_IsRockClimV(attr) == TRUE ){
			return( TRUE );
		}
		break;
	case DIR_LEFT:
	case DIR_RIGHT:
		if( MATR_IsRockClimH(attr) == TRUE ){
			return( TRUE );
		}
		break;
	}
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * ǏCxg 
 * @param	ev	GMEVENT_CONTROL *
 * @retval	BOOL	TRUE=CxgI
 */
//--------------------------------------------------------------
static BOOL JikiEvent_KabeNobori( GMEVENT_CONTROL *ev )
{
	int ret;
	ROCKRIDE_WORK *work = FieldEvent_GetSpecialWork( ev );
	
	do{
		ret = DATA_KabeNoboriEventTbl[work->seq_no]( work );
	}while( ret == RET_AGAIN );
	
	if( ret == TRUE ){
		Jiki_EventWorkFree( work );
	}
	
	return( (BOOL)ret );
}

//--------------------------------------------------------------
/**
 * ǏCxg 0
 * @param	work	ROCKRIDE_WORK *
 * @retval	int		RET_AGAIN=ċAv
 */
//--------------------------------------------------------------
static int RockRideEvent_0( ROCKRIDE_WORK *work )
{
	int gx = Player_NowGPosXGet( work->jiki ) + FieldOBJ_DirAddValueGX( work->dir );
	int gz = Player_NowGPosZGet( work->jiki ) + FieldOBJ_DirAddValueGZ( work->dir );
	work->eoa_poke = FE_FldOBJRockRidePoke_Add( work->fldobj, gx, gz, work->dir, FALSE );
	
	work->seq_no++;
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * ǏCxg 1
 * @param	work	ROCKRIDE_WORK *
 * @retval	int		RET_AGAIN=ċAv
 */
//--------------------------------------------------------------
static int RockRideEvent_1( ROCKRIDE_WORK *work )
{
	if( FieldOBJ_AcmdSetCheck(work->fldobj) == TRUE ){
		int code = FieldOBJ_AcmdCodeDirChange( work->dir, AC_JUMP_U_1G_8F );
		FieldOBJ_AcmdSet( work->fldobj, code );
		work->seq_no++;
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * ǏCxg 2
 * @param	work	ROCKRIDE_WORK *
 * @retval	int		RET_AGAIN=ċAv
 */
//--------------------------------------------------------------
static int RockRideEvent_2( ROCKRIDE_WORK *work )
{
	if( FieldOBJ_AcmdEndCheck(work->fldobj) == TRUE ){
		work->seq_no++;
		FE_FldOBJRockRidePokeJointFlagSet( work->eoa_poke, TRUE );
	}
		
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * ǏCxg 3
 * @param	work	ROCKRIDE_WORK *
 * @retval	int		RET_AGAIN=ċAv
 */
//--------------------------------------------------------------
static int RockRideEvent_3( ROCKRIDE_WORK *work )
{
	if( FieldOBJ_AcmdSetCheck(work->fldobj) == TRUE ){
		int code = FieldOBJ_AcmdCodeDirChange( work->dir, AC_WALK_U_4F );
		FieldOBJ_AcmdSet( work->fldobj, code );
		work->seq_no++;
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * ǏCxg 4
 * @param	work	ROCKRIDE_WORK *
 * @retval	int		RET_AGAIN=ċAv
 */
//--------------------------------------------------------------
static int RockRideEvent_4( ROCKRIDE_WORK *work )
{
	if( FieldOBJ_AcmdEndCheck(work->fldobj) == FALSE ){
		return( FALSE );
	}
	
	{
		int dir = FieldOBJ_DirMoveGet( work->fldobj );
		int gx = FieldOBJ_NowPosGX_Get( work->fldobj ) + FieldOBJ_DirAddValueGX( dir );
		int gz = FieldOBJ_NowPosGZ_Get( work->fldobj ) + FieldOBJ_DirAddValueGZ( dir );
		MATR attr = GetAttributeLSB( work->fsys, gx, gz );
		
		#if 0
		if( work->count < 2 ){
			work->seq_no = 3;
			return( RET_AGAIN );
		}
		#else
		if( Player_EventAttrCheck_KabeNobori(attr,dir) == TRUE ){
			work->seq_no = 3;
			return( RET_AGAIN );
		}
		#endif
	}
	
	{
		int code = FieldOBJ_AcmdCodeDirChange( work->dir, AC_JUMP_U_1G_8F );
		FieldOBJ_AcmdSet( work->fldobj, code );
		
		work->count = 0;
		work->seq_no++;
		FE_FldOBJRockRidePokeJointFlagSet( work->eoa_poke, FALSE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * ǏCxg 5
 * @param	work	ROCKRIDE_WORK *
 * @retval	int		RET_AGAIN=ċAv
 */
//--------------------------------------------------------------
static int RockRideEvent_5( ROCKRIDE_WORK *work )
{
	if( FieldOBJ_AcmdEndCheck(work->fldobj) == FALSE ){
		return( FALSE );
	}
	
	FieldOBJ_AcmdEnd( work->fldobj );
	EOA_Delete( work->eoa_poke );
	return( TRUE );
}

//--------------------------------------------------------------
///	ǏCxge[u
//--------------------------------------------------------------
static int (* const DATA_KabeNoboriEventTbl[])( ROCKRIDE_WORK *work ) =
{
	RockRideEvent_0,
	RockRideEvent_1,
	RockRideEvent_2,
	RockRideEvent_3,
	RockRideEvent_4,
	RockRideEvent_5,
};

//==============================================================================
//	p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * @\nZbg
 * @param	jiki	PLAYER_STATE_PTR
 * @param	code	\OBJR[h HERO
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Jiki_DrawReset( PLAYER_STATE_PTR jiki, int code )
{
	int ret;
	CONST_FIELD_OBJ_SYS_PTR fos;
	FIELD_OBJ_PTR fldobj;
	
	fldobj = Player_FieldOBJGet( jiki );
	fos = FieldOBJ_FieldOBJSysGet( fldobj );
	
	ret = FieldOBJ_OBJCodeGet( fldobj );
	FieldOBJ_DrawDelete( fldobj );
	FieldOBJ_BlActResmRegularDelete_Tex( fos, ret );
	FieldOBJ_BlActResmRegularAdd_Tex( fos, code );
	FieldOBJ_DrawResetAlone( fldobj, code );
}

//--------------------------------------------------------------
/**
 * @ʒuwɃtB[hOBJ邩
 * @param	jiki			PLAYER_STATE_PTR
 * @param	dir				wBDIR_UP
 * @retval	FIELD_OBJ_PTR	NULL=Ȃ
 */
//--------------------------------------------------------------
static FIELD_OBJ_PTR Jiki_DirOBJSearch( PLAYER_STATE_PTR jiki, int dir )
{
	int x = Player_NowGPosXGet( jiki ) + FieldOBJ_DirAddValueGX( dir );
	int z = Player_NowGPosZGet( jiki ) + FieldOBJ_DirAddValueGZ( dir );
	CONST_FIELD_OBJ_SYS_PTR fos = FieldOBJ_FieldOBJSysGet( Player_FieldOBJGet(jiki) );
	FIELD_OBJ_PTR fldobj = FieldOBJ_SearchGPos( fos, x, z );
	
	return( fldobj );
}

//--------------------------------------------------------------
/**
 * Cxgp[Nm
 * @param	size	[NTCY
 * @retval	void*	mۂ[N
 */
//--------------------------------------------------------------
static void * Jiki_EventWorkAlloc( int size )
{
	void *work = sys_AllocMemoryLo( HEAPID_FIELD, size );
	GF_ASSERT( work != NULL && "Jiki_EventWorkAlloc()[Nmێs" );
	memset( work, 0, size );
	
	return( work );
}

//--------------------------------------------------------------
/**
 * Cxgp[NJ
 * @param	work	J郏[N
 * @retval	nothing
 */
//--------------------------------------------------------------
static void Jiki_EventWorkFree( void *work )
{
	sys_FreeMemory( HEAPID_FIELD, work );
}

