//============================================================================================
/**
 * @file	poketch_a00c.c
 * @bfief	|Pb`iAvNo00 = fW^vj@Rg[
 * @author	taya GAME FREAK inc.
 */
//============================================================================================
#include <nitro/sinit.h>
#include "common.h"
#include "system\lib_pack.h"

#include "poketch_button.h"
#include "poketch_a00.h"
#include "poketch_prv.h"

//==============================================================
// Work
//==============================================================
typedef struct {
	u8        main_seq;
	u8        seq;
	u8        quit_req_flag;

	u8        rtc_callback_end_flag;
	u8        rtc_update_flag;
	u8        rtc_backup_value;

	u8        backlight_update_flag;

	u32       rtc_wait_time;
	u32       rtc_wait_cnt;

	POKETCH_BUTTON_MAN*	button_man;

	VIEWPARAM  vpara;
	VIEWWORK*  vwk;
	CONTACT_WORK*  conwk;

}APPWORK;

//==============================================================
// 萔
//==============================================================
enum {
	RTC_WAIT_MARGIN_TIME = 30,	// ςnỸt[炱̃t[O̎_Ń`FbNn߂
};



//==============================================================
// V[PX
//==============================================================
enum {
	SEQ_INIT,
	SEQ_IDLE,
	SEQ_QUIT,
};

//==============================================================
// Prototype
//==============================================================
static void NitroStaticInit(void);
static BOOL Poketch_A00_Init(void **wk_ptr, CONTACT_WORK* conwk, GF_BGL_INI* bgl, u32 param);
static BOOL SetupWork( APPWORK *wk, CONTACT_WORK* conwk, GF_BGL_INI* bgl, u32 param );
static void CleanupWork( APPWORK *wk );
static void Poketch_A00_Main(TCB_PTR tcb, void *wk_adrs);
static void Poketch_A00_Quit(void *wk_adrs);
static void BmnCallback( u32 btn_idx, u32 event, u32 touch_event, void *wk_adrs );
static void ChangeSeq(APPWORK *wk, u32 seq);
static BOOL SeqInit(APPWORK *wk);
static BOOL SeqIdle(APPWORK *wk);
static BOOL SeqQuit(APPWORK *wk);
static void RtcCallBackSet( APPWORK* wk );
static void RtcCallBack( RTCResult result, void* wk_adrs );
static BOOL RtcEndCheck( APPWORK* wk );
static BOOL RtcUpdateCheck( APPWORK* wk );


//==============================================================
// {^ʒuienum BUTTON_ID ɑΉj
//==============================================================
#define ORGP(c)		((c)*8)
#define ENDP(c)		((c)*8+7)

static const TP_HIT_TBL ButtonRectData[] = {
	{  ORGP(2), ENDP(21),  ORGP(2), ENDP(25),  },
};


//------------------------------------------------------------------
/**
 * Av̐֐AhXCRg[ɓn
 */
//------------------------------------------------------------------
static void NitroStaticInit(void)
{
	PoketchSetAppProc(Poketch_A00_Init, Poketch_A00_Quit);
}

//------------------------------------------------------------------
/**
 * Av֐
 *
 * @param   wk_ptr		[NAhXۑ|C^̃AhX
 * @param   conwk		Av{̂擾ۂɕKvƂȂ郏[NiAvւ͔Jj
 * @param   bgl			BGLW[wb_
 * @param   param		J[EmNȂǓ^CviAvˑj
 */
//------------------------------------------------------------------
static BOOL Poketch_A00_Init(void **wk_ptr, CONTACT_WORK* conwk, GF_BGL_INI* bgl, u32 param)
{
	APPWORK* wk = (APPWORK*)sys_AllocMemory( POKETCH_APP_CTRL_HEAPID, sizeof(APPWORK));

	if(wk != NULL)
	{
		if(SetupWork( wk, conwk, bgl, param ))
		{
			if( TCB_Add(Poketch_A00_Main, wk, POKETCH_APP_TASKPRI) != NULL )
			{
				*wk_ptr = wk;
				return TRUE;
			}
		}
		sys_FreeMemoryEz( wk );
	}

	return FALSE;
}
//------------------------------------------------------------------
/**
 * [ÑZbgAbv
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static BOOL SetupWork( APPWORK *wk, CONTACT_WORK* conwk, GF_BGL_INI* bgl, u32 param )
{
	if( Poketch_A00_SetViewWork( &(wk->vwk), &(wk->vpara), bgl ) )
	{
		wk->main_seq = SEQ_INIT;
		wk->seq = 0;
		wk->quit_req_flag = FALSE;

		wk->rtc_callback_end_flag = TRUE;
		wk->backlight_update_flag = FALSE;

		wk->vpara.backlight = 0;

	// Ԏ擾BwȒlĂ̂߂Ɋۂ߂Ă
		RTC_GetTime( &(wk->vpara.time) );
		if( wk->vpara.time.hour >= 24 ){
			wk->vpara.time.hour %= 24;
		}
		if( wk->vpara.time.minute >= 60 ){
			wk->vpara.time.hour %= 60;
		}

	wk->button_man = PBTN_Create( ButtonRectData, NELEMS(ButtonRectData), BmnCallback, wk, POKETCH_APP_CTRL_HEAPID );
		if(wk->button_man == NULL)
		{
			return FALSE;
		}

		wk->conwk = conwk;
		return TRUE;
	}

	return FALSE;
}
//------------------------------------------------------------------
/**
 * [ÑN[Abv
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void CleanupWork( APPWORK *wk )
{
	Poketch_A00_DeleteViewWork( wk->vwk );
	PBTN_Delete( wk->button_man );
	sys_FreeMemoryEz( wk );
}
//------------------------------------------------------------------
/**
 * AvC֐
 *
 * @param   wk_adrs		[NAhX
 *
 */
//------------------------------------------------------------------
static void Poketch_A00_Main(TCB_PTR tcb, void *wk_adrs)
{
	static BOOL (* const seqtbl[])(APPWORK*) = {
		SeqInit,
		SeqIdle,
		SeqQuit,
	};

	APPWORK *wk = (APPWORK*)wk_adrs;


	if( wk->main_seq < NELEMS(seqtbl) )
	{
		if( PoketchIsSleepMode( wk->conwk ) == FALSE )
		{
			PBTN_Main( wk->button_man );
		}

		if( seqtbl[wk->main_seq](wk) )
		{
			CleanupWork( wk );
			TCB_Delete(tcb);
			PoketchNoticeAppEnd( wk->conwk );
		}
	}
	else
	{
		SDK_ASSERT(0);
	}
}
//------------------------------------------------------------------
/**
 * AvI֐
 *
 * @param   wk_adrs		[NAhX
 *
 */
//------------------------------------------------------------------
static void Poketch_A00_Quit(void *wk_adrs)
{
	((APPWORK*)wk_adrs)->quit_req_flag = TRUE;
}
//------------------------------------------------------------------
/**
 * {^}l[WR[obN֐
 *
 * @param   btn_idx		
 * @param   event		
 * @param   touch_event		
 * @param   wk_adrs		
 *
 */
//------------------------------------------------------------------
static void BmnCallback( u32 btn_idx, u32 event, u32 touch_event, void *wk_adrs )
{
	APPWORK* wk = (APPWORK*)wk_adrs;

	switch( touch_event ){
	case BMN_TOUCH_ON:
		wk->vpara.backlight = 1;
		wk->backlight_update_flag = TRUE;
		break;

	case BMN_TOUCH_OFF:
		wk->vpara.backlight = 0;
		wk->backlight_update_flag = TRUE;
		break;
	}
}

//------------------------------------------------------------------
/**
 * V[PXύX
 *
 * @param   wk		[N|C^
 * @param   seq		ύX̃V[PXio[
 *
 */
//------------------------------------------------------------------
static void ChangeSeq(APPWORK *wk, u32 seq)
{
	if(wk->quit_req_flag == FALSE)
	{
		wk->main_seq = seq;
	}
	else
	{
		wk->main_seq = SEQ_QUIT;
	}
	wk->seq = 0;
}


//------------------------------------------------------------------
/**
 * V[PXFʍ\z
 *
 * @param   wk			[N|C^
 *
 * @retval  BOOL		TRUEŃAvI
 */
//------------------------------------------------------------------
static BOOL SeqInit(APPWORK *wk)
{
	switch(wk->seq){
	case 0:
		Poketch_A00_SetViewCommand( wk->vwk, CMD_INIT );
		wk->seq++;
		break;

	case 1:
		if(Poketch_A00_WaitViewCommand( wk->vwk, CMD_INIT ))
		{
			PoketchNoticeAppStart( wk->conwk );
			ChangeSeq( wk, SEQ_IDLE );
		}
		break;
	}
	return FALSE;
}
//------------------------------------------------------------------
/**
 * V[PXFȂȂ
 *
 * @param   wk		[N|C^
 *
 * @retval  BOOL		TRUEŃAvI
 */
//------------------------------------------------------------------
static BOOL SeqIdle(APPWORK *wk)
{
	if(wk->quit_req_flag)
	{
		if( RtcEndCheck( wk ) )
		{
			ChangeSeq( wk, SEQ_QUIT );
			return FALSE;
		}
	}

	if( wk->backlight_update_flag )
	{
		wk->backlight_update_flag = FALSE;
		Poketch_A00_SetViewCommand( wk->vwk, CMD_BACKLIGHT_UPDATE );
	}

	switch( wk->seq ){
	case 0:
		wk->rtc_wait_cnt = 0;
		wk->rtc_wait_time = ((60 - wk->vpara.time.second) * 30) - RTC_WAIT_MARGIN_TIME;
		wk->seq++;
		/* falltru */
	case 1:
		wk->rtc_wait_cnt++;
		if( wk->rtc_wait_cnt < wk->rtc_wait_time ){
			break;
		}
		wk->rtc_wait_cnt = 0;
		wk->seq++;
		/* fallthru */
	case 2:
		RtcCallBackSet( wk );
		wk->seq++;
		/* fallthru */
	case 3:
		if( RtcEndCheck( wk ) )
		{
			if( RtcUpdateCheck( wk ) )
			{
				Poketch_A00_SetViewCommand( wk->vwk, CMD_TIME_UPDATE );
				wk->seq++;
			}
			else
			{
				RtcCallBackSet( wk );
			}
		}
		break;
	case 4:
		if(Poketch_A00_WaitViewCommand( wk->vwk, CMD_TIME_UPDATE ))
		{
			wk->rtc_wait_time = 60 * 30 - RTC_WAIT_MARGIN_TIME;
			wk->seq = 1;
		}
		break;
	}


	return FALSE;
}

//------------------------------------------------------------------
/**
 * V[PXFI
 *
 * @param   wk		[N|C^
 *
 * @retval  BOOL		TRUEŃAvI
 */
//------------------------------------------------------------------
static BOOL SeqQuit(APPWORK *wk)
{
	switch(wk->seq){
	case 0:
		Poketch_A00_SetViewCommand( wk->vwk, CMD_QUIT );
		wk->seq++;
		break;

	case 1:
		if(Poketch_A00_WaitViewCommandAll( wk->vwk ))
		{
			return TRUE;
		}
		break;
	}

	return FALSE;
}


//------------------------------------------------------------------
/**
 * RTC`FbNJn
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void RtcCallBackSet( APPWORK* wk )
{
	wk->rtc_backup_value = wk->vpara.time.minute;	// Ŕf
	wk->rtc_update_flag = FALSE;
	wk->rtc_callback_end_flag = FALSE;
	RTC_GetTimeAsync( &(wk->vpara.time), RtcCallBack, wk );
}

//------------------------------------------------------------------
/**
 * RTC`FbNʂ̃R[obN֐
 *
 * @param   result		s
 * @param   wk_adrs		[N|C^
 *
 */
//------------------------------------------------------------------
static void RtcCallBack( RTCResult result, void* wk_adrs )
{
	APPWORK* wk = (APPWORK*)wk_adrs;

	if(	(result == RTC_RESULT_SUCCESS)
	&&	(wk->vpara.time.minute != wk->rtc_backup_value )
	){
		wk->rtc_update_flag = TRUE;
	}
	wk->rtc_callback_end_flag = TRUE;
}

//------------------------------------------------------------------
/**
 * RTC`FbNIH
 *
 * @param   wk			[N|C^
 *
 * @retval  BOOL		TRUEŏI
 */
//------------------------------------------------------------------
static BOOL RtcEndCheck( APPWORK* wk )
{
	return wk->rtc_callback_end_flag;
}

//------------------------------------------------------------------
/**
 * RTC`FbŇʁA\XVKvH
 *
 * @param   wk			[N|C^
 *
 * @retval  BOOL		TRUEŕKv
 */
//------------------------------------------------------------------
static BOOL RtcUpdateCheck( APPWORK* wk )
{
	return wk->rtc_update_flag;
}
