//============================================================================================
/**
 * @file	poketch_a21c.c
 * @bfief	|Pb`iAvNoa21FLb`^C}[j@Rg[
 * @author	taya GAME FREAK inc.
 */
//============================================================================================
#include <nitro/sinit.h>
#include "common.h"
#include "gflib\apptimer.h"
#include "system\lib_pack.h"


#include "poketch_sound.h"
#include "poketch_button.h"
#include "poketch_a21.h"
#include "poketch_prv.h"

//==============================================================
// Button
//==============================================================
enum {
	BTN_START,
	BTN_STOP,
	BTN_RESET,
	BTN_MIN10_UP,
	BTN_MIN1_UP,
	BTN_MIN10_DOWN,
	BTN_MIN1_DOWN,
	BTN_SEC10_UP,
	BTN_SEC1_UP,
	BTN_SEC10_DOWN,
	BTN_SEC1_DOWN,
};


//==============================================================
// Work
//==============================================================
typedef struct {
	u8        main_seq;
	u8        seq;

	u8        quit_req_flag;

	VIEWPARAM  vpara;
	VIEWWORK*  vwk;
	CONTACT_WORK*  conwk;

	POKETCH_BUTTON_MAN*  button;
	u32                  button_id;
	u32                  button_event;

	u64         timer_sec;
	u64         passed_sec;
	u64         timer_backup;

	BOOL        button_enable[PUSH_BUTTON_MAX];
	BOOL        button_update_flag;


}APPWORK;

//==============================================================
// V[PX
//==============================================================
enum {
	SEQ_INIT,
	SEQ_INPUT,
	SEQ_COUNTDOWN,
	SEQ_ALARM,
	SEQ_QUIT,
};

//==============================================================
// Prototype
//==============================================================
static void NitroStaticInit(void);
static BOOL Poketch_A21_Init(void **wk_ptr, CONTACT_WORK* conwk, GF_BGL_INI* bgl, u32 param);
static void init_button_state( APPWORK* wk );
static void set_button_enable( APPWORK* wk, u32 button, BOOL flag );
static void set_button_state( APPWORK* wk, u32 button, u32 state );
static BOOL SetupWork( APPWORK *wk, CONTACT_WORK* conwk, GF_BGL_INI* bgl, u32 param );
static void CleanupWork( APPWORK *wk );
static void ButtonCallBack( u32 idx, u32 event, u32 touch_event, void* wk_adrs );
static void Poketch_A21_Main(TCB_PTR tcb, void *wk_adrs);
static void Poketch_A21_Quit(void *wk_adrs);
static void ChangeSeq(APPWORK *wk, u32 seq);
static BOOL SeqInit(APPWORK *wk);
static BOOL SeqInput(APPWORK *wk);
static BOOL SeqCountDown(APPWORK *wk);
static BOOL SeqAlarm(APPWORK *wk);
static BOOL check_update_timer( APPWORK* wk );
static void reset_timer(VIEWPARAM* vpara);
static BOOL SeqQuit(APPWORK *wk);



//------------------------------------------------------------------
/**
 * Av̐֐AhXCRg[ɓn
 */
//------------------------------------------------------------------
static void NitroStaticInit(void)
{
	PoketchSetAppProc(Poketch_A21_Init, Poketch_A21_Quit);
}

//------------------------------------------------------------------
/**
 * Av֐
 *
 * @param   wk_ptr		[NAhXۑ|C^̃AhX
 * @param   conwk		Av{̂擾ۂɕKvƂȂ郏[NiAvւ͔Jj
 * @param   bgl			BGLW[wb_
 * @param   param		J[EmNȂǓ^CviAvˑj
 */
//------------------------------------------------------------------
static BOOL Poketch_A21_Init(void **wk_ptr, CONTACT_WORK* conwk, GF_BGL_INI* bgl, u32 param)
{
	APPWORK* wk = (APPWORK*)sys_AllocMemory( POKETCH_APP_CTRL_HEAPID, sizeof(APPWORK));

	if(wk != NULL)
	{
		if(SetupWork( wk, conwk, bgl, param ))
		{
			if( TCB_Add(Poketch_A21_Main, wk, POKETCH_APP_TASKPRI) != NULL )
			{
				*wk_ptr = wk;
				return TRUE;
			}
		}
		sys_FreeMemoryEz( wk );
	}

	return FALSE;
}



static void init_button_state( APPWORK* wk )
{
	int i;

	for(i=0; i<PUSH_BUTTON_MAX; i++)
	{
		wk->button_enable[i] = TRUE;
		wk->vpara.button[i] = BUTTON_OFF;
	}

	wk->button_update_flag = TRUE;
}

static void set_button_enable( APPWORK* wk, u32 button, BOOL flag )
{
	wk->button_enable[button] = flag;
	wk->vpara.button[button] =(flag)? BUTTON_OFF : BUTTON_ON;
	wk->button_update_flag = TRUE;
}

static void set_button_state( APPWORK* wk, u32 button, u32 state )
{
	if( wk->button_enable[button] )
	{
		wk->vpara.button[button] = state;
		wk->button_update_flag = TRUE;
	}
}


//------------------------------------------------------------------
/**
 * [ÑZbgAbv
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static BOOL SetupWork( APPWORK *wk, CONTACT_WORK* conwk, GF_BGL_INI* bgl, u32 param )
{
	static const TP_HIT_TBL hit_tbl[] = {
		{ START_TOUCH_TOP, START_TOUCH_BOTTOM, START_TOUCH_LEFT, START_TOUCH_RIGHT },
		{ STOP_TOUCH_TOP, STOP_TOUCH_BOTTOM, STOP_TOUCH_LEFT, STOP_TOUCH_RIGHT },
		{ RESET_TOUCH_TOP, RESET_TOUCH_BOTTOM, RESET_TOUCH_LEFT, RESET_TOUCH_RIGHT },
		{ MIN10_UP_TOP, MIN10_UP_BOTTOM, MIN10_UP_LEFT, MIN10_UP_RIGHT },
		{ MIN1_UP_TOP, MIN1_UP_BOTTOM, MIN1_UP_LEFT, MIN1_UP_RIGHT },
		{ MIN10_DOWN_TOP, MIN10_DOWN_BOTTOM, MIN10_DOWN_LEFT, MIN10_DOWN_RIGHT },
		{ MIN1_DOWN_TOP, MIN1_DOWN_BOTTOM, MIN1_DOWN_LEFT, MIN1_DOWN_RIGHT },
		{ SEC10_UP_TOP, SEC10_UP_BOTTOM, SEC10_UP_LEFT, SEC10_UP_RIGHT },
		{ SEC1_UP_TOP, SEC1_UP_BOTTOM, SEC1_UP_LEFT, SEC1_UP_RIGHT },
		{ SEC10_DOWN_TOP, SEC10_DOWN_BOTTOM, SEC10_DOWN_LEFT, SEC10_DOWN_RIGHT },
		{ SEC1_DOWN_TOP, SEC1_DOWN_BOTTOM, SEC1_DOWN_LEFT, SEC1_DOWN_RIGHT },
	};

	wk->vpara.min10 = 0;
	wk->vpara.min1  = 0;
	wk->vpara.sec10 = 0;
	wk->vpara.sec1  = 0;

	init_button_state( wk );
	set_button_enable( wk, BTN_STOP, FALSE );

	if( Poketch_A21_SetViewWork( &(wk->vwk), &(wk->vpara), bgl ) )
	{
		enum {
			BUTTON_REPEAT_FRAMES = 4,
		};

		wk->main_seq = SEQ_INIT;
		wk->seq = 0;
		wk->quit_req_flag = FALSE;

		wk->button = PBTN_Create(hit_tbl, NELEMS(hit_tbl), ButtonCallBack, wk, POKETCH_APP_CTRL_HEAPID );
		wk->button_event = BMN_EVENT_NULL;
		PBTN_SetRepeatTime(wk->button, BTN_MIN10_UP, BUTTON_REPEAT_FRAMES);
		PBTN_SetRepeatTime(wk->button, BTN_MIN10_DOWN, BUTTON_REPEAT_FRAMES);
		PBTN_SetRepeatTime(wk->button, BTN_MIN1_UP, BUTTON_REPEAT_FRAMES);
		PBTN_SetRepeatTime(wk->button, BTN_MIN1_DOWN, BUTTON_REPEAT_FRAMES);
		PBTN_SetRepeatTime(wk->button, BTN_SEC10_UP, BUTTON_REPEAT_FRAMES);
		PBTN_SetRepeatTime(wk->button, BTN_SEC10_DOWN, BUTTON_REPEAT_FRAMES);
		PBTN_SetRepeatTime(wk->button, BTN_SEC1_UP, BUTTON_REPEAT_FRAMES);
		PBTN_SetRepeatTime(wk->button, BTN_SEC1_DOWN, BUTTON_REPEAT_FRAMES);

		wk->conwk = conwk;
		return TRUE;
	}

	return FALSE;
}
//------------------------------------------------------------------
/**
 * [ÑN[Abv
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void CleanupWork( APPWORK *wk )
{
	PBTN_Delete( wk->button );
	Poketch_A21_DeleteViewWork( wk->vwk );
	sys_FreeMemoryEz( wk );
}


//------------------------------------------------------------------
/**
 * 
 *
 * @param   idx				
 * @param   event			
 * @param   touch_event		
 * @param   wk_adrs			
 *
 */
//------------------------------------------------------------------
static void ButtonCallBack( u32 idx, u32 event, u32 touch_event, void* wk_adrs )
{
	APPWORK* wk = wk_adrs;
	wk->button_id = idx;
	wk->button_event = event;

	if( idx < PUSH_BUTTON_MAX )
	{
		if( event == BMN_EVENT_TOUCH )
		{
			set_button_state( wk, idx, BUTTON_ON );
		}
		else if( event == BMN_EVENT_OUT || event == BMN_EVENT_TAP )
		{
			set_button_state( wk, idx, BUTTON_OFF );
		}
	}
}



//------------------------------------------------------------------
/**
 * AvC֐
 *
 * @param   wk_adrs		[NAhX
 *
 */
//------------------------------------------------------------------
static void Poketch_A21_Main(TCB_PTR tcb, void *wk_adrs)
{
	static BOOL (* const seqtbl[])(APPWORK*) = {
		SeqInit,
		SeqInput,
		SeqCountDown,
		SeqAlarm,
		SeqQuit,
	};

	APPWORK *wk = (APPWORK*)wk_adrs;

	if( wk->main_seq < NELEMS(seqtbl) )
	{
		if( PoketchIsSleepMode(wk->conwk) == FALSE )
		{
			PBTN_Main( wk->button );
			if( wk->button_update_flag )
			{
				Poketch_A21_SetViewCommand(wk->vwk, CMD_UPDATE_BUTTON);
				wk->button_update_flag = FALSE;
			}
		}

		if( seqtbl[wk->main_seq](wk) )
		{
			CleanupWork( wk );
			TCB_Delete(tcb);
			PoketchNoticeAppEnd( wk->conwk );
		}
	}
	else
	{
		SDK_ASSERT(0);
	}
}
//------------------------------------------------------------------
/**
 * AvI֐
 *
 * @param   wk_adrs		[NAhX
 *
 */
//------------------------------------------------------------------
static void Poketch_A21_Quit(void *wk_adrs)
{
	((APPWORK*)wk_adrs)->quit_req_flag = TRUE;
}

//------------------------------------------------------------------
/**
 * V[PXύX
 *
 * @param   wk		[N|C^
 * @param   seq		ύX̃V[PXio[
 *
 */
//------------------------------------------------------------------
static void ChangeSeq(APPWORK *wk, u32 seq)
{
	if(wk->quit_req_flag == FALSE)
	{
		wk->main_seq = seq;
	}
	else
	{
		wk->main_seq = SEQ_QUIT;
	}
	wk->seq = 0;
}


//------------------------------------------------------------------
/**
 * V[PXFʍ\z
 *
 * @param   wk			[N|C^
 *
 * @retval  BOOL		TRUEŃAvI
 */
//------------------------------------------------------------------
static BOOL SeqInit(APPWORK *wk)
{
	switch(wk->seq){
	case 0:
		Poketch_A21_SetViewCommand( wk->vwk, CMD_INIT );
		wk->seq++;
		break;

	case 1:
		if(Poketch_A21_WaitViewCommand( wk->vwk, CMD_INIT ))
		{
			PoketchNoticeAppStart( wk->conwk );
			ChangeSeq( wk, SEQ_INPUT );
		}
		break;
	}
	return FALSE;
}
//------------------------------------------------------------------
/**
 * V[PXFԓ
 *
 * @param   wk		[N|C^
 *
 * @retval  BOOL		TRUEŃAvI
 */
//------------------------------------------------------------------
static BOOL SeqInput(APPWORK *wk)
{
	if(wk->quit_req_flag)
	{
		ChangeSeq( wk, SEQ_QUIT );
		return FALSE;
	}

	switch(wk->seq){
	case 0:
		if( Poketch_A21_WaitViewCommandAll(wk->vwk)==FALSE )
		{
			break;
		}
		if( wk->button_event == BMN_EVENT_TOUCH && wk->button_id <= BTN_RESET)
		{
			wk->button_event = BMN_EVENT_NULL;

			switch( wk->button_id ){
			case BTN_RESET:
				reset_timer(&wk->vpara);
				Poketch_A21_SetViewCommand(wk->vwk, CMD_UPDATE_NUM);
				PoketchSePlay(POKETCH_SE_KITCHEN_BUTTON);
				break;
			case BTN_START:
				PoketchSePlay(POKETCH_SE_KITCHEN_BUTTON);
				wk->timer_sec = (wk->vpara.min10*10 + wk->vpara.min1)*60 + wk->vpara.sec10*10 + wk->vpara.sec1;
				if( wk->timer_sec )
				{
					set_button_enable( wk, BTN_START, FALSE );
					set_button_enable( wk, BTN_STOP, TRUE );
					Poketch_A21_SetViewCommand(wk->vwk, CMD_CHANGE_COUNTDOWN);
					ChangeSeq( wk, SEQ_COUNTDOWN );
					return FALSE;
				}
				break;
			case BTN_STOP:
				PoketchSePlay(POKETCH_SE_KITCHEN_BUTTON_DISABLE);
				break;
			}
			break;
		}

		if( wk->button_event == BMN_EVENT_TOUCH || wk->button_event == BMN_EVENT_REPEAT )
		{
			switch( wk->button_id ){
			case BTN_MIN10_UP:	if(++(wk->vpara.min10)>9){ wk->vpara.min10=0; } break;
			case BTN_MIN1_UP:	if(++(wk->vpara.min1)>9){ wk->vpara.min1=0; } break;
			case BTN_MIN10_DOWN:if(--(wk->vpara.min10)<0){ wk->vpara.min10=9; } break;
			case BTN_MIN1_DOWN:	if(--(wk->vpara.min1)<0){ wk->vpara.min1=9; } break;
			case BTN_SEC10_UP:	if(++(wk->vpara.sec10)>5){ wk->vpara.sec10=0; } break;
			case BTN_SEC1_UP:	if(++(wk->vpara.sec1)>9){ wk->vpara.sec1=0; } break;
			case BTN_SEC10_DOWN:if(--(wk->vpara.sec10)<0){ wk->vpara.sec10=5; } break;
			case BTN_SEC1_DOWN:	if(--(wk->vpara.sec1)<0){ wk->vpara.sec1=9; } break;
			}

			Poketch_A21_SetViewCommand(wk->vwk, CMD_UPDATE_NUM);
			wk->button_event = BMN_EVENT_NULL;
			break;
		}
		break;
	}

	return FALSE;
}

//------------------------------------------------------------------
/**
 * V[PXFJEg_E
 *
 * @param   wk		[N|C^
 *
 * @retval  BOOL		TRUEŃAvI
 */
//------------------------------------------------------------------
static BOOL SeqCountDown(APPWORK *wk)
{
	enum {
		SEQ_INIT,
		SEQ_WAIT,
		SEQ_COUNT_STOP,
	};

	if(wk->quit_req_flag)
	{
		ChangeSeq( wk, SEQ_QUIT );
		return FALSE;
	}

	switch( wk->seq ){
	case SEQ_INIT:
		APTM_Reset();
		wk->passed_sec = 0;
		wk->seq = SEQ_WAIT;
		/* fallthru */
	case SEQ_WAIT:
		if( check_update_timer(wk) )
		{
			Poketch_A21_SetViewCommand(wk->vwk, CMD_UPDATE_NUM);
			if( wk->timer_sec == 0 )
			{
				set_button_enable(wk, BTN_START, FALSE);
				ChangeSeq( wk, SEQ_ALARM );
				return FALSE;
			}
		}

		if( wk->button_event == BMN_EVENT_TOUCH )
		{
			wk->button_event = BMN_EVENT_NULL;

			switch( wk->button_id ){
			case BTN_START:
				PoketchSePlay(POKETCH_SE_KITCHEN_BUTTON_DISABLE);
				break;

			case BTN_STOP:
				set_button_enable( wk, BTN_STOP, FALSE );
				set_button_enable( wk, BTN_START, TRUE );
				wk->timer_backup = APTM_GetData();
				wk->seq = SEQ_COUNT_STOP;
				PoketchSePlay(POKETCH_SE_KITCHEN_BUTTON);
				break;

			case BTN_RESET:
				set_button_enable( wk, BTN_START, TRUE );
				set_button_enable( wk, BTN_STOP, FALSE );
				reset_timer( &wk->vpara );
				Poketch_A21_SetViewCommand( wk->vwk, CMD_UPDATE_BUTTON );
				Poketch_A21_SetViewCommand( wk->vwk, CMD_UPDATE_NUM );
				Poketch_A21_SetViewCommand( wk->vwk, CMD_CHANGE_INPUT );
				PoketchSePlay(POKETCH_SE_KITCHEN_BUTTON);
				ChangeSeq( wk, SEQ_INPUT );
				return FALSE;
			}
			break;
		}
		break;

	case SEQ_COUNT_STOP:
		if( wk->button_event == BMN_EVENT_TOUCH )
		{
			wk->button_event = BMN_EVENT_NULL;

			switch( wk->button_id ){
			case BTN_START:
				set_button_enable( wk, BTN_STOP, TRUE );
				set_button_enable( wk, BTN_START, FALSE );
				APTM_SetData( wk->timer_backup );
				PoketchSePlay(POKETCH_SE_KITCHEN_BUTTON);
				wk->seq = SEQ_WAIT;
				break;

			case BTN_STOP:
				PoketchSePlay(POKETCH_SE_KITCHEN_BUTTON_DISABLE);
				break;

			case BTN_RESET:
				set_button_enable( wk, BTN_START, TRUE );
				set_button_enable( wk, BTN_STOP, FALSE );
				reset_timer( &wk->vpara );
				Poketch_A21_SetViewCommand( wk->vwk, CMD_UPDATE_BUTTON );
				Poketch_A21_SetViewCommand( wk->vwk, CMD_UPDATE_NUM );
				Poketch_A21_SetViewCommand( wk->vwk, CMD_CHANGE_INPUT );
				PoketchSePlay(POKETCH_SE_KITCHEN_BUTTON);
				ChangeSeq( wk, SEQ_INPUT );
				return FALSE;
			}
			break;
		}
		break;

	}

	return FALSE;
}

//------------------------------------------------------------------
/**
 * V[PXFA[
 *
 * @param   wk		[N|C^
 *
 * @retval  BOOL		TRUEŃAvI
 */
//------------------------------------------------------------------
static BOOL SeqAlarm(APPWORK *wk)
{
	if(wk->quit_req_flag)
	{
		ChangeSeq( wk, SEQ_QUIT );
		return FALSE;
	}

	switch( wk->seq ){
	case 0:
		Poketch_A21_SetViewCommand( wk->vwk, CMD_START_ALARM );
		wk->seq++;
		break;

	case 1:
		if( wk->button_event == BMN_EVENT_TOUCH )
		{
			wk->button_event = BMN_EVENT_NULL;
			switch(wk->button_id){
			case BTN_START:
				PoketchSePlay(POKETCH_SE_KITCHEN_BUTTON_DISABLE);
				break;
			case BTN_STOP:
				set_button_enable( wk, BTN_START, TRUE );
				set_button_enable( wk, BTN_STOP,  FALSE );
				Poketch_A21_SetViewCommand( wk->vwk, CMD_STOP_ALARM );
				PoketchSePlay(POKETCH_SE_KITCHEN_BUTTON);
				wk->seq++;
				break;
			case BTN_RESET:
				set_button_enable( wk, BTN_START, TRUE );
				set_button_enable( wk, BTN_STOP, FALSE );
				PoketchSePlay(POKETCH_SE_KITCHEN_BUTTON);
				Poketch_A21_SetViewCommand( wk->vwk, CMD_STOP_ALARM );
				wk->seq = 3;
				break;
			}
			break;
		}
		break;

	case 2:
		if( Poketch_A21_WaitViewCommand( wk->vwk, CMD_STOP_ALARM ) == FALSE )
		{
			break;
		}

		if( wk->button_event == BMN_EVENT_TOUCH )
		{
			wk->button_event = BMN_EVENT_NULL;
			switch(wk->button_id){
			case BTN_START:
				set_button_enable( wk, BTN_START, FALSE );
				set_button_enable( wk, BTN_STOP,  TRUE );
				Poketch_A21_SetViewCommand( wk->vwk, CMD_START_ALARM );
				PoketchSePlay(POKETCH_SE_KITCHEN_BUTTON);
				wk->seq=1;
				break;
			case BTN_STOP:
				PoketchSePlay(POKETCH_SE_KITCHEN_BUTTON_DISABLE);
				break;
			case BTN_RESET:
				set_button_enable( wk, BTN_START, TRUE );
				set_button_enable( wk, BTN_STOP, FALSE );
				PoketchSePlay(POKETCH_SE_KITCHEN_BUTTON);
				Poketch_A21_SetViewCommand( wk->vwk, CMD_STOP_ALARM );
				wk->seq = 3;
				break;
			}
			break;
		}
		break;

	case 3:
		if( Poketch_A21_WaitViewCommandAll( wk->vwk ) )
		{
			set_button_enable( wk, BTN_START, TRUE );
			set_button_enable( wk, BTN_STOP, FALSE );
			reset_timer( &wk->vpara );
			Poketch_A21_SetViewCommand( wk->vwk, CMD_UPDATE_BUTTON );
			Poketch_A21_SetViewCommand( wk->vwk, CMD_UPDATE_NUM );
			Poketch_A21_SetViewCommand( wk->vwk, CMD_CHANGE_INPUT );
			ChangeSeq( wk, SEQ_INPUT );
		}
		break;
	}

	return FALSE;
}


static BOOL check_update_timer( APPWORK* wk )
{
	u64 passed_sec = APTM_GetSec();

	if( (passed_sec == wk->passed_sec)
	||	(wk->timer_sec == 0)
	){
		return FALSE;
	}

	if( passed_sec >= wk->timer_sec )
	{
		reset_timer(&wk->vpara);
		wk->timer_sec = 0;
	}
	else
	{
		u32 min, sec;
		CP_SetDiv64_32( (wk->timer_sec - passed_sec), 60 );

		min = CP_GetDivResult64();
		sec = CP_GetDivRemainder64();

		CP_SetDiv32_32( min, 10 );
		wk->vpara.min10 = CP_GetDivResult32();
		wk->vpara.min1 = CP_GetDivRemainder32();

		CP_SetDiv32_32( sec, 10 );
		wk->vpara.sec10 = CP_GetDivResult32();
		wk->vpara.sec1 = CP_GetDivRemainder32();
	}

	wk->passed_sec = passed_sec;
	return TRUE;
}


static void reset_timer(VIEWPARAM* vpara)
{
	vpara->min10 = 0;
	vpara->min1 = 0;
	vpara->sec10 = 0;
	vpara->sec1 = 0;
}

//------------------------------------------------------------------
/**
 * V[PXFI
 *
 * @param   wk		[N|C^
 *
 * @retval  BOOL		TRUEŃAvI
 */
//------------------------------------------------------------------
static BOOL SeqQuit(APPWORK *wk)
{
	switch(wk->seq){
	case 0:
		Poketch_A21_SetViewCommand( wk->vwk, CMD_QUIT );
		wk->seq++;
		break;

	case 1:
		if(Poketch_A21_WaitViewCommandAll( wk->vwk ))
		{
			return TRUE;
		}
		break;
	}

	return FALSE;
}
