//============================================================================================
/**
 * @file	poketch_c.c
 * @bfief	|Pb`iCj@Rg[
 * @author	taya GAME FREAK inc.
 */
//============================================================================================
#include "common.h"
#include "tcb.h"
#include "system\lib_pack.h"
#include "system\pm_overlay.h"
#include "gflib\touchpanel.h"
#include "system\snd_tool.h"

#include "field\poketch.h"
#include "poketch_sound.h"
#include "poketch_prv.h"
#include "poketch_main.h"
#include "poketch_button.h"


#define  DOUBLETAP_OFF		// _u^bvItāAVO^bvŃAvX؂ւ铮



//====================================================
// AvI[o[CW[錾
//====================================================
FS_EXTERN_OVERLAY(poketch_app_dwatch);
FS_EXTERN_OVERLAY(poketch_app_awatch);
FS_EXTERN_OVERLAY(poketch_app_stopwatch);
FS_EXTERN_OVERLAY(poketch_app_calc);
FS_EXTERN_OVERLAY(poketch_app_memo);
FS_EXTERN_OVERLAY(poketch_app_dotart);
FS_EXTERN_OVERLAY(poketch_app_simple_pokelist);
FS_EXTERN_OVERLAY(poketch_app_dummy);
FS_EXTERN_OVERLAY(poketch_app_natsuki_checker);
FS_EXTERN_OVERLAY(poketch_app_dowsing);
FS_EXTERN_OVERLAY(poketch_app_counter);
FS_EXTERN_OVERLAY(poketch_app_pedometer);
FS_EXTERN_OVERLAY(poketch_app_cointoss);
FS_EXTERN_OVERLAY(poketch_app_trainer_launcher);
FS_EXTERN_OVERLAY(poketch_app_wazaeff);
FS_EXTERN_OVERLAY(poketch_app_color_changer);
FS_EXTERN_OVERLAY(poketch_app_sodateya_camera);
FS_EXTERN_OVERLAY(poketch_app_love_tester);
FS_EXTERN_OVERLAY(poketch_app_alarm);
FS_EXTERN_OVERLAY(poketch_app_roulette);
FS_EXTERN_OVERLAY(poketch_app_kitchen);
FS_EXTERN_OVERLAY(poketch_app_comm_search);

//====================================================
// AvI[o[Chce[u
//====================================================
static const struct {
	FSOverlayID	id;			// I[o[Chc
	u32			param;		// Avɓnp[^
}OverlayID[] = {

	{ FS_OVERLAY_ID(poketch_app_dwatch),     0 },		//  0: fW^v
	{ FS_OVERLAY_ID(poketch_app_stopwatch),  1 },		//  1: XgbvEHb`
	{ FS_OVERLAY_ID(poketch_app_calc),       0 },		//  2: d
	{ FS_OVERLAY_ID(poketch_app_memo),       0 },		//  3: 
	{ FS_OVERLAY_ID(poketch_app_awatch),     0 },		//  4: AiOv
	{ FS_OVERLAY_ID(poketch_app_dotart),     0 },		//  5: hbgA[g
	{ FS_OVERLAY_ID(poketch_app_simple_pokelist),  0 },	//  6: ȈՃ|PXg
	{ FS_OVERLAY_ID(poketch_app_natsuki_checker),  0 },	//  7: Ȃx`FbJ[
	{ FS_OVERLAY_ID(poketch_app_dowsing),    0 },		//  8: _EWO}V
	{ FS_OVERLAY_ID(poketch_app_counter),    0 },		//  9: JE^[
	{ FS_OVERLAY_ID(poketch_app_pedometer),  0 },		// 10: v
	{ FS_OVERLAY_ID(poketch_app_dummy),  12 },			// 11:[[[[ obNCgXCb` ]]]]
	{ FS_OVERLAY_ID(poketch_app_dummy),  13 },			// 12:[[[[ 񂽂}bv ]]]]


	{ FS_OVERLAY_ID(poketch_app_trainer_launcher), 0 },	// 13: g[i[`[
	{ FS_OVERLAY_ID(poketch_app_dummy), 15 },			// 14:[[[[ Ȃ̃{^ ]]]]


	{ FS_OVERLAY_ID(poketch_app_sodateya_camera), 0 },	// 15: ĂJ
	{ FS_OVERLAY_ID(poketch_app_roulette),   0 },		// 16: [bg
	{ FS_OVERLAY_ID(poketch_app_cointoss),   0 },		// 17: RCgX
	{ FS_OVERLAY_ID(poketch_app_wazaeff),   0 },		// 18: 킴ʃ`FbJ[
	{ FS_OVERLAY_ID(poketch_app_love_tester),0 },		// 19: ueX^[
	{ FS_OVERLAY_ID(poketch_app_alarm),  0 },			// 20: A[v
	{ FS_OVERLAY_ID(poketch_app_kitchen),    0 },		// 21: Lb`^C}[
	{ FS_OVERLAY_ID(poketch_app_dummy), 23 },			// 22:[[[[ }bv}[LO ]]]]
	{ FS_OVERLAY_ID(poketch_app_dummy), 24 },			// 23:[[[[ ̂݃T[`[ ]]]]


	{ FS_OVERLAY_ID(poketch_app_color_changer), 0 },	// 24: J[`FW[
	{ FS_OVERLAY_ID(poketch_app_dummy), 26 },			// 25:[[[[ J_[ ]]]]
	{ FS_OVERLAY_ID(poketch_app_dummy), 27 },			// 26:[[[[ WI ]]]]


	{ FS_OVERLAY_ID(poketch_app_comm_search), 0 },		// 27: T[`[
	{ FS_OVERLAY_ID(poketch_app_dummy), 29 },			// 28:[[[[ ׂ񂫂傤{^ ]]]]
	{ FS_OVERLAY_ID(poketch_app_dummy), 30 },			// 29:[[[[ _~[P ]]]]
	{ FS_OVERLAY_ID(poketch_app_dummy), 31 },			// 30:[[[[ _~[Q ]]]]
	{ FS_OVERLAY_ID(poketch_app_dummy), 32 },			// 31:[[[[ _~[R ]]]]
};



//====================================================
// V[PX
//====================================================
enum {
	SEQ_INIT = 0,
	SEQ_APP_MAIN,
	SEQ_APPCHANGE_NORMAL,
	SEQ_APPCHANGE_LONG,
	SEQ_APPCHANGE_DEFAULT,
	SEQ_CLEANUP,
	SEQ_QUIT,
};

// X[vȍ~̃V[PX
enum {
	SLEEP_SEQ_NULL,	// Ȃ
	SLEEP_SEQ_REQ,	// X[vNGXg
	SLEEP_SEQ_MAIN,	// X[vł
	SLEEP_SEQ_WAKE,	// EFCNNGXg
};

//====================================================
// q[vgpTCY
//====================================================
enum {
	HEAPSIZE_MAIN = 0xc000,
	HEAPSIZE_APP = 0xc000,
};
//====================================================
// ̂萔
//====================================================
enum {
	APP_SKIP_TIMER = 30,
	APP_FIRST_SKIP_TIMER = 3,
};

//====================================================
// C[N
//====================================================
struct _POKETCH_WORK {
	u8	main_seq;
	u8	seq;

	u8	app_working_flag;
	u8	app_quit_req_flag;
	u8	next_seq;

	u8	sleep_flag;
	u8	player_move_flag;
	u8  app_changing_flag;

	u32  button_action;
	BOOL app_skip_flag;
	u32  app_skip_timer;
	u32  unload_app_number;

	POKETCH_VIEW_WORK	*view_wk;
	POKETCH_MAIN_VPARAM  vpara;
	void				*app_work;

	POKETCH_BUTTON_MAN*				button;
	u32						button_cmd_req;

	struct _POKETCH_WORK**  this_work_adrs;	// pɎ̃AhX
	TCB_PTR                 tail_task;

	// AvP[V̐֐
	pAppInitProc	app_init_proc;
	pAppQuitProc	app_quit_proc;

	GF_BGL_INI*						bgl;
	NNSG2dOamManagerInstance*		oamm;

	SAVEDATA*       savedata;
	POKETCH_DATA*   poketch_savedata;
	FIELDSYS_WORK*  fieldsys;
};

//==============================================================
// Prototype
//==============================================================
static POKETCH_WORK* GetMainWorkPtr(void);
static BOOL PoketchWorkSetup( POKETCH_WORK* wk );
static void PoketchWorkCleanup( POKETCH_WORK* wk );
static void PoketchMain(TCB_PTR tcb, void *wk_adrs);
static void PoketchTail( TCB_PTR tcb, void* wk_adrs );
static void ChangeSeq( POKETCH_WORK *wk, u32 seq );
static void SeqInit(POKETCH_WORK *wk);
static void SeqAppMain(POKETCH_WORK *wk);
static void SeqAppChangeNormal(POKETCH_WORK *wk);
static void SeqAppChangeLong(POKETCH_WORK *wk);
static void SeqAppChangeDefault(POKETCH_WORK *wk);
static void SeqCleanUp( POKETCH_WORK *wk );
static void LoadApplication(u32 app_no);
static void UnloadApplication(u32 app_no);
static BOOL BmnSetup( POKETCH_WORK* wk );
static void BmnCleanup( POKETCH_WORK *wk );
static void ButtonUpdate( POKETCH_WORK *wk );
static void BmnCallBack( u32 idx, u32 event, u32 touch_event, void* wk_adrs );
static void ButtonViewReq( POKETCH_VIEW_WORK *vwk, u32 cmd );


extern struct _POKETCH_WORK* GetPoketchMainWorkPtr(void);



//------------------------------------------------------------------
/**
 * C[N|C^Ԃ
 *
 * @retval  POKETCH_WORK*		C[N|C^
 */
//------------------------------------------------------------------
static POKETCH_WORK* GetMainWorkPtr(void)
{
	#ifdef PM_DEBUG
	extern POKETCH_WORK* GetPoketchMainWorkPtrDebug(void);
	#endif

	return  GetPoketchMainWorkPtr();
}

//------------------------------------------------------------------
/**
 * |Pb`JnitB[hJnɂ̂݌Ă΂j
 *
 * @param   wk_adrs		[NAhXۑϐ̃|C^
 * @param   savedata	|Pb`Z[uf[^|C^
 * @param   bgl			ʍ\zɎgBGLVXe|C^
 *
 */
//------------------------------------------------------------------
void PoketchInit( FIELDSYS_WORK* fsys, POKETCH_WORK **wk_adrs, SAVEDATA* savedata,  GF_BGL_INI* bgl, NNSG2dOamManagerInstance* oamm )
{
	POKETCH_WORK *wk;

	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_POKETCH_MAIN, HEAPSIZE_MAIN );
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_POKETCH_APP,  HEAPSIZE_APP );

	wk = sys_AllocMemory(POKETCH_MAIN_CTRL_HEAPID, sizeof(POKETCH_WORK));

	if(wk != NULL)
	{
		*wk_adrs = wk;

		wk->fieldsys = fsys;
		wk->savedata = savedata;
		wk->poketch_savedata = SaveData_GetPoketchData( savedata );
		wk->bgl = bgl;
		wk->oamm = oamm;


		if( PoketchWorkSetup( wk ) )
		{
			InitTPSystem();			// ^b`plVXe
			InitTPNoBuff(4);

			wk->this_work_adrs = wk_adrs;
			wk->tail_task = TCB_Add( PoketchTail, wk, POKETCH_TAIL_TASKPRI );
			TCB_Add( PoketchMain, wk, POKETCH_MAIN_TASKPRI );
		}
	}
}

//------------------------------------------------------------------
/**
 * |Pb`IJn
 *
 * @param   wk		|Pb`[N|C^iPoketchInitœńj
 *
 */
//------------------------------------------------------------------
void PoketchQuitReq(POKETCH_WORK *wk)
{
	ChangeSeq( wk, SEQ_CLEANUP );
}
//------------------------------------------------------------------
/**
 * |Pb`I҂
 *
 * @param   wk		|Pb`[N|C^
 *
 * @retval  BOOL	TRUEŏI
 */
//------------------------------------------------------------------
BOOL PoketchQuitWait( POKETCH_WORK *wk )
{
	return (wk == NULL);
}


//------------------------------------------------------------------
/**
 * tB[h|Pb`֊e󋵕ω̒ʒm󂯎
 *
 * @param   wk		
 * @param   id		
 * @param   value		
 *
 */
//------------------------------------------------------------------
void Poketch_SendRequest( POKETCH_WORK* wk, FIELD_POKETCH_SEND_ID  id, u32 value )
{
	switch( id ){
	case POKETCH_SEND_SLEEP:
		wk->sleep_flag = value;
		break;

	case POKETCH_SEND_MOVE_PLAYER:
		{
			u32 count = PoketchData_GetPedometer( wk->poketch_savedata );
			if( ++count > 99999 )
			{
				count = 0;
			}
			PoketchData_SetPedometer( wk->poketch_savedata, count );
			wk->player_move_flag = TRUE;
		}
		break;
	}
}

//------------------------------------------------------------------
/**
 * C[NZbgAbv
 *
 * @param   wk		[N|C^
 */
//------------------------------------------------------------------
static BOOL PoketchWorkSetup( POKETCH_WORK* wk )
{
	if(Poketch_MAIN_SetViewWork( &(wk->view_wk), &(wk->vpara), wk->oamm, wk ))
	{
		wk->main_seq = SEQ_INIT;
		wk->seq = 0;

		wk->app_working_flag = FALSE;
		wk->app_quit_req_flag = FALSE;
		wk->sleep_flag = FALSE;
		wk->player_move_flag = FALSE;
		wk->app_changing_flag = FALSE;

		wk->button_action = BMN_EVENT_NULL;

		if( BmnSetup( wk ) )
		{
			return TRUE;
		}
	}
	return FALSE;
}
//------------------------------------------------------------------
/**
 * C[NN[Abv
 *
 * @param   wk		
 *
 */
//------------------------------------------------------------------
static void PoketchWorkCleanup( POKETCH_WORK* wk )
{
	TCB_Delete( wk->tail_task );
	BmnCleanup( wk );
	Poketch_MAIN_DeleteViewWork( wk->view_wk );
}

//------------------------------------------------------------------
/**
 * |Pb`C^XN
 *8+
 * @param   tcb			TCB|C^
 * @param   wk_adrs		[NAhX
 */
//------------------------------------------------------------------
static void PoketchMain(TCB_PTR tcb, void *wk_adrs)
{
	static void (* const seq_tbl[])(POKETCH_WORK *) = {
		SeqInit,
		SeqAppMain,
		SeqAppChangeNormal,
		SeqAppChangeLong,
		SeqAppChangeDefault,
		SeqCleanUp,
	};

	POKETCH_WORK *wk;

	wk = (POKETCH_WORK *)wk_adrs;

	ButtonUpdate( wk );

	if( wk->main_seq < NELEMS(seq_tbl) )
	{
		seq_tbl[ wk->main_seq ]( wk );
	}
	else
	{
		GF_ASSERT( wk->main_seq == SEQ_QUIT );
		*(wk->this_work_adrs) = NULL;
		PoketchWorkCleanup( wk );
		sys_FreeMemoryEz( wk );
		TCB_Delete( tcb );

		sys_DeleteHeap( HEAPID_POKETCH_MAIN );
		sys_DeleteHeap( HEAPID_POKETCH_APP );

	}
}

//------------------------------------------------------------------
/**
 * CA`擙ASĂ̏IɂPĂ^XN
 *
 * @param   tcb		
 * @param   wk_adrs		
 *
 */
//------------------------------------------------------------------
static void PoketchTail( TCB_PTR tcb, void* wk_adrs )
{
	POKETCH_WORK* wk = wk_adrs;

	wk->player_move_flag = FALSE;
}

//------------------------------------------------------------------
/**
 * V[PX؂ւ
 *
 * @param   wk		[N|C^
 * @param   seq		̃V[PX
 *
 */
//------------------------------------------------------------------
static void ChangeSeq( POKETCH_WORK *wk, u32 seq )
{
	wk->main_seq = seq;
	wk->seq = 0;
}
//------------------------------------------------------------------
/**
 * V[PXFʍ\z
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void SeqInit(POKETCH_WORK *wk)
{
	switch(wk->seq){
	case 0:
		Poketch_MAIN_SetCommand(wk->view_wk, CMD_MAIN_INIT);
		wk->seq++;
		break;

	case 1:
		if(Poketch_MAIN_WaitCommand(wk->view_wk, CMD_MAIN_INIT))
		{
			u32 app_no = PoketchData_GetNowApplication(wk->poketch_savedata);
			LoadApplication( app_no );
			wk->app_init_proc( &(wk->app_work), wk, wk->bgl, OverlayID[app_no].param );
			wk->seq++;
		}
		break;

	case 2:
		if( wk->app_working_flag == FALSE ){
			break;
		}
		Poketch_MAIN_SetCommand(wk->view_wk, CMD_MAIN_FIRSTOPEN);
		wk->seq++;
		/* fallthru */
	case 3:
		if(Poketch_MAIN_WaitCommand(wk->view_wk, CMD_MAIN_FIRSTOPEN))
		{
			ChangeSeq(wk, SEQ_APP_MAIN);
		}
	}
}
//------------------------------------------------------------------
/**
 * V[PXFAvC
 *
 * @param   wk		
 *
 */
//------------------------------------------------------------------
static void SeqAppMain(POKETCH_WORK *wk)
{
	switch(wk->seq){
	case 0:
		if( wk->sleep_flag )
		{
			return;
		}

		switch( wk->button_action ){
		case BMN_EVENT_TAP:
		case BMN_EVENT_TIMER0:
			wk->app_skip_flag = FALSE;
			wk->next_seq = SEQ_APPCHANGE_NORMAL;
			wk->unload_app_number = PoketchData_GetNowApplication( wk->poketch_savedata );
			Poketch_MAIN_SetCommand( wk->view_wk, CMD_MAIN_EFFCLOSE );
			wk->app_changing_flag = TRUE;
			wk->seq++;
			break;

//		p~
//		case BUTTON_ACTION_LONGHOLD:
//			wk->next_seq = SEQ_APPCHANGE_LONG;
//			break;

		#ifndef DOUBLETAP_OFF
		case BMN_EVENT_DOUBLETAP:
			wk->next_seq = SEQ_APPCHANGE_DEFAULT;
			wk->unload_app_number = PoketchData_GetNowApplication( wk->poketch_savedata );
			Poketch_MAIN_SetCommand( wk->view_wk, CMD_MAIN_EFFCLOSE2 );
			wk->seq++;
			break;
		#endif

		}
		break;

	case 1:
		if( wk->button_action == BMN_EVENT_TAP || wk->button_action == BMN_EVENT_TIMER0 )
		{
			wk->app_skip_flag = TRUE;
		}

		if(Poketch_MAIN_WaitCommandAll( wk->view_wk ))
		{
			wk->vpara.app_pos = PoketchData_SetApplicationPosNext( wk->poketch_savedata );
			if( wk->app_skip_flag )
			{
				Poketch_MAIN_SetCommand( wk->view_wk, CMD_MAIN_SKIPNUM_DISP );
				wk->app_skip_timer = APP_SKIP_TIMER;
				wk->app_skip_flag = FALSE;
				wk->seq = 4;
			}
			else
			{
				wk->app_skip_timer = APP_FIRST_SKIP_TIMER;
				wk->seq = 2;
			}
		}
		break;

	case 2:
		if( wk->button_action == BMN_EVENT_TAP || wk->button_action == BMN_EVENT_TIMER0 )
		{
			Poketch_MAIN_SetCommand( wk->view_wk, CMD_MAIN_SKIPNUM_DISP );
			wk->app_skip_timer = APP_SKIP_TIMER;
			wk->app_skip_flag = FALSE;
			wk->seq = 4;
			break;
		}

		if( wk->app_skip_timer )
		{
			wk->app_skip_timer--;
		}
		else
		{
			wk->app_quit_proc(wk->app_work);
			wk->app_quit_req_flag = TRUE;
			wk->seq = 3;
		}
		break;

	case 3:
		if( wk->app_working_flag  == FALSE )
		{
			wk->app_quit_req_flag = FALSE;
			UnloadApplication( wk->unload_app_number );
			ChangeSeq(wk, wk->next_seq);
		}
		break;

	// AŎtJn
	case 4:
		if( wk->button_action == BMN_EVENT_TAP || wk->button_action == BMN_EVENT_TIMER0 )
		{
			wk->vpara.app_pos = PoketchData_SetApplicationPosNext( wk->poketch_savedata );
			wk->app_skip_timer = APP_SKIP_TIMER;
			Poketch_MAIN_SetCommand( wk->view_wk, CMD_MAIN_SKIPNUM_UPDATE );
			break;
		}

		if(wk->app_skip_timer)
		{
			wk->app_skip_timer--;
		}
		else
		{
			Poketch_MAIN_SetCommand( wk->view_wk, CMD_MAIN_SKIPNUM_END );
			wk->app_quit_proc(wk->app_work);
			wk->app_quit_req_flag = TRUE;
			wk->seq = 3;
		}
		break;
	}
}
//------------------------------------------------------------------
/**
 * V[PXFAv؂ւiVOFPցj
 *
 * @param   wk		
 */
//------------------------------------------------------------------
static void SeqAppChangeNormal(POKETCH_WORK *wk)
{
	switch(wk->seq){
	case 0:
		{
			u32 app_no;

			app_no = PoketchData_GetNowApplication( wk->poketch_savedata );
			LoadApplication( app_no );
			wk->app_init_proc( &(wk->app_work), wk, wk->bgl, OverlayID[app_no].param );
			wk->seq++;
		}
		break;

	case 1:
		if( wk->app_working_flag )
		{
			Poketch_MAIN_SetCommand( wk->view_wk, CMD_MAIN_EFFOPEN );
			wk->seq++;
		}
		break;

	case 2:
		if(Poketch_MAIN_WaitCommand(wk->view_wk, CMD_MAIN_EFFOPEN))
		{
			wk->app_changing_flag = FALSE;
			ChangeSeq(wk, SEQ_APP_MAIN);
		}
		break;
	}
}
//------------------------------------------------------------------
/**
 * V[PXFAv؂ւiF10ցj
 *
 * @param   wk		
 */
//------------------------------------------------------------------
static void SeqAppChangeLong(POKETCH_WORK *wk)
{
	enum {
		APPCHANGE_LONG_LANGE = 10,
	};

	switch(wk->seq){
	case 0:
		{
			u32 pos, appno;

			pos = PoketchData_GetNowApplicationPos( wk->poketch_savedata );
			pos += APPCHANGE_LONG_LANGE;
			PoketchData_SetApplicationPos( wk->poketch_savedata, pos );
			appno = PoketchData_GetNowApplication( wk->poketch_savedata );
			LoadApplication( appno );
			wk->app_init_proc( &(wk->app_work), wk, wk->bgl, OverlayID[appno].param );
			wk->seq++;
		}
		break;

	case 1:
		if( wk->app_working_flag )
		{
			Poketch_MAIN_SetCommand( wk->view_wk, CMD_MAIN_EFFOPEN );
			wk->seq++;
		}
		break;

	case 2:
		if(Poketch_MAIN_WaitCommand(wk->view_wk, CMD_MAIN_EFFOPEN))
		{
			ChangeSeq(wk, SEQ_APP_MAIN);
		}
		break;
	}
}
//------------------------------------------------------------------
/**
 * V[PXFAv؂ւi_uFftHgo^ցj
 *
 * @param   wk		
 */
//------------------------------------------------------------------
static void SeqAppChangeDefault(POKETCH_WORK *wk)
{
	switch(wk->seq){
	case 0:
		{
			u32 app_no;

			PoketchData_SetApplicationPos( wk->poketch_savedata, 0 );
			app_no = PoketchData_GetNowApplication( wk->poketch_savedata );
			LoadApplication( app_no );
			wk->app_init_proc( &(wk->app_work), wk, wk->bgl, OverlayID[app_no].param );
			wk->seq++;
		}
		break;

	case 1:
		if( wk->app_working_flag )
		{
			Poketch_MAIN_SetCommand( wk->view_wk, CMD_MAIN_EFFOPEN2 );
			wk->seq++;
		}
		break;

	case 2:
		if(Poketch_MAIN_WaitCommand(wk->view_wk, CMD_MAIN_EFFOPEN2))
		{
			ChangeSeq(wk, SEQ_APP_MAIN);
		}
		break;
	}
}
//------------------------------------------------------------------
/**
 * V[PXF|Pb`I
 *
 * @param   wk		
 *
 */
//------------------------------------------------------------------
static void SeqCleanUp( POKETCH_WORK *wk )
{
	switch( wk->seq ){
	case 0:
		if( (wk->app_quit_req_flag == FALSE)
		||	(wk->app_working_flag == TRUE)
		){
			wk->app_quit_proc( wk->app_work );
			wk->app_quit_req_flag = TRUE;
		}
		wk->seq++;
		break;
	case 1:
		if( wk->app_working_flag ){
			break;
		}
		Poketch_MAIN_SetCommand( wk->view_wk, CMD_MAIN_QUIT );
		wk->seq++;
		break;
	case 2:
		if( Poketch_MAIN_WaitCommandAll( wk->view_wk ) == FALSE ){
			break;
		}
		if(wk->app_quit_req_flag)
		{
			UnloadApplication( PoketchData_GetNowApplication(wk->poketch_savedata) );
			wk->app_quit_req_flag = FALSE;
		}

		StopTP();
		ChangeSeq( wk, SEQ_QUIT );
		break;
	}
}


//------------------------------------------------------------------
/**
 * AvP[ṼI[o[CW[[h
 *
 * @param   app_no		AvP[Vio[
 *
 */
//------------------------------------------------------------------
static void LoadApplication(u32 app_no)
{
	GF_ASSERT( app_no < NELEMS(OverlayID) );

	Overlay_Load( OverlayID[app_no].id, OVERLAY_LOAD_NOT_SYNCHRONIZE);
}
//------------------------------------------------------------------
/**
 * AvP[ṼI[o[CW[A[h
 *
 * @param   app_no		
 *
 */
//------------------------------------------------------------------
static void UnloadApplication(u32 app_no)
{
	extern BOOL sys_HeapFullEmptyCheck( u32 heapID );

	GF_ASSERT( app_no < NELEMS(OverlayID) );

	Overlay_UnloadID( OverlayID[app_no].id );
}

/*====================================================================================*/
/*                                                                                    */
/*  {^ԃ[N                                                              */
/*                                                                                    */
/*====================================================================================*/

// enum POKETCH_BUTTON_VIEW ̕тƓ
static const u32 ButtonViewCmd[] = {
	CMD_MAIN_BUTTONFREE,
	CMD_MAIN_BUTTONLOCK,
	CMD_MAIN_BUTTONPUSH,
};

enum {
	BUTTON_TIMER_TAP = 7,
	BUTTON_TIMER_DOUBLETAP = 8,		// ŏ̃^bv_u^bvst[
};

enum {
	BUTTON_ID_MAIN,		///< C̃{^
	BUTTON_ID_SCREEN,	///< ʑŜ{^ƂĈc
};

//------------------------------------------------------------------
/**
 * {^Ǘ}l[WZbgAbv
 *
 * @param   wk			Av[N
 *
 * @retval  BOOL		TRUEŐ
 */
//------------------------------------------------------------------
static BOOL BmnSetup( POKETCH_WORK* wk )
{
	// {^ʒuiviewɎǂ̂c?j
	static const TP_HIT_TBL ButtonRectData[] = {
		{ 116, 172, 220, 244 },
		{ 16, 175, 16, 207 },
	};

	wk->button = PBTN_Create( ButtonRectData, NELEMS(ButtonRectData), BmnCallBack, wk, POKETCH_MAIN_CTRL_HEAPID );
	if( wk->button != NULL )
	{
		#ifndef DOUBLETAP_OFF
		PBTN_SetDoubleTapTime( wk->button, 0, BUTTON_TIMER_DOUBLETAP );
		#endif
		PBTN_SetEventTime( wk->button, 0, 0, BUTTON_TIMER_TAP );
		wk->button_cmd_req = CMD_NULL;
		return TRUE;
	}
	return FALSE;
}
//------------------------------------------------------------------
/**
 * {^Ǘ}l[WN[Abv
 *
 * @param   wk		
 *
 */
//------------------------------------------------------------------
static void BmnCleanup( POKETCH_WORK *wk )
{
	PBTN_Delete( wk->button );
}
//------------------------------------------------------------------
/**
 * 
 *
 * @param   wk		
 *
 */
//------------------------------------------------------------------
static void ButtonUpdate( POKETCH_WORK *wk )
{
	wk->button_action = BMN_EVENT_NULL;
	PBTN_Main( wk->button );
}
//------------------------------------------------------------------
/**
 * {^Ǘ}l[W̃R[obN֐
 *
 * @param   idx		
 * @param   event		
 * @param   touch_event		
 * @param   wk_adrs		
 *
 */
//------------------------------------------------------------------
static void BmnCallBack( u32 idx, u32 event, u32 touch_event, void* wk_adrs )
{
	POKETCH_WORK *wk = (POKETCH_WORK*)wk_adrs;
	u32 v_cmd = CMD_NULL;

	if( idx == BUTTON_ID_SCREEN )
	{
		if( wk->sleep_flag )
		{
			if(touch_event == BMN_TOUCH_ON)
			{
				Snd_SePlay( POKETCH_SE_BEEP );
			}
		}
		return;
	}

	switch(touch_event){
	case BMN_TOUCH_OFF:
		v_cmd = CMD_MAIN_BUTTONFREE;
		break;
	case BMN_TOUCH_ON:
		if( PoketchIsSleepMode( wk ) ){
			v_cmd = CMD_MAIN_BUTTONLOCK;
		}else{
			v_cmd = CMD_MAIN_BUTTONPUSH;
		}
		break;
	}

	if( wk->button_cmd_req != CMD_NULL )
	{
		u32 tmp = v_cmd;
		v_cmd = wk->button_cmd_req;
		wk->button_cmd_req = tmp;
	}

	if(v_cmd != CMD_NULL)
	{
		ButtonViewReq( wk->view_wk, v_cmd );
	}

	if(event == BMN_EVENT_TIMER0)
	{
		PBTN_ResetState( wk->button, 0 );
	}

	wk->button_action = event;
}
//------------------------------------------------------------------
/**
 * {^\XVR}hviewɓ`
 *
 * @param   wk		|Pb`[N
 * @param   cmd		R}h
 */
//------------------------------------------------------------------
static void ButtonViewReq( POKETCH_VIEW_WORK *vwk, u32 cmd )
{
	u32 i;

	for(i = 0; i < NELEMS(ButtonViewCmd); i++)
	{
		if( Poketch_MAIN_WaitCommand( vwk, cmd ) == FALSE )
		{
			return;
		}
	}
	Poketch_MAIN_SetCommand( vwk, cmd );
}



/*====================================================================================*/
/*                                                                                    */
/*  eAvʒm󂯎֐Q                                                  */
/*                                                                                    */
/*====================================================================================*/

//------------------------------------------------------------------
/**
 * eAvW[̃[hANitroStaticInitɂĂяo
 * Av̊e퐧֐AhX󂯎
 *
 * @param   initproc		֐
 * @param   quitproc		I֐
 *
 */
//------------------------------------------------------------------
void PoketchSetAppProc( pAppInitProc initproc, pAppQuitProc quitproc)
{
	POKETCH_WORK *wk = GetMainWorkPtr();

	wk->app_init_proc = initproc;
	wk->app_quit_proc = quitproc;

}
//------------------------------------------------------------------
/**
 * eAv̏ʒm󂯎
 */
//------------------------------------------------------------------
void PoketchNoticeAppStart(CONTACT_WORK* wk)
{
	GF_ASSERT( wk->app_working_flag == FALSE );
	wk->app_working_flag = TRUE;
}
//------------------------------------------------------------------
/**
 * eAv̏Iʒm󂯎
 */
//------------------------------------------------------------------
void PoketchNoticeAppEnd(CONTACT_WORK* wk)
{
	GF_ASSERT( wk->app_working_flag == TRUE );
	wk->app_working_flag = FALSE;
}



/*====================================================================================*/
/*                                                                                    */
/*  `۰ّĂяo֐                                                  */
/*                                                                                    */
/*====================================================================================*/

POKETCH_VIEW_WORK* PoketchGetMainViewWork( void )
{
	POKETCH_WORK *wk = GetMainWorkPtr();

	return wk->view_wk;
}


void PoketchSePlay( u32 se )
{
	POKETCH_WORK *wk = GetMainWorkPtr();

	if(	(PoketchIsSleepMode( wk ) == FALSE)
	&&	(wk->app_changing_flag == FALSE)
	){
		Snd_SePlay( se );
	}
}

void PoketchVoicePlay( u32 pokeno )
{
	POKETCH_WORK *wk = GetMainWorkPtr();

	if( PoketchIsSleepMode( wk ) == FALSE )
	{
		Snd_PMVoicePlay( pokeno );
	}
}

BOOL PoketchGetTPCont( u32* x, u32 *y )
{
	POKETCH_WORK *wk = GetMainWorkPtr();

	if( PoketchIsSleepMode( wk ) == FALSE )
	{
		return GF_TP_GetPointCont(x, y);
	}
	return FALSE;
}

BOOL PoketchGetTPTrg( void )
{
	POKETCH_WORK *wk = GetMainWorkPtr();

	if( PoketchIsSleepMode( wk ) == FALSE )
	{
		return GF_TP_GetTrg();
	}
	return FALSE;
}

//------------------------------------------------------------------
/**
 * X[v[hǂ`FbN
 *
 * @param   wk		
 *
 * @retval  BOOL		
 */
//------------------------------------------------------------------
BOOL PoketchIsSleepMode( const CONTACT_WORK* wk )
{
	return wk->sleep_flag;
}

//------------------------------------------------------------------
/**
 * vC[ړtO擾
 *
 * @param   wk		
 *
 * @retval  BOOL	FALSE
 */
//------------------------------------------------------------------
BOOL PoketchGetPlayerMoveTrg( const CONTACT_WORK* wk )
{
	BOOL ret = wk->player_move_flag;
	return ret;
}

FIELDSYS_WORK* PoketchGetFieldSysWork( const CONTACT_WORK* wk )
{
	return wk->fieldsys;
}

POKETCH_DATA* PoketchGetSaveData( const CONTACT_WORK* wk )
{
	return (POKETCH_DATA*)(wk->poketch_savedata);
}

SAVEDATA* PoketchGetSystemSaveData( const CONTACT_WORK* wk )
{
	return (SAVEDATA*)(wk->savedata);
}
