//============================================================================================
/**
 * @file	poketch_data.c
 * @bfief	|Pb`f[^ANZXp\[X
 * @author	taya GAME FREAK inc.
 * @date	2005.10.27
 */
//============================================================================================

#include "system/savedata_def.h"	//SAVEDATAQƂ̂

#include "common.h"
#include "gflib/system.h"
#include "system/savedata.h"

#include "field/poketch_data.h"



//============================================================================================
//============================================================================================
enum {
	APP_REGIST_MAX = 32,

	APP_DISABLE_NUMBER = POKETCH_APPID_MAX,

	POKETCH_DEFAULT_APPNO = POKETCH_APPID_DWATCH,	// ftHgœo^ĂAv
};


//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	|Pb`f[^p\̒`
 */
//----------------------------------------------------------
struct _POKETCH_DATA {
	u8		get_flag : 1;		///< |Pb`擾tO
	u8		pedometer_flag : 1;	///< Avwvx擾tO
	u8		color_type : 3;		///< J[^Cvi0`7j
	u8		 : 3;

	s8		app_count;			///< o^ĂAv
	s8		now_pos;			///< ݕ\̃Avio^e[uCfbNXj


	u8		app_id[APP_REGIST_MAX];	///< 擾AvIDo^e[u

	u32		pedometer;			///< v̕

	u16		alarm_switch : 1;		///< AvwA[vxXCb`
	u16		alarm_hour   : 5;		///< AvwA[vx
	u16		alarm_minute : 6;		///< AvwA[vx
	u16		 : 4;

};

//============================================================================================
//	Z[uf[^VXeˑ֐
//============================================================================================

//------------------------------------------------------------------
/**
 * [NTCY擾
 *
 * @retval  int		[NTCY
 */
//------------------------------------------------------------------
int PoketchData_GetWorkSize(void)
{
	return sizeof(POKETCH_DATA);
}
//------------------------------------------------------------------
/**
 * [NpAP[gĕԂ
 *
 * @param   heapID		AP[gpq[vhc
 *
 * @retval  POKETCH_DATA *		ς݃[N̈̃|C^
 */
//------------------------------------------------------------------
POKETCH_DATA * PoketchData_AllocWork(u32 heapID)
{
	POKETCH_DATA * pk;
	pk = sys_AllocMemory(heapID, sizeof(POKETCH_DATA));
	PoketchData_Init( pk );
	return pk;
}

//============================================================================================
//	POKETCH_DATÂ߂̊֐
//============================================================================================

//------------------------------------------------------------------
/**
 * [N̈揉
 *
 * @param   poketch_data		[N|C^
 *
 */
//------------------------------------------------------------------
void PoketchData_Init(POKETCH_DATA* poketch_data)
{
	enum {
		DEFAULT_APPNO = POKETCH_APPID_DWATCH,
	};

	int i;

	for(i=0; i<APP_REGIST_MAX; i++)
	{
		poketch_data->app_id[i] = POKETCH_APPID_MAX;
	}
	poketch_data->app_count = 0;
	poketch_data->now_pos = 0;
	poketch_data->get_flag = FALSE;
	poketch_data->color_type = POKETCH_COLOR_TYPE0;

	poketch_data->pedometer_flag = FALSE;
	poketch_data->pedometer = 0;

	poketch_data->alarm_switch = FALSE;
	poketch_data->alarm_hour = 0;
	poketch_data->alarm_minute = 0;

	PoketchData_AddApplication(poketch_data, DEFAULT_APPNO);
}
//------------------------------------------------------------------
/**
 * |Pb`ɓꂽtOZbg
 *
 * @param   poketch_data		[N|C^
 *
 */
//------------------------------------------------------------------
void PoketchData_SetPoketchGetFlag( POKETCH_DATA* poketch_data )
{
	poketch_data->get_flag = TRUE;
}
//------------------------------------------------------------------
/**
 * |Pb`ɓꂽtO擾
 *
 * @param   poketch_data		[N|C^
 *
 */
//------------------------------------------------------------------
BOOL PoketchData_GetPoketchGetFlag( POKETCH_DATA* poketch_data )
{
	return poketch_data->get_flag;
}
//------------------------------------------------------------------
/**
 * o^ĂAvP[V̐擾
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  int		o^ĂAvP[V̐
 */
//------------------------------------------------------------------
int PoketchData_GetApplicationCount(const POKETCH_DATA * poketch_data)
{
	return poketch_data->app_count;
}
//------------------------------------------------------------------
/**
 * ƂAvo^ł邩擾
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  int		o^ł邩
 */
//------------------------------------------------------------------
int PoketchData_GetRestApplicationSpace( POKETCH_DATA* poketch_data )
{
	return APP_REGIST_MAX - poketch_data->app_count;
}
//------------------------------------------------------------------
/**
 * łɃAvo^Ă邩`FbN
 *
 * @param   poketch_data	[N|C^
 * @param   app_id			AvP[VID
 *
 * @retval  BOOL	TRUEœo^ς
 */
//------------------------------------------------------------------
BOOL PoketchData_CheckApplicationRegisterd( POKETCH_DATA* poketch_data, int app_id )
{
	int i;
	for(i=0; i<poketch_data->app_count; i++)
	{
		if( poketch_data->app_id[i] == app_id )
		{
			return TRUE;
		}
	}
	return FALSE;
}
//------------------------------------------------------------------
/**
 * ɐVAvP[Vǉ
 *
 * @param   poketch_data		[N|C^
 * @param   app_id				AvP[VID
 *
 * @retval  BOOL		TRUEœo^^FALSEŎsiςj
 */
//------------------------------------------------------------------
BOOL PoketchData_AddApplication(POKETCH_DATA * poketch_data, int app_id)
{
	GF_ASSERT( app_id >= 0 && app_id < POKETCH_APPID_MAX );

	if( poketch_data->app_count < APP_REGIST_MAX )
	{
		if( PoketchData_CheckApplicationRegisterd(poketch_data, app_id) == FALSE )
		{
			poketch_data->app_id[ poketch_data->app_count ] = app_id;
			poketch_data->app_count++;

			if( app_id == POKETCH_APPID_PEDOMETER )
			{
				poketch_data->pedometer_flag = TRUE;
			}

			return TRUE;
		}
	}
	return FALSE;
}
//------------------------------------------------------------------
/**
 * ݕ\̃AvP[VID擾
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  int		AvP[VID
 *
 * AvP[VID = vAAAv̎ނʂID.
 */
//------------------------------------------------------------------
int PoketchData_GetNowApplication(const POKETCH_DATA* poketch_data)
{
	return poketch_data->app_id[poketch_data->now_pos];
}
//------------------------------------------------------------------
/**
 * ݕ\̃AvP[Vo^ԍ擾
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  int		AvP[Vo^ԍ
 *
 * AvP[Vo^ԍ = vC[o^ԁB
 */
//------------------------------------------------------------------
int PoketchData_GetNowApplicationPos(const POKETCH_DATA* poketch_data)
{
	return poketch_data->now_pos;
}
//------------------------------------------------------------------
/**
 * \AvPO֐؂ւ
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  int		؂ւ̃AvP[Vԍ
 */
//------------------------------------------------------------------
int PoketchData_SetApplicationPosNext( POKETCH_DATA* poketch_data )
{
	poketch_data->now_pos++;
	if( poketch_data->now_pos >= poketch_data->app_count )
	{
		poketch_data->now_pos = 0;
	}
	return poketch_data->now_pos;
}
//------------------------------------------------------------------
/**
 * \AvP֐؂ւ
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  int		؂ւ̃AvP[Vԍ
 */
//------------------------------------------------------------------
int PoketchData_SetApplicationPosPrev( POKETCH_DATA* poketch_data )
{
	poketch_data->now_pos--;
	if( poketch_data->now_pos < 0 )
	{
		poketch_data->now_pos = poketch_data->app_count - 1;
	}
	return poketch_data->now_pos;
}
//------------------------------------------------------------------
/**
 * \Avwo^ԍ̕ɐ؂ւ
 *
 * @param   poketch_data	[N|C^
 * @param   pos				o^ԍ
 *
 */
//------------------------------------------------------------------
void PoketchData_SetApplicationPos( POKETCH_DATA* poketch_data, int pos )
{
	if( pos >= 0 && pos < poketch_data->app_count )
	{
		poketch_data->now_pos = pos;
	}
	else
	{
		GF_ASSERT(0);
	}
}

//------------------------------------------------------------------
/**
 * J[^Cv擾
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  u32		J[^Cv
 */
//------------------------------------------------------------------
u32 PoketchData_GetColorType( const POKETCH_DATA* poketch_data )
{
	GF_ASSERT(poketch_data);
	return poketch_data->color_type;
}
//------------------------------------------------------------------
/**
 * J[^Cvݒ
 *
 * @param   poketch_data		[N|C^
 */
//------------------------------------------------------------------
void PoketchData_SetColorType( POKETCH_DATA* poketch_data, u32 color_type )
{
	GF_ASSERT(poketch_data);
	GF_ASSERT(color_type < POKETCH_COLOR_TYPE_MAX);
	poketch_data->color_type = color_type;
}

//------------------------------------------------------------------
/**
 * wvx̕擾
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  u32		v
 */
//------------------------------------------------------------------
u32 PoketchData_GetPedometer( const POKETCH_DATA* poketch_data )
{
	return poketch_data->pedometer;
}
//------------------------------------------------------------------
/**
 * wvx̕Zbg
 *
 * @param   poketch_data		[N|C^
 * @param   pos					Zbg
 */
//------------------------------------------------------------------
void PoketchData_SetPedometer( POKETCH_DATA* poketch_data, u32 count )
{
	if( poketch_data->pedometer_flag )
	{
		poketch_data->pedometer = count;
	}
}


//------------------------------------------------------------------
/**
 * wA[vx̃XCb`I^IttO擾
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  BOOL			
 */
//------------------------------------------------------------------
BOOL PoketchData_GetAlarmSwitchFlag( const POKETCH_DATA* poketch_data )
{
	return poketch_data->alarm_switch;
}
//------------------------------------------------------------------
/**
 * wA[vx̐ݒ莞擾
 *
 * @param   poketch_data		[N|C^
 * @param   hour				ݒ莞ij󂯎ϐ̃|C^
 * @param   min					ݒ莞ij󂯎ϐ̃|C^
 *
 */
//------------------------------------------------------------------
void PoketchData_GetAlarmTime( const POKETCH_DATA* poketch_data, u32* hour, u32* min )
{
	*hour = poketch_data->alarm_hour;
	*min = poketch_data->alarm_minute;
}
//------------------------------------------------------------------
/**
 * wA[vx̐ݒXV
 *
 * @param   poketch_data	[N|C^
 * @param   switch_flag		XCb`I^IttO
 * @param   hour			ݒ莞ij
 * @param   min				ݒ莞ij
 *
 */
//------------------------------------------------------------------
void PoketchData_SetAlarm( POKETCH_DATA* poketch_data, BOOL switch_flag, u32 hour, u32 min )
{
	poketch_data->alarm_switch = switch_flag;
	poketch_data->alarm_hour = hour;
	poketch_data->alarm_minute = min;
}







//============================================================================================
//	Z[uf[^擾̂߂̊֐
//============================================================================================
POKETCH_DATA * SaveData_GetPoketchData(SAVEDATA * sv)
{
	POKETCH_DATA * pk;
	pk = SaveData_Get(sv, GMDATA_ID_POKETCH_DATA);
	return pk;
}



//============================================================================================
//	fobOp
//============================================================================================
#ifdef PM_DEBUG
void PoketchData_AddAllApplication( POKETCH_DATA* poketch_data )
{
	int i;
	for(i=0; i<POKETCH_APPID_MAX; i++)
	{
		if(i == POKETCH_DEFAULT_APPNO)
		{
			continue;
		}
		PoketchData_AddApplication(poketch_data, i);
	}
}
#endif
