//============================================================================================
/**
 * @file	scr_tool.c
 * @bfief	XNvgŎgpvO
 * @author	Satoshi Nohara
 * @date	05.11.16
 */
//============================================================================================
#include "common.h"
#include "gflib/msg_print.h"
#include "system/lib_pack.h"
#include "system/window.h"
#include "fieldmap.h"
#include "fieldsys.h"
#include "zonedata.h"
#include "mapdefine.h"
#include "itemtool/itemsym.h"							//ITEM_KIZUGUSURI

#include "field/eventflag.h"							//EventWork_CheckEventFlag
#include "field/evwkdef.h"								//FH_FLAG_START
#include "script.h"										//ID_HIDE_ITEM_SCR_OFFSET
#include "scr_tool.h"									//HIDEITEM_ID_FLAG

#include "msgdata/msg_gameover.h"						//msg_


//============================================================================================
//
//	vg^Cv錾	
//
//============================================================================================
u16 GetNumKeta(u32 num);
u16 WazaMachineItemNoCheck( u16 itemno );

u16 GetZukanHyoukaMsgID( u16 num );


//============================================================================================
//
//	̑
//
//============================================================================================

//--------------------------------------------------------------
/**
 * nꂽľ擾
 *
 * @param   num			l
 *
 * @retval  ""
 */
//--------------------------------------------------------------
u16 GetNumKeta(u32 num)
{
	if( num / 10 == 0 )	return 1;
	else if( num / 100 == 0 ) return 2;
	else if( num / 1000 == 0 ) return 3;
	else if( num / 10000 == 0 ) return 4;
	else if( num / 100000 == 0 ) return 5;
	else if( num / 1000000 == 0 ) return 6;
	else if( num / 10000000 == 0 ) return 7;
	else if( num / 100000000 == 0 ) return 8;

	return 1;	//Ă͂܂ȂPԂ
}

//--------------------------------------------------------------
/**
 * Z}ṼACeio[`FbN
 *
 * @param   itemno		ACeio[
 *
 * @retval  TRUE		Z}V
 * @retval  FALSE		ȊO
 */
//--------------------------------------------------------------
u16 WazaMachineItemNoCheck( u16 itemno )
{
	//Z}V`FbN
	if( (itemno >= ITEM_WAZAMASIN01) && (itemno <= ITEM_HIDENMASIN08) ){
		return TRUE;
	}

	return FALSE;
}


//============================================================================================
//
//	}ӕ]
//
//============================================================================================

//--------------------------------------------------------------
/**
 * ]bZ[WID擾
 *
 * @param   num		߂܂
 *
 * @retval  "bZ[WID"
 */
//--------------------------------------------------------------
u16 GetZukanHyoukaMsgID( u16 num )
{
#if 0
	if( num <= 9 ){		return msg_odamaki_01_p03_zukan; }
	if( num <= 19 ){	return msg_odamaki_01_p04_zukan; }
	if( num <= 29 ){	return msg_odamaki_01_p05_zukan; }
	if( num <= 39 ){	return msg_odamaki_01_p06_zukan; }
	if( num <= 49 ){	return msg_odamaki_01_p07_zukan; }
	if( num <= 59 ){	return msg_odamaki_01_p08_zukan; }
	if( num <= 69 ){	return msg_odamaki_01_p09_zukan; }
	if( num <= 79 ){	return msg_odamaki_01_p10_zukan; }
	if( num <= 89 ){	return msg_odamaki_01_p11_zukan; }
	if( num <= 99 ){	return msg_odamaki_01_p12_zukan; }
	if( num <= 109 ){	return msg_odamaki_01_p13_zukan; }
	if( num <= 119 ){	return msg_odamaki_01_p14_zukan; }
	if( num <= 129 ){	return msg_odamaki_01_p15_zukan; }
	if( num <= 139 ){	return msg_odamaki_01_p16_zukan; }
	if( num <= 149 ){	return msg_odamaki_01_p17_zukan; }
	if( num <= 159 ){	return msg_odamaki_01_p18_zukan; }
	if( num <= 169 ){	return msg_odamaki_01_p19_zukan; }
	if( num <= 179 ){	return msg_odamaki_01_p21_zukan; }
	if( num <= 189 ){	return msg_odamaki_01_p22_zukan; }
	if( num <= 199 ){	return msg_odamaki_01_p23_zukan; }

	//B|P܂܂Ă邩̃`FbN
	if( num == 200 )
	{
		//|Pio[Sɂ
		if( ZukanCheck( PokeMonsNo2ZukanNoGet(MONSNO_ZIRAATI), Z_GET_CHK ) ||
				ZukanCheck( PokeMonsNo2ZukanNoGet(MONSNO_DEOKISISU), Z_GET_CHK ) )
		{
			//200CɉB|P܂܂̂ŊĂȂI
			return msg_odamaki_01_p23_zukan;
		}else
		{
			return msg_odamaki_01_p24_zukan;
		}
	}

	//B|P܂܂Ă邩̃`FbN
	if( num == 201 )
	{
		//|Pio[Sɂ
		if( ZukanCheck( PokeMonsNo2ZukanNoGet(MONSNO_ZIRAATI), Z_GET_CHK ) &&
				ZukanCheck( PokeMonsNo2ZukanNoGet(MONSNO_DEOKISISU), Z_GET_CHK ) )
		{
			//c̈CB|Pł͂Ȃ̂ŊĂȂI
			return msg_odamaki_01_p23_zukan;
		}else
		{
			return msg_odamaki_01_p24_zukan;
		}
	}

	//B|P܂ߊĂI
	if( num == 202 )	return msg_odamaki_01_p24_zukan;

	//ȊO
	return msg_odamaki_01_p03_zukan;
#else
	return 0;
#endif
}


//==============================================================================================
//
//	SŊ֘A
//
//==============================================================================================
#include "system/fontproc.h"						
#include "system/msgdata.h"							//MSGMAN_TYPE_DIRECT
#include "system/wordset.h"							//WORDSET_Create
#include "system/palanm.h"						

#include "fld_bmp.h"						
#include "field_event.h"						

#include "msgdata/msg.naix"							//NARC_msg_??_dat
#include "msgdata/msg_gameover.h"					//msg_all_dead_??

//----------------------------------------------------------------------------------------------
//	\̐錾
//----------------------------------------------------------------------------------------------
typedef struct{
	int seq;

	FIELDSYS_WORK* fsys;

	GF_BGL_INI* bgl;								//BGLf[^

	GF_BGL_BMPWIN bmpwin;							//BMPEBhEf[^

	//STRBUF* msg_buf[EV_WIN_MENU_MAX];				//bZ[Wf[^̃|C^
	MSGDATA_MANAGER* msgman;						//bZ[W}l[W[
	WORDSET* wordset;								//PZbg

	int disp_main;
	int disp_sub;

	//PALETTE_FADE_PTR pfd;							//pbgtF[h
}GAME_OVER_WORK;

#define GAME_OVER_MSG_BUF_SIZE		(1024)			//bZ[Wobt@TCY
#define GAME_OVER_FADE_SYNC			(8)				//tF[hsync

//----------------------------------------------------------------------------------------------
//	BMPEBhE
//----------------------------------------------------------------------------------------------
enum{
	GAME_OVER_BMPWIN_FRAME	= GF_BGL_FRAME3_M,
	//GAME_OVER_BMPWIN_PX1	= 1,//2,
	//GAME_OVER_BMPWIN_PY1	= 1,//2,
	//GAME_OVER_BMPWIN_SX		= 29,//25,
	//GAME_OVER_BMPWIN_SY		= 19,//18,
	GAME_OVER_BMPWIN_PX1	= 4,
	GAME_OVER_BMPWIN_PY1	= 5,
	GAME_OVER_BMPWIN_SX		= 25,
	GAME_OVER_BMPWIN_SY		= 15,
	GAME_OVER_BMPWIN_PL		= FLD_SYSFONT_PAL,
	GAME_OVER_BMPWIN_CH		= 1,
};

static const BMPWIN_DAT	GameOverWinData = {
	GAME_OVER_BMPWIN_FRAME,						//EChEgpt[
	GAME_OVER_BMPWIN_PX1,GAME_OVER_BMPWIN_PY1,	//EChË̍X,YWiLPʂŎwj
	GAME_OVER_BMPWIN_SX, GAME_OVER_BMPWIN_SY,	//EChËX,YTCYiLPʂŎwj
	GAME_OVER_BMPWIN_PL,						//EChË̃pbgio[	
	GAME_OVER_BMPWIN_CH							//EChEL̈̊JnLN^io[
};

//----------------------------------------------------------------------------------------------
//	vg^Cv錾
//----------------------------------------------------------------------------------------------
void GameOverCall( FIELDSYS_WORK* fsys, GMEVENT_CONTROL* event );
static BOOL GMEVENT_GameOver( GMEVENT_CONTROL* event );
static void scr_msg_print( GAME_OVER_WORK* wk, u16 msg_id, u8 x, u8 y );

static void SetBgHeader( GF_BGL_INI * ini );
static void BgExit( GF_BGL_INI * ini );

//--------------------------------------------------------------
/**
 * @brief	Q[I[o[ʌĂяo
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
void GameOverCall( FIELDSYS_WORK* fsys, GMEVENT_CONTROL* event )
{
	GAME_OVER_WORK* wk;

	wk = sys_AllocMemory( HEAPID_WORLD, sizeof(GAME_OVER_WORK) );
	if( wk == NULL ){
		GF_ASSERT( (0) && "mۂɎs܂I" );
	}
	memset( wk, 0, sizeof(GAME_OVER_WORK) );

	wk->seq			= 0;
	wk->fsys		= fsys;
	wk->disp_main	= GF_Disp_MainVisibleGet();		//Cʂ̕\󋵎擾
	wk->disp_sub	= GF_Disp_SubVisibleGet();		//Tuʂ̕\󋵎擾

	//bZ[Wf[^}l[W[쐬
	wk->msgman = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_gameover_dat, HEAPID_WORLD);
	wk->wordset = WORDSET_Create( HEAPID_WORLD );

	//rbg}bvǉ
	GF_BGL_BmpWinAddEx( wk->fsys->bgl, &wk->bmpwin, &GameOverWinData );

	//lZbg
	WORDSET_RegisterPlayerName(wk->wordset, 0, SaveData_GetMyStatus(GameSystem_GetSaveData(fsys)));

	//}bvǗ\BGMio[Ԃ
	if( fsys->location->zone_id == ZONE_ID_T01R0101 ){
		OS_Printf( "05 zone_id = %d\n", fsys->location->zone_id );
		scr_msg_print( wk, msg_all_dead_05, 0, 0 );
	}else{
		OS_Printf( "04 zone_id = %d\n", fsys->location->zone_id );
		scr_msg_print( wk, msg_all_dead_04, 0, 0 );
	}

	GF_BGL_BmpWinOn( &wk->bmpwin );

	FieldEvent_Call( event, GMEVENT_GameOver, wk );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	Q[I[o[ʃC
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static BOOL GMEVENT_GameOver( GMEVENT_CONTROL* event )
{
	GAME_OVER_WORK * wk = FieldEvent_GetSpecialWork( event );

	switch( wk->seq ){

	//xBGȊO\It
	case 0:
		//Cʂ̊eʂ̕\Rg[(\OFF)
		GF_Disp_GX_VisibleControl(	GX_PLANEMASK_BG0 | 
									GX_PLANEMASK_BG1 | 
									GX_PLANEMASK_BG2 |
									//GX_PLANEMASK_BG3 | 
									GX_PLANEMASK_OBJ, 
									VISIBLE_OFF );

		//Tuʂ̊eʂ̕\Rg[(\OFF)
		GF_Disp_GXS_VisibleControl(	GX_PLANEMASK_BG0 | 
									GX_PLANEMASK_BG1 | 
									GX_PLANEMASK_BG2 | 
									GX_PLANEMASK_BG3 | 
									GX_PLANEMASK_OBJ, 
									VISIBLE_OFF );


		//Cʂ̊eʂ̕\Rg[(\ON)
		GF_Disp_GX_VisibleControl(	GX_PLANEMASK_BG3, VISIBLE_ON );

		//Cʂ̂݋Pxm[}
		SetBrightness( BRIGHTNESS_NORMAL, PLANEMASK_ALL, MASK_MAIN_DISPLAY);

		wk->seq++;
		break;

	case 1:
		wk->seq++;
		break;

	//L[҂
	case 2:
		if( (sys.trg & PAD_BUTTON_A) || (sys.trg & PAD_BUTTON_B) ){
			ChangeBrightnessRequest( GAME_OVER_FADE_SYNC, BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, 
								PLANEMASK_ALL, MASK_MAIN_DISPLAY);
			wk->seq++;
		}
		break;

	//CʃubNAEg҂
	case 3:
		if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == TRUE ){

			GF_BGL_BmpWinDataFill( &wk->bmpwin, FBMP_COL_NULL );		//hԂ

			//CETuʂ̊eʂ̕\Rg[iAƂj
			GF_Disp_GX_VisibleControlDirect( wk->disp_main );
			GF_Disp_GXS_VisibleControlDirect( wk->disp_sub );
			wk->seq++;
		}
		break;

	//IJ
	case 4:
		BmpTalkWinClear( &wk->bmpwin, WINDOW_TRANS_ON );
		GF_BGL_BmpWinDel( &wk->bmpwin );

		WORDSET_Delete( wk->wordset );
		MSGMAN_Delete( wk->msgman );

		sys_FreeMemoryEz( wk );

		return TRUE;
	};

	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief	bZ[W\
 *
 * @param	wk			EV_WIN_WORK^̃AhX
 * @param	msg_id		bZ[WID
 * @param	x			\wW
 * @param	y			\xW
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void scr_msg_print( GAME_OVER_WORK* wk, u16 msg_id, u8 x, u8 y )
{
	STRBUF* tmp_buf = STRBUF_Create( GAME_OVER_MSG_BUF_SIZE, HEAPID_WORLD );
	STRBUF* tmp_buf2= STRBUF_Create( GAME_OVER_MSG_BUF_SIZE, HEAPID_WORLD );

	GF_BGL_BmpWinDataFill( &wk->bmpwin, FBMP_COL_NULL );			//hԂ

	MSGMAN_GetString( wk->msgman, msg_id, tmp_buf );

	WORDSET_ExpandStr( wk->wordset, tmp_buf2, tmp_buf );
	GF_STR_PrintColor( &wk->bmpwin, FONT_SYSTEM, tmp_buf2, x, y, MSG_NO_PUT, 
					GF_PRINTCOLOR_MAKE(FBMP_COL_WHITE,FBMP_COL_BLK_SDW,FBMP_COL_NULL), NULL );

	STRBUF_Delete( tmp_buf );
	STRBUF_Delete( tmp_buf2 );
	return;
}


