//============================================================================================
/**
 * @file	scrcmd.c
 * @bfief	XNvgR}hp֐
 * @author	Satoshi Nohara
 * @date	05.08.04
 *
 * 05.04.26 Hiroyuki Nakamura
 */
//============================================================================================
#include "common.h"

#include "system/snd_tool.h"
#include "system/pm_str.h"
#include "system\msgdata.h"			//MSGMAN_GetString
#include "system/brightness.h"		//ChangeBrightnessRequest
#include "system\wordset.h"			//WordSet_RegistPlayerName
#include "system/bmp_menu.h"
#include "system/bmp_list.h"
#include "system/get_text.h"
#include "system/window.h"
#include "system/fontproc.h"
#include "system/pms_data.h"
#include "system/wipe.h"

#include "fieldsys.h"
#include "fieldmap.h"
#include "fld_bmp.h"
#include "talk_msg.h"
#include "fieldobj.h"
#include "fld_bgm.h"
#include "field_subproc.h"
#include "field/field.h"
#include "field/poketch_data.h"

#include "field/eventflag.h"
#include "field/evwkdef.h"
#include "field/sysflag.h"
#include "field/syswork.h"
#include "vm.h"
#include "scrcmd.h"
#include "script.h"
#include "scr_tool.h"
#include "ev_win.h"
#include "guinness_win.h"

#include "msgdata\msg.naix"			//NARC_msg_??_dat

#include "application/namein.h"
#include "poketool/pokeparty.h"
#include "battle/battle_common.h"	//CN[hɕKv
#include "poketool/tr_tool.h"		//TT_TrainerMessageGet
#include "itemtool/myitem.h"		//MyItem_AddItem
#include "itemtool/item.h"			//ItemParamGet
#include "ev_mapchange.h"			//GMEVENT_Call_MapChange
#include "field_encount.h"			//DebugFieldEncount
#include "ev_poketch.h"
#include "comm_union.h"				//Union_ConnectIdSet
#include "field/union_beacon_tool.h"		// UnionView_GetTrainerType
#include "comm_union_def.h"	

#include "comm_direct_counter.h"
#include "communication/communication.h"
#include "communication/comm_def.h"
#include "communication/comm_state.h"

#include "underground/ug_manager.h"

#include "field/honey_tree_enc.h"

#include "report.h"
#include "ev_pokemon.h"				//EvPoke_Add
#include "fd_shop.h"				//ShopInit
#include "ev_trainer.h"				//EvTrainer
#include "situation_local.h"

#include "poketool/status_rcv.h"

#include "field_3d_anime_ev.h"

#include "savedata/sodateyadata.h"
#include "sodateya.h"

#include "gym.h"
#include "eventdata.h"
#include "itemtool/nuts.h"
#include "seedsys.h"
#include "application/trainer_card.h"	//TR_CARD_DATA
#include "tr_card_setup.h"				//TRCSET_MakeTrainerInfo
#include "application/pokelist.h"
#include "savedata/zukanwork.h"
#include "savedata/imageclip_data.h"	//ImageClipSave
#include "include/application/imageClip/imc_sys.h"	//ImageClipProcData
#include "include/poketool/monsno.h"	//ImageClip
#include "savedata/coin.h"				//RC֐p

#include "contest/contest.h"			//
#include "include/demo/ev_poke_select.h"

#include "include/system/pm_rtc.h"

//============================================================================================
//
//	extern錾
//
//============================================================================================
extern BOOL DebugSioEncount(FIELDSYS_WORK * fsys);
extern void EventCmd_ContestSioProc(GMEVENT_CONTROL * event);


//============================================================================================
//
//	`
//
//============================================================================================
typedef u16 (* pMultiFunc)();

//WX^řʒ`
enum {
	MINUS_RESULT = 0,	//rʂ}CiX
	EQUAL_RESULT,		//rʂCR[
	PLUS_RESULT			//rʂvX
};

//FIELDSYS_WORK*ǉ(050906)
//#define VMGetWork(core)		GetEventWorkAdrs( VMGetU16(core) )
//#define VMGetWorkValue(core)	GetEventWorkValue( VMGetU16(core) )
//#define VMGetWork(core)			GetEventWorkAdrs( FieldEvent_GetFieldSysWork( core->event_work ),\
//													VMGetU16(core) )
//#define VMGetWorkValue(core)	GetEventWorkValue( FieldEvent_GetFieldSysWork( core->event_work ),\
//													VMGetU16(core) )

#define VMGetWork(core)			GetEventWorkAdrs( core->fsys, VMGetU16(core) )
#define VMGetWorkValue(core)	GetEventWorkValue( core->fsys, VMGetU16(core) )


//============================================================================================
//
//	vg^Cv錾
//
//============================================================================================
static BOOL EvCmdNop( VM_MACHINE * core );				//
static BOOL EvCmdDummy( VM_MACHINE * core );				//
static BOOL EvCmdEnd( VM_MACHINE * core );				//
static BOOL EvCmdTimeWait( VM_MACHINE * core );			//
static BOOL EvWaitTime(VM_MACHINE * core);
static BOOL EvCmdLoadRegValue( VM_MACHINE * core );
static BOOL EvCmdLoadRegWData( VM_MACHINE * core );
static BOOL EvCmdLoadRegAdrs( VM_MACHINE * core );
static BOOL EvCmdLoadAdrsValue( VM_MACHINE * core );
static BOOL EvCmdLoadAdrsReg( VM_MACHINE * core );
static BOOL EvCmdLoadRegReg( VM_MACHINE * core );
static BOOL EvCmdLoadAdrsAdrs( VM_MACHINE * core );
static BOOL EvCmdCmpMain( u16 r1, u16 r2 );
static BOOL EvCmdCmpRegReg( VM_MACHINE * core );			//
static BOOL EvCmdCmpRegValue( VM_MACHINE * core );		//
static BOOL EvCmdCmpRegAdrs( VM_MACHINE * core );
static BOOL EvCmdCmpAdrsReg( VM_MACHINE * core );
static BOOL EvCmdCmpAdrsValue(VM_MACHINE * core);
static BOOL EvCmdCmpAdrsAdrs(VM_MACHINE * core);
static BOOL EvCmdCmpWkValue( VM_MACHINE * core );			//
static BOOL EvCmdCmpWkWk( VM_MACHINE * core );			//
static BOOL EvCmdVMMachineAdd( VM_MACHINE * core );
static BOOL EvCmdChangeCommonScr( VM_MACHINE * core );
static BOOL EvChangeCommonScrWait(VM_MACHINE * core);
static BOOL EvCmdChangeLocalScr( VM_MACHINE * core );
static BOOL EvCmdGlobalJump( VM_MACHINE * core );			//
static FIELD_OBJ_PTR FieldObjPtrGetByObjId( FIELDSYS_WORK* fsys, int obj_id );
static BOOL EvCmdObjIDJump( VM_MACHINE * core );
static BOOL EvCmdBgIDJump( VM_MACHINE * core );
static BOOL EvCmdPlayerDirJump( VM_MACHINE * core );
static BOOL EvCmdGlobalCall( VM_MACHINE * core );			//
static BOOL EvCmdRet( VM_MACHINE * core );				//
static BOOL EvCmdIfJump( VM_MACHINE * core );				//
static BOOL EvCmdIfCall(VM_MACHINE * core);
static BOOL EvCmdFlagSet( VM_MACHINE * core );			//
static BOOL EvCmdFlagReset( VM_MACHINE * core );			//
static BOOL EvCmdFlagCheck( VM_MACHINE * core );			//
static BOOL EvCmdFlagCheckWk( VM_MACHINE * core );			//
static BOOL EvCmdFlagSetWk( VM_MACHINE * core );
static BOOL EvCmdTrainerFlagSet( VM_MACHINE * core );			//
static BOOL EvCmdTrainerFlagReset( VM_MACHINE * core );			//
static BOOL EvCmdTrainerFlagCheck( VM_MACHINE * core );			//
static BOOL EvCmdWkAdd( VM_MACHINE * core );				//
static BOOL EvCmdWkSub( VM_MACHINE * core );				//
static BOOL EvCmdLoadWkValue( VM_MACHINE * core );		//
static BOOL EvCmdLoadWkWk( VM_MACHINE * core );
static BOOL EvCmdLoadWkWkValue( VM_MACHINE * core );		//
static void talk_msg_sub( VM_MACHINE * core, u8 msg_id, u8 skip );
static BOOL EvCmdTalkMsgAllPut( VM_MACHINE * core );			//
static BOOL EvCmdTalkMsg( VM_MACHINE * core );			//
static BOOL EvCmdTalkMsgSp( VM_MACHINE * core );
static BOOL EvCmdTalkMsgNoSkip( VM_MACHINE * core );
static BOOL TalkMsgWait(VM_MACHINE * core);
static BOOL EvCmdABKeyWait( VM_MACHINE * core );			//
static BOOL EvWaitABKey(VM_MACHINE * core);
static BOOL EvCmdLastKeyWait( VM_MACHINE * core );			//
static BOOL EvWaitLastKey(VM_MACHINE * core);
static BOOL EvCmdTalkWinOpen( VM_MACHINE * core );			//
static BOOL EvCmdTalkWinClose( VM_MACHINE * core );		//
static BOOL EvCmdTalkWinCloseNoClear( VM_MACHINE * core );		//
static BOOL EvCmdBoardMake( VM_MACHINE * core );
static BOOL EvCmdInfoBoardMake( VM_MACHINE * core );
static BOOL EvCmdBoardReq( VM_MACHINE * core );
static BOOL EvCmdBoardWait( VM_MACHINE * core );
static BOOL BoardReqWait( VM_MACHINE * core );
static BOOL EvCmdBoardMsg( VM_MACHINE * core );
static BOOL BoardMsgWait( VM_MACHINE * core );
static BOOL EvCmdBoardEndWait( VM_MACHINE * core );
static BOOL BoardEndWait( VM_MACHINE * core );
static BOOL EvCmdMenuReq( VM_MACHINE * core );
static BOOL EvBgScrollWait( VM_MACHINE * core );
static BOOL EvCmdBgScroll( VM_MACHINE * core );
static BOOL EvCmdYesNoWin( VM_MACHINE * core );			//
static BOOL EvYesNoSelect(VM_MACHINE * core);
static BOOL EvCmdBmpMenuInit( VM_MACHINE * core );
static BOOL EvCmdBmpMenuMakeList( VM_MACHINE * core );
static BOOL EvCmdBmpMenuStart( VM_MACHINE * core );
static BOOL EvSelWinWait(VM_MACHINE * core);
static BOOL EvCmdBmpListInit( VM_MACHINE * core );
static BOOL EvCmdBmpListMakeList( VM_MACHINE * core );
static BOOL EvCmdBmpListStart( VM_MACHINE * core );
static BOOL EvCmdBmpMenuHVStart( VM_MACHINE * core );
static BOOL EvCmdSePlay( VM_MACHINE * core );				//
static BOOL EvCmdSeWait(VM_MACHINE * core );
static BOOL EvWaitSe( VM_MACHINE * core );
static BOOL EvCmdVoicePlay( VM_MACHINE * core );
static BOOL EvCmdVoicePlayWait( VM_MACHINE * core );
static BOOL EvWaitVoicePlay(VM_MACHINE * core);
static BOOL EvCmdMePlay(VM_MACHINE * core );
static BOOL EvCmdMeWait(VM_MACHINE * core );
static BOOL EvWaitMe( VM_MACHINE * core );
static BOOL EvCmdBgmPlay(VM_MACHINE * core );
static BOOL EvCmdBgmStop(VM_MACHINE * core );
static BOOL EvCmdBgmNowMapPlay(VM_MACHINE * core );
static BOOL EvCmdBgmSpecialSet(VM_MACHINE * core );
static BOOL EvCmdBgmFadeOut( VM_MACHINE * core );
static BOOL EvWaitBgmFade( VM_MACHINE * core );
static BOOL EvCmdBgmFadeIn( VM_MACHINE * core );
static BOOL EvCmdBgmPlayerPause( VM_MACHINE * core );
static BOOL EvCmdObjAnime( VM_MACHINE * core );			//
static BOOL EvCmdObjAnimeWait( VM_MACHINE * core );			//
static BOOL EvCmdObjPauseAll( VM_MACHINE * core );		//
static BOOL EvCmdObjPauseClearAll( VM_MACHINE * core );	//	
static BOOL EvCmdObjPause( VM_MACHINE * core );
static BOOL EvCmdObjPauseClear( VM_MACHINE * core );
static BOOL EvCmdObjAdd( VM_MACHINE * core );
static BOOL EvCmdObjDel( VM_MACHINE * core );
static BOOL EvCmdVanishDummyObjAdd( VM_MACHINE * core );
static BOOL EvCmdVanishDummyObjDel( VM_MACHINE * core );
static BOOL EvCmdObjTurn( VM_MACHINE * core );			//
static BOOL EvCmdPlayerPosGet( VM_MACHINE * core );			//
static BOOL EvCmdObjPosGet( VM_MACHINE * core );			//
static BOOL EvCmdPlayerDirGet( VM_MACHINE * core );
static BOOL EvCmdNotZoneDelSet( VM_MACHINE * core );
static BOOL EvCmdMoveCodeChange( VM_MACHINE * core );
static BOOL EvCmdPairObjIdSet( VM_MACHINE * core );
static BOOL EvCmdAddGold(VM_MACHINE * core);
static BOOL EvCmdSubGold(VM_MACHINE * core);
static BOOL EvCmdCompGold(VM_MACHINE * core);
static BOOL EvCmdGoldWinWrite(VM_MACHINE * core);	
static BOOL EvCmdGoldWinDel(VM_MACHINE * core);
static BOOL EvCmdGoldWrite(VM_MACHINE * core);	
static BOOL EvCmdCoinWinWrite(VM_MACHINE * core);
static BOOL EvCmdCoinWinDel(VM_MACHINE * core);
static BOOL EvCmdCoinWrite(VM_MACHINE * core);
static BOOL EvCmdCheckCoin( VM_MACHINE * core );
static BOOL EvCmdAddCoin( VM_MACHINE * core );
static BOOL EvCmdSubCoin( VM_MACHINE * core );
static BOOL EvCmdAddItem(VM_MACHINE * core);
static BOOL EvCmdSubItem(VM_MACHINE * core);
static BOOL EvCmdAddItemChk(VM_MACHINE * core);	
static BOOL EvCmdCheckItem(VM_MACHINE * core);
static BOOL EvCmdWazaMachineItemNoCheck( VM_MACHINE * core );
static BOOL EvCmdGetPocketNo(VM_MACHINE * core);
static BOOL EvCmdAddPCBoxItem( VM_MACHINE * core );
static BOOL EvCmdCheckPCBoxItem( VM_MACHINE * core );
static BOOL EvCmdAddGoods(VM_MACHINE * core);
static BOOL EvCmdSubGoods(VM_MACHINE * core);
static BOOL EvCmdAddGoodsChk(VM_MACHINE * core);
static BOOL EvCmdCheckGoods(VM_MACHINE * core);
static BOOL EvCmdAddPokemon(VM_MACHINE * core);
static BOOL EvCmdAddTamago(VM_MACHINE * core);
static BOOL EvCmdChgPokeWaza( VM_MACHINE * core );
static BOOL EvCmdChkPokeWaza( VM_MACHINE * core );
static BOOL EvCmdGetTrainerType(VM_MACHINE * core);
static BOOL EvCmdGetTrainerName(VM_MACHINE * core);
static BOOL EvCmdConPokeList( VM_MACHINE * core );
static BOOL EvCmdConNijiCall( VM_MACHINE * core );
static BOOL EvCmdConResultScr( VM_MACHINE * core );
static BOOL EvCmdConTuusinInit( VM_MACHINE * core );
static BOOL EvCmdSetWeather( VM_MACHINE * core );
static BOOL EvCmdInitWeather( VM_MACHINE * core );
static BOOL EvCmdUpdateWeather( VM_MACHINE * core );
static BOOL EvCmdShopStart( VM_MACHINE * core );
static BOOL EvCmdGoodsShopStart( VM_MACHINE * core );
static BOOL EvCmdFlowerShopStart( VM_MACHINE * core );
static BOOL EvCmdGetMapPosition( VM_MACHINE * core );
static BOOL EvCmdGetTemotiPokeNum( VM_MACHINE * core );
static BOOL EvCmdWaitSubProcEnd( VM_MACHINE * core );
static BOOL EvCmdSetMapProc( VM_MACHINE * core );
static BOOL EvCmdWaitMapProcStart( VM_MACHINE * core );
static BOOL EvCmdImageClipSetProc( VM_MACHINE * core );
static BOOL EvCmdBoxSetProc( VM_MACHINE * core );
static BOOL EvCmdOekakiBoardSetProc( VM_MACHINE * core );
static BOOL EvCmdTrCardSetProc( VM_MACHINE * core );
static BOOL EvCmdTradeListSetProc( VM_MACHINE * core );
static BOOL EvCmdFirstPokeSelectProc( VM_MACHINE * core );
static BOOL EvCmdFirstPokeSelectSetAndDel( VM_MACHINE * core );
static BOOL EvCmdEyeTrainerMoveSet( VM_MACHINE * core );
static BOOL EvCmdEyeTrainerMoveCheck( VM_MACHINE * core );
static BOOL EvCmdEyeTrainerTypeGet( VM_MACHINE * core );
static BOOL EvCmdEyeTrainerIdGet( VM_MACHINE * core );
static BOOL EvCmdNameIn( VM_MACHINE * core );
static BOOL EvCmdNameInPoke( VM_MACHINE * core );
static BOOL EvCmdBrightnessReq( VM_MACHINE * core );
static BOOL EvCmdChangeBrightnessWait( VM_MACHINE * core );
static BOOL EvChangeBrightnessWait(VM_MACHINE * core);
static BOOL EvCmdMapChange( VM_MACHINE * core );
static BOOL EvCmdKabeNobori( VM_MACHINE * core );
static BOOL EvCmdNaminori( VM_MACHINE * core );
static BOOL EvCmdPlayerName(VM_MACHINE * core );
static BOOL EvCmdRivalName(VM_MACHINE * core ); 
static BOOL EvCmdSupportName(VM_MACHINE * core );
static BOOL EvCmdPokemonName(VM_MACHINE * core );
static BOOL EvCmdItemName(VM_MACHINE * core );
static BOOL EvCmdPocketName(VM_MACHINE * core );
static BOOL EvCmdWazaName(VM_MACHINE * core );
static BOOL EvCmdNumberName(VM_MACHINE * core );
static BOOL EvCmdNickName(VM_MACHINE * core );
static BOOL EvCmdPoketchName(VM_MACHINE * core );
static BOOL EvCmdTrTypeName(VM_MACHINE * core );
static BOOL EvCmdMyTrTypeName(VM_MACHINE * core );
static BOOL EvCmdPokemonNameExtra(VM_MACHINE * core );
static STRBUF * PokeNameGetAlloc( u16 id, u32 heap );
static BOOL EvCmdFirstPokemonName(VM_MACHINE * core );
static BOOL EvCmdRivalPokemonName(VM_MACHINE * core );
static BOOL EvCmdFirstPokeNoGet(VM_MACHINE * core );
static BOOL EvCmdTrainerIdGet( VM_MACHINE * core );
static BOOL EvCmdTrainerBattleSet( VM_MACHINE * core );
static BOOL EvCmdTrainerMessageSet( VM_MACHINE * core );
static BOOL EvCmdTrainerTalkTypeGet( VM_MACHINE * core );
static BOOL EvCmdTrainerTypeGet( VM_MACHINE * core );
static BOOL EvCmdTrainerBgmSet( VM_MACHINE * core );
static BOOL EvCmdTrainerLose( VM_MACHINE * core );
static BOOL EvCmdTrainerLoseCheck( VM_MACHINE * core );
static BOOL EvCmd2vs2BattleCheck( VM_MACHINE * core );
static BOOL EvCmdDebugBattleSet( VM_MACHINE * core );
static BOOL EvCmdDebugTrainerFlagSet( VM_MACHINE * core );
static BOOL EvCmdDebugTrainerFlagOnJump( VM_MACHINE * core );
static BOOL EvCmdConnectSelParentWin( VM_MACHINE * core );
static BOOL EvWaitConnectSelParentWin( VM_MACHINE * core );
static BOOL EvCmdConnectSelChildWin( VM_MACHINE * core );
static BOOL EvWaitConnectSelChildWin( VM_MACHINE * core );
static BOOL EvCmdConnectDebugParentWin( VM_MACHINE * core );
static BOOL EvCmdConnectDebugChildWin( VM_MACHINE * core );
static BOOL EvCmdDebugSioEncount( VM_MACHINE * core );
static BOOL EvCmdDebugSioContest( VM_MACHINE * core );
static BOOL EvCmdConSystemCreate( VM_MACHINE * core );
static BOOL EvCmdConSystemExit( VM_MACHINE * core );
static BOOL EvCmdConJudgeNameGet( VM_MACHINE * core );
static BOOL EvCmdConBreederNameGet( VM_MACHINE * core );
static BOOL EvCmdConNickNameGet( VM_MACHINE * core );
static BOOL EvCmdConSioParamInitSet( VM_MACHINE * core );
static BOOL EvWaitConSioParamInitSet(VM_MACHINE * core);
static BOOL EvCmdContestProc( VM_MACHINE * core );
static BOOL EvCmdConRankNameGet( VM_MACHINE * core );
static BOOL EvCmdConTypeNameGet( VM_MACHINE * core );
static BOOL EvCmdConVictoryBreederNameGet( VM_MACHINE * core );
static BOOL EvCmdConVictoryItemNoGet( VM_MACHINE * core );
//static BOOL EvCmdPoisonDeadCheck( VM_MACHINE * core );
//static BOOL EvCmdPoisonDeadSet( VM_MACHINE * core );
//static BOOL EvCmdAllDeadCheck( VM_MACHINE * core );
static BOOL EvCmdSpLocationSet( VM_MACHINE * core );
static BOOL EvCmdElevatorNowFloorGet( VM_MACHINE * core );
static BOOL EvCmdElevatorFloorWrite( VM_MACHINE * core );
static BOOL EvCmdGetShinouZukanSeeNum( VM_MACHINE * core );
static BOOL EvCmdGetShinouZukanGetNum( VM_MACHINE * core );
static BOOL EvCmdGetZenkokuZukanSeeNum( VM_MACHINE * core );
static BOOL EvCmdGetZenkokuZukanGetNum( VM_MACHINE * core );
static BOOL EvCmdChkZenkokuZukan( VM_MACHINE * core );
static BOOL EvCmdGetZukanHyoukaMsgID( VM_MACHINE * core );
static BOOL EvCmdWildBattleSet( VM_MACHINE * core );
static BOOL EvCmdFirstBattleSet( VM_MACHINE * core );
static BOOL EvCmdHoneyTree( VM_MACHINE * core );
static BOOL EvCmdGetHoneyTreeState( VM_MACHINE * core );
static BOOL EvCmdHoneyTreeBattleSet( VM_MACHINE * core );
static BOOL EvCmdHoneyAfterTreeBattleSet( VM_MACHINE * core );
static BOOL EvCmdOpeningSetProc( VM_MACHINE * core );
static BOOL EvCmdReportSaveCheck( VM_MACHINE * core );
static BOOL EvCmdReportSave( VM_MACHINE * core );
static BOOL EvCmdGetPoketch( VM_MACHINE * core );
static BOOL EvCmdGetPoketchFlag( VM_MACHINE * core );
static BOOL EvCmdPoketchAppAdd( VM_MACHINE * core );
static BOOL EvCmdPoketchAppCheck( VM_MACHINE * core );
static BOOL EvCmdCommTimingSyncStart( VM_MACHINE * core );
static BOOL EvWaitCommIsTimingSync( VM_MACHINE * core );
static BOOL EvCmdUnionTrainerNameRegist( VM_MACHINE * core );
static BOOL EvCmdUnionReturnSetUp( VM_MACHINE * core );
static BOOL EvCmdUnionConnectCutRestart( VM_MACHINE * core );
static BOOL EvCmdUnionGetTalkNumber( VM_MACHINE * core );
static BOOL EvCmdUnionIdSet( VM_MACHINE * core );
static BOOL EvCmdUnionConnectStart( VM_MACHINE * core );
static BOOL EvCmdUnionResultGet( VM_MACHINE * core );
static BOOL EvWaitUnionResultGet(VM_MACHINE * core);
static BOOL EvCmdUnionObjAllVanish( VM_MACHINE * core );
static BOOL EvCmdUnionScriptResultSet( VM_MACHINE * core );
static BOOL EvCmdUnionParentStartCommandSet( VM_MACHINE * core );
static BOOL EvWaitUnion_ParentStartCommandSet(VM_MACHINE * core);
static BOOL EvCmdUnionChildSelectCommandSet( VM_MACHINE * core );
static BOOL EvWaitUnion_ChildSelectCommandSet(VM_MACHINE * core);
static BOOL EvCmdUnionMapChange( VM_MACHINE * core );
static BOOL EvCmdUnionViewSetUpTrainerTypeSelect( VM_MACHINE * core );
static BOOL EvCmdUnionViewGetTrainerType( VM_MACHINE * core );
static BOOL EvCmdUnionViewMyStatusSet( VM_MACHINE * core );
static BOOL EvCmdSysFlagZukanGet( VM_MACHINE * core );
static BOOL EvCmdSysFlagZukanSet( VM_MACHINE * core );
static BOOL EvCmdSysFlagShoesGet( VM_MACHINE * core );
static BOOL EvCmdSysFlagShoesSet( VM_MACHINE * core );
static BOOL EvCmdSysFlagBadgeGet( VM_MACHINE * core );
static BOOL EvCmdSysFlagBadgeSet( VM_MACHINE * core );
static BOOL EvCmdSysFlagBagGet( VM_MACHINE * core );
static BOOL EvCmdSysFlagBagSet( VM_MACHINE * core );
static BOOL EvCmdSysFlagPairGet( VM_MACHINE * core );
static BOOL EvCmdSysFlagPairSet( VM_MACHINE * core );
static BOOL EvCmdSysFlagPairReset( VM_MACHINE * core );
static BOOL EvCmdShopCall( VM_MACHINE * core );
static BOOL EvCmdGameOverCall( VM_MACHINE * core );
static BOOL EvCmdSetWarpId( VM_MACHINE * core );
static BOOL EvCmdGetMySex( VM_MACHINE * core );
static BOOL EvCmdPcKaifuku( VM_MACHINE * core );
static BOOL EvCmdUgManShopNpcRandomPlace( VM_MACHINE * core );
static BOOL EvCmdCommDirectEnd( VM_MACHINE * core );
static BOOL EvCmdCommDirectEnterBtlRoom( VM_MACHINE * core );
static BOOL EvCmdSxyPosChange( VM_MACHINE * core );
static BOOL EvCmdObjPosChange( VM_MACHINE * core );
static BOOL EvCmdSxyMoveCodeChange( VM_MACHINE * core );
static BOOL EvCmdSxyDirChange( VM_MACHINE * core );
static BOOL EvCmdObjDirChange( VM_MACHINE * core );
static BOOL EvCmdReturnScriptWkSet( VM_MACHINE * core );
//Ή
static BOOL EvCmdProgram( VM_MACHINE * core );			//
static BOOL EvCmdFunctionCall( VM_MACHINE * core );		//
static BOOL EvCmdStopScript( VM_MACHINE * core );			//
//mF
/*

static BOOL EvCmdLoadRegWData( VM_MACHINE * core );		//
static BOOL EvCmdLoadRegValue( VM_MACHINE * core );		//
static BOOL EvCmdLoadRegReg( VM_MACHINE * core );			//

static BOOL EvObjMoveCheck(VM_MACHINE * core);
*/
static BOOL EvCmdChkTemotiPokerus( VM_MACHINE * core );

static BOOL EvCmdSetUpDoorAnime( VM_MACHINE * core );
static BOOL EvCmdWait3DAnime( VM_MACHINE * core );
static BOOL EvCmdFree3DAnime( VM_MACHINE * core );
static BOOL EvCmdOpenDoor( VM_MACHINE * core );
static BOOL EvCmdCloseDoor( VM_MACHINE * core );
static BOOL EvCmdGetSodateyaName( VM_MACHINE * core );
static BOOL EvCmdGetSodateyaZiisan( VM_MACHINE * core );
static BOOL EvCmdInitWaterGym( VM_MACHINE * core );
static BOOL EvCmdPushWaterGymButton( VM_MACHINE * core );
static BOOL EvCmdInitGhostGym( VM_MACHINE * core );
static BOOL EvCmdMoveGhostGymLift( VM_MACHINE * core );
static BOOL EvCmdInitSteelGym( VM_MACHINE * core );
static BOOL EvCmdGetPokeCount( VM_MACHINE * core );

//VKǉ2006.02`
static BOOL EvCmdBagSetProc( VM_MACHINE * core );
static BOOL EvCmdBagGetResult( VM_MACHINE * core);

static BOOL EvCmdPocketCheck(VM_MACHINE * core);
static BOOL EvCmdNutsName(VM_MACHINE * core);

static BOOL EvCmdSeedGetStatus(VM_MACHINE * core);
static BOOL EvCmdSeedGetType(VM_MACHINE * core);
static BOOL EvCmdSeedGetCompost(VM_MACHINE * core);
static BOOL EvCmdSeedGetNutsCount(VM_MACHINE * core);
static BOOL EvCmdSeedGetGroundStatus(VM_MACHINE * core);

static BOOL EvCmdSeedSetCompost(VM_MACHINE * core);
static BOOL EvCmdSeedSetNuts(VM_MACHINE * core);
static BOOL EvCmdSeedSetWater(VM_MACHINE * core);
static BOOL EvCmdSeedTakeNuts(VM_MACHINE * core);

static BOOL EvCmdTimeWaitIconAdd(VM_MACHINE * core);
static BOOL EvCmdTimeWaitIconDel(VM_MACHINE * core);

static BOOL EvCmdABKeyTimeWait( VM_MACHINE * core );
static BOOL EvWaitABKeyTime(VM_MACHINE * core);

static BOOL EvCmdPokeListSetProc(VM_MACHINE * core);
static BOOL EvCmdPokeListGetResult(VM_MACHINE * core);

static BOOL EvCmdTemotiMonsNo(VM_MACHINE * core);
static BOOL EvCmdMonsOwnChk(VM_MACHINE * core);

static BOOL EvCmdGetPokeCount2( VM_MACHINE * core );
static BOOL EvCmdGetPokeCount3( VM_MACHINE * core );
static BOOL EvCmdGetPokeCount4( VM_MACHINE * core );

static BOOL EvCmdUgShopMenuInit( VM_MACHINE * core );
static BOOL EvWaitUgShopMenuInit( VM_MACHINE * core );
static BOOL EvCmdUgShopTalkStart( VM_MACHINE * core );
static BOOL EvWaitUgShopTalkStart( VM_MACHINE * core );
static BOOL EvCmdUgShopTalkEnd( VM_MACHINE * core );
static BOOL EvCmdUgShopTalkRegisterItemName( VM_MACHINE * core );
static BOOL EvCmdUgShopTalkRegisterTrapName( VM_MACHINE * core );
static BOOL EvCmdGuinnessWin( VM_MACHINE * core );

static BOOL EvCmdSubMyGold( VM_MACHINE * core );
static BOOL EvCmdHikitoriPoke( VM_MACHINE * core );
static BOOL EvCmdHikitoriList( VM_MACHINE * core );
static BOOL EvCmdMsgSodateyaAishou( VM_MACHINE * core );
static BOOL EvCmdMsgExpandBuf( VM_MACHINE * core );
static BOOL EvCmdDelSodateyaEgg( VM_MACHINE * core );
static BOOL EvCmdGetSodateyaEgg( VM_MACHINE * core );
static BOOL EvCmdHikitoriRyoukin( VM_MACHINE * core );
static BOOL EvCmdCompMyGold( VM_MACHINE * core );
static BOOL EvCmdTamagoDemo( VM_MACHINE * core );
static BOOL EvCmdSodateyaPokeList( VM_MACHINE * core );
static BOOL EvCmdSodatePokeLevelStr( VM_MACHINE * core );
static BOOL EvCmdMsgAzukeSet( VM_MACHINE * core );
static BOOL EvCmdSetSodateyaPoke( VM_MACHINE * core );

static BOOL EvCmdObjVisible( VM_MACHINE * core );
static BOOL EvCmdObjInvisible( VM_MACHINE * core );

///[{bNXp by iwasawa
static BOOL EvCmdMailBox( VM_MACHINE * core );
static BOOL EvCmdGetMailBoxDataNum( VM_MACHINE * core );

static BOOL EvCmdGetRand( VM_MACHINE * core );
static BOOL EvCmdGetNatsuki( VM_MACHINE * core );
static BOOL EvCmdHikitoriListNameSet( VM_MACHINE * core );
static BOOL EvCmdGetSodateyaAishou( VM_MACHINE * core );
static BOOL EvCmdGetSodateyaTamagoCheck( VM_MACHINE * core );

//============================================================================================
//
//	O[oϐ
//
//============================================================================================
//pe[u
static const u8 ConditionTable[6][3] =
{
//	  MINUS  EQUAL  PLUS
	{ TRUE,	 FALSE, FALSE },	// LT
	{ FALSE, TRUE,  FALSE },	// EQ
	{ FALSE, FALSE, TRUE  },	// GT
	{ TRUE,  TRUE,  FALSE },	// LE
	{ FALSE, TRUE,  TRUE  },	// GE
	{ TRUE,  FALSE, TRUE  }		// NE
};

const pMultiFunc ScriptCallTable[] = {
	NULL,
	NULL,
	NULL,
	NULL
};

static const BMPWIN_DAT YesNoBmpDat = {
	FLD_MBGFRM_FONT, FLD_YESNO_WIN_PX, FLD_YESNO_WIN_PY,
	FLD_YESNO_WIN_SX, FLD_YESNO_WIN_SY, FLD_YESNO_WIN_PAL, FLD_YESNO_WIN_CGX
};

const VM_CMD ScriptCmdTbl[EVCMD_MAX] = {
	EvCmdNop,				
	EvCmdDummy,				
	EvCmdEnd,			
	EvCmdTimeWait,			//

	EvCmdLoadRegValue,
	EvCmdLoadRegWData,
	EvCmdLoadRegAdrs,
	EvCmdLoadAdrsValue,
	EvCmdLoadAdrsReg,
	EvCmdLoadRegReg,
	EvCmdLoadAdrsAdrs,

	EvCmdCmpRegReg,
	EvCmdCmpRegValue,
	EvCmdCmpRegAdrs,		
	EvCmdCmpAdrsReg,		
	EvCmdCmpAdrsValue,
	EvCmdCmpAdrsAdrs,
	EvCmdCmpWkValue,
	EvCmdCmpWkWk,

	EvCmdVMMachineAdd,
	EvCmdChangeCommonScr,	// 
	EvCmdChangeLocalScr,	// 

	EvCmdGlobalJump,		//
	EvCmdObjIDJump,
	EvCmdBgIDJump,
	EvCmdPlayerDirJump,

	EvCmdGlobalCall,		//
	EvCmdRet,				//

	EvCmdIfJump,			//
	EvCmdIfCall,

	EvCmdFlagSet,
	EvCmdFlagReset,
	EvCmdFlagCheck,
	EvCmdFlagCheckWk,
	EvCmdFlagSetWk,

	EvCmdTrainerFlagSet,
	EvCmdTrainerFlagReset,
	EvCmdTrainerFlagCheck,

	EvCmdWkAdd,
	EvCmdWkSub,

	EvCmdLoadWkValue,
	EvCmdLoadWkWk,
	EvCmdLoadWkWkValue,

	EvCmdTalkMsgAllPut,		//
	EvCmdTalkMsg,			//
	EvCmdTalkMsgSp,			//
	EvCmdTalkMsgNoSkip,		//
	EvCmdABKeyWait,			//
	EvCmdLastKeyWait,		//
	EvCmdTalkWinOpen,		//
	EvCmdTalkWinClose,		//
	EvCmdTalkWinCloseNoClear,//

	EvCmdBoardMake,			//Ŕ쐬i^E}bvAWA\Dj
	EvCmdInfoBoardMake,		//Ŕ쐬ifj
	EvCmdBoardReq,			//Ŕ䃊NGXg
	EvCmdBoardWait,
	EvCmdBoardMsg,			//ŔbZ[W\
	EvCmdBoardEndWait,
	EvCmdMenuReq,			//j[NGXg
	EvCmdBgScroll,

	EvCmdYesNoWin,			//
	EvCmdGuinnessWin,

	EvCmdBmpMenuInit,
	EvCmdBmpMenuMakeList,
	EvCmdBmpMenuStart,

	EvCmdBmpListInit,
	EvCmdBmpListMakeList,
	EvCmdBmpListStart,

	EvCmdBmpMenuHVStart,

	EvCmdSePlay,			//
	EvCmdSeWait,
	EvCmdVoicePlay,			//
	EvCmdVoicePlayWait,		//
	EvCmdMePlay,
	EvCmdMeWait,
	EvCmdBgmPlay,
	EvCmdBgmStop,
	EvCmdBgmNowMapPlay,
	EvCmdBgmSpecialSet,		//
	EvCmdBgmFadeOut,
	EvCmdBgmFadeIn,
	EvCmdBgmPlayerPause,

	EvCmdObjAnime,			//
	EvCmdObjAnimeWait,		//
	EvCmdObjPauseAll,		//
	EvCmdObjPauseClearAll,	//
	EvCmdObjPause,			//
	EvCmdObjPauseClear,		//
	EvCmdObjAdd,			//
	EvCmdObjDel,			//

	EvCmdVanishDummyObjAdd,	//
	EvCmdVanishDummyObjDel,	//

	EvCmdObjTurn,			//
	EvCmdPlayerPosGet,		//
	EvCmdObjPosGet,			//

	EvCmdNotZoneDelSet,		//
	EvCmdMoveCodeChange,	//
	EvCmdPairObjIdSet,	//

	EvCmdAddGold,			//֘Aׂ
	EvCmdSubGold,
	EvCmdCompGold,
	EvCmdGoldWinWrite,		//winȍ~͖Ή
	EvCmdGoldWinDel,
	EvCmdGoldWrite,			//֘A܂

	EvCmdCoinWinWrite,		//RC֘Aׂ
	EvCmdCoinWinDel,
	EvCmdCoinWrite,
	EvCmdCheckCoin,
	EvCmdAddCoin,
	EvCmdSubCoin,			//RC֘A܂

	EvCmdAddItem,			
	EvCmdSubItem,
	EvCmdAddItemChk,
	EvCmdCheckItem,
	EvCmdWazaMachineItemNoCheck,

	EvCmdGetPocketNo,		//Ή
	EvCmdAddPCBoxItem,
	EvCmdCheckPCBoxItem,	//ACe֘A܂

	EvCmdAddGoods,			//ObY֘Aׂ			Ή
	EvCmdSubGoods,
	EvCmdAddGoodsChk,
	EvCmdCheckGoods,		//ObY֘A܂

	EvCmdAddPokemon,		//|P֘Aׂ
	EvCmdAddTamago,
	EvCmdChgPokeWaza,
	EvCmdChkPokeWaza,		//|P֘A܂

	EvCmdGetTrainerType,	//g[i[֘Aׂ		Ή
	EvCmdGetTrainerName,	//g[i[֘A܂

	EvCmdConPokeList,		//ReXg֘Aׂ		Ή
	EvCmdConNijiCall,
	EvCmdConResultScr,
	EvCmdConTuusinInit,		//ReXg֘A܂

	EvCmdSetWeather,		//V֘Aׂ			Ή
	EvCmdInitWeather,
	EvCmdUpdateWeather,		//V֘A܂

	EvCmdShopStart,			//X֘Aׂ			Ή
	EvCmdGoodsShopStart,
	EvCmdFlowerShopStart,	//X֘A܂

	EvCmdGetMapPosition,	//݂̃}bvʒu擾	Ή
	EvCmdGetTemotiPokeNum,	//莝̃|P擾	Ή

	EvCmdSetMapProc,

	EvCmdImageClipSetProc,
	EvCmdBoxSetProc,
	EvCmdOekakiBoardSetProc,
	EvCmdTrCardSetProc,
	EvCmdTradeListSetProc,

	EvCmdFirstPokeSelectProc,
	EvCmdFirstPokeSelectSetAndDel,

	EvCmdEyeTrainerMoveSet,
	EvCmdEyeTrainerMoveCheck,
	EvCmdEyeTrainerTypeGet,
	EvCmdEyeTrainerIdGet,
	EvCmdNameIn,
	EvCmdNameInPoke,

	EvCmdBrightnessReq,
	EvCmdChangeBrightnessWait,

	EvCmdMapChange,
	EvCmdKabeNobori,
	EvCmdNaminori,

	EvCmdPlayerName,
	EvCmdRivalName,
	EvCmdSupportName,
	EvCmdPokemonName,
	EvCmdItemName,
	EvCmdPocketName,
	EvCmdWazaName,
	EvCmdNumberName,
	EvCmdNickName,
	EvCmdPoketchName,
	EvCmdTrTypeName,
	EvCmdMyTrTypeName,
	EvCmdPokemonNameExtra,
	EvCmdFirstPokemonName,
	EvCmdRivalPokemonName,
	EvCmdFirstPokeNoGet,

	EvCmdTrainerIdGet,
	EvCmdTrainerBattleSet,
	EvCmdTrainerMessageSet,
	EvCmdTrainerTalkTypeGet,
	EvCmdTrainerTypeGet,
	EvCmdTrainerBgmSet,
	EvCmdTrainerLose,
	EvCmdTrainerLoseCheck,
	EvCmd2vs2BattleCheck,
	EvCmdDebugBattleSet,
	EvCmdDebugTrainerFlagSet,
	EvCmdDebugTrainerFlagOnJump,

	EvCmdConnectSelParentWin,
	EvCmdConnectSelChildWin,
	EvCmdConnectDebugParentWin,
	EvCmdConnectDebugChildWin,

	EvCmdDebugSioEncount,
	EvCmdDebugSioContest,

	EvCmdConSystemCreate,
	EvCmdConSystemExit,
	EvCmdConJudgeNameGet,
	EvCmdConBreederNameGet,
	EvCmdConNickNameGet,
	EvCmdConSioParamInitSet,
	EvCmdContestProc,
	EvCmdConRankNameGet,
	EvCmdConTypeNameGet,
	EvCmdConVictoryBreederNameGet,
	EvCmdConVictoryItemNoGet,

	//EvCmdPoisonDeadCheck,
	//EvCmdPoisonDeadSet,
	//EvCmdAllDeadCheck,
	
	EvCmdChkTemotiPokerus,

	EvCmdSpLocationSet,
	EvCmdElevatorNowFloorGet,
	EvCmdElevatorFloorWrite,

	EvCmdGetShinouZukanSeeNum,
	EvCmdGetShinouZukanGetNum,
	EvCmdGetZenkokuZukanSeeNum,
	EvCmdGetZenkokuZukanGetNum,
	EvCmdChkZenkokuZukan,
	EvCmdGetZukanHyoukaMsgID,

	EvCmdWildBattleSet,
	EvCmdFirstBattleSet,

	EvCmdHoneyTree,
	EvCmdGetHoneyTreeState,
	EvCmdHoneyTreeBattleSet,
	EvCmdHoneyAfterTreeBattleSet,

	EvCmdOpeningSetProc,

	EvCmdReportSaveCheck,
	EvCmdReportSave,

	EvCmdGetPoketch,
	EvCmdGetPoketchFlag,
	EvCmdPoketchAppAdd,
	EvCmdPoketchAppCheck,

	EvCmdCommTimingSyncStart,

	EvCmdUnionTrainerNameRegist,
	EvCmdUnionReturnSetUp,
	EvCmdUnionConnectCutRestart,
	EvCmdUnionGetTalkNumber,
	EvCmdUnionIdSet,
	EvCmdUnionResultGet,
	EvCmdUnionObjAllVanish,
	EvCmdUnionScriptResultSet,
	EvCmdUnionParentStartCommandSet,
	EvCmdUnionChildSelectCommandSet,
	EvCmdUnionConnectStart,

	EvCmdShopCall,

	EvCmdGameOverCall,

	EvCmdSetWarpId,
	EvCmdGetMySex,
	EvCmdPcKaifuku,

	EvCmdUgManShopNpcRandomPlace,
	EvCmdCommDirectEnd,
	EvCmdCommDirectEnterBtlRoom,

	EvCmdUnionMapChange,
	EvCmdUnionViewSetUpTrainerTypeSelect,
	EvCmdUnionViewGetTrainerType,
	EvCmdUnionViewMyStatusSet,

	EvCmdSysFlagZukanGet,
	EvCmdSysFlagZukanSet,
	EvCmdSysFlagShoesGet,
	EvCmdSysFlagShoesSet,
	EvCmdSysFlagBadgeGet,
	EvCmdSysFlagBadgeSet,
	EvCmdSysFlagBagGet,
	EvCmdSysFlagBagSet,
	EvCmdSysFlagPairGet,
	EvCmdSysFlagPairSet,
	EvCmdSysFlagPairReset,

	EvCmdSetUpDoorAnime,
	EvCmdWait3DAnime,
	EvCmdFree3DAnime,
	EvCmdOpenDoor,
	EvCmdCloseDoor,

	EvCmdGetSodateyaName,
	EvCmdGetSodateyaZiisan,
	
	EvCmdInitWaterGym,			//W
	EvCmdPushWaterGymButton,	//W{^vbV
	EvCmdInitGhostGym,			//S[XgW
	EvCmdMoveGhostGymLift,		//S[XgWtg[u
	EvCmdInitSteelGym,			//|W

	EvCmdGetPokeCount,			//莝|P擾

	EvCmdBagSetProc,			//obOʌĂяo
	EvCmdBagGetResult,			//obOʌʎo

	EvCmdPocketCheck,			//|Pbg̒ɂǂ邩`FbN
	EvCmdNutsName,				//̂݃^O̖O

	EvCmdSeedGetStatus,			//؂̎FԎ擾
	EvCmdSeedGetType,
	EvCmdSeedGetCompost,
	EvCmdSeedGetGroundStatus,
	EvCmdSeedGetNutsCount,

	EvCmdSeedSetCompost,
	EvCmdSeedSetNuts,
	EvCmdSeedSetWater,
	EvCmdSeedTakeNuts,

	EvCmdSxyPosChange,
	EvCmdObjPosChange,
	EvCmdSxyMoveCodeChange,
	EvCmdSxyDirChange,
	EvCmdObjDirChange,

	EvCmdTimeWaitIconAdd,
	EvCmdTimeWaitIconDel,

	EvCmdReturnScriptWkSet,
	EvCmdABKeyTimeWait,

	EvCmdPokeListSetProc,
	EvCmdPokeListGetResult,

	EvCmdTemotiMonsNo,
	EvCmdMonsOwnChk,

	EvCmdGetPokeCount2,			//莝|P擾
	EvCmdGetPokeCount3,			//莝|P擾
	EvCmdGetPokeCount4,			//莝|P擾

	EvCmdUgShopMenuInit,		//n̂X@j[J
	EvCmdUgShopTalkStart,		//n̂X@bJn
	EvCmdUgShopTalkEnd,			//n̂X@bI
	EvCmdUgShopTalkRegisterItemName,	//n̂X@ACe̖OX̉bɓo^
	EvCmdUgShopTalkRegisterTrapName,	//n̂X@㩂̖OX̉bɓo^

	EvCmdSubMyGold,				//Ă֘Aꎮ
	EvCmdHikitoriPoke,
	EvCmdHikitoriList,
	EvCmdMsgSodateyaAishou,
	EvCmdMsgExpandBuf,
	EvCmdDelSodateyaEgg,
	EvCmdGetSodateyaEgg,
	EvCmdHikitoriRyoukin,
	EvCmdCompMyGold,
	EvCmdTamagoDemo,
	EvCmdSodateyaPokeList,
	EvCmdSodatePokeLevelStr,
	EvCmdMsgAzukeSet,
	EvCmdSetSodateyaPoke,

	EvCmdObjVisible,			//OBJ\As\
	EvCmdObjInvisible,

	EvCmdMailBox,				///<[{bNXĂяo
	EvCmdGetMailBoxDataNum,		///<[{bNX̃f[^擾

	EvCmdGetRand,				//_擾
	EvCmdGetNatsuki,			//Ȃx擾
	EvCmdHikitoriListNameSet,		//|PZbg

	EvCmdPlayerDirGet,

	EvCmdGetSodateyaAishou,		//2̂̑Qbg
	EvCmdGetSodateyaTamagoCheck,	//܂܂Ă邩
};

//============================================================================================
//
//	{VXe
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * mno߁iȂɂȂj
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdNop( VM_MACHINE * core )
{
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ȂifobKň|邽߂̖߁j
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdDummy( VM_MACHINE * core )
{
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * XNvg̏I
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdEnd( VM_MACHINE * core )
{
	VM_End( core );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * EFCg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTimeWait( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 num				= VMGetU16( core );
	u16 wk_id			= VMGetU16( core );
	u16* ret_wk			= GetEventWorkAdrs( fsys, wk_id );

	*ret_wk = num;

	//z}V̔ėpWX^Ƀ[NIDi[
	core->reg[0] = wk_id;
	//OS_Printf( "[NID = %d\n", wk_id );
	//OS_Printf( "[N̒g = %d\n", *ret_wk );

	VM_SetWait( core, EvWaitTime );
	return 1;
}

//return 1 = I
static BOOL EvWaitTime(VM_MACHINE * core)
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk = GetEventWorkAdrs( fsys, core->reg[0] );	//ӁI

	(*ret_wk)--;
	//OS_Printf( "[N̒g = %d\n", *ret_wk );
	if( *ret_wk == 0 ){ 
		return 1;
	}
	return 0;
}


//============================================================================================
//
//	f[^[hEXgA֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * z}V̔ėpWX^1byte̒li[
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdLoadRegValue( VM_MACHINE * core )
{
	u8	r = VMGetU8( core );
	core->reg[r] = VMGetU8( core );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * z}V̔ėpWX^4byte̒li[
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdLoadRegWData( VM_MACHINE * core )
{
	u8	r;
	u32	wdata;

	r = VMGetU8( core );
	wdata = VMGetU32( core );
	core->reg[r] = wdata;
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * z}V̔ėpWX^ɃAhXi[
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdLoadRegAdrs( VM_MACHINE * core )
{
	u8	r;
	VM_CODE * adrs;

	r = VMGetU8( core );
	adrs = (VM_CODE *)VMGetU32( core );
	core->reg[r] = *adrs;

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * AhX̒gɒl
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdLoadAdrsValue( VM_MACHINE * core )
{
	VM_CODE * adrs;
	u8	r;

	adrs = (VM_CODE *)VMGetU32( core );
	r = VMGetU8( core );
	*adrs = r;

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * AhX̒gɉz}V̔ėpWX^̒l
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdLoadAdrsReg( VM_MACHINE * core )
{
	VM_CODE * adrs;
	u8	r;

	adrs = (VM_CODE *)VMGetU32( core );
	r = VMGetU8( core) ;
	*adrs = core->reg[r];

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * z}V̔ėpWX^̒lėpWX^ɃRs[
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdLoadRegReg( VM_MACHINE * core )
{
	u8	r1, r2;

	r1 = VMGetU8( core );
	r2 = VMGetU8( core );
	core->reg[r1] = core->reg[r2];

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * AhX̒gɃAhX̒g
 *  
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdLoadAdrsAdrs( VM_MACHINE * core )
{
	VM_CODE * adr1;
	VM_CODE * adr2;

	adr1 = (VM_CODE *)VMGetU32( core );
	adr2 = (VM_CODE *)VMGetU32( core );
	*adr1 = * adr2;

	return 0;
}


//============================================================================================
//
//	r
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * Q̒lr
 *
 * @param	r1		lP
 * @param	r2		lQ
 *
 * @retval	"r1 < r2 : MISUS_RESULT"
 * @retval	"r1 = r2 : EQUAL_RESULT"
 * @retval	"r1 > r2 : PLUS_RESULT"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCmpMain( u16 r1, u16 r2 )
{
	if( r1 < r2 ){
		return MINUS_RESULT;
	}else if( r1 == r2 ){
		return EQUAL_RESULT;
	}
	return PLUS_RESULT;
}

//--------------------------------------------------------------------------------------------
/**
 * z}V̔ėpWX^r
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCmpRegReg( VM_MACHINE * core )
{
	u8	r1, r2;

	r1 = core->reg[ VMGetU8(core) ];
	r2 = core->reg[ VMGetU8(core) ];
	core->cmp_flag = EvCmdCmpMain( r1, r2 );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * z}V̔ėpWX^ƒlr
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCmpRegValue( VM_MACHINE * core )
{
	u8	r1, r2;

	r1 = core->reg[ VMGetU8(core) ];
	r2 = VMGetU8(core);
	core->cmp_flag = EvCmdCmpMain( r1, r2 );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * z}V̔ėpWX^ƃAhX̒gr
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCmpRegAdrs( VM_MACHINE * core )
{
	u8	r1, r2;

	r1 = core->reg[ VMGetU8(core) ];
	r2 = *(VM_CODE *)VMGetU32(core);
	core->cmp_flag = EvCmdCmpMain( r1, r2 );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * AhX̒gƉz}V̔ėpWX^r
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCmpAdrsReg( VM_MACHINE * core )
{
	u8	r1, r2;

	r1 = *(VM_CODE *)VMGetU32(core);
	r2 = core->reg[ VMGetU8(core) ];
	core->cmp_flag = EvCmdCmpMain(r1,r2);

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * AhX̒gƒlr
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCmpAdrsValue(VM_MACHINE * core)
{
	u8 r1,r2;

	r1 = *(VM_CODE *)VMGetU32(core);
	r2 = VMGetU8(core);
	core->cmp_flag = EvCmdCmpMain(r1,r2);

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * AhX̒gƃAhX̒gr
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCmpAdrsAdrs(VM_MACHINE * core)
{
	u8 r1,r2;

	r1 = *(VM_CODE *)VMGetU32(core);
	r2 = *(VM_CODE *)VMGetU32(core);
	core->cmp_flag = EvCmdCmpMain(r1,r2);

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * [Nƒlr
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCmpWkValue( VM_MACHINE * core )
{
	u16 * wk;
	u16	r1, r2;

	wk = VMGetWork( core );
	r1 = *wk;
	r2 = VMGetU16( core );
	core->cmp_flag = EvCmdCmpMain( r1, r2 );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * [Nƃ[Nr
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCmpWkWk( VM_MACHINE * core )
{
	u16 * wk1;
	u16 * wk2;

	wk1 = VMGetWork( core );
	wk2 = VMGetWork( core );
	core->cmp_flag = EvCmdCmpMain( *wk1, *wk2 );

	return 0;
}

//============================================================================================
//
//	z}V֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * z}Vǉ(؂ւ͂Aœ삵܂I)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdVMMachineAdd( VM_MACHINE * core )
{
	u16 id;
	FIELDSYS_WORK* fsys		= core->fsys;
	u8* vm_machine_count	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_VM_MACHINE_COUNT );
	VM_MACHINE** vm			= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_VM_SUB1 );

	id = VMGetU16(core);

	//z}Vǉ
	//*vm = VMMachineAdd(fsys, id, &ScriptCmdTbl[0], &ScriptCmdTbl[EVCMD_MAX]);
	*vm = VMMachineAdd(fsys, id);
	(*vm_machine_count)++;

	//CxgƐ؂藣TCBɂ邩H
	//*vm = VMMachineAddTCB( fsys, id, &ScriptCmdTbl[0], &ScriptCmdTbl[EVCMD_MAX] );

	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * [JXNvgEFCgԂɂāAʃXNvg𓮍삳܂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdChangeCommonScr( VM_MACHINE * core )
{
	u16 scr_id;
	FIELDSYS_WORK* fsys		= core->fsys;
	u8* common_scr_flag		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_COMMON_SCR_FLAG );
	u8* vm_machine_count	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_VM_MACHINE_COUNT );
	VM_MACHINE** vm			= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_VM_SUB1 );

	scr_id = VMGetU16(core);

	//ʃXNvgȊOɂ؂ւ\ɂȂĂI

	//ʃXNvg؂ւtOON
	*common_scr_flag = 1;

	//z}Vǉ
	//*vm = VMMachineAdd(fsys, scr_id, &ScriptCmdTbl[0], &ScriptCmdTbl[EVCMD_MAX]);
	*vm = VMMachineAdd(fsys, scr_id);
	(*vm_machine_count)++;

	VM_SetWait( core, EvChangeCommonScrWait );
	return 1;
}

//return 1 = I
static BOOL EvChangeCommonScrWait(VM_MACHINE * core)
{
	FIELDSYS_WORK* fsys = core->fsys;
	u8* common_scr_flag = GetEvScriptWorkMemberAdrs(fsys,ID_EVSCR_COMMON_SCR_FLAG);

	if( *common_scr_flag == 0 ){
		return 1;
	}

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ʃXNvgIāA[JXNvgĊJ܂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdChangeLocalScr( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u8* common_scr_flag = GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_COMMON_SCR_FLAG );

	//ʃXNvg؂ւtOOFF
	*common_scr_flag = 0;

	//VM_End( core );
	return 0;	//ӁI@̌"END"ɍs悤ɂ
}


//============================================================================================
//
//	򖽗
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * XNvgWv
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 *
 * @li	EVCMD_JUMP
 *
 *	\LF	EVCMD_JUMP	JumpOffset(s16)
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGlobalJump( VM_MACHINE * core )
{
	s32	pos;
	pos = (s32)VMGetU32(core);
	VMJump( core, (VM_CODE *)(core->PC+pos) );	//JUMP
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * b|ΏOBJIDrWv
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdObjIDJump( VM_MACHINE * core )
{
	u8 id;
	s32	pos;
	FIELD_OBJ_PTR* fldobj;
	FIELDSYS_WORK* fsys = core->fsys;

	//b|ΏOBJ
	fldobj = GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TARGET_OBJ );

	//rl
	id = VMGetU8(core);
	
	//ѐ
	pos = (s32)VMGetU32(core);

	//b|ΏOBJƁArl
	if( FieldOBJ_OBJIDGet(*fldobj) == id ){
		VMJump( core, (VM_CODE *)(core->PC+pos) );	//JUMP
	}
	
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * b|ΏBGrWv
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBgIDJump( VM_MACHINE * core )
{
	u8 id;
	s32	pos;
	//u32 *targetbg;
	u32 targetbg;

	//b|ΏBG
	targetbg = Event_GetTargetBg( core->event_work );

	//rl
	id = VMGetU8(core);
	
	//ѐ
	pos = (s32)VMGetU32(core);

	//b|ΏBGƁArl
	//if( *targetbg == id ){
	if( targetbg == id ){
		VMJump( core, (VM_CODE *)(core->PC+pos) );	//JUMP
	}
	
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * CxgN̎ľrWv
 * (݂̌ł͂Ȃ̂ŒӁI)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPlayerDirJump( VM_MACHINE * core )
{
	u8 dir;
	s32	pos;
	int* player_dir;
	FIELDSYS_WORK* fsys = core->fsys;

	player_dir = GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_PLAYER_DIR );

	//rl
	dir = VMGetU8(core);
	
	//ѐ
	pos = (s32)VMGetU32(core);

	if( *player_dir == dir ){
		VMJump( core, (VM_CODE *)(core->PC+pos) );	//JUMP
	}
	
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * XNvgR[
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 *
 * @li	EVCMD_CALL
 *
 *	\LF	EVCMD_CALL	CallOffset(s16)
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGlobalCall( VM_MACHINE * core )
{
	s32	pos = (s32)VMGetU32(core);
	VMCall( core, (VM_CODE *)(core->PC+pos) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * XNvg^[
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdRet( VM_MACHINE * core )
{
	VMRet( core );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * XNvgWv
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdIfJump( VM_MACHINE * core )
{
	u8	r;
	s32	pos;

	r   = VMGetU8(core);
	pos = (s32)VMGetU32(core);

	if( ConditionTable[r][core->cmp_flag] == TRUE ){
		VMJump( core, (VM_CODE *)(core->PC+pos) );
	}
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * XNvgR[
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdIfCall( VM_MACHINE * core )	
{
	u8	r;
	s32	pos;

	r   = VMGetU8(core);
	pos = (s32)VMGetU32(core);

	if( ConditionTable[r][core->cmp_flag] == TRUE ){
		VMCall( core, (VM_CODE *)(core->PC+pos) );
	}
	return 0;
}


//============================================================================================
//
//	CxgtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * tÕZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdFlagSet( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16	flag = VMGetU16( core );
	SetEventFlag( fsys, flag );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * tÕZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdFlagReset( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16	flag = VMGetU16( core );
	ResetEventFlag( fsys, flag );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * tÕ`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdFlagCheck( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16	flag = VMGetU16( core );
	core->cmp_flag = CheckEventFlag( fsys, flag );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * [N̒ltOio[ƂătO`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdFlagCheckWk( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16* wk				= VMGetWork( core );
	u16* ret_wk			= VMGetWork( core );

	*ret_wk = CheckEventFlag( fsys, (*wk) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * [N̒ltOio[ƂătOZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdFlagSetWk( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16* wk				= VMGetWork( core );
	SetEventFlag( fsys, (*wk) );
	return 0;
}


//============================================================================================
//
//	g[i[tO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * g[i[tÕZbg(g[i[IDn)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTrainerFlagSet( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 flag = VMGetWorkValue(core);	//g[i[IDnI@[Nio[n̂̓_I
	SetEventFlagTrainer( fsys, flag );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[tÕZbg(g[i[IDn)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTrainerFlagReset( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 flag = VMGetWorkValue(core);	//g[i[IDnI@[Nio[n̂̓_I
	ResetEventFlagTrainer( fsys, flag );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[tÕ`FbN(g[i[IDn)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTrainerFlagCheck( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 flag = VMGetWorkValue(core);	//g[i[IDnI@[Nio[n̂̓_I
	core->cmp_flag = CheckEventFlagTrainer( fsys, flag );
	return 0;
}


//============================================================================================
//
//	[N֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * [Nɒl𑫂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdWkAdd( VM_MACHINE * core )
{
	u16 * work;
	u16 num;
	work = VMGetWork( core );
	*work += VMGetWorkValue( core );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * [Nl
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdWkSub( VM_MACHINE * core )
{
	u16 * work;
	work = VMGetWork( core );
	*work -= VMGetWorkValue( core );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * [Nɒli[
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdLoadWkValue( VM_MACHINE * core )
{
	u16 * work;

	work = VMGetWork( core );
	*work = VMGetU16( core );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * [NɃ[N̒li[
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdLoadWkWk( VM_MACHINE * core )
{
	u16 * wk1;
	u16 * wk2;

	wk1 = VMGetWork( core );
	wk2 = VMGetWork( core );
	*wk1 = *wk2;
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * [Nɒl[N̒li[
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdLoadWkWkValue( VM_MACHINE * core )
{
	u16 * work;

	work = VMGetWork( core );
	*work = VMGetWorkValue( core );
	return 0;
}


//============================================================================================
//
//	bZ[WEEBhE֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * o^ꂽPgĕWJ@bZ[W\(MSG_ALLPUT)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTalkMsgAllPut( VM_MACHINE * core )
{
	STRBUF** pbuf		= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_MSGBUF );
	STRBUF** ptmp		= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_TMPBUF );
	u8* win_open_flag	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WIN_OPEN_FLAG );
	u8* msg_index		= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_MSGINDEX );
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WORDSET );
	u8 msg_id			= VMGetU8(core);	//1byte

	//rbg}bvEBhEf[^ǉĂȂ
	if( *win_open_flag == 0 ){
		FldTalkBmpAdd( core->fsys->bgl,GetEvScriptWorkMemberAdrs(core->fsys,ID_EVSCR_MSGWINDAT),
							FLD_MBGFRM_FONT);
		FldTalkWinPut( GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_MSGWINDAT ) );
		*win_open_flag = 1;	//ON
	}

	//bZ[WNA
	GF_BGL_BmpWinDataFill( GetEvScriptWorkMemberAdrs(core->fsys, ID_EVSCR_MSGWINDAT), 
							(FBMP_COL_WHITE) );

	MSGMAN_GetString( core->msgman, msg_id, *ptmp );

	//o^ꂽPgĕWJ
	WORDSET_ExpandStr( *wordset, *pbuf, *ptmp );

	//ӁI
	*msg_index = GF_STR_PrintSimple( GetEvScriptWorkMemberAdrs(core->fsys,ID_EVSCR_MSGWINDAT), 
										FONT_TALK, *pbuf, 0, 0, MSG_ALLPUT, NULL );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * o^ꂽPgĕWJ@bZ[W\
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTalkMsg( VM_MACHINE * core )
{
	u8 msg_id = VMGetU8(core);							//1byte
	talk_msg_sub( core, (u8)msg_id, 1 );
	VM_SetWait( core, TalkMsgWait );
	return 1;
}

static BOOL TalkMsgWait(VM_MACHINE * core)
{
	FIELDSYS_WORK * fsys = core->fsys;
	u8* msg_index = GetEvScriptWorkMemberAdrs(fsys,ID_EVSCR_MSGINDEX);
	return FldTalkMsgEndCheck( *msg_index );
}

//--------------------------------------------------------------------------------------------
/**
 * o^ꂽPgĕWJ@bZ[W\(FbZ[WID[Nw\)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTalkMsgSp( VM_MACHINE * core )
{
	u16 msg_id = VMGetWorkValue(core);					//2byte
	talk_msg_sub( core, (u8)msg_id, 1 );
	VM_SetWait( core, TalkMsgWait );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * o^ꂽPgĕWJ@bZ[W\(L[XLbvs)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTalkMsgNoSkip( VM_MACHINE * core )
{
	u16 msg_id = VMGetWorkValue(core);					//2byte
	talk_msg_sub( core, (u8)msg_id, 0 );
	VM_SetWait( core, TalkMsgWait );
	return 1;
}

static void talk_msg_sub( VM_MACHINE * core, u8 msg_id, u8 skip )
{
	FIELDSYS_WORK* fsys = core->fsys;
	STRBUF** pbuf		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_MSGBUF );
	STRBUF** ptmp		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TMPBUF );
	u8* win_open_flag	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WIN_OPEN_FLAG );
	u8* msg_index		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_MSGINDEX );
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );

	//rbg}bvEBhEf[^ǉĂȂ
	//if( GF_BGL_BmpWinAddCheck( GetEvScriptWorkMemberAdrs(fsys,ID_EVSCR_MSGWINDAT) ) == FALSE ){
	if( *win_open_flag == 0 ){
		FldTalkBmpAdd(fsys->bgl,GetEvScriptWorkMemberAdrs(fsys,ID_EVSCR_MSGWINDAT),FLD_MBGFRM_FONT);
		FldTalkWinPut( GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_MSGWINDAT ) );
		*win_open_flag = 1;	//ON
	}

	//bZ[WNA
	GF_BGL_BmpWinDataFill( GetEvScriptWorkMemberAdrs(fsys, ID_EVSCR_MSGWINDAT), (FBMP_COL_WHITE) );

	MSGMAN_GetString( core->msgman, msg_id, *ptmp );

	//o^ꂽPgĕWJ
	WORDSET_ExpandStr( *wordset, *pbuf, *ptmp );

	*msg_index = FldTalkMsgStart(GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_MSGWINDAT ), *pbuf,skip);

	return;
}

//--------------------------------------------------------------------------------------------
/**
 * L[EFCg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdABKeyWait( VM_MACHINE * core )
{
	VM_SetWait( core, EvWaitABKey );
	return 1;
}

//return 1 = I
static BOOL EvWaitABKey(VM_MACHINE * core)
{
	//if( sys.trg & ( PAD_BUTTON_A | PAD_BUTTON_B ) ){
	if( sys.trg & ( PAD_BUTTON_DECIDE | PAD_BUTTON_CANCEL ) ){
		return 1;
	}
	return 0;
}
//--------------------------------------------------------------------------------------------
/**
 * L[EFCg or ԑ҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdABKeyTimeWait( VM_MACHINE * core )
{
	core->reg[0] = VMGetWorkValue(core);
	VM_SetWait( core, EvWaitABKeyTime );
	return 1;
}

//L[orԑ҂
static BOOL EvWaitABKeyTime(VM_MACHINE * core)
{
	//if (sys.trg & (PAD_BUTTON_A | PAD_BUTTON_B)) {
	if (sys.trg & (PAD_BUTTON_DECIDE | PAD_BUTTON_CANCEL)) {
		return 1;
	}
	core->reg[0] --;
	if (core->reg[0] == 0) {
		return 1;
	}
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * Cxg̍Ō̃L[EFCg(core->key_statusɃL[ۑ)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdLastKeyWait( VM_MACHINE * core )
{
	VM_SetWait( core, EvWaitLastKey );
	return 1;
}

//return 1 = I
static BOOL EvWaitLastKey(VM_MACHINE * core)
{
	//ʏI
	//if( sys.trg & ( PAD_BUTTON_A | PAD_BUTTON_B ) ){
	if( sys.trg & ( PAD_BUTTON_DECIDE | PAD_BUTTON_CANCEL ) ){
		return 1;
	}

#if 1
	//cont
	if( sys.cont & PAD_KEY_UP ){
		Player_DirSet( core->fsys->player, DIR_UP );
	}else if( sys.cont & PAD_KEY_DOWN ){
		Player_DirSet( core->fsys->player, DIR_DOWN );
	}else if( sys.cont & PAD_KEY_LEFT ){
		Player_DirSet( core->fsys->player, DIR_LEFT );
	}else if( sys.cont & PAD_KEY_RIGHT ){
		Player_DirSet( core->fsys->player, DIR_RIGHT );
	//trg
	}else if( sys.trg & PAD_BUTTON_START ){
		SetEvScriptNextFunc( core->fsys );
	}else{
		return 0;
	}

	return 1;
#else
	return 0;
#endif
}

//--------------------------------------------------------------------------------------------
/**
 * bEBhEJ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTalkWinOpen( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u8* win_open_flag	= GetEvScriptWorkMemberAdrs( fsys,ID_EVSCR_WIN_OPEN_FLAG );

	FldTalkBmpAdd(fsys->bgl, GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_MSGWINDAT ),FLD_MBGFRM_FONT);
	FldTalkWinPut( GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_MSGWINDAT ) );
	*win_open_flag = 1;	//ON;
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * bEBhE
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTalkWinClose( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	GF_BGL_BMPWIN* pMsgWinDat = GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_MSGWINDAT );
	u8* win_open_flag	= GetEvScriptWorkMemberAdrs( fsys,ID_EVSCR_WIN_OPEN_FLAG );

	BmpTalkWinClear( pMsgWinDat, WINDOW_TRANS_ON );
	GF_BGL_BmpWinDel( pMsgWinDat );
	*win_open_flag = 0;	//OFF
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * bEBhE(NAȂ)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTalkWinCloseNoClear( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	GF_BGL_BMPWIN* pMsgWinDat = GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_MSGWINDAT );
	u8* win_open_flag	= GetEvScriptWorkMemberAdrs( fsys,ID_EVSCR_WIN_OPEN_FLAG );

	//BmpTalkWinClear( pMsgWinDat, WINDOW_TRANS_ON );
	GF_BGL_BmpWinDel( pMsgWinDat );
	*win_open_flag = 0;	//OFF
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * BGXN[
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 *
 * REG	0-3
 * TMP	0,1
 * gpĂ̂ŒӁI
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBgScroll( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16* reg0			= GetEvScriptWorkMemberAdrs( fsys,ID_EVSCR_WK_REG0 );
	u16* tmp0			= GetEvScriptWorkMemberAdrs( fsys,ID_EVSCR_WK_TEMP0 );
	u16* reg1			= GetEvScriptWorkMemberAdrs( fsys,ID_EVSCR_WK_REG1 );
	u16* reg2			= GetEvScriptWorkMemberAdrs( fsys,ID_EVSCR_WK_REG2 );
	u16* tmp1			= GetEvScriptWorkMemberAdrs( fsys,ID_EVSCR_WK_TEMP1 );
	u16* reg3			= GetEvScriptWorkMemberAdrs( fsys,ID_EVSCR_WK_REG3 );

	*reg0 = VMGetU8(core);	//XXN[l
	*tmp0 = VMGetU8(core);	//XJE^
	*reg1 = VMGetU8(core);	//XXN[

	*reg2 = VMGetU8(core);	//YXN[l
	*tmp1 = VMGetU8(core);	//YJE^
	*reg3 = VMGetU8(core);	//YXN[

	VM_SetWait( core, EvBgScrollWait );

	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * BGXN[I҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @retval	"0 = 쒆"
 * @retval	"1 = I"
 *
 * REG	0-3
 * TMP	0,1
 * gpĂ̂ŒӁI
 */
//--------------------------------------------------------------------------------------------
static BOOL EvBgScrollWait( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys = core->fsys;

	u16* scroll_x	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WK_REG0 );
	u16* mv_x		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WK_REG1 );
	u16* scroll_y	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WK_REG2 );
	u16* mv_y		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WK_REG3 );
	u16* count_x	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WK_TEMP0 );
	u16* count_y	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WK_TEMP1 );

	if( *count_x == 0 && *count_y == 0 ){
		return 1;	//I
	}

	if( *scroll_x != 0 ){
		if( *mv_x == 0 ){
			GF_BGL_ScrollSet( fsys->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_X_INC, *scroll_x );
		}else{
			GF_BGL_ScrollSet( fsys->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_X_DEC, *scroll_x );
		}
	}

	if( *scroll_y != 0 ){
		if( *mv_y == 0 ){
			GF_BGL_ScrollSet( fsys->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_Y_INC, *scroll_y );
		}else{
			GF_BGL_ScrollSet( fsys->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_Y_DEC, *scroll_y );
		}
	}

	if( *count_x != 0 ){ 
		(*count_x)--;
	}

	if( *count_y != 0 ){
		(*count_y)--;
	}

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * Ŕ쐬i^E}bvAWA\Dj
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBoardMake( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys;
	STRBUF** ptmp;
	STRBUF** pbuf;
	WORDSET** wordset;
	u16	map;
	u16	wk_id;
	u8	type;
	u8	msg_id;

	fsys = core->fsys;
	ptmp = GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TMPBUF );
	pbuf = GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_MSGBUF );
	wordset = GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	msg_id = VMGetU8(core);
	type = VMGetU8( core );
	map  = VMGetU16( core );
	wk_id = VMGetU16( core );

	BoardDataSet( fsys->board, type, map );
	BoardSetRequest( fsys->board, BOARD_REQ_ADD );
	BoardMain( fsys );

	MSGMAN_GetString( core->msgman, msg_id, *ptmp );
	WORDSET_ExpandStr( *wordset, *pbuf, *ptmp );

	GF_STR_PrintSimple( BoardWinGet(fsys->board), FONT_TALK, *pbuf, 0, 0, MSG_ALLPUT, NULL );

	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * Ŕ쐬ifpj
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdInfoBoardMake( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys;
	u16 map;
	u8 type;

	fsys = core->fsys;
	type = VMGetU8( core );
	map  = VMGetU16( core );

	BoardDataSet( fsys->board, type, map );
	BoardSetRequest( fsys->board, BOARD_REQ_ADD );

	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * Ŕ䃊NGXg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBoardReq( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys;
	u8 req;

	fsys = core->fsys;
	req  = VMGetU8( core );

	BoardSetRequest( fsys->board, req );

	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * ŔNGXgI҂Zbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @retval	"0 = IĂ"
 * @retval	"1 = "
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBoardWait( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys = core->fsys;

	if( BoardReqEndCheck( fsys->board ) == TRUE ){
		return 0;
	}
	VM_SetWait( core, BoardReqWait );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * ŔNGXgI҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @retval	"0 = 쒆"
 * @retval	"1 = I"
 */
//--------------------------------------------------------------------------------------------
static BOOL BoardReqWait( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys = core->fsys;

	if( BoardReqEndCheck( fsys->board ) == TRUE ){
		return 1;
	}
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ŔbZ[W\
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @retrn	1
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBoardMsg( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys		= core->fsys;
	u8* msg_index			= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_MSGINDEX );
	STRBUF** ptmp			= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TMPBUF );
	STRBUF** pbuf			= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_MSGBUF );
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8	msg_id				= VMGetU8(core);
	u16 wk_id				= VMGetU16( core );

	//GF_BGL_BmpWinDataFill( BoardWinGet( fsys->board ), FBMP_COL_WHITE );	//bZ[WNA

	MSGMAN_GetString( core->msgman, msg_id, *ptmp );

	//o^ꂽPgĕWJ
	WORDSET_ExpandStr( *wordset, *pbuf, *ptmp );

	//ŔTCBۑ
	*msg_index = FldTalkMsgStart( BoardWinGet(fsys->board), *pbuf, 1 );

	//z}V̔ėpWX^Ƀ[NIDi[
	core->reg[0] = wk_id;
	//OS_Printf( "[NID = %d\n", wk_id );

	VM_SetWait( core, BoardMsgWait );

	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * bZ[WI҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @retval	"0 = 쒆"
 * @retval	"1 = I"
 *
 * @li	ANSWK = 0 : LZ
 * @li	ANSWK = 1 : j[
 * @li	ANSWK = 2 : ʏI
 */
//--------------------------------------------------------------------------------------------
static BOOL BoardMsgWait( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u8* msg_index		= GetEvScriptWorkMemberAdrs( fsys,ID_EVSCR_MSGINDEX );
	u16* ret_wk			= GetEventWorkAdrs( fsys, core->reg[0] );	//ӁI
	u8	type			= BoardTypeGet( fsys->board );

	// LZ
	if( sys.trg & ( PAD_KEY_UP|PAD_KEY_DOWN|PAD_KEY_LEFT|PAD_KEY_RIGHT ) ){
		GF_STR_PrintForceStop( *msg_index );
		*ret_wk = 0;
		return 1;
	}

	// j[NGXg
	if( sys.trg & PAD_BUTTON_START ){
		GF_STR_PrintForceStop( *msg_index );
		*ret_wk = 1;
		return 1;
	}

	// ʏI
	if( FldTalkMsgEndCheck( *msg_index ) == 1 ){
		*ret_wk = 2;
		return 1;
	}

	return 0;
}


//--------------------------------------------------------------------------------------------
/**
 * ŔI҂Zbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @retrn	1
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBoardEndWait( VM_MACHINE * core )
{
	u16 wk_id	= VMGetU16( core );

	//z}V̔ėpWX^Ƀ[NIDi[
	core->reg[0] = wk_id;
	//OS_Printf( "[NID = %d\n", wk_id );

	VM_SetWait( core, BoardEndWait );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * ŔI҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @retval	"0 = 쒆"
 * @retval	"1 = I"
 *
 * @li	ANSWK = 0 : ʏI
 * @li	ANSWK = 1 : j[
 */
//--------------------------------------------------------------------------------------------
static BOOL BoardEndWait( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= GetEventWorkAdrs( fsys, core->reg[0] );	//ӁI

	// ʏI
//if( sys.trg & (PAD_KEY_UP|PAD_KEY_DOWN|PAD_KEY_LEFT|PAD_KEY_RIGHT|PAD_BUTTON_A|PAD_BUTTON_B) ){
	if( sys.trg & (PAD_KEY_UP|PAD_KEY_DOWN|PAD_KEY_LEFT|PAD_KEY_RIGHT|PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL) ){
		*ret_wk = 0;
		return 1;
	}

	// j[NGXg
	if( sys.trg & PAD_BUTTON_START ){
		*ret_wk = 1;
		return 1;
	}

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * j[NGXg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	0
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdMenuReq( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	SetEvScriptNextFunc( fsys );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * u͂Ev
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdYesNoWin( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	BMPMENU_WORK** mw	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_MENUWORK );
	u16 wk_id			= VMGetU16( core );

	MenuWinGraphicSet(
		fsys->bgl, FLD_MBGFRM_FONT, MENU_WIN_CGX_NUM, MENU_WIN_PAL, 0, HEAPID_FIELD );

	*mw = BmpYesNoSelectInit(
			fsys->bgl, &YesNoBmpDat, MENU_WIN_CGX_NUM, MENU_WIN_PAL, HEAPID_FIELD );

	//z}V̔ėpWX^Ƀ[NIDi[
	core->reg[0] = wk_id;
	//OS_Printf( "[NID = %d\n", wk_id );

	VM_SetWait( core, EvYesNoSelect );

	return 1;
}

static BOOL EvYesNoSelect(VM_MACHINE * core)
{
	u32	ret;
	FIELDSYS_WORK* fsys = core->fsys;
	BMPMENU_WORK** mw	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_MENUWORK );
	u16* ret_wk			= GetEventWorkAdrs( fsys, core->reg[0] );	//ӁI
	
	ret  = BmpYesNoSelectMain( *mw, HEAPID_FIELD );

	if( ret == BMPMENU_NULL ){ return 0; }

	if( ret == 0 ){
		*ret_wk = 0;
	}else{
		*ret_wk = 1;
	}
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	ҋ@ACR\
 * @param	core		z}V\̂ւ̃|C^
 * @return	0
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTimeWaitIconAdd(VM_MACHINE * core)
{
	void **buf;
	GF_BGL_BMPWIN* pMsgWinDat = GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_MSGWINDAT );
	buf = GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WAITICON);
	*buf = TimeWaitIconAdd(pMsgWinDat, TALK_WIN_CGX_NUM);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	ҋ@ACR
 * @param	core		z}V\̂ւ̃|C^
 * @return	0
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTimeWaitIconDel(VM_MACHINE * core)
{
	void **buf;
	buf = GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WAITICON);
	TimeWaitIconDel(*buf);
	return 0;
}


//============================================================================================
//
//	BMPj[֘A
//
//	"BMPXg"֐Ɠ֐gĂ̂ŒӁI
//	EXgI҂֐
//
//============================================================================================

//--------------------------------------------------------------
/**
 * @brief	BMPj[	
 *
 * @param	none
 *
 * @return	1
 */
//--------------------------------------------------------------
static BOOL EvCmdBmpMenuInit( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys	= core->fsys;
	EV_WIN_WORK** ev_win= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_EVWIN );
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8 x				= VMGetU8(core);
	u8 y				= VMGetU8(core);
	u8 cursor			= VMGetU8(core);
	u8 cancel			= VMGetU8(core);
	u16 wk_id			= VMGetU16( core );
	
	//
	*ev_win	= CmdEvBmpMenu_Init(fsys, x, y, cursor, cancel, 
								GetEventWorkAdrs(fsys,wk_id), *wordset, 
								GetEvScriptWorkMemberAdrs(core->fsys,ID_EVSCR_MSGWINDAT) );

	//z}V̔ėpWX^Ƀ[NIDi[
	core->reg[0] = wk_id;
	//OS_Printf( "[NID = %d\n", wk_id );

	return 1;
}

//--------------------------------------------------------------
/**
 * @brief	BMPj[	Xg쐬
 *
 * @param	none
 *
 * @retval	0
 */
//--------------------------------------------------------------
static BOOL EvCmdBmpMenuMakeList( VM_MACHINE * core )
{
	u8 msg_id, param;
	FIELDSYS_WORK* fsys	= core->fsys;
	EV_WIN_WORK** ev_win= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_EVWIN );	//EV_WIN_WORK擾

	msg_id	= VMGetU8(core);
	param	= VMGetU8(core);

	CmdEvBmpMenu_MakeList( *ev_win, msg_id, param );
	return 0;
}

//--------------------------------------------------------------
/**
 * @brief	BMPj[	Jn
 *
 * @param	none
 *
 * @retval	1
 */
//--------------------------------------------------------------
static BOOL EvCmdBmpMenuStart( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys	= core->fsys;
	EV_WIN_WORK** ev_win= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_EVWIN );	//EV_WIN_WORK擾

	CmdEvBmpMenu_Start( *ev_win );
	
	VM_SetWait( core, EvSelWinWait );
	return 1;
}

//EFCg֐
static BOOL EvSelWinWait(VM_MACHINE * core)
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk = GetEventWorkAdrs( fsys, core->reg[0] );	//ӁI

	if( *ret_wk == EV_WIN_NOTHING ){
		return FALSE;	//p
	}

	return TRUE;		//I
}


//============================================================================================
//
//	BMPXg֘A
//
//	"BMPj["֐Ɠ֐gĂ̂ŒӁI
//	EXgI҂֐
//
//============================================================================================

//--------------------------------------------------------------
/**
 * @brief	BMPXg	
 *
 * @param	none
 *
 * @retval	1
 */
//--------------------------------------------------------------
static BOOL EvCmdBmpListInit( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys	= core->fsys;
	EV_WIN_WORK** ev_win= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_EVWIN );
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8 x				= VMGetU8(core);
	u8 y				= VMGetU8(core);
	u8 cursor			= VMGetU8(core);
	u8 cancel			= VMGetU8(core);
	u16 wk_id			= VMGetU16( core );

	//
//*ev_win	= CmdEvBmpList_Init(fsys, x, y, cursor,cancel, GetEventWorkAdrs(fsys,wk_id), *wordset);
	*ev_win	= CmdEvBmpList_Init( fsys, x, y, cursor, cancel, 
									GetEventWorkAdrs(fsys,wk_id), *wordset, 
									GetEvScriptWorkMemberAdrs(core->fsys,ID_EVSCR_MSGWINDAT) );

	//z}V̔ėpWX^Ƀ[NIDi[
	core->reg[0] = wk_id;
	//OS_Printf( "[NID = %d\n", wk_id );

	return 1;
}

//--------------------------------------------------------------
/**
 * @brief	BMPXg	Xg쐬
 *
 * @param	none
 *
 * @retval	0
 */
//--------------------------------------------------------------
static BOOL EvCmdBmpListMakeList( VM_MACHINE * core )
{
	EV_WIN_WORK** ev_win= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_EVWIN );
	u8 msg_id			= VMGetU8(core);
	u8 talk_msg_id		= VMGetU8(core);
	u8 param			= VMGetU8(core);

	CmdEvBmpList_MakeList( *ev_win, msg_id, talk_msg_id, param );
	return 0;
}

//--------------------------------------------------------------
/**
 * @brief	BMPXg	Jn
 *
 * @param	none
 *
 * @retval	1
 */
//--------------------------------------------------------------
static BOOL EvCmdBmpListStart( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys	= core->fsys;
	EV_WIN_WORK** ev_win= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_EVWIN );	//EV_WIN_WORK擾

	CmdEvBmpList_Start( *ev_win );
	
	VM_SetWait( core, EvSelWinWait );
	return 1;
}


//============================================================================================
//
//	BMPj[c֘A
//
//	"BMPXg"֐Ɠ֐gĂ̂ŒӁI
//	EXgI҂֐
//
//============================================================================================

//--------------------------------------------------------------
/**
 * @brief	BMPj[c	Jn
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static BOOL EvCmdBmpMenuHVStart( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys	= core->fsys;
	EV_WIN_WORK** ev_win= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_EVWIN );	//EV_WIN_WORK擾
	u8 x_max			= VMGetU8(core);

	CmdEvBmpMenuHV_Start( *ev_win, x_max );
	
	VM_SetWait( core, EvSelWinWait );
	return 1;
}


//============================================================================================
//	yErd֘A
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * rd炷
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSePlay( VM_MACHINE * core )
{
	Snd_SePlay( VMGetWorkValue(core) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * SEI҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSeWait(VM_MACHINE * core)
{
	VM_SetWait( core, EvWaitSe );
	return 1;
}

//return 1 = I
static BOOL EvWaitSe(VM_MACHINE * core)
{
	if( Snd_SePlayCheckAll() == 0 ){
		return TRUE;
	}

	return FALSE;
};


//--------------------------------------------------------------------------------------------
/**
 * 炷
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdVoicePlay( VM_MACHINE * core )
{
	u16 no, ptn;
	no	= VMGetWorkValue(core);
	ptn = VMGetWorkValue(core);

	//p^[wł֐ɒu\
	Snd_PMVoicePlay( no );
	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * I҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdVoicePlayWait( VM_MACHINE * core )
{
	VM_SetWait( core, EvWaitVoicePlay );
	return 1;
}

//return 1 = I
static BOOL EvWaitVoicePlay(VM_MACHINE * core)
{
	if( Snd_PMVoicePlayCheck() == 0 ){
		return 1;
	}
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * MEĐ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdMePlay(VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	Snd_MePlay( VMGetU16(core) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * MEI҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdMeWait(VM_MACHINE * core )
{
	VM_SetWait( core, EvWaitMe );
	return 1;
}

//return 1 = I
static BOOL EvWaitMe( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;

	//I҂̂
	//if( Snd_MePlayCheck() == 0 ){
	
	//I҂{EFCg[N҂
	if( Snd_MePlayCheckBgmPlay() == 0 ){ 
		return TRUE;
	}

	return FALSE;
};

//--------------------------------------------------------------------------------------------
/**
 * BGMύX
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBgmPlay( VM_MACHINE * core )
{
	u16 music = VMGetU16(core);
	Snd_BgmPlay( music );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * BGM~
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBgmStop( VM_MACHINE * core )
{
	u16 music = VMGetU16(core);	//"gp"
	//Snd_BgmStop( music, 0 );
	Snd_BgmStop( Snd_NowBgmNoGet(), 0 );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ݂̃}bvBGMĐ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBgmNowMapPlay( VM_MACHINE * core )
{
	int zone_id = core->fsys->location->zone_id;
	u16 music	= Snd_PcBgmNoGet( core->fsys, Snd_FieldBgmNoGet(core->fsys,zone_id) );
	Snd_BgmPlay( music );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * }bvBGMw肪Zbg
 * ]BGM̐ȂǂɎgp
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBgmSpecialSet( VM_MACHINE * core )
{
	Snd_FieldBgmSetSpecial( core->fsys, VMGetU16(core) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * BGMtF[hAEg҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBgmFadeOut( VM_MACHINE * core )
{
	u16 frame = VMGetU16(core);
	Snd_BgmFadeOut( BGM_VOL_MIN, frame );
	VM_SetWait( core, EvWaitBgmFade );
	return 1;
}

//return 1 = I
static BOOL EvWaitBgmFade( VM_MACHINE * core )
{
	if( Snd_FadeCheck() == 0 ){
		return TRUE;
	}
	return FALSE;
};

//--------------------------------------------------------------------------------------------
/**
 * BGMtF[hC҂(tF[hAEĝĊJ)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBgmFadeIn( VM_MACHINE * core )
{
	u16 frame = VMGetU16(core);
	Snd_BgmFadeIn( BGM_VOL_MAX, frame, BGM_FADEIN_START_VOL_MIN );
	VM_SetWait( core, EvWaitBgmFade );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * V[PXꎞ~܂͍ĊJ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBgmPlayerPause( VM_MACHINE * core )
{
	u8 player = VMGetU8(core);
	BOOL flag = VMGetU8(core);

	Snd_PlayerPause( player, flag );
	return 0;
}


//============================================================================================
//
//	OBJAj[V֘A
//
//============================================================================================
static BOOL EvObjAnimeWait(VM_MACHINE * core);
static void EvAnmSetTCB( FIELDSYS_WORK* fsys, TCB_PTR anm_tcb );
static void EvAnmMainTCB( TCB_PTR tcb, void* wk );

//Aj[VIĎ[N
typedef struct{
	TCB_PTR	tcb;					//TCB
	TCB_PTR	anm_tcb;				//Aj[VTCB
	FIELDSYS_WORK* fsys;			//
}EV_ANM_WORK;

//--------------------------------------------------------------------------------------------
/**
 * Aj[V
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdObjAnime( VM_MACHINE * core )
{
	VM_CODE* p;
	TCB_PTR anm_tcb;
	u8* num;
	FIELD_OBJ_PTR* dummy;
	FIELD_OBJ_PTR fldobj;		//Ώۂ̃tB[hOBJ̃|C^
	u16 obj_id	= VMGetWorkValue(core);
	u32 pos		= (s32)VMGetU32(core);

#if 0
	//AOBJIDnꂽ
	if( obj_id == SCR_OBJID_MV_PAIR ){
		fldobj = FieldOBJSys_OBJIDMoveCodeSearch( core->fsys->fldobjsys, obj_id, MV_PAIR );

	//_~[OBJIDnꂽ
	}else if( obj_id == SCR_OBJID_DUMMY ){
		dummy = GetEvScriptWorkMemberAdrs( core->fsys,ID_EVSCR_DUMMY_OBJ );
		fldobj = *dummy;

	//Ώۂ̃tB[hOBJ̃|C^擾
	}else{
		fldobj	= FieldOBJSys_OBJIDSearch( core->fsys->fldobjsys, obj_id );
	}
#else
	fldobj = FieldObjPtrGetByObjId( core->fsys, obj_id );
#endif

	//G[`FbN
	if( fldobj == NULL ){
		GF_ASSERT( (0) && "Ώۂ̃tB[hOBJ̃|C^擾sI" );
	}

	//Aj[VR}hXgZbg
	p = (VM_CODE*)(core->PC+pos);
	anm_tcb = FieldOBJ_AcmdListSet( fldobj, (FIELD_OBJ_ACMD_LIST*)p );

	//Aj[V̐𑫂
	num = GetEvScriptWorkMemberAdrs( core->fsys,ID_EVSCR_ANMCOUNT );
	(*num)++;

	//TCBZbg
	EvAnmSetTCB( core->fsys, anm_tcb );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * FIELD_OBJ_PTR擾
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	obj_id	OBJID
 *
 * @return	"FIELD_OBJ_PTR"
 */
//--------------------------------------------------------------------------------------------
static FIELD_OBJ_PTR FieldObjPtrGetByObjId( FIELDSYS_WORK* fsys, int obj_id )
{
	FIELD_OBJ_PTR* dummy;
	FIELD_OBJ_PTR fldobj;		//Ώۂ̃tB[hOBJ̃|C^

	//AOBJIDnꂽ
	if( obj_id == SCR_OBJID_MV_PAIR ){
		fldobj = FieldOBJSys_MoveCodeSearch( fsys->fldobjsys, MV_PAIR );

	//_~[OBJIDnꂽ
	}else if( obj_id == SCR_OBJID_DUMMY ){
		dummy = GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_DUMMY_OBJ );
		fldobj = *dummy;

	//Ώۂ̃tB[hOBJ̃|C^擾
	}else{
		fldobj	= FieldOBJSys_OBJIDSearch( fsys->fldobjsys, obj_id );
	}

	return fldobj;
}

//--------------------------------------------------------------------------------------------
/**
 * Aj[VI҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdObjAnimeWait( VM_MACHINE * core )
{
	VM_SetWait( core, EvObjAnimeWait );
	return 1;
}

//return 1 = I
static BOOL EvObjAnimeWait(VM_MACHINE * core)
{
	FIELDSYS_WORK* fsys = core->fsys;
	u8* anm_count = GetEvScriptWorkMemberAdrs(fsys,ID_EVSCR_ANMCOUNT);

	//Aj[V`FbN
	if( *anm_count == 0 ){
		return 1;
	}

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	AjIĎTCB Zbg
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	anm_tcb	TCB_PTR^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void EvAnmSetTCB( FIELDSYS_WORK* fsys, TCB_PTR anm_tcb )
{
	EV_ANM_WORK* wk = NULL;
	wk = sys_AllocMemory(HEAPID_FIELD, sizeof(EV_ANM_WORK));

	if( wk == NULL ){
		GF_ASSERT( (0) && "scrcmd.c mێsI" );
		return;
	}

	wk->fsys	= fsys;
	wk->anm_tcb	= anm_tcb;
	wk->tcb		= TCB_Add( EvAnmMainTCB, wk, 0 );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	AjIĎTCB C
 *
 * @param	tcb		TCB_PTR
 * @param	wk		[ÑAhX
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void EvAnmMainTCB( TCB_PTR tcb, void* wk )
{
	EV_ANM_WORK *swk;
	u8* num;

	swk = (EV_ANM_WORK *)wk;
	num = GetEvScriptWorkMemberAdrs( swk->fsys, ID_EVSCR_ANMCOUNT );

	if( FieldOBJ_AcmdListEndCheck( swk->anm_tcb ) == TRUE ){	//I`FbN

		FieldOBJ_AcmdListEnd( swk->anm_tcb );

		TCB_Delete( swk->tcb );
		sys_FreeMemory( HEAPID_FIELD, wk );

		//Aj[V̊Ǘ
		if( *num == 0 ){
			GF_ASSERT( (0) && "Aj[V̊ǗsłI" );
			return;
		}

		(*num)--;
	}

	return;
}

//--------------------------------------------------------------------------------------------
/**
 * SOBJ~
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	0
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdObjPauseAll( VM_MACHINE * core )
{
	FIELD_OBJ_SYS_PTR fldobjsys;
	FIELDSYS_WORK* fsys = core->fsys;
	
	fldobjsys = fsys->fldobjsys;
	
	FieldOBJSys_MovePauseAll( fldobjsys );
	
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * SOBJĊJ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdObjPauseClearAll( VM_MACHINE * core )
{
	FIELD_OBJ_SYS_PTR fldobjsys;
	FIELDSYS_WORK* fsys = core->fsys;
	
	fldobjsys = fsys->fldobjsys;
	
	FieldOBJSys_MovePauseAllClear( fldobjsys );
	
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * OBJ~(X)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	0
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdObjPause( VM_MACHINE * core )
{
	FIELD_OBJ_PTR fldobj;		//Ώۂ̃tB[hOBJ̃|C^
	FIELDSYS_WORK* fsys = core->fsys;
	
	//Ώۂ̃tB[hOBJ̃|C^擾
	fldobj = FieldOBJSys_OBJIDSearch( fsys->fldobjsys, VMGetU16(core) );

	//|[Y ON
	FieldOBJ_MovePause( fldobj );
	
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * OBJĊJ(X)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	0
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdObjPauseClear( VM_MACHINE * core )
{
	FIELD_OBJ_PTR fldobj;		//Ώۂ̃tB[hOBJ̃|C^
	FIELDSYS_WORK* fsys = core->fsys;
	
	//Ώۂ̃tB[hOBJ̃|C^擾
	fldobj = FieldOBJSys_OBJIDSearch( fsys->fldobjsys, VMGetU16(core) );
	FieldOBJ_MovePauseClear( fldobj );
	
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * OBJo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdObjAdd( VM_MACHINE * core )
{
	FIELD_OBJ_PTR ret;
	FIELDSYS_WORK* fsys = core->fsys;
	u16 id				= VMGetWorkValue(core);
	
	//OS_Printf( "count = %d\n", EventData_GetNpcCount(fsys) );
	//OS_Printf( "id = %d\n", id );
	ret= FieldOBJ_AddHEvent( fsys->fldobjsys, id, EventData_GetNpcCount(fsys),
								fsys->location->zone_id, EventData_GetNpcData(fsys) );

	if( ret == NULL ){
		GF_ASSERT( (0) && "w肵IDɊYf[^܂łI" );
	}

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * OBJ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdObjDel( VM_MACHINE * core )
{
	FIELD_OBJ_PTR fldobj;		//Ώۂ̃tB[hOBJ̃|C^
	FIELDSYS_WORK* fsys = core->fsys;
	
	//Ώۂ̃tB[hOBJ̃|C^擾
	fldobj	= FieldOBJSys_OBJIDSearch( fsys->fldobjsys, VMGetWorkValue(core) );

	FieldOBJ_DeleteEvent( fldobj );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * _~[OBJǉ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdVanishDummyObjAdd( VM_MACHINE * core )
{
	u16 x	= VMGetU16( core );
	u16 z	= VMGetU16( core );
	FIELD_OBJ_PTR* fldobj = GetEvScriptWorkMemberAdrs(core->fsys,ID_EVSCR_DUMMY_OBJ);//_~[OBJ

#if 0
	//ėpIɎg
	u16 dir = VMGetWorkValue( core );
	u16 obj = VMGetWorkValue( core );	//OBJR[h(HERO)
	u16 move= VMGetWorkValue( core );	//R[h
	u16 zone= VMGetU16( core );			//][ID
	*fldobj = FieldOBJ_AddHMake( core->fsys->fldobjsys, x, z, dir, obj, move, zone_id );
#endif
	
	//_~[OBJpŒ
	*fldobj = FieldOBJ_AddHMake( core->fsys->fldobjsys, x, z, DIR_UP, NONDRAW, 
								MV_DMY, core->fsys->location->zone_id );

	FieldOBJ_VecPosNowHeightGetSet( *fldobj );			//f
	FieldOBJ_StatusBitSet_Vanish( *fldobj, TRUE );		//\
	FieldOBJ_StatusBitSet_FellowHit( *fldobj, FALSE );	//qbgȂ
	//FieldOBJ_NotZoneDeleteSet( *fldobj, TRUE );		//][؂ւ̍폜֎~

#if 1
	//Jݒ؂ւ(_~[)
	{
		const VecFx32* inTarget;

		inTarget = FieldOBJ_VecPosPtrGet( *fldobj );
		DivMapBindTarget( inTarget, core->fsys->map_cont_dat );	//n`oCh
		GFC_BindCameraTarget( inTarget, core->fsys->camera_ptr );
	}
#endif

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * _~[OBJ폜
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdVanishDummyObjDel( VM_MACHINE * core )
{
	FIELD_OBJ_PTR* fldobj = GetEvScriptWorkMemberAdrs(core->fsys,ID_EVSCR_DUMMY_OBJ);	//_~[OBJ
	FieldOBJ_Delete( *fldobj );

#if 1
	//Jݒ؂ւ(l)
	{
		FIELD_OBJ_PTR fldobj_player;
		const VecFx32* inTarget;

		fldobj_player = FieldOBJSys_OBJIDSearch( core->fsys->fldobjsys, FLDOBJ_ID_PLAYER );
		inTarget = FieldOBJ_VecPosPtrGet( fldobj_player );
		DivMapBindTarget( inTarget, core->fsys->map_cont_dat );	//n`oCh
		GFC_BindCameraTarget( inTarget, core->fsys->camera_ptr );
	}
#endif

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * bOBJ@ւ̐U
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdObjTurn( VM_MACHINE * core )
{
	int dir;
	FIELD_OBJ_PTR* fldobj;
	FIELDSYS_WORK* fsys = core->fsys;
	
	{
		FIELDSYS_WORK *fsys;
		PLAYER_STATE_PTR player;
		
		fsys = core->fsys;
		player = fsys->player;
	
		dir = Player_DirGet( player );
	}
	
	dir = FieldOBJTool_DirFlip( dir );
	
	fldobj = GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TARGET_OBJ );
	if( *fldobj == NULL ){
		return 0;
	}

	FieldOBJ_DirDispCheckSet( *fldobj, dir );
	
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * l̈ʒu擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPlayerPosGet( VM_MACHINE * core )
{
	u16 *x, *z;
	FIELDSYS_WORK* fsys = core->fsys;
	
	x = VMGetWork( core );
	z = VMGetWork( core );

	//int x,z;
	//x = Player_NowGPosXGet( fsys->player );
	//z = Player_NowGPosZGet( fsys->player );

	*x = Player_NowGPosXGet( fsys->player );
	*z = Player_NowGPosZGet( fsys->player );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * OBJ̈ʒu擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdObjPosGet( VM_MACHINE * core )
{
	FIELD_OBJ_PTR fldobj;
	u16 *x, *z;
	FIELDSYS_WORK* fsys = core->fsys;

	fldobj = FieldOBJSys_OBJIDSearch( fsys->fldobjsys, VMGetWorkValue(core) );

	x = VMGetWork( core );
	z = VMGetWork( core );

	*x = FieldOBJ_NowPosGX_Get( fldobj );
	*z = FieldOBJ_NowPosGZ_Get( fldobj );
	OS_Printf( "x = %d\n", *x );
	OS_Printf( "z = %d\n", *z );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * vC[̕擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPlayerDirGet( VM_MACHINE * core )
{
	u16 *dir;
	
	dir = VMGetWork( core );
	*dir = Player_DirGet(core->fsys->player);

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ][؂ւ̍폜֎~(TRUE=֎~AFALSE=֎~Ȃ)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdNotZoneDelSet( VM_MACHINE * core )
{
	FIELD_OBJ_PTR fldobj;
	u8 flag;

	fldobj	= FieldOBJSys_OBJIDSearch( core->fsys->fldobjsys, VMGetWorkValue(core) );
	flag	= VMGetU8( core );

	FieldOBJ_NotZoneDeleteSet( fldobj, flag );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * R[hύX
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdMoveCodeChange( VM_MACHINE * core )
{
	FIELD_OBJ_PTR fldobj;
	u16 code;

	fldobj	= FieldOBJSys_OBJIDSearch( core->fsys->fldobjsys, VMGetWorkValue(core) );
	code	= VMGetU16( core );

	FieldOBJ_MoveCodeChange( fldobj, code );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * AOBJIDZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPairObjIdSet( VM_MACHINE * core )
{
	FIELD_OBJ_PTR fldobj;
	fldobj = FieldOBJSys_MoveCodeSearch( core->fsys->fldobjsys, MV_PAIR );
	FieldOBJ_OBJIDSet( fldobj, FLDOBJ_ID_PAIR );
	return 0;
}


//============================================================================================
//
//	֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * 
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdAddGold(VM_MACHINE * core)
{
	MYSTATUS* my	= SaveData_GetMyStatus( GameSystem_GetSaveData(core->fsys) );
	u32 gold;
	
	gold = VMGetU32(core);

	Mystatus_AddGold( my, gold);
	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * 
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSubGold(VM_MACHINE * core)
{
	MYSTATUS* my	= SaveData_GetMyStatus( GameSystem_GetSaveData(core->fsys) );
	u32 gold;
	
	gold = VMGetU32(core);

	Mystatus_SubGold( my, gold);
	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * 
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSubMyGold( VM_MACHINE * core )
{
	MYSTATUS* my	= SaveData_GetMyStatus( GameSystem_GetSaveData(core->fsys) );
	u32 gold;
	
	gold = VMGetWorkValue(core);

	Mystatus_SubGold( my, gold);
	return 0;
};


//--------------------------------------------------------------------------------------------
/**
 * z𒲂ׂ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCompGold(VM_MACHINE * core)	
{
	MYSTATUS* my	= SaveData_GetMyStatus( GameSystem_GetSaveData(core->fsys) );
	u16 * work;
	u32 gold,my_gold;

	work  = VMGetWork(core);

	gold = VMGetU32(core);
	my_gold = MyStatus_GetGold( my);

	if(my_gold < gold){
		*work = FALSE;
	}else{
		*work = TRUE;
	}

	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * EBhE\
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGoldWinWrite(VM_MACHINE * core)	
{
#if 0
	u8 x,y,code;

	x = VMGetU8(core);
	y = VMGetU8(core);
	code = VMGetU8(core);

	if( code == 0 )						//莝
	{
		//DrawGoldWin( fld->my_gold, x, y );<<20030908 del
		EvBmpGoldWinPut( GetGold( &fld->my_gold ), x, y );
	}else								//aĂ邨
	{
		//DrawGoldWin( ???, x, y );
	}
#endif
		
	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * EBhE폜
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGoldWinDel(VM_MACHINE * core)
{
#if 0
/*	
	u8 x,y;

	x = VMGetU8(core);
	y = VMGetU8(core);

	DelOkozukaiWin( x, y );
*/
	EvBmpGoldWinDel();
#endif

	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * EBhEĕ\
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGoldWrite(VM_MACHINE * core)
{
#if 0
	u8 x,y,code;

	x = VMGetU8(core);
	y = VMGetU8(core);
	code = VMGetU8(core);

	if( code == 0 )						//莝
	{
		//DrawWinOkozukai( fld->my_gold, x, y );<<20030909 del
		EvBmpGoldPut( GetGold( &fld->my_gold ) );
	}else								//aĂ邨
	{
		//DrawWinOkozukai( ???, x, y );
	}
#endif
		
	return 0;
};


//============================================================================================
//
//	֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * RCEBhE\
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCoinWinWrite(VM_MACHINE * core)	
{
#if 0
	u8 x,y;

	x = VMGetU8(core);
	y = VMGetU8(core);

	DrawCoinWin( G_CheckCoin(), x, y );
#endif

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * RCEBhE폜
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCoinWinDel(VM_MACHINE * core)
{
#if 0
	u8 x,y;

	x = VMGetU8(core);
	y = VMGetU8(core);

	DelCoinWin();
#endif

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * RCĕ\
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCoinWrite(VM_MACHINE * core)
{
#if 0
	u8 x,y;

	x = VMGetU8(core);
	y = VMGetU8(core);

	BmpCoinPut( G_CheckCoin() );
#endif

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * RC擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCheckCoin( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	SAVEDATA * sv = fsys->savedata;
	COIN * coin = SaveData_GetMyCoin(sv);
	u16 * work;

	work  = VMGetWork(core);
	*work = (u16)COIN_GetValue(coin);

	return	0;
}

//--------------------------------------------------------------------------------------------
/**
 * RC
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdAddCoin( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	SAVEDATA * sv = fsys->savedata;
	COIN * coin = SaveData_GetMyCoin(sv);
	u16 value;
	
	value = VMGetWorkValue(core);
	COIN_Add(coin, value);

	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * RC炷
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSubCoin( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	SAVEDATA * sv = fsys->savedata;
	COIN * coin = SaveData_GetMyCoin(sv);
	u16 value;
	
	value = VMGetWorkValue(core);
	COIN_Sub(coin, value);

	return	0;
}


//============================================================================================
//
//	ACe֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ACe
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdAddItem(VM_MACHINE * core)		
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 item_no			= VMGetWorkValue(core);
	u16 num				= VMGetWorkValue(core);
	u16* ret_wk			= VMGetWork( core );

	*ret_wk = MyItem_AddItem( SaveData_GetMyItem(fsys->savedata), item_no, num, HEAPID_FIELD );
	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * ACe炷
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSubItem(VM_MACHINE * core)			
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 item_no			= VMGetWorkValue(core);
	u16 num				= VMGetWorkValue(core);
	u16* ret_wk			= VMGetWork( core );

	*ret_wk = MyItem_SubItem( SaveData_GetMyItem(fsys->savedata), item_no, num, HEAPID_FIELD );
	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * ACe邩`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdAddItemChk(VM_MACHINE * core)	
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 item_no			= VMGetWorkValue(core);
	u16 num				= VMGetWorkValue(core);
	u16* ret_wk			= VMGetWork( core );

	*ret_wk = MyItem_AddCheck( SaveData_GetMyItem(fsys->savedata), item_no, num, HEAPID_FIELD );
	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * obÕACe`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCheckItem(VM_MACHINE * core)			
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 item_no			= VMGetWorkValue(core);
	u16 num				= VMGetWorkValue(core);
	u16* ret_wk			= VMGetWork( core );

	*ret_wk = MyItem_CheckItem( SaveData_GetMyItem(fsys->savedata), item_no, num, HEAPID_FIELD );
	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * Z}ṼACeio[`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdWazaMachineItemNoCheck( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 itemno			= VMGetWorkValue(core);
	u16* ret_wk			= VMGetWork( core );

	*ret_wk = WazaMachineItemNoCheck( itemno );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * |Pbgio[擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetPocketNo(VM_MACHINE * core)		
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 itemno			= VMGetWorkValue(core);
	u16* ret_wk			= VMGetWork( core );

	*ret_wk = (u16)ItemParamGet( itemno, ITEM_PRM_POCKET, HEAPID_WORLD );
	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * p\RɃACe
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdAddPCBoxItem( VM_MACHINE * core )
{
#if 0
	u16 item,num;
	item = VMGetWorkValue(core);
	num = VMGetWorkValue(core);
	*ret_wk = AddPCBoxItem(item,num);
#endif

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * p\R̃ACe`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCheckPCBoxItem( VM_MACHINE * core )
{
#if 0
	u16 item,num;
	item = VMGetWorkValue(core);
	num = VMGetWorkValue(core);
	*ret_wk = PCBoxItemCheck(item,num);
#endif

	return 0;
}

//============================================================================================
//
//	ObY֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ObY
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdAddGoods(VM_MACHINE * core)		
{
#if 0
	u16 goods;

	goods = VMGetWorkValue(core);

	*ret_wk = (u16)AddGoods(goods);
#endif

	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * ObY炷
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSubGoods(VM_MACHINE * core)					
{
#if 0
	u16 goods;

	goods = VMGetWorkValue(core);

	*ret_wk = (u16)SubGoods(goods);
#endif

	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * ObY邩̃`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdAddGoodsChk(VM_MACHINE * core)	
{
#if 0
	u16 goods;

	goods = VMGetWorkValue(core);

	*ret_wk = (u16)AddGoodsCheck(goods);
#endif

	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * obÕObY`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCheckGoods(VM_MACHINE * core)		
{
#if 0
	u16 goods;

	goods = VMGetWorkValue(core);

	*ret_wk = (u16)CheckGoodsMine(goods);
#endif

	return 0;
};


//============================================================================================
//
//	|P֘A
//
//============================================================================================
//--------------------------------------------------------------------------------------------
/**
 * @brief	|PIʌĂяo
 * @param	core		z}V\̂ւ̃|C^
 * @return	1		XNvg烁Cɖ߂
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPokeListSetProc(VM_MACHINE * core)
{
	void ** buf;
	buf = GetEvScriptWorkMemberAdrs(core->fsys, ID_EVSCR_SUBPROC_WORK);
	*buf = FieldPokeListEvent_SetProc(HEAPID_EVENT, core->fsys);

	VM_SetWait( core, EvCmdWaitSubProcEnd );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	|PIʌĂяo
 * @param	core		z}V\̂ւ̃|C^
 * @return	1		XNvg烁Cɖ߂
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPokeListGetResult(VM_MACHINE * core)
{
	void ** buf;
	u16 * ret_wk;
	ret_wk = VMGetWork(core);
	buf = GetEvScriptWorkMemberAdrs(core->fsys, ID_EVSCR_SUBPROC_WORK);
	GF_ASSERT(*buf != 0);
	*ret_wk = FieldPokeListEvent_GetSelect(*buf);
	if (*ret_wk == PL_SEL_POS_EXIT) {
		*ret_wk = 0xff;
	}
	sys_FreeMemoryEz(*buf);
	*buf = NULL;

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * |P莝ɉ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdAddPokemon(VM_MACHINE * core)
{
	POKEPARTY * temoti;
	FIELDSYS_WORK * fsys	= core->fsys;
	u16 monsno				= VMGetWorkValue(core);
	u16 lv					= VMGetWorkValue(core);
	u16 itemno				= VMGetWorkValue(core);
	u16* ret_wk				= VMGetWork( core );

	temoti = SaveData_GetTemotiPokemon(fsys->savedata);
	*ret_wk = EvPoke_Add(HEAPID_WORLD, temoti, monsno, lv, itemno);
	if (*ret_wk) {
		//菈BۂEvPoke_Addɓׂ
		ZUKAN_WORK * zw;
		int pos;
		zw = SaveData_GetZukanWork(fsys->savedata);
		pos = PokeParty_GetPokeCount(temoti);
		ZukanWork_SetPokeGet(zw, PokeParty_GetMemberPointer(temoti, pos - 1));
	}
	//gp
	//u32 pokename_adrs		= (VM_CODE *)VMGetU32(core);
	//u32 oyaname_adrs		= (VM_CODE *)VMGetU32(core);
	//u8 name_sw			= VMGetU8(core);
	
	//*ret_wk = (u16)TemotiPokeAdd(monsno, lv, itemno, NULL, NULL, 0);

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 *	莝|PԍA|Pԍ֕ϊ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTemotiMonsNo(VM_MACHINE * core)
{
	FIELDSYS_WORK * fsys	= core->fsys;
	POKEMON_PARAM * poke;
	u16* in_wk				= VMGetWork( core );
	u16* out_wk				= VMGetWork( core );

	//|Pւ̃|C^擾
	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), *in_wk);

	//X^[ԍ擾
	if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) == 0 ){
		*out_wk = PokeParaGet(poke,ID_PARA_monsno,NULL);
	}else{	//^}S
		*out_wk = 0;
	}

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 *	莝|P̂ll`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdMonsOwnChk(VM_MACHINE * core)
{
	FIELDSYS_WORK * fsys	= core->fsys;
	POKEMON_PARAM * poke;
	MYSTATUS* my		= SaveData_GetMyStatus( GameSystem_GetSaveData(core->fsys) );
	u16* in_wk				= VMGetWork( core );
	u16* out_wk				= VMGetWork( core );
	u16 poke_id,my_id;

	//|Pւ̃|C^擾
	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), *in_wk);

	//|PID
	poke_id = PokeParaGet( poke, ID_PARA_id_no, NULL );

	my_id = MyStatus_GetID(my);

	if(poke_id == my_id){	//v
		*out_wk = 0;
	}else{					//sv
		*out_wk = 1;
	}

	return 0;
}



//--------------------------------------------------------------------------------------------
/**
 * ^}S莝ɉ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdAddTamago(VM_MACHINE * core)
{
	u8	max;
	BOOL result;
	POKEPARTY * temoti;
	POKEMON_PARAM* poke_param;
	FIELDSYS_WORK * fsys	= core->fsys;
	u16 monsno				= VMGetWorkValue(core);

	temoti = SaveData_GetTemotiPokemon(fsys->savedata);

	max = PokeParty_GetPokeCount(temoti);
	if(max<6){		//Ô߁B|Pő吔̂ƂɌĂ΂Ă΂Ȃ悤
//		pokemon_param = PokeParty_GetMemberPointer( temoti, max);

		poke_param = PokemonParam_AllocWork(HEAPID_WORLD);
		PokeParaInit(poke_param);

		PokemonTamagoSet_forEvent(poke_param,monsno,1);

		result = PokeParty_Add(temoti, poke_param);
		sys_FreeMemoryEz(poke_param);
	}
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * 莝|P̋Zu
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdChgPokeWaza( VM_MACHINE * core )
{
	u16 poke_pos, waza_pos, waza_no;
	poke_pos = VMGetWorkValue(core);
	waza_pos = VMGetWorkValue(core);
	waza_no = VMGetWorkValue(core);
	EvPoke_ChangeWaza(SaveData_GetTemotiPokemon(core->fsys->savedata),
			poke_pos, waza_pos, waza_no);
#if 0
	u8 pos,waza_pos;
	u16 wazano;

	pos = VMGetU8(core);
	waza_pos = VMGetU8(core);
	wazano = VMGetU16(core);
	TemotiPokeWazaChange( pos, wazano, waza_pos );
#endif

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * 莝|Pw肳ꂽZoĂ邩`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdChkPokeWaza( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys	= core->fsys;
	POKEMON_PARAM * poke;
	u16* ret_wk	= VMGetWork( core );
	u16 waza	= VMGetWorkValue(core);
	u16 my_waza;
	u8	i,max;

	//|P̓ANZX͕ʃ\[Xɂ܂Ƃ߂āAĂяo\B
	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(fsys->savedata));

	for( i=0, *ret_wk=6 ; i<max; i++ ){
		poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), i);

		//܂`FbN
		if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) != 0 ){
			continue;
		}

		//UXg`FbN
		if( (PokeParaGet( poke, ID_PARA_waza1, NULL ) == waza) ||(PokeParaGet( poke, ID_PARA_waza2, NULL ) == waza) ||(PokeParaGet( poke, ID_PARA_waza3, NULL ) == waza) ||(PokeParaGet( poke, ID_PARA_waza4, NULL ) == waza) ){
			*ret_wk = i;		//Ă|P̃Xg̕тԂ
			break;
		}

	}

	return	0;
}


//============================================================================================
//
//	g[i[֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * g[i[^Cv擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetTrainerType(VM_MACHINE * core)		
{
#if 0
	u8 buf;
	u16 tno;

	buf = VMGetU8(core);
	tno = VMGetWorkValue(core);
	PM_strcpy(buf_list[buf],FieldTrainerTypeNameGet(tno));
#endif

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetTrainerName(VM_MACHINE * core)
{
#if 0
	u8 buf;
	u16 tno;

	buf = VMGetU8(core);
	tno = VMGetWorkValue(core);
	PM_strcpy(buf_list[buf],FieldTrainerNameGet(tno));
#endif

	return 0;
}


//============================================================================================
//
//	ReXg֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ReXg̃|PI(Xe[^X)Ă	
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConPokeList( VM_MACHINE * core )
{
#if 0
	ContestPokeListInit();
	StopFieldScript();
#endif

	return 1;
};

//--------------------------------------------------------------------------------------------
/**
 * 񎟐RĂяo	
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConNijiCall( VM_MACHINE * core )
{
#if 0
	ContestNijiAppeal();
	StopFieldScript();
#endif

	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * ʔ\ʂĂяo	
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConResultScr( VM_MACHINE * core )
{
#if 0
	ContestResultScr();
	StopFieldScript();
#endif

	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * ReXgʐM̌Ăяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConTuusinInit( VM_MACHINE * core )
{
#if 0
	ContestTuusinInit(ContestKind);
	StopFieldScript();
#endif

	return 1;
}


//============================================================================================
//
//	V֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * VR[h̃Zbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSetWeather( VM_MACHINE * core )
{
#if 0
	u16 wea;
	wea = VMGetWorkValue(core);
	SetFieldWeatherValue(wea);
#endif

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * VR[h̏
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdInitWeather( VM_MACHINE * core )
{
#if 0
	InitFieldWeatherValue();
#endif

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * VR[h̔f
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUpdateWeather( VM_MACHINE * core )
{
#if 0
	UpdateFieldWeatherSmooth();
#endif

	return 0;
}


//============================================================================================
//
//	X֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * thVbv
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdShopStart( VM_MACHINE * core )
{
#if 0
	FdShopSet( VMGetU32(core) );
	StopFieldScript();
#endif

	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * ObYVbv
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGoodsShopStart( VM_MACHINE * core )
{
#if 0
	GoodsShopSet( VMGetU32(core) );
	StopFieldScript();
#endif

	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * t[Vbv
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdFlowerShopStart( VM_MACHINE * core )
{
#if 0
	FlowerShopSet( VMGetU32(core) );
	StopFieldScript();
#endif

	return 1;
}


//============================================================================================
//
//	c[֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ݂̃}bvʒu擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetMapPosition( VM_MACHINE * core )
{
#if 0
	u16 *x, *y;
	x = VMGetWork( core );
	y = VMGetWork( core );
	*x = fld->MapXpos;
	*y = fld->MapYpos;
#endif

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * 莝̃|P擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetTemotiPokeNum( VM_MACHINE * core )
{
#if 0
	*ret_wk = (u8)PokeCountMineGet();
#endif

	return 0;
}


//============================================================================================
//
//	vOĂяo֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * @brief	TuvZXI҂{[N
 * @param	core		z}V\̂ւ̃|C^
 * @return	"p=0AI=1"
 *
 * EvCmdWaitSubProcEndƂ̈Ⴂ́ATuvZXIƂ
 * ID_EVSCR_SUBPROC_WORKɊmۂ[N̉邱
 */
//--------------------------------------------------------------------------------------------
static BOOL EvWaitSubProcAndFree(VM_MACHINE * core)
{
	void ** buf;
	FIELDSYS_WORK * fsys = core->fsys;
	buf = GetEvScriptWorkMemberAdrs(core->fsys, ID_EVSCR_SUBPROC_WORK);

	if( FieldEvent_Cmd_WaitSubProcEnd(fsys) ){		//TuvZXI҂
		return 0;
	}
	sys_FreeMemoryEz(*buf);
	*buf = NULL;

	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * TuvZXI҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"p=0AI=1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdWaitSubProcEnd( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys = core->fsys;

	if( FieldEvent_Cmd_WaitSubProcEnd(fsys) ){		//TuvZXI҂
		return 0;
	}

	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * tB[hvZXA
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSetMapProc( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys = core->fsys;

	FieldEvent_Cmd_SetMapProc(fsys);				//tB[h}bvvZXA
	VM_SetWait( core, EvCmdWaitMapProcStart );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * tB[h}bvvZXJn҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"p=0AI=1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdWaitMapProcStart( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys = core->fsys;

	if( !FieldEvent_Cmd_WaitMapProcStart(fsys) ){	//tB[h}bvvZXJn҂
		return 0;
	}

	return 1;
}

static IMC_PROC_WORK* ImageClip_DataMake( int heap, FIELDSYS_WORK * fsys )
{
	IMC_PROC_WORK* imc_w;
	POKEMON_PARAM* poke;
	RTCTime time;
	int poke_no;
	IMC_SAVEDATA* p_save;
	IMC_ONE_SAVEDATA* p_save_one;

	// C[WNbvɓnf[^쐬
	imc_w = sys_AllocMemory( heap, sizeof( IMC_PROC_WORK ) );
	memset( imc_w, 0, sizeof( IMC_PROC_WORK ) );

#if 0
	// |Pp		͓KɎԂɂĕҏW|PI
	RTC_GetTime( &time );
	poke_no = time.second;
	poke_no += time.hour * 20;
	poke_no =  1 + (poke_no % MONSNO_END);
	poke = PokemonParam_AllocWork( HEAPID_BASE_DEBUG );
	PokeParaSet( poke, poke_no, 5, POW_RND, RND_NO_SET, 0, ID_NO_RARE, 0 );
#endif

	//|Pւ̃|C^擾(Ŏ莝̐擪)
	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), 0);

	imc_w->p_poke_para = poke;
	// Z[uf[^
	p_save = SaveData_GetImcSaveData( fsys->savedata );
	ImcSaveData_ClaenOneSaveData( p_save, 0 );		// ҏW郏[N
	p_save_one = ImcSaveData_GetOneSaveData( p_save, 0 );
	imc_w->p_imc_one_data = p_save_one;

	return imc_w;
}

#if 0
static void ImcClip_DataDelete( IMC_PROC_WORK* imc_w )
{
	sys_FreeMemoryEz( imc_w->p_poke_para );
	sys_FreeMemoryEz( imc_w );
}
#endif


//--------------------------------------------------------------------------------------------
/**
 * C[WNbvĂяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdImageClipSetProc( VM_MACHINE * core )
{
	void** buf = GetEvScriptWorkMemberAdrs(core->fsys, ID_EVSCR_SUBPROC_WORK);

	//C[WNbvf[^쐬
	*buf = ImageClip_DataMake( HEAPID_WORLD, core->fsys );

	FieldImageClip_SetProc( core->fsys, *buf );			//C[WNbvvbNZbg
	VM_SetWait( core, EvWaitSubProcAndFree );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * {bNXĂяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBoxSetProc( VM_MACHINE * core )
{
	// {̓q[vmۂB
	// ǂFreeėǂȂ̂ňꎞIȑ[uƂĂĂBtaya
	static BOX_PROC_PARAM  param = {};

	FIELDSYS_WORK * fsys = core->fsys;


	param.savedata = fsys->savedata;
	param.mode = BOX_MODE_SEIRI;

	FieldBox_SetProc( fsys, &param );						//{bNXvbNZbg
	VM_SetWait( core, EvCmdWaitSubProcEnd );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * Ăяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdOekakiBoardSetProc( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys = core->fsys;

	OekakiBoard_SetProc( fsys );
	VM_SetWait( core, EvCmdWaitSubProcEnd );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[J[hĂяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTrCardSetProc( VM_MACHINE * core )
{
	TR_CARD_DATA * cd;
	void ** buf;
	buf = GetEvScriptWorkMemberAdrs(core->fsys, ID_EVSCR_SUBPROC_WORK);

	*buf = TRCSET_AllocTrainerCardData( HEAPID_WORLD );
	TRCSET_MakeTrainerInfo(1, core->fsys, *buf);

	FieldTrCard_SetProc( core->fsys, *buf );
	VM_SetWait( core, EvWaitSubProcAndFree );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * Ăяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTradeListSetProc( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys = core->fsys;
	void ** buf;
	buf = GetEvScriptWorkMemberAdrs(core->fsys, ID_EVSCR_SUBPROC_WORK);

	*buf = TradeList_SetProc( fsys );
	VM_SetWait( core, EvWaitSubProcAndFree );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * ŏ̃|PIʌĂяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdFirstPokeSelectProc( VM_MACHINE * core )
{
	void** pwork = GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_PWORK );

	//yAgf[^쐬
	*pwork = sys_AllocMemory( HEAPID_WORLD, sizeof(EV_POKESELECT_PEARENT_DATA) );

	Field_EVPokeSelect_SetProc( core->fsys, *pwork );

	VM_SetWait( core, EvCmdWaitSubProcEnd );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * ŏ̃|PIʂőI|Pio[擾āAmۂ폜
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdFirstPokeSelectSetAndDel( VM_MACHINE * core )
{
	EV_POKESELECT_PEARENT_DATA* first_poke;
	void** pwork	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_PWORK );

	first_poke = (*pwork);

	SysWork_FirstPokeNoSet( core->fsys, first_poke->select_monsno );
	sys_FreeMemoryEz( *pwork );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	obOʂ̂т
 *
 * @param	core		z}V\̂ւ̃|C^
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBagSetProc( VM_MACHINE * core )
{
	void ** buf;
	u8 mode;
	if (VMGetU8(core) == 0) {
		mode = EVBAG_MODE_NORMAL_ONLY;
	} else {
		mode = EVBAG_MODE_KINOMI_ONLY;
	}
	buf = GetEvScriptWorkMemberAdrs(core->fsys, ID_EVSCR_SUBPROC_WORK);
	GF_ASSERT(*buf == 0);
	*buf = FieldBagEvent_SetProc(core->fsys, mode);

	VM_SetWait( core, EvCmdWaitSubProcEnd );
	return 1;
}
//--------------------------------------------------------------------------------------------
/**
 * @brief	obOʂł̌ʎ擾
 * @param	core		z}V\̂ւ̃|C^
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBagGetResult( VM_MACHINE * core)
{
	u16 * ret_wk;
	void ** buf;
	ret_wk = VMGetWork(core);
	buf = GetEvScriptWorkMemberAdrs(core->fsys, ID_EVSCR_SUBPROC_WORK);
	GF_ASSERT(*buf != 0);
	*ret_wk = FieldBagEvent_GetSelectedItem(*buf);
	sys_FreeMemoryEz(*buf);
	*buf = NULL;
	return 0;
}

extern TCB_PTR EvCall_TrEyeMeetMoveAddTcb(FIELD_OBJ_PTR fldobj, 
											PLAYER_STATE_PTR jiki, int dir, int range);
extern void GMEVENT_Call_TrEyeMeetEventStart(FIELDSYS_WORK *fsys, GMEVENT_CONTROL* event, FIELD_OBJ_PTR fldobj,TCB_PTR tcb);

//--------------------------------------------------------------------------------------------
/**
 * Fg[i[ړĂяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdEyeTrainerMoveSet( VM_MACHINE * core )
{
	int* range;
	int* scr_id;
	int* tr_id;
	int* tr_type;
	int* dir;
	TCB_PTR* tcb;
	FIELD_OBJ_PTR* fldobj;
	PLAYER_STATE_PTR player;
	FIELDSYS_WORK* fsys = core->fsys;
	u16 pos				= VMGetWorkValue(core);								//f[^0,1H

	//f[^0,1H
	if( pos == 0 ){
		range	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TR0_RANGE );	//
		dir		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TR0_DIR );	//
		scr_id	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TR0_SCR_ID );	//
		tr_id	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TR0_ID );		//
		tr_type	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TR0_TYPE );		//
		fldobj	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TR0_FLDOBJ );	//
		tcb		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TR0_TCB );
	}else{
		range	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TR1_RANGE );	//
		dir		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TR1_DIR );	//
		scr_id	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TR1_SCR_ID );	//
		tr_id	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TR1_ID );		//
		tr_type	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TR1_TYPE );		//
		fldobj	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TR1_FLDOBJ );	//
		tcb		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TR1_TCB );
	}

	player	= fsys->player;													//l

	//GMEVENT_Call_TrEyeMeetEventStart( fsys, core->event_work, *fldobj, 
	//									EvCall_TrEyeMeetMoveAddTcb(*fldobj,player,*dir,*range) );
	
	*tcb = EvTrainerEyeMoveSet( *fldobj, player, *dir, *range, 0 );
	OS_Printf( "\n===========%d\n", (*tcb) );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * Fg[i[ړI`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdEyeTrainerMoveCheck( VM_MACHINE * core )
{
	TCB_PTR* tcb;
	u16 pos		= VMGetWorkValue(core);					//f[^0,1H
	u16* ret_wk	= VMGetWork( core );

	*ret_wk = 0;

	if( pos == SCR_EYE_TR_0 ){
		tcb	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_TR0_TCB );
	}else{
		tcb	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_TR1_TCB );
	}

	//o^ĂȂ
	if( tcb == NULL ){
		*ret_wk = 1;
		return 1;
	}

	if( EvTrainerEyeMoveEndCheck(*tcb) == TRUE ){
		EvTrainerEyeMoveEnd( *tcb );
		*tcb = NULL;	//NAȂƂ܂
		*ret_wk = 1;
	}
	
	//return"1"ԂȂƃ`FbN[vĂ܂̂ŒӁI
	
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * Fg[i[^Cv擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 *
 * TR0_TYPEɌŒI
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdEyeTrainerTypeGet( VM_MACHINE * core )
{
	u16* type	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_TR0_TYPE );		//TR0_TYPEŒ
	u16* ret_wk	= VMGetWork( core );

	*ret_wk = *type;
	//OS_Printf( "\n===========%d\n", (*type) );
	//OS_Printf( "\n===========%d\n", (*ret_wk) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * Fg[i[ID擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdEyeTrainerIdGet( VM_MACHINE * core )
{
	u16* tr_id_0	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_TR0_ID );		//
	u16* tr_id_1	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_TR1_ID );		//
	u16 pos			= VMGetWorkValue(core);					//f[^0,1H
	u16* ret_wk		= VMGetWork( core );

	//OS_Printf( "\n===========%d\n", pos );
	//OS_Printf( "\n===========%d\n", (*tr_id_0) );
	//OS_Printf( "\n===========%d\n", (*tr_id_1) );
	//OS_Printf( "\n===========%d\n", (*ret_wk) );
	*ret_wk = (pos == SCR_EYE_TR_0) ? (*tr_id_0) : (*tr_id_1);
	//OS_Printf( "\n===========%d\n", (*tr_id_0) );
	//OS_Printf( "\n===========%d\n", (*tr_id_1) );
	//OS_Printf( "\n===========%d\n", (*ret_wk) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * O͌Ăяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdNameIn( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;

	EventCmd_NameIn( core->event_work, NAMEIN_MYNAME, 0, 5, 0, NULL, VMGetWork(core) );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * |PO͌Ăяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdNameInPoke( VM_MACHINE * core )
{
	STRCODE msg_buf[MONS_NAME_SIZE*2];		//TCYmFI
	POKEMON_PARAM * poke;
	FIELDSYS_WORK* fsys = core->fsys;
	u16 pos				= VMGetWorkValue(core);

	//|Pւ̃|C^擾
	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), pos);

	//jbNl[擾
	PokeParaGet(poke, ID_PARA_nickname, msg_buf);

	EventCmd_NameIn(core->event_work, NAMEIN_POKEMON, 
					PokeParaGet(poke,ID_PARA_monsno,NULL), 5, pos, msg_buf, VMGetWork(core) );
	return 1;
}


//============================================================================================
//
//	Px֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * PxύXNGXg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 *
 * ӁI@tF[hɂLCDABGʂ̐ݒ͌ŒɂĂ
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdBrightnessReq( VM_MACHINE * core )
{
	u8 sync;
	u8 dst_bright,src_bright;

	sync = VMGetU8(core);						//tF[ĥɂsync
	dst_bright = VMGetU8(core);					//IPx
	src_bright = VMGetU8(core);					//JnPx

	//EBhE}XNԂ
	WIPE_ResetWndMask( WIPE_DISP_MAIN );
	WIPE_ResetWndMask( WIPE_DISP_SUB );
	
	ChangeBrightnessRequest( sync, (s8)dst_bright, (s8)src_bright, 
								PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * PxύXI`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 *
 * ӁI@`FbNLCD̐ݒ͌ŒɂĂ
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdChangeBrightnessWait( VM_MACHINE * core )
{
	VM_SetWait( core, EvChangeBrightnessWait );
	return 1;
}

//return 1 = I
static BOOL EvChangeBrightnessWait(VM_MACHINE * core)
{
	if( IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) ){
		return 1;
	}

	return 0;
}


//============================================================================================
//
//	}bvJڊ֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * }bvJ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdMapChange( VM_MACHINE * core )
{
//	u16 zone_id,door_id,x,z,dir;
	u16 zone_id,x,z,dir;
	s16 door_id;
	FIELDSYS_WORK * fsys = core->fsys;

	zone_id = VMGetU16(core);
	door_id = VMGetU16(core);
	x		= VMGetU16(core);
	z		= VMGetU16(core);
	dir		= VMGetU16(core);
	door_id = DOOR_ID_JUMP_CODE;

	//GMEVENT_Call_MapChange( core->event_work, zone_id, door_id, x, z, dir );
//	GMEVENT_Call_MapChangeScript( core->event_work, zone_id, door_id, x, z, dir );
	GMEVENT_Call_MapChangeScript( core->event_work, zone_id, door_id, x, z, dir );
	return 1;
}


//============================================================================================
//
//	`Z֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ǂ̂ڂ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdKabeNobori( VM_MACHINE * core )
{
	EventCmd_KabeNoboriCall( core->event_work, Player_DirGet(core->fsys->player) );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * Ȃ݂̂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdNaminori( VM_MACHINE * core )
{
	EventCmd_NaminoriCall( core->event_work, Player_DirGet(core->fsys->player) );
	return 1;
}


//============================================================================================
//
//	
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * vC[wobt@ɓo^
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPlayerName(VM_MACHINE * core ) 
{
	FIELDSYS_WORK * fsys	= core->fsys;
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8 idx					= VMGetU8(core);

	WORDSET_RegisterPlayerName( *wordset, idx, SaveData_GetMyStatus(GameSystem_GetSaveData(fsys)) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * Cowobt@ɓo^
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdRivalName(VM_MACHINE * core ) 
{
	FIELDSYS_WORK * fsys	= core->fsys;
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8 idx					= VMGetU8(core);

	WORDSET_RegisterRivalName( *wordset, idx, fsys->savedata );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * T|[gwobt@ɓo^
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSupportName(VM_MACHINE * core ) 
{
	FIELDSYS_WORK * fsys	= core->fsys;
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8 idx					= VMGetU8(core);

	WORDSET_RegisterSupportName( *wordset, idx, fsys->savedata );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * |Pwobt@ɓo^
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPokemonName(VM_MACHINE * core ) 
{
	POKEMON_PARAM * poke;
	FIELDSYS_WORK * fsys	= core->fsys;
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8 idx					= VMGetU8(core);
	u16 pos					= VMGetWorkValue(core);

	//|Pւ̃|C^擾
	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), pos);

	//POKEMON_PARAMPOKEMON_PASO_PARAMɓnĂ̂ŒӁI(cJɊmFς)
	WORDSET_RegisterPokeMonsName( *wordset, idx, (POKEMON_PASO_PARAM*)poke );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ACewobt@ɓo^
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdItemName(VM_MACHINE * core ) 
{
	FIELDSYS_WORK * fsys	= core->fsys;
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8 idx					= VMGetU8(core);
	u16 itemno				= VMGetWorkValue(core);

	WORDSET_RegisterItemName( *wordset, idx, itemno );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * |Pbgwobt@ɓo^
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPocketName(VM_MACHINE * core ) 
{
	FIELDSYS_WORK * fsys	= core->fsys;
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8 idx					= VMGetU8(core);
	u16 pocket				= VMGetWorkValue(core);

	//WORDSET_RegisterItemPocketName( *wordset, idx, pocket );		//ACRȂ
	WORDSET_RegisterItemPocketWithIcon( *wordset, idx, pocket );	//ACR

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * Zwobt@ɓo^
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdWazaName(VM_MACHINE * core ) 
{
	FIELDSYS_WORK * fsys	= core->fsys;
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8 idx					= VMGetU8(core);
	u16 itemno				= VMGetWorkValue(core);
	u16 wazano;

	//Z}Vio[Zio[擾
	wazano = GetWazaNoItem(itemno);

	WORDSET_RegisterWazaName( *wordset, idx, wazano );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * lwobt@ɓo^
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdNumberName(VM_MACHINE * core ) 
{
	FIELDSYS_WORK * fsys	= core->fsys;
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8 idx					= VMGetU8(core);
	u16 number				= VMGetWorkValue(core);

	WORDSET_RegisterNumber( *wordset, idx, number, GetNumKeta(number), 
							NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * jbNl[wobt@ɓo^
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdNickName(VM_MACHINE * core ) 
{
	POKEMON_PARAM * poke;
	FIELDSYS_WORK * fsys	= core->fsys;
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8 idx					= VMGetU8(core);
	u16 pos					= VMGetWorkValue(core);

	//|Pւ̃|C^擾
	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), pos);

	//POKEMON_PARAMPOKEMON_PASO_PARAMɓnĂ̂ŒӁI(cJɊmFς)
	WORDSET_RegisterPokeNickName( *wordset, idx, (POKEMON_PASO_PARAM*)poke );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * |Pb`\tgwobt@ɓo^
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPoketchName(VM_MACHINE * core ) 
{
	POKEMON_PARAM * poke;
	FIELDSYS_WORK * fsys	= core->fsys;
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8 idx					= VMGetU8(core);
	u16 app_id				= VMGetWorkValue(core);

	WORDSET_RegisterPoketchAppName( *wordset, idx, app_id );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[ʂwobt@ɓo^
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTrTypeName(VM_MACHINE * core ) 
{
	FIELDSYS_WORK * fsys	= core->fsys;
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8 idx					= VMGetU8(core);
	u16 type				= VMGetWorkValue(core);

	//OS_Printf( "type = %d\n", type );
	WORDSET_RegisterTrTypeName( *wordset, idx, type );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * l̃g[i[ʂwobt@ɓo^
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdMyTrTypeName(VM_MACHINE * core ) 
{
	FIELDSYS_WORK * fsys	= core->fsys;
	MYSTATUS* my			= SaveData_GetMyStatus( GameSystem_GetSaveData(core->fsys) );
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8 idx					= VMGetU8(core);

	WORDSET_RegisterTrTypeName( *wordset, idx, MyStatus_GetTrainerView(my) );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * X^[io[|Pwobt@ɓo^
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPokemonNameExtra(VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys	= core->fsys;
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8 idx					= VMGetU8(core);
	u16 mons				= VMGetWorkValue(core);
	u16 sex					= VMGetU16(core);
	u8 flag					= VMGetU8(core);
	STRBUF* buf				= PokeNameGetAlloc( mons, HEAPID_FIELD );

	//PZbg
	//obt@ID
	//
	//ʃR[h
	//P^iTRUEŒPj
	//R[h
	WORDSET_RegisterWord( *wordset, idx, buf, sex, flag, PM_LANG );
	STRBUF_Delete( buf );
	return 0;
}

static STRBUF * PokeNameGetAlloc( u16 id, u32 heap )
{
	MSGDATA_MANAGER* man;
	STRBUF* str;
	
	man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_monsname_dat, heap );
	str = MSGMAN_AllocString( man, id );

	MSGMAN_Delete( man );
	return str;
}

//--------------------------------------------------------------------------------------------
/**
 * ŏ̃|Pwobt@ɓo^
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdFirstPokemonName(VM_MACHINE * core )
{
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WORDSET );
	u8 idx					= VMGetU8(core);
	u16 mons				= SysWork_FirstPokeNoGet( core->fsys );
	STRBUF* buf				= PokeNameGetAlloc( mons, HEAPID_FIELD );

	//PZbg
	//obt@ID
	//
	//ʃR[h
	//P^iTRUEŒPj
	//R[h
	WORDSET_RegisterWord( *wordset, idx, buf, PM_MALE, TRUE, PM_LANG );
	STRBUF_Delete( buf );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * Cõ|Pwobt@ɓo^
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdRivalPokemonName(VM_MACHINE * core )
{
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WORDSET );
	u8 idx					= VMGetU8(core);
	u16 mons				= SysWork_RivalPokeNoGet( core->fsys );
	STRBUF* buf				= PokeNameGetAlloc( mons, HEAPID_FIELD );

	//PZbg
	//obt@ID
	//
	//ʃR[h
	//P^iTRUEŒPj
	//R[h
	WORDSET_RegisterWord( *wordset, idx, buf, PM_MALE, TRUE, PM_LANG );
	STRBUF_Delete( buf );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ŏ̃|Pio[擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdFirstPokeNoGet(VM_MACHINE * core )
{
	u16* ret_wk	= VMGetWork( core );

	*ret_wk = SysWork_FirstPokeNoGet( core->fsys );
	return 0;
}


//============================================================================================
//
//	퓬֘A()
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * g[i[ID擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTrainerIdGet( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys	= core->fsys;
	u16* script_id			= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_SCRIPT_ID );
	u16* wk					= VMGetWork( core );

	//XNvgIDAg[i[ID擾
	*wk = GetTrainerIdByScriptId( *script_id );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[퓬Ăяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTrainerBattleSet( VM_MACHINE * core )
{
	u32 fight_type;
	FIELDSYS_WORK * fsys	= core->fsys;
	u16* script_id			= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_SCRIPT_ID );
	BOOL* win_flag			= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WIN_FLAG );
	u16 tr_id_0				= VMGetWorkValue(core);
	u16 tr_id_1				= VMGetWorkValue(core);

	fight_type = ( tr_id_1 == 0 ) ? FIGHT_TYPE_TRAINER : FIGHT_TYPE_2vs2_TRAINER;
	//OS_Printf( "fight_type = %d\n", fight_type );
	//OS_Printf( "tr_id_0 = %d\n", tr_id_0 );
	//OS_Printf( "tr_id_1 = %d\n", tr_id_1 );
	EventCmd_TrainerBattle(core->event_work, tr_id_0, tr_id_1, fight_type, HEAPID_WORLD, win_flag);
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[bĂяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTrainerMessageSet( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys	= core->fsys;
	u16* script_id			= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_SCRIPT_ID );
	STRBUF** pbuf			= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_MSGBUF );
	u8* win_open_flag		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WIN_OPEN_FLAG );
	u8* msg_index			= GetEvScriptWorkMemberAdrs( fsys,ID_EVSCR_MSGINDEX );
	u16 tr_id				= VMGetWorkValue(core);
	u16 kind_id				= VMGetWorkValue(core);

	//OS_Printf( "tr_id = %d\n", tr_id );
	//OS_Printf( "kind_id = %d\n", kind_id );

	TT_TrainerMessageGet( tr_id, kind_id, *pbuf, HEAPID_WORLD );

	//bZ[WNA
	GF_BGL_BmpWinDataFill( GetEvScriptWorkMemberAdrs(fsys, ID_EVSCR_MSGWINDAT), (FBMP_COL_WHITE) );

	*msg_index = FldTalkMsgStart(GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_MSGWINDAT ), *pbuf, 1);

	VM_SetWait( core, TalkMsgWait );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[b̎ގ擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTrainerTalkTypeGet( VM_MACHINE * core )
{
	u16 btl_type,lr,start_type,after_type,one_type;
	u16* script_id			= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_SCRIPT_ID );
	u16* wk1				= VMGetWork( core );
	u16* wk2				= VMGetWork( core );
	u16* wk3				= VMGetWork( core );

	//XNvgIDAg[i[ID擾A_uog^Cv擾
	btl_type = CheckTrainer2vs2Type( GetTrainerIdByScriptId(*script_id) );

	//VO_u`FbN
	if( btl_type == 0 ){
		//VO
		start_type = TRMSG_FIGHT_START;
		after_type = TRMSG_FIGHT_AFTER;
		one_type   = 0;
	}else{
		//_u
		lr = GetTrainerLRByScriptId( *script_id );

		if( lr == 0 ){
			//
			start_type = TRMSG_FIGHT_START_1;
			after_type = TRMSG_FIGHT_AFTER_1;
			one_type = TRMSG_POKE_ONE_1;
		}else{
			//E
			start_type = TRMSG_FIGHT_START_2;
			after_type = TRMSG_FIGHT_AFTER_2;
			one_type = TRMSG_POKE_ONE_2;
		}
	}

	*wk1 = start_type;
	*wk2 = after_type;
	*wk3 = one_type;

	//OS_Printf( "start_type = %d\n", *wk1 );
	//OS_Printf( "after_type = %d\n", *wk2 );
	//OS_Printf( "one_type = %d\n", *wk3 );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[^Cv擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTrainerTypeGet( VM_MACHINE * core )
{
	u16* script_id	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_SCRIPT_ID );
	u16* ret_wk		= VMGetWork( core );

	//XNvgIDAg[i[ID擾A_uog^Cv擾
	*ret_wk = CheckTrainer2vs2Type( GetTrainerIdByScriptId(*script_id) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[BGMĐ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTrainerBgmSet( VM_MACHINE * core )
{
	u16 tr_id = VMGetWorkValue(core);
	Snd_EyeBgmSet( Snd_EyeBgmGet(tr_id) );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[sk
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTrainerLose( VM_MACHINE * core )
{
	EventCmd_NormalLose( core->event_work );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[sk`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdTrainerLoseCheck( VM_MACHINE * core )
{
	BOOL* win_flag	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WIN_FLAG );
	u16* ret_wk		= VMGetWork( core );

	*ret_wk = *win_flag;
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * 莝`FbN 2vs2\擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmd2vs2BattleCheck( VM_MACHINE * core )
{
	u16* ret_wk	= VMGetWork( core );

	*ret_wk = EvPoke_Enable2vs2Battle(SaveData_GetTemotiPokemon(core->fsys->savedata));
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * fobN퓬Ăяo()
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdDebugBattleSet( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys = core->fsys;
	BOOL * win_flag			= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WIN_FLAG );

	//Cxg؂ւĂ܂̂ŉIII
	//DebugFieldEncount( fsys );
	
	//CxgR[Ȃ̂ŁAXNvgɕA܂B
	//EventCmd_TrainerBattle( core->event_work, 0 );
	//EventCmd_TrainerBattle( core->event_work, 0, FIGHT_TYPE_TRAINER, HEAPID_WORLD ,win_flag );
	EventCmd_TrainerBattle( core->event_work, 1, 0, FIGHT_TYPE_TRAINER, HEAPID_WORLD ,win_flag );

	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * fobNg[i[tOZbg(10ROMpAƂō폜܂I)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdDebugTrainerFlagSet( VM_MACHINE * core )
{
	FIELD_OBJ_PTR* fldobj;
	FIELDSYS_WORK * fsys = core->fsys;

	fldobj = GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TARGET_OBJ );

	SetEventFlagTrainer( FieldOBJ_FieldSysWorkGet(*fldobj), FieldOBJ_OBJIDGet(*fldobj) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * fobNg[i[tOZbg(10ROMpAƂō폜܂I)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdDebugTrainerFlagOnJump( VM_MACHINE * core )
{
	int ret;
	s32	pos;
	FIELD_OBJ_PTR* fldobj;
	FIELDSYS_WORK* fsys = core->fsys;

	fldobj = GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_TARGET_OBJ );

	pos = (s32)VMGetU32(core);

	ret = CheckEventFlagTrainer( FieldOBJ_FieldSysWorkGet(*fldobj), FieldOBJ_OBJIDGet(*fldobj) );

	//tOONȂWv
	if( ret == TRUE ){
		VMJump( core, (VM_CODE *)(core->PC+pos) );	//JUMP
		//VM_End( core );
		return 1;			//10ROM̂肬̕ύXɑΏ邽߉IIIII
	}

	return 0;
}


//============================================================================================
//
//	ʐM֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * e@IEBhEJ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConnectSelParentWin( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 mode			= VMGetWorkValue(core);	//battle_mode
	u16 type			= VMGetWorkValue(core);	//regulation_type
	u16 type2			= VMGetWorkValue(core);	//
	u16 wk_id			= VMGetU16( core );

	CommSelectParentWindowOpen( fsys, mode, type, type2 );

	//z}V̔ėpWX^Ƀ[NIDi[
	core->reg[0] = wk_id;
	//OS_Printf( "[NID = %d\n", wk_id );

	VM_SetWait( core, EvWaitConnectSelParentWin );
	return 1;
}

//return 1 = I
static BOOL EvWaitConnectSelParentWin( VM_MACHINE * core )
{
	u32 ret;
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= GetEventWorkAdrs( fsys, core->reg[0] );	//ӁI

	ret = CommSelectParentWindowCheck();
	if( ret == COMM_RETVAL_NULL ){
		return 0;					//I
	}

	*ret_wk = ret;					//߂li[
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * q@IEBhEJ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConnectSelChildWin( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 mode			= VMGetWorkValue(core);	//battle_mode
	u16 type			= VMGetWorkValue(core);	//regulation_type
	u16 type2			= VMGetWorkValue(core);	//
	u16 wk_id			= VMGetU16( core );

	CommChildWindowOpen( fsys, mode, type, type2 );

	//z}V̔ėpWX^Ƀ[NIDi[
	core->reg[0] = wk_id;
	//OS_Printf( "[NID = %d\n", wk_id );

	VM_SetWait( core, EvWaitConnectSelChildWin );
	return 1;
}

//return 1 = I
static BOOL EvWaitConnectSelChildWin( VM_MACHINE * core )
{
	u32 ret;
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= GetEventWorkAdrs( fsys, core->reg[0] );	//ӁI

	ret = CommChildWindowCheck();
	if( ret == COMM_RETVAL_NULL ){
		return 0;					//I
	}

	*ret_wk = ret;					//߂li[
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * fobNe@IEBhEJ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConnectDebugParentWin( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 wk_id			= VMGetU16( core );

	CommDirectParent_Debug( fsys );

	//z}V̔ėpWX^Ƀ[NIDi[
	core->reg[0] = wk_id;
	//OS_Printf( "[NID = %d\n", wk_id );

	VM_SetWait( core, EvWaitConnectSelParentWin );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * fobNq@IEBhEJ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConnectDebugChildWin( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 wk_id			= VMGetU16( core );

	CommDirectChild_Debug( fsys );

	//z}V̔ėpWX^Ƀ[NIDi[
	core->reg[0] = wk_id;
	//OS_Printf( "[NID = %d\n", wk_id );

	VM_SetWait( core, EvWaitConnectSelChildWin );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * fobNp@ʐM퓬Ăяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdDebugSioEncount( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	DebugSioEncount(fsys);
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * fobNp@ʐMReXgĂяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdDebugSioContest( VM_MACHINE * core )
{
//	FIELDSYS_WORK* fsys = core->fsys;
	
	//ContestActin_FieldConnectStart(fsys);

	EventCmd_ContestSioProc(core->event_work);
	return 1;
}


//============================================================================================
//
//	ReXg֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * VXe[N쐬
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConSystemCreate( VM_MACHINE * core )
{
	STRBUF* buf;
	POKEMON_PARAM * poke;
	void** pwork	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_PWORK );
	MYSTATUS* my	= SaveData_GetMyStatus( GameSystem_GetSaveData(core->fsys) );
	u16 rank		= VMGetWorkValue(core);
	u16 type		= VMGetWorkValue(core);
	u16 mode		= VMGetWorkValue(core);
	u16 pos			= VMGetWorkValue(core);

	//|Pւ̃|C^擾
	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(core->fsys->savedata), pos );

	//̖O擾
	buf	= MyStatus_CreateNameString( my, HEAPID_FIELD );

	*pwork = Contest_SystemCreate( type, rank, mode, poke, buf, my );

	//STRBUFJ
	STRBUF_Delete( buf );

#if 1
	//ReXǵAt}bvAI[vjO}bv֐؂ւ̂ŁA
	//XNvgIƁAReXgVXẽ|C^ێłȂ̂ŁA
	//Z[u[NɕۑĂ(b)
	SysWork_ContestAdrsSet( core->fsys, *pwork );
#endif

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * VXe[N폜
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConSystemExit( VM_MACHINE * core )
{
#if 0
	void** pwork= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_PWORK );
	Contest_SystemExit( *pwork );
#else
	//ReXǵAt}bvAI[vjO}bv֐؂ւ̂ŁA
	//XNvgIƁAReXgVXẽ|C^ێłȂ̂ŁA
	//Z[u[NɕۑĂ(b)
	Contest_SystemExit( SysWork_ContestAdrsGet(core->fsys) );
#endif
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * R擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConJudgeNameGet( VM_MACHINE * core )
{
	void** pwork		= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_PWORK );
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WORDSET );
	u16 judge_no		= VMGetWorkValue(core);
	u16 buf_id			= VMGetWorkValue(core);

#if 0
	ConScr_JudgeNameGet( *pwork, judge_no, *wordset, buf_id );
#else
	ConScr_JudgeNameGet( SysWork_ContestAdrsGet(core->fsys), judge_no, *wordset, buf_id );
#endif
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * u[_[擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConBreederNameGet( VM_MACHINE * core )
{
	void** pwork		= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_PWORK );
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WORDSET );
	u16 breeder_no		= VMGetWorkValue(core);
	u16 buf_id			= VMGetWorkValue(core);

#if 0
	ConScr_BreederNameGet( *pwork, breeder_no, *wordset, buf_id );
#else
	ConScr_BreederNameGet( SysWork_ContestAdrsGet(core->fsys), breeder_no, *wordset, buf_id );
#endif
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * jbNl[擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConNickNameGet( VM_MACHINE * core )
{
	void** pwork		= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_PWORK );
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WORDSET );
	u16 breeder_no		= VMGetWorkValue(core);
	u16 buf_id			= VMGetWorkValue(core);

#if 0
	ConScr_NickNameGet( *pwork, breeder_no, *wordset, buf_id );
#else
	ConScr_NickNameGet( SysWork_ContestAdrsGet(core->fsys), breeder_no, *wordset, buf_id );
#endif
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ʐMpɃ[N̏ݒƍŏ̒ʐMs^XN𐶐
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConSioParamInitSet( VM_MACHINE * core )
{
	void** pwork		= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_PWORK );
	Contest_SioParamInitSet( *pwork );
	VM_SetWait( core, EvWaitConSioParamInitSet );
	return 1;
}

//return 1 = I
static BOOL EvWaitConSioParamInitSet(VM_MACHINE * core)
{
	void** pwork		= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_PWORK );
#if 0
	return Contest_SioFastDataEndCheck( *pwork );
#else
	return Contest_SioFastDataEndCheck( SysWork_ContestAdrsGet(core->fsys) );
#endif
}

//--------------------------------------------------------------------------------------------
/**
 * ReXgĂяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdContestProc( VM_MACHINE * core )
{
	void** pwork = GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_PWORK );
#if 0
	EventCmd_ContestProc( core->event_work, *pwork );	//Cxg؂ւ
#else
	EventCmd_ContestProc( core->event_work, SysWork_ContestAdrsGet(core->fsys) );//Cxg؂ւ
#endif
	//VM_SetWait( core, EvCmdWaitSubProcEnd );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * N擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConRankNameGet( VM_MACHINE * core )
{
	void** pwork		= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_PWORK );
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WORDSET );
	u16 buf_id			= VMGetWorkValue(core);

#if 0
	ConScr_RankNameGet( *pwork, *wordset, buf_id );
#else
	ConScr_RankNameGet( SysWork_ContestAdrsGet(core->fsys), *wordset, buf_id );
#endif
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ^Cv擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConTypeNameGet( VM_MACHINE * core )
{
	void** pwork		= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_PWORK );
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WORDSET );
	u16 buf_id			= VMGetWorkValue(core);

#if 0
	ConScr_TypeNameGet( *pwork, *wordset, buf_id );
#else
	ConScr_TypeNameGet( SysWork_ContestAdrsGet(core->fsys), *wordset, buf_id );
#endif
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * DҖ擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConVictoryBreederNameGet( VM_MACHINE * core )
{
	void** pwork		= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_PWORK );
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WORDSET );
	u16 buf_id			= VMGetWorkValue(core);

#if 0
	ConScr_VictoryBreederNameGet( *pwork, *wordset, buf_id );
#else
	ConScr_VictoryBreederNameGet( SysWork_ContestAdrsGet(core->fsys), *wordset, buf_id );
#endif
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * Diio[擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdConVictoryItemNoGet( VM_MACHINE * core )
{
	void** pwork		= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_PWORK );
	u16* ret_wk			= VMGetWork( core );

#if 0
	*ret_wk = ConScr_VictoryItemNoGet( *pwork );
#else
	*ret_wk = ConScr_VictoryItemNoGet( SysWork_ContestAdrsGet(core->fsys) );
#endif
	return 0;
}


//============================================================================================
//
//	m֘A
//
//============================================================================================

#if 0
//--------------------------------------------------------------------------------------------
/**
 * ŕm`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPoisonDeadCheck( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;

	//*ret_wk = PoisonDeadCheck();
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ŕmZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPoisonDeadSet( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	//PoisonDeadSet();
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ׂĕm`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdAllDeadCheck( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;

	//*ret_wk = AllDeadCheck();
	return 0;
}
#endif


//============================================================================================
//
//	ڑ֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ڑ̃Zbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSpLocationSet( VM_MACHINE * core )
{
	LOCATION_WORK lw;

	lw.zone_id	= VMGetWorkValue( core );
	lw.door_id	= VMGetWorkValue( core );
	lw.grid_x	= VMGetWorkValue( core );
	lw.grid_z	= VMGetWorkValue( core );
	lw.dir		= VMGetWorkValue( core );

	Situation_SetSpecialLocation( SaveData_GetSituation(core->fsys->savedata), &lw );
	return 0;
}


//============================================================================================
//
//	Gx[^֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ڑ悩Ã݂tAio[擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdElevatorNowFloorGet( VM_MACHINE * core )
{
	LOCATION_WORK* location;
	u16* wk				= VMGetWork( core );

	location = Situation_GetSpecialLocation( SaveData_GetSituation(core->fsys->savedata) );

	//ڑ悩Ã݂tAio[擾
	*wk = ElevatorNowFloorGet( location->zone_id );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ݂̃tAio[\
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdElevatorFloorWrite( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	u8 x				= VMGetU8(core);
	u8 y				= VMGetU8(core);
	u16* wk				= VMGetWork(core);

	ElevatorFloorWrite( fsys, x, y, wk, *wordset );
	return 0;
}


//============================================================================================
//
//	}ӕ]֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * VIE}Ӂ@擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetShinouZukanSeeNum( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;

	//*ret_wk = ZukanHouenTotal( Z_SEE_CHK );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * VIE}Ӂ@߂܂擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetShinouZukanGetNum( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;

	//*ret_wk = ZukanHouenTotal( Z_GET_CHK );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * S}Ӂ@擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetZenkokuZukanSeeNum( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;

	//*ret_wk = ZukanTotal( Z_SEE_CHK );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * S}Ӂ@߂܂擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetZenkokuZukanGetNum( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;

	//*ret_wk = ZukanTotal( Z_GET_CHK );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * S}ӂ`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdChkZenkokuZukan( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;

	//*ret_wk = (u16)ZukanSpecialFlagCheck();
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ]bZ[WID擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetZukanHyoukaMsgID( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 num				= VMGetWorkValue(core);
	u16* ret_wk			= VMGetWork( core );

	*ret_wk = GetZukanHyoukaMsgID(num);
	return 0;
}


//============================================================================================
//
//	쐶퓬֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * |Pio[ƃxw肵Ė쐶퓬Ăяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdWildBattleSet( VM_MACHINE * core )
{
	BOOL* win_flag	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WIN_FLAG );
	u16 monsno		= VMGetWorkValue(core);
	u8 level		= (u8)VMGetWorkValue(core);

	//CxgR[Ȃ̂ŁAXNvgɕA܂B
	EventCmd_WildBattle( core->event_work, monsno, level, win_flag );

	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * ŏ̃Cxg퓬Ăяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdFirstBattleSet( VM_MACHINE * core )
{
	BOOL* win_flag	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WIN_FLAG );
	u16 monsno		= VMGetWorkValue(core);
	u8 level		= (u8)VMGetWorkValue(core);

	//CxgR[Ȃ̂ŁAXNvgɕA܂B
	EventCmd_FirstBattle( core->event_work, monsno, level, win_flag );

	return 1;
}


//============================================================================================
//
//	nj[c[֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * nj[c[
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdHoneyTree( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	OS_Printf("test_honey_setup\n");
	HTE_SetupNowLocHoneyTree(fsys);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * nj[c[Xe[g擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetHoneyTreeState( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= VMGetWork( core );

	//݂̎@̃][ID擾AɑΉ閨؂肷
	*ret_wk = HTE_GetNowLocHoneyTreeState(fsys);
	OS_Printf("test_honey_state\n");
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * h퓬Ăяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdHoneyTreeBattleSet( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys = core->fsys;
	BOOL * win_flag			= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WIN_FLAG );

	//CxgR[Ȃ̂ŁAXNvgɕA܂B
	EventCmd_HoneyTreeBattle( core->event_work ,win_flag );

	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * h퓬I㏈
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdHoneyAfterTreeBattleSet( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys = core->fsys;

	//CxgR[Ȃ̂ŁAXNvgɕA܂B
	OS_Printf("퓬ɌĂяo\n");
	HTE_SetHoneyTreeInfoAfterBtl(fsys);

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * eXgFI[vjOĂяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
extern BOOL FieldOpening_SetProc( FIELDSYS_WORK * fsys, void* buff );
static BOOL EvCmdOpeningSetProc( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys = core->fsys;

	FieldOpening_SetProc( fsys, NULL );			//I[vjOZbg
	VM_SetWait( core, EvCmdWaitSubProcEnd );
	return 1;
}


//============================================================================================
//
//	|[gZ[u֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * |[gf[^`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdReportSaveCheck( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= VMGetWork( core );

	if (SaveData_GetExistFlag(fsys->savedata) && SaveData_GetNewDataFlag(fsys->savedata)) {
		*ret_wk = TRUE;
	} else {
		*ret_wk = FALSE;
	}

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * |[g
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdReportSave( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	Field_Save(fsys);
	//{̓Z[usǂԂ
	return 0;
}


//============================================================================================
//
//	|Pb`֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * |Pb`Qbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetPoketch( VM_MACHINE * core )
{
	EventCmd_GetPoketch( core->event_work );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * |Pb`ς݃tO擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetPoketchFlag( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= VMGetWork( core );

	*ret_wk = EventCmd_GetPoketchFlag( core->event_work );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * |Pb`\tgǉ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPoketchAppAdd( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 app_id			= VMGetWorkValue(core);

	PoketchData_AddApplication(SaveData_GetPoketchData(fsys->savedata),app_id);

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * |Pb`\tgǉς݂`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPoketchAppCheck( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16 app_id			= VMGetWorkValue(core);
	u16* ret_wk			= VMGetWork( core );

	*ret_wk = PoketchData_CheckApplicationRegisterd(SaveData_GetPoketchData(fsys->savedata),app_id);
	return 0;
}

//============================================================================================
//
//	ʐM֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ^C~OR}h𔭍s
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCommTimingSyncStart( VM_MACHINE * core )
{
	u16 no = VMGetWorkValue( core );

	//z}V̔ėpWX^Ƀ[NIDi[
	core->reg[0] = no;

	CommTimingSyncStart( no );

	VM_SetWait( core, EvWaitCommIsTimingSync );
	return 1;
}

//return 1 = I
static BOOL EvWaitCommIsTimingSync(VM_MACHINE * core)
{
	return CommIsTimingSync( core->reg[0] );
}


//============================================================================================
//
//	jI֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * jI[ŎgpbpɃg[i[Zbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUnionTrainerNameRegist( VM_MACHINE * core )
{
	FIELD_OBJ_PTR* fldobj	= GetEvScriptWorkMemberAdrs(core->fsys,ID_EVSCR_TARGET_OBJ);//ΏOBJ
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WORDSET );
	u16 type				= VMGetU16( core );
	MYSTATUS* my		= SaveData_GetMyStatus( GameSystem_GetSaveData(core->fsys) );
	u16 no;

	if( type == UNION_TALK_CHILD ){
		no = FieldOBJ_OBJIDGet( *fldobj );
	}else{
		no = 0;
	}

	Union_TrainerNameRegist( *wordset, type, no, my );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * tB[hp̃R}ȟnɏ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUnionReturnSetUp( VM_MACHINE * core )
{
	CommCommandFieldInitialize( core->fsys );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * r[RWĊJ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUnionConnectCutRestart( VM_MACHINE * core )
{
	CommStateUnionBconCollectionRestart();
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * bŒʐMڑłȂɏob̃CfbNX擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUnionGetTalkNumber( VM_MACHINE * core )
{
	FIELD_OBJ_PTR* fldobj = GetEvScriptWorkMemberAdrs(core->fsys,ID_EVSCR_TARGET_OBJ);//b|ΏOBJ
	u16* ret_wk			  = VMGetWork( core );

	*ret_wk = Union_GetTalkNumber( core->fsys->union_work, FieldOBJ_OBJIDGet(*fldobj) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * bOBJIDZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUnionIdSet( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys		= core->fsys;
	FIELD_OBJ_PTR* fldobj	= GetEvScriptWorkMemberAdrs(fsys,ID_EVSCR_TARGET_OBJ);//b|ΏOBJ
	u16* ret_wk				= VMGetWork( core );

	*ret_wk = Union_ConnectIdSet( fsys->union_work, FieldOBJ_OBJIDGet(*fldobj) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * jI͂ȂڑX^[giXNvg͘bOBJIDnj
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUnionConnectStart( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys		= core->fsys;
	FIELD_OBJ_PTR* fldobj	= GetEvScriptWorkMemberAdrs(fsys,ID_EVSCR_TARGET_OBJ);//b|ΏOBJ
	u16* ret_wk				= VMGetWork( core );

	*ret_wk = Union_ConnectStart( fsys->union_work, FieldOBJ_OBJIDGet(*fldobj) );
	return 0;
}



//--------------------------------------------------------------------------------------------
/**
 * bŐڑĂ݂ʂԂ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUnionResultGet( VM_MACHINE * core )
{
	u16 wk_id = VMGetU16( core );

	//z}V̔ėpWX^Ƀ[NIDi[
	core->reg[0] = wk_id;
	//OS_Printf( "[NID = %d\n", wk_id );

	VM_SetWait( core, EvWaitUnionResultGet );
	return 1;
}

//return 1 = I
static BOOL EvWaitUnionResultGet(VM_MACHINE * core)
{
	FIELDSYS_WORK* fsys	= core->fsys;
	u32 ret				= Union_ConnectResultGet( fsys->union_work );
	u16* ret_wk			= GetEventWorkAdrs( fsys, core->reg[0] );	//ӁI

	//r
	if( ret == 0 ){
		return 0;
	}

	*ret_wk = ret;
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * jI[OBJB
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUnionObjAllVanish( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys	 = core->fsys;
	Union_BeaconObjAllVanish( fsys->fldobjsys );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * IljI[Nɓn
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUnionScriptResultSet( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys	 = core->fsys;
	u16 type = VMGetWorkValue(core);
	u16 num = VMGetWorkValue(core);
	Union_ScriptResultGet( fsys->union_work, type, num );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * e@̃X^[g҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUnionParentStartCommandSet( VM_MACHINE * core )
{
	u16 wk_id = VMGetU16( core );

	//z}V̔ėpWX^Ƀ[NIDi[
	core->reg[0] = wk_id;

	VM_SetWait( core, EvWaitUnion_ParentStartCommandSet );
	return 1;
}

//return 1 = I
static BOOL EvWaitUnion_ParentStartCommandSet(VM_MACHINE * core)
{
	u16* ret_wk	= GetEventWorkAdrs( core->fsys, core->reg[0] );	//ӁI
	u32 ret		= Union_ParentStartCommandSet(core->fsys->union_work);

	if( ret >= 1 ){
		*ret_wk = ret;

		// jI[őMeNAi߂Ă̌듮h~pj
		Union_CommWorkClear(core->fsys->union_work);

		return 1;
	}

	*ret_wk = 0;
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * q@̑I҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUnionChildSelectCommandSet( VM_MACHINE * core )
{
	u16 wk_id = VMGetU16( core );

	//z}V̔ėpWX^Ƀ[NIDi[
	core->reg[0] = wk_id;
	
	VM_SetWait( core, EvWaitUnion_ChildSelectCommandSet );
	return 1;
}

//return 1 = I
static BOOL EvWaitUnion_ChildSelectCommandSet(VM_MACHINE * core)
{
	u16* ret_wk	= GetEventWorkAdrs( core->fsys, core->reg[0] );	//ӁI
	u32 ret		= Union_ChildSelectCommandSet(core->fsys->union_work);

	if( ret != 0 ){
		*ret_wk = ret;
		return 1;
	}
	return 0;
}

//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUnionMapChange( VM_MACHINE * core )
{
	EventCmd_UnionRoomMapChange( core->fsys );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * 4̑Ĩg[i[̖OwordsetɊi[
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUnionViewSetUpTrainerTypeSelect( VM_MACHINE * core )
{
	MYSTATUS* my		= SaveData_GetMyStatus( GameSystem_GetSaveData(core->fsys) );
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WORDSET );

	UnionView_SetUpTrainerTypeSelect( MyStatus_GetID(my), MyStatus_GetMySex(my), *wordset );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * I0-3̐g[i[̌ڔԍɕϊ֐
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUnionViewGetTrainerType( VM_MACHINE * core )
{
	MYSTATUS* my	= SaveData_GetMyStatus( GameSystem_GetSaveData(core->fsys) );
	u16 ans			= VMGetWorkValue(core);
	u16* ret_wk		= VMGetWork( core );

	//OS_Printf( "ans = %d\n", ans );
	*ret_wk = UnionView_GetTrainerType( MyStatus_GetID(my), MyStatus_GetMySex(my), ans );
	//OS_Printf( "ret_wk = %d\n", *ret_wk );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[ƂČ鎞̔ԍZbg(jI[p)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUnionViewMyStatusSet( VM_MACHINE * core )
{
	MYSTATUS* my	= SaveData_GetMyStatus( GameSystem_GetSaveData(core->fsys) );
	u16 type		= VMGetWorkValue(core);

	MyStatus_SetTrainerView( my, type );
	return 0;
}


//============================================================================================
//
//	VXetÕQbgAZbg֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * VXetO@}ӓς݂擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSysFlagZukanGet( VM_MACHINE * core )
{
	const ZUKAN_WORK* zw = SaveData_GetZukanWork( core->fsys->savedata );
	u16* ret_wk	= VMGetWork( core );

	*ret_wk = ZukanWork_GetZukanGetFlag( zw );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * VXetO@}ӃZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSysFlagZukanSet( VM_MACHINE * core )
{
	ZUKAN_WORK* zw = SaveData_GetZukanWork( core->fsys->savedata );

	ZukanWork_SetZukanGetFlag( zw );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * VXetO@V[Yς݂擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSysFlagShoesGet( VM_MACHINE * core )
{
	SITUATION *situ;
	PLAYER_SAVE_DATA *jikisave;
	u16* ret_wk	= VMGetWork( core );

	situ = SaveData_GetSituation( core->fsys->savedata );
	jikisave = Situation_GetPlayerSaveData( situ );
	*ret_wk = Player_SaveDataDashCheck( jikisave );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * VXetO@V[YZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSysFlagShoesSet( VM_MACHINE * core )
{
	SITUATION *situ;
	PLAYER_SAVE_DATA *jikisave;

	situ = SaveData_GetSituation( core->fsys->savedata );
	jikisave = Situation_GetPlayerSaveData( situ );
	Player_SaveDataDashSet( jikisave, TRUE );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * VXetO@obWς݂擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSysFlagBadgeGet( VM_MACHINE * core )
{
	u16 no		= VMGetWorkValue( core );		//obW̎
	u16* ret_wk	= VMGetWork( core );

	GF_ASSERT(no < 8)
	*ret_wk = MyStatus_GetBadgeFlag(SaveData_GetMyStatus(core->fsys->savedata), no);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * VXetO@obWZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSysFlagBadgeSet( VM_MACHINE * core )
{
	u16 no		= VMGetWorkValue( core );		//obW̎
	GF_ASSERT(no < 8)
	MyStatus_SetBadgeFlag(SaveData_GetMyStatus(core->fsys->savedata), no);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * VXetO@obOς݂擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSysFlagBagGet( VM_MACHINE * core )
{
	u16* ret_wk	= VMGetWork( core );
	*ret_wk = SysFlag_BagCheck( core->fsys );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * VXetO@obOZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSysFlagBagSet( VM_MACHINE * core )
{
	SysFlag_BagSet( core->fsys );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * VXetO@AtO擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSysFlagPairGet( VM_MACHINE * core )
{
	u16* ret_wk	= VMGetWork( core );
	*ret_wk = SysFlag_PairCheck( core->fsys );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * VXetO@AtOZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSysFlagPairSet( VM_MACHINE * core )
{
	SysFlag_PairSet( core->fsys );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * VXetO@AtOZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSysFlagPairReset( VM_MACHINE * core )
{
	SysFlag_PairReset( core->fsys );
	return 0;
}


//============================================================================================
//
//	thVbv֘A
//
//============================================================================================

//ƂŁAړ邩BB
//
//fp[g̃ACeǗȂǂ͕ʂɂȂ\

//VbvACef[^^
typedef struct{
	u16 itemno;		//ACeio[
	u16 level;		//iK
}SHOP_ITEM_DATA;
#include "..\fielddata\shopdata\shop_item.dat"

#define BADGE_MAX	(8)		//ǂ̋ʒ`ɒuI

//--------------------------------------------------------------------------------------------
/**
 * thVbvĂяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdShopCall( VM_MACHINE * core )
{
	u16 list[64];
	u8 level,badge,count,i;
	u16 id	= VMGetWorkValue(core);

	//
	count = 0;
	badge = 0;
	level = 0;

	//obW擾
	for( i=0; i < BADGE_MAX ;i++ ){
		if( MyStatus_GetBadgeFlag(SaveData_GetMyStatus(core->fsys->savedata), i) == TRUE ){
			badge++;
		}
	}

	//iK擾
	switch( badge ){
	case 0:
		level = 1;
		break;
	case 1:
	case 2:
		level = 2;
		break;
	case 3:
	case 4:
		level = 3;
		break;
	case 5:
	case 6:
		level = 4;
		break;
	case 7:
		level = 5;
		break;
	case 8:
		level = 6;
		break;
	default:
		level = 1;
		break;
	};

	for( i=0; i < SHOP_ITEM_DATA_MAX ;i++ ){
		if( level >= shop_item_data[i].level ){			//iKr
			list[count] = shop_item_data[i].itemno;		//f[^Zbg
			count++;
		}
	}
	list[count] = 0xffff;								//IR[hZbg

	//CxgR[Ȃ̂ŁAXNvgɕA܂B
	ShopInit2( core->event_work, core->fsys, list );
	return 1;
}


//============================================================================================
//
//	Q[I[o[֘A
//
//============================================================================================
extern void GameOverCall( FIELDSYS_WORK* fsys, GMEVENT_CONTROL* event );

//--------------------------------------------------------------------------------------------
/**
 * Q[I[o[Ăяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGameOverCall( VM_MACHINE * core )
{
	//CxgR[Ȃ̂ŁAXNvgɕA܂B
	GameOverCall( core->fsys, core->event_work );
	return 1;
}


//============================================================================================
//
//	[v֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * [vIDZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSetWarpId( VM_MACHINE * core )
{
	u16 id = VMGetWorkValue(core);
	FIELDSYS_WORK* fsys = core->fsys;
	Situation_SetWarpID(SaveData_GetSituation(fsys->savedata), id);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ̐ʎ擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetMySex( VM_MACHINE * core )
{
	MYSTATUS* my		= SaveData_GetMyStatus( GameSystem_GetSaveData(core->fsys) );
	u16* ret_wk			= VMGetWork( core );

	*ret_wk = MyStatus_GetMySex( my );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * |PZ񕜏
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPcKaifuku( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(core->event_work);
	PokeParty_RecoverAll(SaveData_GetTemotiPokemon(fsys->savedata));
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * nNPC_ɔzu 
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUgManShopNpcRandomPlace( VM_MACHINE * core )
{
	UgManagerShopNpcRandomPlace( core->fsys );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ʐM_CNgR[i[̏IJn
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCommDirectEnd( VM_MACHINE * core )
{
	CommDirectEnd();
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * _CNgR[i[[ɓ̏
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCommDirectEnterBtlRoom( VM_MACHINE * core )
{
	CommDirectEnterBattleRoom( core->fsys );
	return 0;
}

//============================================================================================
//
//
//						̂݊֘A
//
//
//============================================================================================
//--------------------------------------------------------------------------------------------
/**
 * @brief	݂̂̏Ԏ擾
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSeedGetStatus(VM_MACHINE * core)
{
	FIELD_OBJ_PTR* fldobj;
	u16 * ret_wk = VMGetWork(core);
	fldobj = GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_TARGET_OBJ );
	*ret_wk = SeedSys_GetSeedStatus(core->fsys, *fldobj);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	݂̂̎ގ擾
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSeedGetType(VM_MACHINE * core)
{
	FIELD_OBJ_PTR* fldobj = GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_TARGET_OBJ );
	u16 * ret_wk = VMGetWork(core);
	*ret_wk = SeedSys_GetSeedTypeItem(core->fsys, *fldobj);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	엿̎ގ擾
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSeedGetCompost(VM_MACHINE * core)
{
	FIELD_OBJ_PTR* fldobj = GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_TARGET_OBJ );
	u16 * ret_wk = VMGetWork(core);
	*ret_wk = SeedSys_GetCompost(core->fsys, *fldobj);
	return 0;
}
//--------------------------------------------------------------------------------------------
/**
 * @brief	y̏Ԏ擾
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSeedGetGroundStatus(VM_MACHINE * core)
{
	FIELD_OBJ_PTR* fldobj = GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_TARGET_OBJ );
	u16 * ret_wk = VMGetWork(core);
	*ret_wk = SeedSys_GetGroundStatus(core->fsys, *fldobj);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	Ă̐擾
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSeedGetNutsCount(VM_MACHINE * core)
{
	FIELD_OBJ_PTR* fldobj = GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_TARGET_OBJ );
	u16 * ret_wk = VMGetWork(core);
	*ret_wk = SeedSys_GetSeedCount(core->fsys, *fldobj);
	return 0;
}
//--------------------------------------------------------------------------------------------
/**
 * @brief		엿܂
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSeedSetCompost(VM_MACHINE * core)
{
	FIELD_OBJ_PTR* fldobj = GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_TARGET_OBJ );
	u16 compost_item = VMGetWorkValue(core);
	SeedSys_SetCompost(core->fsys, *fldobj, compost_item);
	return 0;
}
//--------------------------------------------------------------------------------------------
/**
 * @brief		݂̂A
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSeedSetNuts(VM_MACHINE * core)
{
	FIELD_OBJ_PTR* fldobj = GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_TARGET_OBJ );
	u16 compost_item = VMGetWorkValue(core);
	SeedSys_SetNuts(core->fsys, *fldobj, compost_item);
	return 0;
}
//--------------------------------------------------------------------------------------------
/**
 * @brief		܂
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSeedSetWater(VM_MACHINE * core)
{
	EventCall_SeedWater(core->fsys);
	return 1;
	//FIELD_OBJ_PTR* fldobj = GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_TARGET_OBJ );
	//SeedSys_SetWater(core->fsys, *fldobj);
	//return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		݂̂n
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSeedTakeNuts(VM_MACHINE * core)
{
	u16 count;
	FIELD_OBJ_PTR* fldobj = GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_TARGET_OBJ );
	SeedSys_TakeNuts(core->fsys, *fldobj);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	w|PbgɂȂɂ͂Ă邩`FbN
 * @param	core		z}V\̂ւ̃|C^
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPocketCheck(VM_MACHINE * core)
{
	u16 pocket_id = VMGetWorkValue(core);
	u16 * ret_wk = VMGetWork(core);
	*ret_wk = MyItem_CheckItemPocket(SaveData_GetMyItem(core->fsys->savedata), pocket_id);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	݂̖̂OwordsetɊi[
 * @param	core		z}V\̂ւ̃|C^
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdNutsName(VM_MACHINE * core)
{
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WORDSET );
	u8 idx = VMGetU8(core);				//͂PFߍ݃obt@w
	u16 nuts_id = VMGetWorkValue(core);	//͂QF̂ID
	u16 count = VMGetWorkValue(core);	//͂RF݂̂̐
	STRBUF * buf = NutsNameGetAlloc(nuts_id - NUTS_START_ITEMNUM /* + 1 */, HEAPID_EVENT);
	//{WORDSET_RegisterNutsNameƂˁB
//void WORDSET_RegisterWord( WORDSET* wordset, u32 bufID, const STRBUF* word, u32 sex, BOOL singular_flag, u32 lang )
	WORDSET_RegisterWord(*wordset, idx, buf, PM_MALE, (count < 2? TRUE:FALSE), PM_LANG);
	STRBUF_Delete(buf);
	return 0;
}


//============================================================================================
//
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * SXYf[^̍WύX
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSxyPosChange( VM_MACHINE * core )
{
	u16 id = VMGetWorkValue(core);
	u16 gx = VMGetWorkValue(core);
	u16 gz = VMGetWorkValue(core);

	EventData_NpcDataPosChange( core->fsys, id, gx, gz );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * OBJf[^̍WύX
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdObjPosChange( VM_MACHINE * core )
{
	FIELD_OBJ_PTR fldobj;
	u16 obj_id	= VMGetWorkValue(core);
	u16 x		= VMGetWorkValue(core);
	u16 y		= VMGetWorkValue(core);
	u16 z		= VMGetWorkValue(core);
	u16 dir		= VMGetWorkValue(core);

	//Ώۂ̃tB[hOBJ̃|C^擾
	fldobj	= FieldOBJSys_OBJIDSearch( core->fsys->fldobjsys, obj_id );

	FieldOBJ_GPosDirInit( fldobj, x, y, z, dir );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * SXYf[^̓R[hύX
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSxyMoveCodeChange( VM_MACHINE * core )
{
	u16 id	= VMGetWorkValue(core);
	u16 mv	= VMGetWorkValue(core);

	EventData_NpcDataMoveCodeChange( core->fsys, id, mv );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * SXYf[^̕ύX
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSxyDirChange( VM_MACHINE * core )
{
	u16 id	= VMGetWorkValue(core);
	u16 dir	= VMGetWorkValue(core);

	EventData_NpcDataDirChange( core->fsys, id, dir );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * OBJ̕ύX
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdObjDirChange( VM_MACHINE * core )
{
	FIELD_OBJ_PTR fldobj;
	u16 obj_id	= VMGetWorkValue(core);
	u16 dir		= VMGetWorkValue(core);
	
	//Ώۂ̃tB[hOBJ̃|C^擾
	fldobj	= FieldOBJSys_OBJIDSearch( core->fsys->fldobjsys, obj_id );
	if( fldobj == NULL ){
		GF_ASSERT( (0) && "Ώۂ̃tB[hOBJ̃|C^擾sI" );
	}

	FieldOBJ_DirDispCheckSet( fldobj, dir );
	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * XNvgʂ郏[NɒlZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdReturnScriptWkSet( VM_MACHINE * core )
{
	u16** return_script_wk	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_RETURN_SCRIPT_WK );
	u16 num					= VMGetWorkValue(core);

	if( *return_script_wk != NULL ){
		**return_script_wk = num;
	}
	return 0;
}

/********************************/
/********************************/
/********************************/
/********************************/
/********************************/
/********************************/
/********************************/
/********************************/
/********************************/
/********************************/
/********************************/
/********************************/
/********************************/
/********************************/
/********************************/





#if 0

//=========================================================================
//
//	CxgtO֘A
//
//=========================================================================


//-------------------------------------------------------------------------
//	JE^̃CNg
//-------------------------------------------------------------------------
u8 EvCmdIncRecord( VM_MACHINE * core )
{
	IncRecord( VMGetU8(core) );
	return 0;
}

//=========================================================================
//
//	tB[h֘A
//
//=========================================================================

//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
u8 EvCmdChangeBrightCircle( VM_MACHINE * core )
{
	u8 end;
	end = VMGetU8(core);
	StartFieldLasterChange( end );
	StopFieldScript();
	return 1;
}

//-------------------------------------------------------------------------
//	邳̕ύX
//-------------------------------------------------------------------------
u8 EvCmdChangeBrightValue( VM_MACHINE * core )
{
	SetBright( VMGetWorkValue(core) ); 
	return 0;
}

//-------------------------------------------------------------------------
//	tF[h̐
//-------------------------------------------------------------------------
/* tF[hIĎ */
static BOOL EvWaitFadeEnd(void)
{
	if( FadeData.fade_sw == 0 )return TRUE;
	return FALSE;
}

u8 EvCmdFieldFade( VM_MACHINE * core )
{
	u8 type;
	type = VMGetU8(core);
	FieldFadeControl( type , 0 );
	VM_SetWait( core, EvWaitFadeEnd );
	return 1;
}

//tF[hxw
u8 EvCmdFieldFadeWait( VM_MACHINE * core )
{
	u8 type,wait;
	type = VMGetU8(core);
	wait = VMGetU8(core);
	FieldFadeControl( type , wait );
	VM_SetWait( core, EvWaitFadeEnd );
	return 1;
}

//tF[hiʂƂ̑Jڂł͂ȂtB[hoƂčsꍇj
extern u16 PaletteWorkTmp[];
u8 EvCmdFieldFadeEx(VM_MACHINE *core)
{
	u8 type,out;
	u16	col;
	type = VMGetU8(core);

	switch(type){
	case FIELD_BLACK_IN:
		col = 0x0000;
		out = 0;
		break;
	case FIELD_WHITE_IN:
		col = 0xffff;
		out = 0;
		break;
	case FIELD_WHITE_OUT:
		col = 0xffff;
		out = 1;
		break;
	case FIELD_BLACK_OUT:
	default:
		col = 0x0000;
		out = 1;
		break;
	}


	if(out){
		CpuCopy(PaletteWork, PaletteWorkTmp, 0x400, 32);
		FieldFadeControl(type, 0);
//		WeatherFadeStop();
	}else{
		CpuCopy(PaletteWorkTmp, PaletteWork, 0x400, 32);
		FieldFadeControl(type, 0);
//		WeatherFadeStart();
	}

	VM_SetWait( core, EvWaitFadeEnd );
	return 1;
}

//-------------------------------------------------------------------------
//	Q[Ԃ̃Zbg
//-------------------------------------------------------------------------
u8 EvCmdSetGameTime( VM_MACHINE * core )
{
	u8 hour,min;
	hour = VMGetWorkValue(core);
	min = VMGetWorkValue(core);
	SetGameTime( hour, min );
	return 0;
}

//-------------------------------------------------------------------------
//	Q[Ԃ̍XV
//	Q[ԃ`FbNtOXVĂяo
//-------------------------------------------------------------------------
u8 EvCmdUpdateGameTime( VM_MACHINE * core )
{
	UpdateTimeEvent();
	return 0;
}

//-------------------------------------------------------------------------
//	Q[Ԃ̎擾(RG0,RG1,RG2ɑ)
//-------------------------------------------------------------------------
u8 EvCmdGetGameTime( VM_MACHINE * core )
{
	GetGameTime();
	ScriptRegister0 = (u16)GameTime.hour;
	ScriptRegister1 = (u16)GameTime.min;
	ScriptRegister2 = (u16)GameTime.sec;
	return 0;
}

//-------------------------------------------------------------------------
//	}bvŗL̃GtFNg̐ݒ
//-------------------------------------------------------------------------
u8 EvCmdSetMapEffect( VM_MACHINE * core )
{
	SetMapEffectControl( VMGetU8(core) );
	return 0;
}

//-------------------------------------------------------------------------
//	}bvXN[̐؂ւ
//	FLAG_CHANGE_LABEL̃xő삷邱
//-------------------------------------------------------------------------
u8 EvCmdChangeMapScreen( VM_MACHINE * core )
{
	u16 id = VMGetWorkValue(core);
	ChangeNowMapScreen( id );
	return 0;
}

//=========================================================================
//
//	}bvJ
//
//=========================================================================

//-------------------------------------------------------------------------
//	}bvJ
//-------------------------------------------------------------------------
#if 0
u8 EvCmdMapChange( VM_MACHINE * core )			/* EVCMD_MAP_CHANGE */
{
	u8  div,map,exit;
	u16 x,y;

	div = VMGetU8(core);
	map = VMGetU8(core);
	exit = VMGetU8(core);
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);

	NextMapSetDirect( div, map, exit, (u8)x, (u8)y );
	AddMapChangeTask();
	InitHeroLastStatus();
	return 1;
}
#endif

//-------------------------------------------------------------------------
//	}bvJ(SEȂ)
//-------------------------------------------------------------------------
u8 EvCmdMapChangeSeNot( VM_MACHINE * core )			/* EVCMD_MAP_CHG_SENOT */
{
	u8  div,map,exit;
	u16 x,y;

	div = VMGetU8(core);
	map = VMGetU8(core);
	exit = VMGetU8(core);
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);

	NextMapSetDirect( div, map, exit, (u8)x, (u8)y );
	AddMapChangeSeNotTask();
	InitHeroLastStatus();
	return 1;
}

//-------------------------------------------------------------------------
//	hAɓă}bvJ
//-------------------------------------------------------------------------
u8 EvCmdDoorMapChange( VM_MACHINE * core )			/* EVCMD_DOORMAP_CHANGE */
{
	u8  div,map,exit;
	u16 x,y;

	div = VMGetU8(core);
	map = VMGetU8(core);
	exit = VMGetU8(core);
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);

	NextMapSetDirect( div, map, exit, (u8)x, (u8)y );
	AddDoorMapChangeTask();
	InitHeroLastStatus();
	return 1;
}

//-------------------------------------------------------------------------
//	ɂ}bvJ
//-------------------------------------------------------------------------
u8 EvCmdMapChangeFall( VM_MACHINE * core )
{
	u8  div,map;
	u16 x,y;

	div = VMGetU8(core);
	map = VMGetU8(core);
	GetHeroCellPos( &x, &y );

	if ( div == 0xff && map == 0xff ) {
		NextMapSetByPitfall( x - MAP_X_MARGIN, y - MAP_Y_MARGIN );
	} else {
		NextMapSetDirect( div, map, NO_EXIT_ID,
				x - MAP_X_MARGIN, y - MAP_Y_MARGIN );
	}
	AddMapChangeFallTask();
	InitHeroLastStatus();

	return 1;
}

//-------------------------------------------------------------------------
//	[vɂ}bvJ
//-------------------------------------------------------------------------
u8 EvCmdMapChangeWarp( VM_MACHINE * core )
{
	u8  div,map,exit;
	u16 x,y;

	div = VMGetU8(core);
	map = VMGetU8(core);
	exit = VMGetU8(core);
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);

	NextMapSetDirect( div, map, exit, (u8)x, (u8)y );
	AddMapChangeWarpTask();
	InitHeroLastStatus();
	return 1;
}

//-------------------------------------------------------------------------
//	[vɂ}bvJ	OBJʒuێ
//-------------------------------------------------------------------------
u8 EvCmdMapChangeKeepWarp( VM_MACHINE * core )
{
	u8  div,map,exit;
	u16 x,y;

	div = VMGetU8(core);
	map = VMGetU8(core);
	exit = VMGetU8(core);
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);

	NextMapSetDirect( div, map, exit, (u8)x, (u8)y );
	AddMapChangeKeepWarpTask();
	InitHeroLastStatus();
	return 1;
}

//-------------------------------------------------------------------------
//	}bvJڐZbg
//-------------------------------------------------------------------------
u8 EvCmdSetMapChangePos( VM_MACHINE * core )
{
	u8  div,map,exit;
	u16 x,y;

	div = VMGetU8(core);
	map = VMGetU8(core);
	exit = VMGetU8(core);
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);

	NextMapSetDirect( div, map, exit, (u8)x, (u8)y );
	return 0;
}

//-------------------------------------------------------------------------
//	ڑZbg
//-------------------------------------------------------------------------
u8 EvCmdSetSPMapID( VM_MACHINE * core )
{
	u8  div,map,exit;
	u16 x,y;

	div = VMGetU8(core);
	map = VMGetU8(core);
	exit = VMGetU8(core);
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);

	SetSpecialMapDirect( 0, div, map, exit, (u8)x, (u8)y );
	return 0;
}

//-------------------------------------------------------------------------
//	_CrOڑZbg
//-------------------------------------------------------------------------
u8 EvCmdSetDivingMapID( VM_MACHINE * core )
{
	u8  div,map,exit;
	u16 x,y;

	div = VMGetU8(core);
	map = VMGetU8(core);
	exit = VMGetU8(core);
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);

	SetDivingMapDirect( div, map, exit, (u8)x, (u8)y );
	return 0;
}

//-------------------------------------------------------------------------
//	ƂڑZbg
//-------------------------------------------------------------------------
u8 EvCmdSetPitfallMapID( VM_MACHINE * core )
{
	u8  div,map,exit;
	u16 x,y;

	div = VMGetU8(core);
	map = VMGetU8(core);
	exit = VMGetU8(core);
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);

	SetPitfallMapDirect( div, map, exit, (u8)x, (u8)y );
	return 0;
}

//-------------------------------------------------------------------------
//	Jڐ̃Zbg
//-------------------------------------------------------------------------
u8 EvCmdSetEscapeMapID( VM_MACHINE * core )
{
	u8  div,map,exit;
	u16 x,y;

	div = VMGetU8(core);
	map = VMGetU8(core);
	exit = VMGetU8(core);
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);

	EscapeMapSetDirect( div, map, exit, (u8)x, (u8)y );
	return 0;
}
//=========================================================================
//
//	yErd֘A
//
//=========================================================================

//=========================================================================
//
//	nai֘A
//
//=========================================================================
static u16 ScriptAnimeObjNumber = 0;
static u16 ScriptAnimeDivID = 0;
static u16 ScriptAnimeMapID = 0;

//-------------------------------------------------------------------------
//	naiAj̃Zbg
//-------------------------------------------------------------------------
u8 EvCmdObjAnime(VM_MACHINE * core)				/* EVCMD_OBJANIME */
{
	u16 obj_id;
	ACMD_CODE *adrs;
	
	obj_id = VMGetWorkValue(core);
	adrs = (ACMD_CODE *)VMGetU32(core);
	AnmCmdSet( (u8)obj_id, (u8)fld->MapID.map_id, (u8)fld->MapID.div_id, adrs );
	ScriptAnimeObjNumber = obj_id;
	return 0;
};

//div,mapIDw肷
u8 EvCmdObjAnimeSP(VM_MACHINE * core)				/* EVCMD_OBJANIMESP */
{
	u8  div_id,map_id;
	u16 obj_id;
	ACMD_CODE *adrs;
	
	obj_id = VMGetWorkValue(core);
	adrs = (ACMD_CODE *)VMGetU32(core);
	div_id = VMGetU8(core);
	map_id = VMGetU8(core);
	AnmCmdSet( (u8)obj_id, map_id, div_id, adrs );
	ScriptAnimeObjNumber = obj_id;
	return 0;
};

//-------------------------------------------------------------------------
//	naiAjI҂
//-------------------------------------------------------------------------
static BOOL EvWaitAnimeEnd(void)
{
	/* ߂l ==1:I@==0:쒆 */
	return AnmCmdEnd(ScriptAnimeObjNumber,ScriptAnimeMapID,ScriptAnimeDivID);
};

u8 EvCmdObjAnimeWait(VM_MACHINE * core)			/* EVCMD_OBJANIMEWAIT */
{
	u16 val = VMGetWorkValue(core);
	if( val != 0 )ScriptAnimeObjNumber = val;
	ScriptAnimeDivID = fld->MapID.div_id;
	ScriptAnimeMapID = fld->MapID.map_id;

	VM_SetWait( core, EvWaitAnimeEnd );
	return 1;
};

//div,mapIDw肷
u8 EvCmdObjAnimeWaitSP(VM_MACHINE * core)			/* EVCMD_OBJANIMEWAITSP */
{
	u8  div_id,map_id;
	u16 val = VMGetWorkValue(core);
	if( val != 0 )ScriptAnimeObjNumber = val;

	div_id = VMGetU8(core);
	map_id = VMGetU8(core);
	ScriptAnimeDivID = div_id;
	ScriptAnimeMapID = map_id;

	VM_SetWait( core, EvWaitAnimeEnd );
	return 1;
};

//-------------------------------------------------------------------------
//	naȉ
//-------------------------------------------------------------------------
u8 EvCmdObjDel(VM_MACHINE * core)					/* EVCMD_OBJDEL */
{
	u16 obj_id;

	obj_id = VMGetWorkValue(core);
	EvObjDelId( (u8)obj_id, (u8)fld->MapID.map_id, (u8)fld->MapID.div_id );
	return 0;
};

//div,mapIDw肷
u8 EvCmdObjDelSP(VM_MACHINE * core)					/* EVCMD_OBJDELSP */
{
	u16 obj_id;
	u8  div_id,map_id;

	obj_id = VMGetWorkValue(core);
	div_id = VMGetU8(core);
	map_id = VMGetU8(core);

	EvObjDelId( (u8)obj_id, map_id, div_id );
	return 0;
};

//-------------------------------------------------------------------------
//	nai̕\
//-------------------------------------------------------------------------
u8 EvCmdObjAppear(VM_MACHINE * core)				/* EVCMD_OBJAPPEAR */
{
	u16 obj_id;

	obj_id = VMGetWorkValue(core);
	EvObjAddId( (u8)obj_id, (u8)fld->MapID.map_id, (u8)fld->MapID.div_id );
	return 0;
};

//div,mapIDw肷
u8 EvCmdObjAppearSP(VM_MACHINE * core)				/* EVCMD_OBJAPPEARSP */
{
	u16 obj_id;
	u8  div_id,map_id;

	obj_id = VMGetWorkValue(core);
	div_id = VMGetU8(core);
	map_id = VMGetU8(core);
	EvObjAddId( (u8)obj_id, map_id, div_id );
	return 0;
};

//-------------------------------------------------------------------------
//	nai\ʒu̕ύX
//-------------------------------------------------------------------------
u8 EvCmdObjPosChg( VM_MACHINE * core )			/* EVCMD_OBJ_POSCHG */
{
	u16 id,x,y;

	id = VMGetWorkValue(core);
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);
	EvObjPosAllChgId( (u8)id, (u8)fld->MapID.map_id, (u8)fld->MapID.div_id, (s16)x, (s16)y );
	return 0;
}

//-------------------------------------------------------------------------
//	݂OBJʒuɂ킹SXYf[^̍WXV
//-------------------------------------------------------------------------
u8 EvCmdSxyPosOverWrite( VM_MACHINE * core )
{
	u16 id;

	id = VMGetWorkValue(core);
	EvObjSxyIdPosChange( (u8)id, (u8)fld->MapID.map_id, (u8)fld->MapID.div_id );
	return 0;
}

//-------------------------------------------------------------------------
//	naivCIeB̕ύX
//-------------------------------------------------------------------------
u8 EvCmdObjPriChg( VM_MACHINE * core )			/* EVCMD_OBJPRICHG */
{
	u16 id;
	u8	div,map,pri;

	id = VMGetWorkValue(core);
	div = VMGetU8(core);
	map = VMGetU8(core);
	pri = VMGetU8(core);

	EvObjPriChg( (u8)id, map, div, EVOBJ_ACTPRI0 + pri );
	return 0;
}

//-------------------------------------------------------------------------
//	naivCIeBʒuɏC
//-------------------------------------------------------------------------
u8 EvCmdObjPriOff( VM_MACHINE * core )			/* EVCMD_OBJPRIOFF */
{
	u16 id;
	u8	div,map;

	id = VMGetWorkValue(core);
	div = VMGetU8(core);
	map = VMGetU8(core);

	EvObjPriChgOff( (u8)id, map, div );
	return 0;
}

//--------------------------------------------------------------------
//	b|naiɎ@̕
//--------------------------------------------------------------------
u8 EvCmdObjSiteToHero( VM_MACHINE * core )
{
	if (EvObj[TargetObjNo].sw == 1) {
		AcmdCodeTurnSiteSet( &EvObj[TargetObjNo], GetHeroSite() );
	}
	return 0;
}
//-------------------------------------------------------------------------
//	tB[hOBJ_~[ANgǉ
//-------------------------------------------------------------------------
u8 EvCmdObjDmyActAdd( VM_MACHINE * core )	
{
	u8 code,id,h,site;
	u16	x,y;

	code	= VMGetU8(core);
	id		= VMGetU8(core);
	x		= VMGetWorkValue(core);
	y		= VMGetWorkValue(core);
	h		= VMGetU8(core);
	site	= VMGetU8(core);

	EvObjDmyAddAct( code, id, (s16)x, (s16)y, h, site );
	return 0;
}

//-------------------------------------------------------------------------
//	tB[hOBJ_~[ANgύX
//-------------------------------------------------------------------------
u8 EvCmdObjDmySiteChg( VM_MACHINE * core )	
{
	u16 id;
	u8	site;

	id		= VMGetU8(core);
	site	= VMGetU8(core);
	
	EvObjDmyActSiteChg( id, site );
	return 0;
}

//=========================================================================
//
//	bZ[WEEBhE֘A
//
//=========================================================================

//-------------------------------------------------------------------------
//	XNvgEBhE			01/09/26 nohara
//-------------------------------------------------------------------------
u8 EvCmdSelectWin(VM_MACHINE * core)		/* EVCMD_SELECTWIN */
{
	u8 x,y,no,check;

	x  = VMGetU8(core);						//8bit(1byte)f[^擾
	y  = VMGetU8(core);
	no = VMGetU8(core);
	check = VMGetU8(core);					//BLZL肩

	if( AddScriptEvWinTask(x,y,no,check) == TRUE )
	{
		StopFieldScript();
		return 1;
	};
	return 0;
};

//J[\ʒuw
u8 EvCmdSelectWinCsr(VM_MACHINE * core)		/* EVCMD_SELECTWINCSR */
{
	u8 x,y,no,check,csr;

	x  = VMGetU8(core);						//8bit(1byte)f[^擾
	y  = VMGetU8(core);
	no = VMGetU8(core);
	csr = VMGetU8(core);
	check = VMGetU8(core);					//BLZL肩

	if( AddScriptEvWinCsrTask(x,y,no,check,csr) == TRUE )
	{
		StopFieldScript();
		return 1;
	};
	return 0;
};

//-------------------------------------------------------------------------
//	cXNvgEBhE	02/01/17 nohara
//-------------------------------------------------------------------------
u8 EvCmdHVWin(VM_MACHINE * core)		/* EVCMD_HVWIN */
{
	u8 x,y,no,arrange,check;

	x  = VMGetU8(core);						//8bit(1byte)f[^擾
	y  = VMGetU8(core);
	no = VMGetU8(core);
	arrange = VMGetU8(core);				//ו
	check = VMGetU8(core);					//BLZL肩

	if( AddScriptEvHVWinTask(x,y,no,check,arrange) == TRUE )
	{
		//VM_SetWait( core, EvWaitYesNoEnd );
		StopFieldScript();
		return 1;
	};
	return 0;
};

//-------------------------------------------------------------------------
//	XNvg@j[(EBhEȂ)
//-------------------------------------------------------------------------
u8 EvCmdSelectMenu(VM_MACHINE * core)		/* EVCMD_MENUWRITE */
{
	//gps@mFĂȂ߁I
	u8 x,y,no,check;

	x  = VMGetU8(core);						//8bit(1byte)f[^擾
	y  = VMGetU8(core);
	no = VMGetU8(core);
	check = VMGetU8(core);					//BLZL肩

	/*
	if( AddScriptEvMenuTask(x,y,no,check) == TRUE )
	{
		StopFieldScript();
		return 1;
	};
	*/
	return 0;
};

//-------------------------------------------------------------------------
//	|Pbf\EBhE
//-------------------------------------------------------------------------
u8 EvCmdPokeCGWinOpen(VM_MACHINE * core)		/* EVCMD_POKECGWINOPEN */
{
	u16 no;
	u8	x,y;

	no = VMGetWorkValue(core);
	x = VMGetU8(core);
	y = VMGetU8(core);
	FieldPokeCGWinOpen(no,x,y);
	return 0;
};

u8 EvCmdPokeCGWinErase(VM_MACHINE * core)		/* EVCMD_POKECGWINERASE */
{
	void * res;
	res = FieldPokeCGWinClose();
	if( res == NULL )return 0;
	VM_SetWait( core, res );
	return 1;
};

//-------------------------------------------------------------------------
//	G\т
//	fobO@\𗬗pbŁB
//-------------------------------------------------------------------------
extern void PortraitPictureSet( int number );
u8 EvCmdPutPortrait( VM_MACHINE * core )
{
	u8 number;
	number = VMGetU8(core);
	if ( number != 0 ) PortraitPictureSet( number );
	PortraitPicturePut();

	StopFieldScript();
	return 1;
}

//-------------------------------------------------------------------------
//	_bZ[W\
//-------------------------------------------------------------------------
u8 EvCmdTenjiMsgPut( VM_MACHINE * core )
{
	BMPWIN_DAT	data;
	u8 x1,y1,x2,y2,mx,my;
	u8 x,y,sx,sy,msg_x,msg_y;
	const u8 * adrs;

	adrs = (const u8 *)VMGetU32(core);
	x1 = adrs[0]; y1 = adrs[1]; x2 = adrs[2]; y2 = adrs[3];
	mx = adrs[4]; my = adrs[5];
	//PM_TenjiExpand( MsgExpandBuffer, adrs+6 );
	PM_MsgExpand( MsgExpandBuffer, adrs+6 );
	x = x1+1;
	y = y1+1;
	sx = (x2 - x1) - 1;
	sy = (y2 - y1) - 1;
	msg_x = ((mx - x1) - 1)*8;
	msg_y = ((my - y1) - 1)*8;
	
	data = MakeBmpWinData(BGL_FRAME_0 ,  x, y, sx, sy, FMENU_WIN_PAL, TENJI_WIN_CHR);
	TenjiWinIndex = (u8)BMPWIN_SysAdd( &data );

	BmpNWinSaveTypeSet( TenjiWinIndex, FBMP_NWIN_CGXNUM, PA_BG14 );	// j[EBhE
	FieldBitMapWinWrite( TenjiWinIndex, FBMP_TRANS_OFF );// EChE`
	BMPWIN_WindowOn( TenjiWinIndex );
	BMPWIN_Clear(TenjiWinIndex,0x11);
	MSG_Print(TenjiWinIndex,POKE_TENJI,MsgExpandBuffer,msg_x,msg_y,MSG_NO_PUT,NULL);//_\͂QhbgItZbgȂ
	BMPWIN_DispOn(TenjiWinIndex,BMPWIN_ALLTRANS);	//XN[L]
	return 0;
}

//-------------------------------------------------------------------------
//	_bZ[WNA
//-------------------------------------------------------------------------
u8 EvCmdTenjiClear( VM_MACHINE * core )
{
	ClearTenji();
//	FieldBitMapWinClear(TenjiWinIndex,FBMP_TRANS_ON);
//	BMPWIN_SysDel( TenjiWinIndex );
	return 0;
}

//-------------------------------------------------------------------------
//	blrfZbg
//-------------------------------------------------------------------------
u8 EvCmdTalkMsgRelative( VM_MACHINE * core )
{
	u32 msg;
	msg = GET_REL_ADRS( VMGetU32(core) );
//	if( (u32)msg == 0 )msg = (VM_CODE *)(core->reg[0]);
	FieldMsgSet( (const u8 *)msg );
	return 0;
}

//=========================================================================
//
//	擾
//
//=========================================================================

static BOOL * const buf_list[] =
{
	StrTempBuffer0,
	StrTempBuffer1,
	StrTempBuffer2,
};

//-------------------------------------------------------------------------
//	|P擾
//-------------------------------------------------------------------------
u8 EvCmdGetMonsName(VM_MACHINE * core)				/* EVCMD_GETMONSNAME */
{
	u8 buf;
	u16 mons;

	buf = VMGetU8(core);
	mons = VMGetWorkValue(core);
	PM_strcpy( buf_list[buf], PokeNameData[mons] );
	return 0;
};

//-------------------------------------------------------------------------
//	^}S𔲂擪̃|P̖O擾
//-------------------------------------------------------------------------
u8 EvCmdGetTemotiMonsName(VM_MACHINE * core)			/* EVCMD_GETTEMOTIMONSNAME */
{
	u8 buf;

	buf = VMGetU8(core);
	PM_strcpy( buf_list[buf], 
			PokeNameData[PokeParaGet(&PokeParaMine[GetTemotiBtlPokeNum()],ID_monsno,0)] );
	return 0;
};

//-------------------------------------------------------------------------
//	jbNl[擾
//-------------------------------------------------------------------------
u8 EvCmdGetNickName(VM_MACHINE * core)				/* EVCMD_GETNICKNAME */
{
	u8 buf;
	u16 no;

	buf = VMGetU8(core);
	no = VMGetWorkValue(core);
	PokeParaGet( &PokeParaMine[no], ID_nickname, buf_list[buf] );
	NickNameCutOff( buf_list[buf] );
	return 0;
};

//-------------------------------------------------------------------------
//	ACe擾
//-------------------------------------------------------------------------
u8 EvCmdGetItemName(VM_MACHINE * core)				/* EVCMD_GETITEMNAME */
{
	u8 buf;
	u16 item;

	buf = VMGetU8(core);
	item = VMGetWorkValue(core);
	GetItemName( item, buf_list[buf] );				//؂̎擾p
	return 0;
};

//-------------------------------------------------------------------------
//	ObY擾
//-------------------------------------------------------------------------
u8 EvCmdGetGoodsName(VM_MACHINE * core)				/* EVCMD_GETGOODSNAME */
{
	u8 buf;
	u16 goods;

	buf = VMGetU8(core);
	goods = VMGetWorkValue(core);

	PM_strcpy(buf_list[buf], base_goods[goods].name );

	return 0;
};

//-------------------------------------------------------------------------
//	Z擾
//-------------------------------------------------------------------------
u8 EvCmdGetWazaName(VM_MACHINE * core)				/* EVCMD_GETWAZANAME */
{
	u8 buf;
	u16 waza;

	buf = VMGetU8(core);
	waza = VMGetWorkValue(core);
	PM_strcpy( buf_list[buf], &WazaNameData[waza][0] );
	return 0;
};

//-------------------------------------------------------------------------
//	擾
//-------------------------------------------------------------------------
u8 EvCmdGetNumMsg(VM_MACHINE * core)			/* EVCMD_GETNUMMSG */
{
	u8 buf,keta = 1;
	u16 num;

	buf = VMGetU8(core);
	num = VMGetWorkValue(core);
	keta = GetNumKeta(num);

	//lߌŒɂĂ
	PM_NumMsgSet( buf_list[buf], (int)num, NUM_MODE_LEFT, keta);

	return 0;
};

//-------------------------------------------------------------------------
//	ev_winɂ镶擾
//-------------------------------------------------------------------------
u8 EvCmdSetBuf(VM_MACHINE * core)				/* EVCMD_SETBUF */
{
	u8 buf;
	u16 no;

	buf = VMGetU8(core);
	no = VMGetWorkValue(core);
	PM_strcpy( buf_list[buf], msg_data_buf[no] );
	return 0;
};

//-------------------------------------------------------------------------
//	w蕶obt@ɃRs[
//-------------------------------------------------------------------------
u8 EvCmdCopyBuf( VM_MACHINE * core )
{
	u8 buf_no;
	const u8 * str;

	buf_no = VMGetU8(core);
	str = (const u8 *)VMGetU32(core);
	PM_strcpy( buf_list[buf_no], str );

	return 0;
}

//----------------------------------------------------------------------------------------------
/**
 * {bNX擾
 *
 * @li	{bNXio[VMGetWorkValuegp
 */
//----------------------------------------------------------------------------------------------
u8 EvCmdGetBoxName(VM_MACHINE * core)				/* EVCMD_GETBOXNAME */
{
	u8 buf;
	u16 box;

	buf = VMGetU8(core);
	box = VMGetWorkValue(core);
	PM_strcpy( buf_list[buf], BoxData_BoxNameAdrs(box) );

	return 0;
};

//=========================================================================
//
//	퓬֘A
//
//=========================================================================
//-------------------------------------------------------------------------
//	g[i[̐ݒ
//-------------------------------------------------------------------------
u8 EvCmdTrainerDataSet( VM_MACHINE * core )
{
	core->PC = (VM_CODE *) SetTrainerDataByAdrs( core->PC );
	return 0;
}

//-------------------------------------------------------------------------
//	g[i[Jn
//-------------------------------------------------------------------------
u8 EvCmdTrainerFightStart( VM_MACHINE * core )
{
	FieldTrainerFightStart();
	return 1;
}

//-------------------------------------------------------------------------
//	g[i[ς݂̏ꍇ̃XNvg֕
//-------------------------------------------------------------------------
u8 EvCmdTrainerAfterScript( VM_MACHINE * core )
{
	core->PC = GetTrainerAfterScript();
	return 0;
}

//-------------------------------------------------------------------------
//	g[i[ĨXNvg֕
//-------------------------------------------------------------------------
u8 EvCmdTrainerBattleEndScript( VM_MACHINE * core )
{
	core->PC = GetTrainerBattleEndScript();
	return 0;
}

//-------------------------------------------------------------------------
//	g[i[IDtO`FbN
//-------------------------------------------------------------------------
u8 EvCmdTrainerFlagCheck( VM_MACHINE * core )
{
	core->cmp_flag = CheckTrainerFlagByID( VMGetWorkValue(core) );
	return 0;
}

//-------------------------------------------------------------------------
//	g[i[IDtOZbg
//-------------------------------------------------------------------------
u8 EvCmdTrainerFlagSet( VM_MACHINE * core )
{
	SetTrainerFlagByID( VMGetWorkValue(core) );
	return 0;
}

//-------------------------------------------------------------------------
//	g[i[IDtOZbg
//-------------------------------------------------------------------------
u8 EvCmdTrainerFlagReset( VM_MACHINE * core )
{
	ResetTrainerFlagByID( VMGetWorkValue(core) );
	return 0;
}

//-------------------------------------------------------------------------
//	쐫|P̃f[^Zbg
//-------------------------------------------------------------------------
u8 EvCmdWildFightSet( VM_MACHINE * core )
{
	u16 pokeno,itemno;
	u8 level;
	pokeno = VMGetU16(core);
	level = VMGetU8(core);
	itemno = VMGetU16(core);
	ScrEncountPokeSet( pokeno, level, itemno );
	return 0;
}

//-------------------------------------------------------------------------
//	쐶|PƂ̃GJEgJn
//-------------------------------------------------------------------------
extern void StartScriptEncountEvent(void);

u8 EvCmdWildFightStart( VM_MACHINE * core )
{
	StartScriptEncountEvent();
	StopFieldScript();
	return 1;
}

//=========================================================================
//
//	ʂ̃Cxg֘ÃXNvgR}h
//
//=========================================================================

//-------------------------------------------------------------------------
//
//	Xbg}V[̌Ăяo
//
//-------------------------------------------------------------------------
extern void FieldScriptRecover(void);

u8 EvCmdSlotMachine( VM_MACHINE * core )
{
	Slot( VMGetWorkValue(core), FieldScriptRecover );
	StopFieldScript();
	return 1;
}

//-------------------------------------------------------------------------
//
//	݂̂A鏈
//
//-------------------------------------------------------------------------
#define SET_SEED_USER_ID	0			//̒`͎gpĂӏȂI

u8 EvCmdSetSeed( VM_MACHINE * core )
{
	u8 bed_no,type,growth;
	bed_no = VMGetU8(core);
	type = VMGetU8(core);
	growth = VMGetU8(core);

	if( type == SET_SEED_USER_ID )
	{
		//^Cv߂鏈
		//GetSeedType();
		SeedBedSet( bed_no, type, growth, FALSE );
	}else
	{
		SeedBedSet( bed_no, type, growth, FALSE );
	}
	return 0;
}

//-------------------------------------------------------------------------
//	CMf[^JÃ`FbN
//-------------------------------------------------------------------------
u8 EvCmdCMEventStartChk(VM_MACHINE * core)					
{
	u16 type;

	type = VMGetWorkValue(core);
	*ret_wk = (u16)CMEventStartChk((u8)type);
	return 0;
}

static u16 ScriptFldEffCodeNumber = 0;
//-------------------------------------------------------------------------
//	tB[hGtFNgĂ			02/01/24 nohara
//-------------------------------------------------------------------------

u8 EvCmdSetFldEff( VM_MACHINE * core )
{
	u16 no;
	no = VMGetWorkValue(core);
	ScriptFldEffCodeNumber = no;
	FldEffSet( (u8)no );
	return 0;
};

//-------------------------------------------------------------------------
//	tB[hGtFNg̃[NɒlZbg@2002/01/24 by nakahiro
//-------------------------------------------------------------------------
u8 EvCmdSetFEWork( VM_MACHINE * core )
{
	u8	no;
	u16	param;

	no = VMGetU8(core);
	param = VMGetWorkValue(core);
	FeSetWork[no] = (s16)param;
	return 0;
}

//-------------------------------------------------------------------------
//	tB[hGtFNgI҂		02/01/25 nohara
//-------------------------------------------------------------------------
static BOOL EvWaitFldEffEnd(void)
{
	/* ߂l ==1:I@==0:쒆 */
	if( FeCodeChk((u8)ScriptFldEffCodeNumber) == 0 ) return 1;	//I
	else	return 0;
};

u8 EvCmdFldEffWait(VM_MACHINE * core)	/* EVCMD_FLDEFFWAIT */
{
	u16 code = VMGetWorkValue(core);
	ScriptFldEffCodeNumber = code;
	VM_SetWait( core, EvWaitFldEffEnd );
	return 1;
};


//-------------------------------------------------------------------------
//	wʒuɃZZbg			02/02/15 nohara
//-------------------------------------------------------------------------
u8 EvCmdSetCell( VM_MACHINE * core )
{
	u16 x,y,code,hitchk;
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);
	code = VMGetWorkValue(core);
	hitchk = VMGetWorkValue(core);

	x += MAP_X_MARGIN;
	y += MAP_Y_MARGIN;
	if( hitchk == 0 )	SetCell( x, y , code );
	else	SetCell( x, y , code | CELL_HITCHECK_MASK );

	return 0;
};

//-------------------------------------------------------------------------
//	hAAjĂяo				02/06/01 nohara
//-------------------------------------------------------------------------
extern void AddCloseDoorAnimeTask( int, int );
extern void AddOpenDoorAnimeTask( int, int );
extern void CloseDoorCellSet( int, int );
extern void OpenDoorCellSet( int, int );
extern u16 GetDoorSENumber(int px, int py);

//Aj[VL(J)
u8 EvCmdOpenDoorAnime( VM_MACHINE * core )
{
	u16 x,y;
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);

	x += MAP_X_MARGIN;
	y += MAP_Y_MARGIN;
	
	SePlay( GetDoorSENumber(x,y) );
	AddOpenDoorAnimeTask( (int)x, (int)y );		//
	return 0;
}

//Aj[VL(߂)
u8 EvCmdCloseDoorAnime( VM_MACHINE * core )
{
	u16 x,y;
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);

	x += MAP_X_MARGIN;
	y += MAP_Y_MARGIN;
	
	AddCloseDoorAnimeTask( (int)x, (int)y );	//߂
	return 0;
}

//hAAj[VI҂
extern u8 CheckDoorAnime();
static BOOL EvWaitDoorAnimeEnd(void)
{
	/* ߂l ==1:I@==0:쒆 */
	if ( CheckDoorAnime() == FALSE ) return TRUE;
	else return FALSE;
}

u8 EvCmdDoorAnimeWait( VM_MACHINE * core )
{
	VM_SetWait( core, EvWaitDoorAnimeEnd );
	return 1;
}

//JĂhÃZZbg
u8 EvCmdOpenDoorSet( VM_MACHINE * core )
{
	u16 x,y;
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);

	x += MAP_X_MARGIN;
	y += MAP_Y_MARGIN;
	
	OpenDoorCellSet( (int)x, (int)y );			
	return 0;
}

//܂ĂhÃZZbg
u8 EvCmdCloseDoorSet( VM_MACHINE * core )
{
	u16 x,y;
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);

	x += MAP_X_MARGIN;
	y += MAP_Y_MARGIN;
	
	CloseDoorCellSet( (int)x, (int)y );
	return 0;
}

//-------------------------------------------------------------------------
//
//	Gx[^̌Ăяo
//
//-------------------------------------------------------------------------
extern void ElevatorSet(u8,u8,u8,u8);
extern void ElevatorStart();

u8 EvCmdElevatorSet( VM_MACHINE * core )
{
	u8  floor;
	u16 div,map,exit;
	floor = VMGetU8(core);
	div = VMGetWorkValue(core);
	map = VMGetWorkValue(core);
	exit = VMGetWorkValue(core);

	//ElevatorSet(floor,(u8)div,(u8)map,(u8)exit);
	return 0;
}

u8 EvCmdElevatorStart( VM_MACHINE * core )
{
#if 0	
	ElevatorStart();
	StopFieldScript();	
	return 1;
#endif //<<20040130 del
	return 0;
}


//^bOog̉bΏOBJZbg
u8 EvCmdSetTagTargetObjNo( VM_MACHINE * core )
{
	TargetObjNo = GetTagTargetObjNo();
	return 0;
}

//-------------------------------------------------------------------------
//	naiƂ̉bX^[g(^bOp)
//-------------------------------------------------------------------------
u8 EvCmdTagTalkObjStart( VM_MACHINE * core )
{
	if ( IsFieldCommMode() ) return 0;

	if (EvObj[TargetObjNo].sw == 1) {
		AddTagTalkObjStartTask();
		VM_SetWait( core, EvWaitTagTalkObjStart );
	}
#if 0
	else {
		AddTalkStartTask();
		VM_SetWait( core, EvWaitTalkStart );
	}
#endif
	return 1;
}


//==============================================================================================
//
//	eqEkfǉR}h
//
//==============================================================================================

//----------------------------------------------------------------------------------------------
/**
 * 莝|PɃCxgŔzzꂽƂtOǉ
 *
 * @li	莝io[VMGetWorkValuegp
 */
//----------------------------------------------------------------------------------------------
u8 EvCmdEventGetFlagSet( VM_MACHINE * core )
{
	u8 flag = 1;
	u16 pos;

	pos = VMGetWorkValue(core);
	PokeParaPut( &PokeParaMine[pos], ID_event_get_flag, &flag );
	return 0;
}

//----------------------------------------------------------------------------------------------
/**
 * 莝|PɃCxgŔzzꂽƂtOǉĂ邩`FbN
 *
 * @li	莝io[VMGetWorkValuegp
 */
//----------------------------------------------------------------------------------------------
u8 EvCmdEventGetFlagCheck( VM_MACHINE * core )
{
	u16 pos;

	pos = VMGetWorkValue(core);
	*ret_wk = PokeParaGet( &PokeParaMine[pos], ID_event_get_flag, 0 );
	return 0;
}

//----------------------------------------------------------------------------------------------
/**
 * ʏ}bvJځ[vœĂ
 *
 * @li	wExVMGetWorkValuegp
 */
//----------------------------------------------------------------------------------------------
u8 EvCmdMapChangeWarpIn( VM_MACHINE * core )
{
	u8  div,map,exit;
	u16 x,y;

	div = VMGetU8(core);
	map = VMGetU8(core);
	exit = VMGetU8(core);
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);

	NextMapSetDirect( div, map, exit, (u8)x, (u8)y );
	SetWarpInSite( GetHeroSite() );
	AddDoorOutWarpInMapChangeTask();
	InitHeroLastStatus();
	return 1;
}

//----------------------------------------------------------------------------------------------
/**
 * 莝|Pɕ߂܂nhcZbg
 *
 * @li	莝io[VMGetWorkValuegp
 */
//----------------------------------------------------------------------------------------------
u8 EvCmdPokePlaceSet( VM_MACHINE * core )
{
	u16	pos;
	u8 place_id;

	pos = VMGetWorkValue(core);
	place_id = VMGetU8(core);

	if (pos < TEMOTI_POKEMAX) {
		PokeParaPut(&PokeParaMine[pos], ID_get_place, (u8 *)&place_id);
	}
	return 0;
}

//----------------------------------------------------------------------------------------------
/**
 * _̃NA
 *
 * @param   none
 *
 * @retval  none
 */
//----------------------------------------------------------------------------------------------
void ClearTenji(void)
{
	FieldBitMapWinClear(TenjiWinIndex,FBMP_TRANS_ON);
	BMPWIN_SysDel( TenjiWinIndex );
}

//-------------------------------------------------------------------------
//	}bvJ(SEȂ) WHITEp
//-------------------------------------------------------------------------
u8 EvCmdMapChangeSeNotWhite( VM_MACHINE * core )			/* EVCMD_MAP_CHG_SENOT */
{
	u8  div,map,exit;
	u16 x,y;

	div = VMGetU8(core);
	map = VMGetU8(core);
	exit = VMGetU8(core);
	x = VMGetWorkValue(core);
	y = VMGetWorkValue(core);

	NextMapSetDirect( div, map, exit, (u8)x, (u8)y );
	AddMapChangeSeNotWhiteTask();
	InitHeroLastStatus();
	return 1;
}

#endif


/*********************************/
/*********************************/
/*********************************/
/*********************************/
/*********************************/
/*********************************/



//============================================================================================
//
//	Ή
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * o^vǑĂяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdProgram( VM_MACHINE * core )
{
	//EScriptCallTable̐ݒ
	
	ScriptCallTable[ VMGetU16(core) ]();
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * o^vǑĂяo(߂lj
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdFunctionCall( VM_MACHINE * core )
{
	//E߂li[郏[N̎w
	//EScriptCallTable̐ݒ
	
	u16 * work;
	work = VMGetWork(core);
	*work = ( ScriptCallTable[ VMGetU16(core) ] )();
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * XNvgs̒~
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 *
 * @li	ContinueFieldScriptōĊJ
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdStopScript( VM_MACHINE * core )
{
	//StopFieldScript();
	return 1;
}
//--------------------------------------------------------------------------------------------
//	hcɂ鋤ʃXNvgWv
//--------------------------------------------------------------------------------------------
u8 EvCmdJumpID( VM_MACHINE * core );
u8 EvCmdJumpID( VM_MACHINE * core )
{
/*
	u8 id = VMGetU8(core);
	if ( CommonScriptTableStart+id < CommonScriptTableEnd ) {
		VMJump( core, (VM_CODE *)(CommonScriptTableStart[id]) );
	}
*/
	return 0;
}

//--------------------------------------------------------------------------------------------
//	hcɂ鋤ʃXNvgR[
//--------------------------------------------------------------------------------------------
u8 EvCmdCallID( VM_MACHINE * core );
u8 EvCmdCallID( VM_MACHINE * core )
{
/*
	u8 id = VMGetU8(core);
	if ( CommonScriptTableStart+id < CommonScriptTableEnd ) {
		VMCall( core, (VM_CODE *)(CommonScriptTableStart[id]) );
	}
*/
	return 0;
}

//--------------------------------------------------------------------------------------------
//	hcɂ鋤ʃXNvgWvitj
//--------------------------------------------------------------------------------------------
u8 EvCmdIfJumpID( VM_MACHINE * core );
u8 EvCmdIfJumpID( VM_MACHINE * core )
{
/*
	u8 r;
	u8 id;
	r = VMGetU8(core);
	id = VMGetU8(core);
	if ( ConditionTable[r][core->cmp_flag] == TRUE ) {
		if ( CommonScriptTableStart+id < CommonScriptTableEnd ) {
			VMJump( core, (VM_CODE *)(CommonScriptTableStart[id]) );
		}
	}
*/
	return 0;
}

//--------------------------------------------------------------------------------------------
//	hcɂ鋤ʃXNvgR[itj
//--------------------------------------------------------------------------------------------
u8 EvCmdIfCallID( VM_MACHINE * core );
u8 EvCmdIfCallID( VM_MACHINE * core )
{
/*
	u8 r;
	u8 id;
	r = VMGetU8(core);
	id = VMGetU8(core);
	if ( ConditionTable[r][core->cmp_flag] == TRUE ) {
		if ( CommonScriptTableStart+id < CommonScriptTableEnd ) {
			VMCall( core, (VM_CODE *)(CommonScriptTableStart[id]) );
		}
	}
*/
	return 0;
}


#if 0
//--------------------------------------------------------------------------------------------
/**
 * [NƒlrAǂȂ番
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 *
 * @li	EVCMD_IFVAL_JUMP
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdIfValueJump( VM_MACHINE * core )
{
	EvCmdCmpWkValue( core );
	EvCmdIfJump( core );

	return	0;
}

//--------------------------------------------------------------------------------------------
/**
 * [Nƃ[NrAǂȂ番
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 *
 * @li	EVCMD_IFWK_JUMP
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdIfWorkJump( VM_MACHINE * core )
{
	EvCmdCmpWkWk( core );
	EvCmdIfJump( core );

	return	0;
}
#endif



//-------------------------------------------------------------------------
//	naiƂ̉bX^[g
//-------------------------------------------------------------------------
u8 EvCmdTalkObjStart( VM_MACHINE * core );
u8 EvCmdTalkObjStart( VM_MACHINE * core )
{
/*
	if ( IsFieldCommMode() ) return 0;

	if (EvObj[TargetObjNo].sw == 1) {
		AddTalkObjStartTask();
		VM_SetWait( core, EvWaitTalkObjStart );
	} else {
		AddTalkStartTask();
		VM_SetWait( core, EvWaitTalkStart );
	}
*/
	return 1;
}

//-------------------------------------------------------------------------
//	bI
//-------------------------------------------------------------------------
u8 EvCmdTalkEnd( VM_MACHINE * core );
u8 EvCmdTalkEnd( VM_MACHINE * core )
{
/*
	FieldMsgClear();

	AcmdEnd(EvObjSpWorkAdrs(EV_OBJ_SPID));			// @Aj
	AnmCmdFree();
	EvObjPauseClrAll();
*/
	return 0;
}

//-------------------------------------------------------------------------
//	naiƂ̉bI
//-------------------------------------------------------------------------
u8 EvCmdTalkObjEnd( VM_MACHINE * core );
u8 EvCmdTalkObjEnd( VM_MACHINE * core )
{
/*
	FieldMsgClear();

	if (EvObj[TargetObjNo].sw == 1) AcmdEnd(&EvObj[TargetObjNo]);
	AcmdEnd(EvObjSpWorkAdrs(EV_OBJ_SPID));			// @Aj
	AnmCmdFree();
	EvObjPauseClrAll();
*/
	return 0;
}

//-------------------------------------------------------------------------
//	blrfZbg
//-------------------------------------------------------------------------
#if 0
u8 EvCmdTalkMsg(VM_MACHINE * core)					/* EVCMD_TALKMSG		*/
{
/*
	VM_CODE * msg = (VM_CODE *)VMGetU32(core);
	if( (u32)msg == 0 )msg = (VM_CODE *)(core->reg[0]);
	FieldMsgSet(msg);
*/
	return 0;
};
#endif

//-------------------------------------------------------------------------
//	blrfZbgilrf̃L[Ȃj
//-------------------------------------------------------------------------
u8 EvCmdSysTalkMsg(VM_MACHINE * core);			/* EVCMD_SYSTALKMSG		*/
u8 EvCmdSysTalkMsg(VM_MACHINE * core)			/* EVCMD_SYSTALKMSG		*/
{
/*
	VM_CODE * msg = (VM_CODE *)VMGetU32(core);
	if( (u32)msg == 0 )msg = (VM_CODE *)(core->reg[0]);
	msg_print_flag.auto_f = MSG_AUTO_ON;	//add by matsuda 2004.03.08()
	msg_print_flag.speed_fix = MSGSPEED_FIX_ON;
	FieldMsgSetNoSkip(msg);
*/
	return 0;
}

//----------------------------------------------------------------------------------------------
/**
 * ꊇbZ[W\(L[ɂ͑ΉĂȂ̂ŒӁI)
 */
//----------------------------------------------------------------------------------------------
u8 EvCmdMsgAllPut( VM_MACHINE * core );
u8 EvCmdMsgAllPut( VM_MACHINE * core )
{
/*
	VM_CODE * msg = (VM_CODE *)VMGetU32(core);
	if( (u32)msg == 0 )msg = (VM_CODE *)(core->reg[0]);
	FieldBitMapWinCgxSet();										//EBhEf[^Zbg
	FieldBitMapTalkWinWrite( FMSG_WIN, FBMP_TRANS_ON );			//bEBhE
	MSG_Print( FMSG_WIN, FONT_SYSTEM, msg, FLD_MSG_POS_X, FLD_MSG_POS_Y, MSG_ALLPUT, NULL );
*/
	return 0;
}

//-------------------------------------------------------------------------
//	blrf\I҂
//-------------------------------------------------------------------------
u8 EvCmdTalkWait(VM_MACHINE * core);					/* EVCMD_TALKWAIT	*/
u8 EvCmdTalkWait(VM_MACHINE * core)					/* EVCMD_TALKWAIT	*/
{
//	VM_SetWait( core, FieldMsgWait );
	return 1;
};



/******************************/
/******************************/
/******************************/
/******************************/
/******************************/
/******************************/




//============================================================================================
//
//	gp
//
//============================================================================================
#if 0
static void FieldTalkMsgFileNameMake( char * path, u16 map, u16 id, u16 msg );
static void FieldTalkMsgFileNameMake( char * path, u16 map, u16 id, u16 msg )
{
	strcpy( path, "/data/script/msg_map" );

	StrNumSet( &path[20], map, 3 );		// "/data/script/msg_map"
	strcat( path, "_" );
	StrNumSet( &path[24], id, 2 );		// "/data/script/msg_map000_"
	strcat( path, "_" );
	StrNumSet( &path[27], msg, 2 );		// "/data/script/msg_map000_00_"
	strcat( path, ".dat" );
}

static void FieldMsgLoad( u16 map, u16 id, u16 msg );
static void FieldMsgLoad( u16 map, u16 id, u16 msg )
{
	char * path;

	path = (char *)sys_AllocMemory( APP_W_HEAP_AREA, 48 );
	FieldTalkMsgFileNameMake( path, map, id, msg );
	pMsg = (u16 *)sys_LoadFile( APP_W_HEAP_AREA, path );
	sys_FreeMemory( APP_W_HEAP_AREA, path );
}
#endif


//--------------------------------------------------------------------------------------------
//
//--------------------------------------------------------------------------------------------
/**
 * 莝|P̃|PXւ̊`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdChkTemotiPokerus( VM_MACHINE * core )
{
	int i, max, bol;
	//u8	͊{IɎgȂB2005.12.22 tamada
	//u8	i;
	//u8	bol;
	u16 * wk;
	POKEMON_PARAM * poke;
	FIELDSYS_WORK* fsys = core->fsys;

	wk = VMGetWork( core );

	*wk = 0;

	//|P̓ANZX͕ʃ\[Xɂ܂Ƃ߂āAĂяo\B
	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(fsys->savedata));
	//xxxxx |PXĂ邩check
	for(i=0,bol=0;i<max;i++){
		//|Pւ̃|C^擾
		poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), i);

		PokeParaGet(poke, ID_PARA_pokerus, &bol);

		if(bol!=0){
			*wk = 1;
			break;
		}
	}

	return 0;
}

//============================================================================================
//
//	hAAj֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * hAAj[VZbgAbv
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdSetUpDoorAnime( VM_MACHINE * core )
{
	u16 block_x,block_z;
	u8 local_x,local_z;
	int grid_x,grid_z;
	u8 entry;
	
	FIELDSYS_WORK* fsys;
	
	//ubNW擾
	block_x = VMGetU16(core);
	block_z = VMGetU16(core);
	//[JObhW擾
	local_x = VMGetU8(core);
	local_z = VMGetU8(core);
	//Gg[ID擾
	entry = VMGetU8(core);

	OS_Printf("info:%d,%d,%d,%d,%d\n",block_x,block_z,local_x,local_z,entry);
	
	fsys = core->fsys;

	//[hWvZ
	grid_x = block_x*32+local_x;
	grid_z = block_z*32+local_z;
	
	//wW̃f̃Aj[VZbgAbv
	FLD_SCR_ANM_DOOR_Setup(fsys, grid_x, grid_z, entry);
	
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * Aj[VEFCg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdWait3DAnime( VM_MACHINE * core )
{
	u8 entry;
	FIELDSYS_WORK* fsys;
	//Gg[ID擾
	entry = VMGetU8(core);
	fsys = core->fsys;
	
	FLD_SCR_ANM_DOOR_WaitAnime(fsys, entry);
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * Aj[V
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdFree3DAnime( VM_MACHINE * core )
{
	u8 entry;
	FIELDSYS_WORK* fsys;
	//Gg[ID擾
	entry = VMGetU8(core);
	fsys = core->fsys;
	FLD_SCR_ANM_DOOR_FreeDoor(fsys, entry);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * hAI[vAj
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdOpenDoor( VM_MACHINE * core )
{
	u8 entry;
	FIELDSYS_WORK* fsys;
	//Gg[ID擾
	entry = VMGetU8(core);
	fsys = core->fsys;
	FLD_SCR_ANM_DOOR_StartOpenDoorAnm( fsys, entry );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * hAN[YAj
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdCloseDoor( VM_MACHINE * core )
{
	u8 entry;
	FIELDSYS_WORK* fsys;
	//Gg[ID擾
	entry = VMGetU8(core);
	fsys = core->fsys;
	FLD_SCR_ANM_DOOR_StartCloseDoorAnm( fsys, entry );
	return 0;
}

//============================================================================================
//
//	ĉ֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * Ă@O̎擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetSodateyaName( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	SAVEDATA * sv = fsys->savedata;
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );

	SodateyaNameSet(SaveData_GetSodateyaWork(sv),*wordset);

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * Ă@̏Ԏ擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetSodateyaZiisan( VM_MACHINE * core )
{
	u16 * work;
	FIELDSYS_WORK* fsys = core->fsys;
	SAVEDATA * sv = fsys->savedata;
	SODATEYA_WORK *sodateya;
	work = VMGetWork( core );

	sodateya = (SODATEYA_WORK *)(SaveData_Get(sv,GMDATA_ID_SODATEYA));
	*work = SodateyaZiisannCheck(sodateya);

	return 0;
}

//============================================================================================
//
//	W֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * WԃZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdInitWaterGym( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	GYM_InitWaterGym(fsys);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * W{^
 * @brief   CxgR[̂ŁAreturn 0ŃXNvg{̂IĂ܂Ȃ悤ɁA1Ԃ
 * 
 * @param	core		z}V\̂ւ̃|C^
 * 
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdPushWaterGymButton( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	GYM_CheckWaterGymButton(fsys);
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * S[XgWԃZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdInitGhostGym( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	GYM_InitGhostGym(fsys);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * S[XgWtg
 * @brief   CxgR[̂ŁAreturn 0ŃXNvg{̂IĂ܂Ȃ悤ɁA1Ԃ
 * 
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdMoveGhostGymLift( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	GYM_MoveGhostGymLift(fsys);
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * |WԃZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdInitSteelGym( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	GYM_InitSteelGym(fsys);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * |P擾
 * @brief   莝̃|P𒲂ׂĕԂ
 * 
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetPokeCount( VM_MACHINE * core )
{
	int max;
	POKEMON_PARAM * poke;
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= VMGetWork( core );

	//|P̓ANZX͕ʃ\[Xɂ܂Ƃ߂āAĂяo\B
	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(fsys->savedata));

	//A^}Sɂďo͂𕪂邩

	*ret_wk = max;

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * |P擾(^}Sj
 * @brief   莝̃|P𒲂ׂĕԂ
 * 
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetPokeCount2( VM_MACHINE * core )
{
	int max,poke_max,i;
	POKEMON_PARAM * poke;
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= VMGetWork( core );

	//|P̓ANZX͕ʃ\[Xɂ܂Ƃ߂āAĂяo\B
	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(fsys->savedata));

	for(i=0,poke_max=0;i<max;i++){
		poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), i);

		//X^[ԍ擾(0ȊOȂ^}SȂj
		if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) == 0 ){
			poke_max++;
		}
	}

	*ret_wk = poke_max;

	return 0;
}


//--------------------------------------------------------------------------------------------
/**
 * |P擾(^}Sƕmj
 * @brief   莝̃|P𒲂ׂĕԂ
 * 
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetPokeCount3( VM_MACHINE * core )
{
	int max,poke_max,i;
	POKEMON_PARAM * poke;
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= VMGetWork( core );

	//|P̓ANZX͕ʃ\[Xɂ܂Ƃ߂āAĂяo\B
	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(fsys->savedata));

	for(i=0,poke_max=0;i<max;i++){
		poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), i);

		//X^[ԍ擾(0ȊOȂ^}SȂj
		if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) == 0 ){
			//mO`FbN(0==m)
			if( PokeParaGet( poke,ID_PARA_hp , NULL ) != 0 ){
				poke_max++;
			}
		}
	}

	*ret_wk = poke_max;

	return 0;
}
static BOOL EvCmdGetPokeCount4( VM_MACHINE * core )
{
//쐬 060302 by tomo
//xxxxx
	return 0;
}


static BOOL EvCmdHikitoriPoke( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	SODATEYA_WORK *sodateya;
	POKEPARTY * temoti;
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	SAVEDATA * sv = fsys->savedata;
	u8 no		= VMGetWorkValue(core);
	sodateya = (SODATEYA_WORK *)(SaveData_Get(sv,GMDATA_ID_SODATEYA));
	temoti = SaveData_GetTemotiPokemon(fsys->savedata);

	PokeHikitoriSub(temoti,*wordset,sodateya,no);

	return 0;
}


static BOOL EvCmdHikitoriList( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= VMGetWork( core );

//쐬 060302 by tomo
//xxxxx

	return 0;
}

static BOOL EvCmdMsgSodateyaAishou( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;

//쐬 060302 by tomo
//xxxxx

	return 0;
}

static BOOL EvCmdMsgExpandBuf( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;

//쐬 060302 by tomo
//xxxxx

	return 0;
}

static BOOL EvCmdDelSodateyaEgg( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;

//쐬 060302 by tomo
//xxxxx

	return 0;
}

static BOOL EvCmdGetSodateyaEgg( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;

//쐬 060302 by tomo
//xxxxx

	return 0;
}

// =================================================================
/**
 * @brief 藿擾
 * @param  none
 * @retval  ԂiƂāA[NɔԍZbgKv܂j
 * @retval  obt@O֗ZbgA[N֕Ԃ
 */
// =================================================================
static BOOL EvCmdHikitoriRyoukin( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	SODATEYA_WORK *sodateya;
	WORDSET** wordset		= GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WORDSET );
	SAVEDATA * sv = fsys->savedata;
	u16 * work  = VMGetWork(core);
	u8 no		= VMGetWorkValue(core);
	sodateya = (SODATEYA_WORK *)(SaveData_Get(sv,GMDATA_ID_SODATEYA));

	*work = PokeHikitoriRyoukinSub(sodateya,no,*wordset);
	return 0;
}

static BOOL EvCmdCompMyGold( VM_MACHINE * core )
{
	MYSTATUS* my	= SaveData_GetMyStatus( GameSystem_GetSaveData(core->fsys) );
	u16 * work;
	u32 gold,my_gold;

	work  = VMGetWork(core);
	gold	= VMGetWorkValue( core );
	my_gold = MyStatus_GetGold( my);

	if(my_gold < gold){
		*work = FALSE;
	}else{
		*work = TRUE;
	}

	return 0;
}

static BOOL EvCmdTamagoDemo( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;

//쐬 060302 by tomo
//xxxxx

	return 0;
}

static BOOL EvCmdSodateyaPokeList( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= VMGetWork( core );

//쐬 060302 by tomo
//xxxxx

	return 0;
}

static BOOL EvCmdSodatePokeLevelStr( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	SAVEDATA * sv = fsys->savedata;
	SODATEYA_WORK *sodateya;
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WORDSET );
	u16 no			= VMGetWorkValue( core );

	sodateya = (SODATEYA_WORK *)(SaveData_Get(sv,GMDATA_ID_SODATEYA));
	SodatePokeLevelSet(sodateya,no,*wordset );

	return 0;
}

static BOOL EvCmdMsgAzukeSet( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	POKEPARTY * temoti;
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WORDSET );
	u16 wk_no			= VMGetU16( core );		//݂͂OŒȂ̂Ŏgp
	u16 no				= VMGetWorkValue( core );
	u16* ret_wk			= VMGetWork( core );

	temoti = SaveData_GetTemotiPokemon(fsys->savedata);
	*ret_wk = SodateyaAzukeName(temoti,no,*wordset );

	return 0;
}

static BOOL EvCmdSetSodateyaPoke( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	SAVEDATA * sv = fsys->savedata;
	SODATEYA_WORK *sodateya;
	POKEPARTY * temoti;
	u8 no				= VMGetWorkValue(core);

	temoti = SaveData_GetTemotiPokemon(fsys->savedata);
	sodateya = (SODATEYA_WORK *)(SaveData_Get(sv,GMDATA_ID_SODATEYA));
	PokeSodateSet(temoti,no,sodateya,sv);

	return 0;
}



//============================================================================================
//
//	nX֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * @brief   n̂X̃j[J
 * 
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUgShopMenuInit( VM_MACHINE * core )
{
	void** pwork= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_PWORK );
	u16 type	= VMGetWorkValue( core );		//TRUE=ȁAFALSE=ObY
	u16 wk_id	= VMGetU16( core );

	//z}V̔ėpWX^Ƀ[NIDi[
	core->reg[0] = wk_id;

	*pwork = UgShopMenuInit( type, core->fsys );

	VM_SetWait( core, EvWaitUgShopMenuInit );
	return 1;
}

//return 1 = I
static BOOL EvWaitUgShopMenuInit(VM_MACHINE * core)
{
	void** pwork= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_PWORK );
	u16* ret_wk = GetEventWorkAdrs( core->fsys, core->reg[0] );	//ӁI

	*ret_wk = UgShopMenuFuncAndCheck( (*pwork) );

	if( (*ret_wk) == UG_SHOP_NONE ){	//I
		return 0;
	}

	OS_Printf( "UgShopMenuInit ret = %d\n", (*ret_wk) );
	//case UG_SHOP_BAG_FULL:			//obOς
	//case UG_SHOP_MISS_SELECT:			//I^}قȂ
	//case UG_SHOP_CANCEL:				//LZ
	//̑							//ȔԍAObYԍ
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   X̉bJn
 * 
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUgShopTalkStart( VM_MACHINE * core )
{
	u8* msg_index = GetEvScriptWorkMemberAdrs( core->fsys,ID_EVSCR_MSGINDEX );

	*msg_index = UgShopTalkStart( VMGetWorkValue(core) );

	VM_SetWait( core, EvWaitUgShopTalkStart );
	return 1;
}

//return 1 = I
static BOOL EvWaitUgShopTalkStart(VM_MACHINE * core)
{
	u8* msg_index = GetEvScriptWorkMemberAdrs( core->fsys,ID_EVSCR_MSGINDEX );
	return FldTalkMsgEndCheck( *msg_index );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   X̉bI
 * 
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUgShopTalkEnd( VM_MACHINE * core )
{
	UgShopTalkEnd();
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   ACe̖OX̉bɓo^
 * 
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUgShopTalkRegisterItemName( VM_MACHINE * core )
{
	u8 idx		= VMGetU8(core);
	u16 type	= VMGetWorkValue(core);

	UgShopTalkRegisterItemName( idx, type );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   㩂̖OX̉bɓo^
 * 
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdUgShopTalkRegisterTrapName( VM_MACHINE * core )
{
	u8 idx		= VMGetU8(core);
	u16 type	= VMGetWorkValue(core);

	UgShopTalkRegisterTrapName( idx, type );
	return 0;
}


//============================================================================================
//
//	MlX֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * @brief   MlXEBhEĂяo
 * 
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGuinnessWin( VM_MACHINE * core )
{
	EventCmd_GuinnessWin( core->event_work, 1, 1, 0, 0, NULL );
	return 1;
}

//-------------------------------------------------------------------------
//	naǐEȂXCb`؂ւ
//-------------------------------------------------------------------------
static BOOL EvCmdObjVisible( VM_MACHINE * core )
{
	FIELD_OBJ_PTR fldobj;		//Ώۂ̃tB[hOBJ̃|C^
	FIELDSYS_WORK * fsys = core->fsys;

	fldobj	= FieldOBJSys_OBJIDSearch( fsys->fldobjsys, VMGetWorkValue(core) );
	if( fldobj == NULL ){
		GF_ASSERT( (0) && "Ώۂ̃tB[hOBJ̃|C^擾sI" );
	}
	FieldOBJ_StatusBitSet_Vanish(fldobj, FALSE);
	return 0;
}

static BOOL EvCmdObjInvisible( VM_MACHINE * core )
{
	FIELD_OBJ_PTR fldobj;		//Ώۂ̃tB[hOBJ̃|C^
	FIELDSYS_WORK * fsys = core->fsys;

	fldobj	= FieldOBJSys_OBJIDSearch( fsys->fldobjsys, VMGetWorkValue(core) );
	if( fldobj == NULL ){
		GF_ASSERT( (0) && "Ώۂ̃tB[hOBJ̃|C^擾sI" );
	}
	FieldOBJ_StatusBitSet_Vanish(fldobj, TRUE);
	return 0;
}

//[{bNX
//--------------------------------------------------------------------------------------------
/**
 * [{bNXĂяo
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
#include "savedata/mail_util.h"
#include "field/fld_mailbox.h"
static BOOL EvCmdMailBox( VM_MACHINE * core )
{
	EventCmd_MailBoxCall(core->event_work);	
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * [{bNX̃f[^擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetMailBoxDataNum( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= VMGetWork( core );
	MAIL_BLOCK* block = SaveData_GetMailBlock(fsys->savedata);
	
	*ret_wk = (u16)MAIL_GetEnableDataNum(block,MAILBLOCK_PASOCOM);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ̎擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetRand( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= VMGetWork( core );
	u16	limit			= VMGetWorkValue( core );
	RTCTime	rtc;

	GF_RTC_GetTime(&rtc);
	gf_srand(rtc.second);

	*ret_wk = ( gf_rand() % limit );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * Ȃx̎擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetNatsuki( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	POKEMON_PARAM * poke;
	u16* ret_wk			= VMGetWork( core );
	u16 poke_id;

	//|Pւ̃|C^擾
	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), 0);

	//|P̂Ȃx擾
	*ret_wk = PokeParaGet( poke, ID_PARA_friend, NULL );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ĂXNvgFLISTp|PZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdHikitoriListNameSet( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	SAVEDATA * sv = fsys->savedata;
	WORDSET** wordset	= GetEvScriptWorkMemberAdrs( core->fsys, ID_EVSCR_WORDSET );

	u8	buf_id		= VMGetWorkValue( core );
	u8	no			= VMGetWorkValue( core );

	SodateyaListNameSet(SaveData_GetSodateyaWork(sv),buf_id,no,*wordset);
	return 0;
}


//--------------------------------------------------------------------------------------------
/**
 * ĂXNvgFaĂ2̂̑Qbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetSodateyaAishou( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	SAVEDATA * sv = fsys->savedata;
	SODATEYA_WORK *sodateya;
	u16* ret_wk	= VMGetWork( core );

	sodateya = (SODATEYA_WORK *)(SaveData_Get(sv,GMDATA_ID_SODATEYA));

	*ret_wk = SodateyaGetAffinity( sodateya );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ĂXNvgF^}S܂Ă邩iPFAOFȂj
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
static BOOL EvCmdGetSodateyaTamagoCheck( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	SAVEDATA * sv = fsys->savedata;
	SODATEYA_WORK *sodateya;
	u16* ret_wk	= VMGetWork( core );

	sodateya = (SODATEYA_WORK *)(SaveData_Get(sv,GMDATA_ID_SODATEYA));

	*ret_wk = PokeTamagoCheck(sodateya);

	return 0;
}


//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
