//============================================================================================
/**
 * @file	script.h
 * @bfief	XNvg䃁C
 * @author	Satoshi Nohara
 * @date	05.08.04
 *
 * 01.03.28	Sousuke Tamada
 * 03.04.15	Satoshi Nohara
 * 05.04.25 Hiroyuki Nakamura
 */
//============================================================================================
#ifndef SCRIPT_H
#define SCRIPT_H

#include "field_common.h"
#include "field_event.h"
#include "vm.h"					//VM_CMD
#include "script_def.h"			//XNvg`


//============================================================================================
//
//	fobN
//
//============================================================================================
extern VM_CODE* sp_script;


//==============================================================================================
//
//	XNvg䃏[Nւ̕sS^|C^
//
//==============================================================================================
typedef	struct _EV_SCRIPT_WORK EV_SCRIPT_WORK;


//============================================================================================
//	`
//============================================================================================
//EV_SCRIPT_WORK̃o[ID`
enum{
	ID_EVSCR_EVWIN = 0,				//CxgEBhE[Ñ|C^

	ID_EVSCR_MSGWINDAT,				//bEBhErbg}bvf[^
	ID_EVSCR_MENUWORK,				//rbg}bvj[[Ñ|C^

	ID_EVSCR_MSGINDEX,				//bEBhEbZ[WCfbNX
	ID_EVSCR_ANMCOUNT,				//Aj[V̐
	ID_EVSCR_COMMON_SCR_FLAG,		//ʃXNvg؂ւtO
	ID_EVSCR_WIN_OPEN_FLAG,			//bEBhEJtO
	ID_EVSCR_VM_MACHINE_COUNT,		//ǉz}V̐

	ID_EVSCR_SCRIPT_ID,				//C̃XNvgID

	ID_EVSCR_PLAYER_DIR,			//CxgN̎ľ
	ID_EVSCR_TARGET_OBJ,			//bΏۂOBJ̃|C^
	ID_EVSCR_DUMMY_OBJ,				//_~[OBJ̃|C^
	ID_EVSCR_RETURN_SCRIPT_WK,		//Cxgʂ郏[Ñ|C^

	ID_EVSCR_VM_MAIN,				//VM̃|C^
	ID_EVSCR_VM_SUB1,				//VM̃|C^

	ID_EVSCR_WORDSET,				//PZbg
	ID_EVSCR_MSGBUF,				//bZ[Wobt@̃|C^
	ID_EVSCR_TMPBUF,				//e|obt@̃|C^
	ID_EVSCR_WAITICON,				///<ҋ@ACR̃|C^

	ID_EVSCR_SUBPROC_WORK,			//TuvZX̃p[^
	ID_EVSCR_PWORK,					//[Nւ̔ėp|C^

	ID_EVSCR_WIN_FLAG,

	ID_EVSCR_TR0_RANGE,				//
	ID_EVSCR_TR0_DIR,
	ID_EVSCR_TR0_SCR_ID,
	ID_EVSCR_TR0_ID,
	ID_EVSCR_TR0_TYPE,
	ID_EVSCR_TR0_FLDOBJ,
	ID_EVSCR_TR0_TCB,

	ID_EVSCR_TR1_RANGE,
	ID_EVSCR_TR1_DIR,
	ID_EVSCR_TR1_SCR_ID,
	ID_EVSCR_TR1_ID,
	ID_EVSCR_TR1_TYPE,
	ID_EVSCR_TR1_FLDOBJ,
	ID_EVSCR_TR1_TCB,

	//XNvgƃvÕf[^p
	ID_EVSCR_WK_START,				//[N̊JnID
	ID_EVSCR_WK_PARAM0 = ID_EVSCR_WK_START,				
	ID_EVSCR_WK_PARAM1,
	ID_EVSCR_WK_PARAM2,
	ID_EVSCR_WK_PARAM3,

	//XNvgł̃e|
	ID_EVSCR_WK_TEMP0,					
	ID_EVSCR_WK_TEMP1,
	ID_EVSCR_WK_TEMP2,
	ID_EVSCR_WK_TEMP3,

	//XNvgł̏p
	ID_EVSCR_WK_REG0,					
	ID_EVSCR_WK_REG1,
	ID_EVSCR_WK_REG2,
	ID_EVSCR_WK_REG3,

	//XNvgɓԂėp[N
	ID_EVSCR_WK_ANSWER,

	//bΏۂOBJID(ύXsI)
	ID_EVSCR_WK_TARGET_OBJID,

/*
	//莝ςŃp\Rɓ]ꂽ
	u16 BoxNoWork = 0;			//ԂBOX
	u16 PasoNoWork = 0;			//BOX̉Ԗڂ

	//jI[ł̃CxgԐp[N
	u16 UnionRoomWork = 0;
*/

	ID_EVSCR_WK_END,				//[N̏IID
};
#define EVSCR_WORK_MAX	( ID_EVSCR_WK_END - ID_EVSCR_WK_START )	//[N̐

//z}Ṽio[
enum{
	VM_MACHINE_MAIN = 0,			//C
	VM_MACHINE_SUB1,				//Tu

	VM_MACHINE_MAX,					//ő吔
};

//BACeXg(|Pb`p)
typedef struct {
	u16 gx, gz;
	u8 response;	//
}HIDE_ITEM_LIST;

#define HIDE_LIST_SX				(7)		//͈
#define HIDE_LIST_SZ				(7)		//͈(gp)
#define HIDE_LIST_SZ_2				(6)		//͈(gp)
#define HIDE_LIST_TOP				(7)		//͈(lʏ)
#define HIDE_LIST_BOTTOM			(6)		//͈(lʉ)
#define HIDE_LIST_RESPONSE_NONE		(0xff)	//IR[h


//============================================================================================
//	O[oϐ
//============================================================================================
//extern const VM_CODE * ReserveScript;


//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * XNvgCxgZbg
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	scr_id		XNvgID
 * @param	obj			bΏOBJ̃|C^(ȂNULL)
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void EventSet_Script( FIELDSYS_WORK * fsys, u16 scr_id, FIELD_OBJ_PTR obj );

//----------------------------------------------------------------------------------------------
/**
 * g[i[i[@OEventSet_Script()NĂ
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	fldobj		qbgFIELD_OBJ_PTR
 * @param	range		ObhPʂ̎
 * @param	dir			ړ
 * @param	scr_id		qbgXNvgID
 * @param	tr_id		qbgg[i[ID
 * @param	tr_type		g[i[^Cv@VOA_uA^bO
 * @param	tr_no		ԖڂɃqbgg[i[Ȃ̂
 */
//----------------------------------------------------------------------------------------------
extern void EventSet_TrainerEyeData(
		FIELDSYS_WORK* fsys, FIELD_OBJ_PTR fldobj,
		int range, int dir, int scr_id, int tr_id, int tr_type, int tr_no );

//--------------------------------------------------------------------------------------------
/**
 * XNvgCxgR[
 *
 * @param	event		GMEVENT_CONTROL^̃|C^
 * @param	scr_id		XNvgID
 * @param	obj			bΏOBJ̃|C^(ȂNULL)
 * @param	ret_script_wk	XNvgʂ郏[Ñ|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void EventCall_Script( GMEVENT_CONTROL* event, u16 scr_id, FIELD_OBJ_PTR obj, void* ret_script_wk );

//--------------------------------------------------------------
/**
 * @brief	z}Vǉ
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	scr_id		XNvgID
 * @param	start		߃e[uJnAhX
 * @param	end			߃e[uIAhX
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern VM_MACHINE* VMMachineAddTCB(FIELDSYS_WORK* fsys, u16 scr_id, const VM_CMD* start, const VM_CMD* end);

//extern VM_MACHINE* VMMachineAdd(FIELDSYS_WORK* fsys, u16 scr_id, const VM_CMD* start, const VM_CMD* end);
extern VM_MACHINE* VMMachineAdd(FIELDSYS_WORK* fsys, u16 scr_id);


//============================================================================================
//
//	XNvg䃏[Ño[ANZX
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * XNvg䃏[Ño[AhX擾
 *
 * @param	sc		EV_SCRIPT_WORK^̃|C^
 * @param	id		擾郁oID(script.hQ)
 *
 * @return	"AhX"
 */
//--------------------------------------------------------------------------------------------
extern void* GetEvScriptWorkMemberAdrs_Sub( EV_SCRIPT_WORK* sc, u32 id );

//--------------------------------------------------------------------------------------------
/**
 * XNvg䃏[Ño[AhX擾
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	id		擾郁oID(script.hQ)
 *
 * @return	"AhX"
 */
//--------------------------------------------------------------------------------------------
extern void* GetEvScriptWorkMemberAdrs( FIELDSYS_WORK* fsys, u32 id );

//--------------------------------------------------------------------------------------------
/**
 * XNvg䃏[N"next_func"Ƀj[ĂяoZbg
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @return	none
 *
 * tB[hj[ĂяoI
 *
 * ꂪc炭Ȃ̂ŁAėpIɎgȂ悤ɂĂI
 */
//--------------------------------------------------------------------------------------------
extern void SetEvScriptNextFunc( FIELDSYS_WORK* fsys );


//============================================================================================
//
//	
//
//============================================================================================

//------------------------------------------------------------------
/**
 * @brief	Cxg[NAhX擾
 *
 * @param	fsys		FIELDSYS_WORKւ̃|C^
 * @param	work_no		[Nio[
 *
 * @return	"[ÑAhX"
 *
 * @li	work_no < 0x8000	ʏ̃Z[u[N
 * @li	work_no >= 0x8000	XNvg䃏[N̒ɊmۂĂ郏[N
 */
//------------------------------------------------------------------
extern u16 * GetEventWorkAdrs( FIELDSYS_WORK* fsys, u16 work_no );

//------------------------------------------------------------------
/**
 * @brief	Cxg[N̒l擾
 *
 * @param	fsys		FIELDSYS_WORKւ̃|C^
 * @param	work_no		[Nio[
 *
 * @return	"[N̒l"
 */
//------------------------------------------------------------------
extern u16 GetEventWorkValue( FIELDSYS_WORK* fsys, u16 work_no );

//------------------------------------------------------------------
/**
 * @brief	Cxg[N̒lZbg
 *
 * @param	fsys		FIELDSYS_WORKւ̃|C^
 * @param	work_no		[Nio[
 * @param	value		Zbgl
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//------------------------------------------------------------------
extern BOOL SetEventWorkValue( FIELDSYS_WORK* fsys, u16 work_no, u16 value );

//------------------------------------------------------------------
/**
 * @brief	XNvgw肷OBJR[h擾
 *
 * @param	fsys		FIELDSYS_WORKւ̃|C^
 * @param	no			0-15
 *
 * @return	"OBJLR[h"
 */
//------------------------------------------------------------------
extern u16 GetEvDefineObjCode( FIELDSYS_WORK* fsys, u16 no );

//------------------------------------------------------------------
/**
 * @brief	XNvgw肷OBJR[hZbg
 *
 * @param	fsys		FIELDSYS_WORKւ̃|C^
 * @param	no			0-15
 * @param	obj_code	OBJR[h
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//------------------------------------------------------------------
extern BOOL SetEvDefineObjCode( FIELDSYS_WORK* fsys, u16 no, u16 obj_code );


//============================================================================================
//
//	tO֘A
//
//============================================================================================

//------------------------------------------------------------------
/**
 * @brief	CxgtO`FbN
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 * @param	flag_no		tOio[
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//------------------------------------------------------------------
extern BOOL CheckEventFlag( FIELDSYS_WORK* fsys, u16 flag_no);

//------------------------------------------------------------------
/**
 * @brief	CxgtOZbg
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 * @param	flag_no		tOio[
 *
 * @return	none
 */
//------------------------------------------------------------------
extern void SetEventFlag( FIELDSYS_WORK* fsys, u16 flag_no);

//------------------------------------------------------------------
/**
 * @brief	CxgtOZbg
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 * @param	flag_no		tOio[
 *
 * @return	none
 */
//------------------------------------------------------------------
extern void ResetEventFlag( FIELDSYS_WORK* fsys, u16 flag_no);

//------------------------------------------------------------------
/**
 * @brief	}bṽZ[utONA
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 *
 * @return	none
 */
//------------------------------------------------------------------
extern void LocalEventFlagClear( FIELDSYS_WORK* fsys );

//------------------------------------------------------------------
/**
 * @brief	1o߂ƂɃNAtONA
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 *
 * @return	none
 */
//------------------------------------------------------------------
extern void TimeEventFlagClear( FIELDSYS_WORK* fsys );


//============================================================================================
//
//	g[i[tO֘A
//
//	EXNvgIDAg[i[ID擾āAtO`FbN
//	BOOL CheckEventFlagTrainer( fsys, GetTrainerIdByScriptId(scr_id) );
//
//============================================================================================

//--------------------------------------------------------------
/**
 * XNvgIDAg[i[ID擾
 *
 * @param   scr_id		XNvgID
 *
 * @retval  "g[i[ID = tOCfbNX"
 */
//--------------------------------------------------------------
extern u16 GetTrainerIdByScriptId( u16 scr_id );

//--------------------------------------------------------------
/**
 * XNvgIDAEǂ̃g[i[擾
 *
 * @param   scr_id		XNvgID
 *
 * @retval  "0=A1=E"
 */
//--------------------------------------------------------------
extern BOOL GetTrainerLRByScriptId( u16 scr_id );

//--------------------------------------------------------------
/**
 * g[i[IDA_uog^Cv擾
 *
 * @param   tr_id		g[i[ID
 *
 * @retval  "0=VOogA1=_uog"
 */
//--------------------------------------------------------------
extern BOOL CheckTrainer2vs2Type( u16 tr_id );

//------------------------------------------------------------------
/**
 * @brief	g[i[CxgtO`FbN
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 * @param	tr_id		g[i[ID
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//------------------------------------------------------------------
extern BOOL CheckEventFlagTrainer( FIELDSYS_WORK* fsys, u16 tr_id );

//------------------------------------------------------------------
/**
 * @brief	g[i[CxgtOZbg
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 * @param	tr_id		g[i[ID
 *
 * @return	none
 */
//------------------------------------------------------------------
extern void SetEventFlagTrainer( FIELDSYS_WORK* fsys, u16 tr_id );

//------------------------------------------------------------------
/**
 * @brief	g[i[CxgtOZbg
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 * @param	tr_id		g[i[ID
 *
 * @return	none
 */
//------------------------------------------------------------------
extern void ResetEventFlagTrainer( FIELDSYS_WORK* fsys, u16 tr_id );


//============================================================================================
//
//	BACe֘A
//
//	EXNvgIDABACetO擾āAtO`FbN
//	BOOL CheckEventFlag( fsys, GetHideItemFlagNoByScriptId(scr_id) );
//
//============================================================================================

//--------------------------------------------------------------
/**
 * XNvgIDABACetOio[擾
 *
 * @param   scr_id		XNvgID
 *
 * @retval  "tOio["
 */
//--------------------------------------------------------------
extern u16 GetHideItemFlagNoByScriptId( u16 scr_id );

//--------------------------------------------------------------
/**
 * XNvgIDABACetOCfbNX擾
 *
 * @param   scr_id		XNvgID
 *
 * @retval  "tOCfbNX"
 */
//--------------------------------------------------------------
extern u16 GetHideItemFlagIndexByScriptId( u16 scr_id );

//--------------------------------------------------------------
/**
 * XNvgIDABACe̔擾
 *
 * @param   scr_id		XNvgID
 *
 * @retval  ""
 *
 * BACẽXNvgĂԂ悤ɂI
 */
//--------------------------------------------------------------
extern u8 GetHideItemResponseByScriptId( u16 scr_id );

//--------------------------------------------------------------
/**
 * ʓɂBACeĊmۂXgɓo^
 *
 * @param   fsys		FIELDSYS_WORK^̃|C^
 * @param   heapid		q[vID
 *
 * @retval  "Xg̃AhX"
 *
 * YꂸɁI
 */
//--------------------------------------------------------------
extern HIDE_ITEM_LIST* HideItem_CreateList( FIELDSYS_WORK * fsys, int heapid );

//------------------------------------------------------------------
/**
 * @brief	Q[Jn XNvgݒ̎s
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 *
 * @return	none
 */
//------------------------------------------------------------------
extern void GameStartScriptInit( FIELDSYS_WORK* fsys );

//------------------------------------------------------------------
/**
 * @brief	EVENTł͂ȂXNvgs
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	scr_id		XNvgID
 *
 * @return	none
 *
 * ӁI
 * EV_SCRIPT_WORKmۂĂȂ̂ŁA
 * SCWK_ANSWERȂǂ̃[N͎gp邱ƂoȂI
 * LOCALWORK0Ȃǂgp悤ɂI
 *
 * ʃXNvgɂĂ͌gpsI
 * Ή\肾A][܂ɏ邩H
 * ܂ȂH
 *
 * tO`FWxŋʃXNvggƂ́A
 * tO`FWxƂɂȂ邩H
 * Е́A][łƂ́AЕ́AʃXNvgIDwHBBB
 */
//------------------------------------------------------------------
extern void SpScriptStart( FIELDSYS_WORK* fsys, u16 scr_id );

//------------------------------------------------------------------
/**
 * @brief	̓XNvgǂݍݏ
 *
 * @param	none
 *
 * @return	none
 */
//------------------------------------------------------------------
extern void TestSpScriptLoad();

//------------------------------------------------------------------
/**
 * @brief	XNvgĎs
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	key			XNvgID
 *
 * @return	"TRUE=XNvgsAFALSE=Ȃ"
 */
//------------------------------------------------------------------
extern BOOL SpScriptSearch( FIELDSYS_WORK* fsys, u8 key );



/***************/
/***************/
/***************/
/***************/
/***************/
/***************/
/***************/


extern void InitControlScriptCheck( void * p );

extern u16 * GetEventWorkAdrs( FIELDSYS_WORK* fsys, u16 work_no );
extern u16 GetEventWorkValue( FIELDSYS_WORK* fsys, u16 work_no );


#endif	/* SCRIPT_H */


