//============================================================================================
/**
 * @file	situation.c
 * @brief	󋵃f[^ANZX
 * @author	tamada GAME FREAK inc.
 * @date	2005.12.03
 */
//============================================================================================

#include "common.h"
#include "system/savedata_def.h"	//SAVEDATAQƂ̂
#include "fieldsys.h"
#include "field/situation.h"
#include "townmap_footmark.h"

#include "system/savedata.h"

#include "situation_local.h"

#include "evtime_local.h"

#include "fieldobj_header.h"

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	󋵃f[^^`
 */
//----------------------------------------------------------
struct _SITUATION {
	LOCATION_WORK now;
	LOCATION_WORK entrance;
	LOCATION_WORK before;
	LOCATION_WORK special;
	LOCATION_WORK escape;
	//LOCATION_WORK teleport;
	u16 bgm;
	u16 weather_id;
	u16 warp_id;
	u8 camera_id;
	EVTIME gametime;
	TOWN_MAP_FOOTMARK TownMapFootMark;
	SWAY_GRASS_HIST		SwayGrassHist;
	PLAYER_SAVE_DATA	player_sv;
};

//----------------------------------------------------------
//----------------------------------------------------------
struct _FIELDOBJ_SAVE{
	FIELD_OBJ_SAVE_DATA fldobj_sv[FLDOBJ_ENTRY_MAX];
};

//============================================================================================
//
//	Z[uf[^VXeˑ֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	󋵃[ÑTCY擾
 * @return	int		TCYioCgPʁj
 */
//----------------------------------------------------------
int Situation_GetWorkSize(void)
{
	return sizeof(SITUATION);
}

//----------------------------------------------------------
//----------------------------------------------------------
int FieldObjSv_GetWorkSize(void)
{
	return sizeof(FIELDOBJ_SAVE);
}

//----------------------------------------------------------
//----------------------------------------------------------
void FieldObjSv_Init(FIELDOBJ_SAVE * sv)
{
	MI_CpuClear32(sv, sizeof(FIELDOBJ_SAVE));
}

//============================================================================================
//
//	󋵃f[^̂߂̊֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	󋵃f[^̏
 * @param	st	󋵃[Nւ̃|C^
 */
//----------------------------------------------------------
void Situation_Init(SITUATION * st)
{
	memset(st, 0, sizeof(SITUATION));
	TMFootMark_Init(&st->TownMapFootMark);
	EVTIME_Init(&st->gametime);
	Player_SaveDataInit(&st->player_sv);
}

//----------------------------------------------------------
/**
 * @brief	݂LOCATION_WORKԂ
 * @param	st	󋵃[Nւ̃|C^
 * @return	LOCATION_WORKւ̃|C^
 */
//----------------------------------------------------------
LOCATION_WORK * Situation_GetNowLocation(SITUATION * st)
{
	return &st->now;
}

//----------------------------------------------------------
/**
 * @brief	OɓoLOCATION_WORKւ̃|C^
 * @param	st	󋵃[Nւ̃|C^
 * @return	LOCATION_WORKւ̃|C^
 */
//----------------------------------------------------------
LOCATION_WORK * Situation_GetEntranceLocation(SITUATION * st)
{
	return &st->entrance;
}

//----------------------------------------------------------
/**
 * @param	st	󋵃[Nւ̃|C^
 */
//----------------------------------------------------------
LOCATION_WORK * Situation_GetBeforeLocation(SITUATION * st)
{
	return &st->before;
}

//----------------------------------------------------------
/**
 * @param	st	󋵃[Nւ̃|C^
 */
//----------------------------------------------------------
LOCATION_WORK * Situation_GetEscapeLocation(SITUATION * st)
{
	return &st->escape;
}
//----------------------------------------------------------
/**
 * @brief	ڑ̎擾
 * @param	st	󋵃[Nւ̃|C^
 * @return	LOCATION_WORK	ڑւ̃|C^
 */
//----------------------------------------------------------
LOCATION_WORK * Situation_GetSpecialLocation(SITUATION * st)
{
	return &st->special;
}

//----------------------------------------------------------
/**
 * @brief	ڑ̃Zbg
 * @param	st	󋵃[Nւ̃|C^
 * @param	sp	LOCATION_WORKf[^̃|C^
 * @return	none
 */
//----------------------------------------------------------
void Situation_SetSpecialLocation(SITUATION * st, LOCATION_WORK* lw)
{
	st->special = *lw;
	return;
}

//----------------------------------------------------------
/**
 * @brief	BGMIDANZX
 * @param	st	󋵃[Nւ̃|C^
 * @param	u16	BGMIDւ̃|C^
 */
//----------------------------------------------------------
u16 * Situation_GetBGMWork(SITUATION * st)
{
	return &st->bgm;
}

//----------------------------------------------------------
/**
 * @brief	VID擾
 * @param	st	󋵃[Nւ̃|C^
 * @return	u16	VIDւ̃|C^
 */
//----------------------------------------------------------
u16 Situation_GetWeatherID(const SITUATION * st)
{
	return st->weather_id;
}

//----------------------------------------------------------
/**
 * @brief	VIDZbg
 * @param	st	󋵃[Nւ̃|C^
 * @param	weather_id	VID
 */
//----------------------------------------------------------
void Situation_SetWeatherID(SITUATION * st, u16 weather_id)
{
	st->weather_id = weather_id;
}

//----------------------------------------------------------
/**
 * @brief	[vID̎擾
 * @param	st	󋵃[Nւ̃|C^
 * @return	u16	[vID
 */
//----------------------------------------------------------
u16 Situation_GetWarpID(const SITUATION * st)
{
	return st->warp_id;
}
//----------------------------------------------------------
/**
 * @brief	[vID̐ݒ
 * @param	st		󋵃[Nւ̃|C^
 * @param	warp_id	[vID
 */
//----------------------------------------------------------
void Situation_SetWarpID(SITUATION * st, u16 warp_id)
{
	st->warp_id = warp_id;
}

//----------------------------------------------------------
/**
 * @param	st	󋵃[Nւ̃|C^
 */
//----------------------------------------------------------
TOWN_MAP_FOOTMARK * Situation_GetTMFootMark(SITUATION * st)
{
	return &st->TownMapFootMark;
}

//----------------------------------------------------------
/**
 * @brief	JwID̎擾
 * @param	st	󋵃[Nւ̃|C^
 * @return	int JwID
 */
//----------------------------------------------------------
int Situation_GetCameraID(const SITUATION * st)
{
	return st->camera_id;
}

//----------------------------------------------------------
/**
 * @brief	JwID̃Zbg
 * @param	st	󋵃[Nւ̃|C^
 * @param	camera_id	JwID
 */
//----------------------------------------------------------
void Situation_SetCameraID(SITUATION * st, int camera_id)
{
	st->camera_id = camera_id;
}

//----------------------------------------------------------
/**
 * @brief	Q[ԕێ[N̎擾
 * @param	st	󋵃[Nւ̃|C^
 * @return	EVTIME Q[ԕێ[Nւ̃|C^
 */
//----------------------------------------------------------
EVTIME * Situation_GetEvTime(SITUATION * st)
{
	return &st->gametime;
}

//----------------------------------------------------------
/**
 * @brief	hꑐGJEg̎擾
 * @param	st	󋵃[Nւ̃|C^
 * @return	hꑐf[^ւ̃|C^
 */
//----------------------------------------------------------
SWAY_GRASS_HIST * Situation_GetSwayGrassHist(SITUATION * st)
{
	return &st->SwayGrassHist;
}

//----------------------------------------------------------
/**
 * @brief	@Z[u擾
 * @param	st	󋵃[Nւ̃|C^
 * @return	PLAYER_SAVE_DATAւ̃|C^
 */
//----------------------------------------------------------
PLAYER_SAVE_DATA * Situation_GetPlayerSaveData(SITUATION * st)
{
	return &st->player_sv;
}

//============================================================================================
//
//	Z[uf[^擾̂߂̊֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	󋵃f[^ւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	SITUATION	󋵕ێ[Nւ̃|C^
 */
//----------------------------------------------------------
SITUATION * SaveData_GetSituation(SAVEDATA * sv)
{
		SITUATION * st;
		st = SaveData_Get(sv, GMDATA_ID_SITUATION);
		return st;
}

FIELDOBJ_SAVE * SaveData_GetFieldObjSv(SAVEDATA * sv)
{
	FIELDOBJ_SAVE * fld;
	fld = SaveData_Get(sv, GMDATA_ID_FIELDOBJSV);
	return fld;
}

#if 0
FIELDOBJ_SAVE * SaveData_GetFieldObjSv2(SAVEDATA * sv)
{
	FIELDOBJ_SAVE * fld;
	fld = SaveData_Get(sv, GMDATA_ID_FIELDOBJSV2);
	return fld;
}
#endif

//----------------------------------------------------------
/**
 * @brief	tB[hOBJ̃Z[u
 * @param	fsys			Q[䃏[Nւ̃|C^
 */
//----------------------------------------------------------
void Field_SaveFieldObj(FIELDSYS_WORK * fsys)
{
	FIELD_OBJ_SAVE_DATA * fldobjsv;
	fldobjsv = ((FIELDOBJ_SAVE *)SaveData_GetFieldObjSv(fsys->savedata))->fldobj_sv;
	FieldOBJSys_DataSaveAll(fsys->fldobjsys, fldobjsv, FLDOBJ_ENTRY_MAX);
}

//----------------------------------------------------------
/**
 * @brief	tB[hOBJ̃[h
 * @param	fsys			Q[䃏[Nւ̃|C^
 */
//----------------------------------------------------------
void Field_LoadFieldObj(FIELDSYS_WORK * fsys)
{
	FIELD_OBJ_SAVE_DATA * fldobjsv;
	fldobjsv = ((FIELDOBJ_SAVE *)SaveData_GetFieldObjSv(fsys->savedata))->fldobj_sv;
	FieldOBJSys_DataLoadAll(fsys->fldobjsys, fldobjsv, FLDOBJ_ENTRY_MAX);
}

//============================================================================================
//
//	fobOp
//
//============================================================================================
