//============================================================================================
/**
 * @file	sway_grass_enc.c
 * @brief	hꑐGJEg
 * @author	saito GAME FREAK inc.
 * @date	2006.02.14
 */
//============================================================================================

#include "sway_grass_enc.h"
#include "field_effect.h"	//<<ꑐł܂ł̎b
#include "map_tool.h"

#include "location.h"		//ꂪȂsituation_local.hŃG[ɂȂ
#include "situation_local.h"

#include "fieldsys.h"	//for savedata

#include "bounding_box.h"

#include "battle/battle_common.h"	//for FIGHT_WIN, FIGHT_POKE_GET 

#define ISMIN(rc,a,b) { \
	(a<=b)? (rc=TRUE):(rc=FALSE); \
}

#define SEARCH_AROUND		(4)
#define SEARCH_WIDTH_MAX	(9)
#define SEARCH_OFFS			(SEARCH_WIDTH_MAX/2)
#define SERCH_NUM_ROUND1	(32)	//OO
#define SERCH_NUM_ROUND2	(24)	//
#define SERCH_NUM_ROUND3	(16)	//
#define SERCH_NUM_ROUND4	(8)		//O

typedef struct SWAY_GRASS_INFO_tag
{
	int GridX;
	int GridZ;
	int EncTblCode;	//GJEge[uR[h
	BOOL	SwayGrassFlg;
	BOOL	ChainFlg;	//AtO
	BOOL	IsRare;
	EOA_PTR	GrassAnime;
	VecFx32 GrassPos;
}SWAY_GRASS_INFO;

typedef struct SWAY_GRASS_tag{
	int EncTblCode;			//GJEge[uR[h
	int Chain;				//A
	int EncMonsNo;			//hꑐGJEgX^[io[
//	BOOL SwayGrassEnc;		//hꑐGJEgǂ
	u8 MonsTblNo;			//|PL̈(e[uԍ0`11)
	u8 RewritePos;			//`F[R[hʒu
	BOOL FirstEnc;			//hꑐGJEg
	BOOL SwayEncReturn;	//ꑐ퓬ƂĕA
	SWAY_GRASS_INFO GrassInfo[SEARCH_AROUND];
	BOUNDING_BOX	BoundingBox;
}SWAY_GRASS;

static void SetSwayGrassInfo(	FIELDSYS_WORK * fsys,
							const int inX, const int inZ,
							const u8 inSearchX, const u8 inSearchZ,
							const BOOL inChainFlg,
							const int inEncTblCode,
							SWAY_GRASS_INFO *outInfo	);
static BOOL CheckSwayGrass(	const SWAY_GRASS_PTR inSwayGrass,
							const int inX, const int inZ,
							u8 *outRound);
static void UpdateSwayGrassHist(FIELDSYS_WORK * fsys, const SWAY_GRASS_PTR inSwayGrass);
static u8 GetSwayGrassMinRecordPos(FIELDSYS_WORK * fsys);
static BOOL GetChainFlg(const u8 inRound, const int inBattleResult);
static BOOL SwayGrassSetupEvent(GMEVENT_CONTROL * event);

//-----------------------------------------------------------------------------
/**
 * @brief	mۊ֐
 * @param	inHeapID	q[vID
 * 
 * @retval	ptr			ꑐ\̂ւ̃|C^
 *
 */
//-----------------------------------------------------------------------------
SWAY_GRASS_PTR SwayGrass_AllocSwayGrass(const int inHeapID)
{
	SWAY_GRASS_PTR ptr;
	ptr = sys_AllocMemory(inHeapID, sizeof(SWAY_GRASS) );
	//oEfBO{bNX쐬(PObhAObhAsPObh)
	BB_MakeBoundingBox(FX32_ONE*16,FX32_ONE*8,FX32_ONE*16,&ptr->BoundingBox);
	return ptr;
}

//-----------------------------------------------------------------------------
/**
 * @brief	֐	(Q[n߂ɊmۂāÂ܂܂Ȃ̂ŉȂ)
 * @param	outSwayGrass		ꑐ\̂ւ̃|C^
 * 
 * @retval	
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_FeeSwayGrass(SWAY_GRASS_PTR outSwayGrass)
{
	sys_FreeMemoryEz(outSwayGrass);
}

//-----------------------------------------------------------------------------
/**
 * @brief	
 * @param	outSwayGrass		ꑐ\̂ւ̃|C^
 * 
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_InitSwayGrass(SWAY_GRASS_PTR outSwayGrass)
{
	u8 i;
	outSwayGrass->Chain = 0;
	outSwayGrass->EncTblCode = SWAY_GRASS_ENC_NORMAL;
	outSwayGrass->EncMonsNo = 0;
	//outSwayGrass->SwayGrassEnc = FALSE;
	outSwayGrass->MonsTblNo = 0;
	outSwayGrass->RewritePos = 0;
	outSwayGrass->FirstEnc = TRUE;
	outSwayGrass->SwayEncReturn = FALSE;
	
	MI_CpuClear8(&(outSwayGrass->GrassInfo[0]), sizeof(SWAY_GRASS_INFO)*SEARCH_AROUND);
	for(i=0;i<4;i++){
		outSwayGrass->GrassInfo[i].SwayGrassFlg = FALSE;
	}
/*	
#ifdef PM_DEBUG
	outSwayGrass->SwayEncReturn = TRUE;	//퓬ɂꑐ<<12/22p
#endif
*/	//<<del 060316
}

//-----------------------------------------------------------------------------
/**
 * @brief	hꑐ{
 * @param	fsys			tB[hVXe|C^
 * @param	inX				SXW
 * @param	inZ				SZW
 * @param	inBattleResult	퓬	 FIGHT_WIN	FIGHT_POKE_GET
 * @param	ioSwayGrass	hꑐ\̂ւ̃|C^
 * 
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_SearchSwayGrass(	FIELDSYS_WORK * fsys,
								const int inX, const int inZ,
								const int inBattleResult,
								SWAY_GRASS_PTR ioSwayGrass)
{
	u8 i;				//OJE^
	u8 size_x,size_z;	//OcTCY
	u8 num;				//ԍ
	u8 t_num;			//vZe|
	int x,z;			//W
	BOOL chain_flg;		//AtO

	u8	rand_list[4] = {	//_e[uieÕ_őlj
		SERCH_NUM_ROUND1,	//ԊO
		SERCH_NUM_ROUND2,
		SERCH_NUM_ROUND3,
		SERCH_NUM_ROUND4	//ԓ
	};

	
	for(i=0;i<SEARCH_AROUND;i++){
		//ΏۍW_Ō
		num = gf_rand()%rand_list[i];
		//OS_Printf("num%d\n",num);
		//ݒ
		size_x = SEARCH_WIDTH_MAX-(i*2);
		//cݒ
		size_z = SEARCH_WIDTH_MAX-(i*2);

		//肵ԍ𕝂Ŋ
		t_num = num/size_x;
		//0ȂOA1Ȃ牺
		//AɃqbgꍇA]łWi͏Łj
		if (t_num == 0){
			x = i+num%size_x;
			z = i;
		}else if(t_num == 1){
			x = i+num%size_x;
			z = i+size_z-1;
		}else{
			//	//qbgȂꍇA肵ԍ-*2
			t_num = num-(size_x*2);
			//Hԍ2Ŋ
			//+1zi͍AEȂ̂ŁAŔfj
			z = i+(t_num/2)+1;
			if (t_num%2 == 0){	//O
				x = i;
			}else{				//OE
				x = i+size_x-1;
			}
		}
		//A邩ǂ
		chain_flg = GetChainFlg(i,inBattleResult);	//Ƃ肠퓬ʂ͌Œ(ߊlƂ݂Ȃ)
		//OS_Printf("grass_anime%d,%d\n",x,z);		
		//肵W̏Zbg
		SetSwayGrassInfo(	fsys, inX, inZ, x, z,
							chain_flg, ioSwayGrass->EncTblCode,
							&ioSwayGrass->GrassInfo[i]);
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐAjZbg
 * @param	fsys		tB[hVXe|C^
 * @param	outSwayGrass		ꑐ\̂ւ̃|C^
 * 
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_SetSwayGrassAnime(FIELDSYS_WORK * fsys, SWAY_GRASS_PTR outSwayGrass)
{
	u8 i;
	for(i=0;i<4;i++){
		if (outSwayGrass->GrassInfo[i].SwayGrassFlg){
			int x = outSwayGrass->GrassInfo[i].GridX;
			int z = outSwayGrass->GrassInfo[i].GridZ;
			//AtOĂ邩ŃAj
			if (outSwayGrass->GrassInfo[i].IsRare){
				//A|PGJEgpAjZbg
				outSwayGrass->GrassInfo[i].GrassAnime = FE_EncGrass_Add( fsys, x, z );
			}else{
				//ZbgĂe[uR[hŃAj𕪊
				if (outSwayGrass->GrassInfo[i].EncTblCode == SWAY_GRASS_ENC_NORMAL){
					//ʏe[u
					outSwayGrass->GrassInfo[i].GrassAnime = FE_EncGrass_Add( fsys, x, z );
				}else{
					//hꑐpe[u
					outSwayGrass->GrassInfo[i].GrassAnime = FE_EncGrass_Add( fsys, x, z );
				}
			}
		}else{
			outSwayGrass->GrassInfo[i].GrassAnime = NULL;
		}
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐAjI҂
 * @param	ioSwayGrass		ꑐ\̂ւ̃|C^
 * 
 * @retval	BOOL	TRUE:AjI	FALSE:Ajp
 *
 */
//-----------------------------------------------------------------------------
BOOL SwayGrass_CheckSwayGrassAnimeEnd(SWAY_GRASS_PTR ioSwayGrass)
{
	u8 count;
	u8 i;
	count = 0;
	for(i=0;i<4;i++){
		if (ioSwayGrass->GrassInfo[i].GrassAnime != NULL){
			if (FE_EncGrass_AnimeCheck( ioSwayGrass->GrassInfo[i].GrassAnime )){
				EOA_Delete( ioSwayGrass->GrassInfo[i].GrassAnime );
				ioSwayGrass->GrassInfo[i].GrassAnime = NULL;
				count++;
			}
		}else{
			count++;
		}
	}
	if(count >= 4){
		return TRUE;
	}

	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐ`FbN
 * @param	fsys		tB[hVXe|C^
 * @param	ioSwayGrass		ꑐ\̂ւ̃|C^
 * @param	outUseEncTable	gpGJEge[uR[h
 * @param	outMonsDeside	GJEg|P肵Ă邩tO
 * 
 * @retval	BOOL	TRUE:hꑐGJEg@FALSE:hꑐGJEgs
 *
 */
//-----------------------------------------------------------------------------
BOOL SwayGrass_CheckSpEncount(	const int inX, const int inZ,
								FIELDSYS_WORK * fsys,
								SWAY_GRASS_PTR ioSwayGrass,
								int *outUseEncTable,
								BOOL *outMonsDeside )
{
	u8 round;
	BOOL chain_flg;
	int tbl_code;
	
	*outMonsDeside = FALSE;
	
	//ꑐGJEgǂ`FbN
	if ( !CheckSwayGrass(ioSwayGrass, inX, inZ, &round) ){
		//񂾍Whꑐł͂Ȃ
		return FALSE;//SWAY_GRASS_ENC_NO_ENC;
	}
	
	ioSwayGrass->SwayEncReturn = TRUE;	//퓬͂ꑐ
	//߂ăGJEg`FbN
	chain_flg = ioSwayGrass->GrassInfo[round].ChainFlg;
	tbl_code = ioSwayGrass->GrassInfo[round].EncTblCode;
	
	if(ioSwayGrass->FirstEnc == FALSE){ //߂Ăł͂Ȃ
		if(chain_flg){			//AȂA|P
			ioSwayGrass->Chain++;				//A+1
			//*outUseEncTable = ioSwayGrass->EncTblCode;//ۑƂR[h
			*outUseEncTable = tbl_code;	//SwayGrass̃o璼Ɏ邱Ƃ\ǂAInfo
			*outMonsDeside = TRUE;
			//hꑐGJEg`FbNƍXV
			UpdateSwayGrassHist(fsys, ioSwayGrass);
			//ioSwayGrass->SwayGrassEnc = TRUE;	//hꑐGJEgtOI
			return TRUE;//SWAY_GRASS_ENC_KEEP_MONSTER;
		}else{		//Ⴄ|P
			*outUseEncTable = tbl_code;	//GJEge[uR[hZbg
			//AI
			ioSwayGrass->Chain = 0;
			//ΏۂƂȂhꑐGJEg擾
			//(3̗̒ňԘAȂR[h̏ꏊ擾)
			//(Ƃ肠퓬OɎ擾Ă܂)
			ioSwayGrass->RewritePos = GetSwayGrassMinRecordPos(fsys);
		}
	}else{	//߂ėhꑐ	(m͎b)<<|PT[`[ł܂ł̎b菈
/**
		if(gf_rand()%100 < 50){	//m[}
			*outUseEncTable = SWAY_GRASS_ENC_NORMAL;
		}else{		//e[uύX
			*outUseEncTable = SWAY_GRASS_ENC_SP;
		}
*/
		*outUseEncTable = tbl_code;
		ioSwayGrass->FirstEnc = FALSE;
		//ΏۂƂȂhꑐGJEg擾
		//(3̗̒ňԘAȂR[h̏ꏊ擾)
		//(Ƃ肠퓬OɎ擾Ă܂)
		ioSwayGrass->RewritePos = GetSwayGrassMinRecordPos(fsys);
	}
	
	//ǂ̃e[uKpۑ
	ioSwayGrass->EncTblCode = *outUseEncTable;

	//ioSwayGrass->SwayGrassEnc = TRUE;	//hꑐGJEgtOI
	
	return TRUE;//SWAY_GRASS_ENC_START;
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐGJEg|PL
 * @param	outSwayGrass		ꑐ\̂ւ̃|C^
 * @param	inMonsNo			GJEgX^[io[
 *
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_SetEncMonsNo(SWAY_GRASS_PTR outSwayGrass, const int inMonsNo)
{
	outSwayGrass->EncMonsNo = inMonsNo;
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐGJEge[uio[擾
 * @param	inSwayGrass		ꑐ\̂ւ̃|C^
 *
 * @retval	u8				GJEge[uio[
 *
 */
//-----------------------------------------------------------------------------
const u8 SwayGrass_GetMonsTblNo( SWAY_GRASS_PTR inSwayGrass )
{
	return inSwayGrass->MonsTblNo;
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐGJEge[uio[Zbg
 * @param	outSwayGrass		ꑐ\̂ւ̃|C^
 * @param	inMonsTblNo			GJEge[uio[
 * @retval	none				
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_SetMonsTblNo( SWAY_GRASS_PTR outSwayGrass, const u8 inMonsTblNo )
{
	outSwayGrass->MonsTblNo = inMonsTblNo;
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐGJEgA𒲂ׂ
 * @param	inSwayGrass		ꑐ\̂ւ̃|C^
 * @retval	BOOL		TRUE:hꑐGJEgA		FALSE:ʏGJEgA				
 *
 */
//-----------------------------------------------------------------------------
const BOOL SwayGrass_IsSwayEncRetern(const SWAY_GRASS_PTR inSwayGrass)
{
	return inSwayGrass->SwayEncReturn;
}

//-----------------------------------------------------------------------------
/**
 * @brief	ʓO`FbN
 * @param	fsys			tB[hVXe|C^
 * @param	inX				SXW
 * @param	inZ				SZW
 * @param	inSearchX		XWi΁j
 * @param	inSearchZ		ZWi΁j
 * @param	inChainFlg		AtO
 * @param	inEncTblCode	݂̃GJEge[uR[h
 * @param	outInfo			ꑐ\̂ւ̃|C^
 * 
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_CheckIO(FIELDSYS_WORK * fsys)
{
	BOOL rc;
	SWAY_GRASS_INFO *info;
	
	int i;
	//ʓO`FbN
	for(i=0;i<SEARCH_AROUND;i++){
		info = &(fsys->SwayGrass->GrassInfo[i]);
		rc = BB_CullingCheck3DModelNonResQuick( &(info->GrassPos),
											 &(fsys->SwayGrass->BoundingBox) );
		if ((info->SwayGrassFlg)&&(!rc)){
			//ɂ
			info->SwayGrassFlg = FALSE;
		}
	}
	//S`FbN
	{
		int count;
		count = 0;
		for(i=0;i<SEARCH_AROUND;i++){
			info = &(fsys->SwayGrass->GrassInfo[i]);
			if (info->SwayGrassFlg == FALSE){
				count++;
			}
		}
		if (count == 4){
			///OS_Printf("hꑐ͖ɂȂ܂\n");
		}
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐZbg
 * @param	fsys			tB[hVXe|C^
 * @param	inX				SXW
 * @param	inZ				SZW
 * @param	inSearchX		XWi΁j
 * @param	inSearchZ		ZWi΁j
 * @param	inChainFlg		AtO
 * @param	inEncTblCode	݂̃GJEge[uR[h
 * @param	outInfo			ꑐ\̂ւ̃|C^
 * 
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
static void SetSwayGrassInfo(	FIELDSYS_WORK * fsys,
								const int inX, const int inZ,
								const u8 inSearchX, const u8 inSearchZ,
								const BOOL inChainFlg,
								const int inEncTblCode,
								SWAY_GRASS_INFO *outInfo	)
{
	int x,z;
	MATR attr;
	x = (inX-SEARCH_OFFS)+inSearchX;
	z = (inZ-SEARCH_OFFS)+inSearchZ;
	//Wۑ
	outInfo->GridX = x;
	outInfo->GridZ = z;
	//Agr[g{
	attr = GetAttributeLSB(fsys, x, z);
	
	if (  MATR_IsGrass(attr) ){
		HEIGHT_TYPE code;
		//fx32^̍W擾
		outInfo->GrassPos.x = FX32_ONE*16*x;
		outInfo->GrassPos.z = FX32_ONE*16*z;
		outInfo->GrassPos.y = GetHeightPack(fsys,
											0, outInfo->GrassPos.x, outInfo->GrassPos.z,
											&code);
		//擾āA@̍Ɣr\

		//ȂꑐtO𗧂Ă
		outInfo->SwayGrassFlg = 1;
		outInfo->ChainFlg = inChainFlg;	//AtOZbg
		//GJEge[uZbg
		if (!inChainFlg){
			//AȂ̂Ńe[u̒I(m1/2)
			if(gf_rand()%100 < 50){	//m[}
				outInfo->EncTblCode = SWAY_GRASS_ENC_NORMAL;
			}else{		//e[uύX
				outInfo->EncTblCode = SWAY_GRASS_ENC_SP;
			}
		}else{
			//Aꍇ͑Õe[up
			outInfo->EncTblCode = inEncTblCode;
		}

		//ŁAA|PIs\
		outInfo->IsRare = FALSE;
	}else{
		//ł͂Ȃ̂ŃtOIt
		outInfo->SwayGrassFlg = 0;
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐ`FbN
 * @param	inSwayGrass	hꑐ\̂ւ̃|C^
 * @param	inX			XW
 * @param	inZ			ZW
 * @param	outRound	qbg
 *
 * @retval	BOOL	TRUE:hꑐqbg		FALSE:hꑐqbgĂȂ
 *
 */
//-----------------------------------------------------------------------------
static BOOL CheckSwayGrass(	const SWAY_GRASS_PTR inSwayGrass,
							const int inX, const int inZ,
							u8 *outRound)
{
	u8 i;
	for(i=0;i<4;i++){
		if (inSwayGrass->GrassInfo[i].SwayGrassFlg){
			if ( (inSwayGrass->GrassInfo[i].GridX == inX) &&
					(inSwayGrass->GrassInfo[i].GridZ == inZ) ){
				*outRound = i;
				return TRUE;
			}
		}
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐ`FbNƍXV
 * @param	fsys		tB[hVXe|C^	
 * @param	inSwayGrass	ꑐ\̂ւ̃|C^	
 *
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
static void UpdateSwayGrassHist(FIELDSYS_WORK * fsys, const SWAY_GRASS_PTR inSwayGrass)
{
	SWAY_GRASS_HIST * hist;
	SITUATION *st;
	int chain;
	st = SaveData_GetSituation(fsys->savedata);
	hist = Situation_GetSwayGrassHist(st);
	chain = hist->SwayGrassRec[inSwayGrass->RewritePos].Chain;
	if (chain <= inSwayGrass->Chain){//L^H
		//XV
		hist->SwayGrassRec[inSwayGrass->RewritePos].Chain = inSwayGrass->Chain;
		hist->SwayGrassRec[inSwayGrass->RewritePos].MonsNo = inSwayGrass->EncMonsNo;
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	hꑐR[h̏ʒu擾
 *
 * @param	fsys	tB[hVXe|C^	
 *
 * @retval	u8		ʒu
 *
 */
//-----------------------------------------------------------------------------
static u8 GetSwayGrassMinRecordPos(FIELDSYS_WORK *fsys)
{
	SWAY_GRASS_HIST * hist;
	SITUATION *st;
	u8 pos;
	BOOL rc;
	
	st = SaveData_GetSituation(fsys->savedata);
	hist = Situation_GetSwayGrassHist(st);
	ISMIN(rc,hist->SwayGrassRec[0].Chain,hist->SwayGrassRec[1].Chain);
	if (rc){
		pos = 0;
	}else{
		pos = 1;
	}
	ISMIN(rc,hist->SwayGrassRec[pos].Chain,hist->SwayGrassRec[2].Chain);
	if (!rc){
		pos = 2;
	}

	return pos;
}

//-----------------------------------------------------------------------------
/**
 * @brief	AtǑ
 *
 * @param	inRound			O
 * @param	inBattleResult	퓬 FIGHT_WIN	FIGHT_POKE_GET
 * 
 * @retval	BOOL		AtO	TURE:A	FALSE:AȂ	
 *
 */
//-----------------------------------------------------------------------------
static BOOL GetChainFlg(const u8 inRound, const int inBattleResult)
{
	//|PomŌ߂
	u8 *tbl;
	u8 table1[4] = {80,60,40,20};
	u8 table2[4] = {90,70,50,30};
	//OAߊlĐ퓬IŃe[uύX
	if (inBattleResult == FIGHT_WIN){
		tbl = table1;
	}else if(inBattleResult == FIGHT_POKE_GET){
		tbl = table2;
	}
	if(gf_rand()%100<tbl[inRound]){			//A
		return TRUE;
	}else{		//AȂ
		return FALSE;
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	hꑐN
 *
 * @param	*fsys		tB[hVXe|C^
 * 
 * @retval	none	
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_Setup(FIELDSYS_WORK * fsys)
{
	int *seq;
	seq = sys_AllocMemoryLo(HEAPID_FIELD,sizeof(int));
	(*seq) = 0;
	//CxgZbg
	FieldEvent_Set(fsys, SwayGrassSetupEvent, seq);
}

//-----------------------------------------------------------------------------
/**
 * @brief	hꑐZbgCxg
 * 
 * @param	*event		Cxg|C^
 * 
 * @retval	BOOL	TRUE:I	FALSE:p
 *
 */
//-----------------------------------------------------------------------------
static BOOL SwayGrassSetupEvent(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	int *seq = FieldEvent_GetSpecialWork(event);
	OS_Printf("seq:%d\n",(*seq));
	
	switch (*seq) {
	case 0:
		{
			int x,z;
			//@̈ʒu擾
			x = Player_NowGPosXGet(fsys->player);
			z = Player_NowGPosZGet(fsys->player);
			//T[`
			SwayGrass_SearchSwayGrass(fsys, x, z, FIGHT_WIN, fsys->SwayGrass);	//Ƃ肠e[u͐퓬ŌŒ
			//AjZbg
			SwayGrass_SetSwayGrassAnime(fsys, fsys->SwayGrass);
		}
		(*seq)++;
		break;
	case 1:
		//AjI҂
		if (SwayGrass_CheckSwayGrassAnimeEnd(fsys->SwayGrass)){
			(*seq)++;
		}
		break;
	case 2:
		//I
		sys_FreeMemoryEz(seq);
		return TRUE;
		break;
	}
	return FALSE;
}
