//============================================================================================
/**
 * @file	sysflag.c
 * @bfief	vOAXNvgANZXVXetO
 * @author	Satoshi Nohara
 * @date	06.03.12
 */
//============================================================================================
#include "common.h"
#include "fieldsys.h"
#include "script.h"
#include "field/eventflag.h"
#include "field/evwkdef.h"
#include "field/sysflag.h"


//============================================================================================
//
//	vg^Cv錾
//
//============================================================================================
static void SysFlag_Set( FIELDSYS_WORK* fsys, u16 flag );
static void SysFlag_Reset( FIELDSYS_WORK* fsys, u16 flag );
static BOOL SysFlag_Check( FIELDSYS_WORK* fsys, u16 flag );
void SysFlag_BagSet( FIELDSYS_WORK* fsys );
BOOL SysFlag_BagCheck( FIELDSYS_WORK* fsys );
void SysFlag_PairSet( FIELDSYS_WORK* fsys );
BOOL SysFlag_PairCheck( FIELDSYS_WORK* fsys );


//============================================================================================
//
//	֐
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * VXetOZbg
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 * @param	flag		tOio[
 *
 * @retval	none
 *
 * VXetÓAXNvg̃Z[utOgpĂ
 */
//--------------------------------------------------------------------------------------------
static void SysFlag_Set( FIELDSYS_WORK* fsys, u16 flag )
{
	SetEventFlag( fsys, flag );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * VXetOZbg
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 * @param	flag		tOio[
 *
 * @retval	none
 *
 * VXetÓAXNvg̃Z[utOgpĂ
 */
//--------------------------------------------------------------------------------------------
static void SysFlag_Reset( FIELDSYS_WORK* fsys, u16 flag )
{
	ResetEventFlag( fsys, flag );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * VXetO`FbN
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 * @param	flag		tOio[
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 *
 * VXetÓAXNvg̃Z[utOgpĂ
 */
//--------------------------------------------------------------------------------------------
static BOOL SysFlag_Check( FIELDSYS_WORK* fsys, u16 flag )
{
	return CheckEventFlag( fsys, flag );
}


//============================================================================================
//
//	obO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * obOtÕZbg
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_BagSet( FIELDSYS_WORK* fsys )
{
	SysFlag_Set( fsys, SYS_FLAG_BAG_GET );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * obOtÕ`FbN
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_BagCheck( FIELDSYS_WORK* fsys )
{
	return SysFlag_Check( fsys, SYS_FLAG_BAG_GET );
}


//============================================================================================
//
//	AtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * AtÕZbg
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_PairSet( FIELDSYS_WORK* fsys )
{
	SysFlag_Set( fsys, SYS_FLAG_PAIR );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * AtÕZbg
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_PairReset( FIELDSYS_WORK* fsys )
{
	SysFlag_Reset( fsys, SYS_FLAG_PAIR );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * AtÕ`FbN
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_PairCheck( FIELDSYS_WORK* fsys )
{
	return SysFlag_Check( fsys, SYS_FLAG_PAIR );
}

