//============================================================================================
/**
 * @file	syswork.c
 * @bfief	vOAXNvgANZXVXe[N
 * @author	Satoshi Nohara
 * @date	06.03.12
 */
//============================================================================================
#include "common.h"
#include "fieldsys.h"
#include "script.h"
#include "field/eventflag.h"
#include "field/evwkdef.h"
#include "field/syswork.h"
#include "poketool/monsno.h"		//|Pio[


//============================================================================================
//
//	vg^Cv錾
//
//============================================================================================
static BOOL SysWork_Set( FIELDSYS_WORK* fsys, u16 work, u16 no );
static u16 SysWork_Get( FIELDSYS_WORK* fsys, u16 work );
BOOL SysWork_FirstPokeNoSet( FIELDSYS_WORK* fsys, u16 no );
u16 SysWork_FirstPokeNoGet( FIELDSYS_WORK* fsys );
u16 SysWork_RivalPokeNoGet( FIELDSYS_WORK* fsys );
BOOL SysWork_ContestAdrsSet( FIELDSYS_WORK* fsys, void* pwork );
void* SysWork_ContestAdrsGet( FIELDSYS_WORK* fsys );


//============================================================================================
//
//	֐
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * VXe[NZbg
 *
 * @param	fsys		FIELDSYS_WORKւ̃|C^
 * @param	work		[Nio[
 * @param	no			Zbgl
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
static BOOL SysWork_Set( FIELDSYS_WORK* fsys, u16 work, u16 no )
{
	return SetEventWorkValue( fsys, work, no );
}

//--------------------------------------------------------------------------------------------
/**
 * VXe[NQbg
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 * @param	work		[Nio[
 *
 * @return	"[N̒l"
 */
//--------------------------------------------------------------------------------------------
static u16 SysWork_Get( FIELDSYS_WORK* fsys, u16 work )
{
	return GetEventWorkValue( fsys, work );
}


//============================================================================================
//
//	ŏ̃|Pio[֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ŏ̃|Pio[Zbg
 *
 * @param	fsys		FIELDSYS_WORKւ̃|C^
 * @param	no			|Pio[
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_FirstPokeNoSet( FIELDSYS_WORK* fsys, u16 no )
{
	return SysWork_Set( fsys, SYS_WORK_FIRST_POKE_NO, no );
}

//--------------------------------------------------------------------------------------------
/**
 * ŏ̃|Pio[Qbg
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 *
 * @return	"ŏ̃|Pio["
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_FirstPokeNoGet( FIELDSYS_WORK* fsys )
{
	return SysWork_Get( fsys, SYS_WORK_FIRST_POKE_NO );
}

//--------------------------------------------------------------------------------------------
/**
 * Cõ|Pio[Qbg
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 *
 * @return	"Cõ|Pio["
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_RivalPokeNoGet( FIELDSYS_WORK* fsys )
{
	u16 rival;
	u16 first = SysWork_Get( fsys, SYS_WORK_FIRST_POKE_NO );

#if 1
	if( first == MONSNO_NAETORU ){
		rival = MONSNO_HIKOZARU;
	}else if( first == MONSNO_HIKOZARU ){
		rival = MONSNO_POTTYAMA;
	}else{
		rival = MONSNO_NAETORU;
	}
#endif

	return rival;
}


//============================================================================================
//
//	ReXg֘A(őΉlBBB)
//
//	ReXǵAt}bvAI[vjO}bv֐؂ւ̂ŁA
//	XNvgIƁAReXgVXẽ|C^ێłȂ̂ŁA
//	Z[u[NɕۑĂ(b)
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ReXgVXe[Nւ̃|C^Zbg
 *
 * @param	fsys		FIELDSYS_WORKւ̃|C^
 * @param	pwork		ReXgVXe[Nւ̃|C^
 *
 * @return	"TRUE"
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_ContestAdrsSet( FIELDSYS_WORK* fsys, void* pwork )
{
	u16 lo,hi;
	u32* adrs;

	adrs = (u32*)pwork;

	lo = (u16)( ((u32)adrs) & 0xffff );
	hi = (u16)( ((u32)adrs) >> 16 );

	//OS_Printf( "lo = %d\n", lo );
	//OS_Printf( "hi = %d\n", hi );

	//ReXgVXe[Ñ|C^ۑ
	SysWork_Set( fsys, SYS_WORK_CONTEST_LO, lo  );
	SysWork_Set( fsys, SYS_WORK_CONTEST_HI, hi  );

	return TRUE;
}

//--------------------------------------------------------------------------------------------
/**
 * ReXgVXe[Nւ̃|C^擾
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 *
 * @return	"ŏ̃|Pio["
 */
//--------------------------------------------------------------------------------------------
void* SysWork_ContestAdrsGet( FIELDSYS_WORK* fsys )
{
	u16 lo = SysWork_Get( fsys, SYS_WORK_CONTEST_LO );
	u16 hi = SysWork_Get( fsys, SYS_WORK_CONTEST_HI );

	//OS_Printf( "lo = %d\n", lo );
	//OS_Printf( "hi = %d\n", hi );

	return (void*)( ((hi) << 16) | (lo) );
}


